﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <nn/os.h>
#include <nn/nn_Abort.h>
#include <nn/nn_SdkLog.h>

extern "C" {

#include <sys/types.h>
#include <sys/param.h>
#include <sys/systm.h>
#include <netinet/in.h>

char* inet_ntoa(struct in_addr ina)
{
        static char buf[4 * sizeof "123"];
        unsigned char *ucp = (unsigned char *)&ina;
        sprintf(buf, "%d.%d.%d.%d",
                ucp[0] & 0xff,
                ucp[1] & 0xff,
                ucp[2] & 0xff,
                ucp[3] & 0xff);
        return buf;
}

char* inet_ntoa_r(struct in_addr ina, char *buf)
{
        unsigned char *ucp = (unsigned char *)&ina;
        sprintf(buf, "%d.%d.%d.%d",
                ucp[0] & 0xff,
                ucp[1] & 0xff,
                ucp[2] & 0xff,
                ucp[3] & 0xff);
        return buf;
}

}

