﻿
/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef _SYS_BSDTYPES_H_
#define _SYS_BSDTYPES_H_

#include      <stdint.h>
#include      <stdarg.h>
#include      <sys/cdefs.h>
#include_next <sys/types.h>

#if defined(NN_BUILD_CONFIG_COMPILER_CLANG)
typedef uint16_t        u_short;
typedef uint32_t        u_int;
#endif

#if defined(NN_BUILD_CONFIG_COMPILER_GCC)
typedef int64_t         quad_t;
typedef uint64_t        u_quad_t;
typedef uint32_t        blksize_t;
#endif

typedef uint64_t        u_int64_t;
typedef uint32_t        u_int32_t;
typedef uint16_t        u_int16_t;
typedef uint8_t         u_int8_t;
typedef int64_t         sbintime_t;
typedef char *          caddr_t;
typedef const char *    c_caddr_t;
typedef ssize_t         register_t;
typedef size_t          u_register_t;
typedef uintptr_t       vm_offset_t;
typedef size_t          vm_size_t;
typedef int64_t         vm_ooffset_t;
typedef uint32_t        vm_paddr_t;
typedef __builtin_va_list __va_list;
typedef uint32_t        __fixpt_t;
typedef uint64_t        rlim_t;

#if !defined(__cplusplus)
typedef int             bool;
#endif

#ifndef false
#define false           0
#endif

#ifndef true
#define true            1
#endif

#endif
