﻿/*-
 * Copyright (c) 2002 Ian Dowse.  All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *
 * THIS SOFTWARE IS PROVIDED BY THE AUTHOR AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE AUTHOR OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 * $FreeBSD$
 */

#ifndef _SYS_SYSCALLSUBR_H_
#define _SYS_SYSCALLSUBR_H_

#include <sys/signal.h>
#include <sys/uio.h>
#include <sys/socket.h>
#include <sys/mac.h>

struct file;
struct msghdr;
struct sockaddr;

int kern_accept4(struct thread *td, int s, struct sockaddr **name,
        socklen_t *namelen, int flags, struct file **fp);
int kern_bind(struct thread *td, int fd, struct sockaddr *sa);
int kern_close(struct thread *td, int fd);
int kern_connect(struct thread *td, int fd, struct sockaddr *sa);
int kern_getpeername(struct thread *td, int fd, struct sockaddr **sa,
        socklen_t *alen);
int kern_getsockname(struct thread *td, int fd, struct sockaddr **sa,
        socklen_t *alen);
int kern_getsockopt(struct thread *td, int s, int level, int name,
        void *optval, enum uio_seg valseg, socklen_t *valsize);
int kern_sendit(struct thread *td, int s, struct msghdr *mp, int flags,
        struct mbuf *control, enum uio_seg segflg);
int kern_setsockopt(struct thread *td, int s, int level, int name,
        void *optval, enum uio_seg valseg, socklen_t valsize);
int kern_writev(struct thread *td, int fd, struct uio *auio);
int kern_readv(struct thread *td, int fd, struct uio *auio);
int kern_select(struct thread *td, int nd, fd_set *fd_in, fd_set *fd_ou,
        fd_set *fd_ex, struct timeval *tvp, int abi_nfdbits);
int kern_poll(struct thread *td, struct pollfd *fds, u_int nfds,
        struct timespec *tsp, sigset_t *uset);
int kern_ioctl(struct thread *td, int fd, u_long com, caddr_t data);

#endif /* !_SYS_SYSCALLSUBR_H_ */
