﻿/*-
 * Copyright (c) 1990, 1993
 *    The Regents of the University of California.  All rights reserved.
 * Copyright (c) 2000
 *    Poul-Henning Kamp.  All rights reserved.
 * (c) UNIX System Laboratories, Inc.
 * All or some portions of this file are derived from material licensed
 * to the University of California by American Telephone and Telegraph
 * Co. or Unix System Laboratories, Inc. and are reproduced herein with
 * the permission of UNIX System Laboratories, Inc.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions
 * are met:
 * 1. Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 * 2. Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 * 4. Neither the name of the University nor the names of its contributors
 *    may be used to endorse or promote products derived from this software
 *    without specific prior written permission.
 *
 * THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
 * ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
 * IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
 * ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
 * FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
 * DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
 * OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
 * HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
 * LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
 * OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
 * SUCH DAMAGE.
 *
 *    @(#)conf.h    8.5 (Berkeley) 1/9/95
 * $FreeBSD$
 */

#ifndef _SYS_CONF_H_
#define    _SYS_CONF_H_

#include <sys/queue.h>
struct cdevsw;
struct file;

struct cdev {
    void               *si_spare0;
    u_int               si_flags;
#define SI_ETERNAL      0x0001    /* never destroyed */
#define SI_ALIAS        0x0002    /* carrier of alias name */
#define SI_NAMED        0x0004    /* make_dev{_alias} has been called */
#define SI_CHEAPCLONE   0x0008    /* can be removed_dev'ed when vnode reclaims */
#define SI_CHILD        0x0010    /* child of another struct cdev **/
#define SI_DUMPDEV      0x0080    /* is kernel dumpdev */
#define SI_CLONELIST    0x0200    /* on a clone list */
#define SI_UNMAPPED     0x0400    /* can handle unmapped I/O */
#define SI_NOSPLIT      0x0800    /* I/O should not be split up */
    uid_t               si_devuid;
    gid_t               si_devgid;
    mode_t              si_mode;
    int                 si_drv0;
    LIST_ENTRY(cdev)    si_list;
    struct cdevsw      *si_devsw;
    char                si_name[SPECNAMELEN + 1];
};

struct thread;
struct uio;
struct knote;

typedef int d_open_t(struct cdev *dev, int oflags, int devtype, struct thread *td);
typedef int d_close_t(struct cdev *dev, int fflag, int devtype, struct thread *td);
typedef int d_ioctl_t(struct cdev *dev, u_long cmd, caddr_t data,
              int fflag, struct thread *td);
typedef int d_read_t(struct cdev *dev, struct uio *uio, int ioflag);
typedef int d_write_t(struct cdev *dev, struct uio *uio, int ioflag);
typedef int d_poll_t(struct cdev *dev, int events, struct thread *td);
typedef int d_kqfilter_t(struct cdev *dev, struct knote *kn);

#define D_VERSION_03    0x17122009    /* d_mmap takes memattr,vm_ooffset_t */
#define D_VERSION       D_VERSION_03

/*
 * Character device switch table
 */
struct cdevsw {
    int                 d_version;
    u_int               d_flags;
    const char         *d_name;
    d_open_t           *d_open;
    d_close_t          *d_close;
    d_read_t           *d_read;
    d_write_t          *d_write;
    d_ioctl_t          *d_ioctl;
    d_poll_t           *d_poll;
    d_kqfilter_t       *d_kqfilter;
};

struct cdev *make_dev(
        struct cdevsw *_devsw, int _unit, uid_t _uid, gid_t _gid,
        int _perms, const char *_fmt, ...) __printflike(6, 7);
struct cdev *make_dev_alias(
        struct cdev *_pdev, const char *_fmt, ...)
        __printflike(2, 3);
typedef    void (*cdevpriv_dtr_t)(void *data);
int    devfs_get_cdevpriv(void **datap);
int    devfs_set_cdevpriv(void *priv, cdevpriv_dtr_t dtr);

#define UID_ROOT        0
#define GID_WHEEL       0

#endif /* !_SYS_CONF_H_ */
