﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <new>
#include <nn/fs.h>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/ro.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <nn/os/os_SdkMemoryAllocatorForThreadLocal.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include "ntd-test-tls.h"

typedef struct ___oasis_nnmusl_dso_modules_
{
    int version;                    // This is our version number to specify how we are encoding this data.
                                    // Debugger will check this and bail if an unknown version is detected.
                                    // For example, Rynda 1.5.X has a new fancy TLS system and no longer uses the DTV, version is incremented,
                                    // and the debugger no longer attempts to locate NRO TLS variables.
    int nModules;                   // This will be used to know how many modules are listed in the table.
                                    // E.g. if the table includes [MainMod, NRO1, NRO2] then nModules = 3.
    int nElements;                  // This will be used to know how big modAddresses.  Note that modAddresses[0] holds the index of the last NSO.
                                    // modAddresses[1] will hold the first module, the app.
    size_t reserved1;               // Reserved for future use. Maybe a pointer to another structure...
    size_t reserved2;               // Reserved for future use. Maybe a pointer to another structure...
    size_t modAddresses[];          // This is the current array structure that contains each modules load address (and it matches the DTV index).
} ___oasis_nnmusl_dso_modules_;

extern ___oasis_nnmusl_dso_modules_ *__oasis_nnmusl_dso_modules;

typedef void* (*NroEntryPoint)(void);
extern "C" void *CallNro1(void);
extern "C" void *CallNro2(void);
extern "C" void *CallNro3(void);
extern "C" void *CallNro4(void);
extern "C" void *CallNro5(void);
extern "C" void *CallNro6(void);
extern "C" void *CallNro7(void);
extern "C" void *CallNro8(void);
extern "C" void *CallNro9(void);
extern "C" void *CallNro10(void);
extern "C" void *CallNro11(void);
extern "C" void *CallNro12(void);
extern "C" void *CallNro13(void);
extern "C" void *CallNro14(void);
extern "C" void *CallNro15(void);
extern "C" void *CallNro16(void);
extern "C" void *CallNro17(void);
extern "C" void *CallNro18(void);
extern "C" void *CallNro19(void);
extern "C" void *CallNro20(void);
extern "C" void *CallNro21(void);
extern "C" void *CallNro22(void);
extern "C" void *CallNro23(void);
extern "C" void *CallNro24(void);
extern "C" void *CallNro25(void);
extern "C" void *CallNro26(void);
extern "C" void *CallNro27(void);
extern "C" void *CallNro28(void);
extern "C" void *CallNro29(void);
extern "C" void *CallNro30(void);
extern "C" void *CallNro31(void);
extern "C" void *CallNro32(void);
extern "C" void *CallNro33(void);
extern "C" void *CallNro34(void);
extern "C" void *CallNro35(void);
extern "C" void *CallNro36(void);
extern "C" void *CallNro37(void);
extern "C" void *CallNro38(void);
extern "C" void *CallNro39(void);
extern "C" void *CallNro40(void);

extern "C" void *__get_tp(void);

extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define MIN_ALIGN nn::os::ThreadStackAlignment

#define STACK_SIZE (3 * MIN_ALIGN)
#define NUM_THREADS 40

const size_t            ThreadStackSize = STACK_SIZE;                 // スレッド操作スレッドのスタックサイズ
typedef struct thread_stack {
    NN_OS_ALIGNAS_THREAD_STACK char  stack[ ThreadStackSize ];   // 1つ目のスレッドのスタック
} thread_stack;
thread_stack            g_ThreadStack[NUM_THREADS];

nn::os::ThreadType      g_Thread[NUM_THREADS];

typedef void (*ThreadFuncPtr)(void *);
static void TestThread1(void *arg);
static void TestThread2(void *arg);
static void TestThread3(void *arg);
static void TestThread4(void *arg);
static void TestThread5(void *arg);
static void TestThread6(void *arg);
static void TestThread7(void *arg);
static void TestThread8(void *arg);
static void TestThread9(void *arg);
static void TestThread10(void *arg);
static void TestThread11(void *arg);
static void TestThread12(void *arg);
static void TestThread13(void *arg);
static void TestThread14(void *arg);
static void TestThread15(void *arg);
static void TestThread16(void *arg);
static void TestThread17(void *arg);
static void TestThread18(void *arg);
static void TestThread19(void *arg);
static void TestThread20(void *arg);
static void TestThread21(void *arg);
static void TestThread22(void *arg);
static void TestThread23(void *arg);
static void TestThread24(void *arg);
static void TestThread25(void *arg);
static void TestThread26(void *arg);
static void TestThread27(void *arg);
static void TestThread28(void *arg);
static void TestThread29(void *arg);
static void TestThread30(void *arg);
static void TestThread31(void *arg);
static void TestThread32(void *arg);
static void TestThread33(void *arg);
static void TestThread34(void *arg);
static void TestThread35(void *arg);
static void TestThread36(void *arg);
static void TestThread37(void *arg);
static void TestThread38(void *arg);
static void TestThread39(void *arg);
static void TestThread40(void *arg);

static ThreadFuncPtr TestThread[NUM_THREADS] = {
    TestThread1,
    TestThread2,
    TestThread3,
    TestThread4,
    TestThread5,
    TestThread6,
    TestThread7,
    TestThread8,
    TestThread9,
    TestThread10,
    TestThread11,
    TestThread12,
    TestThread13,
    TestThread14,
    TestThread15,
    TestThread16,
    TestThread17,
    TestThread18,
    TestThread19,
    TestThread20,
    TestThread21,
    TestThread22,
    TestThread23,
    TestThread24,
    TestThread25,
    TestThread26,
    TestThread27,
    TestThread28,
    TestThread29,
    TestThread30,
    TestThread31,
    TestThread32,
    TestThread33,
    TestThread34,
    TestThread35,
    TestThread36,
    TestThread37,
    TestThread38,
    TestThread39,
    TestThread40
};

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_TEST_NAME)
#if ULONG_MAX == 0xffffffff
#define TPOFF_K 8
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TPOFF_K 16
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif
#define NRR_NAME "rom:/.nrr/" TEST_ROOT_NAME ".nrr"

#define NRO1_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO1_NAME) ".nro"
#define NRO2_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO2_NAME) ".nro"
#define NRO3_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO3_NAME) ".nro"
#define NRO4_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO4_NAME) ".nro"
#define NRO5_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO5_NAME) ".nro"
#define NRO6_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO6_NAME) ".nro"
#define NRO7_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO7_NAME) ".nro"
#define NRO8_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO8_NAME) ".nro"
#define NRO9_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO9_NAME) ".nro"
#define NRO10_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO10_NAME) ".nro"
#define NRO11_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO11_NAME) ".nro"
#define NRO12_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO12_NAME) ".nro"
#define NRO13_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO13_NAME) ".nro"
#define NRO14_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO14_NAME) ".nro"
#define NRO15_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO15_NAME) ".nro"
#define NRO16_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO16_NAME) ".nro"
#define NRO17_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO17_NAME) ".nro"
#define NRO18_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO18_NAME) ".nro"
#define NRO19_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO19_NAME) ".nro"
#define NRO20_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO20_NAME) ".nro"
#define NRO21_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO21_NAME) ".nro"
#define NRO22_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO22_NAME) ".nro"
#define NRO23_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO23_NAME) ".nro"
#define NRO24_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO24_NAME) ".nro"
#define NRO25_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO25_NAME) ".nro"
#define NRO26_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO26_NAME) ".nro"
#define NRO27_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO27_NAME) ".nro"
#define NRO28_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO28_NAME) ".nro"
#define NRO29_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO29_NAME) ".nro"
#define NRO30_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO30_NAME) ".nro"
#define NRO31_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO31_NAME) ".nro"
#define NRO32_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO32_NAME) ".nro"
#define NRO33_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO33_NAME) ".nro"
#define NRO34_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO34_NAME) ".nro"
#define NRO35_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO35_NAME) ".nro"
#define NRO36_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO36_NAME) ".nro"
#define NRO37_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO37_NAME) ".nro"
#define NRO38_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO38_NAME) ".nro"
#define NRO39_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO39_NAME) ".nro"
#define NRO40_NAME "rom:/nro/" STRINGIZE_VALUE_OF(TLS_NRO40_NAME) ".nro"

static const size_t MaxFileSize  = 0x400000;
static long         num_dtrs_to_call = 0;
static char*        cacheBuffer;
static size_t       cacheSize = 0;
static int          num_HogeConstructorCalls = 0;
static int          num_HogeDestructorCalls = 0;

extern thread_local int nro1_int; // is defined to 1
extern thread_local int nro2_int; // is defined to 2
extern thread_local int nro3_int; // is defined to 3
extern thread_local int nro4_int; // is defined to 4
extern thread_local int nro5_int; // is defined to 5
extern thread_local int nro6_int; // is defined to 6
extern thread_local int nro7_int; // is defined to 7
extern thread_local int nro8_int; // is defined to 8
extern thread_local int nro9_int; // is defined to 9
extern thread_local int nro10_int; // is defined to 10
extern thread_local int nro11_int; // is defined to 11
extern thread_local int nro12_int; // is defined to 12
extern thread_local int nro13_int; // is defined to 13
extern thread_local int nro14_int; // is defined to 14
extern thread_local int nro15_int; // is defined to 15
extern thread_local int nro16_int; // is defined to 16
extern thread_local int nro17_int; // is defined to 17
extern thread_local int nro18_int; // is defined to 18
extern thread_local int nro19_int; // is defined to 19
extern thread_local int nro20_int; // is defined to 20
extern thread_local int nro21_int; // is defined to 21
extern thread_local int nro22_int; // is defined to 22
extern thread_local int nro23_int; // is defined to 23
extern thread_local int nro24_int; // is defined to 24
extern thread_local int nro25_int; // is defined to 25
extern thread_local int nro26_int; // is defined to 26
extern thread_local int nro27_int; // is defined to 27
extern thread_local int nro28_int; // is defined to 28
extern thread_local int nro29_int; // is defined to 29
extern thread_local int nro30_int; // is defined to 30
extern thread_local int nro31_int; // is defined to 31
extern thread_local int nro32_int; // is defined to 32
extern thread_local int nro33_int; // is defined to 33
extern thread_local int nro34_int; // is defined to 34
extern thread_local int nro35_int; // is defined to 35
extern thread_local int nro36_int; // is defined to 36
extern thread_local int nro37_int; // is defined to 37
extern thread_local int nro38_int; // is defined to 38
extern thread_local int nro39_int; // is defined to 39
extern thread_local int nro40_int; // is defined to 40

thread_local int nsp_int = 123456789;

static size_t ReadAll(void** pOut, size_t bufferSize, const char* path, size_t alignment)
{
    void *p;
    nn::Result result;
    nn::fs::FileHandle file;
    result = nn::fs::OpenFile(&file, path, nn::fs::OpenMode_Read);
    NN_ASSERT(result.IsSuccess());

    int64_t fileSize;
    int32_t test;
    result = nn::fs::GetFileSize(&fileSize, file);
    NN_ASSERT(result.IsSuccess());
    NN_ASSERT_LESS(fileSize, static_cast<int64_t>(bufferSize));
    test = static_cast<int32_t>(fileSize);
    NN_ASSERT_EQUAL(static_cast<int64_t>(test), fileSize);

    p = aligned_alloc(alignment, test);
    NN_ASSERT_NOT_NULL(p);
    TESTLOG("ReadAll: path \"%s\" required %d byts to read its content", path, test);

    size_t readSize;
    result = nn::fs::ReadFile(&readSize, file, 0, p, bufferSize);
    NN_ASSERT(result.IsSuccess());
    NN_ASSERT_EQUAL(static_cast<int64_t>(readSize), fileSize);
    *pOut = p;

    nn::fs::CloseFile(file);

    return readSize;
}

static void Initialize_Ro_And_Rom()
{
    nn::Result result;

    TESTLOG("Initialize_Ro_And_Rom calling nn::ro::Initialize()");
    nn::ro::Initialize();

    // ファイルシステムのメタデータキャッシュに必要なバッファサイズを修得
    TESTLOG("Initialize_Ro_And_Rom calling nn::fs::QueryMountRomCacheSize(&cacheSize)");
    result = nn::fs::QueryMountRomCacheSize(&cacheSize);
    NN_ASSERT(result.IsSuccess());
    TESTLOG("Initialize_Ro_And_Rom cacheSize is %zd", cacheSize);

    // キャッシュバッファを確保
    TESTLOG("Initialize_Ro_And_Rom calling new(std::nothrow) char[cacheSize]");
    cacheBuffer = new(std::nothrow) char[cacheSize];
    NN_ASSERT_NOT_NULL(cacheBuffer);

    // ファイルシステムをマウント
    TESTLOG("Initialize_Ro_And_Rom calling nn::fs::MountRom(\"rom\", cacheBuffer, cacheSize)");
    result = nn::fs::MountRom("rom", cacheBuffer, cacheSize);
    NN_ABORT_UNLESS_RESULT_SUCCESS(result);
}

static void Finalize_Ro_And_Rom()
{
    TESTLOG("Finalize_Ro_And_Rom calling nn::ro::Finalize()");
    nn::ro::Finalize();

    // アンマウントする
    TESTLOG("Finalize_Ro_And_Rom calling nn::fs::Unmount(\"rom\")");
    nn::fs::Unmount("rom");
    delete[] cacheBuffer;
    cacheBuffer = NULL;
}

class Hoge
{
public:
    nn::Result result;
    void* nro;
    void* bss;
    void* nrr;
    size_t imageSize;
    size_t bufferSize;
    size_t nrrSize;
    nn::ro::Module module;
    nn::ro::RegistrationInfo info;
    void *nro_dso_handle;
    long hoge_num_dtrs_to_call = 0;
    const char *nrr_name;
    const char *nro_name;
    NroEntryPoint nro_entry;
    const char *nro_entry_name;
    uintptr_t addr;

    Hoge(const char *NrrName, const char *NroName, char *EntryPointName) {
        nrr_name = NrrName;
        nro_name = NroName;
        nro_entry_name = EntryPointName;

        num_HogeConstructorCalls++;
        nrr = 0;
        TESTLOG("Hoge: calling ReadAll(&nrr, MaxFileSize, \"%s\")", NrrName);
        nrrSize = ReadAll(&nrr, MaxFileSize, NrrName, nn::os::MemoryPageSize);
        TESTLOG("load_nro_module nrrSize is %zd", nrrSize);

        // nrr を登録
        TESTLOG("Hoge: calling nn::ro::RegisterModuleInfo(&info, nrr)");
        result = nn::ro::RegisterModuleInfo(&info, nrr);
        NN_ASSERT(result.IsSuccess());

        nro = 0;
        TESTLOG("Hoge: calling ReadAll(nro, MaxFileSize, \"%s\")", NroName);
        imageSize = ReadAll(&nro, MaxFileSize, NroName, nn::os::MemoryPageSize);
        TESTLOG("load_nro_module imageSize is %zd", imageSize);

        TESTLOG("Hoge: calling nn::ro::GetBufferSize(&bufferSize, nro)");
        result = nn::ro::GetBufferSize(&bufferSize, nro);
        NN_ASSERT(result.IsSuccess());
        TESTLOG("Hoge: bufferSize for bss is %zd", bufferSize);
        if (bufferSize != 0)
        {
            TESTLOG("Hoge: calling bss = aligned_alloc(nn::os::MemoryPageSize, bufferSize)");
            bss = aligned_alloc(nn::os::MemoryPageSize, bufferSize);
        }
        else
        {
            TESTLOG("Hoge: setting bss = 0");
            bss = 0;
        }

        // nro をロード(シンボルは遅延解決)
        TESTLOG("Hoge: calling nn::ro::LoadModule(&module, nro, bss, bufferSize, nn::ro::BindFlag_Lazy)");
        result = nn::ro::LoadModule(&module, nro, bss, bufferSize, nn::ro::BindFlag_Lazy);
        NN_ASSERT(result.IsSuccess());

        result = nn::ro::LookupModuleSymbol(&addr, &module, nro_entry_name);
        NN_ASSERT(result.IsSuccess());
        TESTLOG("Hoge: %s is %p based on LookupModuleSymbol", nro_entry_name, addr);
        NroEntryPoint nro_entry = reinterpret_cast<NroEntryPoint>(addr);

        TESTLOG("Hoge: calling %s()", nro_entry_name);
        nro_dso_handle = nro_entry();
        TESTLOG("Hoge: after calling %s()", nro_entry_name);

        TESTLOG("Hoge: calling __nnmusl_get_tls_dtors_status() with 0x%08zX from NRO", nro_dso_handle);
        hoge_num_dtrs_to_call = __nnmusl_get_tls_dtors_status (nro_dso_handle);
        TESTCASE_MESSAGE(hoge_num_dtrs_to_call == 0, "there were %ld uncalled destructors", hoge_num_dtrs_to_call);
    }
    ~Hoge() {
        TESTLOG("~Hoge(): TP = 0x%08zX; app module __dso_handle = %p; nro entry %s; nro __dso_handle %p", (size_t)__get_tp(), __dso_handle, nro_entry_name, nro_dso_handle);
        TESTLOG("~Hoge(): calling __nnmusl_get_tls_dtors_status() with %p in app module __dso_handle = %p", nro_dso_handle, __dso_handle);
        hoge_num_dtrs_to_call = __nnmusl_get_tls_dtors_status (nro_dso_handle);
        TESTLOG("~Hoge(): got %ld uncalled destructors in the NRO; nro entry %s; nro __dso_handle %p", hoge_num_dtrs_to_call, nro_entry_name, nro_dso_handle);
        TESTCASE_MESSAGE(hoge_num_dtrs_to_call == 0, "expected 0 but there were %ld uncalled destructors in the NRO; nro entry %s; nro __dso_handle %p", hoge_num_dtrs_to_call, nro_entry_name, nro_dso_handle);

        TESTLOG("~Hoge(): calling nn::ro::UnloadModule(&module)");
        nn::ro::UnloadModule(&module);
        TESTLOG("~Hoge(): calling nn::ro::UnregisterModuleInfo(&info)");
        nn::ro::UnregisterModuleInfo(&info);
        num_HogeDestructorCalls++;
    }
};


static void TestThread1(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread1 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO1_NAME, (char *)"CallNro1");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro1_int = %d; expected 1 in app module __dso_handle %p", nro1_int, __dso_handle);
    TESTCASE_MESSAGE(nro1_int == 1, "expected 1 but got %d in the NSP's TestThread in app module __dso_handle %p", nro1_int, __dso_handle);
}

static void TestThread2(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread2 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO2_NAME, (char *)"CallNro2");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro2_int = %d; expected 2 in app module __dso_handle %p", nro2_int, __dso_handle);
    TESTCASE_MESSAGE(nro2_int == 2, "expected 2 but got %d in the NSP's TestThread in app module __dso_handle %p", nro2_int, __dso_handle);
}

static void TestThread3(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread3 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO3_NAME, (char *)"CallNro3");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro3_int = %d; expected 3 in app module __dso_handle %p", nro3_int, __dso_handle);
    TESTCASE_MESSAGE(nro3_int == 3, "expected 3 but got %d in the NSP's TestThread in app module __dso_handle %p", nro3_int, __dso_handle);
}

static void TestThread4(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread4 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO4_NAME, (char *)"CallNro4");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro4_int = %d; expected 4 in app module __dso_handle %p", nro4_int, __dso_handle);
    TESTCASE_MESSAGE(nro4_int == 4, "expected 4 but got %d in the NSP's TestThread in app module __dso_handle %p", nro4_int, __dso_handle);
}

static void TestThread5(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread5 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO5_NAME, (char *)"CallNro5");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro5_int = %d; expected 5 in app module __dso_handle %p", nro5_int, __dso_handle);
    TESTCASE_MESSAGE(nro5_int == 5, "expected 5 but got %d in the NSP's TestThread in app module __dso_handle %p", nro5_int, __dso_handle);
}

static void TestThread6(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread6 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO6_NAME, (char *)"CallNro6");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro6_int = %d; expected 6 in app module __dso_handle %p", nro6_int, __dso_handle);
    TESTCASE_MESSAGE(nro6_int == 6, "expected 6 but got %d in the NSP's TestThread in app module __dso_handle %p", nro6_int, __dso_handle);
}

static void TestThread7(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread7 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO7_NAME, (char *)"CallNro7");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro7_int = %d; expected 7 in app module __dso_handle %p", nro7_int, __dso_handle);
    TESTCASE_MESSAGE(nro7_int == 7, "expected 7 but got %d in the NSP's TestThread in app module __dso_handle %p", nro7_int, __dso_handle);
}

static void TestThread8(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread8 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO8_NAME, (char *)"CallNro8");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro8_int = %d; expected 8 in app module __dso_handle %p", nro8_int, __dso_handle);
    TESTCASE_MESSAGE(nro8_int == 8, "expected 8 but got %d in the NSP's TestThread in app module __dso_handle %p", nro8_int, __dso_handle);
}

static void TestThread9(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread9 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO9_NAME, (char *)"CallNro9");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro9_int = %d; expected 9 in app module __dso_handle %p", nro9_int, __dso_handle);
    TESTCASE_MESSAGE(nro9_int == 9, "expected 9 but got %d in the NSP's TestThread in app module __dso_handle %p", nro9_int, __dso_handle);
}

static void TestThread10(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread10 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO10_NAME, (char *)"CallNro10");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro10_int = %d; expected 10 in app module __dso_handle %p", nro10_int, __dso_handle);
    TESTCASE_MESSAGE(nro10_int == 10, "expected 10 but got %d in the NSP's TestThread in app module __dso_handle %p", nro10_int, __dso_handle);
}

static void TestThread11(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread11 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO11_NAME, (char *)"CallNro11");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro11_int = %d; expected 11 in app module __dso_handle %p", nro11_int, __dso_handle);
    TESTCASE_MESSAGE(nro11_int == 11, "expected 11 but got %d in the NSP's TestThread in app module __dso_handle %p", nro11_int, __dso_handle);
}

static void TestThread12(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread12 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO12_NAME, (char *)"CallNro12");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro12_int = %d; expected 12 in app module __dso_handle %p", nro12_int, __dso_handle);
    TESTCASE_MESSAGE(nro12_int == 12, "expected 12 but got %d in the NSP's TestThread in app module __dso_handle %p", nro12_int, __dso_handle);
}

static void TestThread13(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread13 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO13_NAME, (char *)"CallNro13");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro13_int = %d; expected 13 in app module __dso_handle %p", nro13_int, __dso_handle);
    TESTCASE_MESSAGE(nro13_int == 13, "expected 13 but got %d in the NSP's TestThread in app module __dso_handle %p", nro13_int, __dso_handle);
}

static void TestThread14(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread14 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO14_NAME, (char *)"CallNro14");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro14_int = %d; expected 14 in app module __dso_handle %p", nro14_int, __dso_handle);
    TESTCASE_MESSAGE(nro14_int == 14, "expected 14 but got %d in the NSP's TestThread in app module __dso_handle %p", nro14_int, __dso_handle);
}

static void TestThread15(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread15 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO15_NAME, (char *)"CallNro15");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro15_int = %d; expected 15 in app module __dso_handle %p", nro15_int, __dso_handle);
    TESTCASE_MESSAGE(nro15_int == 15, "expected 15 but got %d in the NSP's TestThread in app module __dso_handle %p", nro15_int, __dso_handle);
}

static void TestThread16(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread16 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO16_NAME, (char *)"CallNro16");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro16_int = %d; expected 16 in app module __dso_handle %p", nro16_int, __dso_handle);
    TESTCASE_MESSAGE(nro16_int == 16, "expected 16 but got %d in the NSP's TestThread in app module __dso_handle %p", nro16_int, __dso_handle);
}

static void TestThread17(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread17 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO17_NAME, (char *)"CallNro17");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro17_int = %d; expected 17 in app module __dso_handle %p", nro17_int, __dso_handle);
    TESTCASE_MESSAGE(nro17_int == 17, "expected 17 but got %d in the NSP's TestThread in app module __dso_handle %p", nro17_int, __dso_handle);
}

static void TestThread18(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread18 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO18_NAME, (char *)"CallNro18");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro18_int = %d; expected 18 in app module __dso_handle %p", nro18_int, __dso_handle);
    TESTCASE_MESSAGE(nro18_int == 18, "expected 18 but got %d in the NSP's TestThread in app module __dso_handle %p", nro18_int, __dso_handle);
}

static void TestThread19(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread19 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO19_NAME, (char *)"CallNro19");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro19_int = %d; expected 19 in app module __dso_handle %p", nro19_int, __dso_handle);
    TESTCASE_MESSAGE(nro19_int == 19, "expected 19 but got %d in the NSP's TestThread in app module __dso_handle %p", nro19_int, __dso_handle);
}

static void TestThread20(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread20 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO20_NAME, (char *)"CallNro20");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro20_int = %d; expected 20 in app module __dso_handle %p", nro20_int, __dso_handle);
    TESTCASE_MESSAGE(nro20_int == 20, "expected 20 but got %d in the NSP's TestThread in app module __dso_handle %p", nro20_int, __dso_handle);
}

static void TestThread21(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread21 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO21_NAME, (char *)"CallNro21");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro21_int = %d; expected 21 in app module __dso_handle %p", nro21_int, __dso_handle);
    TESTCASE_MESSAGE(nro21_int == 21, "expected 21 but got %d in the NSP's TestThread in app module __dso_handle %p", nro21_int, __dso_handle);
}

static void TestThread22(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread22 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO22_NAME, (char *)"CallNro22");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro22_int = %d; expected 22 in app module __dso_handle %p", nro22_int, __dso_handle);
    TESTCASE_MESSAGE(nro22_int == 22, "expected 22 but got %d in the NSP's TestThread in app module __dso_handle %p", nro22_int, __dso_handle);
}

static void TestThread23(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread23 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO23_NAME, (char *)"CallNro23");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro23_int = %d; expected 23 in app module __dso_handle %p", nro23_int, __dso_handle);
    TESTCASE_MESSAGE(nro23_int == 23, "expected 23 but got %d in the NSP's TestThread in app module __dso_handle %p", nro23_int, __dso_handle);
}

static void TestThread24(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread24 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO24_NAME, (char *)"CallNro24");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro24_int = %d; expected 24 in app module __dso_handle %p", nro24_int, __dso_handle);
    TESTCASE_MESSAGE(nro24_int == 24, "expected 24 but got %d in the NSP's TestThread in app module __dso_handle %p", nro24_int, __dso_handle);
}

static void TestThread25(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread25 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO25_NAME, (char *)"CallNro25");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro25_int = %d; expected 25 in app module __dso_handle %p", nro25_int, __dso_handle);
    TESTCASE_MESSAGE(nro25_int == 25, "expected 25 but got %d in the NSP's TestThread in app module __dso_handle %p", nro25_int, __dso_handle);
}

static void TestThread26(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread26 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO26_NAME, (char *)"CallNro26");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro26_int = %d; expected 26 in app module __dso_handle %p", nro26_int, __dso_handle);
    TESTCASE_MESSAGE(nro26_int == 26, "expected 26 but got %d in the NSP's TestThread in app module __dso_handle %p", nro26_int, __dso_handle);
}

static void TestThread27(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread27 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO27_NAME, (char *)"CallNro27");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro27_int = %d; expected 27 in app module __dso_handle %p", nro27_int, __dso_handle);
    TESTCASE_MESSAGE(nro27_int == 27, "expected 27 but got %d in the NSP's TestThread in app module __dso_handle %p", nro27_int, __dso_handle);
}

static void TestThread28(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread28 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO28_NAME, (char *)"CallNro28");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro28_int = %d; expected 28 in app module __dso_handle %p", nro28_int, __dso_handle);
    TESTCASE_MESSAGE(nro28_int == 28, "expected 28 but got %d in the NSP's TestThread in app module __dso_handle %p", nro28_int, __dso_handle);
}

static void TestThread29(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread29 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO29_NAME, (char *)"CallNro29");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro29_int = %d; expected 29 in app module __dso_handle %p", nro29_int, __dso_handle);
    TESTCASE_MESSAGE(nro29_int == 29, "expected 29 but got %d in the NSP's TestThread in app module __dso_handle %p", nro29_int, __dso_handle);
}

static void TestThread30(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread30 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO30_NAME, (char *)"CallNro30");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro30_int = %d; expected 30 in app module __dso_handle %p", nro30_int, __dso_handle);
    TESTCASE_MESSAGE(nro30_int == 30, "expected 30 but got %d in the NSP's TestThread in app module __dso_handle %p", nro30_int, __dso_handle);
}

static void TestThread31(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread31 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO31_NAME, (char *)"CallNro31");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro31_int = %d; expected 31 in app module __dso_handle %p", nro31_int, __dso_handle);
    TESTCASE_MESSAGE(nro31_int == 31, "expected 31 but got %d in the NSP's TestThread in app module __dso_handle %p", nro31_int, __dso_handle);
}

static void TestThread32(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread32 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO32_NAME, (char *)"CallNro32");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro32_int = %d; expected 32 in app module __dso_handle %p", nro32_int, __dso_handle);
    TESTCASE_MESSAGE(nro32_int == 32, "expected 32 but got %d in the NSP's TestThread in app module __dso_handle %p", nro32_int, __dso_handle);
}

static void TestThread33(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread33 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO33_NAME, (char *)"CallNro33");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro33_int = %d; expected 33 in app module __dso_handle %p", nro33_int, __dso_handle);
    TESTCASE_MESSAGE(nro33_int == 33, "expected 33 but got %d in the NSP's TestThread in app module __dso_handle %p", nro33_int, __dso_handle);
}

static void TestThread34(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread34 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO34_NAME, (char *)"CallNro34");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro34_int = %d; expected 34 in app module __dso_handle %p", nro34_int, __dso_handle);
    TESTCASE_MESSAGE(nro34_int == 34, "expected 34 but got %d in the NSP's TestThread in app module __dso_handle %p", nro34_int, __dso_handle);
}

static void TestThread35(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread35 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO35_NAME, (char *)"CallNro35");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro35_int = %d; expected 35 in app module __dso_handle %p", nro35_int, __dso_handle);
    TESTCASE_MESSAGE(nro35_int == 35, "expected 35 but got %d in the NSP's TestThread in app module __dso_handle %p", nro35_int, __dso_handle);
}

static void TestThread36(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread36 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO36_NAME, (char *)"CallNro36");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro36_int = %d; expected 36 in app module __dso_handle %p", nro36_int, __dso_handle);
    TESTCASE_MESSAGE(nro36_int == 36, "expected 36 but got %d in the NSP's TestThread in app module __dso_handle %p", nro36_int, __dso_handle);
}

static void TestThread37(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread37 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO37_NAME, (char *)"CallNro37");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro37_int = %d; expected 37 in app module __dso_handle %p", nro37_int, __dso_handle);
    TESTCASE_MESSAGE(nro37_int == 37, "expected 37 but got %d in the NSP's TestThread in app module __dso_handle %p", nro37_int, __dso_handle);
}

static void TestThread38(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread38 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO38_NAME, (char *)"CallNro38");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro38_int = %d; expected 38 in app module __dso_handle %p", nro38_int, __dso_handle);
    TESTCASE_MESSAGE(nro38_int == 38, "expected 38 but got %d in the NSP's TestThread in app module __dso_handle %p", nro38_int, __dso_handle);
}

static void TestThread39(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread39 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO39_NAME, (char *)"CallNro39");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro39_int = %d; expected 39 in app module __dso_handle %p", nro39_int, __dso_handle);
    TESTCASE_MESSAGE(nro39_int == 39, "expected 39 but got %d in the NSP's TestThread in app module __dso_handle %p", nro39_int, __dso_handle);
}

static void TestThread40(void *arg)
{
    NN_UNUSED(arg);

    TESTLOG("TestThread40 in app module __dso_handle %p", __dso_handle);

    thread_local Hoge g_Hoge(NRR_NAME, NRO40_NAME, (char *)"CallNro40");

    TESTLOG("nsp_int = %d; expected 123456789 in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTCASE_MESSAGE(nsp_int == 123456789, "expected 123456789 but got %d in the NSP's TestThread in app module __dso_handle %p", nsp_int, __dso_handle);
    TESTLOG("nro40_int = %d; expected 40 in app module __dso_handle %p", nro40_int, __dso_handle);
    TESTCASE_MESSAGE(nro40_int == 40, "expected 40 but got %d in the NSP's TestThread in app module __dso_handle %p", nro40_int, __dso_handle);
}

/*---------------------------------------------------------------------------*
  Name:         main

  Description:  This is the main function of the demo.

                This demo displays Hello! on the main thread and sub-threads.

  Arguments:    None.

  Returns:      Always zero.

 *---------------------------------------------------------------------------*/
extern "C" void nnMain()
{
    nn::Result      result;
    int i;

    NTD_TEST_START();
    NTD_TEST_GROUP_START(TEST_NAME, 1);

    TESTLOG("__EX_start = %p", (unsigned char *)__EX_start);
    TESTLOG("%s: __oasis_nnmusl_dso_modules->version = %d", TEST_NAME, __oasis_nnmusl_dso_modules->version);
    TESTLOG("%s: __oasis_nnmusl_dso_modules->nModules = %d", TEST_NAME, __oasis_nnmusl_dso_modules->nModules);
    TESTLOG("%s: __oasis_nnmusl_dso_modules->nElements = %d", TEST_NAME, __oasis_nnmusl_dso_modules->nElements);
    for (i = 1; i < __oasis_nnmusl_dso_modules->nElements; i++) {
        if (__oasis_nnmusl_dso_modules->modAddresses[i] == (size_t)__EX_start) {
            TESTLOG("%s is modAddresses element %d", TEST_NAME, i);
            break;
        }
    }
    TESTCASE_MESSAGE(i == 1, "The module with nnMain is expected to be in element 1");

    Initialize_Ro_And_Rom();

    // スレッドを生成する
    TESTLOG("begin creating threads");
    for (i = 0; i < NUM_THREADS; i++) {
        result = nn::os::CreateThread( &(g_Thread[i]), TestThread[i], NULL, g_ThreadStack[i].stack, ThreadStackSize, nn::os::DefaultThreadPriority );
        NN_ASSERT( result.IsSuccess(), "Cannot create g_Thread[%zd].", i );
        TESTLOG("g_Thread[%zd] = 0x%08zX created", i, (size_t)&(g_Thread[i]));
    }

    TESTLOG("begin starting threads");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors before starting threads.", num_dtrs_to_call);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before calling nn::os::StartThread we expected 0 uncalled Destructor but we got %ld.", num_dtrs_to_call);
    // スレッドの実行を開始する
    for (i = 0; i < NUM_THREADS; i++) {
        nn::os::StartThread( &(g_Thread[i]) );
        TESTLOG("g_Thread[%zd] = 0x%08zX started", i, (size_t)&(g_Thread[i]));
    }

    TESTLOG("begin waiting threads");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors before waiting threads.", num_dtrs_to_call);
    // スレッドが終了するのを待つ
    for (i = 0; i < NUM_THREADS; i++) {
        nn::os::WaitThread( &(g_Thread[i]) );
        TESTLOG("g_Thread[%zd] = 0x%08zX did wait", i, (size_t)&(g_Thread[i]));
    }

    TESTLOG("begin destroying threads");
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTLOG("There are %ld registered destructors before destroying threads.", num_dtrs_to_call);
    // スレッドを破棄する
    for (i = 0; i < NUM_THREADS; i++) {
        nn::os::DestroyThread( &(g_Thread[i]) );
        TESTLOG("g_Thread[%zd] = 0x%08zX destroyed", i, (size_t)&(g_Thread[i]));
    }
    TESTLOG("done destroying threads");

    Finalize_Ro_And_Rom();

    TESTLOG("num_HogeConstructorCalls = %d", num_HogeConstructorCalls);
    TESTCASE_MESSAGE(num_HogeConstructorCalls == NUM_THREADS, "Before exiting nnMain we expected %d calls to Hoge() but we got %ld.",
        NUM_THREADS, num_HogeConstructorCalls);

    TESTLOG("num_HogeDestructorCalls = %d", num_HogeDestructorCalls);
    TESTCASE_MESSAGE(num_HogeDestructorCalls == NUM_THREADS, "Before exiting nnMain we expected %d calls to ~Hoge() but we got %ld.",
        NUM_THREADS, num_HogeDestructorCalls);

    TESTLOG("nnMain calling __nnmusl_get_tls_dtors_status() with 0x%08zX", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_tls_dtors_status (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "expected 0 but there were %ld uncalled destructors", num_dtrs_to_call);

    NTD_TEST_GROUP_END(TEST_NAME, 1);
    NTD_TEST_END();
}

