﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <cstring>
#include <cstdint>
#include <cstddef>
#include <cstdlib>
#include <pthread.h>
#include <nn/nn_Macro.h>
#include <nn/nn_Log.h>
#include <nn/nn_Assert.h>
#include <nn/os.h>
#include <nn/svc/svc_ThreadLocalRegion.h>
#include <climits>
#include <nn/os/os_ThreadApi.h>
#include <inttypes.h>
#include "ntd-test-tls.h"

extern "C" void *CallNro(void);
extern void *__dso_handle;  // this is defined in Chris/Sources/Libraries/rocrt/rocrt.cpp

#define TEST_ROOT_NAME STRINGIZE_VALUE_OF(TLS_NRO_NAME)
#if ULONG_MAX == 0xffffffff
#define TEST_NAME "ARM32-" TEST_ROOT_NAME
#else
#define TEST_NAME "AARCH64-" TEST_ROOT_NAME
#endif

static int num_Hoge5ConstructorCalls = 0;
static int num_Hoge5DestructorCalls = 0;

class Hoge5
{
public:
    int x;
    nn::os::ThreadType *Hoge5_thread;
    void *this_obj;
    char *name = (char *)"<unitialized name>";
    int64_t hoge5_num_dtrs_to_call = 0;
    Hoge5() {
        Hoge5_thread = nn::os::GetCurrentThread();
        this_obj = (void*)this;
        TESTLOG("Hello from class Hoge5 (%s) %d thread address %p; this = %p", name, x, (size_t)Hoge5_thread, (size_t)this_obj);
        num_Hoge5ConstructorCalls++;
    }
    Hoge5(char *func_name, int T) {
        name = func_name;
        x = T;
        Hoge5_thread = nn::os::GetCurrentThread();
        this_obj = (void*)this;
        TESTLOG("Hello from class Hoge5 (%s) %d thread address %p; this = %p", name, x, (size_t)Hoge5_thread, (size_t)this_obj);
        num_Hoge5ConstructorCalls++;
    }
    ~Hoge5() {
        TESTLOG("Good-bye from class Hoge5 (%s) %d thread address %p; this = %p!", name, x, (size_t)Hoge5_thread, (size_t)this_obj);
        hoge5_num_dtrs_to_call = __nnmusl_get_number_uncalled_tls_dtors (__dso_handle);
        TESTLOG("in ~Hoge5(): got %" PRId64 " uncalled destructors in the NRO", hoge5_num_dtrs_to_call);
        TESTCASE_MESSAGE(hoge5_num_dtrs_to_call == 1, "Before exiting ~Hoge5() we expected 1 uncalled Destructor but we got %" PRId64 ".", hoge5_num_dtrs_to_call);
        num_Hoge5DestructorCalls++;
    }
};

static thread_local int trigger;
static thread_local Hoge5 hoge5((char *)"g_Hoge5_0", 47);

extern "C" void *CallNro()
{
    TESTLOG("Start %s", TEST_NAME);

    int64_t         num_dtrs_to_call = 0;
    nn::os::ThreadType *main_thread = nn::os::GetCurrentThread();
    TESTLOG("main_thread in the NRO = %p", (size_t)main_thread);

    TESTLOG("CallNro calling __nnmusl_get_number_uncalled_tls_dtors() before triggering the constructor in module with __dso_handle = %p", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_number_uncalled_tls_dtors (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "Before triggering the constructor, CallNro we expected 0 uncalled Destructors but we got %" PRId64 ".", num_dtrs_to_call);

    TESTLOG("num_Hoge5ConstructorCalls = %d", num_Hoge5ConstructorCalls);
    TESTCASE_MESSAGE(num_Hoge5ConstructorCalls == 0, "Before exiting CallNro we expected 0 calls to Hoge5() but we got %" PRId64 ".",
        num_Hoge5ConstructorCalls);
    TESTLOG("num_Hoge5DestructorCalls = %d", num_Hoge5DestructorCalls);
    TESTCASE_MESSAGE(num_Hoge5DestructorCalls == 0, "Before exiting CallNro we expected 0 calls to ~Hoge5() but we got %" PRId64 ".",
        num_Hoge5DestructorCalls);

    trigger++;

    TESTLOG("CallNro calling __nnmusl_get_number_uncalled_tls_dtors() after triggering the constructor in module with __dso_handle = %p", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_number_uncalled_tls_dtors (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 1, "After triggering the constructor, CallNro we expected 1 uncalled Destructor but we got %" PRId64 ".", num_dtrs_to_call);

    TESTLOG("num_Hoge5ConstructorCalls = %d", num_Hoge5ConstructorCalls);
    TESTCASE_MESSAGE(num_Hoge5ConstructorCalls == 1, "Before exiting CallNro we expected 1 call to Hoge5() but we got %" PRId64 ".",
        num_Hoge5ConstructorCalls);
    TESTLOG("num_Hoge5DestructorCalls = %d", num_Hoge5DestructorCalls);
    TESTCASE_MESSAGE(num_Hoge5DestructorCalls == 0, "Before exiting CallNro we expected 0 calls to ~Hoge5() but we got %" PRId64 ".",
        num_Hoge5DestructorCalls);

    if (num_dtrs_to_call) {
        // I know that the outstanding destructor will not call any more constructors
        // unload the module via the destructor
        __nnmusl_call_tls_dtors_for_module (__dso_handle);
    }

    TESTLOG("CallNro calling __nnmusl_get_number_uncalled_tls_dtors() calling destructors in module with __dso_handle = %p", __dso_handle);
    num_dtrs_to_call = __nnmusl_get_number_uncalled_tls_dtors (__dso_handle);
    TESTCASE_MESSAGE(num_dtrs_to_call == 0, "After calling destructors in CallNro, we expected 0 uncalled Destructors but we got %" PRId64 ".", num_dtrs_to_call);

    TESTLOG("num_Hoge5ConstructorCalls = %d", num_Hoge5ConstructorCalls);
    TESTCASE_MESSAGE(num_Hoge5ConstructorCalls == 1, "Before exiting CallNro we expected 1 call to Hoge5() but we got %" PRId64 ".",
        num_Hoge5ConstructorCalls);
    TESTLOG("num_Hoge5DestructorCalls = %d", num_Hoge5DestructorCalls);
    TESTCASE_MESSAGE(num_Hoge5DestructorCalls == 1, "Before exiting CallNro we expected 1 calls to ~Hoge5() but we got %" PRId64 ".",
        num_Hoge5DestructorCalls);

    TESTLOG("End %s", TEST_NAME);
    return __dso_handle;
}


