/*-----------------------------------------------------------------------*
  Project: csGrass
  File: sky.vs

  Copyright (C)2013 Nintendo  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo and/or its licensed developers
  and are protected by national and international copyright laws. They
  may not be disclosed to third parties or copied or duplicated in any
  form, in whole or in part, without the prior written consent of
  Nintendo.

  The content herein is highly confidential and should be handled
  accordingly.
*-----------------------------------------------------------------------*/

#version 330
attribute vec4 a_position;

layout(std140) uniform u_VUniforms
{
	mat4 InvProjMatrix;
	mat4 InvModelviewMatrix;
};

varying vec4 ViewDir;

void main()
{
    vec4 prj = InvProjMatrix * a_position;
    vec4 dir = InvModelviewMatrix * vec4(prj.xyz, 0.0);
    ViewDir = dir;
    
    gl_Position = a_position;
}
