#!/bin/bash

#-------------------------------------------------------------------------------
#  This runs the script that generates the "!.nact--external", then creates a
#  "LibcTest" folder in "SDK/Samples/Sources/Applications" and copies
#  "!.nact--external" to it, then edits "Samples/Sources/Applications/!.nact"
#  to add "build LibcTest" if needed.
#
#  This script assumes that the 'SIGLO_ROOT' variable is set. It's the path to
#  the SDK root directory, which is where the "NintendoSdkRootMark" file is.
#-------------------------------------------------------------------------------

bash "./generate-external-nact.sh"

nact_file_name="!.nact"
nact_external_file_name="!.nact--external"
SDK_SAMPLES_SRC=${SIGLO_ROOT}"/Samples/Sources/Applications"
SDK_SAMPLES_NACT=${SDK_SAMPLES_SRC}"/!.nact"
LIBC_TEST_NAME="LibcTest"
LIBC_TEST_DIR=${SDK_SAMPLES_SRC}"/"${LIBC_TEST_NAME}

if [ -z ${SIGLO_ROOT} ]
then
  echo " --ERROR--  Environment variable 'SIGLO_ROOT' needs to be set."
  echo "            (Path to the SDK root directory, where the \"NintendoSdkRootMark\" file is)"
  exit
fi

if ! [ -d ${SDK_SAMPLES_SRC} ]
then
  echo " --ERROR--  Directory \""${SDK_SAMPLES_SRC}"\" could not be found"
  exit
fi

mkdir -p ${LIBC_TEST_DIR}

cp "./"${LIBC_TEST_NAME}".yml" ${LIBC_TEST_DIR}
mv "./"${nact_external_file_name} ${LIBC_TEST_DIR}"/"${nact_file_name}

if ! grep -q "\""${LIBC_TEST_NAME}"\";" ${SDK_SAMPLES_NACT}
then
    echo -e -n "build \""${LIBC_TEST_NAME}"\";\n" >> ${SDK_SAMPLES_NACT}
fi

echo -e "\nDone! LibcTest folder created:"
echo "  \""${LIBC_TEST_DIR}"\""
