﻿#ifndef PDCLIB_TEST_H
#define PDCLIB_TEST_H 1

#include "ntd-test-libc.h"

#define TEST 1
#define SKIP_MALLOC 1

/* DON'T TEST platform stuff */
#define PDCLIB_TEST_PLATFORM 0

void functions__PDCLIB(void);
void functions_ctype(void);
void functions_inttypes(void);
void functions_locale(void);
void functions_stdio(void);
void functions_stdlib(void);
void functions_string(void);
void functions_uchar(void);
void functions_wchar(void);
void functions_wctype(void);
void opt_basecodecs(void);
void opt_c_locale(void);
void opt_dlmalloc(void);
void opt_malloc_solar(void);
void opt_mincoll(void);
void opt_nothread(void);
void opt_notime(void);
void opt_pthreads(void);
void opt_tss_errno(void);
void pdclib_function_tests(void);
void pdclib_opt_tests(void);
#if PDCLIB_TEST_PLATFORM
void pdclib_platform_example_tests(void);
void pdclib_platform_gandr_tests(void);
void pdclib_platform_posix_tests(void);
void pdclib_platform_win32_tests(void);
void pdclib_platform_tests(void);
void pdclib_tests(void);
void platform_example_functions__PDCLIB(void);
void platform_example_functions_signal(void);
void platform_example_functions_stdio(void);
void platform_example_functions_stdlib(void);
void platform_gandr_functions__PDCLIB(void);
void platform_gandr_functions_signal(void);
void platform_gandr_functions_stdio(void);
void platform_posix_functions__PDCLIB(void);
void platform_posix_functions_signal(void);
void platform_posix_functions_stdio(void);
void platform_posix_functions_stdlib(void);
void platform_win32_functions__PDCLIB(void);
void platform_win32_functions_signal(void);
void platform_win32_functions_stdio(void);
void platform_win32_functions_stdlib(void);
void platform_win32_functions_threads(void);
#endif

int test__PDCLIB_atomax( void );
int test__PDCLIB_closeall( void );
int test__PDCLIB_initclocale( void );
int test__PDCLIB_digits( void );
int test__PDCLIB_strtox_main( void );
int test__PDCLIB_strtox_prelim( void );
int test_isalnum( void );
int test_isalpha( void );
int test_isblank( void );
int test_iscntrl( void );
int test_isdigit( void );
int test_isgraph( void );
int test_islower( void );
int test_isprint( void );
int test_ispunct( void );
int test_isspace( void );
int test_isupper( void );
int test_isxdigit( void );
int test_tolower( void );
int test_toupper( void );
int test_imaxabs( void );
int test_imaxdiv( void );
int test_strtoimax( void );
int test_strtoumax( void );
int test__PDCLIB_mb_cur_max( void );
int test__PDCLIB_unicodedata( void );
int test_freelocale( void );
int test_localeconv( void );
int test_setlocale( void );
int test_uselocale( void );
int test__cbprintf( void );
int test__PDCLIB_filemode( void );
int test__PDCLIB_fillbuffer( void );
int test__PDCLIB_flushbuffer( void );
int test__PDCLIB_ftell64( void );
int test__PDCLIB_fvopen( void );
int test__PDCLIB_prepread( void );
int test__PDCLIB_prepwrite( void );
int test__PDCLIB_print( void );
int test__PDCLIB_scan( void );
int test__PDCLIB_seek( void );
int test__vcbprintf( void );
int test_clearerr( void );
int test_fclose( void );
int test_feof( void );
int test_ferror( void );
int test_fflush( void );
int test_fgetc( void );
int test_fgetpos( void );
int test_fgets( void );
int test_flockfile( void );
int test_fopen( void );
int test_fprintf( void );
int test_fputc( void );
int test_fputs( void );
int test_fread( void );
int test_freopen( void );
int test_fscanf( void );
int test_fseek( void );
int test_fsetpos( void );
int test_ftell( void );
int test_ftrylockfile( void );
int test_funlockfile( void );
int test_fwrite( void );
int test_getc( void );
int test_getchar( void );
int test_gets( void );
int test_perror( void );
int test_printf( void );
int test_putc( void );
int test_putchar( void );
int test_puts( void );
int test_rename( void );
int test_rewind( void );
int test_scanf( void );
int test_setbuf( void );
int test_setvbuf( void );
int test_snprintf( void );
int test_sprintf( void );
int test_sscanf( void );
int test_tmpnam( void );
int test_ungetc( void );
int test_vfprintf( void );
int test_vfscanf( void );
int test_vprintf( void );
int test_vscanf( void );
int test_vsnprintf( void );
int test_vsprintf( void );
int test_vsscanf( void );
int test__Exit( void );
int test_abort( void );
int test_abs( void );
int test_atexit( void );
int test_atoi( void );
int test_atol( void );
int test_atoll( void );
int test_bsearch( void );
int test_div( void );
int test_exit( void );
int test_labs( void );
int test_ldiv( void );
int test_llabs( void );
int test_lldiv( void );
int test_qsort( void );
int test_rand( void );
int test_srand( void );
int test_strtol( void );
int test_strtoll( void );
int test_strtoul( void );
int test_strtoull( void );
int test_memchr( void );
int test_memcmp( void );
int test_memcpy( void );
int test_memmove( void );
int test_memset( void );
int test_snprintf( void );
int test_strcat( void );
int test_strchr( void );
int test_strcmp( void );
int test_strcoll( void );
int test_strcpy( void );
int test_strcspn( void );
int test_strdup( void );
int test_strerror( void );
int test_strlcat( void );
int test_strlcpy( void );
int test_strlen( void );
int test_strncat( void );
int test_strncmp( void );
int test_strncpy( void );
int test_strndup( void );
int test_strnlen( void );
int test_strpbrk( void );
int test_strrchr( void );
int test_strspn( void );
int test_strstr( void );
int test_strtok( void );
int test_strxfrm( void );
int test__PDCLIB_c16slen( void );
int test__PDCLIB_c32slen( void );
int test__PDCLIB_c32srtombs( void );
int test__PDCLIB_mbsrtoc32s( void );
int test_c16rtomb( void );
int test_c32rtomb( void );
int test_mbrtoc16( void );
int test_mbrtoc32( void );
int test_mbrtowc( void );
int test_mbsinit( void );
int test_wcrtomb( void );
int test_wcscat( void );
int test_wcschr( void );
int test_wcscmp( void );
int test_wcscpy( void );
int test_wcscspn( void );
int test_wcslen( void );
int test_wcsncat( void );
int test_wcsncmp( void );
int test_wcsncpy( void );
int test_wcspbrk( void );
int test_wcsrchr( void );
int test_wcsspn( void );
int test_wcsstr( void );
int test_wcstok( void );
int test_wmemchr( void );
int test_wmemcmp( void );
int test_wmemcpy( void );
int test_wmemmove( void );
int test_iswalnum( void );
int test_iswalpha( void );
int test_iswblank( void );
int test_iswcntrl( void );
int test_iswctype( void );
int test_iswdigit( void );
int test_iswgraph( void );
int test_iswlower( void );
int test_iswprint( void );
int test_iswpunct( void );
int test_iswspace( void );
int test_iswupper( void );
int test_iswxdigit( void );
int test_towctrans( void );
int test_towlower( void );
int test_towupper( void );
int test_wctrans( void );
int test_wctype( void );
int test__PDCLIB_ascii( void );
int test__PDCLIB_latin1( void );
int test__PDCLIB_utf8( void );
int test_dlmalloc( void );
int test_calloc( void );
int test_free( void );
int test_malloc( void );
int test_realloc( void );
int test_wcscoll( void );
int test_wcsxfrm( void );
int test_nt_call_once( void );
int test_nt_cnd_init( void );
int test_nt_cnd_signal( void );
int test_nt_cnd_wait( void );
int test_nt_mtx_destroy( void );
int test_nt_mtx_init( void );
int test_nt_mtx_lock( void );
int test_nt_mtx_timedlock( void );
int test_nt_mtx_trylock( void );
int test_nt_mtx_unlock( void );
int test_nt_thrd_yield( void );
int test_nt_tss_create( void );
int test_nt_tss_delete( void );
int test_nt_tss_get( void );
int test_nt_tss_set( void );
int test_time( void );
int test_timespec_get( void );
int test_call_once( void );
int test_mtx_destroy( void );
int test_mtx_init( void );
int test_mtx_lock( void );
int test_mtx_timedlock( void );
int test_mtx_trylock( void );
int test_mtx_unlock( void );
int test_tss_create( void );
int test_tss_delete( void );
int test_tss_get( void );
int test_tss_set( void );
int test_errno( void );
int test__PDCLIB_Exit( void );
int test__PDCLIB_fileops( void );
int test__PDCLIB_open( void );
int test_rename( void );
int test_stdinit( void );
int test_raise( void );
int test_signal( void );
int test_remove( void );
int test_tmpfile( void );
int test_getenv( void );
int test__PDCLIB_Exit( void );
int test__PDCLIB_stdinit( void );
int test__PDCLIB_stdstreams( void );
int test_raise( void );
int test_signal( void );
int test__PDCLIB_fileops( void );
int test_remove( void );
int test__PDCLIB_allocpages( void );
int test__PDCLIB_Exit( void );
int test__PDCLIB_freepages( void );
int test__PDCLIB_rename( void );
int test__PDCLIB_stdinit( void );
int test_raise( void );
int test_signal( void );
int test__PDCLIB_fileops( void );
int test__PDCLIB_open( void );
int test_remove( void );
int test_tmpfile( void );
int test_getenv( void );
int test__PDCLIB_allocpages( void );
int test__PDCLIB_Exit( void );
int test__PDCLIB_fileops( void );
int test__PDCLIB_freepages( void );
int test__PDCLIB_open( void );
int test__PDCLIB_rename( void );
int test__PDCLIB_runTlsCallbacks( void );
int test__PDCLIB_stdinit( void );
int test__PDCLIB_w32errno( void );
int test__tls_used( void );
int test_raise( void );
int test_signal( void );
int test_remove( void );
int test_tmpfile( void );
int test_getenv( void );
int test_call_once( void );
int test_mtx_destroy( void );
int test_mtx_init( void );
int test_mtx_lock( void );
int test_mtx_timedlock( void );
int test_mtx_trylock( void );
int test_mtx_unlock( void );
int test_tss_create( void );
int test_tss_delete( void );
int test_tss_get( void );
int test_tss_set( void );

/* Some strings used for <string.h> and <stdlib.h> testing. */
static char const abcde[] = "abcde";
static char const abcdx[] = "abcdx";
static char const teststring[] = "1234567890\nABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n";

static wchar_t const wabcde[] = L"abcde";
static wchar_t const wabcdx[] = L"abcdx";
static wchar_t const wteststring[] = L"1234567890\nABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n";

/* Temporary file names */
static char const testfile[]="testing/testfile";
static char const testfile1[]="testing/testfile1";
static char const testfile2[]="testing/testfile2";

#define NO_TESTDRIVER 0

static int TEST_RESULTS = 0;

/* Include printf() / scanf() test macros if required */

#if defined( _PDCLIB_FILEIO ) || defined( _PDCLIB_STRINGIO )
#include "pdclib-tests/_PDCLIB_iotest.h"
#endif

#define REGTEST 1

#endif /* PDCLIB_TEST_H */
