﻿/* wmemmove( wchar_t *, const wchar_t *, size_t )

   This file is part of the Public Dotest_wmemmove C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <wchar.h>


#include "pdclib-tests/pdclib-tests.h"

int test_wmemmove( void )
{
    wchar_t s[] = L"xxxxabcde";
    TESTCASE( wmemmove( s, s + 4, 5 ) == s );
    TESTCASE( s[0] == L'a' );
    TESTCASE( s[4] == L'e' );
    TESTCASE( s[5] == L'b' );
    TESTCASE( wmemmove( s + 4, s, 5 ) == s + 4 );
    TESTCASE( s[4] == L'a' );
    return TEST_RESULTS;
}
