﻿/* wcsncat( wchar_t *, const wchar_t *, size_t )

   This file is part of the Public Dotest_wcsncat C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <wchar.h>


#include "pdclib-tests/pdclib-tests.h"

int test_wcsncat( void )
{
    wchar_t s[] = L"xx\0xxxxxx";
    TESTCASE( wcsncat( s, wabcde, 10 ) == s );
    TESTCASE( s[2] == L'a' );
    TESTCASE( s[6] == L'e' );
    TESTCASE( s[7] == L'\0' );
    TESTCASE( s[8] == L'x' );
    s[0] = L'\0';
    TESTCASE( wcsncat( s, wabcdx, 10 ) == s );
    TESTCASE( s[4] == L'x' );
    TESTCASE( s[5] == L'\0' );
    TESTCASE( wcsncat( s, L"\0", 10 ) == s );
    TESTCASE( s[5] == L'\0' );
    TESTCASE( s[6] == L'e' );
    TESTCASE( wcsncat( s, wabcde, 0 ) == s );
    TESTCASE( s[5] == L'\0' );
    TESTCASE( s[6] == L'e' );
    TESTCASE( wcsncat( s, wabcde, 3 ) == s );
    TESTCASE( s[5] == L'a' );
    TESTCASE( s[7] == L'c' );
    TESTCASE( s[8] == L'\0' );
    return TEST_RESULTS;
}
