﻿/* $Id$ */

/* vfprintf( FILE *, const char *, va_list )

   This file is part of the Public Dotest_vfprintf C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include <stdio.h>
#include <stdarg.h>
#include <stdint.h>
#include <limits.h>


#define _PDCLIB_FILEID "stdio/vfprintf.c"
#define _PDCLIB_FILEIO
#include <stddef.h>
#include "pdclib-tests/pdclib-tests.h"

static int testprintf( FILE * stream, const char * format, ... )
{
    int i;
    va_list arg;
    va_start( arg, format );
    i = vfprintf( stream, format, arg );
    va_end( arg );
    return i;
}

int test_vfprintf( void )
{
    FILE * target;
    TESTCASE( ( target = tmpfile() ) != NULL );
#include "pdclib-tests/printf_testcases.h"
    TESTCASE( fclose( target ) == 0 );
    return TEST_RESULTS;
}

