﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#ifndef NTD_TESTS_H
#define NTD_TESTS_H 1

#include "ntd-test-libc.h"

void ntd_functions_dirent(void);
void ntd_dirent_bug_readdir1(void);
void ntd_dirent_list(void);
void ntd_dirent_tst_seekdir(void);

void ntd_functions_stdlib(void);

void ntd_functions_stdio(void);
int ntd_stdio_fgetpos( void );
int ntd_stdio_clearerr( void );
int ntd_stdio_fgets( void );
int ntd_stdio_fprintf( void );
int ntd_stdio_fputs( void );
int ntd_stdio_fread( void );
int ntd_stdio_freopen( void );
int ntd_stdio_fscanf( void );
int ntd_stdio_fseek( void );
int ntd_stdio_ftell( void );
int ntd_stdio_snprintf( void );
int ntd_stdio_sprintf( void );
int ntd_stdio_sscanf( void );
int ntd_stdio_ungetc( void );
int ntd_stdio_vfprintf( void );
int ntd_stdio_vfscanf( void );
int ntd_stdio_vsnprintf( void );
int ntd_stdio_vsprintf( void );
int ntd_stdio_vsscanf( void );
int ntd_stdio_rename( void );

void ntd_functions_stdlib( void );
int test_malloc_tests( void );
int test_random_r_tests( void );

void ntd_functions_string( void );
void test_fnmatch( void );
void ntd_test_memcpy( void ); /* A "test_memcpy" func name exists elsewhere */
void ntd_test_memccpy( void );

void ntd_functions_threads( void );
void test_pthread_affinity( void );
void test_pthread_attr_set_and_get( void );
void test_pthread_attr_setinheritsched( void );
void test_pthread_attr_setschedparam_1( void );
void test_pthread_attr_setschedparam_2( void );
void test_pthread_attr_setschedpolicy( void );
void test_pthread_attr_setscope( void );
void test_pthread_attr_setstack( void );
void test_pthread_barrier( void );
void test_pthread_cond_broadcast( void );
void test_pthread_cond_destroy( void );
void test_pthread_cond_init( void );
void test_pthread_cond_signal( void );
void test_pthread_cond_timedwait( void );
void test_pthread_cond_wait( void );
void test_pthread_condattr_setpshared( void );
void test_pthread_errno_locale( void );
void test_pthread_getschedparam( void );
void test_pthread_getspecific( void );
void test_pthread_join( void );
void test_pthread_key_create( void );
void test_pthread_key_delete( void );
void test_pthread_mutex_destroy( void );
void test_pthread_mutex_init( void );
void test_pthread_mutex_lock( void );
void test_pthread_mutex_trylock( void );
void test_pthread_mutex_trylock_yield( void );
void test_pthread_mutex_unlock( void );
void test_pthread_mutexattr_settype( void );
void test_pthread_once( void );
void test_pthread_rwlock_basic( void );
void test_pthread_rwlock_trylock( void );
void test_pthread_setname_np( void );
void test_pthread_setspecific( void );
void test_pthread_validate_filelocks( void );
void test_sched_get_priority_max( void );
void test_sched_yield( void );
void test_sem_destroy( void );
void test_sem_getvalue( void );
void test_sem_post( void );
void test_sem_timedwait( void );
void test_sem_trywait( void );
void test_sem_wait( void );

void ntd_functions_unistd( void );
void test_ftruncate( void );

void ntd_extended_tests(void);
void ntd_tests( void );

#define NTD_TEST_RESULTS NTD_CURRENT_FAIL_COUNT()

/* Include printf() / scanf() test macros if required */
//#if defined( _PDCLIB_FILEIO ) || defined( _PDCLIB_STRINGIO )
//#include "pdclib-tests/_PDCLIB_iotest.h"
//#endif

//#define REGTEST 1

#endif /* NTD_TESTS_H */
