﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h" /* Needs to be included before 'locale.h' for '_GNU_SOURCE' */
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>
#include <assert.h>
#include <errno.h>
#include <locale.h>
#include <inttypes.h>

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */
  #include "ntd-tests/ntd-tests.h"
#ifdef __cplusplus
}
#endif /* __cplusplus */

/* const size_t           ThreadStackSize = 8192; */
/* NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack1[ ThreadStackSize ]; */
/* NN_OS_ALIGNAS_THREAD_STACK char  g_ThreadStack2[ ThreadStackSize ]; */


typedef struct thread_arg {
    const char *name;
    int         index;
} thread_arg;

static pthread_t  g_Thread1;
static pthread_t  g_Thread2;

static void *ThreadFunction1(void *in_arg)
{
    thread_arg *arg = (thread_arg *) in_arg;
    errno = 0;
    pthread_t me = pthread_self();
    locale_t old, dup, old2, dup2, use_old, use_dup;
    const char *thread_var = NULL;
    int t_index = 0;
    char buf[32];
    const char *old_name, *dup_name, *old2_name, *dup2_name, *use_old_name, *use_dup_name;
    bool test1, test2;

    thread_var = arg->name;
    t_index = arg->index;
    TESTCASE_MESSAGE(t_index > 0, "unexpected thread %s, expected t_index(%d) > 0", thread_var, t_index);
    if (t_index <= 0) return NULL;

    errno = 0;
    errno = t_index;

    TESTWARN("setting errno to %d for %s", (uintptr_t)arg, thread_var);

    TESTWARN("yielding %s", thread_var);
    sched_yield();

    TESTCASE_MESSAGE(errno != 0, "errno is %d thread = %s", errno, thread_var);

    old = uselocale(NULL);
    dup = duplocale(old);
    TESTCASE_MESSAGE(dup != old, "thread %s, dup is %p, old is %p", thread_var, dup, old);

    TESTWARN("yielding %s", thread_var);
    sched_yield();

    old2 = uselocale(NULL);
    uselocale(dup);
    TESTCASE_MESSAGE(old == old2, "thread %s, old = %p, old2 = %p, dup = %p",
        thread_var, old, old2, dup);

    TESTWARN("yielding %s", thread_var);
    sched_yield();

    dup2 = uselocale(NULL);
    uselocale(old);
    old2 = uselocale(NULL);
    TESTCASE_MESSAGE(old == old2 && dup == dup2,
        "thread %s, old is %p old2 is %p, dup is %p dup2 is %p",
        thread_var, old, old2, dup, dup2);

    TESTWARN("yielding %s", thread_var);
    sched_yield();

    use_old = uselocale(dup);
    TESTWARN("yielding %s", thread_var);
    sched_yield();

    use_dup = uselocale(use_old);
    TESTCASE_MESSAGE(dup == use_dup,
        "thread %s dup is %p, use_dup is %p", thread_var, dup, use_dup);

    TESTCASE_MESSAGE(use_old == old && use_old == LC_GLOBAL_LOCALE,
        "thread %s use_old = %p, old = %p, LC_GLOBAL_LOCALE = %p",
            thread_var, use_old, old, LC_GLOBAL_LOCALE);

    return NULL;
}


void test_pthread_errno_locale()
{
    int ret=0;

    NTD_TEST_GROUP_START("errno_locale", 3);

    thread_arg arg1 = {"g_Thread1", 1};
    ret = pthread_create(&g_Thread1, NULL, &ThreadFunction1, (void *)&arg1);
    TESTCASE_MESSAGE(ret == 0, "Cannot create g_Thread1");
    if (ret != 0) return;
    TESTWARN("g_Thread1 = %p", g_Thread1);


    thread_arg arg2 = {"g_Thread2", 2};
    ret = pthread_create(&g_Thread2, NULL, &ThreadFunction1, (void *)&arg2);
    TESTCASE_MESSAGE(ret == 0, "Cannot create g_Thread2");
    if (ret != 0) return;
    TESTWARN("g_Thread1 = %p", g_Thread2);

    TESTWARN("calling pthread_join(%p, NULL)", g_Thread1);
    ret = pthread_join(g_Thread1, NULL);
    TESTCASE_MESSAGE(ret == 0, "pthread_join(g_Thread1(%p), NULL) failed %d",
        g_Thread1, ret);

    TESTWARN("calling pthread_join(%p, NULL)", g_Thread2);
    ret = pthread_join(g_Thread2, NULL);
    TESTCASE_MESSAGE(ret == 0, "pthread_join(g_Thread2(%p), NULL) failed %d",
        g_Thread2, ret);

    NTD_TEST_GROUP_END("errno_locale", 3);
}
