﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <stdlib.h>
#include <pthread.h>
#include "ntd-tests/ntd-tests.h"

#if defined(__NX__)
  #include <nnc/os.h>
  #include <nnc/os/os_ThreadApi.h>

  #define MIN_ALIGN NN_OS_THREAD_STACK_ALIGNMENT
#else
  #define MIN_ALIGN 0x1000    /* 4K */
#endif /* __NX__ */

static size_t          mystacksize = 2 * MIN_ALIGN;
static void            *mystackaddr;

static void *thread_entry(void *arg)
{
#if 0
    bool test;
    nn::os::ThreadType *horizon_thread = (nn::os::ThreadType*)pthread_self();
    size_t stacksize = horizon_thread->_stackSize;
    void * stackaddr = horizon_thread->_originalStack;
    TESTWARN("in thread_entry\n");
    test = (stackaddr == mystackaddr);
    TESTCASE( test );
    if (!test) {
        TESTWARN("Horizon returned stackaddr 0x%x but expected 0x%x\n", stackaddr, mystackaddr);
    } else {
        TESTWARN("Horizon returned stackaddr successfully\n");
    }
    test = (stacksize == mystacksize);
    TESTCASE( test );
    if (!test) {
        TESTWARN("Horizon returned stackaddr 0x%x but expected 0x%x\n", stacksize, mystacksize);
    } else {
        TESTWARN("Horizon returned stacksize successfully\n");
    }
#endif
    return NULL;
}

void test_pthread_attr_setstack()
{
    pthread_attr_t  attr;
    int             rc;
    pthread_t       pthread;
    void            *myallocation = 0;
    void            *stackaddr;
    size_t          stacksize;
    bool            test;

    NTD_TEST_GROUP_START("attr_setstack", 3);

    rc = pthread_attr_init(&attr);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_init() returned %d expected 0", rc);

    /* allocate a larger than needed stack so I can align it to 4K */
    mystackaddr = myallocation = malloc(mystacksize + (MIN_ALIGN - 1));
    if (mystackaddr != NULL) {
        TESTWARN("Align mystackaddr to nearest 0x%x boundary.\n", MIN_ALIGN);
        mystackaddr = (void *)(((size_t)mystackaddr + (MIN_ALIGN - 1)) & ~(MIN_ALIGN - 1));
        test = ( !((size_t)mystackaddr & (MIN_ALIGN - 1)) );
        TESTCASE( test );
        if (!test) {
            TESTWARN("Aligning mystackaddr failed.");
            return;
        }
    } else {
        TESTWARN("Unable to allocate stack.");
        return;
    }

    TESTWARN("Attempting to set stackaddr to mystackaddr and stacksize to 0x%x\n", mystacksize);
    rc = pthread_attr_setstack(&attr, mystackaddr, mystacksize);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setstack() returned %d expected 0", rc);
    if (rc == 0) {
        TESTWARN("pthread_attr_setstack set stackaddr to mystackaddr and stacksize to 0x%x\n", mystacksize);

        rc = pthread_attr_getstack(&attr, &stackaddr, &stacksize);
        TESTCASE_MESSAGE(rc == 0, "pthread_attr_setstack() returned %d expected 0", rc);
        if (rc == 0) {
            test = (stackaddr == mystackaddr);
            TESTCASE( test );
            if (!test) {
                TESTWARN("pthread_attr_getstack returned stackaddr 0x%x but expected 0x%x\n", stackaddr, mystackaddr);
            } else {
                TESTWARN("pthread_attr_getstack returned stackaddr successfully\n");
            }
            test = (stacksize == mystacksize);
            TESTCASE( test );
            if (!test) {
                TESTWARN("pthread_attr_getstack returned stackaddr 0x%x but expected 0x%x\n", stacksize, mystacksize);
            } else {
                TESTWARN("pthread_attr_getstack returned stacksize successfully\n");
            }
            rc = pthread_create(&pthread, &attr, thread_entry, NULL);
            TESTCASE_MESSAGE(rc == 0, "pthread_create() returned %d expected 0", rc);

            if (!rc) {
                rc = pthread_join(pthread, NULL);
                TESTCASE_MESSAGE(rc == 0, "pthread_join() returned %d expected 0", rc);
            }
        }
    }

    rc = pthread_attr_destroy(&attr);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_destroy() returned %d expected 0", rc);

    if (myallocation)
        free(myallocation);

    NTD_TEST_GROUP_END("attr_setstack", 3);
}
