﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "thread_test.h"
/* The header above includes other headers this file needs:
     #include <stdio.h>
*/
#include <pthread.h>


static const char * inherit_sched_string(pthread_attr_t *attr) {
  int rc;
  int inheritsched;
  rc = pthread_attr_getinheritsched(attr, &inheritsched);
  TESTCASE_MESSAGE(rc == 0, "pthread_attr_getinheritsched(%p, %p) returned %d expected 0",
    attr, &inheritsched, rc);

  switch(inheritsched) {
  case PTHREAD_EXPLICIT_SCHED:
    return "Inherit Sched - PTHREAD_EXPLICIT_SCHED";
    break;
  case PTHREAD_INHERIT_SCHED:
    return "Inherit Sched - PTHREAD_INHERIT_SCHED";
    break;
  default:
    return "Invalid inheritsched attribute!\n";
  }
}

void test_pthread_attr_setinheritsched(void)
{
    int                   rc=0;
    pthread_attr_t        attr;
    bool                  test;

    NTD_TEST_GROUP_START("attr_setinheritsched", 3);

    rc = pthread_attr_init(&attr);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_init() returned %d expected 0", rc);

    inherit_sched_string(&attr);

    rc = pthread_attr_setinheritsched(&attr, PTHREAD_INHERIT_SCHED);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setinheritsched() returned %d expected 0 %s",
        rc, inherit_sched_string(&attr));

    rc = pthread_attr_setinheritsched(&attr, PTHREAD_EXPLICIT_SCHED);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_setinheritsched() returned %d expected 0 %s",
        rc, inherit_sched_string(&attr));

#if TEST_UNSUPPORTED_FEATURES
    rc = pthread_attr_setinheritsched(&attr, 2);
    TESTCASE_MESSAGE(rc == EINVAL,
        "pthread_attr_setinheritsched(%p, 2) returned %d expected EINVAL(%d) %s",
        &attr, rc, inherit_sched_string(&attr) );

    rc = pthread_attr_setinheritsched(&attr, -1);
    TESTCASE_MESSAGE(rc == EINVAL,
        "pthread_attr_setinheritsched(%p, -1) returned %d expected EINVAL(%d) %s",
        &attr, rc, inherit_sched_string(&attr) );


    rc = pthread_attr_setinheritsched(&attr, 0xDEADDEAD);
    TESTCASE_MESSAGE(rc == EINVAL,
        "pthread_attr_setinheritsched(%p, 0xDEADDEAD) returned %d expected EINVAL(%d) %s",
        &attr, rc, inherit_sched_string(&attr) );
#endif

    rc = pthread_attr_destroy(&attr);
    TESTCASE_MESSAGE(rc == 0, "pthread_attr_destroy() returned %d expected 0", rc);

    NTD_TEST_GROUP_END("attr_setinheritsched", 3);
}

#if 0
Debug Output:

Enter Testcase - QP0WTEST/TPSIS0
Inherit Sched - PTHREAD_EXPLICIT_SCHED
Inherit Sched - PTHREAD_INHERIT_SCHED
Main completed
#endif
