﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include <string.h>
#include <fnmatch.h>


#include "ntd-tests/ntd-tests.h"

void test_fnmatch( void )
{
    NTD_TEST_GROUP_START("fnmatch", 3);
    /* fnmatch() returns '0' if pattern matches string */
    TESTCASE( fnmatch("*tri*", "string", 0) == 0 );
    TESTCASE( fnmatch("a", "A", FNM_CASEFOLD) == 0 );
    TESTCASE( fnmatch("aaAA", "AaAa", FNM_CASEFOLD) == 0 );
    TESTCASE( fnmatch("[a]", "A", FNM_CASEFOLD) == 0 );
    TESTCASE( fnmatch("[!a]", "A", FNM_CASEFOLD) == FNM_NOMATCH );
    TESTCASE( fnmatch("[!A-C]", "b", FNM_CASEFOLD) == FNM_NOMATCH );
    TESTCASE( fnmatch("[!a-c]", "B", FNM_CASEFOLD) == FNM_NOMATCH );

    /* FNM_NOCASE likely won't compile. 'FNM_CASEFOLD' has likely taken its place */
    /*fnmatch_ret_val = fnmatch("a", "A", FNM_NOCASE);
    TESTCASE( fnmatch_ret_val == 0 );*/

    NTD_TEST_GROUP_END("fnmatch", 3);
}
