﻿#ifndef NTD_STDIO_TEST_H
#define NTD_STDIO_TEST_H 1

#include "ntd-test-libc.h"

#define TEST 1
#define SKIP_MALLOC 1

/* Some strings used for <string.h> and <stdlib.h> testing. */
static char const abcde[] = "abcde";
static char const abcdx[] = "abcdx";
static char const teststring[] = "1234567890\nABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n";

static wchar_t const wabcde[] = L"abcde";
static wchar_t const wabcdx[] = L"abcdx";
static wchar_t const wteststring[] = L"1234567890\nABCDEFGHIJKLMNOPQRSTUVWXYZ\nabcdefghijklmnopqrstuvwxyz\n";

/* Temporary file names */
#if __NX__
static char const testfile_dir[]="host:/testing";
static char const testfile[]="host:/testing/testfile";
static char const testfile1[]="host:/testing/testfile1";
static char const testfile2[]="host:/testing/testfile2";
#else
static char const testfile_dir[]="testing";
static char const testfile[]="testing/testfile";
static char const testfile1[]="testing/testfile1";
static char const testfile2[]="testing/testfile2";
#endif

#define NO_TESTDRIVER 0

static int TEST_RESULTS = 0;

/* Include printf() / scanf() test macros if required */

#if defined( NTD_FILEIO ) || defined( NTD_STRINGIO )
#include "ntd_stdio_iotest.h"
#endif

#define REGTEST 1

#endif /* NTD_STDIO_TEST_H */
