﻿/* $Id$ */

/* freopen( const char *, const char *, FILE * )

   This file is part of the Public Dotest_freopen C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <string.h>


#include "ntd_stdio_tests.h"

#if __NX__
static const char *tempfilename1 = "host:/ntd-test-freopen1.txt";
static const char *tempfilename2 = "host:/ntd-test-freopen2.txt";
static const char *tempfilename3 = "host:/ntd-test-freopen3.txt";
#else
static const char *tempfilename1 = "ntd-test-freopen1.txt";
static const char *tempfilename2 = "ntd-test-freopen2.txt";
static const char *tempfilename3 = "ntd-test-freopen3.txt";
#endif

int ntd_stdio_freopen( void )
{
    FILE * fin;
    FILE * fin2;
    FILE * fout;
    FILE * fout2;

    if (!access(tempfilename1, F_OK)) {
    	TESTCASE( remove( tempfilename1 ) == 0 );
    }
    if (!access(tempfilename2, F_OK)) {
    	TESTCASE( remove( tempfilename2 ) == 0 );
    }
    if (!access(tempfilename3, F_OK)) {
    	TESTCASE( remove( tempfilename3 ) == 0 );
    }

    TESTCASE( ( fin = fopen( tempfilename1, "wb+" ) ) != NULL );
    TESTCASE( fputc( 'x', fin ) == 'x' );
    TESTCASE( fclose( fin ) == 0 );

    TESTCASE( ( fin2 = fopen( tempfilename2, "wb+" ) ) != NULL );
    TESTCASE( fputc( 'y', fin2 ) == 'y' );
    TESTCASE( fclose( fin2 ) == 0 );
    fin2 = fopen( tempfilename2, "r" );
    TESTCASE_MESSAGE( fin2 != NULL,
        "fopen('%s', \"r\") == %p, errno = %d(%s)",
        tempfilename2, fin2, errno, strerror(errno));


    TESTCASE( ( fin = freopen( tempfilename1, "rb", fin2 ) ) != NULL );
    TESTCASE( getc(fin) == 'x' );

    TESTCASE( ( fin = freopen( tempfilename2, "rb", fin2 ) ) != NULL );
    TESTCASE( getc(fin) == 'y' );

    TESTCASE( ( fout2 = fopen( tempfilename1, "r" ) ) != NULL );

    TESTCASE( ( fout = freopen( tempfilename3, "wb+", fout2 ) ) != NULL );
    TESTCASE( putc( 'z', fout ) == 'z' );
    rewind( fout );
    TESTCASE( fgetc( fout ) == 'z' );

    TESTCASE( fclose( fin ) == 0 );
    TESTCASE( fclose( fout ) == 0 );
    // TESTCASE( remove( testfile1 ) == 0 );
    // TESTCASE( remove( testfile2 ) == 0 );

    return TEST_RESULTS;
}

