﻿/* $Id$ */

/* fputs( const char *, FILE * )

   This file is part of the Public Dotest_fputs C Library (PDCLib).
   Permission is granted to use, modify, and / or redistribute at will.
*/

#include "ntd-test-libc.h"
#include <stdio.h>
#include <unistd.h>

#include "ntd_stdio_tests.h"

#if __NX__
static const char *tempfilename = "host:/ntd-test-fputs.txt";
#else
static const char *tempfilename = "ntd-test-fputs.txt";
#endif

int ntd_stdio_fputs( void )
{
    char const * const message = "SUCCESS testing fputs()";
    FILE * fh;
    if (!access(tempfilename, F_OK)) {
    	TESTCASE( remove( tempfilename ) == 0 );
    }

    TESTCASE( ( fh = fopen( tempfilename, "wb+" ) ) != NULL );
    // TESTCASE( ( fh = tmpfile() ) != NULL );
    TESTCASE( fputs( message, fh ) >= 0 );
    rewind( fh );
    for ( size_t i = 0; i < 23; ++i )
    {
        TESTCASE( fgetc( fh ) == message[i] );
    }
    TESTCASE( fclose( fh ) == 0 );
    return TEST_RESULTS;
}


