﻿#include "ntd-test-libc.h"
#include <stdio.h>
#include <dirent.h>
#include <stdlib.h>
#include <errno.h>
#include <string.h>
#include <sys/stat.h>

#if __NX__
#define tempdirname "host:/tst_seekdir"
static const char *files[] = {
    "host:/tst_seekdir/file_a",
    "host:/tst_seekdir/file_b",
    "host:/tst_seekdir/file_c",
    "host:/tst_seekdir/file_d",
    "host:/tst_seekdir/file_e",
    "host:/tst_seekdir/file_f"
};
#else
#define tempdirname "tst_seekdir"
static const char *files[] = {
    "tst_seekdir/file_a",
    "tst_seekdir/file_b",
    "tst_seekdir/file_c",
    "tst_seekdir/file_d",
    "tst_seekdir/file_e",
    "tst_seekdir/file_f"
};
#endif

static const char *file_names[] = {
    "file_a",
    "file_b",
    "file_c",
    "file_d",
    "file_e",
    "file_f"
};

static void setup_test_tst_seekdir()
{
    int result = mkdir(tempdirname, 0777);
    TESTCASE_MESSAGE((result == 0 || (result == -1 && errno == EEXIST)),
        "mkdir('%s') result = %d errno = %s(%d)",
        tempdirname, result, strerror(errno), errno);
    int i;
    for (i = 0; i < sizeof(files) / sizeof(files[0]); i++) {
        FILE *f = fopen(files[i],"w");
        TESTCASE(f != NULL);
        if (f != NULL) {
            int j;
            for (j = 0; j < 1000; j++) {
                fprintf(f, "%04d:%08x\n", j, (i << 16) + j);
            }
            fclose(f);
        }
    }
}

void ntd_dirent_tst_seekdir(void)
{
  DIR * dirp;
  long int save3 = 0;
  long int neg=-100;
  long int cur;
  int i = 0;
  int result = 0;
  struct dirent *dp;
  long int save0;
  long int rewind;

  setup_test_tst_seekdir();
  dirp = opendir (tempdirname);
  TESTCASE_MESSAGE(dirp != NULL, "opendir('%s') failed", tempdirname);
  if (dirp == NULL) return;
  save0 = telldir (dirp);
  TESTCASE_MESSAGE(save0 >= 0, "telldir() failed %ld, errno = %d", save0, errno);
  for (dp = readdir (dirp); dp != NULL; dp = readdir (dirp)) {
      /* save position 3 (after fourth entry) */
      if (i++ == 3) {
          save3 = telldir (dirp);
          TESTWARN("save3 = %ld\n", save3);
          TESTCASE_MESSAGE(save3 >= 0, "telldir() after 4th entry failed %ld errno = %d",
            save3, errno);
      }
      TESTWARN("%d:%s\n", i, dp->d_name);
      TESTWARN("  d_ino    = %ld\n", (long int) dp->d_ino);
      TESTWARN("  d_off    = %ld\n", (long int) dp->d_off);
      TESTWARN("  d_reclen = %d\n", (int) dp->d_reclen);
      TESTWARN("  d_type   = %d\n", (int) dp->d_type);
      TESTWARN("  telldir() = %ld\n", (long int) telldir(dirp));

      TESTWARN("%s\n", dp->d_name);
      if (i == 400) break;
    }

  TESTWARN("going back past 4-th entry...\n");

  errno = 0;
  /* go back to saved entry */
  seekdir(dirp, save3);

  /* Check whether telldir equals to save3 now.  */
  cur = telldir (dirp);
  TESTCASE_MESSAGE(cur == save3, "seekdir (dirp, %ld); telldir (dirp) == %ld errno = %s(%d)",
    save3, cur, strerror(errno), errno);

  /* print remaining files (3-last) */
  i = 4;
  for (dp = readdir (dirp); dp != NULL; dp = readdir (dirp)) {
    TESTWARN ("%s\n", dp->d_name);
    TESTWARN("%d:%s\n", ++i, dp->d_name);
    TESTWARN("  d_ino    = %ld\n", (long int) dp->d_ino);
    TESTWARN("  d_off    = %ld\n", (long int) dp->d_off);
    TESTWARN("  d_reclen = %d\n", (int) dp->d_reclen);
    TESTWARN("  d_type   = %d\n", (int) dp->d_type);
    TESTWARN("  telldir() = %ld\n", (long int) telldir(dirp));
  }

  /* Check negative seekdir */
  seekdir(dirp, neg);
  cur = telldir (dirp);
  TESTCASE_MESSAGE(cur == -1 && errno == EINVAL, "seekdir (dirp, %ld) return %ld expect -1. errno = %s(%d)",
    neg, cur, strerror(errno), errno);

  /* Check rewinddir */
  rewinddir (dirp);
  rewind = telldir (dirp);
  TESTCASE_MESSAGE(rewind >= 0, "rewind(dirp), telldir(dirp) < 0, returned %ld, errno = %d",
    rewind, errno);
  TESTCASE_MESSAGE(save0 == rewind, "rewinddir didn't reset directory stream save0 (%ld) != rewind (%ld) errno = %d",
    save0, rewind, errno);

  result = closedir (dirp);
  TESTCASE_MESSAGE(result == 0, "closedir(dirp) failed returned %d errno = %d",
    result, errno);
}
