﻿/*******************************************************************************

  This file contains a series of tests for malloc()

*******************************************************************************/

#include "errno_error_triggers.h"
#include <stdlib.h> /* realloc(), malloc(), calloc(), free() */
#include <string.h> /* strcpy(), strcmp() */
#include <errno.h> /* errno codes */
#include "test.h" /* t_error(), t_status */

#include "malloc_helper_functions.h" /* is_ptr_null() */

/*{{{{------------------------------------------------------------------------*/
/* Try allocating too much memory and causing malloc() to fail */
void test_trigger_enomem(const char *testname)
{
  TriggerErrno(ENOMEM, testname);
}
/*------------------------------------------------------------------------}}}}*/



int main(void)
{
  test_trigger_enomem("test_trigger_enomem");

  return t_status;
}
