﻿/*******************************************************************************

  This file contains a series of tests for clock()

*******************************************************************************/

#include "ntd_extended_test.h"
#include <time.h> /* clock(), clock_t, CLOCKS_PER_SEC, time(), time_t, localtime() */
#include <stdlib.h> /* malloc() */
#include <stdio.h>  /* printf() */
#include <unistd.h> /* sleep() */

#define VALID_TIME(t) TESTCASE(t != -1);

/*{{{{------------------------------------------------------------------------*/
/* Make the program do nothing for the specified amount of seconds. Helps test
   if time is actually passing correctly.
   This version of waste_time() doesn't use sleep() since it's POSIX. Am keeping
   it around in case it becomes useful later. Am using time() in this file
   and using clock() in time.c in order to test against each other and to try
   having a reliable means of pausing a program for a consistent amount of time */

static void waste_time_using_time(unsigned int seconds, const char *testname)
{
  time_t current_time;
  int when_to_stop;

  current_time = time(NULL);
  when_to_stop = current_time + (time_t)seconds;

  while (current_time < when_to_stop)
  {
    current_time = time(NULL);
    VALID_TIME((int)current_time);
  }
}
/*------------------------------------------------------------------------}}}}*/




/*{{{{------------------------------------------------------------------------*/
/* Make sure time passes in between a time-consuming operation to help make
   sure clock() is returning accurate values */

static void test_time_passing()
{
  clock_t begin, end;
  double seconds; /* Amount of time (in seconds) it took between 'begin' and 'end' */
  unsigned int seconds_to_sleep;
  seconds_to_sleep = 3;

  begin = clock();

  /*waste_time_using_time(seconds_to_sleep, testname);*/
  waste_time_using_sleep(seconds_to_sleep, testname);

  end = clock();

  VALID_TIME((int)begin);
  VALID_TIME((int)end);

  /* Since the accuracy of the exact amount of seconds the program slept can
     vary, simply check that the end time is greater than the beginning time */
  TESTCASE_MESSAGE(end > begin, "Expected begin = %d, less than end = %d",
        begin, end);
}
/*------------------------------------------------------------------------}}}}*/




/*{{{{------------------------------------------------------------------------*/
/* Make sure the clock() function will even return anything expected at all */

static void test_clock_return_value()
{
  clock_t ret_val;
  ret_val = clock();

  VALID_TIME((int)ret_val);

  /* The C Standard recommends dividing the return value of clock() by this
     #define'd macro to convert the value into seconds, so it would be expected
     for the definition to be about 1000 or 10,000 */
  TESTCASE_MESSAGE(CLOCKS_PER_SEC > 0,
    "CLOCKS_PER_SEC doesn't seem to be defined properly in function '%s'. "
            "Got %d, expected > 0\n", __func__, CLOCKS_PER_SEC);
  }
}
/*------------------------------------------------------------------------}}}}*/




int ntd_extended_clock()
{
    NTD_TEST_GROUP_START("clock", 2);

    test_clock_return_value();
    test_time_passing();

    return NTD_TEST_GROUP_END("clock", 2);
}
