﻿#define _XOPEN_SOURCE 700
#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct di_d t[] = {
#include "sanity/yn.h"
#include "special/yn.h"
};

int testyn(void)
{
    #pragma STDC FENV_ACCESS ON
    double y;
    float d;
    int e, i, err = 0;
    struct di_d *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        y = yn(p->i, p->x);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        if (!checkexcept(e, p->e, p->r)) {
            printf("%s:%d: bad fp exception: %s yn(%lld, %a)=%a, want %s",
                short_path(p->file), p->line, rstr(p->r), p->i, p->x, p->y, estr(p->e));
            printf(" got %s\n", estr(e));
            err++;
        }
        d = ulperr(y, p->y, p->dy);
        if ((!(p->x < 0) && !checkulp(d, p->r)) || (p->x < 0 && !isnan(y) && y != -inf)) {
            printf("%s:%d: %s yn(%lld, %a) want %a got %a, ulperr %.3f = %a + %a\n",
                short_path(p->file), p->line, rstr(p->r), p->i, p->x, p->y, y, d, d-p->dy, p->dy);
            err++;
            TESTCASE_FAILURE();
        } else {
            TESTCASE_SUCCESS();
        }
    }
    return !!err;
}
