﻿#include "ntd-test-libc.h"
#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct fff_f t[] = {
#include "sanity/fmaf.h"
#include "special/fmaf.h"
};

int testfmaf(void)
{
    #pragma STDC FENV_ACCESS ON
    float y;
    float d;
    int e, i, err = 0;
    struct fff_f *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        y = fmaf(p->x, p->x2, p->x3);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        /* do not check inexact by default */
#if defined CHECK_INEXACT || defined CHECK_INEXACT_OMISSION
        int passed = (t_checkexceptall(e, p->e, p->r));
        #define ESTRS_CUSTOM(e,p) ESTRS_ALL(e,p)
#else
        int passed = (t_checkexceptall(e|INEXACT, p->e|INEXACT, p->r));
        #define ESTRS_CUSTOM(e,p) ESTRS_NO_INEXACT(e,p)
#endif
        char *msg = NULL;
        asprintf(&msg, "bad fp exception: %s fmaf(%a,%a,%a)=%a, %s",
                rstr(p->r), p->x, p->x2, p->x3, p->y, ESTRS_CUSTOM(e,p));
        if (p->expect_failure) {
            NTD_TESTCASE_KNOWN_FAILURE(p->fail_msg, passed, p->file, p->line, msg);
        } else {
            if (!passed) err++;
            NTD_TESTCASE(passed, p->file, p->line, msg);
        }
        free(msg);
        d = ulperrf(y, p->y, p->dy);
        if (!checkcr(y, p->y, p->r)) {
            printf("%s:%d: %s fmaf(%a,%a,%a) want %a got %a ulperr %.3f = %a + %a\n",
                short_path(p->file), p->line, rstr(p->r), p->x, p->x2, p->x3, p->y, y, d, d-p->dy, p->dy);
            err++;
        }
    }
    return !!err;
}
