﻿#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct ll_l t[] = {
#if LDBL_MANT_DIG == 53
#include "sanity/fdim.h"
#include "special/fdim.h"

#elif LDBL_MANT_DIG == 64
#include "sanity/fdiml.h"
#include "special/fdiml.h"

#endif
};

int testfdiml(void)
{
#if 1
    return test_ll_l_checkexceptall(&fdiml, "fdiml", t, sizeof t/sizeof *t);
#else
    #pragma STDC FENV_ACCESS ON
    long double y;
    float d;
    int e, i, err = 0;
    struct ll_l *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        y = fdiml(p->x, p->x2);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        if (!checkexceptall(e, p->e, p->r)) {
            printf("%s:%d: bad fp exception: %s fdiml(%La,%La)=%La, want %s",
                short_path(p->file), p->line, rstr(p->r), p->x, p->x2, p->y, estr(p->e));
            printf(" got %s\n", estr(e));
            err++;
        }
        d = ulperrl(y, p->y, p->dy);
        if (!checkcr(y, p->y, p->r)) {
            printf("%s:%d: %s fdiml(%La,%La) want %La got %La ulperr %.3f = %a + %a\n",
                short_path(p->file), p->line, rstr(p->r), p->x, p->x2, p->y, y, d, d-p->dy, p->dy);
            err++;
        }
    }
    return !!err;
#endif
}
