﻿// asin.testdata
// copyright (C) 2005 F. de Dinechin, Ch. Q. Lauter and V. Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x0p+0,          0x0p+0, 0) // +0 -> +0
T(RN,                 -0x0p+0,                 -0x0p+0,          0x0p+0, 0) // -0 -> -0
T(RN,                  0x1p+0,    0x1.921fb54442d18p+0,  -0x1.1a6264p-2, INEXACT) // +1 -> RN(Pi/2)
T(RN,                 -0x1p+0,   -0x1.921fb54442d18p+0,   0x1.1a6264p-2, INEXACT) // -1 -> RN(-Pi/2)
T(RN,    0x1.0000000000001p+0,                     nan,          0x0p+0, INVALID) // +1 + 1ulp -> NaN the first one
T(RN,   -0x1.0000000000001p+0,                     nan,          0x0p+0, INVALID) // -1 - 1ulp -> NaN the first one
// Worst cases
T(RN,   0x1.dfffffffff02ep-20,   0x1.e0000000001c2p-20,       0x1.8p-74, INEXACT)
T(RU,    0x1.e9950730c4696p-2,    0x1.fe767739d0f6ep-2,          0x1p+0, INEXACT)
T(RD,    0x1.e9950730c4696p-2,    0x1.fe767739d0f6dp-2,     -0x1.16p-66, INEXACT)
T(RZ,    0x1.e9950730c4696p-2,    0x1.fe767739d0f6dp-2,     -0x1.16p-66, INEXACT)
// Cases around the interval bounds in the implementation
// A VIRER: CA CORRESPOND PLUS A LA NOUVELLE IMPLEMENTATION
// SI ON VEUT LAISSER LES TESTS AUTOUR DES BORNES JE PEUX LES FOURNIR
T(RN,            0x1.7ae14p-3,    0x1.7d1336cab9375p-3,  -0x1.cff856p-2, INEXACT) // BOUND 1
T(RN,            0x1.32e91p-2,    0x1.37b3a3331c2acp-2,    -0x1.63ecp-4, INEXACT) // BOUND 2
T(RU,            0x1.9ca24p-2,    0x1.a8b4aab3277c6p-2,   0x1.5ab7cep-2, INEXACT) // BOUND 3
T(RN,            0x1.f90b3p-2,    0x1.08134b1b5a263p-1,   -0x1.257b8p-3, INEXACT) // BOUND 4
T(RU,            0x1.23adcp-1,    0x1.3655b073f2f1dp-1,   0x1.81c296p-2, INEXACT) // BOUND 5
T(RU,            0x1.4781dp-1,    0x1.635bace48ee61p-1,   0x1.0ef3e2p-2, INEXACT) // BOUND 6
T(RN,            0x1.647bbp-1,    0x1.8a5384e186e62p-1,   -0x1.f52c6p-4, INEXACT) // BOUND 7
T(RU,            0x1.7bc81p-1,    0x1.abdfcf76e4f11p-1,   0x1.de7458p-4, INEXACT) // BOUND 8
T(RU,            0x1.8f5c2p-1,     0x1.ca1195024c02p-1,    0x1.2bb9ap-2, INEXACT) // BOUND 9
T(RN,    0x1.7ae1400000001p-3,    0x1.7d1336cab9376p-3,  -0x1.e1f4cep-2, INEXACT) // BOUND 1 + 1ulp
T(RN,    0x1.32e9100000001p-2,    0x1.37b3a3331c2adp-2,  -0x1.14a5f2p-3, INEXACT) // BOUND 2 + 1ulp
T(RU,    0x1.9ca2400000001p-2,    0x1.a8b4aab3277c7p-2,   0x1.f7b6bep-3, INEXACT) // BOUND 3 + 1ulp
T(RN,    0x1.f90b300000001p-2,    0x1.08134b1b5a264p-1,    0x1.20b19p-2, INEXACT) // BOUND 4 + 1ulp
T(RU,    0x1.23adc00000001p-1,    0x1.3655b073f2f1ep-1,   0x1.479f02p-3, INEXACT) // BOUND 5 + 1ulp
T(RN,    0x1.4781d00000001p-1,    0x1.635bace48ee62p-1,   -0x1.29f0dp-5, INEXACT) // BOUND 6 + 1ulp
T(RN,    0x1.647bb00000001p-1,    0x1.8a5384e186e64p-1,    0x1.f01ccp-2, INEXACT) // BOUND 7 + 1ulp
T(RN,    0x1.7bc8100000001p-1,    0x1.abdfcf76e4f12p-1,  -0x1.7f3ae4p-2, INEXACT) // BOUND 8 + 1ulp
T(RN,    0x1.8f5c200000001p-1,    0x1.ca1195024c021p-1,  -0x1.38a214p-2, INEXACT) // BOUND 9 + 1ulp
T(RN,    0x1.7ae13ffffffffp-3,    0x1.7d1336cab9374p-3,  -0x1.bdfbdep-2, INEXACT) // BOUND 1 - 1ulp
T(RN,    0x1.32e90ffffffffp-2,    0x1.37b3a3331c2abp-2,  -0x1.3d1832p-5, INEXACT) // BOUND 2 - 1ulp
T(RU,    0x1.9ca23ffffffffp-2,    0x1.a8b4aab3277c5p-2,   0x1.b9943cp-2, INEXACT) // BOUND 3 - 1ulp
T(RN,    0x1.f90b2ffffffffp-2,    0x1.08134b1b5a263p-1,    0x1.b9d2fp-2, INEXACT) // BOUND 4 - 1ulp
T(RN,    0x1.23adbffffffffp-1,    0x1.3655b073f2f1bp-1,  -0x1.a04a54p-2, INEXACT) // BOUND 5 - 1ulp
T(RN,    0x1.4781cffffffffp-1,    0x1.635bace48ee5fp-1,  -0x1.bcda22p-2, INEXACT) // BOUND 6 - 1ulp
T(RN,    0x1.647baffffffffp-1,    0x1.8a5384e186e61p-1,    0x1.154d1p-2, INEXACT) // BOUND 7 - 1ulp
T(RN,    0x1.7bc80ffffffffp-1,    0x1.abdfcf76e4f0fp-1,   -0x1.918afp-2, INEXACT) // BOUND 8 - 1ulp
T(RN,    0x1.8f5c1ffffffffp-1,    0x1.ca1195024c01ep-1,  -0x1.bfaaacp-4, INEXACT) // BOUND 9 - 1ulp
T(RN,           -0x1.7ae14p-3,   -0x1.7d1336cab9375p-3,   0x1.cff856p-2, INEXACT) // -BOUND 1
T(RN,           -0x1.32e91p-2,   -0x1.37b3a3331c2acp-2,     0x1.63ecp-4, INEXACT) // -BOUND 2
T(RN,           -0x1.9ca24p-2,   -0x1.a8b4aab3277c6p-2,  -0x1.5ab7cep-2, INEXACT) // -BOUND 3
T(RN,           -0x1.f90b3p-2,   -0x1.08134b1b5a263p-1,    0x1.257b8p-3, INEXACT) // -BOUND 4
T(RN,           -0x1.23adcp-1,   -0x1.3655b073f2f1dp-1,  -0x1.81c296p-2, INEXACT) // -BOUND 5
T(RN,           -0x1.4781dp-1,   -0x1.635bace48ee61p-1,  -0x1.0ef3e2p-2, INEXACT) // -BOUND 6
T(RN,           -0x1.647bbp-1,   -0x1.8a5384e186e62p-1,    0x1.f52c6p-4, INEXACT) // -BOUND 7
T(RN,           -0x1.7bc81p-1,   -0x1.abdfcf76e4f11p-1,  -0x1.de7458p-4, INEXACT) // -BOUND 8
T(RN,           -0x1.8f5c2p-1,    -0x1.ca1195024c02p-1,   -0x1.2bb9ap-2, INEXACT) // -BOUND 9
T(RN,   -0x1.7ae1400000001p-3,   -0x1.7d1336cab9376p-3,   0x1.e1f4cep-2, INEXACT) // -BOUND 1 - 1ulp
T(RN,   -0x1.32e9100000001p-2,   -0x1.37b3a3331c2adp-2,   0x1.14a5f2p-3, INEXACT) // -BOUND 2 - 1ulp
T(RN,   -0x1.9ca2400000001p-2,   -0x1.a8b4aab3277c7p-2,  -0x1.f7b6bep-3, INEXACT) // -BOUND 3 - 1ulp
T(RN,   -0x1.f90b300000001p-2,   -0x1.08134b1b5a264p-1,   -0x1.20b19p-2, INEXACT) // -BOUND 4 - 1ulp
T(RN,   -0x1.23adc00000001p-1,   -0x1.3655b073f2f1ep-1,  -0x1.479f02p-3, INEXACT) // -BOUND 5 - 1ulp
T(RN,   -0x1.4781d00000001p-1,   -0x1.635bace48ee62p-1,    0x1.29f0dp-5, INEXACT) // -BOUND 6 - 1ulp
T(RN,   -0x1.647bb00000001p-1,   -0x1.8a5384e186e64p-1,   -0x1.f01ccp-2, INEXACT) // -BOUND 7 - 1ulp
T(RN,   -0x1.7bc8100000001p-1,   -0x1.abdfcf76e4f12p-1,   0x1.7f3ae4p-2, INEXACT) // -BOUND 8 - 1ulp
T(RN,   -0x1.8f5c200000001p-1,   -0x1.ca1195024c021p-1,   0x1.38a214p-2, INEXACT) // -BOUND 9 - 1ulp
T(RN,   -0x1.7ae13ffffffffp-3,   -0x1.7d1336cab9374p-3,   0x1.bdfbdep-2, INEXACT) // -BOUND 1 + 1ulp
T(RN,   -0x1.32e90ffffffffp-2,   -0x1.37b3a3331c2abp-2,   0x1.3d1832p-5, INEXACT) // -BOUND 2 + 1ulp
T(RN,   -0x1.9ca23ffffffffp-2,   -0x1.a8b4aab3277c5p-2,  -0x1.b9943cp-2, INEXACT) // -BOUND 3 + 1ulp
T(RN,   -0x1.f90b2ffffffffp-2,   -0x1.08134b1b5a263p-1,   -0x1.b9d2fp-2, INEXACT) // -BOUND 4 + 1ulp
T(RN,   -0x1.23adbffffffffp-1,   -0x1.3655b073f2f1bp-1,   0x1.a04a54p-2, INEXACT) // -BOUND 5 + 1ulp
T(RN,   -0x1.4781cffffffffp-1,   -0x1.635bace48ee5fp-1,   0x1.bcda22p-2, INEXACT) // -BOUND 6 + 1ulp
T(RN,   -0x1.647baffffffffp-1,   -0x1.8a5384e186e61p-1,   -0x1.154d1p-2, INEXACT) // -BOUND 7 + 1ulp
T(RN,   -0x1.7bc80ffffffffp-1,   -0x1.abdfcf76e4f0fp-1,    0x1.918afp-2, INEXACT) // -BOUND 8 + 1ulp
T(RN,   -0x1.8f5c1ffffffffp-1,   -0x1.ca1195024c01ep-1,   0x1.bfaaacp-4, INEXACT) // -BOUND 9 + 1ulp
T(RU,            0x1.7ae14p-3,    0x1.7d1336cab9376p-3,   0x1.1803d4p-1, INEXACT) // BOUND 1
T(RU,            0x1.32e91p-2,    0x1.37b3a3331c2adp-2,    0x1.d3828p-1, INEXACT) // BOUND 2
T(RN,            0x1.9ca24p-2,    0x1.a8b4aab3277c6p-2,   0x1.5ab7cep-2, INEXACT) // BOUND 3
T(RU,            0x1.f90b3p-2,    0x1.08134b1b5a264p-1,    0x1.b6a12p-1, INEXACT) // BOUND 4
T(RN,            0x1.23adcp-1,    0x1.3655b073f2f1dp-1,   0x1.81c296p-2, INEXACT) // BOUND 5
T(RN,            0x1.4781dp-1,    0x1.635bace48ee61p-1,   0x1.0ef3e2p-2, INEXACT) // BOUND 6
T(RU,            0x1.647bbp-1,    0x1.8a5384e186e63p-1,   0x1.c15a74p-1, INEXACT) // BOUND 7
T(RN,            0x1.7bc81p-1,    0x1.abdfcf76e4f11p-1,   0x1.de7458p-4, INEXACT) // BOUND 8
T(RN,            0x1.8f5c2p-1,     0x1.ca1195024c02p-1,    0x1.2bb9ap-2, INEXACT) // BOUND 9
T(RU,    0x1.7ae1400000001p-3,    0x1.7d1336cab9377p-3,   0x1.0f0598p-1, INEXACT) // BOUND 1 + 1ulp
T(RU,    0x1.32e9100000001p-2,    0x1.37b3a3331c2aep-2,   0x1.bad684p-1, INEXACT) // BOUND 2 + 1ulp
T(RN,    0x1.9ca2400000001p-2,    0x1.a8b4aab3277c7p-2,   0x1.f7b6bep-3, INEXACT) // BOUND 3 + 1ulp
T(RU,    0x1.f90b300000001p-2,    0x1.08134b1b5a264p-1,    0x1.20b19p-2, INEXACT) // BOUND 4 + 1ulp
T(RN,    0x1.23adc00000001p-1,    0x1.3655b073f2f1ep-1,   0x1.479f02p-3, INEXACT) // BOUND 5 + 1ulp
T(RU,    0x1.4781d00000001p-1,    0x1.635bace48ee63p-1,   0x1.ed60f2p-1, INEXACT) // BOUND 6 + 1ulp
T(RU,    0x1.647bb00000001p-1,    0x1.8a5384e186e64p-1,    0x1.f01ccp-2, INEXACT) // BOUND 7 + 1ulp
T(RU,    0x1.7bc8100000001p-1,    0x1.abdfcf76e4f13p-1,   0x1.40628ep-1, INEXACT) // BOUND 8 + 1ulp
T(RU,    0x1.8f5c200000001p-1,    0x1.ca1195024c022p-1,   0x1.63aef6p-1, INEXACT) // BOUND 9 + 1ulp
T(RU,    0x1.7ae13ffffffffp-3,    0x1.7d1336cab9375p-3,   0x1.210212p-1, INEXACT) // BOUND 1 - 1ulp
T(RU,    0x1.32e90ffffffffp-2,    0x1.37b3a3331c2acp-2,   0x1.ec2e7cp-1, INEXACT) // BOUND 2 - 1ulp
T(RN,    0x1.9ca23ffffffffp-2,    0x1.a8b4aab3277c5p-2,   0x1.b9943cp-2, INEXACT) // BOUND 3 - 1ulp
T(RU,    0x1.f90b2ffffffffp-2,    0x1.08134b1b5a263p-1,    0x1.b9d2fp-2, INEXACT) // BOUND 4 - 1ulp
T(RU,    0x1.23adbffffffffp-1,    0x1.3655b073f2f1cp-1,   0x1.2fdad6p-1, INEXACT) // BOUND 5 - 1ulp
T(RU,    0x1.4781cffffffffp-1,     0x1.635bace48ee6p-1,    0x1.2192fp-1, INEXACT) // BOUND 6 - 1ulp
T(RU,    0x1.647baffffffffp-1,    0x1.8a5384e186e61p-1,    0x1.154d1p-2, INEXACT) // BOUND 7 - 1ulp
T(RU,    0x1.7bc80ffffffffp-1,     0x1.abdfcf76e4f1p-1,   0x1.373a88p-1, INEXACT) // BOUND 8 - 1ulp
T(RU,    0x1.8f5c1ffffffffp-1,    0x1.ca1195024c01fp-1,   0x1.c80aaap-1, INEXACT) // BOUND 9 - 1ulp
T(RU,           -0x1.7ae14p-3,   -0x1.7d1336cab9375p-3,   0x1.cff856p-2, INEXACT) // -BOUND 1
T(RU,           -0x1.32e91p-2,   -0x1.37b3a3331c2acp-2,     0x1.63ecp-4, INEXACT) // -BOUND 2
T(RU,           -0x1.9ca24p-2,   -0x1.a8b4aab3277c5p-2,   0x1.52a41ap-1, INEXACT) // -BOUND 3
T(RU,           -0x1.f90b3p-2,   -0x1.08134b1b5a263p-1,    0x1.257b8p-3, INEXACT) // -BOUND 4
T(RU,           -0x1.23adcp-1,   -0x1.3655b073f2f1cp-1,   0x1.3f1eb4p-1, INEXACT) // -BOUND 5
T(RU,           -0x1.4781dp-1,    -0x1.635bace48ee6p-1,   0x1.78860ep-1, INEXACT) // -BOUND 6
T(RU,           -0x1.647bbp-1,   -0x1.8a5384e186e62p-1,    0x1.f52c6p-4, INEXACT) // -BOUND 7
T(RU,           -0x1.7bc81p-1,    -0x1.abdfcf76e4f1p-1,   0x1.c43174p-1, INEXACT) // -BOUND 8
T(RU,           -0x1.8f5c2p-1,   -0x1.ca1195024c01fp-1,    0x1.6a233p-1, INEXACT) // -BOUND 9
T(RU,   -0x1.7ae1400000001p-3,   -0x1.7d1336cab9376p-3,   0x1.e1f4cep-2, INEXACT) // -BOUND 1 - 1ulp
T(RU,   -0x1.32e9100000001p-2,   -0x1.37b3a3331c2adp-2,   0x1.14a5f2p-3, INEXACT) // -BOUND 2 - 1ulp
T(RU,   -0x1.9ca2400000001p-2,   -0x1.a8b4aab3277c6p-2,    0x1.82125p-1, INEXACT) // -BOUND 3 - 1ulp
T(RU,   -0x1.f90b300000001p-2,   -0x1.08134b1b5a263p-1,   0x1.6fa738p-1, INEXACT) // -BOUND 4 - 1ulp
T(RU,   -0x1.23adc00000001p-1,   -0x1.3655b073f2f1dp-1,    0x1.ae184p-1, INEXACT) // -BOUND 5 - 1ulp
T(RU,   -0x1.4781d00000001p-1,   -0x1.635bace48ee62p-1,    0x1.29f0dp-5, INEXACT) // -BOUND 6 - 1ulp
T(RU,   -0x1.647bb00000001p-1,   -0x1.8a5384e186e63p-1,    0x1.07f1ap-1, INEXACT) // -BOUND 7 - 1ulp
T(RU,   -0x1.7bc8100000001p-1,   -0x1.abdfcf76e4f12p-1,   0x1.7f3ae4p-2, INEXACT) // -BOUND 8 - 1ulp
T(RU,   -0x1.8f5c200000001p-1,   -0x1.ca1195024c021p-1,   0x1.38a214p-2, INEXACT) // -BOUND 9 - 1ulp
T(RU,   -0x1.7ae13ffffffffp-3,   -0x1.7d1336cab9374p-3,   0x1.bdfbdep-2, INEXACT) // -BOUND 1 + 1ulp
T(RU,   -0x1.32e90ffffffffp-2,   -0x1.37b3a3331c2abp-2,   0x1.3d1832p-5, INEXACT) // -BOUND 2 + 1ulp
T(RU,   -0x1.9ca23ffffffffp-2,   -0x1.a8b4aab3277c4p-2,   0x1.2335e2p-1, INEXACT) // -BOUND 3 + 1ulp
T(RU,   -0x1.f90b2ffffffffp-2,   -0x1.08134b1b5a262p-1,   0x1.231688p-1, INEXACT) // -BOUND 4 + 1ulp
T(RU,   -0x1.23adbffffffffp-1,   -0x1.3655b073f2f1bp-1,   0x1.a04a54p-2, INEXACT) // -BOUND 5 + 1ulp
T(RU,   -0x1.4781cffffffffp-1,   -0x1.635bace48ee5fp-1,   0x1.bcda22p-2, INEXACT) // -BOUND 6 + 1ulp
T(RU,   -0x1.647baffffffffp-1,    -0x1.8a5384e186e6p-1,   0x1.755978p-1, INEXACT) // -BOUND 7 + 1ulp
T(RU,   -0x1.7bc80ffffffffp-1,   -0x1.abdfcf76e4f0fp-1,    0x1.918afp-2, INEXACT) // -BOUND 8 + 1ulp
T(RU,   -0x1.8f5c1ffffffffp-1,   -0x1.ca1195024c01ep-1,   0x1.bfaaacp-4, INEXACT) // -BOUND 9 + 1ulp
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RZ,    0x1.3b9994abb81d4p-1,    0x1.540e24e5f33f2p-1,         -0x1p+0, INEXACT) // 6.164061030977401323127651266987e-01
T(RZ,    0x1.138a14ace5c76p-1,    0x1.22f26f182fabcp-1,         -0x1p+0, INEXACT) // 5.381628476196869126368937941152e-01
T(RN,    0x1.94e9b94c05952p-1,    0x1.d30a821efa18bp-1,         -0x1p-1, INEXACT) // 7.908456712055260684479662813828e-01
T(RN,    0x1.a4beb7ca30c4fp-1,    0x1.edd3bd3c9c082p-1,         -0x1p-1, INEXACT) // 8.217675623240071614006296840671e-01
T(RZ,   0x1.69e8ad78eeca2p-10,   0x1.69e8b501bb4fdp-10,         -0x1p+0, INEXACT) // 1.380572879709864465153090762328e-03
T(RZ,   0x1.b960de317add7p-10,   0x1.b960ebdc4ec13p-10, -0x1.545914p-51, INEXACT) // 1.683724938966393294345613718122e-03
T(RN,   0x1.da6cc7538a551p-10,   0x1.da6cd84c8fc9ep-10,         -0x1p-1, INEXACT) // 1.809787431634586130427266859044e-03
T(RN,   0x1.e23d1baea3264p-11,   0x1.e23d202373c02p-11,         -0x1p-1, INEXACT) // 9.197973320894223432653280525528e-04
T(RZ,   0x1.55fd6f5c6f5f7p-12,   0x1.55fd6fc227d9dp-12, -0x1.c6d828p-53, INEXACT) // 3.261470608569567281552481485818e-04
T(RN,   0x1.3b47d90e66263p-12,   0x1.3b47d95e19775p-12,         -0x1p-1, INEXACT) // 3.006750638632536376353143747764e-04
T(RN,   0x1.4567470bd5cf5p-12,   0x1.45674763762e4p-12,          0x1p-1, INEXACT) // 3.103288915915069644431423245834e-04
T(RN,   0x1.04c8a7dc82941p-13,   0x1.04c8a7e7c934ap-13,          0x1p-1, INEXACT) // 1.243514115148534459210499791837e-04
T(RZ,    0x1.3f69df30eae3p-13,   0x1.3f69df45a2f3ap-13,         -0x1p+0, INEXACT) // 1.523082551363338053851403941508e-04
T(RZ,     0x1.073485dfe11p-14,    0x1.073485e2c702p-14,         -0x1p+0, INEXACT) // 6.275300211028636554466686447995e-05
T(RN,   0x1.2231aea708e6ep-14,   0x1.2231aeaaeb495p-14,         -0x1p-1, INEXACT) // 6.918765812762860708921841546015e-05
T(RZ,   0x1.3dd7624125893p-14,   0x1.3dd7624640115p-14, -0x1.65184cp-51, INEXACT) // 7.577928137644995224952298995547e-05
T(RN,   0x1.c2263af8547a7p-14,   0x1.c2263b06d40e9p-14,          0x1p-1, INEXACT) // 1.073239653852907799771662644694e-04
T(RN,   0x1.ddf6e4e4450aep-14,   0x1.ddf6e4f5a008ep-14,          0x1p-1, INEXACT) // 1.139556002878762397661355221246e-04
T(RN,   0x1.765a1c05bf38ep-15,   0x1.765a1c07d4e34p-15,         -0x1p-1, INEXACT) // 4.462623478038780144763059132273e-05
T(RN,   0x1.89bd94bb4952bp-15,   0x1.89bd94bdb646dp-15,         -0x1p-1, INEXACT) // 4.693753131793995664452698313163e-05
T(RZ,   0x1.a4ab3dc4b4de3p-15,   0x1.a4ab3dc7aa22fp-15,         -0x1p+0, INEXACT) // 5.014764204749522002796044417572e-05
T(RN,   0x1.f1986a3e1555ap-15,   0x1.f1986a42faa47p-15,         -0x1p-1, INEXACT) // 5.931799067641448021826616754382e-05
T(RZ,   0x1.aa6782f0d0d7cp-16,   0x1.aa6782f196027p-16, -0x1.0df8bcp-51, INEXACT) // 2.541567932047354390952959013461e-05
T(RZ,   0x1.67ffffffe54dap-17,   0x1.6800000002f75p-17,         -0x1p+0, INEXACT) // 1.072883605938506639443548451585e-05
T(RN,   0x1.cd45e653692dcp-17,   0x1.cd45e653a7941p-17,         -0x1p-1, INEXACT) // 1.374700801799174303781045369810e-05
T(RZ,    0x1.dfffffffc0b8p-17,   0x1.e00000000707fp-17,         -0x1p+0, INEXACT) // 1.430511474565464812014337070423e-05
T(RZ,   0x1.786bbbe16e56ap-18,   0x1.786bbbe176d0ep-18, -0x1.84dce8p-53, INEXACT) // 5.609107547704725231876334012870e-06
T(RN,   0x1.40eb0ee78b449p-18,   0x1.40eb0ee790856p-18,         -0x1p-1, INEXACT) // 4.782053771229768318140693900142e-06
T(RN,   0x1.1a37d0cacaa17p-19,   0x1.1a37d0cacb861p-19,         -0x1p-1, INEXACT) // 2.102688175927414455994258687954e-06
T(RZ,   0x1.202c386b34d75p-19,   0x1.202c386b35cacp-19, -0x1.948912p-52, INEXACT) // 2.147054194526281282415789211648e-06
T(RZ,    0x1.4a8e1a96e38e3p-2,    0x1.50954b7bbf87ap-2,         -0x1p+0, INEXACT) // 3.228077082247990392538383730425e-01
T(RZ,    0x1.639fa355ed4d9p-2,    0x1.6b30c65ac788ap-2, -0x1.fd2ceap-52, INEXACT) // 3.472886582561166002314223533176e-01
T(RN,    0x1.a066fd491af5fp-2,    0x1.acd3b71252f39p-2,          0x1p-1, INEXACT) // 4.066428733701651920817710106348e-01
T(RZ,    0x1.afd5e3f5cb8c1p-2,    0x1.bdc8830ddf4e6p-2, -0x1.f8264ep-51, INEXACT) // 4.217143648883273088223688773724e-01
T(RN,     0x1.bdd023167db9p-2,    0x1.cd40e6c9cdb7bp-2,         -0x1p-1, INEXACT) // 4.353642923810463472023002395872e-01
T(RZ,    0x1.e9950730c4696p-2,    0x1.fe767739d0f6dp-2,     -0x1.16p-66, INEXACT) // 4.781075595393330379678786812292e-01
T(RZ,   0x1.0ecb8dc6bb8acp-21,   0x1.0ecb8dc6bb975p-21,         -0x1p+0, INEXACT) // 5.043952392128165825838006369741e-07
T(RZ,   0x1.66937b8c181a6p-21,   0x1.66937b8c1837bp-21, -0x1.c7a6ecp-51, INEXACT) // 6.679000406178028870842226447091e-07
T(RZ,    0x1.73d75f84d1a7p-21,   0x1.73d75f84d1c7ap-21,         -0x1p+0, INEXACT) // 6.926083960599965192199076180479e-07
T(RN,   0x1.7ec61c230793cp-21,   0x1.7ec61c2307b77p-21,          0x1p-1, INEXACT) // 7.129718863107646060854865471823e-07
T(RZ,   0x1.ab8aeac47387ep-21,   0x1.ab8aeac473b98p-21,         -0x1p+0, INEXACT) // 7.963602333628574434469657092328e-07
T(RZ,   0x1.c3c70f91f8619p-21,   0x1.c3c70f91f89c2p-21,         -0x1p+0, INEXACT) // 8.415013203999775687877871362119e-07
T(RZ,   0x1.f1afdb1fba6dcp-21,   0x1.f1afdb1fbabc2p-21, -0x1.c9ad7cp-51, INEXACT) // 9.270141596271749442447884098639e-07
T(RZ,   0x1.3cfc2a006a414p-22,   0x1.3cfc2a006a464p-22,         -0x1p+0, INEXACT) // 2.952153011168167160419755282175e-07
T(RN,   0x1.51c4b960778f5p-23,   0x1.51c4b9607790dp-23,         -0x1p-1, INEXACT) // 1.572856929273622340949989476325e-07
T(RN,   0x1.cc492d38ce8ccp-24,   0x1.cc492d38ce8dcp-24,          0x1p-1, INEXACT) // 1.071686498544782036668264035145e-07
T(RN,   0x1.d5fa99d152081p-24,   0x1.d5fa99d152091p-24,         -0x1p-1, INEXACT) // 1.094254920192055325343485406610e-07
T(RN,   0x1.e83fa11b81dabp-24,   0x1.e83fa11b81dbdp-24,         -0x1p-1, INEXACT) // 1.136792246379420439688232784096e-07
T(RZ,   0x1.3bacd6561ff59p-24,   0x1.3bacd6561ff5dp-24,         -0x1p+0, INEXACT) // 7.349884731562340479101236518159e-08
T(RZ,   0x1.250bfe1b082f3p-25,   0x1.250bfe1b082f3p-25,         -0x1p+0, INEXACT) // 3.411514289836083141458427324920e-08
T(RN,   0x1.8db9cb7511e9bp-25,   0x1.8db9cb7511e9dp-25,         -0x1p-1, INEXACT) // 4.630137243798163075767684144189e-08
T(RN,   0x1.4f747439b3488p-25,   0x1.4f747439b3489p-25,         -0x1p-1, INEXACT) // 3.905208996249579658931899185659e-08
T(RN,   0x1.e3cf476542bccp-25,    0x1.e3cf476542bdp-25,         -0x1p-1, INEXACT) // 5.632285996801581343409700327468e-08
T(RZ,    0x1.35b7e03251fe5p-3,    0x1.36e940de675dap-3, -0x1.99427cp-51, INEXACT) // 1.512296214443714925668160731220e-01
T(RN,    0x1.8e3f0af15614dp-3,    0x1.90ccbe8c57d52p-3,         -0x1p-1, INEXACT) // 1.944561819934826074618428037866e-01
T(RN,    0x1.d881d509da988p-3,    0x1.dccd844ada92ep-3,          0x1p-1, INEXACT) // 2.307163852340858856138083865517e-01
T(RZ,    0x1.c0edeb94cef34p-3,    0x1.c49ac7cde7b4bp-3,         -0x1p+0, INEXACT) // 2.192037968433112604671464396233e-01
T(RZ,    0x1.de920f7a4c509p-3,    0x1.e3095cae52dd7p-3, -0x1.a44a54p-53, INEXACT) // 2.336770257184428711827450797500e-01
T(RN,    0x1.5c77b71e30f9ap-4,    0x1.5ce3ad9dba626p-4,         -0x1p-1, INEXACT) // 8.507510691111833112110218735324e-02
T(RN,    0x1.66605beee4b37p-4,    0x1.66d5d1830b7bbp-4,         -0x1p-1, INEXACT) // 8.749423896214812701455088017610e-02
T(RN,    0x1.668721821b38dp-4,    0x1.66fcbd5065c43p-4,         -0x1p-1, INEXACT) // 8.753121461059105989921391710595e-02
T(RN,    0x1.d7c6f0e805b3cp-4,    0x1.d8d397016455fp-4,         -0x1p-1, INEXACT) // 1.151799593356885309525239335926e-01
T(RN,    0x1.26f551720198bp-5,    0x1.2705a48eb68a1p-5,          0x1p-1, INEXACT) // 3.600564868252139477666773359488e-02
T(RZ,    0x1.4cbced7e1d1aap-5,    0x1.4cd45ddee2881p-5, -0x1.519c9cp-53, INEXACT) // 4.061743150024040016621285076326e-02
T(RN,     0x1.7e5f75f042e9p-5,    0x1.7e830a37173b3p-5,          0x1p-1, INEXACT) // 4.667637858264328531987530368497e-02
T(RZ,    0x1.fc7a07b2549aap-5,    0x1.fccdc252cad1ep-5,         -0x1p+0, INEXACT) // 6.206990721934187160702123264855e-02
T(RN,    0x1.9356606cf5123p-6,    0x1.9360cf0cc0225p-6,          0x1p-1, INEXACT) // 2.461776176990427764113000819179e-02
T(RN,    0x1.540eb7886d89bp-7,    0x1.541047937c481p-7,          0x1p-1, INEXACT) // 1.037773095673016031381674650902e-02
T(RN,    0x1.57c61ad53bc2cp-7,    0x1.57c7b822ddbfcp-7,          0x1p-1, INEXACT) // 1.049114523126889325643773531738e-02
T(RN,    0x1.9f867e5ea4264p-7,    0x1.9f895840859f9p-7,         -0x1p-1, INEXACT) // 1.268082781214836113337085521380e-02
T(RN,    0x1.dcb87eb13d894p-7,    0x1.dcbccce594b6fp-7,          0x1p-1, INEXACT) // 1.454836069249790947432998677868e-02
T(RN,    0x1.f317ce4e1019dp-7,    0x1.f31cbf1868e56p-7,         -0x1p-1, INEXACT) // 1.523110936625543011813110894082e-02
T(RZ,    0x1.28f0f5a8edd16p-8,    0x1.28f1383f00f02p-8, -0x1.a91a5cp-51, INEXACT) // 4.530963874393797649609005873117e-03
T(RZ,    0x1.46a952b460436p-8,    0x1.46a9ab5a2c58dp-8,         -0x1p+0, INEXACT) // 4.984457675505862481180052725449e-03
T(RN,    0x1.828b5e36707d1p-8,     0x1.828bf118aeeep-8,         -0x1p-1, INEXACT) // 5.898199559341636179221612934498e-03
T(RZ,    0x1.311241e0dd8ecp-9,    0x1.311253ee0ea2ap-9, -0x1.4197b8p-51, INEXACT) // 2.327509443087119253568140209154e-03
T(RZ,     0x1.90da81c53f05p-9,    0x1.90daaab8c8498p-9,         -0x1p+0, INEXACT) // 3.058269826054206552701231203173e-03
T(RZ,    0x1.933f8ccbc0ea2p-9,    0x1.933fb67c4d0aep-9,         -0x1p+0, INEXACT) // 3.076539933205627887213839954939e-03
T(RZ,    0x1.efe13977f9dccp-9,    0x1.efe186fe553d9p-9, -0x1.f1c0c8p-54, INEXACT) // 3.783262505738104949926103870439e-03
// Bad cases generated by ./crlibm_generate_test_vectors asin 20 1
T(RN,    0x1.44274525a6fb1p-6,    0x1.442caf51a058bp-6,  -0x1.fffff8p-2, INEXACT) // 1.978475334782076391904048762171e-02
T(RD,   0x1.250bfdf77203ap-25,   0x1.250bfdf77203ap-25,         -0x1p+0, INEXACT) // 3.411514265142917427191504272169e-08
T(RU,   0x1.250bfdf77203ap-25,   0x1.250bfdf77203bp-25,  0x1.750d9ap-26, INEXACT) // 3.411514265142917427191504272169e-08
T(RZ,   0x1.250bfdf77203ap-25,   0x1.250bfdf77203ap-25,         -0x1p+0, INEXACT) // 3.411514265142917427191504272169e-08
T(RD,   0x1.7137445dae51cp-24,   0x1.7137445dae523p-24,  -0x1.fffffap-1, INEXACT) // 8.596477260148969881678264991220e-08
T(RU,   0x1.7137445dae51cp-24,   0x1.7137445dae524p-24,  0x1.ac28e2p-23, INEXACT) // 8.596477260148969881678264991220e-08
T(RZ,   0x1.7137445dae51cp-24,   0x1.7137445dae523p-24,  -0x1.fffffap-1, INEXACT) // 8.596477260148969881678264991220e-08
T(RD,   -0x1.08e07d1cb9d11p-8,   -0x1.08e0ac5f94ba7p-8,  -0x1.fffffcp-1, INEXACT) // -4.041700882886149238937267824667e-03
T(RU,   -0x1.08e07d1cb9d11p-8,   -0x1.08e0ac5f94ba6p-8,  0x1.27fe88p-23, INEXACT) // -4.041700882886149238937267824667e-03
T(RZ,   -0x1.08e07d1cb9d11p-8,   -0x1.08e0ac5f94ba6p-8,  0x1.27fe88p-23, INEXACT) // -4.041700882886149238937267824667e-03
T(RD,  -0x1.e8cc3a3836111p-22,  -0x1.e8cc3a383623ap-22, -0x1.f176a2p-23, INEXACT) // -4.552283914389220116962985699521e-07
T(RU,  -0x1.e8cc3a3836111p-22,  -0x1.e8cc3a3836239p-22,   0x1.fffff8p-1, INEXACT) // -4.552283914389220116962985699521e-07
T(RZ,  -0x1.e8cc3a3836111p-22,  -0x1.e8cc3a3836239p-22,   0x1.fffff8p-1, INEXACT) // -4.552283914389220116962985699521e-07
T(RD,   0x1.80e307e79c1ecp-22,   0x1.80e307e79c27dp-22, -0x1.cae7aap-23, INEXACT) // 3.584538021744656637192867273956e-07
T(RU,   0x1.80e307e79c1ecp-22,   0x1.80e307e79c27ep-22,   0x1.fffff8p-1, INEXACT) // 3.584538021744656637192867273956e-07
T(RZ,   0x1.80e307e79c1ecp-22,   0x1.80e307e79c27dp-22, -0x1.cae7aap-23, INEXACT) // 3.584538021744656637192867273956e-07
T(RN,  -0x1.bd86856207d66p-19,  -0x1.bd8685620b59fp-19,   0x1.fffff6p-2, INEXACT) // -3.319423442796061097983650184373e-06
T(RN,   -0x1.9d40e8fa380d6p-4,   -0x1.9df537e0f9a7bp-4,   0x1.fffff8p-2, INEXACT) // -1.008919811897642515585715727866e-01
T(RD,   0x1.8502f578a664cp-11,   0x1.8502f7cf7f6bep-11, -0x1.3f7d08p-26, INEXACT) // 7.419806634800323562328738802307e-04
T(RU,   0x1.8502f578a664cp-11,   0x1.8502f7cf7f6bfp-11,          0x1p+0, INEXACT) // 7.419806634800323562328738802307e-04
T(RZ,   0x1.8502f578a664cp-11,   0x1.8502f7cf7f6bep-11, -0x1.3f7d08p-26, INEXACT) // 7.419806634800323562328738802307e-04
T(RD,  -0x1.854bebbd68e8ap-12,  -0x1.854bec5373758p-12,  -0x1.b6721p-25, INEXACT) // -3.712621363211951333940796793343e-04
T(RU,  -0x1.854bebbd68e8ap-12,  -0x1.854bec5373757p-12,   0x1.fffffep-1, INEXACT) // -3.712621363211951333940796793343e-04
T(RZ,  -0x1.854bebbd68e8ap-12,  -0x1.854bec5373757p-12,   0x1.fffffep-1, INEXACT) // -3.712621363211951333940796793343e-04
T(RN,  -0x1.128a95d747236p-21,  -0x1.128a95d747308p-21,   0x1.fffff2p-2, INEXACT) // -5.113731117753909682547381818085e-07
T(RN,   0x1.3d59fa20967f9p-20,   0x1.3d59fa2096d0ep-20,   0x1.fffffcp-2, INEXACT) // 1.182226363158430426487607335650e-06
T(RD,    -0x1.8c1fd04be98ap-8,   -0x1.8c206e5fc6d86p-8, -0x1.51f6bap-24, INEXACT) // -6.044376710553717169105425455200e-03
T(RU,    -0x1.8c1fd04be98ap-8,   -0x1.8c206e5fc6d85p-8,   0x1.fffffep-1, INEXACT) // -6.044376710553717169105425455200e-03
T(RZ,    -0x1.8c1fd04be98ap-8,   -0x1.8c206e5fc6d85p-8,   0x1.fffffep-1, INEXACT) // -6.044376710553717169105425455200e-03
T(RN,   0x1.53f879d082f9bp-16,   0x1.53f879d0e6e79p-16,  -0x1.fffffcp-2, INEXACT) // 2.026382736812458925930273412330e-05
T(RN,    0x1.7c395894cd6ap-12,   0x1.7c3959209896cp-12,  -0x1.fffff6p-2, INEXACT) // 3.626098708083645011379658740225e-04
T(RN,   0x1.060c0fa7ade44p-17,   0x1.060c0fa7b9551p-17,   0x1.fffff4p-2, INEXACT) // 7.809612568506565943599745382997e-06
T(RN,   0x1.e9730d4f57579p-18,   0x1.e9730d4f69faap-18,   0x1.fffffep-2, INEXACT) // 7.293364731123457154386788975353e-06
T(RN,   -0x1.f3c6cfa3a53f3p-2,   -0x1.050d938cd893bp-1,  -0x1.fffffap-2, INEXACT) // -4.880630916243823835820592194068e-01
T(RD,  -0x1.78865a11b65e7p-13,  -0x1.78865a33a690ap-13,         -0x1p+0, INEXACT) // -1.795410212739732998526304141862e-04
T(RU,  -0x1.78865a11b65e7p-13,  -0x1.78865a33a6909p-13,  0x1.dd0236p-27, INEXACT) // -1.795410212739732998526304141862e-04
T(RZ,  -0x1.78865a11b65e7p-13,  -0x1.78865a33a6909p-13,  0x1.dd0236p-27, INEXACT) // -1.795410212739732998526304141862e-04
T(RN,   -0x1.4d096b9c98b6ep-4,   -0x1.4d67a3cbcb00bp-4,  -0x1.fffff2p-2, INEXACT) // -8.130781207868917337400205269660e-02
T(RN,   0x1.4c846eb56766ap-22,   0x1.4c846eb5676c8p-22,   0x1.fffffap-2, INEXACT) // 3.096808812388335098846081118451e-07
T(RD,  -0x1.9723913279eb8p-12,  -0x1.972391de1b8f3p-12,  -0x1.0042dp-23, INEXACT) // -3.882779448347406341113252636887e-04
T(RU,  -0x1.9723913279eb8p-12,  -0x1.972391de1b8f2p-12,   0x1.fffffcp-1, INEXACT) // -3.882779448347406341113252636887e-04
T(RZ,  -0x1.9723913279eb8p-12,  -0x1.972391de1b8f2p-12,   0x1.fffffcp-1, INEXACT) // -3.882779448347406341113252636887e-04
T(RN,  -0x1.48ec189e7d614p-22,  -0x1.48ec189e7d66ep-22,   0x1.fffffap-2, INEXACT) // -3.063327173308130850346757759195e-07
T(RN,   -0x1.cf706f49fd29ap-4,   -0x1.d06f0944126ddp-4,   0x1.fffffcp-2, INEXACT) // -1.131443354823410685217055515750e-01
T(RN,  -0x1.2aca34173bac9p-11,  -0x1.2aca352694bafp-11,   0x1.fffff6p-2, INEXACT) // -5.698964258991852426319835167590e-04
T(RD,   0x1.07d5a8d05d708p-17,   0x1.07d5a8d0691d9p-17,  -0x1.fffffcp-1, INEXACT) // 7.862884019198542275876084861608e-06
T(RU,   0x1.07d5a8d05d708p-17,   0x1.07d5a8d0691dap-17,   0x1.30073p-23, INEXACT) // 7.862884019198542275876084861608e-06
T(RZ,   0x1.07d5a8d05d708p-17,   0x1.07d5a8d0691d9p-17,  -0x1.fffffcp-1, INEXACT) // 7.862884019198542275876084861608e-06
T(RN,   -0x1.e927970169ac2p-2,   -0x1.fdf9e133af198p-2,  -0x1.fffff8p-2, INEXACT) // -4.776900858509344205415914075274e-01
T(RN,    0x1.ed4570243ae71p-2,    0x1.0155786866be1p-1,   0x1.fffffcp-2, INEXACT) // 4.817101976502505267241360797925e-01
T(RN,    0x1.070bb53afbe64p-4,    0x1.073a14d8811e1p-4,   0x1.fffff2p-2, INEXACT) // 6.422014992835439750606951747613e-02
T(RN,    0x1.08f2454aade0bp-6,    0x1.08f53a2612529p-6,   0x1.fffff4p-2, INEXACT) // 1.617104307908160884532655643397e-02
T(RN,   -0x1.81af11263190ep-9,   -0x1.81af359ffffffp-9,   0x1.fffff2p-2, INEXACT) // -2.942534297378013828649923055991e-03
T(RN,   -0x1.b6534d6b6ccd4p-8,   -0x1.b65423980f92cp-8,   0x1.fffff2p-2, INEXACT) // -6.688314820553393352797755255779e-03
T(RN,  -0x1.fa5b375c0e482p-18,  -0x1.fa5b375c22eadp-18,   0x1.fffffap-2, INEXACT) // -7.545297048544153320080891955701e-06
T(RD,  -0x1.eb8ca7a28910bp-11,  -0x1.eb8cac5ab663ap-11,  -0x1.fffffap-1, INEXACT) // -9.375561388123299913152641771319e-04
T(RU,  -0x1.eb8ca7a28910bp-11,  -0x1.eb8cac5ab6639p-11,  0x1.833fd4p-23, INEXACT) // -9.375561388123299913152641771319e-04
T(RZ,  -0x1.eb8ca7a28910bp-11,  -0x1.eb8cac5ab6639p-11,  0x1.833fd4p-23, INEXACT) // -9.375561388123299913152641771319e-04
T(RD,   0x1.baed5135ace33p-14,   0x1.baed51437cab1p-14, -0x1.b1b5acp-24, INEXACT) // 1.056020308521303491906470628514e-04
T(RU,   0x1.baed5135ace33p-14,   0x1.baed51437cab2p-14,   0x1.fffffcp-1, INEXACT) // 1.056020308521303491906470628514e-04
T(RZ,   0x1.baed5135ace33p-14,   0x1.baed51437cab1p-14, -0x1.b1b5acp-24, INEXACT) // 1.056020308521303491906470628514e-04
T(RN,   0x1.713743ca5919fp-26,   0x1.713743ca5919fp-26,  -0x1.fffffcp-2, INEXACT) // 2.149119263920880326960048884496e-08
T(RD,   0x1.20f8d69563a7dp-18,   0x1.20f8d695677dap-18,  -0x1.fffffap-1, INEXACT) // 4.306018714385543835678361174191e-06
T(RU,   0x1.20f8d69563a7dp-18,   0x1.20f8d695677dbp-18,  0x1.b16f9ap-23, INEXACT) // 4.306018714385543835678361174191e-06
T(RZ,   0x1.20f8d69563a7dp-18,   0x1.20f8d695677dap-18,  -0x1.fffffap-1, INEXACT) // 4.306018714385543835678361174191e-06
T(RN,   -0x1.33f2cdb389c1dp-3,    -0x1.351ef0aecb89p-3,   0x1.fffffcp-2, INEXACT) // -1.503654547134098129479440331124e-01
T(RN,   -0x1.c23e88b80893dp-1,   -0x1.1316b8fad9012p+0,  -0x1.fffffcp-2, INEXACT) // -8.793833470011019892709214218485e-01
T(RD,  -0x1.4afd7dcef48b4p-11,  -0x1.4afd7f3fd3793p-11,  -0x1.fffffcp-1, INEXACT) // -6.313137072260417183289238352017e-04
T(RU,  -0x1.4afd7dcef48b4p-11,  -0x1.4afd7f3fd3792p-11,  0x1.37fe5ap-23, INEXACT) // -6.313137072260417183289238352017e-04
T(RZ,  -0x1.4afd7dcef48b4p-11,  -0x1.4afd7f3fd3792p-11,  0x1.37fe5ap-23, INEXACT) // -6.313137072260417183289238352017e-04
T(RD,   0x1.298e53b843d6ep-22,    0x1.298e53b843dbp-22,  -0x1.fffff8p-1, INEXACT) // 2.771205873811076460133564873523e-07
T(RU,   0x1.298e53b843d6ep-22,   0x1.298e53b843db1p-22,   0x1.c2d14p-23, INEXACT) // 2.771205873811076460133564873523e-07
T(RZ,   0x1.298e53b843d6ep-22,    0x1.298e53b843dbp-22,  -0x1.fffff8p-1, INEXACT) // 2.771205873811076460133564873523e-07
T(RD,  -0x1.61246d9f3aff4p-24,  -0x1.61246d9f3affcp-24,  -0x1.fffffap-1, INEXACT) // -8.222234847463729270772574315995e-08
T(RU,  -0x1.61246d9f3aff4p-24,  -0x1.61246d9f3affbp-24,   0x1.8eb33p-23, INEXACT) // -8.222234847463729270772574315995e-08
T(RZ,  -0x1.61246d9f3aff4p-24,  -0x1.61246d9f3affbp-24,   0x1.8eb33p-23, INEXACT) // -8.222234847463729270772574315995e-08
T(RD,   0x1.42c815eb7781cp-16,   0x1.42c815ebcd084p-16, -0x1.0398acp-23, INEXACT) // 1.923928168234149743611588467829e-05
T(RU,   0x1.42c815eb7781cp-16,   0x1.42c815ebcd085p-16,   0x1.fffffcp-1, INEXACT) // 1.923928168234149743611588467829e-05
T(RZ,   0x1.42c815eb7781cp-16,   0x1.42c815ebcd084p-16, -0x1.0398acp-23, INEXACT) // 1.923928168234149743611588467829e-05
T(RN,   0x1.46714f588ef6dp-13,   0x1.46714f6eacf51p-13,  -0x1.fffff6p-2, INEXACT) // 1.556599697937160033198861208703e-04
T(RD,   -0x1.6df7af2175d9fp-3,   -0x1.6ff197bc3261ep-3, -0x1.367638p-23, INEXACT) // -1.786950761877336979477348677392e-01
T(RU,   -0x1.6df7af2175d9fp-3,   -0x1.6ff197bc3261dp-3,   0x1.fffffcp-1, INEXACT) // -1.786950761877336979477348677392e-01
T(RZ,   -0x1.6df7af2175d9fp-3,   -0x1.6ff197bc3261dp-3,   0x1.fffffcp-1, INEXACT) // -1.786950761877336979477348677392e-01
T(RD,   0x1.e112fd2ee1392p-12,   0x1.e112fe4a05b11p-12, -0x1.cb12d6p-23, INEXACT) // 4.587880857161381930112153959556e-04
T(RU,   0x1.e112fd2ee1392p-12,   0x1.e112fe4a05b12p-12,   0x1.fffff8p-1, INEXACT) // 4.587880857161381930112153959556e-04
T(RZ,   0x1.e112fd2ee1392p-12,   0x1.e112fe4a05b11p-12, -0x1.cb12d6p-23, INEXACT) // 4.587880857161381930112153959556e-04
T(RD,   -0x1.2e482c57abab2p-5,   -0x1.2e59beacd53cfp-5, -0x1.d0ea18p-23, INEXACT) // -3.689964924466461460017541185152e-02
T(RU,   -0x1.2e482c57abab2p-5,   -0x1.2e59beacd53cep-5,   0x1.fffff8p-1, INEXACT) // -3.689964924466461460017541185152e-02
T(RZ,   -0x1.2e482c57abab2p-5,   -0x1.2e59beacd53cep-5,   0x1.fffff8p-1, INEXACT) // -3.689964924466461460017541185152e-02
T(RD,   0x1.ba6431f0de044p-17,   0x1.ba6431f115102p-17, -0x1.3c542ap-24, INEXACT) // 1.318429073803040614239548422582e-05
T(RU,   0x1.ba6431f0de044p-17,   0x1.ba6431f115103p-17,   0x1.fffffep-1, INEXACT) // 1.318429073803040614239548422582e-05
T(RZ,   0x1.ba6431f0de044p-17,   0x1.ba6431f115102p-17, -0x1.3c542ap-24, INEXACT) // 1.318429073803040614239548422582e-05
T(RD,   0x1.91034d68e13c6p-23,   0x1.91034d68e13efp-23,  -0x1.c05f7p-24, INEXACT) // 1.867361832075205979428092050582e-07
T(RU,   0x1.91034d68e13c6p-23,    0x1.91034d68e13fp-23,   0x1.fffffcp-1, INEXACT) // 1.867361832075205979428092050582e-07
T(RZ,   0x1.91034d68e13c6p-23,   0x1.91034d68e13efp-23,  -0x1.c05f7p-24, INEXACT) // 1.867361832075205979428092050582e-07
T(RN,   0x1.dc3ec209f7e64p-18,   0x1.dc3ec20a09117p-18,  -0x1.fffff8p-2, INEXACT) // 7.096605722594834985078940392533e-06
T(RN,   0x1.943f3c273009bp-24,   0x1.943f3c27300a5p-24,  -0x1.fffff2p-2, INEXACT) // 9.412109190903361371381756440499e-08
T(RN,  -0x1.0203f40f9167bp-15,  -0x1.0203f41040227p-15,  -0x1.fffffap-2, INEXACT) // -3.075783763199516155631071945287e-05
T(RD,    0x1.dbfde75cd3f5cp-5,    0x1.dc4292ead41b3p-5, -0x1.4d27f8p-23, INEXACT) // 5.810446918496722790159481064620e-02
T(RU,    0x1.dbfde75cd3f5cp-5,    0x1.dc4292ead41b4p-5,   0x1.fffffap-1, INEXACT) // 5.810446918496722790159481064620e-02
T(RZ,    0x1.dbfde75cd3f5cp-5,    0x1.dc4292ead41b3p-5, -0x1.4d27f8p-23, INEXACT) // 5.810446918496722790159481064620e-02
T(RN,  -0x1.71374218447bap-26,  -0x1.71374218447bap-26,   0x1.fffff6p-2, INEXACT) // -2.149119113318939458464416751050e-08
T(RN,  -0x1.6347a4ef10516p-13,  -0x1.6347a50b93455p-13,   0x1.fffff8p-2, INEXACT) // -1.694106390193537005177393250932e-04
// Bad cases generated by ./crlibm_generate_test_vectors asin 15 1
T(RN,   -0x1.fa7cffb503271p-3,   -0x1.ffcc787718f79p-3,  -0x1.ffffd8p-2, INEXACT) // -2.473087288966726859928968451641e-01
T(RD,   0x1.887a4e0ccfacfp-13,   0x1.887a4e333fa63p-13, -0x1.1c2242p-18, INEXACT) // 1.871479766126422125249034733585e-04
T(RU,   0x1.887a4e0ccfacfp-13,   0x1.887a4e333fa64p-13,   0x1.ffff72p-1, INEXACT) // 1.871479766126422125249034733585e-04
T(RZ,   0x1.887a4e0ccfacfp-13,   0x1.887a4e333fa63p-13, -0x1.1c2242p-18, INEXACT) // 1.871479766126422125249034733585e-04
T(RD,    0x1.3f7d28a1e0425p-6,    0x1.3f8257d071d4ap-6,  -0x1.ffff6ap-1, INEXACT) // 1.950005500794218041282768183464e-02
T(RU,    0x1.3f7d28a1e0425p-6,    0x1.3f8257d071d4bp-6,  0x1.2bdecep-18, INEXACT) // 1.950005500794218041282768183464e-02
T(RZ,    0x1.3f7d28a1e0425p-6,    0x1.3f8257d071d4ap-6,  -0x1.ffff6ap-1, INEXACT) // 1.950005500794218041282768183464e-02
T(RN,  -0x1.8ad631fb1cca7p-10,  -0x1.8ad63bc3bb6ccp-10,  -0x1.ffff42p-2, INEXACT) // -1.506182480423482036510640647009e-03
T(RN,  -0x1.afe98557b1bf1p-20,   -0x1.afe98557b28cp-20,  -0x1.fffe94p-2, INEXACT) // -1.608998294532053925906035264648e-06
T(RD,  -0x1.2da4aaed3515bp-10,  -0x1.2da4af49fe358p-10,   -0x1.bbefp-18, INEXACT) // -1.150677616625981085005103743413e-03
T(RU,  -0x1.2da4aaed3515bp-10,  -0x1.2da4af49fe357p-10,   0x1.ffff22p-1, INEXACT) // -1.150677616625981085005103743413e-03
T(RZ,  -0x1.2da4aaed3515bp-10,  -0x1.2da4af49fe357p-10,   0x1.ffff22p-1, INEXACT) // -1.150677616625981085005103743413e-03
T(RD,   0x1.1d3524396a707p-22,   0x1.1d3524396a742p-22, -0x1.2c7836p-19, INEXACT) // 2.656202614201729295170925550934e-07
T(RU,   0x1.1d3524396a707p-22,   0x1.1d3524396a743p-22,   0x1.ffffb4p-1, INEXACT) // 2.656202614201729295170925550934e-07
T(RZ,   0x1.1d3524396a707p-22,   0x1.1d3524396a742p-22, -0x1.2c7836p-19, INEXACT) // 2.656202614201729295170925550934e-07
T(RD,  -0x1.351f6f5208606p-18,  -0x1.351f6f520d125p-18, -0x1.387738p-18, INEXACT) // -4.606288557724909585463189676258e-06
T(RU,  -0x1.351f6f5208606p-18,  -0x1.351f6f520d124p-18,   0x1.ffff64p-1, INEXACT) // -4.606288557724909585463189676258e-06
T(RZ,  -0x1.351f6f5208606p-18,  -0x1.351f6f520d124p-18,   0x1.ffff64p-1, INEXACT) // -4.606288557724909585463189676258e-06
T(RN,   0x1.479a99f298bb7p-15,   0x1.479a99f3fe659p-15,  -0x1.ffff64p-2, INEXACT) // 3.905342955048219315923249683742e-05
T(RD,   0x1.d43a94aae5058p-16,   0x1.d43a94abea155p-16, -0x1.edc62cp-18, INEXACT) // 2.790861314457023629152787602692e-05
T(RU,   0x1.d43a94aae5058p-16,   0x1.d43a94abea156p-16,   0x1.ffff0ap-1, INEXACT) // 2.790861314457023629152787602692e-05
T(RZ,   0x1.d43a94aae5058p-16,   0x1.d43a94abea155p-16, -0x1.edc62cp-18, INEXACT) // 2.790861314457023629152787602692e-05
T(RD,   0x1.ee6a8158584cap-19,    0x1.ee6a81585d1ap-19,  -0x1.ffff92p-1, INEXACT) // 3.683686525743876318688980325833e-06
T(RU,   0x1.ee6a8158584cap-19,   0x1.ee6a81585d1a1p-19,  0x1.bb92a6p-19, INEXACT) // 3.683686525743876318688980325833e-06
T(RZ,   0x1.ee6a8158584cap-19,    0x1.ee6a81585d1ap-19,  -0x1.ffff92p-1, INEXACT) // 3.683686525743876318688980325833e-06
T(RD,  -0x1.e9e32cc7c19d6p-12,  -0x1.e9e32df2bf3bbp-12,  -0x1.d1122p-18, INEXACT) // -4.671930332595086157385089187244e-04
T(RU,  -0x1.e9e32cc7c19d6p-12,  -0x1.e9e32df2bf3bap-12,   0x1.ffff18p-1, INEXACT) // -4.671930332595086157385089187244e-04
T(RZ,  -0x1.e9e32cc7c19d6p-12,  -0x1.e9e32df2bf3bap-12,   0x1.ffff18p-1, INEXACT) // -4.671930332595086157385089187244e-04
T(RD,  -0x1.0adb608c8272ep-16,  -0x1.0adb608cb2c71p-16,  -0x1.ffffb4p-1, INEXACT) // -1.590591323189572873315553169782e-05
T(RU,  -0x1.0adb608c8272ep-16,   -0x1.0adb608cb2c7p-16,  0x1.2f91ccp-19, INEXACT) // -1.590591323189572873315553169782e-05
T(RZ,  -0x1.0adb608c8272ep-16,   -0x1.0adb608cb2c7p-16,  0x1.2f91ccp-19, INEXACT) // -1.590591323189572873315553169782e-05
T(RD,   0x1.a9de946b162edp-12,   0x1.a9de952f8329bp-12,  -0x1.ffff5ep-1, INEXACT) // 4.061407586895399960021102447882e-04
T(RU,   0x1.a9de946b162edp-12,   0x1.a9de952f8329cp-12,  0x1.43ad6ep-18, INEXACT) // 4.061407586895399960021102447882e-04
T(RZ,   0x1.a9de946b162edp-12,   0x1.a9de952f8329bp-12,  -0x1.ffff5ep-1, INEXACT) // 4.061407586895399960021102447882e-04
T(RD,   0x1.e17d1c3065dadp-19,   0x1.e17d1c306a4a5p-19, -0x1.f90e8ep-19, INEXACT) // 3.587370450651881121376324604300e-06
T(RU,   0x1.e17d1c3065dadp-19,   0x1.e17d1c306a4a6p-19,   0x1.ffff82p-1, INEXACT) // 3.587370450651881121376324604300e-06
T(RZ,   0x1.e17d1c3065dadp-19,   0x1.e17d1c306a4a5p-19, -0x1.f90e8ep-19, INEXACT) // 3.587370450651881121376324604300e-06
T(RD,  -0x1.d12efcbac55bep-26,   -0x1.d12efcbac55cp-26,  -0x1.ffff6ep-1, INEXACT) // -2.707724598278634220176574044607e-08
T(RU,  -0x1.d12efcbac55bep-26,  -0x1.d12efcbac55bfp-26,  0x1.22defcp-18, INEXACT) // -2.707724598278634220176574044607e-08
T(RZ,  -0x1.d12efcbac55bep-26,  -0x1.d12efcbac55bfp-26,  0x1.22defcp-18, INEXACT) // -2.707724598278634220176574044607e-08
T(RD,  -0x1.11430093b41b4p-17,  -0x1.11430093c1146p-17,  -0x1.b46d1p-21, INEXACT) // -8.143834100777419852338484540510e-06
T(RU,  -0x1.11430093b41b4p-17,  -0x1.11430093c1145p-17,   0x1.ffffe4p-1, INEXACT) // -8.143834100777419852338484540510e-06
T(RZ,  -0x1.11430093b41b4p-17,  -0x1.11430093c1145p-17,   0x1.ffffe4p-1, INEXACT) // -8.143834100777419852338484540510e-06
T(RN,    0x1.7708b0cc08f5ap-7,    0x1.770ac96a88a8bp-7,  -0x1.ffff3ep-2, INEXACT) // 1.144512779871547161758549293609e-02
T(RD,   -0x1.8137e5f5fbd1p-20,  -0x1.8137e5f5fc627p-20,  -0x1.ffffb6p-1, INEXACT) // -1.435050192007660338358934759562e-06
T(RU,   -0x1.8137e5f5fbd1p-20,  -0x1.8137e5f5fc626p-20,  0x1.269b88p-19, INEXACT) // -1.435050192007660338358934759562e-06
T(RZ,   -0x1.8137e5f5fbd1p-20,  -0x1.8137e5f5fc626p-20,  0x1.269b88p-19, INEXACT) // -1.435050192007660338358934759562e-06
T(RN,    0x1.44274525a6fb1p-6,    0x1.442caf51a058bp-6,  -0x1.fffff8p-2, INEXACT) // 1.978475334782076391904048762171e-02
T(RN,  -0x1.80fde316a55fcp-13,  -0x1.80fde33aecf6ep-13,   0x1.ffff4ep-2, INEXACT) // -1.835783702587716640849957450143e-04
T(RD,    0x1.463f78b244972p-9,    0x1.463f8ec627294p-9,  -0x1.ffff08p-1, INEXACT) // 2.489074214403413400076292560925e-03
T(RU,    0x1.463f78b244972p-9,    0x1.463f8ec627295p-9,  0x1.ee922ep-18, INEXACT) // 2.489074214403413400076292560925e-03
T(RZ,    0x1.463f78b244972p-9,    0x1.463f8ec627294p-9,  -0x1.ffff08p-1, INEXACT) // 2.489074214403413400076292560925e-03
T(RD,    0x1.b6cbd4bedefe6p-9,    0x1.b6cc0a760a1c8p-9,  -0x1.ffffc4p-1, INEXACT) // 3.347749442978542426530008668806e-03
T(RU,    0x1.b6cbd4bedefe6p-9,    0x1.b6cc0a760a1c9p-9,  0x1.dda24ep-20, INEXACT) // 3.347749442978542426530008668806e-03
T(RZ,    0x1.b6cbd4bedefe6p-9,    0x1.b6cc0a760a1c8p-9,  -0x1.ffffc4p-1, INEXACT) // 3.347749442978542426530008668806e-03
T(RD,  -0x1.71373db16250ap-25,  -0x1.71373db16250cp-25, -0x1.c98e12p-20, INEXACT) // -4.298237444705395829311458987324e-08
T(RU,  -0x1.71373db16250ap-25,  -0x1.71373db16250bp-25,   0x1.ffffc6p-1, INEXACT) // -4.298237444705395829311458987324e-08
T(RZ,  -0x1.71373db16250ap-25,  -0x1.71373db16250bp-25,   0x1.ffffc6p-1, INEXACT) // -4.298237444705395829311458987324e-08
T(RD,   0x1.10210e070482fp-20,   0x1.10210e0704b63p-20, -0x1.35cf52p-18, INEXACT) // 1.013759971750266097355124526869e-06
T(RU,   0x1.10210e070482fp-20,   0x1.10210e0704b64p-20,   0x1.ffff66p-1, INEXACT) // 1.013759971750266097355124526869e-06
T(RZ,   0x1.10210e070482fp-20,   0x1.10210e0704b63p-20, -0x1.35cf52p-18, INEXACT) // 1.013759971750266097355124526869e-06
T(RD,  -0x1.a51a8a52fcb4dp-16,  -0x1.a51a8a53ba9c8p-16,  -0x1.ffff62p-1, INEXACT) // -2.509973485227282445392434084841e-05
T(RU,  -0x1.a51a8a52fcb4dp-16,  -0x1.a51a8a53ba9c7p-16,  0x1.3c0c56p-18, INEXACT) // -2.509973485227282445392434084841e-05
T(RZ,  -0x1.a51a8a52fcb4dp-16,  -0x1.a51a8a53ba9c7p-16,  0x1.3c0c56p-18, INEXACT) // -2.509973485227282445392434084841e-05
T(RN,    0x1.b75f80e22b2c6p-5,    0x1.b795802ffdf6bp-5,  -0x1.fffe42p-2, INEXACT) // 5.363440678170187936313340060224e-02
T(RD,   -0x1.c8bac72c695a2p-1,   -0x1.1a1391a6e66fap+0,  -0x1.fffff6p-1, INEXACT) // -8.920500032151503777555490160012e-01
T(RU,   -0x1.c8bac72c695a2p-1,   -0x1.1a1391a6e66f9p+0,  0x1.32f79cp-22, INEXACT) // -8.920500032151503777555490160012e-01
T(RZ,   -0x1.c8bac72c695a2p-1,   -0x1.1a1391a6e66f9p+0,  0x1.32f79cp-22, INEXACT) // -8.920500032151503777555490160012e-01
T(RN,   0x1.4b2da54ac5b43p-21,   0x1.4b2da54ac5cb4p-21,  -0x1.ffffaap-2, INEXACT) // 6.168676603715318110870090805020e-07
T(RN,   -0x1.c6187b9ff1ac4p-9,   -0x1.c618b7283af46p-9,  -0x1.fffe4cp-2, INEXACT) // -3.464474764743515414200381030696e-03
T(RD,   -0x1.dd242ec1f9bd9p-1,   -0x1.331d1217d13f8p+0,  -0x1.ffffc2p-1, INEXACT) // -9.319166766916807675968925650523e-01
T(RU,   -0x1.dd242ec1f9bd9p-1,   -0x1.331d1217d13f7p+0,  0x1.f0c40cp-20, INEXACT) // -9.319166766916807675968925650523e-01
T(RZ,   -0x1.dd242ec1f9bd9p-1,   -0x1.331d1217d13f7p+0,  0x1.f0c40cp-20, INEXACT) // -9.319166766916807675968925650523e-01
T(RN,    0x1.078f24df619f1p-9,    0x1.078f308328ca1p-9,  -0x1.fffe58p-2, INEXACT) // 2.010796786353845778255733378614e-03
T(RD,   0x1.bb61c999fe1d2p-18,   0x1.bb61c99a0bf7cp-18,  -0x1.ffff42p-1, INEXACT) // 6.606906390864814604163730848985e-06
T(RU,   0x1.bb61c999fe1d2p-18,   0x1.bb61c99a0bf7dp-18,  0x1.7ad264p-18, INEXACT) // 6.606906390864814604163730848985e-06
T(RZ,   0x1.bb61c999fe1d2p-18,   0x1.bb61c99a0bf7cp-18,  -0x1.ffff42p-1, INEXACT) // 6.606906390864814604163730848985e-06
T(RN,    0x1.fd90aa754c7ebp-4,    0x1.fee3848e9ea16p-4,    0x1.fffefp-2, INEXACT) // 1.244055422328355503536201354109e-01
T(RD,  -0x1.93f85bda23cf5p-12,  -0x1.93f85c81cb81bp-12, -0x1.9d1c5ep-18, INEXACT) // -3.852559581298397738298444625826e-04
T(RU,  -0x1.93f85bda23cf5p-12,  -0x1.93f85c81cb81ap-12,   0x1.ffff32p-1, INEXACT) // -3.852559581298397738298444625826e-04
T(RZ,  -0x1.93f85bda23cf5p-12,  -0x1.93f85c81cb81ap-12,   0x1.ffff32p-1, INEXACT) // -3.852559581298397738298444625826e-04
T(RD,  -0x1.4f747a7e0db9dp-24,  -0x1.4f747a7e0dba4p-24,  -0x1.ffff54p-1, INEXACT) // -7.810420218986614154442032738682e-08
T(RU,  -0x1.4f747a7e0db9dp-24,  -0x1.4f747a7e0dba3p-24,  0x1.585946p-18, INEXACT) // -7.810420218986614154442032738682e-08
T(RZ,  -0x1.4f747a7e0db9dp-24,  -0x1.4f747a7e0dba3p-24,  0x1.585946p-18, INEXACT) // -7.810420218986614154442032738682e-08
T(RD,   0x1.20f9d1b88516dp-16,   0x1.20f9d1b8c2756p-16,  -0x1.ffff52p-1, INEXACT) // 1.722430326552128342543386552155e-05
T(RU,   0x1.20f9d1b88516dp-16,   0x1.20f9d1b8c2757p-16,   0x1.5c2f7p-18, INEXACT) // 1.722430326552128342543386552155e-05
T(RZ,   0x1.20f9d1b88516dp-16,   0x1.20f9d1b8c2756p-16,  -0x1.ffff52p-1, INEXACT) // 1.722430326552128342543386552155e-05
T(RN,   0x1.fdbd692c7c354p-10,   0x1.fdbd7e39d2a52p-10,  -0x1.ffffdcp-2, INEXACT) // 1.944503349587918712704226464894e-03
T(RD,   -0x1.23aa57f2caa95p-4,   -0x1.23e9964d6ba8ap-4,  -0x1.ffffacp-1, INEXACT) // -7.120737414212847948835616307406e-02
T(RU,   -0x1.23aa57f2caa95p-4,   -0x1.23e9964d6ba89p-4,   0x1.515a2p-19, INEXACT) // -7.120737414212847948835616307406e-02
T(RZ,   -0x1.23aa57f2caa95p-4,   -0x1.23e9964d6ba89p-4,   0x1.515a2p-19, INEXACT) // -7.120737414212847948835616307406e-02
T(RN,    0x1.8d5d2bcb82d73p-8,    0x1.8d5dcb5c812b9p-8,  -0x1.fffe8ep-2, INEXACT) // 6.063292686586552009131434459732e-03
T(RD,  -0x1.423fb5382ae35p-14,  -0x1.423fb53d7c87cp-14,  -0x1.ffffa4p-1, INEXACT) // -7.683011506525660669082028464416e-05
T(RU,  -0x1.423fb5382ae35p-14,  -0x1.423fb53d7c87bp-14,  0x1.6fb668p-19, INEXACT) // -7.683011506525660669082028464416e-05
T(RZ,  -0x1.423fb5382ae35p-14,  -0x1.423fb53d7c87bp-14,  0x1.6fb668p-19, INEXACT) // -7.683011506525660669082028464416e-05
T(RD,  -0x1.5e017fc1b6765p-16,  -0x1.5e017fc223813p-16,  -0x1.ffff8cp-1, INEXACT) // -2.086197469606340890451064151723e-05
T(RU,  -0x1.5e017fc1b6765p-16,  -0x1.5e017fc223812p-16,  0x1.cc621cp-19, INEXACT) // -2.086197469606340890451064151723e-05
T(RZ,  -0x1.5e017fc1b6765p-16,  -0x1.5e017fc223812p-16,  0x1.cc621cp-19, INEXACT) // -2.086197469606340890451064151723e-05
T(RN,  -0x1.f327f537eef37p-15,  -0x1.f327f53ce016dp-15,  -0x1.fffef4p-2, INEXACT) // -5.950404232587943952710249351234e-05
T(RN,  -0x1.08edfcbe2ab51p-11,  -0x1.08edfd7b52af7p-11,  -0x1.ffff0ap-2, INEXACT) // -5.053131824487110514490528778708e-04
T(RN,    0x1.8ae9aa859801dp-6,    0x1.8af3753df7921p-6,   0x1.fffe52p-2, INEXACT) // 2.410356190227968056771779004066e-02
T(RN,    0x1.a26e0b3f97fedp-1,    0x1.e9c982ba0c6c5p-1,  -0x1.ffffdcp-2, INEXACT) // 8.172458186272685276563265688310e-01
T(RD,  -0x1.71373f60b8e84p-25,  -0x1.71373f60b8e86p-25, -0x1.59670ep-20, INEXACT) // -4.298237744006431946930228433362e-08
T(RU,  -0x1.71373f60b8e84p-25,  -0x1.71373f60b8e85p-25,   0x1.ffffd4p-1, INEXACT) // -4.298237744006431946930228433362e-08
T(RZ,  -0x1.71373f60b8e84p-25,  -0x1.71373f60b8e85p-25,   0x1.ffffd4p-1, INEXACT) // -4.298237744006431946930228433362e-08
T(RD,   -0x1.bc8e9b8d02b26p-4,   -0x1.bd6f3c47ecde2p-4,  -0x1.ffff82p-1, INEXACT) // -1.085344387248992903405309107256e-01
T(RU,   -0x1.bc8e9b8d02b26p-4,   -0x1.bd6f3c47ecde1p-4,  0x1.fbce8ep-19, INEXACT) // -1.085344387248992903405309107256e-01
T(RZ,   -0x1.bc8e9b8d02b26p-4,   -0x1.bd6f3c47ecde1p-4,  0x1.fbce8ep-19, INEXACT) // -1.085344387248992903405309107256e-01
T(RN,  -0x1.211037d957208p-10,  -0x1.21103bb025a9ap-10,  -0x1.fffe98p-2, INEXACT) // -1.102689179183548653928603755503e-03
T(RD,   0x1.a1f1059303fb6p-14,   0x1.a1f1059e9e856p-14, -0x1.e6be08p-20, INEXACT) // 9.964501650494461313344041197837e-05
T(RU,   0x1.a1f1059303fb6p-14,   0x1.a1f1059e9e857p-14,   0x1.ffffc4p-1, INEXACT) // 9.964501650494461313344041197837e-05
T(RZ,   0x1.a1f1059303fb6p-14,   0x1.a1f1059e9e856p-14, -0x1.e6be08p-20, INEXACT) // 9.964501650494461313344041197837e-05
T(RD,  -0x1.a6a58098183b3p-25,  -0x1.a6a58098183b6p-25, -0x1.15d4cep-18, INEXACT) // -4.920252755290686292861693728294e-08
T(RU,  -0x1.a6a58098183b3p-25,  -0x1.a6a58098183b5p-25,   0x1.ffff76p-1, INEXACT) // -4.920252755290686292861693728294e-08
T(RZ,  -0x1.a6a58098183b3p-25,  -0x1.a6a58098183b5p-25,   0x1.ffff76p-1, INEXACT) // -4.920252755290686292861693728294e-08
T(RN,    0x1.241852c2134e2p-1,    0x1.36d7681431861p-1,  -0x1.ffff88p-2, INEXACT) // 5.704980718525372029858999667340e-01
T(RN,    0x1.98c6bf7076fd9p-4,    0x1.99753dd56f809p-4,  -0x1.ffffd6p-2, INEXACT) // 9.979891568167377491338498884943e-02
T(RN,   -0x1.8415f3feae7d6p-4,   -0x1.84ab33ce6f4f8p-4,  -0x1.ffffcep-2, INEXACT) // -9.474749861229211922442061677430e-02
T(RD,  -0x1.0b2da3591fec4p-11,  -0x1.0b2da41b236abp-11,  -0x1.ffffc2p-1, INEXACT) // -5.096021151444686710096920734259e-04
T(RU,  -0x1.0b2da3591fec4p-11,  -0x1.0b2da41b236aap-11,  0x1.ef2748p-20, INEXACT) // -5.096021151444686710096920734259e-04
T(RZ,  -0x1.0b2da3591fec4p-11,  -0x1.0b2da41b236aap-11,  0x1.ef2748p-20, INEXACT) // -5.096021151444686710096920734259e-04
T(RN,    0x1.fb4e4f50ac38bp-2,    0x1.096065718ab06p-1,   0x1.fffe1cp-2, INEXACT) // 4.954159157742245578326389932045e-01
T(RD,   0x1.6a0deb17ea509p-12,   0x1.6a0deb909c4d3p-12, -0x1.21fe54p-18, INEXACT) // 3.452819523724481192740454194023e-04
T(RU,   0x1.6a0deb17ea509p-12,   0x1.6a0deb909c4d4p-12,    0x1.ffff7p-1, INEXACT) // 3.452819523724481192740454194023e-04
T(RZ,   0x1.6a0deb17ea509p-12,   0x1.6a0deb909c4d3p-12, -0x1.21fe54p-18, INEXACT) // 3.452819523724481192740454194023e-04
T(RD,   0x1.cbe8afcf84d1dp-13,   0x1.cbe8b00d5ddc5p-13, -0x1.52895ep-18, INEXACT) // 2.193016684804782268167905323608e-04
T(RU,   0x1.cbe8afcf84d1dp-13,   0x1.cbe8b00d5ddc6p-13,   0x1.ffff56p-1, INEXACT) // 2.193016684804782268167905323608e-04
T(RZ,   0x1.cbe8afcf84d1dp-13,   0x1.cbe8b00d5ddc5p-13, -0x1.52895ep-18, INEXACT) // 2.193016684804782268167905323608e-04
T(RD,    0x1.77e23208018b3p-9,    0x1.77e253cbeb971p-9,  -0x1.ffff26p-1, INEXACT) // 2.867764098485181458592085945725e-03
T(RU,    0x1.77e23208018b3p-9,    0x1.77e253cbeb972p-9,   0x1.b3f06p-18, INEXACT) // 2.867764098485181458592085945725e-03
T(RZ,    0x1.77e23208018b3p-9,    0x1.77e253cbeb971p-9,  -0x1.ffff26p-1, INEXACT) // 2.867764098485181458592085945725e-03
T(RD,    0x1.e7cde1c6a1ca7p-8,    0x1.e7cf08f9d3a3dp-8, -0x1.a7be86p-20, INEXACT) // 7.443301793166024436787520102143e-03
T(RU,    0x1.e7cde1c6a1ca7p-8,    0x1.e7cf08f9d3a3ep-8,   0x1.ffffccp-1, INEXACT) // 7.443301793166024436787520102143e-03
T(RZ,    0x1.e7cde1c6a1ca7p-8,    0x1.e7cf08f9d3a3dp-8, -0x1.a7be86p-20, INEXACT) // 7.443301793166024436787520102143e-03
T(RN,   -0x1.f221ef68343c8p-7,   -0x1.f226d8e8c6b61p-7,  -0x1.fffeb2p-2, INEXACT) // -1.520179929539890173462168831975e-02
T(RD,   0x1.7137483b1a394p-25,   0x1.7137483b1a396p-25,  -0x1.e7c29p-21, INEXACT) // 4.298239316623567219995008612671e-08
T(RU,   0x1.7137483b1a394p-25,   0x1.7137483b1a397p-25,   0x1.ffffe2p-1, INEXACT) // 4.298239316623567219995008612671e-08
T(RZ,   0x1.7137483b1a394p-25,   0x1.7137483b1a396p-25,  -0x1.e7c29p-21, INEXACT) // 4.298239316623567219995008612671e-08
T(RD,  -0x1.fec4932ad6316p-19,  -0x1.fec4932adb7cfp-19,   -0x1.ffffep-1, INEXACT) // -3.805517186189129442790406859798e-06
T(RU,  -0x1.fec4932ad6316p-19,  -0x1.fec4932adb7cep-19,  0x1.f56888p-21, INEXACT) // -3.805517186189129442790406859798e-06
T(RZ,  -0x1.fec4932ad6316p-19,  -0x1.fec4932adb7cep-19,  0x1.f56888p-21, INEXACT) // -3.805517186189129442790406859798e-06
T(RD,    0x1.5674e86517abp-11,    0x1.5674e9fda49bp-11, -0x1.4edb48p-18, INEXACT) // 6.531842633526654257059007591124e-04
T(RU,    0x1.5674e86517abp-11,   0x1.5674e9fda49b1p-11,   0x1.ffff58p-1, INEXACT) // 6.531842633526654257059007591124e-04
T(RZ,    0x1.5674e86517abp-11,    0x1.5674e9fda49bp-11, -0x1.4edb48p-18, INEXACT) // 6.531842633526654257059007591124e-04
T(RN,   -0x1.bc2e262abec56p-1,   -0x1.0cdc21306ce01p+0,    0x1.ffff9p-2, INEXACT) // -8.675395896128843542527420140686e-01
T(RD,   0x1.d729a973511eap-22,   0x1.d729a973512f4p-22, -0x1.2b8bd6p-19, INEXACT) // 4.388044978108004174019462530210e-07
T(RU,   0x1.d729a973511eap-22,   0x1.d729a973512f5p-22,   0x1.ffffb6p-1, INEXACT) // 4.388044978108004174019462530210e-07
T(RZ,   0x1.d729a973511eap-22,   0x1.d729a973512f4p-22, -0x1.2b8bd6p-19, INEXACT) // 4.388044978108004174019462530210e-07
T(RN,   0x1.79c9f9e294a4ep-21,   0x1.79c9f9e294c72p-21,  -0x1.ffff3ep-2, INEXACT) // 7.036867909016742742397054408143e-07
T(RN,    0x1.4b84e3b17493p-13,   0x1.4b84e3c89ed82p-13,   0x1.fffe56p-2, INEXACT) // 1.580806252108961883207083332081e-04
T(RN,  -0x1.011335ad11bd1p-12,  -0x1.011335d84696cp-12,   0x1.fffe88p-2, INEXACT) // -2.451658609214343365924337891926e-04
T(RN,  -0x1.713762dd43ad3p-26,  -0x1.713762dd43ad4p-26,  -0x1.ffff82p-2, INEXACT) // -2.149122023836894581326054695213e-08
T(RN,   0x1.f279a0ac4748cp-12,   0x1.f279a1e745316p-12,  -0x1.fffe2ap-2, INEXACT) // 4.753829077957592418729459993187e-04
T(RD,   -0x1.d26c5659511bep-7,   -0x1.d2705ea7e0c86p-7, -0x1.08ec88p-18, INEXACT) // -1.423410621885856305879336503040e-02
T(RU,   -0x1.d26c5659511bep-7,   -0x1.d2705ea7e0c85p-7,   0x1.ffff7cp-1, INEXACT) // -1.423410621885856305879336503040e-02
T(RZ,   -0x1.d26c5659511bep-7,   -0x1.d2705ea7e0c85p-7,   0x1.ffff7cp-1, INEXACT) // -1.423410621885856305879336503040e-02
T(RN,  -0x1.a1ba7f88456afp-21,  -0x1.a1ba7f8845995p-21,  -0x1.ffff92p-2, INEXACT) // -7.780799800317831345925346890613e-07
T(RD,   0x1.f9bb443b58581p-18,   0x1.f9bb443b6ce74p-18, -0x1.20527ep-18, INEXACT) // 7.535986749602846514683399808954e-06
T(RU,   0x1.f9bb443b58581p-18,   0x1.f9bb443b6ce75p-18,    0x1.ffff7p-1, INEXACT) // 7.535986749602846514683399808954e-06
T(RZ,   0x1.f9bb443b58581p-18,   0x1.f9bb443b6ce74p-18, -0x1.20527ep-18, INEXACT) // 7.535986749602846514683399808954e-06
T(RD,   -0x1.ebe5efa2542ep-20,  -0x1.ebe5efa2555ccp-20,  -0x1.ffff98p-1, INEXACT) // -1.832463546753443784775167157974e-06
T(RU,   -0x1.ebe5efa2542ep-20,  -0x1.ebe5efa2555cbp-20,  0x1.a1a03ep-19, INEXACT) // -1.832463546753443784775167157974e-06
T(RZ,   -0x1.ebe5efa2542ep-20,  -0x1.ebe5efa2555cbp-20,  0x1.a1a03ep-19, INEXACT) // -1.832463546753443784775167157974e-06
T(RN,    0x1.8a67883d31c1p-10,   0x1.8a6791fd98bdap-10,    0x1.fffeep-2, INEXACT) // 1.504533472415085088025321624627e-03
T(RD,   0x1.250bfdf77203ap-25,   0x1.250bfdf77203ap-25,         -0x1p+0, INEXACT) // 3.411514265142917427191504272169e-08
T(RU,   0x1.250bfdf77203ap-25,   0x1.250bfdf77203bp-25,  0x1.750d9ap-26, INEXACT) // 3.411514265142917427191504272169e-08
T(RZ,   0x1.250bfdf77203ap-25,   0x1.250bfdf77203ap-25,         -0x1p+0, INEXACT) // 3.411514265142917427191504272169e-08
T(RD,  -0x1.988a6bed2d96dp-15,  -0x1.988a6befe33afp-15, -0x1.e970e6p-20, INEXACT) // -4.870184771148503320237557745465e-05
T(RU,  -0x1.988a6bed2d96dp-15,  -0x1.988a6befe33aep-15,   0x1.ffffc2p-1, INEXACT) // -4.870184771148503320237557745465e-05
T(RZ,  -0x1.988a6bed2d96dp-15,  -0x1.988a6befe33aep-15,   0x1.ffffc2p-1, INEXACT) // -4.870184771148503320237557745465e-05
T(RN,  -0x1.8d02b4f815c89p-11,  -0x1.8d02b774a3913p-11,  -0x1.ffffd6p-2, INEXACT) // -7.572375752812481085676776793036e-04
T(RN,   -0x1.1c0460b535737p-3,   -0x1.1cef79a80eb45p-3,  -0x1.ffffc4p-2, INEXACT) // -1.386802249241385343037080701833e-01
T(RN,   0x1.ba9a155915c53p-22,    0x1.ba9a155915d3p-22,   0x1.fffe5ap-2, INEXACT) // 4.122051300894957799585561607908e-07
T(RD,    0x1.8866fd35023c8p-1,    0x1.bf189dcd019ebp-1, -0x1.628956p-19, INEXACT) // 7.664107444007806080321643094067e-01
T(RU,    0x1.8866fd35023c8p-1,    0x1.bf189dcd019ecp-1,   0x1.ffffa8p-1, INEXACT) // 7.664107444007806080321643094067e-01
T(RZ,    0x1.8866fd35023c8p-1,    0x1.bf189dcd019ebp-1, -0x1.628956p-19, INEXACT) // 7.664107444007806080321643094067e-01
T(RN,    0x1.c898f510506bbp-9,    0x1.c8993195e461bp-9,  -0x1.fffe24p-2, INEXACT) // 3.483562388425590680002263965775e-03
T(RN,   0x1.71374b1030758p-26,   0x1.71374b1030759p-26,   0x1.ffffe4p-2, INEXACT) // 2.149119909876822147222084815471e-08
T(RD,   0x1.7137445dae51cp-24,   0x1.7137445dae523p-24,  -0x1.fffffap-1, INEXACT) // 8.596477260148969881678264991220e-08
T(RU,   0x1.7137445dae51cp-24,   0x1.7137445dae524p-24,  0x1.ac28e2p-23, INEXACT) // 8.596477260148969881678264991220e-08
T(RZ,   0x1.7137445dae51cp-24,   0x1.7137445dae523p-24,  -0x1.fffffap-1, INEXACT) // 8.596477260148969881678264991220e-08
T(RN,   -0x1.f085e10cd6c33p-5,   -0x1.f0d3d59cefb02p-5,  -0x1.fffe94p-2, INEXACT) // -6.061071353061499994430150195512e-02
T(RN,   0x1.3905b282a5d72p-23,   0x1.3905b282a5d85p-23,  -0x1.fffe66p-2, INEXACT) // 1.457623462666150448151811212100e-07
T(RN,   0x1.f00dc30ee344bp-18,   0x1.f00dc30ef6ab7p-18,  -0x1.fffedep-2, INEXACT) // 7.391777002830017229649799820335e-06
T(RN,     0x1.7ff15b7ff416p-6,    0x1.7ffa5b0a2a56cp-6,   0x1.fffe42p-2, INEXACT) // 2.343400893715974486752884331509e-02
T(RD,   0x1.a6a58e0eaf7d5p-24,   0x1.a6a58e0eaf7e1p-24, -0x1.f7b3c6p-21, INEXACT) // 9.840510293687024050152670944305e-08
T(RU,   0x1.a6a58e0eaf7d5p-24,   0x1.a6a58e0eaf7e2p-24,    0x1.ffffep-1, INEXACT) // 9.840510293687024050152670944305e-08
T(RZ,   0x1.a6a58e0eaf7d5p-24,   0x1.a6a58e0eaf7e1p-24, -0x1.f7b3c6p-21, INEXACT) // 9.840510293687024050152670944305e-08
T(RN,   0x1.fcf976d8ca0f5p-13,   0x1.fcf9772c9e68fp-13,   0x1.ffff64p-2, INEXACT) // 2.426979397338668647480380835546e-04
T(RD,  -0x1.c215e44754264p-20,  -0x1.c215e447550e2p-20, -0x1.631fa6p-19, INEXACT) // -1.676699200665312227949508422364e-06
T(RU,  -0x1.c215e44754264p-20,  -0x1.c215e447550e1p-20,   0x1.ffffa8p-1, INEXACT) // -1.676699200665312227949508422364e-06
T(RZ,  -0x1.c215e44754264p-20,  -0x1.c215e447550e1p-20,   0x1.ffffa8p-1, INEXACT) // -1.676699200665312227949508422364e-06
T(RD,   -0x1.deef228f87abap-6,   -0x1.df009a5e7b919p-6, -0x1.4d3278p-18, INEXACT) // -2.923181891503177226576681846382e-02
T(RU,   -0x1.deef228f87abap-6,   -0x1.df009a5e7b918p-6,   0x1.ffff5ap-1, INEXACT) // -2.923181891503177226576681846382e-02
T(RZ,   -0x1.deef228f87abap-6,   -0x1.df009a5e7b918p-6,   0x1.ffff5ap-1, INEXACT) // -2.923181891503177226576681846382e-02
T(RD,   0x1.467b2e8b91151p-20,   0x1.467b2e8b916d8p-20,  -0x1.ffff5cp-1, INEXACT) // 1.216237168658979603429377315538e-06
T(RU,   0x1.467b2e8b91151p-20,   0x1.467b2e8b916d9p-20,  0x1.462ec6p-18, INEXACT) // 1.216237168658979603429377315538e-06
T(RZ,   0x1.467b2e8b91151p-20,   0x1.467b2e8b916d8p-20,  -0x1.ffff5cp-1, INEXACT) // 1.216237168658979603429377315538e-06
T(RN,   -0x1.cedebc7cb2b78p-4,   -0x1.cfdc65b3f0957p-4,   0x1.fffed8p-2, INEXACT) // -1.130053866174146603995609439153e-01
T(RN,  -0x1.bcee7e0d314e2p-25,  -0x1.bcee7e0d314e6p-25,  -0x1.fffec2p-2, INEXACT) // -5.179685667317384072727218117041e-08
T(RD,  -0x1.ec9bab43ed6a6p-24,  -0x1.ec9bab43ed6b9p-24, -0x1.e747b4p-18, INEXACT) // -1.146942568131998408343736250634e-07
T(RU,  -0x1.ec9bab43ed6a6p-24,  -0x1.ec9bab43ed6b8p-24,   0x1.ffff0cp-1, INEXACT) // -1.146942568131998408343736250634e-07
T(RZ,  -0x1.ec9bab43ed6a6p-24,  -0x1.ec9bab43ed6b8p-24,   0x1.ffff0cp-1, INEXACT) // -1.146942568131998408343736250634e-07
T(RN,    0x1.5b3be4a1b1b71p-8,    0x1.5b3c4f1ade7c1p-8,   0x1.fffe24p-2, INEXACT) // 5.298369711176018938270093627807e-03
T(RD,   0x1.d12ebe7d5e73fp-26,   0x1.d12ebe7d5e73fp-26,  -0x1.ffffc4p-1, INEXACT) // 2.707719070269342028589911461952e-08
T(RU,   0x1.d12ebe7d5e73fp-26,    0x1.d12ebe7d5e74p-26,  0x1.e09be6p-20, INEXACT) // 2.707719070269342028589911461952e-08
T(RZ,   0x1.d12ebe7d5e73fp-26,   0x1.d12ebe7d5e73fp-26,  -0x1.ffffc4p-1, INEXACT) // 2.707719070269342028589911461952e-08
T(RN,   -0x1.224af2f8f96c2p-6,   -0x1.224ed683469c8p-6,   0x1.ffffcep-2, INEXACT) // -1.771806457317982169685777193990e-02
T(RD,  -0x1.a6a592d74cac8p-24,  -0x1.a6a592d74cad5p-24,   -0x1.ffff1p-1, INEXACT) // -9.840511993180349666223262830589e-08
T(RU,  -0x1.a6a592d74cac8p-24,  -0x1.a6a592d74cad4p-24,  0x1.e03384p-18, INEXACT) // -9.840511993180349666223262830589e-08
T(RZ,  -0x1.a6a592d74cac8p-24,  -0x1.a6a592d74cad4p-24,  0x1.e03384p-18, INEXACT) // -9.840511993180349666223262830589e-08
T(RD,  -0x1.713747a619496p-24,  -0x1.713747a61949fp-24,  -0x1.ffff9ap-1, INEXACT) // -8.596478426463016552849045939094e-08
T(RU,  -0x1.713747a619496p-24,  -0x1.713747a61949ep-24,  0x1.9a4664p-19, INEXACT) // -8.596478426463016552849045939094e-08
T(RZ,  -0x1.713747a619496p-24,  -0x1.713747a61949ep-24,  0x1.9a4664p-19, INEXACT) // -8.596478426463016552849045939094e-08
T(RD,   0x1.d8253ff51e121p-18,   0x1.d8253ff52eccbp-18,  -0x1.ffff18p-1, INEXACT) // 7.035516309199485995298176815860e-06
T(RU,   0x1.d8253ff51e121p-18,   0x1.d8253ff52ecccp-18,   0x1.ce0a2p-18, INEXACT) // 7.035516309199485995298176815860e-06
T(RZ,   0x1.d8253ff51e121p-18,   0x1.d8253ff52eccbp-18,  -0x1.ffff18p-1, INEXACT) // 7.035516309199485995298176815860e-06
T(RD,   -0x1.08e07d1cb9d11p-8,   -0x1.08e0ac5f94ba7p-8,  -0x1.fffffcp-1, INEXACT) // -4.041700882886149238937267824667e-03
T(RU,   -0x1.08e07d1cb9d11p-8,   -0x1.08e0ac5f94ba6p-8,  0x1.27fe88p-23, INEXACT) // -4.041700882886149238937267824667e-03
T(RZ,   -0x1.08e07d1cb9d11p-8,   -0x1.08e0ac5f94ba6p-8,  0x1.27fe88p-23, INEXACT) // -4.041700882886149238937267824667e-03
T(RN,  -0x1.284d36ba2d5f4p-20,  -0x1.284d36ba2da17p-20,  -0x1.ffff62p-2, INEXACT) // -1.103809536701579807540119643194e-06
T(RN,  -0x1.bcee7a85f0317p-25,  -0x1.bcee7a85f031bp-25,  -0x1.ffff18p-2, INEXACT) // -5.179685040558777956154671673165e-08
T(RN,  -0x1.6b7c732a21eebp-19,  -0x1.6b7c732a23d73p-19,   0x1.fffe68p-2, INEXACT) // -2.708182724356932672289113503417e-06
T(RN,    0x1.33c3e52e7dcd3p-3,    0x1.34ef7e253b16cp-3,  -0x1.ffff58p-2, INEXACT) // 1.502759842694333103363391046514e-01
T(RN,    0x1.1bef4459101a5p-2,    0x1.1fb4770f30cc3p-2,   0x1.fffe48p-2, INEXACT) // 2.772799186095887269409843156609e-01
T(RD,    0x1.8fd562b193e38p-4,    0x1.9078a4d2bfa27p-4, -0x1.8199fcp-18, INEXACT) // 9.761560966693927365867011758382e-02
T(RU,    0x1.8fd562b193e38p-4,    0x1.9078a4d2bfa28p-4,    0x1.ffff4p-1, INEXACT) // 9.761560966693927365867011758382e-02
T(RZ,    0x1.8fd562b193e38p-4,    0x1.9078a4d2bfa27p-4, -0x1.8199fcp-18, INEXACT) // 9.761560966693927365867011758382e-02
T(RD,  -0x1.6824c600a7279p-15,  -0x1.6824c60282552p-15,  -0x1.ffffccp-1, INEXACT) // -4.293246820916570119551838868865e-05
T(RU,  -0x1.6824c600a7279p-15,  -0x1.6824c60282551p-15,  0x1.9fc654p-20, INEXACT) // -4.293246820916570119551838868865e-05
T(RZ,  -0x1.6824c600a7279p-15,  -0x1.6824c60282551p-15,  0x1.9fc654p-20, INEXACT) // -4.293246820916570119551838868865e-05
T(RN,   0x1.1849ff06b1673p-24,   0x1.1849ff06b1676p-24,  -0x1.fffe42p-2, INEXACT) // 6.525987937118478085929943908680e-08
T(RD,    0x1.9ca98b68b289dp-1,    0x1.dfe9d5f072a7dp-1, -0x1.6d5e1cp-20, INEXACT) // 8.059810223869764422843786633166e-01
T(RU,    0x1.9ca98b68b289dp-1,    0x1.dfe9d5f072a7ep-1,   0x1.ffffd2p-1, INEXACT) // 8.059810223869764422843786633166e-01
T(RZ,    0x1.9ca98b68b289dp-1,    0x1.dfe9d5f072a7dp-1, -0x1.6d5e1cp-20, INEXACT) // 8.059810223869764422843786633166e-01
T(RD,   0x1.f2156cf8449f5p-15,   0x1.f2156cfd2d9fap-15,  -0x1.ffff14p-1, INEXACT) // 5.937620329822874449968508892006e-05
T(RU,   0x1.f2156cf8449f5p-15,   0x1.f2156cfd2d9fbp-15,  0x1.d64634p-18, INEXACT) // 5.937620329822874449968508892006e-05
T(RZ,   0x1.f2156cf8449f5p-15,   0x1.f2156cfd2d9fap-15,  -0x1.ffff14p-1, INEXACT) // 5.937620329822874449968508892006e-05
T(RD,  -0x1.cbbc0517a6a79p-15,  -0x1.cbbc051b83181p-15,   -0x1.ffff8p-1, INEXACT) // -5.480461748881988839942128177718e-05
T(RU,  -0x1.cbbc0517a6a79p-15,   -0x1.cbbc051b8318p-15,  0x1.00a68ap-18, INEXACT) // -5.480461748881988839942128177718e-05
T(RZ,  -0x1.cbbc0517a6a79p-15,   -0x1.cbbc051b8318p-15,  0x1.00a68ap-18, INEXACT) // -5.480461748881988839942128177718e-05
T(RD,   0x1.691b51d5df152p-20,   0x1.691b51d5df8cdp-20,  -0x1.ffff8ap-1, INEXACT) // 1.345227351261838697897609343213e-06
T(RU,   0x1.691b51d5df152p-20,   0x1.691b51d5df8cep-20,   0x1.d97fbp-19, INEXACT) // 1.345227351261838697897609343213e-06
T(RZ,   0x1.691b51d5df152p-20,   0x1.691b51d5df8cdp-20,  -0x1.ffff8ap-1, INEXACT) // 1.345227351261838697897609343213e-06
T(RN,  -0x1.fb078ab10407ap-13,  -0x1.fb078b03e34a9p-13,  -0x1.fffefep-2, INEXACT) // -2.417704868382697142199788675754e-04
T(RN,    0x1.a701af8d5da62p-3,    0x1.aa12d141b4a41p-3,   0x1.ffffdcp-2, INEXACT) // 2.065461840645240187974707168905e-01
T(RN,  -0x1.0822a114aaee2p-12,  -0x1.0822a143885a9p-12,  -0x1.ffff9cp-2, INEXACT) // -2.518990234345719727085399775035e-04
T(RN,  -0x1.8b320a17a5af7p-13,  -0x1.8b320a3ee37d1p-13,  -0x1.fffe6cp-2, INEXACT) // -1.884438831793661453788829573952e-04
T(RD,  -0x1.e8cc3a3836111p-22,  -0x1.e8cc3a383623ap-22, -0x1.f176a2p-23, INEXACT) // -4.552283914389220116962985699521e-07
T(RU,  -0x1.e8cc3a3836111p-22,  -0x1.e8cc3a3836239p-22,   0x1.fffff8p-1, INEXACT) // -4.552283914389220116962985699521e-07
T(RZ,  -0x1.e8cc3a3836111p-22,  -0x1.e8cc3a3836239p-22,   0x1.fffff8p-1, INEXACT) // -4.552283914389220116962985699521e-07
T(RD,   0x1.c4a3e9148c975p-13,   0x1.c4a3e94f82bb3p-13,  -0x1.ffffe2p-1, INEXACT) // 2.158357025493041830236512490515e-04
T(RU,   0x1.c4a3e9148c975p-13,   0x1.c4a3e94f82bb4p-13,  0x1.ea8f8ep-21, INEXACT) // 2.158357025493041830236512490515e-04
T(RZ,   0x1.c4a3e9148c975p-13,   0x1.c4a3e94f82bb3p-13,  -0x1.ffffe2p-1, INEXACT) // 2.158357025493041830236512490515e-04
T(RN,   0x1.1ff35b1ea2714p-20,    0x1.1ff35b1ea2aep-20,   0x1.ffff2cp-2, INEXACT) // 1.072699610612413269686033628902e-06
T(RN,    0x1.3034782680f1ap-6,    0x1.3038f1cefd86fp-6,  -0x1.ffff8ap-2, INEXACT) // 1.856719716489783206236907631137e-02
T(RN,  -0x1.d9ad54cec03a9p-20,  -0x1.d9ad54cec148dp-20,   0x1.ffffb2p-2, INEXACT) // -1.764584613262097610516415148452e-06
T(RN,   0x1.d8b3de0881c24p-16,   0x1.d8b3de098e602p-16,   0x1.fffeeep-2, INEXACT) // 2.817527095724468562485537370677e-05
T(RD,   -0x1.773217eda7fdep-1,   -0x1.a5160b460bb1cp-1,  -0x1.ffffc6p-1, INEXACT) // -7.328040578468024701663807718433e-01
T(RU,   -0x1.773217eda7fdep-1,   -0x1.a5160b460bb1bp-1,  0x1.d1938ep-20, INEXACT) // -7.328040578468024701663807718433e-01
T(RZ,   -0x1.773217eda7fdep-1,   -0x1.a5160b460bb1bp-1,  0x1.d1938ep-20, INEXACT) // -7.328040578468024701663807718433e-01
T(RD,   0x1.80e307e79c1ecp-22,   0x1.80e307e79c27dp-22, -0x1.cae7aap-23, INEXACT) // 3.584538021744656637192867273956e-07
T(RU,   0x1.80e307e79c1ecp-22,   0x1.80e307e79c27ep-22,   0x1.fffff8p-1, INEXACT) // 3.584538021744656637192867273956e-07
T(RZ,   0x1.80e307e79c1ecp-22,   0x1.80e307e79c27dp-22, -0x1.cae7aap-23, INEXACT) // 3.584538021744656637192867273956e-07
T(RN,    0x1.1de197b679271p-2,    0x1.21bb46c3407bfp-2,  -0x1.fffeeap-2, INEXACT) // 2.791808800814470914453124805732e-01
T(RD,   -0x1.3f6a0a594b358p-7,   -0x1.3f6b55de7d5c1p-7, -0x1.afb248p-18, INEXACT) // -9.747748425604704780589315760153e-03
T(RU,   -0x1.3f6a0a594b358p-7,    -0x1.3f6b55de7d5cp-7,   0x1.ffff28p-1, INEXACT) // -9.747748425604704780589315760153e-03
T(RZ,   -0x1.3f6a0a594b358p-7,    -0x1.3f6b55de7d5cp-7,   0x1.ffff28p-1, INEXACT) // -9.747748425604704780589315760153e-03
T(RD,   -0x1.88bf19a011b19p-2,    -0x1.931338e2424bp-2, -0x1.a9acd6p-19, INEXACT) // -3.835414890240130270093743547477e-01
T(RU,   -0x1.88bf19a011b19p-2,   -0x1.931338e2424afp-2,   0x1.ffff96p-1, INEXACT) // -3.835414890240130270093743547477e-01
T(RZ,   -0x1.88bf19a011b19p-2,   -0x1.931338e2424afp-2,   0x1.ffff96p-1, INEXACT) // -3.835414890240130270093743547477e-01
T(RN,   0x1.b143a282c4434p-14,   0x1.b143a28fb1a5bp-14,   0x1.fffeeap-2, INEXACT) // 1.032982345743484295548519913410e-04
T(RD,    0x1.334e30ff6037bp-5,    0x1.3360a7717c245p-5,   -0x1.ffff7p-1, INEXACT) // 3.751287050091086511249827140091e-02
T(RU,    0x1.334e30ff6037bp-5,    0x1.3360a7717c246p-5,   0x1.1f848p-18, INEXACT) // 3.751287050091086511249827140091e-02
T(RZ,    0x1.334e30ff6037bp-5,    0x1.3360a7717c245p-5,   -0x1.ffff7p-1, INEXACT) // 3.751287050091086511249827140091e-02
T(RN,   -0x1.f455be76c4c3ap-8,   -0x1.f456fd00c4e21p-8,  -0x1.ffff7cp-2, INEXACT) // -7.634505271897623970844826146731e-03
T(RD,    0x1.b2c36385cf2ep-15,   0x1.b2c363891324ap-15, -0x1.624f22p-18, INEXACT) // 5.182781664678725273842641030342e-05
T(RU,    0x1.b2c36385cf2ep-15,   0x1.b2c363891324bp-15,   0x1.ffff4ep-1, INEXACT) // 5.182781664678725273842641030342e-05
T(RZ,    0x1.b2c36385cf2ep-15,   0x1.b2c363891324ap-15, -0x1.624f22p-18, INEXACT) // 5.182781664678725273842641030342e-05
T(RD,   0x1.440436b9d73a4p-16,    0x1.440436ba2dbdp-16, -0x1.03166ep-19, INEXACT) // 1.931288600275398641224061657695e-05
T(RU,   0x1.440436b9d73a4p-16,   0x1.440436ba2dbd1p-16,    0x1.ffffcp-1, INEXACT) // 1.931288600275398641224061657695e-05
T(RZ,   0x1.440436b9d73a4p-16,    0x1.440436ba2dbdp-16, -0x1.03166ep-19, INEXACT) // 1.931288600275398641224061657695e-05
T(RD,   -0x1.cc0dc142505ap-20,  -0x1.cc0dc1425151ap-20, -0x1.401dc6p-18, INEXACT) // -1.713833697694927169722506343774e-06
T(RU,   -0x1.cc0dc142505ap-20,  -0x1.cc0dc14251519p-20,    0x1.ffff6p-1, INEXACT) // -1.713833697694927169722506343774e-06
T(RZ,   -0x1.cc0dc142505ap-20,  -0x1.cc0dc14251519p-20,    0x1.ffff6p-1, INEXACT) // -1.713833697694927169722506343774e-06
T(RD,  -0x1.d73449d28b91fp-17,  -0x1.d73449d2ce167p-17, -0x1.500f82p-18, INEXACT) // -1.404298101189950568029162630834e-05
T(RU,  -0x1.d73449d28b91fp-17,  -0x1.d73449d2ce166p-17,   0x1.ffff58p-1, INEXACT) // -1.404298101189950568029162630834e-05
T(RZ,  -0x1.d73449d28b91fp-17,  -0x1.d73449d2ce166p-17,   0x1.ffff58p-1, INEXACT) // -1.404298101189950568029162630834e-05
T(RN,    0x1.cdffbd6569199p-2,    0x1.df4f8daa195abp-2,  -0x1.ffffd6p-2, INEXACT) // 4.511708825250707044496323305793e-01
T(RD,   0x1.96b0480fcd703p-20,   0x1.96b0480fce1b3p-20,  -0x1.ffff46p-1, INEXACT) // 1.515033094490745989668212083401e-06
T(RU,   0x1.96b0480fcd703p-20,   0x1.96b0480fce1b4p-20,  0x1.75151ep-18, INEXACT) // 1.515033094490745989668212083401e-06
T(RZ,   0x1.96b0480fcd703p-20,   0x1.96b0480fce1b3p-20,  -0x1.ffff46p-1, INEXACT) // 1.515033094490745989668212083401e-06
T(RN,   -0x1.63c147e170e81p-5,   -0x1.63ddee621d85ap-5,   0x1.ffff34p-2, INEXACT) // -4.342712439713825728349050336874e-02
T(RD,  -0x1.fd51bcb4cfb2bp-24,   -0x1.fd51bcb4cfb4p-24, -0x1.3290d6p-18, INEXACT) // -1.185851371100959992364948995640e-07
T(RU,  -0x1.fd51bcb4cfb2bp-24,  -0x1.fd51bcb4cfb3fp-24,   0x1.ffff66p-1, INEXACT) // -1.185851371100959992364948995640e-07
T(RZ,  -0x1.fd51bcb4cfb2bp-24,  -0x1.fd51bcb4cfb3fp-24,   0x1.ffff66p-1, INEXACT) // -1.185851371100959992364948995640e-07
T(RN,  -0x1.bd86856207d66p-19,  -0x1.bd8685620b59fp-19,   0x1.fffff6p-2, INEXACT) // -3.319423442796061097983650184373e-06
T(RN,   -0x1.d285cbb7f585ep-1,   -0x1.2568e5da2470bp+0,  -0x1.ffff84p-2, INEXACT) // -9.111770307597557572165669625974e-01
T(RN,  -0x1.4e53209a9c892p-13,  -0x1.4e5320b25ea54p-13,  -0x1.fffe4ep-2, INEXACT) // -1.594184476121957732587530731649e-04
T(RD,    0x1.0b6886dfd71d8p-4,    0x1.0b993fc88da02p-4, -0x1.97c31ap-18, INEXACT) // 6.528523145011122519321133950143e-02
T(RU,    0x1.0b6886dfd71d8p-4,    0x1.0b993fc88da03p-4,   0x1.ffff34p-1, INEXACT) // 6.528523145011122519321133950143e-02
T(RZ,    0x1.0b6886dfd71d8p-4,    0x1.0b993fc88da02p-4, -0x1.97c31ap-18, INEXACT) // 6.528523145011122519321133950143e-02
T(RN,    0x1.f7f504980269p-16,   0x1.f7f5049947e8cp-16,   0x1.fffe3ep-2, INEXACT) // 3.003818400774141634049230198400e-05
T(RD,   0x1.bcee70bb190f1p-22,    0x1.bcee70bb191dp-22,  -0x1.ffff6cp-1, INEXACT) // 4.143746640871074407858206615357e-07
T(RU,   0x1.bcee70bb190f1p-22,   0x1.bcee70bb191d1p-22,   0x1.26ddfp-18, INEXACT) // 4.143746640871074407858206615357e-07
T(RZ,   0x1.bcee70bb190f1p-22,    0x1.bcee70bb191dp-22,  -0x1.ffff6cp-1, INEXACT) // 4.143746640871074407858206615357e-07
T(RN,   -0x1.0155805819d8bp-1,   -0x1.0d9fd06d1f972p-1,  -0x1.ffffa6p-2, INEXACT) // -5.026054484887237938650628166215e-01
T(RD,  -0x1.2101ec7b52bc8p-14,  -0x1.2101ec7f28f93p-14,  -0x1.ffffc6p-1, INEXACT) // -6.890476099845257041548451937274e-05
T(RU,  -0x1.2101ec7b52bc8p-14,  -0x1.2101ec7f28f92p-14,  0x1.d3934cp-20, INEXACT) // -6.890476099845257041548451937274e-05
T(RZ,  -0x1.2101ec7b52bc8p-14,  -0x1.2101ec7f28f92p-14,  0x1.d3934cp-20, INEXACT) // -6.890476099845257041548451937274e-05
T(RD,    0x1.5f502548c28b4p-4,    0x1.5fbec7e5cc5e3p-4,   -0x1.ffff8p-1, INEXACT) // 8.576979221484998250346620807250e-02
T(RU,    0x1.5f502548c28b4p-4,    0x1.5fbec7e5cc5e4p-4,  0x1.0180dap-18, INEXACT) // 8.576979221484998250346620807250e-02
T(RZ,    0x1.5f502548c28b4p-4,    0x1.5fbec7e5cc5e3p-4,   -0x1.ffff8p-1, INEXACT) // 8.576979221484998250346620807250e-02
T(RN,   0x1.47912c7246d6ap-15,   0x1.47912c73ac61fp-15,   0x1.ffffe4p-2, INEXACT) // 3.904903941728372570880295500118e-05
T(RN,   0x1.741ff4bae79b2p-17,   0x1.741ff4bb085e5p-17,   0x1.fffe28p-2, INEXACT) // 1.109018409356236881829239904196e-05
T(RN,  -0x1.46b84e849b017p-14,  -0x1.46b84e8a261d5p-14,   0x1.fffe12p-2, INEXACT) // -7.789610578762293875611927296276e-05
T(RD,  -0x1.cb691a96bfc89p-17,  -0x1.cb691a96fd6e4p-17,  -0x1.ffff88p-1, INEXACT) // -1.369150167595939054422399944189e-05
T(RU,  -0x1.cb691a96bfc89p-17,  -0x1.cb691a96fd6e3p-17,  0x1.e32078p-19, INEXACT) // -1.369150167595939054422399944189e-05
T(RZ,  -0x1.cb691a96bfc89p-17,  -0x1.cb691a96fd6e3p-17,  0x1.e32078p-19, INEXACT) // -1.369150167595939054422399944189e-05
T(RN,    0x1.75a846323b3eep-2,     0x1.7e7d5d4a5818p-2,  -0x1.fffee6p-2, INEXACT) // 3.648997276457625060785971982114e-01
T(RN,  -0x1.4f7484c5b8e62p-25,  -0x1.4f7484c5b8e64p-25,  -0x1.ffff1cp-2, INEXACT) // -3.905211935580258800793795751286e-08
T(RN,   -0x1.b671494d576fdp-1,   -0x1.07334f18d4597p+0,  -0x1.fffe56p-2, INEXACT) // -8.563330561553069708580210317450e-01
T(RN,   0x1.3f48f502cfacep-14,   0x1.3f48f507fc174p-14,  -0x1.ffffe8p-2, INEXACT) // 7.612347330352849344818622068232e-05
T(RN,   0x1.4f7477728a0abp-25,   0x1.4f7477728a0adp-25,   0x1.ffffd4p-2, INEXACT) // 3.905209568596541543297824181612e-08
T(RN,   0x1.c2b9e7ed256bap-15,   0x1.c2b9e7f0c8e31p-15,   0x1.ffff72p-2, INEXACT) // 5.373074950758062213063831480397e-05
T(RN,   0x1.e516acb3593e1p-16,   0x1.e516acb47b884p-16,  -0x1.fffedcp-2, INEXACT) // 2.891353206048777923554450597354e-05
T(RD,   -0x1.9caf10770dcd7p-2,   -0x1.a8c2ab1a185eap-2,  -0x1.ffff2cp-1, INEXACT) // -4.030115673699134481999806212116e-01
T(RU,   -0x1.9caf10770dcd7p-2,   -0x1.a8c2ab1a185e9p-2,  0x1.a84948p-18, INEXACT) // -4.030115673699134481999806212116e-01
T(RZ,   -0x1.9caf10770dcd7p-2,   -0x1.a8c2ab1a185e9p-2,  0x1.a84948p-18, INEXACT) // -4.030115673699134481999806212116e-01
T(RN,  -0x1.2a0d35595a66ap-15,   -0x1.2a0d355a67bep-15,   0x1.ffff22p-2, INEXACT) // -3.553051892419836429743568162465e-05
T(RN,      0x1.eff7f69ea1cp-1,    0x1.51e48bca0380ap+0,   0x1.fffe46p-2, INEXACT) // 9.686886852877023557084612548351e-01
T(RD,    0x1.feb323e0759bcp-3,    0x1.0212bd3f6b915p-2,  -0x1.ffff1ap-1, INEXACT) // 2.493651202082228790501972071070e-01
T(RU,    0x1.feb323e0759bcp-3,    0x1.0212bd3f6b916p-2,  0x1.cbcabcp-18, INEXACT) // 2.493651202082228790501972071070e-01
T(RZ,    0x1.feb323e0759bcp-3,    0x1.0212bd3f6b915p-2,  -0x1.ffff1ap-1, INEXACT) // 2.493651202082228790501972071070e-01
T(RD,     -0x1.6a1eaed1cbp-12,  -0x1.6a1eaf4a8dc19p-12,  -0x1.ffffdap-1, INEXACT) // -3.453444052066156899627458187751e-04
T(RU,     -0x1.6a1eaed1cbp-12,  -0x1.6a1eaf4a8dc18p-12,  0x1.353ec2p-20, INEXACT) // -3.453444052066156899627458187751e-04
T(RZ,     -0x1.6a1eaed1cbp-12,  -0x1.6a1eaf4a8dc18p-12,  0x1.353ec2p-20, INEXACT) // -3.453444052066156899627458187751e-04
T(RN,   -0x1.23dc0ff36a831p-2,   -0x1.27f68a6d4b706p-2,  -0x1.ffff48p-2, INEXACT) // -2.850191585845350261685382520227e-01
T(RN,  -0x1.683114f78311ap-14,  -0x1.683114fef08a9p-14,  -0x1.fffebep-2, INEXACT) // -8.587639955965169756037236314938e-05
T(RD,  -0x1.beb3a49de586dp-14,  -0x1.beb3a4ac107a6p-14,  -0x1.ffff36p-1, INEXACT) // -1.065019918925228854149692137021e-04
T(RU,  -0x1.beb3a49de586dp-14,  -0x1.beb3a4ac107a5p-14,  0x1.95cc78p-18, INEXACT) // -1.065019918925228854149692137021e-04
T(RZ,  -0x1.beb3a49de586dp-14,  -0x1.beb3a4ac107a5p-14,  0x1.95cc78p-18, INEXACT) // -1.065019918925228854149692137021e-04
T(RD,    0x1.611bf6058a51ap-7,    0x1.611db5eb503f5p-7,  -0x1.ffff64p-1, INEXACT) // 1.077603829169731033954526822072e-02
T(RU,    0x1.611bf6058a51ap-7,    0x1.611db5eb503f6p-7,  0x1.36ba7ap-18, INEXACT) // 1.077603829169731033954526822072e-02
T(RZ,    0x1.611bf6058a51ap-7,    0x1.611db5eb503f5p-7,  -0x1.ffff64p-1, INEXACT) // 1.077603829169731033954526822072e-02
T(RD,    0x1.90c00bb125ab8p-9,    0x1.90c0349c93577p-9,  -0x1.ffff2ap-1, INEXACT) // 3.057481219524173926549437396716e-03
T(RU,    0x1.90c00bb125ab8p-9,    0x1.90c0349c93578p-9,  0x1.abce1cp-18, INEXACT) // 3.057481219524173926549437396716e-03
T(RZ,    0x1.90c00bb125ab8p-9,    0x1.90c0349c93577p-9,  -0x1.ffff2ap-1, INEXACT) // 3.057481219524173926549437396716e-03
T(RD,   -0x1.366c3b3a9e911p-2,   -0x1.3b62ab6fc339cp-2,  -0x1.ffff2ap-1, INEXACT) // -3.031472448852961520948667839548e-01
T(RU,   -0x1.366c3b3a9e911p-2,   -0x1.3b62ab6fc339bp-2,  0x1.ac4d7ep-18, INEXACT) // -3.031472448852961520948667839548e-01
T(RZ,   -0x1.366c3b3a9e911p-2,   -0x1.3b62ab6fc339bp-2,  0x1.ac4d7ep-18, INEXACT) // -3.031472448852961520948667839548e-01
T(RN,   -0x1.285b949de714p-17,  -0x1.285b949df7a07p-17,  -0x1.fffe46p-2, INEXACT) // -8.832148804143445143532975549761e-06
T(RN,  -0x1.92a7c848fef85p-19,  -0x1.92a7c84901907p-19,  -0x1.fffe8ap-2, INEXACT) // -3.000016509433923261011703878531e-06
T(RN,   -0x1.32d62e0ef06aep-5,   -0x1.32e88ee5bb07ep-5,   0x1.ffffc6p-2, INEXACT) // -3.745564456722881574446404329137e-02
T(RN,  -0x1.246cc734082a1p-16,  -0x1.246cc73447c1fp-16,   0x1.fffeacp-2, INEXACT) // -1.742988315822874704542379264982e-05
T(RD,   -0x1.c175c991707d2p-6,   -0x1.c1843960383d6p-6,  -0x1.ffffa2p-1, INEXACT) // -2.743286785494786911288045416768e-02
T(RU,   -0x1.c175c991707d2p-6,   -0x1.c1843960383d5p-6,  0x1.75d858p-19, INEXACT) // -2.743286785494786911288045416768e-02
T(RZ,   -0x1.c175c991707d2p-6,   -0x1.c1843960383d5p-6,  0x1.75d858p-19, INEXACT) // -2.743286785494786911288045416768e-02
T(RN,  -0x1.213b4aaf24f6fp-17,  -0x1.213b4aaf34591p-17,  -0x1.fffedep-2, INEXACT) // -8.619773636454640394831232252937e-06
T(RN,  -0x1.625a76eed4165p-20,  -0x1.625a76eed4878p-20,   -0x1.fffe8p-2, INEXACT) // -1.320069198580068428434887602141e-06
T(RD,   -0x1.52c747c0685dfp-1,   -0x1.7233f6db4458fp-1,  -0x1.ffffb8p-1, INEXACT) // -6.616766378758106581514653043996e-01
T(RU,   -0x1.52c747c0685dfp-1,   -0x1.7233f6db4458ep-1,  0x1.1da05ap-19, INEXACT) // -6.616766378758106581514653043996e-01
T(RZ,   -0x1.52c747c0685dfp-1,   -0x1.7233f6db4458ep-1,  0x1.1da05ap-19, INEXACT) // -6.616766378758106581514653043996e-01
T(RD,  -0x1.e34f72380d743p-11,  -0x1.e34f76b47d5c4p-11, -0x1.62bc68p-20, INEXACT) // -9.218413097247041753865004487523e-04
T(RU,  -0x1.e34f72380d743p-11,  -0x1.e34f76b47d5c3p-11,   0x1.ffffd4p-1, INEXACT) // -9.218413097247041753865004487523e-04
T(RZ,  -0x1.e34f72380d743p-11,  -0x1.e34f76b47d5c3p-11,   0x1.ffffd4p-1, INEXACT) // -9.218413097247041753865004487523e-04
T(RN,   -0x1.db241a2bcb567p-1,   -0x1.306495de96baep+0,    0x1.fffedp-2, INEXACT) // -9.280098131618331747105798967823e-01
T(RD,  -0x1.53d2c53a16cb2p-14,  -0x1.53d2c5405395ep-14, -0x1.b813aap-18, INEXACT) // -8.102019356341879957779383847338e-05
T(RU,  -0x1.53d2c53a16cb2p-14,  -0x1.53d2c5405395dp-14,   0x1.ffff24p-1, INEXACT) // -8.102019356341879957779383847338e-05
T(RZ,  -0x1.53d2c53a16cb2p-14,  -0x1.53d2c5405395dp-14,   0x1.ffff24p-1, INEXACT) // -8.102019356341879957779383847338e-05
T(RN,  -0x1.f8f1e65019164p-11,  -0x1.f8f1eb6dc3f09p-11,  -0x1.fffeb4p-2, INEXACT) // -9.631060038484515369028304832000e-04
T(RD,  -0x1.250bf885d2887p-24,  -0x1.250bf885d288bp-24, -0x1.d432cep-19, INEXACT) // -6.823026596245443901923459278577e-08
T(RU,  -0x1.250bf885d2887p-24,  -0x1.250bf885d288ap-24,   0x1.ffff8ap-1, INEXACT) // -6.823026596245443901923459278577e-08
T(RZ,  -0x1.250bf885d2887p-24,  -0x1.250bf885d288ap-24,   0x1.ffff8ap-1, INEXACT) // -6.823026596245443901923459278577e-08
T(RD,  -0x1.bd97afc496907p-22,  -0x1.bd97afc4969e8p-22, -0x1.cdc4acp-19, INEXACT) // -4.149903783161679982818945047057e-07
T(RU,  -0x1.bd97afc496907p-22,  -0x1.bd97afc4969e7p-22,   0x1.ffff8cp-1, INEXACT) // -4.149903783161679982818945047057e-07
T(RZ,  -0x1.bd97afc496907p-22,  -0x1.bd97afc4969e7p-22,   0x1.ffff8cp-1, INEXACT) // -4.149903783161679982818945047057e-07
T(RN,    0x1.771de36c081f2p-2,    0x1.800ec4dc52a3bp-2,   0x1.fffe28p-2, INEXACT) // 3.663249525725681410293077533424e-01
T(RD,   0x1.77356c8914507p-16,    0x1.77356c899aa6p-16,  -0x1.ffff14p-1, INEXACT) // 2.236418052731662121901910766919e-05
T(RU,   0x1.77356c8914507p-16,   0x1.77356c899aa61p-16,  0x1.d7505cp-18, INEXACT) // 2.236418052731662121901910766919e-05
T(RZ,   0x1.77356c8914507p-16,    0x1.77356c899aa6p-16,  -0x1.ffff14p-1, INEXACT) // 2.236418052731662121901910766919e-05
T(RN,   0x1.c7b1273d05e19p-19,   0x1.c7b1273d09a42p-19,  -0x1.ffff4cp-2, INEXACT) // 3.395170010477498694626734623836e-06
T(RN,   -0x1.a223f6a9ccf89p-8,   -0x1.a224b09737d01p-8,  -0x1.fffedcp-2, INEXACT) // -6.380317421463285211535865215637e-03
T(RN,   0x1.cb5b20c29517cp-22,   0x1.cb5b20c295272p-22,  -0x1.fffe02p-2, INEXACT) // 4.278085833687935516511787956140e-07
T(RD,   -0x1.39d661c4810f2p-5,   -0x1.39ea0c31a7994p-5, -0x1.ed3f96p-19, INEXACT) // -3.831023307069071626163037080914e-02
T(RU,   -0x1.39d661c4810f2p-5,   -0x1.39ea0c31a7993p-5,   0x1.ffff84p-1, INEXACT) // -3.831023307069071626163037080914e-02
T(RZ,   -0x1.39d661c4810f2p-5,   -0x1.39ea0c31a7993p-5,   0x1.ffff84p-1, INEXACT) // -3.831023307069071626163037080914e-02
T(RN,   -0x1.5eb8d54c64d8fp-9,   -0x1.5eb8f0ba0b7dcp-9,  -0x1.fffea4p-2, INEXACT) // -2.675796544460324732223055477220e-03
T(RD,  -0x1.63817379024d3p-15,  -0x1.6381737acb5b5p-15,  -0x1.ffffa6p-1, INEXACT) // -4.237957814019203999422388817742e-05
T(RU,  -0x1.63817379024d3p-15,  -0x1.6381737acb5b4p-15,  0x1.6b8b36p-19, INEXACT) // -4.237957814019203999422388817742e-05
T(RZ,  -0x1.63817379024d3p-15,  -0x1.6381737acb5b4p-15,  0x1.6b8b36p-19, INEXACT) // -4.237957814019203999422388817742e-05
T(RN,   0x1.fca578e30e25ap-18,   0x1.fca578e323106p-18,    0x1.fffefp-2, INEXACT) // 7.579421637031968128129545692051e-06
T(RN,  -0x1.0952b125cc03ap-22,  -0x1.0952b125cc069p-22,   0x1.ffff86p-2, INEXACT) // -2.471013139547190325457010941224e-07
T(RD,   0x1.36ac1558b16ffp-16,   0x1.36ac1558fdb19p-16, -0x1.9f0bfap-19, INEXACT) // 1.851750616556953687812624165243e-05
T(RU,   0x1.36ac1558b16ffp-16,   0x1.36ac1558fdb1ap-16,   0x1.ffff98p-1, INEXACT) // 1.851750616556953687812624165243e-05
T(RZ,   0x1.36ac1558b16ffp-16,   0x1.36ac1558fdb19p-16, -0x1.9f0bfap-19, INEXACT) // 1.851750616556953687812624165243e-05
T(RD,  -0x1.1abe822eb2d3ep-19,  -0x1.1abe822eb3b9dp-19, -0x1.532fc2p-19, INEXACT) // -2.106608256146522897692737602560e-06
T(RU,  -0x1.1abe822eb2d3ep-19,  -0x1.1abe822eb3b9cp-19,   0x1.ffffacp-1, INEXACT) // -2.106608256146522897692737602560e-06
T(RZ,  -0x1.1abe822eb2d3ep-19,  -0x1.1abe822eb3b9cp-19,   0x1.ffffacp-1, INEXACT) // -2.106608256146522897692737602560e-06
T(RN,   0x1.db14a0904351dp-11,   0x1.db14a4d306e68p-11,  -0x1.fffe4ep-2, INEXACT) // 9.061442852115495849921189552845e-04
T(RN,    0x1.8f0dbe827fb3ap-8,    0x1.8f0e601ed518cp-8,  -0x1.ffff64p-2, INEXACT) // 6.089076052829872978677805406278e-03
T(RD,  -0x1.ea702330c90c2p-20,  -0x1.ea702330ca383p-20,  -0x1.ffff1ap-1, INEXACT) // -1.827024061104096933142977923770e-06
T(RU,  -0x1.ea702330c90c2p-20,  -0x1.ea702330ca382p-20,  0x1.ccb9f2p-18, INEXACT) // -1.827024061104096933142977923770e-06
T(RZ,  -0x1.ea702330c90c2p-20,  -0x1.ea702330ca382p-20,  0x1.ccb9f2p-18, INEXACT) // -1.827024061104096933142977923770e-06
T(RD,  -0x1.bb39c4ed5a521p-18,   -0x1.bb39c4ed6829p-18, -0x1.e9b77ap-20, INEXACT) // -6.604577021598614083310822137074e-06
T(RU,  -0x1.bb39c4ed5a521p-18,  -0x1.bb39c4ed6828fp-18,   0x1.ffffc2p-1, INEXACT) // -6.604577021598614083310822137074e-06
T(RZ,  -0x1.bb39c4ed5a521p-18,  -0x1.bb39c4ed6828fp-18,   0x1.ffffc2p-1, INEXACT) // -6.604577021598614083310822137074e-06
T(RN,  -0x1.b792020adb66dp-24,  -0x1.b792020adb67bp-24,  -0x1.fffe34p-2, INEXACT) // -1.023454460466066354741644412081e-07
T(RN,   -0x1.adb635ccc4353p-6,   -0x1.adc2d372426e6p-6,  -0x1.ffff04p-2, INEXACT) // -2.622752431767889566560647551796e-02
T(RD,    0x1.79e702f5f1f75p-9,    0x1.79e72545e271fp-9,   -0x1.ffffdp-1, INEXACT) // 2.883166419426370311734908469248e-03
T(RU,    0x1.79e702f5f1f75p-9,     0x1.79e72545e272p-9,   0x1.80574p-20, INEXACT) // 2.883166419426370311734908469248e-03
T(RZ,    0x1.79e702f5f1f75p-9,    0x1.79e72545e271fp-9,   -0x1.ffffdp-1, INEXACT) // 2.883166419426370311734908469248e-03
T(RN,    0x1.6daae7ee0c1fep-1,    0x1.974831de90d42p-1,   0x1.ffffaap-2, INEXACT) // 7.141945341191442420125667922548e-01
T(RD,   -0x1.84325ad6a1e8fp-7,   -0x1.8434adf7e17c7p-7, -0x1.1a4844p-18, INEXACT) // -1.184682307690756823681521581193e-02
T(RU,   -0x1.84325ad6a1e8fp-7,   -0x1.8434adf7e17c6p-7,   0x1.ffff72p-1, INEXACT) // -1.184682307690756823681521581193e-02
T(RZ,   -0x1.84325ad6a1e8fp-7,   -0x1.8434adf7e17c6p-7,   0x1.ffff72p-1, INEXACT) // -1.184682307690756823681521581193e-02
T(RN,    0x1.819e9bb89598ap-9,    0x1.819ec02db8c79p-9,   0x1.fffe46p-2, INEXACT) // 2.942043789782637815133359282527e-03
T(RD,    0x1.d93b303bfcdc7p-2,    0x1.ebefb9a3ffe38p-2, -0x1.a0c5bep-18, INEXACT) // 4.621398483861551276241641517117e-01
T(RU,    0x1.d93b303bfcdc7p-2,    0x1.ebefb9a3ffe39p-2,    0x1.ffff3p-1, INEXACT) // 4.621398483861551276241641517117e-01
T(RZ,    0x1.d93b303bfcdc7p-2,    0x1.ebefb9a3ffe38p-2, -0x1.a0c5bep-18, INEXACT) // 4.621398483861551276241641517117e-01
T(RD,  -0x1.3a5ab3a37761ap-22,  -0x1.3a5ab3a377669p-22,  -0x1.f9818p-18, INEXACT) // -2.927652593390968832222213437400e-07
T(RU,  -0x1.3a5ab3a37761ap-22,  -0x1.3a5ab3a377668p-22,   0x1.ffff04p-1, INEXACT) // -2.927652593390968832222213437400e-07
T(RZ,  -0x1.3a5ab3a37761ap-22,  -0x1.3a5ab3a377668p-22,   0x1.ffff04p-1, INEXACT) // -2.927652593390968832222213437400e-07
T(RD,  -0x1.2801298233227p-11,  -0x1.28012a8a0795cp-11,  -0x1.a8452p-21, INEXACT) // -5.645838539521428429621141553696e-04
T(RU,  -0x1.2801298233227p-11,  -0x1.28012a8a0795bp-11,   0x1.ffffe6p-1, INEXACT) // -5.645838539521428429621141553696e-04
T(RZ,  -0x1.2801298233227p-11,  -0x1.28012a8a0795bp-11,   0x1.ffffe6p-1, INEXACT) // -5.645838539521428429621141553696e-04
T(RD,    0x1.1b7b765915203p-2,    0x1.1f3bf1387e6f1p-2, -0x1.712162p-21, INEXACT) // 2.768381587859780057492287141940e-01
T(RU,    0x1.1b7b765915203p-2,    0x1.1f3bf1387e6f2p-2,   0x1.ffffe8p-1, INEXACT) // 2.768381587859780057492287141940e-01
T(RZ,    0x1.1b7b765915203p-2,    0x1.1f3bf1387e6f1p-2, -0x1.712162p-21, INEXACT) // 2.768381587859780057492287141940e-01
T(RD,   0x1.affa619a30efcp-22,   0x1.affa619a30fc9p-22, -0x1.2adcccp-20, INEXACT) // 4.023109113732802496853210513783e-07
T(RU,   0x1.affa619a30efcp-22,   0x1.affa619a30fcap-22,   0x1.ffffdap-1, INEXACT) // 4.023109113732802496853210513783e-07
T(RZ,   0x1.affa619a30efcp-22,   0x1.affa619a30fc9p-22, -0x1.2adcccp-20, INEXACT) // 4.023109113732802496853210513783e-07
T(RN,   0x1.d07ac6486726cp-14,   0x1.d07ac658549a2p-14,   0x1.fffeaap-2, INEXACT) // 1.107405634059394831762712652079e-04
T(RD,   0x1.91034d4cb7f8ep-23,   0x1.91034d4cb7fb6p-23,  -0x1.fffff2p-1, INEXACT) // 1.867361824258906644360392259457e-07
T(RU,   0x1.91034d4cb7f8ep-23,   0x1.91034d4cb7fb7p-23,  0x1.b8b816p-22, INEXACT) // 1.867361824258906644360392259457e-07
T(RZ,   0x1.91034d4cb7f8ep-23,   0x1.91034d4cb7fb6p-23,  -0x1.fffff2p-1, INEXACT) // 1.867361824258906644360392259457e-07
T(RN,  -0x1.51c9bb7e8ca84p-12,  -0x1.51c9bbe09104ap-12,  -0x1.ffff1cp-2, INEXACT) // -3.221397563805477540915811474065e-04
T(RN,  -0x1.4850be1b3a509p-23,   -0x1.4850be1b3a52p-23,  -0x1.fffefap-2, INEXACT) // -1.528837721761431230392227391748e-07
T(RN,   -0x1.9d40e8fa380d6p-4,   -0x1.9df537e0f9a7bp-4,   0x1.fffff8p-2, INEXACT) // -1.008919811897642515585715727866e-01
T(RN,  -0x1.6dd1ca9f6de5ap-22,  -0x1.6dd1ca9f6ded7p-22,  -0x1.fffeccp-2, INEXACT) // -3.406959567480874500854646537429e-07
T(RN,  -0x1.55fd7adea1f02p-11,  -0x1.55fd7c7584068p-11,   0x1.fffe68p-2, INEXACT) // -6.522944566577928374867534344617e-04
T(RN,  -0x1.0de5feaaf2abdp-23,  -0x1.0de5feaaf2ac9p-23,   0x1.fffeb2p-2, INEXACT) // -1.256812443825010047941892693882e-07
T(RN,  -0x1.af36605f3a00ep-13,  -0x1.af366092345d8p-13,  -0x1.fffe72p-2, INEXACT) // -2.056180992220383771905412029213e-04
T(RD,  -0x1.f720c2e74afd8p-12,   -0x1.f720c42b301dp-12,  -0x1.ffff94p-1, INEXACT) // -4.798202266609297682309343002771e-04
T(RU,  -0x1.f720c2e74afd8p-12,  -0x1.f720c42b301cfp-12,  0x1.b2af9ep-19, INEXACT) // -4.798202266609297682309343002771e-04
T(RZ,  -0x1.f720c2e74afd8p-12,  -0x1.f720c42b301cfp-12,  0x1.b2af9ep-19, INEXACT) // -4.798202266609297682309343002771e-04
T(RN,   0x1.c6f2d2b74ab9dp-14,   0x1.c6f2d2c642492p-14,   0x1.fffe02p-2, INEXACT) // 1.084681815554503397968158506792e-04
T(RD,   0x1.915c115be1075p-18,   0x1.915c115beb4e1p-18,  -0x1.fffff8p-1, INEXACT) // 5.980724690494392552415642977381e-06
T(RU,   0x1.915c115be1075p-18,   0x1.915c115beb4e2p-18,  0x1.1224b6p-22, INEXACT) // 5.980724690494392552415642977381e-06
T(RZ,   0x1.915c115be1075p-18,   0x1.915c115beb4e1p-18,  -0x1.fffff8p-1, INEXACT) // 5.980724690494392552415642977381e-06
T(RN,    0x1.d8b354d5a1135p-8,    0x1.d8b461742b517p-8,  -0x1.fffe32p-2, INEXACT) // 7.212837420983488241621461867226e-03
T(RD,  -0x1.feb47ed195619p-21,  -0x1.feb47ed195b64p-21, -0x1.cd610cp-18, INEXACT) // -9.512623028821742749547752011907e-07
T(RU,  -0x1.feb47ed195619p-21,  -0x1.feb47ed195b63p-21,   0x1.ffff1ap-1, INEXACT) // -9.512623028821742749547752011907e-07
T(RZ,  -0x1.feb47ed195619p-21,  -0x1.feb47ed195b63p-21,   0x1.ffff1ap-1, INEXACT) // -9.512623028821742749547752011907e-07
T(RN,   -0x1.f4a14fe561449p-7,   -0x1.f4a64c68ce091p-7,  -0x1.fffe32p-2, INEXACT) // -1.527801896259907594999294389027e-02
T(RN,   0x1.c28cd76475487p-16,   0x1.c28cd7655de07p-16,  -0x1.ffffc4p-2, INEXACT) // 2.685488233729720007592588204570e-05
T(RN,  -0x1.c8615dec50b46p-12,  -0x1.c8615ede0e4dep-12,  -0x1.ffff5cp-2, INEXACT) // -4.352382082012839136994641897616e-04
T(RD,  -0x1.713741ca22869p-25,  -0x1.713741ca2286bp-25, -0x1.71bcdcp-21, INEXACT) // -4.298238172422465087076941703433e-08
T(RU,  -0x1.713741ca22869p-25,  -0x1.713741ca2286ap-25,   0x1.ffffe8p-1, INEXACT) // -4.298238172422465087076941703433e-08
T(RZ,  -0x1.713741ca22869p-25,  -0x1.713741ca2286ap-25,   0x1.ffffe8p-1, INEXACT) // -4.298238172422465087076941703433e-08
T(RD,   -0x1.a6a5a08be7e5p-25,  -0x1.a6a5a08be7e54p-25,  -0x1.ffff2ep-1, INEXACT) // -4.920258431174882882624477611899e-08
T(RU,   -0x1.a6a5a08be7e5p-25,  -0x1.a6a5a08be7e53p-25,  0x1.a2e7aep-18, INEXACT) // -4.920258431174882882624477611899e-08
T(RZ,   -0x1.a6a5a08be7e5p-25,  -0x1.a6a5a08be7e53p-25,  0x1.a2e7aep-18, INEXACT) // -4.920258431174882882624477611899e-08
T(RD,   0x1.a6a5815fc7df2p-25,   0x1.a6a5815fc7df4p-25,  -0x1.ffff7ep-1, INEXACT) // 4.920252893850749186875327906635e-08
T(RU,   0x1.a6a5815fc7df2p-25,   0x1.a6a5815fc7df5p-25,   0x1.04d29p-18, INEXACT) // 4.920252893850749186875327906635e-08
T(RZ,   0x1.a6a5815fc7df2p-25,   0x1.a6a5815fc7df4p-25,  -0x1.ffff7ep-1, INEXACT) // 4.920252893850749186875327906635e-08
T(RN,   0x1.1747a55f1007cp-15,   0x1.1747a55fed9e7p-15,   -0x1.ffff4p-2, INEXACT) // 3.329275454477893174225211492256e-05
T(RD,   0x1.cc2adab4f99a7p-18,   0x1.cc2adab509176p-18, -0x1.9da69ap-18, INEXACT) // 6.857028599127634986164139124787e-06
T(RU,   0x1.cc2adab4f99a7p-18,   0x1.cc2adab509177p-18,   0x1.ffff32p-1, INEXACT) // 6.857028599127634986164139124787e-06
T(RZ,   0x1.cc2adab4f99a7p-18,   0x1.cc2adab509176p-18, -0x1.9da69ap-18, INEXACT) // 6.857028599127634986164139124787e-06
T(RN,   0x1.37bde06d681ddp-10,   0x1.37bde53e273c8p-10,   -0x1.ffff7p-2, INEXACT) // 1.189200232467261435578831374471e-03
T(RD,   0x1.64bef8d5db5c2p-17,   0x1.64bef8d5f839cp-17,  -0x1.ffff82p-1, INEXACT) // 1.063185883839579031818513288332e-05
T(RU,   0x1.64bef8d5db5c2p-17,   0x1.64bef8d5f839dp-17,  0x1.f4e208p-19, INEXACT) // 1.063185883839579031818513288332e-05
T(RZ,   0x1.64bef8d5db5c2p-17,   0x1.64bef8d5f839cp-17,  -0x1.ffff82p-1, INEXACT) // 1.063185883839579031818513288332e-05
T(RD,   0x1.0a402dca543f3p-24,   0x1.0a402dca543f5p-24,  -0x1.ffffdep-1, INEXACT) // 6.199132155283850149537892447113e-08
T(RU,   0x1.0a402dca543f3p-24,   0x1.0a402dca543f6p-24,  0x1.161252p-20, INEXACT) // 6.199132155283850149537892447113e-08
T(RZ,   0x1.0a402dca543f3p-24,   0x1.0a402dca543f5p-24,  -0x1.ffffdep-1, INEXACT) // 6.199132155283850149537892447113e-08
T(RD,    0x1.9c14c67c3593ap-2,    0x1.a81a1b3597937p-2, -0x1.2d4568p-21, INEXACT) // 4.024230016051607572435955262335e-01
T(RU,    0x1.9c14c67c3593ap-2,    0x1.a81a1b3597938p-2,   0x1.ffffeep-1, INEXACT) // 4.024230016051607572435955262335e-01
T(RZ,    0x1.9c14c67c3593ap-2,    0x1.a81a1b3597937p-2, -0x1.2d4568p-21, INEXACT) // 4.024230016051607572435955262335e-01
T(RD,   -0x1.ff551cb94716p-23,  -0x1.ff551cb9471b6p-23,  -0x1.ffff9ap-1, INEXACT) // -2.381077360080108130491009787999e-07
T(RU,   -0x1.ff551cb94716p-23,  -0x1.ff551cb9471b5p-23,  0x1.9bac9cp-19, INEXACT) // -2.381077360080108130491009787999e-07
T(RZ,   -0x1.ff551cb94716p-23,  -0x1.ff551cb9471b5p-23,  0x1.9bac9cp-19, INEXACT) // -2.381077360080108130491009787999e-07
T(RD,   0x1.412a8ea3e189cp-10,   0x1.412a93e7d8afep-10, -0x1.0991d6p-20, INEXACT) // 1.225151973785843471931311654544e-03
T(RU,   0x1.412a8ea3e189cp-10,   0x1.412a93e7d8affp-10,   0x1.ffffdep-1, INEXACT) // 1.225151973785843471931311654544e-03
T(RZ,   0x1.412a8ea3e189cp-10,   0x1.412a93e7d8afep-10, -0x1.0991d6p-20, INEXACT) // 1.225151973785843471931311654544e-03
T(RD,    0x1.a2eab926b2289p-1,    0x1.eaa21cf0e2b41p-1, -0x1.c5d01cp-18, INEXACT) // 8.181970462547535349884242350527e-01
T(RU,    0x1.a2eab926b2289p-1,    0x1.eaa21cf0e2b42p-1,   0x1.ffff1ep-1, INEXACT) // 8.181970462547535349884242350527e-01
T(RZ,    0x1.a2eab926b2289p-1,    0x1.eaa21cf0e2b41p-1, -0x1.c5d01cp-18, INEXACT) // 8.181970462547535349884242350527e-01
T(RN,  -0x1.d264227dd4fc2p-23,  -0x1.d264227dd5003p-23,   -0x1.ffff4p-2, INEXACT) // -2.171803039028300553234913320561e-07
T(RN,   0x1.d569b454efa35p-15,   0x1.d569b4590bd3cp-15,  -0x1.ffff28p-2, INEXACT) // 5.595837925608354411358483226913e-05
T(RD,  -0x1.9265a62671c75p-12,  -0x1.9265a6cc26078p-12,  -0x1.58e59p-18, INEXACT) // -3.837557473186988953213483188875e-04
T(RU,  -0x1.9265a62671c75p-12,  -0x1.9265a6cc26077p-12,   0x1.ffff54p-1, INEXACT) // -3.837557473186988953213483188875e-04
T(RZ,  -0x1.9265a62671c75p-12,  -0x1.9265a6cc26077p-12,   0x1.ffff54p-1, INEXACT) // -3.837557473186988953213483188875e-04
T(RD,  -0x1.4a21b67f35106p-13,  -0x1.4a21b6961530cp-13, -0x1.b7d3f4p-18, INEXACT) // -1.574190573366900341815977082405e-04
T(RU,  -0x1.4a21b67f35106p-13,  -0x1.4a21b6961530bp-13,   0x1.ffff24p-1, INEXACT) // -1.574190573366900341815977082405e-04
T(RZ,  -0x1.4a21b67f35106p-13,  -0x1.4a21b6961530bp-13,   0x1.ffff24p-1, INEXACT) // -1.574190573366900341815977082405e-04
T(RD,   0x1.7c2b5deb22cf6p-11,   0x1.7c2b601a11de6p-11,  -0x1.ffff74p-1, INEXACT) // 7.251155888225158368393108432315e-04
T(RU,   0x1.7c2b5deb22cf6p-11,   0x1.7c2b601a11de7p-11,  0x1.17bbc6p-18, INEXACT) // 7.251155888225158368393108432315e-04
T(RZ,   0x1.7c2b5deb22cf6p-11,   0x1.7c2b601a11de6p-11,  -0x1.ffff74p-1, INEXACT) // 7.251155888225158368393108432315e-04
T(RD,   -0x1.fb49b8a0b5c6dp-8,   -0x1.fb4b04a1e99c6p-8,  -0x1.ffffb2p-1, INEXACT) // -7.740600180759488364856668596303e-03
T(RU,   -0x1.fb49b8a0b5c6dp-8,   -0x1.fb4b04a1e99c5p-8,  0x1.3a33a4p-19, INEXACT) // -7.740600180759488364856668596303e-03
T(RZ,   -0x1.fb49b8a0b5c6dp-8,   -0x1.fb4b04a1e99c5p-8,  0x1.3a33a4p-19, INEXACT) // -7.740600180759488364856668596303e-03
T(RD,    0x1.644c523eb4255p-1,    0x1.8a118be762ccdp-1,  -0x1.ffff56p-1, INEXACT) // 6.958947850744815477597171593516e-01
T(RU,    0x1.644c523eb4255p-1,    0x1.8a118be762ccep-1,  0x1.5249acp-18, INEXACT) // 6.958947850744815477597171593516e-01
T(RZ,    0x1.644c523eb4255p-1,    0x1.8a118be762ccdp-1,  -0x1.ffff56p-1, INEXACT) // 6.958947850744815477597171593516e-01
T(RN,   -0x1.59e92efd96a4ep-4,   -0x1.5a52c8485a0edp-4,  -0x1.fffe6cp-2, INEXACT) // -8.445089679427406070821859884745e-02
T(RN,   0x1.951ac3b0b7769p-16,   0x1.951ac3b16088ep-16,   0x1.fffe2cp-2, INEXACT) // 2.414611271005871938007993071640e-05
T(RD,   -0x1.47b4cd831d9cp-19,   -0x1.47b4cd831f02p-19, -0x1.59057ap-19, INEXACT) // -2.441601908705087363091190688635e-06
T(RU,   -0x1.47b4cd831d9cp-19,  -0x1.47b4cd831f01fp-19,   0x1.ffffaap-1, INEXACT) // -2.441601908705087363091190688635e-06
T(RZ,   -0x1.47b4cd831d9cp-19,  -0x1.47b4cd831f01fp-19,   0x1.ffffaap-1, INEXACT) // -2.441601908705087363091190688635e-06
T(RD,  -0x1.a470871d91199p-11,  -0x1.a4708a11990fap-11,  -0x1.7c5afp-18, INEXACT) // -8.019248231865727010239663918867e-04
T(RU,  -0x1.a470871d91199p-11,  -0x1.a4708a11990f9p-11,   0x1.ffff42p-1, INEXACT) // -8.019248231865727010239663918867e-04
T(RZ,  -0x1.a470871d91199p-11,  -0x1.a4708a11990f9p-11,   0x1.ffff42p-1, INEXACT) // -8.019248231865727010239663918867e-04
T(RD,  -0x1.713747de96598p-24,  -0x1.713747de965a1p-24,  -0x1.ffff92p-1, INEXACT) // -8.596478504856596094570305929827e-08
T(RU,  -0x1.713747de96598p-24,   -0x1.713747de965ap-24,  0x1.b7a672p-19, INEXACT) // -8.596478504856596094570305929827e-08
T(RZ,  -0x1.713747de96598p-24,   -0x1.713747de965ap-24,  0x1.b7a672p-19, INEXACT) // -8.596478504856596094570305929827e-08
T(RN,  -0x1.7137aceb4d2d2p-26,  -0x1.7137aceb4d2d3p-26,  -0x1.fffe4ep-2, INEXACT) // -2.149128601227300664913854211409e-08
T(RN,   0x1.c22a96816ffb7p-24,   0x1.c22a96816ffc5p-24,  -0x1.ffff86p-2, INEXACT) // 1.048125231250728092959726193110e-07
T(RN,  -0x1.b5c2cebaee0a1p-20,  -0x1.b5c2cebaeedf6p-20,   0x1.fffee4p-2, INEXACT) // -1.630786683233207643787241770961e-06
T(RN,    0x1.3b059503ef967p-2,    0x1.4037170c1825cp-2,   0x1.fffea2p-2, INEXACT) // 3.076384814884449148131295714848e-01
T(RN,   0x1.2ad9c04c35577p-14,   0x1.2ad9c05073652p-14,   0x1.fffebap-2, INEXACT) // 7.125153314587415480287763136502e-05
T(RD,    0x1.bb0a36bc6cf51p-3,    0x1.be920012dc6eep-3,  -0x1.ffffdcp-1, INEXACT) // 2.163280750515874928385784414786e-01
T(RU,    0x1.bb0a36bc6cf51p-3,    0x1.be920012dc6efp-3,  0x1.22b4e6p-20, INEXACT) // 2.163280750515874928385784414786e-01
T(RZ,    0x1.bb0a36bc6cf51p-3,    0x1.be920012dc6eep-3,  -0x1.ffffdcp-1, INEXACT) // 2.163280750515874928385784414786e-01
T(RD,  -0x1.84d8b8190754fp-16,  -0x1.84d8b8199cda7p-16, -0x1.b3f16ep-18, INEXACT) // -2.317706102782551551440802517501e-05
T(RU,  -0x1.84d8b8190754fp-16,  -0x1.84d8b8199cda6p-16,   0x1.ffff26p-1, INEXACT) // -2.317706102782551551440802517501e-05
T(RZ,  -0x1.84d8b8190754fp-16,  -0x1.84d8b8199cda6p-16,   0x1.ffff26p-1, INEXACT) // -2.317706102782551551440802517501e-05
T(RD,   -0x1.f1ed59b7c579bp-9,   -0x1.f1eda834f7d4fp-9, -0x1.d846a6p-20, INEXACT) // -3.798882676970328272497701149746e-03
T(RU,   -0x1.f1ed59b7c579bp-9,   -0x1.f1eda834f7d4ep-9,   0x1.ffffc4p-1, INEXACT) // -3.798882676970328272497701149746e-03
T(RZ,   -0x1.f1ed59b7c579bp-9,   -0x1.f1eda834f7d4ep-9,   0x1.ffffc4p-1, INEXACT) // -3.798882676970328272497701149746e-03
T(RN,   0x1.a05a15e3ee63bp-17,   0x1.a05a15e41c46dp-17,   0x1.fffe46p-2, INEXACT) // 1.240825344682720407713579641173e-05
T(RN,   -0x1.4304743072dd5p-8,   -0x1.4304c9e735b5bp-8,   -0x1.fffedp-2, INEXACT) // -4.928854338185091783774982587829e-03
T(RD,   0x1.8502f578a664cp-11,   0x1.8502f7cf7f6bep-11, -0x1.3f7d08p-26, INEXACT) // 7.419806634800323562328738802307e-04
T(RU,   0x1.8502f578a664cp-11,   0x1.8502f7cf7f6bfp-11,          0x1p+0, INEXACT) // 7.419806634800323562328738802307e-04
T(RZ,   0x1.8502f578a664cp-11,   0x1.8502f7cf7f6bep-11, -0x1.3f7d08p-26, INEXACT) // 7.419806634800323562328738802307e-04
T(RN,    0x1.306c8e4a9ed6fp-5,    0x1.307e80f9cc93cp-5,   0x1.fffe92p-2, INEXACT) // 3.716113845163248469161132447880e-02
T(RN,  -0x1.284144c2dca6bp-21,  -0x1.284144c2dcb74p-21,  -0x1.ffff46p-2, INEXACT) // -5.518178557275453199217735665572e-07
T(RD,   -0x1.7f728c7c0faadp-8,   -0x1.7f731bddb90f6p-8,  -0x1.ffffaep-1, INEXACT) // -5.850943849565010297653078197300e-03
T(RU,   -0x1.7f728c7c0faadp-8,   -0x1.7f731bddb90f5p-8,  0x1.44f96cp-19, INEXACT) // -5.850943849565010297653078197300e-03
T(RZ,   -0x1.7f728c7c0faadp-8,   -0x1.7f731bddb90f5p-8,  0x1.44f96cp-19, INEXACT) // -5.850943849565010297653078197300e-03
T(RD,    0x1.488afe4fb5e66p-4,    0x1.48e5715a9c489p-4, -0x1.5d8e56p-18, INEXACT) // 8.021067943934098720681902250362e-02
T(RU,    0x1.488afe4fb5e66p-4,    0x1.48e5715a9c48ap-4,   0x1.ffff52p-1, INEXACT) // 8.021067943934098720681902250362e-02
T(RZ,    0x1.488afe4fb5e66p-4,    0x1.48e5715a9c489p-4, -0x1.5d8e56p-18, INEXACT) // 8.021067943934098720681902250362e-02
T(RN,    0x1.f880413c2f973p-2,    0x1.07c373e698964p-1,  -0x1.ffff52p-2, INEXACT) // 4.926767533287580991263610030728e-01
T(RD,    0x1.486e759184a85p-1,    0x1.648fd910e2b17p-1,  -0x1.ffffb6p-1, INEXACT) // 6.414677372107041586346554140619e-01
T(RU,    0x1.486e759184a85p-1,    0x1.648fd910e2b18p-1,  0x1.246e46p-19, INEXACT) // 6.414677372107041586346554140619e-01
T(RZ,    0x1.486e759184a85p-1,    0x1.648fd910e2b17p-1,  -0x1.ffffb6p-1, INEXACT) // 6.414677372107041586346554140619e-01
T(RN,   0x1.d14a632a4ced2p-16,   0x1.d14a632b4d1aap-16,   -0x1.fffe2p-2, INEXACT) // 2.773347947844404345245708509715e-05
T(RD,  -0x1.bda77df26cac8p-14,  -0x1.bda77e007e2bap-14, -0x1.dd6adap-18, INEXACT) // -1.062522567625664342630398273570e-04
T(RU,  -0x1.bda77df26cac8p-14,  -0x1.bda77e007e2b9p-14,   0x1.ffff12p-1, INEXACT) // -1.062522567625664342630398273570e-04
T(RZ,  -0x1.bda77df26cac8p-14,  -0x1.bda77e007e2b9p-14,   0x1.ffff12p-1, INEXACT) // -1.062522567625664342630398273570e-04
T(RN,  -0x1.86a2f522c72e3p-12,  -0x1.86a2f5ba5fbbbp-12,   0x1.fffec6p-2, INEXACT) // -3.725400476229224588746447022203e-04
T(RD,   -0x1.762f1436cd4cep-2,   -0x1.7f0e2b210d1bbp-2, -0x1.8256eap-18, INEXACT) // -3.654139669846018234622420095548e-01
T(RU,   -0x1.762f1436cd4cep-2,   -0x1.7f0e2b210d1bap-2,   0x1.ffff3ep-1, INEXACT) // -3.654139669846018234622420095548e-01
T(RZ,   -0x1.762f1436cd4cep-2,   -0x1.7f0e2b210d1bap-2,   0x1.ffff3ep-1, INEXACT) // -3.654139669846018234622420095548e-01
T(RD,  -0x1.27a0abe1f4994p-11,  -0x1.27a0ace8c75ecp-11,  -0x1.ffff26p-1, INEXACT) // -5.638649420183655149030332864868e-04
T(RU,  -0x1.27a0abe1f4994p-11,  -0x1.27a0ace8c75ebp-11,  0x1.b35eb4p-18, INEXACT) // -5.638649420183655149030332864868e-04
T(RZ,  -0x1.27a0abe1f4994p-11,  -0x1.27a0ace8c75ebp-11,  0x1.b35eb4p-18, INEXACT) // -5.638649420183655149030332864868e-04
T(RN,   0x1.7137bf3a44007p-26,   0x1.7137bf3a44008p-26,   0x1.fffe02p-2, INEXACT) // 2.149130227344653197477172422349e-08
T(RN,  -0x1.184a013383294p-24,  -0x1.184a013383297p-24,   0x1.fffe96p-2, INEXACT) // -6.525988709860580903944255078131e-08
T(RN,    0x1.0a3f16620613bp-6,    0x1.0a42166fe0a3fp-6,  -0x1.fffec4p-2, INEXACT) // 1.625039277868832107709629042347e-02
T(RD,   0x1.d12ee9fd66bf4p-26,   0x1.d12ee9fd66bf5p-26,  -0x1.4e3b9p-19, INEXACT) // 2.707722933856708446914777739870e-08
T(RU,   0x1.d12ee9fd66bf4p-26,   0x1.d12ee9fd66bf6p-26,   0x1.ffffacp-1, INEXACT) // 2.707722933856708446914777739870e-08
T(RZ,   0x1.d12ee9fd66bf4p-26,   0x1.d12ee9fd66bf5p-26,  -0x1.4e3b9p-19, INEXACT) // 2.707722933856708446914777739870e-08
T(RN,   0x1.cd7167bcd4f65p-11,   0x1.cd716ba455267p-11,  -0x1.ffff1ep-2, INEXACT) // 8.801326544962516243778005708975e-04
T(RD,   0x1.6552bec401a62p-13,    0x1.6552bee10344p-13, -0x1.4d2bf4p-18, INEXACT) // 1.703849903835373742234937655127e-04
T(RU,   0x1.6552bec401a62p-13,   0x1.6552bee103441p-13,   0x1.ffff5ap-1, INEXACT) // 1.703849903835373742234937655127e-04
T(RZ,   0x1.6552bec401a62p-13,    0x1.6552bee10344p-13, -0x1.4d2bf4p-18, INEXACT) // 1.703849903835373742234937655127e-04
T(RN,   0x1.3fbb10b916047p-15,   0x1.3fbb10ba62829p-15,   0x1.ffff04p-2, INEXACT) // 3.811487244637138765935777118266e-05
T(RN,  -0x1.8f6c31b8ecd22p-18,  -0x1.8f6c31b8f6f31p-18,  -0x1.fffe98p-2, INEXACT) // -5.951861049280432472354147865889e-06
T(RD,   -0x1.6fccf4bad08bap-1,   -0x1.9a56b68b86aabp-1,  -0x1.ffff68p-1, INEXACT) // -7.183605649991229302742112849955e-01
T(RU,   -0x1.6fccf4bad08bap-1,   -0x1.9a56b68b86aaap-1,  0x1.2f53aep-18, INEXACT) // -7.183605649991229302742112849955e-01
T(RZ,   -0x1.6fccf4bad08bap-1,   -0x1.9a56b68b86aaap-1,  0x1.2f53aep-18, INEXACT) // -7.183605649991229302742112849955e-01
T(RN,   -0x1.f531e050540f1p-2,   -0x1.05dda7d29f20dp-1,  -0x1.ffff3ep-2, INEXACT) // -4.894480752018486868770708042575e-01
T(RN,   0x1.3c47bf404b19ep-19,   0x1.3c47bf404c5bcp-19,   0x1.ffff62p-2, INEXACT) // 2.356471583328351636040572797404e-06
T(RN,   0x1.8db9bb83ef8e5p-25,   0x1.8db9bb83ef8e7p-25,  -0x1.fffeccp-2, INEXACT) // 4.630134411942436236122073328104e-08
T(RD,  -0x1.c525c0e78e68bp-17,  -0x1.c525c0e7c991ap-17, -0x1.9f7fc8p-19, INEXACT) // -1.350484713135153374793159114509e-05
T(RU,  -0x1.c525c0e78e68bp-17,  -0x1.c525c0e7c9919p-17,   0x1.ffff98p-1, INEXACT) // -1.350484713135153374793159114509e-05
T(RZ,  -0x1.c525c0e78e68bp-17,  -0x1.c525c0e7c9919p-17,   0x1.ffff98p-1, INEXACT) // -1.350484713135153374793159114509e-05
T(RN,    0x1.c6a208a1e35ddp-1,    0x1.17c6f3a4286fdp+0,  -0x1.ffff18p-2, INEXACT) // 8.879549691789027088262287179532e-01
T(RN,   0x1.24db1ead85e6fp-21,   0x1.24db1ead85f6fp-21,    0x1.ffff7p-2, INEXACT) // 5.454866902091576404520002589738e-07
T(RN,   -0x1.81faab0d64684p-7,   -0x1.81fcf40a85667p-7,   0x1.fffea4p-2, INEXACT) // -1.177914955295312343652724962340e-02
T(RD,  -0x1.90c63ce2f27aep-16,    -0x1.90c63ce3963p-16, -0x1.f55c7ap-18, INEXACT) // -2.388801375356019968771922878936e-05
T(RU,  -0x1.90c63ce2f27aep-16,  -0x1.90c63ce3962ffp-16,   0x1.ffff06p-1, INEXACT) // -2.388801375356019968771922878936e-05
T(RZ,  -0x1.90c63ce2f27aep-16,  -0x1.90c63ce3962ffp-16,   0x1.ffff06p-1, INEXACT) // -2.388801375356019968771922878936e-05
T(RD,  -0x1.f51a6de174d01p-25,  -0x1.f51a6de174d07p-25,  -0x1.ffff4ap-1, INEXACT) // -5.833609485373022888881703045157e-08
T(RU,  -0x1.f51a6de174d01p-25,  -0x1.f51a6de174d06p-25,  0x1.6bc0cap-18, INEXACT) // -5.833609485373022888881703045157e-08
T(RZ,  -0x1.f51a6de174d01p-25,  -0x1.f51a6de174d06p-25,  0x1.6bc0cap-18, INEXACT) // -5.833609485373022888881703045157e-08
T(RD,  -0x1.c220c4cc42a61p-15,  -0x1.c220c4cfe2695p-15,  -0x1.dd7c2p-19, INEXACT) // -5.365943943232555861768198757211e-05
T(RU,  -0x1.c220c4cc42a61p-15,  -0x1.c220c4cfe2694p-15,   0x1.ffff88p-1, INEXACT) // -5.365943943232555861768198757211e-05
T(RZ,  -0x1.c220c4cc42a61p-15,  -0x1.c220c4cfe2694p-15,   0x1.ffff88p-1, INEXACT) // -5.365943943232555861768198757211e-05
T(RN,   -0x1.97f876c1df29fp-1,   -0x1.d811a661998cbp-1,   0x1.fffe78p-2, INEXACT) // -7.968175040874320158579280359845e-01
T(RN,   0x1.e9db77baa68c3p-18,   0x1.e9db77bab93b3p-18,    0x1.fffebp-2, INEXACT) // 7.299442524777945166195979725954e-06
T(RN,   0x1.037f60c1f66edp-18,   0x1.037f60c1f935ep-18,   0x1.ffffe8p-2, INEXACT) // 3.866815122288816621465724204798e-06
T(RD,   0x1.e65fb6586dc4ap-17,   0x1.e65fb658b6eb3p-17,  -0x1.ffffe2p-1, INEXACT) // 1.449507105709241285289474998610e-05
T(RU,   0x1.e65fb6586dc4ap-17,   0x1.e65fb658b6eb4p-17,  0x1.e3e498p-21, INEXACT) // 1.449507105709241285289474998610e-05
T(RZ,   0x1.e65fb6586dc4ap-17,   0x1.e65fb658b6eb3p-17,  -0x1.ffffe2p-1, INEXACT) // 1.449507105709241285289474998610e-05
T(RD,   0x1.eec37397d6496p-18,   0x1.eec37397e9898p-18, -0x1.a80524p-19, INEXACT) // 7.372550406469941742713079813054e-06
T(RU,   0x1.eec37397d6496p-18,   0x1.eec37397e9899p-18,   0x1.ffff96p-1, INEXACT) // 7.372550406469941742713079813054e-06
T(RZ,   0x1.eec37397d6496p-18,   0x1.eec37397e9898p-18, -0x1.a80524p-19, INEXACT) // 7.372550406469941742713079813054e-06
T(RN,   0x1.1a1db28291677p-14,   0x1.1a1db2862309ap-14,    0x1.fffebp-2, INEXACT) // 6.726169707701479553909468256379e-05
T(RD,   0x1.a811be6310ae9p-14,   0x1.a811be6f2fcebp-14, -0x1.c60848p-19, INEXACT) // 1.011060026466049579932718338604e-04
T(RU,   0x1.a811be6310ae9p-14,   0x1.a811be6f2fcecp-14,   0x1.ffff8ep-1, INEXACT) // 1.011060026466049579932718338604e-04
T(RZ,   0x1.a811be6310ae9p-14,   0x1.a811be6f2fcebp-14, -0x1.c60848p-19, INEXACT) // 1.011060026466049579932718338604e-04
T(RD,     0x1.89af3924d763p-4,    0x1.8a4b0b40d2f47p-4,   -0x1.ffffdp-1, INEXACT) // 9.611437150803037177126952883555e-02
T(RU,     0x1.89af3924d763p-4,    0x1.8a4b0b40d2f48p-4,  0x1.860dfcp-20, INEXACT) // 9.611437150803037177126952883555e-02
T(RZ,     0x1.89af3924d763p-4,    0x1.8a4b0b40d2f47p-4,   -0x1.ffffdp-1, INEXACT) // 9.611437150803037177126952883555e-02
T(RN,   0x1.d249ea50f347dp-18,   0x1.d249ea5103651p-18,   -0x1.fffe6p-2, INEXACT) // 6.948243552918067075720599118371e-06
T(RD,  -0x1.c79e87a78fbc7p-17,  -0x1.c79e87a7cbde9p-17, -0x1.36b514p-21, INEXACT) // -1.357851199579135417761215770538e-05
T(RU,  -0x1.c79e87a78fbc7p-17,  -0x1.c79e87a7cbde8p-17,   0x1.ffffecp-1, INEXACT) // -1.357851199579135417761215770538e-05
T(RZ,  -0x1.c79e87a78fbc7p-17,  -0x1.c79e87a7cbde8p-17,   0x1.ffffecp-1, INEXACT) // -1.357851199579135417761215770538e-05
T(RN,  -0x1.67d3e3d6c971fp-16,  -0x1.67d3e3d73fed6p-16,  -0x1.ffff7ep-2, INEXACT) // -2.144740195854984249833850851186e-05
T(RD,  -0x1.019d12798d8b2p-10,  -0x1.019d153135bccp-10, -0x1.4dbf26p-18, INEXACT) // -9.827177549488860970605674793887e-04
T(RU,  -0x1.019d12798d8b2p-10,  -0x1.019d153135bcbp-10,   0x1.ffff5ap-1, INEXACT) // -9.827177549488860970605674793887e-04
T(RZ,  -0x1.019d12798d8b2p-10,  -0x1.019d153135bcbp-10,   0x1.ffff5ap-1, INEXACT) // -9.827177549488860970605674793887e-04
T(RN,   0x1.84e3720b2caffp-17,   0x1.84e3720b52146p-17,  -0x1.fffe04p-2, INEXACT) // 1.158977922552850187045813540321e-05
T(RD,   0x1.0ab66e412531bp-16,   0x1.0ab66e415571cp-16, -0x1.a3794ep-19, INEXACT) // 1.589731096325866638026107213744e-05
T(RU,   0x1.0ab66e412531bp-16,   0x1.0ab66e415571dp-16,   0x1.ffff98p-1, INEXACT) // 1.589731096325866638026107213744e-05
T(RZ,   0x1.0ab66e412531bp-16,   0x1.0ab66e415571cp-16, -0x1.a3794ep-19, INEXACT) // 1.589731096325866638026107213744e-05
T(RN,  -0x1.a773b7f3a054fp-12,  -0x1.a773b8b4b9d7dp-12,   0x1.fffe64p-2, INEXACT) // -4.038353210732052527530411278889e-04
T(RN,   0x1.a2d45c58078eap-10,   0x1.a2d468058c351p-10,   0x1.ffff84p-2, INEXACT) // 1.597707878324745259940309338731e-03
T(RD,   -0x1.852c9bb540e5p-10,  -0x1.852ca513a72b6p-10,  -0x1.ffff96p-1, INEXACT) // -1.484581950820369061760928275362e-03
T(RU,   -0x1.852c9bb540e5p-10,  -0x1.852ca513a72b5p-10,  0x1.a8cbcep-19, INEXACT) // -1.484581950820369061760928275362e-03
T(RZ,   -0x1.852c9bb540e5p-10,  -0x1.852ca513a72b5p-10,  0x1.a8cbcep-19, INEXACT) // -1.484581950820369061760928275362e-03
T(RN,  -0x1.accfa82c4840cp-15,  -0x1.accfa82f6a59ap-15,   0x1.fffe7ap-2, INEXACT) // -5.111827371907109811809133415039e-05
T(RN,   0x1.5e7fada33faf4p-10,   0x1.5e7fb47b4e9a2p-10,  -0x1.fffe22p-2, INEXACT) // 1.337046597484179040471463650874e-03
T(RN,  -0x1.e822a0cd3f5bep-10,  -0x1.e822b349f5833p-10,  -0x1.fffeb4p-2, INEXACT) // -1.862088264999214436840047071087e-03
T(RN,   -0x1.3efbe267267abp-3,   -0x1.4049b5b6257cdp-3,   -0x1.fffffp-2, INEXACT) // -1.557538688401199633570826108553e-01
T(RN,   -0x1.751e4758cec1ap-5,   -0x1.753f55c1eedeep-5,   0x1.fffebap-2, INEXACT) // -4.554666457121232803206822836728e-02
T(RN,   0x1.8db9c4b544f46p-25,   0x1.8db9c4b544f48p-25,  -0x1.ffff7ep-2, INEXACT) // 4.630136044895645415898319556189e-08
T(RN,   0x1.b56632d84dff4p-13,   0x1.b566330d822cfp-13,   0x1.fffef2p-2, INEXACT) // 2.085681978856165430871727473061e-04
T(RN,   0x1.8fc95b2279731p-22,   0x1.8fc95b22797d3p-22,  -0x1.fffe1ap-2, INEXACT) // 3.723302361132947415854057508083e-07
T(RN,   -0x1.2e01b1648f70fp-8,   -0x1.2e01f771f238cp-8,  -0x1.ffff0ep-2, INEXACT) // -4.608255204002777681571156875862e-03
T(RN,  -0x1.84fbd0a26ea0fp-19,  -0x1.84fbd0a270f7bp-19,  -0x1.fffe2cp-2, INEXACT) // -2.898154052047693701228301896289e-06
T(RD,   -0x1.60f1e714a7529p-6,   -0x1.60f8e47398253p-6,   -0x1.ffff6p-1, INEXACT) // -2.154204908821558475673363375336e-02
T(RU,   -0x1.60f1e714a7529p-6,   -0x1.60f8e47398252p-6,  0x1.3f980ep-18, INEXACT) // -2.154204908821558475673363375336e-02
T(RZ,   -0x1.60f1e714a7529p-6,   -0x1.60f8e47398252p-6,  0x1.3f980ep-18, INEXACT) // -2.154204908821558475673363375336e-02
T(RD,  -0x1.d08ee212b37bcp-15,   -0x1.d08ee216af5dp-15, -0x1.eaf0f6p-18, INEXACT) // -5.537964547884475781207302969023e-05
T(RU,  -0x1.d08ee212b37bcp-15,  -0x1.d08ee216af5cfp-15,   0x1.ffff0ap-1, INEXACT) // -5.537964547884475781207302969023e-05
T(RZ,  -0x1.d08ee212b37bcp-15,  -0x1.d08ee216af5cfp-15,   0x1.ffff0ap-1, INEXACT) // -5.537964547884475781207302969023e-05
T(RN,   0x1.d14231ce66d09p-21,   0x1.d14231ce67109p-21,  -0x1.ffff72p-2, INEXACT) // 8.666116231738762899709902116918e-07
T(RN,  -0x1.dfc95cced2bd9p-21,  -0x1.dfc95cced303dp-21,  -0x1.fffee2p-2, INEXACT) // -8.936721317213353048771362803493e-07
T(RD,   -0x1.8c876a857f429p-8,   -0x1.8c880915854abp-8,  -0x1.dd718p-18, INEXACT) // -6.050551897257818757813740973006e-03
T(RU,   -0x1.8c876a857f429p-8,   -0x1.8c880915854aap-8,   0x1.ffff12p-1, INEXACT) // -6.050551897257818757813740973006e-03
T(RZ,   -0x1.8c876a857f429p-8,   -0x1.8c880915854aap-8,   0x1.ffff12p-1, INEXACT) // -6.050551897257818757813740973006e-03
T(RN,    0x1.05f2f84448bc4p-7,    0x1.05f3af1d91825p-7,   0x1.ffff3ap-2, INEXACT) // 7.994052146903636579811092133241e-03
T(RD,   0x1.0a40272eef0d6p-24,   0x1.0a40272eef0d8p-24,  -0x1.ffff6ap-1, INEXACT) // 6.199129808001354930290947766597e-08
T(RU,   0x1.0a40272eef0d6p-24,   0x1.0a40272eef0d9p-24,  0x1.2a367cp-18, INEXACT) // 6.199129808001354930290947766597e-08
T(RZ,   0x1.0a40272eef0d6p-24,   0x1.0a40272eef0d8p-24,  -0x1.ffff6ap-1, INEXACT) // 6.199129808001354930290947766597e-08
T(RD,  -0x1.854bebbd68e8ap-12,  -0x1.854bec5373758p-12,  -0x1.b6721p-25, INEXACT) // -3.712621363211951333940796793343e-04
T(RU,  -0x1.854bebbd68e8ap-12,  -0x1.854bec5373757p-12,   0x1.fffffep-1, INEXACT) // -3.712621363211951333940796793343e-04
T(RZ,  -0x1.854bebbd68e8ap-12,  -0x1.854bec5373757p-12,   0x1.fffffep-1, INEXACT) // -3.712621363211951333940796793343e-04
T(RD,   0x1.ce982008af83ep-21,   0x1.ce982008afc2cp-21,  -0x1.ffffacp-1, INEXACT) // 8.616489149610557788169914669729e-07
T(RU,   0x1.ce982008af83ep-21,   0x1.ce982008afc2dp-21,  0x1.51fb36p-19, INEXACT) // 8.616489149610557788169914669729e-07
T(RZ,   0x1.ce982008af83ep-21,   0x1.ce982008afc2cp-21,  -0x1.ffffacp-1, INEXACT) // 8.616489149610557788169914669729e-07
T(RN,  -0x1.560cc57b4e439p-15,  -0x1.560cc57ce55c3p-15,   0x1.fffea6p-2, INEXACT) // -4.077552417886720392868962759003e-05
T(RN,   0x1.0dae5b7ebcb65p-10,   0x1.0dae5e9cce62dp-10,   0x1.fffe16p-2, INEXACT) // 1.028751692214690790019848698478e-03
T(RD,  -0x1.8783a9b2a78d4p-12,  -0x1.8783aa4b464ccp-12, -0x1.cd4e68p-18, INEXACT) // -3.733771401729483758319405595216e-04
T(RU,  -0x1.8783a9b2a78d4p-12,  -0x1.8783aa4b464cbp-12,   0x1.ffff1ap-1, INEXACT) // -3.733771401729483758319405595216e-04
T(RZ,  -0x1.8783a9b2a78d4p-12,  -0x1.8783aa4b464cbp-12,   0x1.ffff1ap-1, INEXACT) // -3.733771401729483758319405595216e-04
T(RN,   0x1.f93ea059093bbp-24,    0x1.f93ea059093dp-24,   0x1.fffeb4p-2, INEXACT) // 1.176364333865263374214206178008e-07
T(RN,  -0x1.d3e48a9ea9e2dp-22,  -0x1.d3e48a9ea9f32p-22,   -0x1.fffe3p-2, INEXACT) // -4.357590714189961208554623551398e-07
T(RD,  -0x1.61dd0786f9efap-20,  -0x1.61dd0786fa605p-20, -0x1.8d0728p-18, INEXACT) // -1.318243876497218777761122679437e-06
T(RU,  -0x1.61dd0786f9efap-20,  -0x1.61dd0786fa604p-20,   0x1.ffff3ap-1, INEXACT) // -1.318243876497218777761122679437e-06
T(RZ,  -0x1.61dd0786f9efap-20,  -0x1.61dd0786fa604p-20,   0x1.ffff3ap-1, INEXACT) // -1.318243876497218777761122679437e-06
T(RD,    0x1.453c05660bd05p-3,     0x1.469e036d1b7bp-3,  -0x1.ffff0ap-1, INEXACT) // 1.588058873908055057544430610506e-01
T(RU,    0x1.453c05660bd05p-3,    0x1.469e036d1b7b1p-3,  0x1.ed0282p-18, INEXACT) // 1.588058873908055057544430610506e-01
T(RZ,    0x1.453c05660bd05p-3,     0x1.469e036d1b7bp-3,  -0x1.ffff0ap-1, INEXACT) // 1.588058873908055057544430610506e-01
T(RD,   0x1.f51a602a0874fp-25,   0x1.f51a602a08753p-25,  -0x1.ffffe4p-1, INEXACT) // 5.833607048833673817016251604388e-08
T(RU,   0x1.f51a602a0874fp-25,   0x1.f51a602a08754p-25,  0x1.c585bep-21, INEXACT) // 5.833607048833673817016251604388e-08
T(RZ,   0x1.f51a602a0874fp-25,   0x1.f51a602a08753p-25,  -0x1.ffffe4p-1, INEXACT) // 5.833607048833673817016251604388e-08
T(RN,  -0x1.51316b5507beep-22,   -0x1.51316b5507c5p-22,  -0x1.fffe94p-2, INEXACT) // -3.140354938885456954268562794474e-07
T(RD,    0x1.0f27db12a85a6p-2,    0x1.126dce988d1acp-2,  -0x1.ffffeep-1, INEXACT) // 2.648004751336777706782754648884e-01
T(RU,    0x1.0f27db12a85a6p-2,    0x1.126dce988d1adp-2,  0x1.209398p-21, INEXACT) // 2.648004751336777706782754648884e-01
T(RZ,    0x1.0f27db12a85a6p-2,    0x1.126dce988d1acp-2,  -0x1.ffffeep-1, INEXACT) // 2.648004751336777706782754648884e-01
T(RN,  -0x1.4f7498006a905p-25,  -0x1.4f7498006a907p-25,  -0x1.fffe14p-2, INEXACT) // -3.905215351385399695502824457018e-08
T(RD,  -0x1.7c6938c3527bbp-23,  -0x1.7c6938c3527dfp-23,  -0x1.ffff5ep-1, INEXACT) // -1.771426863895253451106672750934e-07
T(RU,  -0x1.7c6938c3527bbp-23,  -0x1.7c6938c3527dep-23,  0x1.427122p-18, INEXACT) // -1.771426863895253451106672750934e-07
T(RZ,  -0x1.7c6938c3527bbp-23,  -0x1.7c6938c3527dep-23,  0x1.427122p-18, INEXACT) // -1.771426863895253451106672750934e-07
T(RN,  -0x1.128a95d747236p-21,  -0x1.128a95d747308p-21,   0x1.fffff2p-2, INEXACT) // -5.113731117753909682547381818085e-07
T(RN,  -0x1.d8c7548b200c4p-14,  -0x1.d8c7549bebfccp-14,   -0x1.fffe3p-2, INEXACT) // -1.127192100955935944762986711254e-04
T(RN,    0x1.4b9d15a53ea12p-7,    0x1.4b9e889f1cfc9p-7,   0x1.ffffe8p-2, INEXACT) // 1.012004429729976631713306289839e-02
T(RN,    0x1.353364a6d759dp-1,    0x1.4bfa660008e23p-1,  -0x1.ffff1ap-2, INEXACT) // 6.039077237762061622916576197895e-01
T(RD,   0x1.daadd69548027p-24,   0x1.daadd69548038p-24, -0x1.44e9aap-18, INEXACT) // 1.105198300277622113399247894515e-07
T(RU,   0x1.daadd69548027p-24,   0x1.daadd69548039p-24,   0x1.ffff5ep-1, INEXACT) // 1.105198300277622113399247894515e-07
T(RZ,   0x1.daadd69548027p-24,   0x1.daadd69548038p-24, -0x1.44e9aap-18, INEXACT) // 1.105198300277622113399247894515e-07
T(RN,   0x1.3d59fa20967f9p-20,   0x1.3d59fa2096d0ep-20,   0x1.fffffcp-2, INEXACT) // 1.182226363158430426487607335650e-06
T(RD,    0x1.1d584762e4cacp-2,    0x1.212c49c0ac2c2p-2, -0x1.db2868p-18, INEXACT) // 2.786570695981918088790507681551e-01
T(RU,    0x1.1d584762e4cacp-2,    0x1.212c49c0ac2c3p-2,   0x1.ffff12p-1, INEXACT) // 2.786570695981918088790507681551e-01
T(RZ,    0x1.1d584762e4cacp-2,    0x1.212c49c0ac2c2p-2, -0x1.db2868p-18, INEXACT) // 2.786570695981918088790507681551e-01
T(RN,   0x1.a50798a811df1p-19,   0x1.a50798a814d64p-19,  -0x1.ffff52p-2, INEXACT) // 3.136915513155451546383313890520e-06
T(RN,   0x1.04691a738de24p-11,   0x1.04691b2731e45p-11,   0x1.ffff04p-2, INEXACT) // 4.966937253305142747905609468262e-04
T(RN,   -0x1.bc552f8739c5cp-5,   -0x1.bc8d08acbb332p-5,  -0x1.ffff7ep-2, INEXACT) // -5.423983843666554949258795659262e-02
T(RN,  -0x1.b8e625e67e2d1p-16,  -0x1.b8e625e758241p-16,  -0x1.fffe32p-2, INEXACT) // -2.627962921939142084391295706158e-05
T(RD,    -0x1.8c1fd04be98ap-8,   -0x1.8c206e5fc6d86p-8, -0x1.51f6bap-24, INEXACT) // -6.044376710553717169105425455200e-03
T(RU,    -0x1.8c1fd04be98ap-8,   -0x1.8c206e5fc6d85p-8,   0x1.fffffep-1, INEXACT) // -6.044376710553717169105425455200e-03
T(RZ,    -0x1.8c1fd04be98ap-8,   -0x1.8c206e5fc6d85p-8,   0x1.fffffep-1, INEXACT) // -6.044376710553717169105425455200e-03
T(RN,   0x1.eddef0a60af77p-20,   0x1.eddef0a60c29cp-20,  -0x1.ffff34p-2, INEXACT) // 1.839812321611864053631769065633e-06
T(RN,    -0x1.1d95e4a74425p-9,   -0x1.1d95f3764e2ccp-9,  -0x1.ffff14p-2, INEXACT) // -2.178844606199249744893364777454e-03
T(RD,   0x1.1ecf5526a8edcp-23,   0x1.1ecf5526a8eeap-23,  -0x1.ffffc8p-1, INEXACT) // 1.335562640108999770432898594741e-07
T(RU,   0x1.1ecf5526a8edcp-23,   0x1.1ecf5526a8eebp-23,  0x1.c3d802p-20, INEXACT) // 1.335562640108999770432898594741e-07
T(RZ,   0x1.1ecf5526a8edcp-23,   0x1.1ecf5526a8eeap-23,  -0x1.ffffc8p-1, INEXACT) // 1.335562640108999770432898594741e-07
T(RN,  -0x1.0ef4fc45395b6p-14,  -0x1.0ef4fc4862ce8p-14,  -0x1.fffee8p-2, INEXACT) // -6.460117682002036363329844359527e-05
T(RN,   -0x1.9491464f18dd4p-7,    -0x1.9493e7f46245p-7,  -0x1.fffe54p-2, INEXACT) // -1.234641964965180888080809040730e-02
T(RN,   0x1.d24fa459d5532p-19,   0x1.d24fa459d95aap-19,   0x1.fffe6ep-2, INEXACT) // 3.474288445307971267812883336967e-06
T(RD,   -0x1.b3498faf46941p-6,   -0x1.b356acb65ab12p-6,  -0x1.cd5b6p-18, INEXACT) // -2.656783134180185426687081928776e-02
T(RU,   -0x1.b3498faf46941p-6,   -0x1.b356acb65ab11p-6,   0x1.ffff1ap-1, INEXACT) // -2.656783134180185426687081928776e-02
T(RZ,   -0x1.b3498faf46941p-6,   -0x1.b356acb65ab11p-6,   0x1.ffff1ap-1, INEXACT) // -2.656783134180185426687081928776e-02
T(RN,  -0x1.e50a59b5ca4b4p-11,  -0x1.e50a5e3e9aca6p-11,   0x1.fffeecp-2, INEXACT) // -9.251412036280965735246528680591e-04
T(RD,   -0x1.1018c7a68a734p-5,   -0x1.1025981c5ab86p-5, -0x1.c5114cp-18, INEXACT) // -3.321494096992552713665247665631e-02
T(RU,   -0x1.1018c7a68a734p-5,   -0x1.1025981c5ab85p-5,   0x1.ffff1ep-1, INEXACT) // -3.321494096992552713665247665631e-02
T(RZ,   -0x1.1018c7a68a734p-5,   -0x1.1025981c5ab85p-5,   0x1.ffff1ep-1, INEXACT) // -3.321494096992552713665247665631e-02
T(RN,  -0x1.d2c4778df6a76p-21,  -0x1.d2c4778df6e81p-21,  -0x1.fffebap-2, INEXACT) // -8.694221251785418313828097611196e-07
T(RN,   0x1.d9a68ede99df9p-16,   0x1.d9a68edfa81bfp-16,  -0x1.fffe92p-2, INEXACT) // 2.823177680469181731492435416531e-05
T(RD,   0x1.cdd8b6ebdab28p-19,   0x1.cdd8b6ebde9cap-19,  -0x1.3f2a9p-18, INEXACT) // 3.441024878305348175299219204426e-06
T(RU,   0x1.cdd8b6ebdab28p-19,   0x1.cdd8b6ebde9cbp-19,    0x1.ffff6p-1, INEXACT) // 3.441024878305348175299219204426e-06
T(RZ,   0x1.cdd8b6ebdab28p-19,   0x1.cdd8b6ebde9cap-19,  -0x1.3f2a9p-18, INEXACT) // 3.441024878305348175299219204426e-06
T(RD,    -0x1.4d31c500ad67p-9,   -0x1.4d31dc85531b2p-9,  -0x1.ffff96p-1, INEXACT) // -2.542071626829671415759293040537e-03
T(RU,    -0x1.4d31c500ad67p-9,   -0x1.4d31dc85531b1p-9,  0x1.a6d6cep-19, INEXACT) // -2.542071626829671415759293040537e-03
T(RZ,    -0x1.4d31c500ad67p-9,   -0x1.4d31dc85531b1p-9,  0x1.a6d6cep-19, INEXACT) // -2.542071626829671415759293040537e-03
T(RN,   0x1.8606820cb508fp-14,    0x1.860682162334p-14,  -0x1.ffff44p-2, INEXACT) // 9.298930690288170276044249495939e-05
T(RN,    0x1.8884d18dcdc22p-9,    0x1.8884f800e7fffp-9,   0x1.fffe72p-2, INEXACT) // 2.994680958092314250473808812103e-03
T(RD,   0x1.654c1bb26fb92p-23,   0x1.654c1bb26fbafp-23, -0x1.b1cc8cp-20, INEXACT) // 1.663795195626765625419917014188e-07
T(RU,   0x1.654c1bb26fb92p-23,    0x1.654c1bb26fbbp-23,   0x1.ffffcap-1, INEXACT) // 1.663795195626765625419917014188e-07
T(RZ,   0x1.654c1bb26fb92p-23,   0x1.654c1bb26fbafp-23, -0x1.b1cc8cp-20, INEXACT) // 1.663795195626765625419917014188e-07
T(RN,   -0x1.46bfc35216d1dp-9,    -0x1.46bfd9800f2dp-9,   -0x1.ffff2p-2, INEXACT) // -2.492897599081124546810395159468e-03
T(RN,    0x1.08cffd8202cd7p-6,    0x1.08d2f137bf892p-6,   0x1.ffff0ep-2, INEXACT) // 1.616286999346247185704861237809e-02
T(RN,  -0x1.c1cff178f6305p-11,  -0x1.c1cff516c618dp-11,   0x1.ffff9cp-2, INEXACT) // -8.579488340912660862894179025773e-04
T(RD,    0x1.249723a1ba0d9p-3,    0x1.25985060dfb44p-3, -0x1.451166p-18, INEXACT) // 1.428664001207440581442398297440e-01
T(RU,    0x1.249723a1ba0d9p-3,    0x1.25985060dfb45p-3,   0x1.ffff5ep-1, INEXACT) // 1.428664001207440581442398297440e-01
T(RZ,    0x1.249723a1ba0d9p-3,    0x1.25985060dfb44p-3, -0x1.451166p-18, INEXACT) // 1.428664001207440581442398297440e-01
T(RD,   -0x1.afe9357a3dff2p-5,   -0x1.b01c7fcc3e787p-5,  -0x1.ffffb4p-1, INEXACT) // -5.272350735498311513627101021484e-02
T(RU,   -0x1.afe9357a3dff2p-5,   -0x1.b01c7fcc3e786p-5,  0x1.2c5c94p-19, INEXACT) // -5.272350735498311513627101021484e-02
T(RZ,   -0x1.afe9357a3dff2p-5,   -0x1.b01c7fcc3e786p-5,  0x1.2c5c94p-19, INEXACT) // -5.272350735498311513627101021484e-02
T(RD,   -0x1.0580abbd2a4e6p-8,    -0x1.0580d9377fa8p-8,  -0x1.ffffa2p-1, INEXACT) // -3.990213325928615092919038431774e-03
T(RU,   -0x1.0580abbd2a4e6p-8,   -0x1.0580d9377fa7fp-8,  0x1.767ce6p-19, INEXACT) // -3.990213325928615092919038431774e-03
T(RZ,   -0x1.0580abbd2a4e6p-8,   -0x1.0580d9377fa7fp-8,  0x1.767ce6p-19, INEXACT) // -3.990213325928615092919038431774e-03
T(RN,  -0x1.3a8e710f30128p-16,  -0x1.3a8e710f7f399p-16,  -0x1.ffff8ep-2, INEXACT) // -1.874902323773064796198772885560e-05
T(RD,  -0x1.2b076d8922af3p-23,  -0x1.2b076d8922b04p-23, -0x1.0cc614p-18, INEXACT) // -1.392462361286951791103063324692e-07
T(RU,  -0x1.2b076d8922af3p-23,  -0x1.2b076d8922b03p-23,   0x1.ffff7ap-1, INEXACT) // -1.392462361286951791103063324692e-07
T(RZ,  -0x1.2b076d8922af3p-23,  -0x1.2b076d8922b03p-23,   0x1.ffff7ap-1, INEXACT) // -1.392462361286951791103063324692e-07
T(RN,   0x1.f302173e155e6p-17,   0x1.f302173e645e9p-17,   -0x1.ffffdp-2, INEXACT) // 1.487160227157508405010193086593e-05
T(RN,  -0x1.14e9753b52185p-23,  -0x1.14e9753b52193p-23,  -0x1.fffef2p-2, INEXACT) // -1.289471728094427749130879709907e-07
T(RD,    0x1.ddcc577d91c4ap-4,    0x1.dee3739cc28abp-4,  -0x1.ffffc8p-1, INEXACT) // 1.166499536130781999876404597671e-01
T(RU,    0x1.ddcc577d91c4ap-4,    0x1.dee3739cc28acp-4,  0x1.c1303cp-20, INEXACT) // 1.166499536130781999876404597671e-01
T(RZ,    0x1.ddcc577d91c4ap-4,    0x1.dee3739cc28abp-4,  -0x1.ffffc8p-1, INEXACT) // 1.166499536130781999876404597671e-01
T(RD,   0x1.61246f6188a65p-23,   0x1.61246f6188a81p-23, -0x1.de483cp-18, INEXACT) // 1.644447094477027228974762860028e-07
T(RU,   0x1.61246f6188a65p-23,   0x1.61246f6188a82p-23,    0x1.ffff1p-1, INEXACT) // 1.644447094477027228974762860028e-07
T(RZ,   0x1.61246f6188a65p-23,   0x1.61246f6188a81p-23, -0x1.de483cp-18, INEXACT) // 1.644447094477027228974762860028e-07
T(RN,  -0x1.c8c3435faba43p-15,  -0x1.c8c3436375095p-15,   0x1.ffff7cp-2, INEXACT) // -5.445036253825090037444453527904e-05
T(RD,   0x1.b160d924c0695p-22,   0x1.b160d924c0763p-22,  -0x1.ffffeap-1, INEXACT) // 4.036150065695802114497739172122e-07
T(RU,   0x1.b160d924c0695p-22,   0x1.b160d924c0764p-22,  0x1.601b9cp-21, INEXACT) // 4.036150065695802114497739172122e-07
T(RZ,   0x1.b160d924c0695p-22,   0x1.b160d924c0763p-22,  -0x1.ffffeap-1, INEXACT) // 4.036150065695802114497739172122e-07
T(RN,   -0x1.66f5e36e46695p-3,   -0x1.68d3063b0c03fp-3,  -0x1.ffff4ap-2, INEXACT) // -1.752736824062607612351172292620e-01
T(RN,  -0x1.6fc49972cdd19p-22,  -0x1.6fc49972cdd97p-22,    0x1.ffff2p-2, INEXACT) // -3.425106093637430526567760977891e-07
T(RN,   -0x1.fd79b090c1d5fp-1,   -0x1.78b0d62ded7d6p+0,  -0x1.ffff06p-2, INEXACT) // -9.950690437989740955160300472926e-01
T(RD,   0x1.50094975e34b3p-19,   0x1.50094975e4cd2p-19,  -0x1.ffff52p-1, INEXACT) // 2.503665366532399803124525269893e-06
T(RU,   0x1.50094975e34b3p-19,   0x1.50094975e4cd3p-19,  0x1.5a72fcp-18, INEXACT) // 2.503665366532399803124525269893e-06
T(RZ,   0x1.50094975e34b3p-19,   0x1.50094975e4cd2p-19,  -0x1.ffff52p-1, INEXACT) // 2.503665366532399803124525269893e-06
T(RN,    0x1.1592ef34f4bc4p-5,    0x1.15a089da8d38dp-5,  -0x1.ffffd2p-2, INEXACT) // 3.388354034509391543572576210863e-02
T(RN,  -0x1.b086af072c8e4p-20,  -0x1.b086af072d5c1p-20,  -0x1.fffeacp-2, INEXACT) // -1.611285314767406787238388649053e-06
T(RD,  -0x1.385a85e54ca0dp-10,  -0x1.385a8abd51b81p-10,  -0x1.ffff3ap-1, INEXACT) // -1.191534445137978947062973311688e-03
T(RU,  -0x1.385a85e54ca0dp-10,   -0x1.385a8abd51b8p-10,   0x1.8d566p-18, INEXACT) // -1.191534445137978947062973311688e-03
T(RZ,  -0x1.385a85e54ca0dp-10,   -0x1.385a8abd51b8p-10,   0x1.8d566p-18, INEXACT) // -1.191534445137978947062973311688e-03
T(RN,      0x1.e78b13c7d8ap-1,    0x1.42adf16931daep+0,   0x1.fffe8ap-2, INEXACT) // 9.522329503491278046567458659410e-01
T(RD,   -0x1.da9b86b3bf8dcp-9,   -0x1.da9bcaabfcb9bp-9,   -0x1.ffff7p-1, INEXACT) // -3.620968049175761135916040700522e-03
T(RU,   -0x1.da9b86b3bf8dcp-9,   -0x1.da9bcaabfcb9ap-9,  0x1.1fe202p-18, INEXACT) // -3.620968049175761135916040700522e-03
T(RZ,   -0x1.da9b86b3bf8dcp-9,   -0x1.da9bcaabfcb9ap-9,  0x1.1fe202p-18, INEXACT) // -3.620968049175761135916040700522e-03
T(RN,  -0x1.37829487092b4p-21,  -0x1.37829487093e7p-21,   0x1.ffffb6p-2, INEXACT) // -5.802327373056544104897806063414e-07
T(RD,   0x1.18b4a8c59b62dp-21,   0x1.18b4a8c59b70dp-21,  -0x1.ffff2ep-1, INEXACT) // 5.228551109411868079817329625636e-07
T(RU,   0x1.18b4a8c59b62dp-21,   0x1.18b4a8c59b70ep-21,   0x1.a5c2cp-18, INEXACT) // 5.228551109411868079817329625636e-07
T(RZ,   0x1.18b4a8c59b62dp-21,   0x1.18b4a8c59b70dp-21,  -0x1.ffff2ep-1, INEXACT) // 5.228551109411868079817329625636e-07
T(RD,    0x1.c0dbe0a3e312p-19,   0x1.c0dbe0a3e6a9ep-19,  -0x1.ffffc2p-1, INEXACT) // 3.344259384923994730433316480145e-06
T(RU,    0x1.c0dbe0a3e312p-19,   0x1.c0dbe0a3e6a9fp-19,   0x1.e8712p-20, INEXACT) // 3.344259384923994730433316480145e-06
T(RZ,    0x1.c0dbe0a3e312p-19,   0x1.c0dbe0a3e6a9ep-19,  -0x1.ffffc2p-1, INEXACT) // 3.344259384923994730433316480145e-06
T(RD,  -0x1.c979cfd8eee5cp-16,  -0x1.c979cfd9e2621p-16, -0x1.b30e92p-19, INEXACT) // -2.726768420634042373786737334385e-05
T(RU,  -0x1.c979cfd8eee5cp-16,   -0x1.c979cfd9e262p-16,   0x1.ffff94p-1, INEXACT) // -2.726768420634042373786737334385e-05
T(RZ,  -0x1.c979cfd8eee5cp-16,   -0x1.c979cfd9e262p-16,   0x1.ffff94p-1, INEXACT) // -2.726768420634042373786737334385e-05
T(RD,  -0x1.54e2b267824b2p-18,  -0x1.54e2b2678896fp-18, -0x1.6aef3cp-19, INEXACT) // -5.079590301723299120809258788700e-06
T(RU,  -0x1.54e2b267824b2p-18,  -0x1.54e2b2678896ep-18,   0x1.ffffa6p-1, INEXACT) // -5.079590301723299120809258788700e-06
T(RZ,  -0x1.54e2b267824b2p-18,  -0x1.54e2b2678896ep-18,   0x1.ffffa6p-1, INEXACT) // -5.079590301723299120809258788700e-06
T(RN,  -0x1.0d64358642522p-20,  -0x1.0d6435864283ep-20,  -0x1.ffff66p-2, INEXACT) // -1.003561324321792375802555111197e-06
T(RN,    0x1.511c5a9dcfc08p-2,    0x1.57848958ce489p-2,   0x1.fffe52p-2, INEXACT) // 3.292097243137850348659867449896e-01
T(RD,   0x1.abc443018bd5ep-13,   0x1.abc443334fd6ep-13, -0x1.805d3cp-18, INEXACT) // 2.039750325350903558362103407120e-04
T(RU,   0x1.abc443018bd5ep-13,   0x1.abc443334fd6fp-13,    0x1.ffff4p-1, INEXACT) // 2.039750325350903558362103407120e-04
T(RZ,   0x1.abc443018bd5ep-13,   0x1.abc443334fd6ep-13, -0x1.805d3cp-18, INEXACT) // 2.039750325350903558362103407120e-04
T(RD,    0x1.4d46cea79ee3p-13,   0x1.4d46cebf27f8fp-13, -0x1.68165cp-21, INEXACT) // 1.589186624534207580017319827448e-04
T(RU,    0x1.4d46cea79ee3p-13,    0x1.4d46cebf27f9p-13,   0x1.ffffeap-1, INEXACT) // 1.589186624534207580017319827448e-04
T(RZ,    0x1.4d46cea79ee3p-13,   0x1.4d46cebf27f8fp-13, -0x1.68165cp-21, INEXACT) // 1.589186624534207580017319827448e-04
T(RN,    0x1.370568a969a12p-1,    0x1.4e44107181e43p-1,   0x1.fffed6p-2, INEXACT) // 6.074631411364086464033107404248e-01
T(RN,  -0x1.4ab7f4ed6d0dap-16,  -0x1.4ab7f4edc90b5p-16,  -0x1.ffff2cp-2, INEXACT) // -1.971236354388135634608039681304e-05
T(RN,   0x1.53f879d082f9bp-16,   0x1.53f879d0e6e79p-16,  -0x1.fffffcp-2, INEXACT) // 2.026382736812458925930273412330e-05
T(RD,  -0x1.250c09a1e03b4p-25,  -0x1.250c09a1e03b6p-25,  -0x1.ffffc4p-1, INEXACT) // -3.411516337395381683919549312828e-08
T(RU,  -0x1.250c09a1e03b4p-25,  -0x1.250c09a1e03b5p-25,  0x1.e35674p-20, INEXACT) // -3.411516337395381683919549312828e-08
T(RZ,  -0x1.250c09a1e03b4p-25,  -0x1.250c09a1e03b5p-25,  0x1.e35674p-20, INEXACT) // -3.411516337395381683919549312828e-08
T(RD,  -0x1.71be80e9ef7f3p-12,  -0x1.71be816a7c59dp-12, -0x1.e1a738p-18, INEXACT) // -3.526155038534588173453065973462e-04
T(RU,  -0x1.71be80e9ef7f3p-12,  -0x1.71be816a7c59cp-12,    0x1.ffff1p-1, INEXACT) // -3.526155038534588173453065973462e-04
T(RZ,  -0x1.71be80e9ef7f3p-12,  -0x1.71be816a7c59cp-12,    0x1.ffff1p-1, INEXACT) // -3.526155038534588173453065973462e-04
T(RD,   0x1.012950e1bb4f3p-21,    0x1.012950e1bb5ap-21, -0x1.3061d4p-20, INEXACT) // 4.790004164125424352248402114218e-07
T(RU,   0x1.012950e1bb4f3p-21,   0x1.012950e1bb5a1p-21,   0x1.ffffdap-1, INEXACT) // 4.790004164125424352248402114218e-07
T(RZ,   0x1.012950e1bb4f3p-21,    0x1.012950e1bb5ap-21, -0x1.3061d4p-20, INEXACT) // 4.790004164125424352248402114218e-07
T(RN,    0x1.fb911f2835313p-9,    0x1.fb91724b2500bp-9,  -0x1.ffff44p-2, INEXACT) // 3.872427991249324710082424516600e-03
T(RD,  -0x1.86fbbb169134dp-23,  -0x1.86fbbb1691373p-23, -0x1.8a323ap-18, INEXACT) // -1.820657977315901539182952740062e-07
T(RU,  -0x1.86fbbb169134dp-23,  -0x1.86fbbb1691372p-23,   0x1.ffff3ap-1, INEXACT) // -1.820657977315901539182952740062e-07
T(RZ,  -0x1.86fbbb169134dp-23,  -0x1.86fbbb1691372p-23,   0x1.ffff3ap-1, INEXACT) // -1.820657977315901539182952740062e-07
T(RN,    0x1.c554a9facd4aap-2,    0x1.d59eeaa21b79ap-2,   0x1.fffeccp-2, INEXACT) // 4.427057799651473724011907506792e-01
T(RN,   -0x1.34228dcccb15ap-1,   -0x1.4aa46d308f87fp-1,  -0x1.ffff3cp-2, INEXACT) // -6.018261253825969436803688950022e-01
T(RN,   -0x1.259fce38c5bdcp-2,   -0x1.29cdf56606591p-2,   0x1.fffe3ap-2, INEXACT) // -2.867424223090304646888171191677e-01
T(RN,    0x1.de2e17ec06ba4p-5,    0x1.de73b74b6ac26p-5,  -0x1.fffe68p-2, INEXACT) // 5.837158844243298116971629951877e-02
T(RD,    0x1.12fd132eacf3fp-6,    0x1.1300616940552p-6, -0x1.a765cap-18, INEXACT) // 1.678397057794644639527881224694e-02
T(RU,    0x1.12fd132eacf3fp-6,    0x1.1300616940553p-6,   0x1.ffff2cp-1, INEXACT) // 1.678397057794644639527881224694e-02
T(RZ,    0x1.12fd132eacf3fp-6,    0x1.1300616940552p-6, -0x1.a765cap-18, INEXACT) // 1.678397057794644639527881224694e-02
T(RD,  -0x1.8caeb38941f8fp-17,  -0x1.8caeb38969a8ap-17,  -0x1.ffffcep-1, INEXACT) // -1.182205757511970165083824840790e-05
T(RU,  -0x1.8caeb38941f8fp-17,  -0x1.8caeb38969a89p-17,   0x1.963aap-20, INEXACT) // -1.182205757511970165083824840790e-05
T(RZ,  -0x1.8caeb38941f8fp-17,  -0x1.8caeb38969a89p-17,   0x1.963aap-20, INEXACT) // -1.182205757511970165083824840790e-05
T(RD,  -0x1.01a0052e5a214p-19,  -0x1.01a0052e5acf4p-19,   -0x1.ffff5p-1, INEXACT) // -1.919456415301143905488036323082e-06
T(RU,  -0x1.01a0052e5a214p-19,  -0x1.01a0052e5acf3p-19,   0x1.5f971p-18, INEXACT) // -1.919456415301143905488036323082e-06
T(RZ,  -0x1.01a0052e5a214p-19,  -0x1.01a0052e5acf3p-19,   0x1.5f971p-18, INEXACT) // -1.919456415301143905488036323082e-06
T(RN,   0x1.f2162b2f1f65dp-18,   0x1.f2162b2f3309ep-18,  -0x1.ffff2cp-2, INEXACT) // 7.422068661997591552525067176704e-06
T(RD,   0x1.1f185ac341c7cp-13,   0x1.1f185ad24d3f8p-13,  -0x1.ffffcap-1, INEXACT) // 1.368976282736001108195078579399e-04
T(RU,   0x1.1f185ac341c7cp-13,   0x1.1f185ad24d3f9p-13,  0x1.ad46f6p-20, INEXACT) // 1.368976282736001108195078579399e-04
T(RZ,   0x1.1f185ac341c7cp-13,   0x1.1f185ad24d3f8p-13,  -0x1.ffffcap-1, INEXACT) // 1.368976282736001108195078579399e-04
T(RD,   0x1.81b6ed1b1dd62p-20,   0x1.81b6ed1b1e681p-20,  -0x1.b6bc7p-20, INEXACT) // 1.436898691390752999687665039663e-06
T(RU,   0x1.81b6ed1b1dd62p-20,   0x1.81b6ed1b1e682p-20,   0x1.ffffcap-1, INEXACT) // 1.436898691390752999687665039663e-06
T(RZ,   0x1.81b6ed1b1dd62p-20,   0x1.81b6ed1b1e681p-20,  -0x1.b6bc7p-20, INEXACT) // 1.436898691390752999687665039663e-06
T(RD,   0x1.525662a936c36p-18,   0x1.525662a93ceb4p-18,  -0x1.ffffbep-1, INEXACT) // 5.041620775271410335983089667788e-06
T(RU,   0x1.525662a936c36p-18,   0x1.525662a93ceb5p-18,  0x1.09af38p-19, INEXACT) // 5.041620775271410335983089667788e-06
T(RZ,   0x1.525662a936c36p-18,   0x1.525662a93ceb4p-18,  -0x1.ffffbep-1, INEXACT) // 5.041620775271410335983089667788e-06
T(RN,   0x1.51c4bb4c73df7p-23,    0x1.51c4bb4c73e1p-23,   0x1.fffe54p-2, INEXACT) // 1.572857065827056903728795684769e-07
T(RD,   0x1.62a703e33a30cp-13,   0x1.62a703ff968a2p-13,  -0x1.ffff38p-1, INEXACT) // 1.691114440298891385613955229417e-04
T(RU,   0x1.62a703e33a30cp-13,   0x1.62a703ff968a3p-13,  0x1.8f5e46p-18, INEXACT) // 1.691114440298891385613955229417e-04
T(RZ,   0x1.62a703e33a30cp-13,   0x1.62a703ff968a2p-13,  -0x1.ffff38p-1, INEXACT) // 1.691114440298891385613955229417e-04
T(RN,   0x1.6c6422f894151p-17,   0x1.6c6422f8b2d81p-17,  -0x1.ffffbcp-2, INEXACT) // 1.085970278427774074047219149408e-05
T(RD,   0x1.c49dd33b438d6p-13,   0x1.c49dd37637508p-13,  -0x1.ffff9ap-1, INEXACT) // 2.158243677076790152484508933384e-04
T(RU,   0x1.c49dd33b438d6p-13,   0x1.c49dd37637509p-13,  0x1.9a82acp-19, INEXACT) // 2.158243677076790152484508933384e-04
T(RZ,   0x1.c49dd33b438d6p-13,   0x1.c49dd37637508p-13,  -0x1.ffff9ap-1, INEXACT) // 2.158243677076790152484508933384e-04
T(RN,   0x1.1ccc59e547e96p-13,   0x1.1ccc59f3f7ad4p-13,   -0x1.fffeep-2, INEXACT) // 1.358023866169135308694382313632e-04
T(RN,   0x1.0609e9e7ebebcp-19,   0x1.0609e9e7eca2cp-19,  -0x1.fffecep-2, INEXACT) // 1.952340642895207704974984419533e-06
T(RD,   0x1.ffe1537f5a1a9p-19,   0x1.ffe1537f5f6efp-19, -0x1.c57634p-19, INEXACT) // 3.813804539444006907615613080620e-06
T(RU,   0x1.ffe1537f5a1a9p-19,    0x1.ffe1537f5f6fp-19,   0x1.ffff8ep-1, INEXACT) // 3.813804539444006907615613080620e-06
T(RZ,   0x1.ffe1537f5a1a9p-19,   0x1.ffe1537f5f6efp-19, -0x1.c57634p-19, INEXACT) // 3.813804539444006907615613080620e-06
T(RD,  -0x1.f967b3ea79ebdp-10,  -0x1.f967c86f7ce42p-10, -0x1.193ceep-18, INEXACT) // -1.927967411228622600719018187476e-03
T(RU,  -0x1.f967b3ea79ebdp-10,  -0x1.f967c86f7ce41p-10,   0x1.ffff74p-1, INEXACT) // -1.927967411228622600719018187476e-03
T(RZ,  -0x1.f967b3ea79ebdp-10,  -0x1.f967c86f7ce41p-10,   0x1.ffff74p-1, INEXACT) // -1.927967411228622600719018187476e-03
T(RN,   0x1.e3cf5480b48abp-25,    0x1.e3cf5480b48bp-25,   0x1.fffe8ap-2, INEXACT) // 5.632288325108953666106665811829e-08
T(RD,  -0x1.250c197257b83p-25,  -0x1.250c197257b85p-25,   -0x1.ffff7p-1, INEXACT) // -3.411519146583506959115628955591e-08
T(RU,  -0x1.250c197257b83p-25,  -0x1.250c197257b84p-25,  0x1.1e9da4p-18, INEXACT) // -3.411519146583506959115628955591e-08
T(RZ,  -0x1.250c197257b83p-25,  -0x1.250c197257b84p-25,  0x1.1e9da4p-18, INEXACT) // -3.411519146583506959115628955591e-08
T(RN,  -0x1.35b2b3f08966cp-14,  -0x1.35b2b3f5420fdp-14,   -0x1.fffebp-2, INEXACT) // -7.383777097710327681420738876739e-05
T(RN,   -0x1.85c38725c956p-10,  -0x1.85c3908f1a19dp-10,  -0x1.fffecep-2, INEXACT) // -1.486830829386796837265904969172e-03
T(RN,  -0x1.55051607d1a57p-18,  -0x1.55051607d7f33p-18,  -0x1.fffe22p-2, INEXACT) // -5.081592014572083316462005470049e-06
T(RD,    0x1.e170507a097dap-4,    0x1.e28de1403bf11p-4, -0x1.456a6cp-18, INEXACT) // 1.175387519475345199371218996021e-01
T(RU,    0x1.e170507a097dap-4,    0x1.e28de1403bf12p-4,   0x1.ffff5ep-1, INEXACT) // 1.175387519475345199371218996021e-01
T(RZ,    0x1.e170507a097dap-4,    0x1.e28de1403bf11p-4, -0x1.456a6cp-18, INEXACT) // 1.175387519475345199371218996021e-01
T(RD,  -0x1.9837dfefc47b9p-20,  -0x1.9837dfefc5289p-20, -0x1.56d2fep-22, INEXACT) // -1.520731526431509198299071340676e-06
T(RU,  -0x1.9837dfefc47b9p-20,  -0x1.9837dfefc5288p-20,   0x1.fffff6p-1, INEXACT) // -1.520731526431509198299071340676e-06
T(RZ,  -0x1.9837dfefc47b9p-20,  -0x1.9837dfefc5288p-20,   0x1.fffff6p-1, INEXACT) // -1.520731526431509198299071340676e-06
T(RD,   0x1.c67d4031b9d12p-10,   0x1.c67d4f1db2d7fp-10, -0x1.365ef8p-18, INEXACT) // 1.733738940339628071402033882009e-03
T(RU,   0x1.c67d4031b9d12p-10,    0x1.c67d4f1db2d8p-10,   0x1.ffff64p-1, INEXACT) // 1.733738940339628071402033882009e-03
T(RZ,   0x1.c67d4031b9d12p-10,   0x1.c67d4f1db2d7fp-10, -0x1.365ef8p-18, INEXACT) // 1.733738940339628071402033882009e-03
T(RN,   0x1.71375c9cd1dcdp-26,   0x1.71375c9cd1dcep-26,   0x1.ffff9cp-2, INEXACT) // 2.149121468571135583819306264387e-08
T(RN,  -0x1.25dfcd994d053p-13,  -0x1.25dfcda96fcffp-13,  -0x1.fffeccp-2, INEXACT) // -1.401301531501775458812136809783e-04
T(RD,  -0x1.b7ce1e2b9810ep-10,  -0x1.b7ce2bb124304p-10,   -0x1.ffff1p-1, INEXACT) // -1.677723494957264731980428607017e-03
T(RU,  -0x1.b7ce1e2b9810ep-10,  -0x1.b7ce2bb124303p-10,   0x1.df90ap-18, INEXACT) // -1.677723494957264731980428607017e-03
T(RZ,  -0x1.b7ce1e2b9810ep-10,  -0x1.b7ce2bb124303p-10,   0x1.df90ap-18, INEXACT) // -1.677723494957264731980428607017e-03
T(RD,  -0x1.1118fc41cfaa5p-10,  -0x1.1118ff7e99016p-10, -0x1.46e43ep-18, INEXACT) // -1.041784664678560264408635482880e-03
T(RU,  -0x1.1118fc41cfaa5p-10,  -0x1.1118ff7e99015p-10,   0x1.ffff5cp-1, INEXACT) // -1.041784664678560264408635482880e-03
T(RZ,  -0x1.1118fc41cfaa5p-10,  -0x1.1118ff7e99015p-10,   0x1.ffff5cp-1, INEXACT) // -1.041784664678560264408635482880e-03
T(RN,    0x1.36444c4f56f94p-8,    0x1.36449844d61dap-8,    0x1.fffebp-2, INEXACT) // 4.734295492507718111641068503559e-03
T(RD,    0x1.7c3ea0fbc40ap-16,    0x1.7c3ea0fc4fdbp-16, -0x1.10cbd6p-21, INEXACT) // 2.266434692815898297585386345077e-05
T(RU,    0x1.7c3ea0fbc40ap-16,   0x1.7c3ea0fc4fdb1p-16,   0x1.ffffeep-1, INEXACT) // 2.266434692815898297585386345077e-05
T(RZ,    0x1.7c3ea0fbc40ap-16,    0x1.7c3ea0fc4fdbp-16, -0x1.10cbd6p-21, INEXACT) // 2.266434692815898297585386345077e-05
T(RN,  -0x1.de6237424f64ep-13,  -0x1.de623787ea2adp-13,   0x1.fffe48p-2, INEXACT) // -2.281111029080344957363502000902e-04
T(RD,    0x1.2eac05298ac4p-19,    0x1.2eac05298bdep-19,   -0x1.fffffp-1, INEXACT) // 2.255081785992120490050294456807e-06
T(RU,    0x1.2eac05298ac4p-19,   0x1.2eac05298bde1p-19,  0x1.e7eaeap-22, INEXACT) // 2.255081785992120490050294456807e-06
T(RZ,    0x1.2eac05298ac4p-19,    0x1.2eac05298bdep-19,   -0x1.fffffp-1, INEXACT) // 2.255081785992120490050294456807e-06
T(RN,  -0x1.75cab314852a4p-18,  -0x1.75cab3148d776p-18,  -0x1.ffffc6p-2, INEXACT) // -5.569931790923177968933091563919e-06
T(RN,   0x1.8db9b4d067bcep-25,    0x1.8db9b4d067bdp-25,  -0x1.fffe4ap-2, INEXACT) // 4.630133221553995977032416658456e-08
T(RD,   0x1.fb3563e23c157p-18,   0x1.fb3563e250d2ep-18, -0x1.b3a684p-19, INEXACT) // 7.557996442239824572953323794655e-06
T(RU,   0x1.fb3563e23c157p-18,   0x1.fb3563e250d2fp-18,   0x1.ffff94p-1, INEXACT) // 7.557996442239824572953323794655e-06
T(RZ,   0x1.fb3563e23c157p-18,   0x1.fb3563e250d2ep-18, -0x1.b3a684p-19, INEXACT) // 7.557996442239824572953323794655e-06
T(RN,   -0x1.970d98f20ae3dp-2,   -0x1.a29db2eab0e1dp-2,  -0x1.ffff16p-2, INEXACT) // -3.975128076296846058035328042024e-01
T(RD,    0x1.579fd16100f3ep-2,    0x1.5e6c878368bacp-2, -0x1.a8efc4p-18, INEXACT) // 3.355705943542836022785991190176e-01
T(RU,    0x1.579fd16100f3ep-2,    0x1.5e6c878368badp-2,   0x1.ffff2cp-1, INEXACT) // 3.355705943542836022785991190176e-01
T(RZ,    0x1.579fd16100f3ep-2,    0x1.5e6c878368bacp-2, -0x1.a8efc4p-18, INEXACT) // 3.355705943542836022785991190176e-01
T(RN,   0x1.b8b0e0793c0b4p-20,   0x1.b8b0e0793ce4ep-20,  -0x1.fffe18p-2, INEXACT) // 1.641701628248736591104018495146e-06
T(RD,    0x1.1a40fd307af12p-3,    0x1.1b27b5bdeb0d8p-3, -0x1.d7368ap-22, INEXACT) // 1.378192692203517588644956504140e-01
T(RU,    0x1.1a40fd307af12p-3,    0x1.1b27b5bdeb0d9p-3,   0x1.fffff2p-1, INEXACT) // 1.378192692203517588644956504140e-01
T(RZ,    0x1.1a40fd307af12p-3,    0x1.1b27b5bdeb0d8p-3, -0x1.d7368ap-22, INEXACT) // 1.378192692203517588644956504140e-01
T(RD,   0x1.df0a61df02153p-13,   0x1.df0a6224e65c7p-13,   -0x1.ffff1p-1, INEXACT) // 2.284243373369501965610556259989e-04
T(RU,   0x1.df0a61df02153p-13,   0x1.df0a6224e65c8p-13,  0x1.e1db32p-18, INEXACT) // 2.284243373369501965610556259989e-04
T(RZ,   0x1.df0a61df02153p-13,   0x1.df0a6224e65c7p-13,   -0x1.ffff1p-1, INEXACT) // 2.284243373369501965610556259989e-04
T(RD,  -0x1.e312d816d2ad6p-20,  -0x1.e312d816d3cc1p-20, -0x1.248502p-18, INEXACT) // -1.799589431877403720728405764340e-06
T(RU,  -0x1.e312d816d2ad6p-20,   -0x1.e312d816d3ccp-20,   0x1.ffff6ep-1, INEXACT) // -1.799589431877403720728405764340e-06
T(RZ,  -0x1.e312d816d2ad6p-20,   -0x1.e312d816d3ccp-20,   0x1.ffff6ep-1, INEXACT) // -1.799589431877403720728405764340e-06
T(RD,   0x1.f51a708abbcd8p-25,   0x1.f51a708abbcddp-25, -0x1.bd5392p-18, INEXACT) // 5.833609958104116499056040860693e-08
T(RU,   0x1.f51a708abbcd8p-25,   0x1.f51a708abbcdep-25,   0x1.ffff22p-1, INEXACT) // 5.833609958104116499056040860693e-08
T(RZ,   0x1.f51a708abbcd8p-25,   0x1.f51a708abbcddp-25, -0x1.bd5392p-18, INEXACT) // 5.833609958104116499056040860693e-08
T(RD,  -0x1.58868e2cde135p-20,  -0x1.58868e2cde7b5p-20, -0x1.e8693ap-19, INEXACT) // -1.283457901039560186210179877631e-06
T(RU,  -0x1.58868e2cde135p-20,  -0x1.58868e2cde7b4p-20,   0x1.ffff86p-1, INEXACT) // -1.283457901039560186210179877631e-06
T(RZ,  -0x1.58868e2cde135p-20,  -0x1.58868e2cde7b4p-20,   0x1.ffff86p-1, INEXACT) // -1.283457901039560186210179877631e-06
T(RN,    0x1.abfa2dec02673p-1,    0x1.fac18aae2d3d7p-1,   0x1.ffff82p-2, INEXACT) // 8.358930922124286899688172525202e-01
T(RD,    0x1.2584e54835307p-2,    0x1.29b1de9c99941p-2,   -0x1.ffff4p-1, INEXACT) // 2.866397691080213028236300942808e-01
T(RU,    0x1.2584e54835307p-2,    0x1.29b1de9c99942p-2,  0x1.80d5bap-18, INEXACT) // 2.866397691080213028236300942808e-01
T(RZ,    0x1.2584e54835307p-2,    0x1.29b1de9c99941p-2,   -0x1.ffff4p-1, INEXACT) // 2.866397691080213028236300942808e-01
T(RD,  -0x1.f40e9187910abp-22,  -0x1.f40e9187911e9p-22, -0x1.60272ap-18, INEXACT) // -4.657142871104285779708723252285e-07
T(RU,  -0x1.f40e9187910abp-22,  -0x1.f40e9187911e8p-22,    0x1.ffff5p-1, INEXACT) // -4.657142871104285779708723252285e-07
T(RZ,  -0x1.f40e9187910abp-22,  -0x1.f40e9187911e8p-22,    0x1.ffff5p-1, INEXACT) // -4.657142871104285779708723252285e-07
T(RN,   0x1.bcee5f08ee9ecp-25,   0x1.bcee5f08ee9efp-25,   -0x1.fffe5p-2, INEXACT) // 5.179680157654874156888718996633e-08
T(RD,  -0x1.d17c7129275d4p-13,  -0x1.d17c7169476cep-13, -0x1.265d54p-19, INEXACT) // -2.219610699158285635826381998470e-04
T(RU,  -0x1.d17c7129275d4p-13,  -0x1.d17c7169476cdp-13,   0x1.ffffb6p-1, INEXACT) // -2.219610699158285635826381998470e-04
T(RZ,  -0x1.d17c7129275d4p-13,  -0x1.d17c7169476cdp-13,   0x1.ffffb6p-1, INEXACT) // -2.219610699158285635826381998470e-04
T(RN,   0x1.720792f508c1fp-17,   0x1.720792f528f84p-17,   0x1.ffff02p-2, INEXACT) // 1.102774101908147708322582153384e-05
T(RN,   -0x1.00899c6bcc7efp-8,   -0x1.0089c75b7dc9ap-8,  -0x1.ffff9cp-2, INEXACT) // -3.914452255957086811155587469102e-03
T(RN,   0x1.e65e53bb064eep-20,   0x1.e65e53bb07737p-20,  -0x1.ffffa2p-2, INEXACT) // 1.811863724615534695813702167899e-06
T(RN,   0x1.bf3b4f21d95a9p-19,   0x1.bf3b4f21dce88p-19,  -0x1.fffe8ep-2, INEXACT) // 3.332135649114071062763852218436e-06
T(RN,    0x1.7c395894cd6ap-12,   0x1.7c3959209896cp-12,  -0x1.fffff6p-2, INEXACT) // 3.626098708083645011379658740225e-04
T(RN,  -0x1.633b60ccced49p-23,  -0x1.633b60ccced66p-23,  -0x1.ffffccp-2, INEXACT) // -1.654177651746449858136150294977e-07
T(RN,   0x1.060c0fa7ade44p-17,   0x1.060c0fa7b9551p-17,   0x1.fffff4p-2, INEXACT) // 7.809612568506565943599745382997e-06
T(RN,   0x1.364d356fa5e41p-14,   0x1.364d357465a1ap-14,   0x1.ffff58p-2, INEXACT) // 7.398166575922020921866201215167e-05
T(RD,   -0x1.c3125b443bd61p-9,   -0x1.c312959e1368fp-9,  -0x1.ffff28p-1, INEXACT) // -3.441404000220125037473595241977e-03
T(RU,   -0x1.c3125b443bd61p-9,   -0x1.c312959e1368ep-9,  0x1.b12722p-18, INEXACT) // -3.441404000220125037473595241977e-03
T(RZ,   -0x1.c3125b443bd61p-9,   -0x1.c312959e1368ep-9,  0x1.b12722p-18, INEXACT) // -3.441404000220125037473595241977e-03
T(RN,   -0x1.945661e3d7082p-9,   -0x1.94568beb1a2edp-9,   -0x1.ffffdp-2, INEXACT) // -3.084849786246180759763380052618e-03
T(RD,  -0x1.3b2c3aaf468afp-11,  -0x1.3b2c3bedc0118p-11,  -0x1.ffff66p-1, INEXACT) // -6.011443528308925031075626854715e-04
T(RU,  -0x1.3b2c3aaf468afp-11,  -0x1.3b2c3bedc0117p-11,   0x1.333fep-18, INEXACT) // -6.011443528308925031075626854715e-04
T(RZ,  -0x1.3b2c3aaf468afp-11,  -0x1.3b2c3bedc0117p-11,   0x1.333fep-18, INEXACT) // -6.011443528308925031075626854715e-04
T(RD,   0x1.55e25c21a0a66p-11,    0x1.55e25db821f8p-11,  -0x1.ffffd4p-1, INEXACT) // 6.520923963793778376646370631420e-04
T(RU,   0x1.55e25c21a0a66p-11,   0x1.55e25db821f81p-11,  0x1.5fd4c2p-20, INEXACT) // 6.520923963793778376646370631420e-04
T(RZ,   0x1.55e25c21a0a66p-11,    0x1.55e25db821f8p-11,  -0x1.ffffd4p-1, INEXACT) // 6.520923963793778376646370631420e-04
T(RN,    0x1.6a5b6ba27f6bbp-2,    0x1.726160b7ef784p-2,  -0x1.ffff32p-2, INEXACT) // 3.538643663340327871758006494929e-01
T(RD,    0x1.b6dae44bf39ccp-1,    0x1.0799b03f9091dp+0,  -0x1.705c2p-19, INEXACT) // 8.571387617792480817513478541514e-01
T(RU,    0x1.b6dae44bf39ccp-1,    0x1.0799b03f9091ep+0,   0x1.ffffa4p-1, INEXACT) // 8.571387617792480817513478541514e-01
T(RZ,    0x1.b6dae44bf39ccp-1,    0x1.0799b03f9091dp+0,  -0x1.705c2p-19, INEXACT) // 8.571387617792480817513478541514e-01
T(RD,  -0x1.9b0018708bb03p-16,  -0x1.9b0018713c3ffp-16,  -0x1.ffff3ap-1, INEXACT) // -2.449753123040088509973326302838e-05
T(RU,  -0x1.9b0018708bb03p-16,  -0x1.9b0018713c3fep-16,  0x1.8a28c8p-18, INEXACT) // -2.449753123040088509973326302838e-05
T(RZ,  -0x1.9b0018708bb03p-16,  -0x1.9b0018713c3fep-16,  0x1.8a28c8p-18, INEXACT) // -2.449753123040088509973326302838e-05
T(RN,   0x1.6eae8ced22f57p-12,   0x1.6eae8d6a84e33p-12,   0x1.ffff16p-2, INEXACT) // 3.496950510644045140816460470745e-04
T(RD,  -0x1.dafe7c6b18045p-17,  -0x1.dafe7c6b5c271p-17,   -0x1.ffff2p-1, INEXACT) // -1.415592688241996164948913877746e-05
T(RU,  -0x1.dafe7c6b18045p-17,   -0x1.dafe7c6b5c27p-17,  0x1.c0d536p-18, INEXACT) // -1.415592688241996164948913877746e-05
T(RZ,  -0x1.dafe7c6b18045p-17,   -0x1.dafe7c6b5c27p-17,  0x1.c0d536p-18, INEXACT) // -1.415592688241996164948913877746e-05
T(RD,    0x1.16cdd014fa70fp-9,    0x1.16cddddc4fb72p-9, -0x1.75f172p-19, INEXACT) // 2.127105379703737430413523767925e-03
T(RU,    0x1.16cdd014fa70fp-9,    0x1.16cddddc4fb73p-9,   0x1.ffffa2p-1, INEXACT) // 2.127105379703737430413523767925e-03
T(RZ,    0x1.16cdd014fa70fp-9,    0x1.16cddddc4fb72p-9, -0x1.75f172p-19, INEXACT) // 2.127105379703737430413523767925e-03
T(RD,  -0x1.ac18d98befcc5p-11,  -0x1.ac18dcaa08a4ap-11,  -0x1.ffff72p-1, INEXACT) // -8.165303602182474732376626924690e-04
T(RU,  -0x1.ac18d98befcc5p-11,  -0x1.ac18dcaa08a49p-11,   0x1.1c271p-18, INEXACT) // -8.165303602182474732376626924690e-04
T(RZ,  -0x1.ac18d98befcc5p-11,  -0x1.ac18dcaa08a49p-11,   0x1.1c271p-18, INEXACT) // -8.165303602182474732376626924690e-04
T(RN,   0x1.879c0ec1f4f62p-16,   0x1.879c0ec28db16p-16,  -0x1.ffff1cp-2, INEXACT) // 2.334175110958682555469326236341e-05
T(RD,  -0x1.827f634a31373p-19,  -0x1.827f634a33829p-19,  -0x1.ffff94p-1, INEXACT) // -2.879631584825514220869540835124e-06
T(RU,  -0x1.827f634a31373p-19,  -0x1.827f634a33828p-19,  0x1.b29c06p-19, INEXACT) // -2.879631584825514220869540835124e-06
T(RZ,  -0x1.827f634a31373p-19,  -0x1.827f634a33828p-19,  0x1.b29c06p-19, INEXACT) // -2.879631584825514220869540835124e-06
T(RD,    0x1.21643ae452a61p-8,    0x1.21647886faa42p-8,  -0x1.ffff52p-1, INEXACT) // 4.415764215375790092965591071561e-03
T(RU,    0x1.21643ae452a61p-8,    0x1.21647886faa43p-8,  0x1.5da0cap-18, INEXACT) // 4.415764215375790092965591071561e-03
T(RZ,    0x1.21643ae452a61p-8,    0x1.21647886faa42p-8,  -0x1.ffff52p-1, INEXACT) // 4.415764215375790092965591071561e-03
T(RD,  -0x1.3d43707b0a68ap-16,  -0x1.3d43707b5b9f6p-16,  -0x1.ffff1ep-1, INEXACT) // -1.891037434745846806125393890774e-05
T(RU,  -0x1.3d43707b0a68ap-16,  -0x1.3d43707b5b9f5p-16,  0x1.c51956p-18, INEXACT) // -1.891037434745846806125393890774e-05
T(RZ,  -0x1.3d43707b0a68ap-16,  -0x1.3d43707b5b9f5p-16,  0x1.c51956p-18, INEXACT) // -1.891037434745846806125393890774e-05
T(RN,  -0x1.15c3931a46facp-22,  -0x1.15c3931a46fe3p-22,  -0x1.ffff6ap-2, INEXACT) // -2.586878494901947234872697720109e-07
T(RD,   -0x1.63d989949138dp-9,   -0x1.63d9a63ab99d6p-9, -0x1.ff3702p-18, INEXACT) // -2.714918179011544061701721730628e-03
T(RU,   -0x1.63d989949138dp-9,   -0x1.63d9a63ab99d5p-9,     0x1.ffffp-1, INEXACT) // -2.714918179011544061701721730628e-03
T(RZ,   -0x1.63d989949138dp-9,   -0x1.63d9a63ab99d5p-9,     0x1.ffffp-1, INEXACT) // -2.714918179011544061701721730628e-03
T(RD,  -0x1.ca169ab4080b6p-18,  -0x1.ca169ab41752dp-18, -0x1.29cca2p-18, INEXACT) // -6.826047570768366384830715121179e-06
T(RU,  -0x1.ca169ab4080b6p-18,  -0x1.ca169ab41752cp-18,   0x1.ffff6cp-1, INEXACT) // -6.826047570768366384830715121179e-06
T(RZ,  -0x1.ca169ab4080b6p-18,  -0x1.ca169ab41752cp-18,   0x1.ffff6cp-1, INEXACT) // -6.826047570768366384830715121179e-06
T(RN,  -0x1.b791fa7f5920ep-24,  -0x1.b791fa7f5921bp-24,   0x1.ffff04p-2, INEXACT) // -1.023454192415362546216055185042e-07
T(RN,  -0x1.bd0fde0ac2caep-18,   -0x1.bd0fde0ad0cep-18,   0x1.fffef4p-2, INEXACT) // -6.631940332689463814502643657089e-06
T(RD,   0x1.09f21045dfadap-11,   0x1.09f2110536de3p-11, -0x1.e445e2p-18, INEXACT) // 5.072509018047802620970943010548e-04
T(RU,   0x1.09f21045dfadap-11,   0x1.09f2110536de4p-11,   0x1.ffff0ep-1, INEXACT) // 5.072509018047802620970943010548e-04
T(RZ,   0x1.09f21045dfadap-11,   0x1.09f2110536de3p-11, -0x1.e445e2p-18, INEXACT) // 5.072509018047802620970943010548e-04
T(RN,  -0x1.4f748f6acb169p-25,  -0x1.4f748f6acb16bp-25,  -0x1.fffe8ap-2, INEXACT) // -3.905213826478149565255159236972e-08
T(RN,   0x1.1f8e0bd809535p-20,   0x1.1f8e0bd8098fdp-20,    0x1.ffff3p-2, INEXACT) // 1.071225360868328090960537209153e-06
T(RN,   0x1.1bca66a61ab2fp-21,   0x1.1bca66a61ac18p-21,   0x1.ffff72p-2, INEXACT) // 5.286012381260688363724255071918e-07
T(RN,     0x1.35162819e5ffp-3,    0x1.3645a8135c6c3p-3,  -0x1.ffff38p-2, INEXACT) // 1.509211666968890419582294271095e-01
T(RN,   -0x1.18e0077402419p-1,   -0x1.294d9289179d1p-1,   -0x1.fffebp-2, INEXACT) // -5.485842064964600028886820837215e-01
T(RD,   0x1.7ffffca47dadap-24,   0x1.7ffffca47dae2p-24,  -0x1.ffff88p-1, INEXACT) // 8.940695523500145288146835013260e-08
T(RU,   0x1.7ffffca47dadap-24,   0x1.7ffffca47dae3p-24,  0x1.e3794ap-19, INEXACT) // 8.940695523500145288146835013260e-08
T(RZ,   0x1.7ffffca47dadap-24,   0x1.7ffffca47dae2p-24,  -0x1.ffff88p-1, INEXACT) // 8.940695523500145288146835013260e-08
T(RN,   -0x1.de19a38a684cfp-9,   -0x1.de19e905a0364p-9,   0x1.ffff4cp-2, INEXACT) // -3.647614682635059567966662186222e-03
T(RN,   0x1.713781552f812p-26,   0x1.713781552f813p-26,   0x1.ffff04p-2, INEXACT) // 2.149124729978178785900244413161e-08
T(RN,  -0x1.71370eef0b5fbp-26,  -0x1.71370eef0b5fbp-26,    0x1.ffff2p-2, INEXACT) // -2.149114569306869180132796976184e-08
T(RD,  -0x1.83f583ab1ff97p-21,  -0x1.83f583ab201e9p-21, -0x1.f5fb4cp-18, INEXACT) // -7.226300246104710849555960265611e-07
T(RU,  -0x1.83f583ab1ff97p-21,  -0x1.83f583ab201e8p-21,   0x1.ffff06p-1, INEXACT) // -7.226300246104710849555960265611e-07
T(RZ,  -0x1.83f583ab1ff97p-21,  -0x1.83f583ab201e8p-21,   0x1.ffff06p-1, INEXACT) // -7.226300246104710849555960265611e-07
T(RN,   0x1.e9730d4f57579p-18,   0x1.e9730d4f69faap-18,   0x1.fffffep-2, INEXACT) // 7.293364731123457154386788975353e-06
T(RD,   0x1.a6a5a3518ed43p-25,   0x1.a6a5a3518ed46p-25, -0x1.df59fcp-18, INEXACT) // 4.920258923594937067391846276763e-08
T(RU,   0x1.a6a5a3518ed43p-25,   0x1.a6a5a3518ed47p-25,    0x1.ffff1p-1, INEXACT) // 4.920258923594937067391846276763e-08
T(RZ,   0x1.a6a5a3518ed43p-25,   0x1.a6a5a3518ed46p-25, -0x1.df59fcp-18, INEXACT) // 4.920258923594937067391846276763e-08
T(RN,   0x1.df84ff32c616ep-20,   0x1.df84ff32c72f4p-20,  -0x1.fffeacp-2, INEXACT) // 1.786349412119256140307711408499e-06
T(RD,  -0x1.51f87c2934b31p-12,   -0x1.51f87c8b61c8p-12, -0x1.9d911ep-20, INEXACT) // -3.223139234026949268875628096254e-04
T(RU,  -0x1.51f87c2934b31p-12,  -0x1.51f87c8b61c7fp-12,   0x1.ffffccp-1, INEXACT) // -3.223139234026949268875628096254e-04
T(RZ,  -0x1.51f87c2934b31p-12,  -0x1.51f87c8b61c7fp-12,   0x1.ffffccp-1, INEXACT) // -3.223139234026949268875628096254e-04
T(RN,    0x1.b8717a181e826p-4,    0x1.b94be7a69313bp-4,   0x1.fffe14p-2, INEXACT) // 1.075300950341505357155114097623e-01
T(RN,  -0x1.a81bef8f8a452p-23,  -0x1.a81bef8f8a482p-23,   0x1.fffe24p-2, INEXACT) // -1.974912007135542286682657140556e-07
T(RD,   -0x1.691f5312180ep-15,   -0x1.691f5313f71ep-15,  -0x1.ffff34p-1, INEXACT) // -4.304914013242440960771428848375e-05
T(RU,   -0x1.691f5312180ep-15,  -0x1.691f5313f71dfp-15,  0x1.989336p-18, INEXACT) // -4.304914013242440960771428848375e-05
T(RZ,   -0x1.691f5312180ep-15,  -0x1.691f5313f71dfp-15,  0x1.989336p-18, INEXACT) // -4.304914013242440960771428848375e-05
T(RD,   -0x1.71796a57bacd6p-3,   -0x1.7382278e9d423p-3, -0x1.650956p-20, INEXACT) // -1.804073627493837927993070024968e-01
T(RU,   -0x1.71796a57bacd6p-3,   -0x1.7382278e9d422p-3,   0x1.ffffd4p-1, INEXACT) // -1.804073627493837927993070024968e-01
T(RZ,   -0x1.71796a57bacd6p-3,   -0x1.7382278e9d422p-3,   0x1.ffffd4p-1, INEXACT) // -1.804073627493837927993070024968e-01
T(RD,   0x1.c770bc3aa3a64p-21,   0x1.c770bc3aa3e24p-21,  -0x1.ffffe8p-1, INEXACT) // 8.483237999445120718002445042716e-07
T(RU,   0x1.c770bc3aa3a64p-21,   0x1.c770bc3aa3e25p-21,  0x1.8854f2p-21, INEXACT) // 8.483237999445120718002445042716e-07
T(RZ,   0x1.c770bc3aa3a64p-21,   0x1.c770bc3aa3e24p-21,  -0x1.ffffe8p-1, INEXACT) // 8.483237999445120718002445042716e-07
T(RD,  -0x1.f51a5a318d725p-25,  -0x1.f51a5a318d72ap-25, -0x1.df6888p-19, INEXACT) // -5.833605988237265338683881104632e-08
T(RU,  -0x1.f51a5a318d725p-25,  -0x1.f51a5a318d729p-25,   0x1.ffff88p-1, INEXACT) // -5.833605988237265338683881104632e-08
T(RZ,  -0x1.f51a5a318d725p-25,  -0x1.f51a5a318d729p-25,   0x1.ffff88p-1, INEXACT) // -5.833605988237265338683881104632e-08
T(RN,  -0x1.8c0fc49505177p-23,  -0x1.8c0fc4950519ep-23,   0x1.fffe2ap-2, INEXACT) // -1.844305514148128177195532602026e-07
T(RN,    0x1.f47cc8b8ef559p-1,    0x1.5bbbbcd0338bap+0,    -0x1.ffffp-2, INEXACT) // 9.775145269156083616124419677362e-01
T(RD,  -0x1.aa1a8c3ba9074p-21,  -0x1.aa1a8c3ba9388p-21,  -0x1.ffffc4p-1, INEXACT) // -7.936799941332969150732060820141e-07
T(RU,  -0x1.aa1a8c3ba9074p-21,  -0x1.aa1a8c3ba9387p-21,  0x1.d97a1ap-20, INEXACT) // -7.936799941332969150732060820141e-07
T(RZ,  -0x1.aa1a8c3ba9074p-21,  -0x1.aa1a8c3ba9387p-21,  0x1.d97a1ap-20, INEXACT) // -7.936799941332969150732060820141e-07
T(RD,   0x1.a2378a44aa7ffp-12,   0x1.a2378afeb12adp-12, -0x1.c6bacep-20, INEXACT) // 3.988427672917404533635410412984e-04
T(RU,   0x1.a2378a44aa7ffp-12,   0x1.a2378afeb12aep-12,   0x1.ffffc8p-1, INEXACT) // 3.988427672917404533635410412984e-04
T(RZ,   0x1.a2378a44aa7ffp-12,   0x1.a2378afeb12adp-12, -0x1.c6bacep-20, INEXACT) // 3.988427672917404533635410412984e-04
T(RD,   0x1.95618574dfaa8p-14,   0x1.9561857f76597p-14, -0x1.bd8b56p-19, INEXACT) // 9.665034833792696209592287814871e-05
T(RU,   0x1.95618574dfaa8p-14,   0x1.9561857f76598p-14,    0x1.ffff9p-1, INEXACT) // 9.665034833792696209592287814871e-05
T(RZ,   0x1.95618574dfaa8p-14,   0x1.9561857f76597p-14, -0x1.bd8b56p-19, INEXACT) // 9.665034833792696209592287814871e-05
T(RD,  -0x1.dd940867c37bap-15,  -0x1.dd94086c178a8p-15,  -0x1.ffff64p-1, INEXACT) // -5.693176427544418855431623827101e-05
T(RU,  -0x1.dd940867c37bap-15,  -0x1.dd94086c178a7p-15,  0x1.37ce7ap-18, INEXACT) // -5.693176427544418855431623827101e-05
T(RZ,  -0x1.dd940867c37bap-15,  -0x1.dd94086c178a7p-15,  0x1.37ce7ap-18, INEXACT) // -5.693176427544418855431623827101e-05
T(RN,   -0x1.3c7ed67d26c7ep-6,   -0x1.3c83e0b5cb6c1p-6,   0x1.fffe8ep-2, INEXACT) // -1.931734987429622324439648650696e-02
T(RN,   0x1.8865c6c79b0f5p-15,   0x1.8865c6ca01ae7p-15,    0x1.ffff2p-2, INEXACT) // 4.677743487211005231221974676181e-05
T(RN,  -0x1.22cde11c90fc9p-14,  -0x1.22cde12079a81p-14,   0x1.ffffcap-2, INEXACT) // -6.933312801843319729631215375676e-05
T(RD,    0x1.ee1d656195fd9p-8,    0x1.ee1e982fe008fp-8, -0x1.6b0ec8p-18, INEXACT) // 7.539593936222354665643852200674e-03
T(RU,    0x1.ee1d656195fd9p-8,     0x1.ee1e982fe009p-8,   0x1.ffff4ap-1, INEXACT) // 7.539593936222354665643852200674e-03
T(RZ,    0x1.ee1d656195fd9p-8,    0x1.ee1e982fe008fp-8, -0x1.6b0ec8p-18, INEXACT) // 7.539593936222354665643852200674e-03
T(RD,  -0x1.65c16506e1a2cp-12,  -0x1.65c1657b54052p-12, -0x1.00dcf8p-19, INEXACT) // -3.411821821192341768619327169176e-04
T(RU,  -0x1.65c16506e1a2cp-12,  -0x1.65c1657b54051p-12,    0x1.ffffcp-1, INEXACT) // -3.411821821192341768619327169176e-04
T(RZ,  -0x1.65c16506e1a2cp-12,  -0x1.65c1657b54051p-12,    0x1.ffffcp-1, INEXACT) // -3.411821821192341768619327169176e-04
T(RN,    0x1.826672fd504adp-5,    0x1.828b2a4c91d82p-5,   0x1.ffffd2p-2, INEXACT) // 4.716799219978305007794361358719e-02
T(RN,    -0x1.2f11b5606adfp-4,   -0x1.2f58ad56864fcp-4,  -0x1.fffe88p-2, INEXACT) // -7.399149751898170812580701749539e-02
T(RD,  -0x1.a3aac43db8ff2p-10,  -0x1.a3aacffd35fd9p-10,  -0x1.fffff6p-1, INEXACT) // -1.600902774435472315089912243025e-03
T(RU,  -0x1.a3aac43db8ff2p-10,  -0x1.a3aacffd35fd8p-10,  0x1.36bef4p-22, INEXACT) // -1.600902774435472315089912243025e-03
T(RZ,  -0x1.a3aac43db8ff2p-10,  -0x1.a3aacffd35fd8p-10,  0x1.36bef4p-22, INEXACT) // -1.600902774435472315089912243025e-03
T(RN,   0x1.cc8489d1b507cp-21,   0x1.cc8489d1b545dp-21,   -0x1.ffff5p-2, INEXACT) // 8.577811121076749929076615125423e-07
T(RD,  -0x1.62d2ac77d05f4p-16,  -0x1.62d2ac7841faap-16,  -0x1.ffff2ep-1, INEXACT) // -2.114909554440896996985871370001e-05
T(RU,  -0x1.62d2ac77d05f4p-16,  -0x1.62d2ac7841fa9p-16,  0x1.a39beep-18, INEXACT) // -2.114909554440896996985871370001e-05
T(RZ,  -0x1.62d2ac77d05f4p-16,  -0x1.62d2ac7841fa9p-16,  0x1.a39beep-18, INEXACT) // -2.114909554440896996985871370001e-05
T(RN,    0x1.15a646e0f9534p-9,    0x1.15a6547cabe7ap-9,   0x1.ffff94p-2, INEXACT) // 2.118297722051432421808137007702e-03
T(RD,   -0x1.17ce888b24274p-4,   -0x1.18065cacf1fbfp-4,   -0x1.ffffap-1, INEXACT) // -6.831219994843157339303729713720e-02
T(RU,   -0x1.17ce888b24274p-4,   -0x1.18065cacf1fbep-4,  0x1.7d1238p-19, INEXACT) // -6.831219994843157339303729713720e-02
T(RZ,   -0x1.17ce888b24274p-4,   -0x1.18065cacf1fbep-4,  0x1.7d1238p-19, INEXACT) // -6.831219994843157339303729713720e-02
T(RN,   0x1.182836c27cdc1p-10,   0x1.18283a4138b84p-10,   0x1.fffe72p-2, INEXACT) // 1.068714468257833888689689594287e-03
T(RD,    -0x1.cc4db32f51e7p-2,   -0x1.dd696d8139a63p-2,  -0x1.ffff2cp-1, INEXACT) // -4.495151517516893235892894153949e-01
T(RU,    -0x1.cc4db32f51e7p-2,   -0x1.dd696d8139a62p-2,  0x1.a981d6p-18, INEXACT) // -4.495151517516893235892894153949e-01
T(RZ,    -0x1.cc4db32f51e7p-2,   -0x1.dd696d8139a62p-2,  0x1.a981d6p-18, INEXACT) // -4.495151517516893235892894153949e-01
T(RD,   0x1.6de4a6e2d9d0bp-12,    0x1.6de4a75f6d14p-12,  -0x1.ffff0cp-1, INEXACT) // 3.489429201892358246676895117133e-04
T(RU,   0x1.6de4a6e2d9d0bp-12,   0x1.6de4a75f6d141p-12,   0x1.e66bep-18, INEXACT) // 3.489429201892358246676895117133e-04
T(RZ,   0x1.6de4a6e2d9d0bp-12,    0x1.6de4a75f6d14p-12,  -0x1.ffff0cp-1, INEXACT) // 3.489429201892358246676895117133e-04
T(RN,  -0x1.7a5ca314fa1e2p-10,  -0x1.7a5cabb0f9b59p-10,   0x1.ffff98p-2, INEXACT) // -1.443335965854435510441478029975e-03
T(RN,   -0x1.f3c6cfa3a53f3p-2,   -0x1.050d938cd893bp-1,  -0x1.fffffap-2, INEXACT) // -4.880630916243823835820592194068e-01
T(RN,  -0x1.998e88e097105p-12,  -0x1.998e898f4c25cp-12,  -0x1.ffff46p-2, INEXACT) // -3.905837784594776086917466972892e-04
T(RD,  -0x1.5dc6d0860c123p-19,  -0x1.5dc6d0860dc58p-19,  -0x1.84a42p-19, INEXACT) // -2.606038893147989429988553231055e-06
T(RU,  -0x1.5dc6d0860c123p-19,  -0x1.5dc6d0860dc57p-19,   0x1.ffff9ep-1, INEXACT) // -2.606038893147989429988553231055e-06
T(RZ,  -0x1.5dc6d0860c123p-19,  -0x1.5dc6d0860dc57p-19,   0x1.ffff9ep-1, INEXACT) // -2.606038893147989429988553231055e-06
T(RN,   -0x1.3866ae76ca211p-5,   -0x1.387a140db7ae9p-5,  -0x1.ffff5cp-2, INEXACT) // -3.813489985470053938998447051745e-02
T(RD,  -0x1.01a7eb3a4c067p-20,   -0x1.01a7eb3a4c32p-20,  -0x1.ffff1cp-1, INEXACT) // -9.598431476958098570350296982467e-07
T(RU,  -0x1.01a7eb3a4c067p-20,  -0x1.01a7eb3a4c31fp-20,  0x1.c9d572p-18, INEXACT) // -9.598431476958098570350296982467e-07
T(RZ,  -0x1.01a7eb3a4c067p-20,  -0x1.01a7eb3a4c31fp-20,  0x1.c9d572p-18, INEXACT) // -9.598431476958098570350296982467e-07
T(RN,    0x1.d6605719286f6p-1,    0x1.2a2f6738e24e6p+0,  -0x1.fffe96p-2, INEXACT) // 9.187037676058185109440046289819e-01
T(RN,   -0x1.528eb4b0f7db7p-4,   -0x1.52f1b2e66982fp-4,  -0x1.ffff26p-2, INEXACT) // -8.265562613040954020870998419923e-02
T(RD,   0x1.a6a5832cd709dp-25,   0x1.a6a5832cd709fp-25,  -0x1.ffff92p-1, INEXACT) // 4.920253213774867709953461506790e-08
T(RU,   0x1.a6a5832cd709dp-25,    0x1.a6a5832cd70ap-25,   0x1.bb19fp-19, INEXACT) // 4.920253213774867709953461506790e-08
T(RZ,   0x1.a6a5832cd709dp-25,   0x1.a6a5832cd709fp-25,  -0x1.ffff92p-1, INEXACT) // 4.920253213774867709953461506790e-08
T(RD,    0x1.5cd723aa57387p-7,    0x1.5cd8d383833f5p-7, -0x1.8cff02p-20, INEXACT) // 1.064576379274641097782971854713e-02
T(RU,    0x1.5cd723aa57387p-7,    0x1.5cd8d383833f6p-7,   0x1.ffffcep-1, INEXACT) // 1.064576379274641097782971854713e-02
T(RZ,    0x1.5cd723aa57387p-7,    0x1.5cd8d383833f5p-7, -0x1.8cff02p-20, INEXACT) // 1.064576379274641097782971854713e-02
T(RD,    0x1.609709bb626aap-3,    0x1.625afe6f24ef2p-3, -0x1.61e79ap-19, INEXACT) // 1.721630821523850163323743345245e-01
T(RU,    0x1.609709bb626aap-3,    0x1.625afe6f24ef3p-3,   0x1.ffffa8p-1, INEXACT) // 1.721630821523850163323743345245e-01
T(RZ,    0x1.609709bb626aap-3,    0x1.625afe6f24ef2p-3, -0x1.61e79ap-19, INEXACT) // 1.721630821523850163323743345245e-01
T(RN,  -0x1.3253d536b227ap-19,  -0x1.3253d536b34c1p-19,  -0x1.ffff16p-2, INEXACT) // -2.282317520172901627935769380828e-06
T(RN,   0x1.a70c5b6bd7df7p-14,   0x1.a70c5b77e0a35p-14,   0x1.fffe74p-2, INEXACT) // 1.008625674194725709139838776274e-04
T(RD,    -0x1.3d3706f00c0dp-5,   -0x1.3d4b55bc4dfecp-5,  -0x1.ffffa8p-1, INEXACT) // -3.872252802864439846786126508960e-02
T(RU,    -0x1.3d3706f00c0dp-5,   -0x1.3d4b55bc4dfebp-5,  0x1.5cafd6p-19, INEXACT) // -3.872252802864439846786126508960e-02
T(RZ,    -0x1.3d3706f00c0dp-5,   -0x1.3d4b55bc4dfebp-5,  0x1.5cafd6p-19, INEXACT) // -3.872252802864439846786126508960e-02
T(RD,  -0x1.d12ea7944d375p-26,  -0x1.d12ea7944d376p-26, -0x1.0f72f4p-18, INEXACT) // -2.707717035415344465552202172804e-08
T(RU,  -0x1.d12ea7944d375p-26,  -0x1.d12ea7944d375p-26,   0x1.ffff78p-1, INEXACT) // -2.707717035415344465552202172804e-08
T(RZ,  -0x1.d12ea7944d375p-26,  -0x1.d12ea7944d375p-26,   0x1.ffff78p-1, INEXACT) // -2.707717035415344465552202172804e-08
T(RD,  -0x1.7adcb3bffeb26p-19,  -0x1.7adcb3c000db9p-19, -0x1.02268ep-19, INEXACT) // -2.822742743544508175590045800929e-06
T(RU,  -0x1.7adcb3bffeb26p-19,  -0x1.7adcb3c000db8p-19,    0x1.ffffcp-1, INEXACT) // -2.822742743544508175590045800929e-06
T(RZ,  -0x1.7adcb3bffeb26p-19,  -0x1.7adcb3c000db8p-19,    0x1.ffffcp-1, INEXACT) // -2.822742743544508175590045800929e-06
T(RD,   0x1.61246d6440c46p-22,   0x1.61246d6440cb5p-22,  -0x1.fffff4p-1, INEXACT) // 3.288893906246424217289041867784e-07
T(RU,   0x1.61246d6440c46p-22,   0x1.61246d6440cb6p-22,  0x1.91ba2cp-22, INEXACT) // 3.288893906246424217289041867784e-07
T(RZ,   0x1.61246d6440c46p-22,   0x1.61246d6440cb5p-22,  -0x1.fffff4p-1, INEXACT) // 3.288893906246424217289041867784e-07
T(RN,   0x1.addc47b727f09p-23,   0x1.addc47b727f3bp-23,  -0x1.ffff3cp-2, INEXACT) // 2.001693794927432280118486567291e-07
T(RD,    0x1.d2a4b8e16200dp-6,    0x1.d2b4e117ea2a4p-6,  -0x1.ffff12p-1, INEXACT) // 2.848165564276432595858246088483e-02
T(RU,    0x1.d2a4b8e16200dp-6,    0x1.d2b4e117ea2a5p-6,  0x1.dc7bc2p-18, INEXACT) // 2.848165564276432595858246088483e-02
T(RZ,    0x1.d2a4b8e16200dp-6,    0x1.d2b4e117ea2a4p-6,  -0x1.ffff12p-1, INEXACT) // 2.848165564276432595858246088483e-02
T(RN,   0x1.8db9e23d7afa6p-25,   0x1.8db9e23d7afa9p-25,   0x1.fffe48p-2, INEXACT) // 4.630141290845867590519560228965e-08
T(RD,   -0x1.aa10c29ab3013p-5,    -0x1.aa41fe904254p-5,   -0x1.c229p-20, INEXACT) // -5.200994499827529121693814317950e-02
T(RU,   -0x1.aa10c29ab3013p-5,   -0x1.aa41fe904253fp-5,   0x1.ffffc8p-1, INEXACT) // -5.200994499827529121693814317950e-02
T(RZ,   -0x1.aa10c29ab3013p-5,   -0x1.aa41fe904253fp-5,   0x1.ffffc8p-1, INEXACT) // -5.200994499827529121693814317950e-02
T(RD,  -0x1.a2a576da003d8p-16,  -0x1.a2a576dabad71p-16,  -0x1.ffffd4p-1, INEXACT) // -2.495326666718589484449120075027e-05
T(RU,  -0x1.a2a576da003d8p-16,   -0x1.a2a576dabad7p-16,  0x1.66a7a6p-20, INEXACT) // -2.495326666718589484449120075027e-05
T(RZ,  -0x1.a2a576da003d8p-16,   -0x1.a2a576dabad7p-16,  0x1.66a7a6p-20, INEXACT) // -2.495326666718589484449120075027e-05
T(RD,   -0x1.c01159b07284bp-7,   -0x1.c014ecd91d1fdp-7,  -0x1.47276p-18, INEXACT) // -1.367394332273277023082069803195e-02
T(RU,   -0x1.c01159b07284bp-7,   -0x1.c014ecd91d1fcp-7,   0x1.ffff5cp-1, INEXACT) // -1.367394332273277023082069803195e-02
T(RZ,   -0x1.c01159b07284bp-7,   -0x1.c014ecd91d1fcp-7,   0x1.ffff5cp-1, INEXACT) // -1.367394332273277023082069803195e-02
T(RN,  -0x1.e1723ed44a0fdp-12,  -0x1.e1723ff016da8p-12,   0x1.ffff5ep-2, INEXACT) // -4.591429435714248813611704225224e-04
T(RN,   -0x1.dcbaa45297e26p-5,   -0x1.dcffa1c60bdaep-5,  -0x1.fffeacp-2, INEXACT) // -5.819446653617559028770500617611e-02
T(RN,    0x1.33c8574201a11p-8,      0x1.33c8a16825ep-8,   0x1.fffe3ap-2, INEXACT) // 4.696389487441014233548575163013e-03
T(RN,   0x1.3844b2bee4595p-14,   0x1.3844b2c3bb5a5p-14,  -0x1.fffe6ap-2, INEXACT) // 7.445057688772731979438140870187e-05
T(RD,   0x1.9fe4a791188d5p-14,   0x1.9fe4a79c87a11p-14,  -0x1.ffff58p-1, INEXACT) // 9.915666147855839451536602568993e-05
T(RU,   0x1.9fe4a791188d5p-14,   0x1.9fe4a79c87a12p-14,  0x1.517c32p-18, INEXACT) // 9.915666147855839451536602568993e-05
T(RZ,   0x1.9fe4a791188d5p-14,   0x1.9fe4a79c87a11p-14,  -0x1.ffff58p-1, INEXACT) // 9.915666147855839451536602568993e-05
T(RD,   0x1.6c18ee614b9a5p-21,    0x1.6c18ee614bb9p-21, -0x1.ce3992p-18, INEXACT) // 6.781842324716040173323791141746e-07
T(RU,   0x1.6c18ee614b9a5p-21,   0x1.6c18ee614bb91p-21,   0x1.ffff18p-1, INEXACT) // 6.781842324716040173323791141746e-07
T(RZ,   0x1.6c18ee614b9a5p-21,    0x1.6c18ee614bb9p-21, -0x1.ce3992p-18, INEXACT) // 6.781842324716040173323791141746e-07
T(RN,   0x1.654a4aa36267fp-14,   0x1.654a4aaaa24bbp-14,   0x1.fffe16p-2, INEXACT) // 8.518462214204303194816508826293e-05
T(RD,   0x1.5be1d2058b621p-16,   0x1.5be1d205f673dp-16, -0x1.cbcb4cp-18, INEXACT) // 2.073538964546793673449955053290e-05
T(RU,   0x1.5be1d2058b621p-16,   0x1.5be1d205f673ep-16,   0x1.ffff1ap-1, INEXACT) // 2.073538964546793673449955053290e-05
T(RZ,   0x1.5be1d2058b621p-16,   0x1.5be1d205f673dp-16, -0x1.cbcb4cp-18, INEXACT) // 2.073538964546793673449955053290e-05
T(RD,   0x1.43faae06a9ec5p-11,   0x1.43faaf6096654p-11, -0x1.1387cep-18, INEXACT) // 6.179413183717499683314522407329e-04
T(RU,   0x1.43faae06a9ec5p-11,   0x1.43faaf6096655p-11,   0x1.ffff76p-1, INEXACT) // 6.179413183717499683314522407329e-04
T(RZ,   0x1.43faae06a9ec5p-11,   0x1.43faaf6096654p-11, -0x1.1387cep-18, INEXACT) // 6.179413183717499683314522407329e-04
T(RN,     0x1.7da5a8931f1ap-8,    0x1.7da635f22ee73p-8,   0x1.ffff28p-2, INEXACT) // 5.823472648554789410368925928196e-03
T(RN,  -0x1.0a66a847664dfp-14,  -0x1.0a66a84a679b1p-14,  -0x1.ffffcap-2, INEXACT) // -6.351494913871571742266380899977e-05
T(RD,  -0x1.e19ccb629a164p-12,  -0x1.e19ccc7eb2264p-12, -0x1.65068ep-18, INEXACT) // -4.593014511216268833809772687005e-04
T(RU,  -0x1.e19ccb629a164p-12,  -0x1.e19ccc7eb2263p-12,   0x1.ffff4ep-1, INEXACT) // -4.593014511216268833809772687005e-04
T(RZ,  -0x1.e19ccb629a164p-12,  -0x1.e19ccc7eb2263p-12,   0x1.ffff4ep-1, INEXACT) // -4.593014511216268833809772687005e-04
T(RN,  -0x1.16df366692d8fp-17,  -0x1.16df3666a0a2dp-17,   0x1.ffff34p-2, INEXACT) // -8.311030979111007439201312674282e-06
T(RN,    0x1.85056e3d1c25dp-3,    0x1.876642d15476ap-3,  -0x1.fffeb6p-2, INEXACT) // 1.899517643355634055613023747355e-01
T(RN,   0x1.0cfeeb4d83f82p-22,   0x1.0cfeeb4d83fb4p-22,   0x1.ffffaep-2, INEXACT) // 2.505218404677825215241056440452e-07
T(RD,   0x1.0a4033ef9c257p-24,   0x1.0a4033ef9c25ap-24, -0x1.1e69e8p-19, INEXACT) // 6.199134338649639823386926695478e-08
T(RU,   0x1.0a4033ef9c257p-24,   0x1.0a4033ef9c25bp-24,   0x1.ffffb8p-1, INEXACT) // 6.199134338649639823386926695478e-08
T(RZ,   0x1.0a4033ef9c257p-24,   0x1.0a4033ef9c25ap-24, -0x1.1e69e8p-19, INEXACT) // 6.199134338649639823386926695478e-08
T(RN,    0x1.40c5a54c545cfp-6,    0x1.40cae489845f1p-6,   0x1.fffeacp-2, INEXACT) // 1.957837240599307956911978578773e-02
T(RN,  -0x1.62b63b01e2574p-22,  -0x1.62b63b01e25e6p-22,  -0x1.ffffa8p-2, INEXACT) // -3.303511421017892762589220415070e-07
T(RD,     0x1.460d6127ef12p-2,    0x1.4bd453cdd142bp-2,  -0x1.ffff4ep-1, INEXACT) // 3.184104138015459994903721963055e-01
T(RU,     0x1.460d6127ef12p-2,    0x1.4bd453cdd142cp-2,  0x1.647978p-18, INEXACT) // 3.184104138015459994903721963055e-01
T(RZ,     0x1.460d6127ef12p-2,    0x1.4bd453cdd142bp-2,  -0x1.ffff4ep-1, INEXACT) // 3.184104138015459994903721963055e-01
T(RD,   0x1.d932cdcde26dfp-15,   0x1.d932cdd21847cp-15,  -0x1.ffffc4p-1, INEXACT) // 5.640965137760993295843944816959e-05
T(RU,   0x1.d932cdcde26dfp-15,   0x1.d932cdd21847dp-15,  0x1.e4c386p-20, INEXACT) // 5.640965137760993295843944816959e-05
T(RZ,   0x1.d932cdcde26dfp-15,   0x1.d932cdd21847cp-15,  -0x1.ffffc4p-1, INEXACT) // 5.640965137760993295843944816959e-05
T(RD,  -0x1.10bab367eb1edp-18,  -0x1.10bab367ee584p-18, -0x1.205fe6p-20, INEXACT) // -4.063983261842486626347781958346e-06
T(RU,  -0x1.10bab367eb1edp-18,  -0x1.10bab367ee583p-18,   0x1.ffffdcp-1, INEXACT) // -4.063983261842486626347781958346e-06
T(RZ,  -0x1.10bab367eb1edp-18,  -0x1.10bab367ee583p-18,   0x1.ffffdcp-1, INEXACT) // -4.063983261842486626347781958346e-06
T(RD,   0x1.b893d93df4061p-18,   0x1.b893d93e019ddp-18,  -0x1.ffff08p-1, INEXACT) // 6.565116846560330460399416280248e-06
T(RU,   0x1.b893d93df4061p-18,   0x1.b893d93e019dep-18,  0x1.f1c29cp-18, INEXACT) // 6.565116846560330460399416280248e-06
T(RZ,   0x1.b893d93df4061p-18,   0x1.b893d93e019ddp-18,  -0x1.ffff08p-1, INEXACT) // 6.565116846560330460399416280248e-06
T(RN,    0x1.224d7298845ap-20,   0x1.224d729884983p-20,  -0x1.ffff4ap-2, INEXACT) // 1.081461198041866087708046118010e-06
T(RD,  -0x1.cce757a9fa354p-22,  -0x1.cce757a9fa44ep-22,  -0x1.ffffc8p-1, INEXACT) // -4.292500032075582966649461916231e-07
T(RU,  -0x1.cce757a9fa354p-22,  -0x1.cce757a9fa44dp-22,  0x1.bcc528p-20, INEXACT) // -4.292500032075582966649461916231e-07
T(RZ,  -0x1.cce757a9fa354p-22,  -0x1.cce757a9fa44dp-22,  0x1.bcc528p-20, INEXACT) // -4.292500032075582966649461916231e-07
T(RD,   -0x1.9e70190761768p-9,   -0x1.9e70464943224p-9, -0x1.eb0bfap-20, INEXACT) // -3.161910109784327876925047462464e-03
T(RU,   -0x1.9e70190761768p-9,   -0x1.9e70464943223p-9,   0x1.ffffc2p-1, INEXACT) // -3.161910109784327876925047462464e-03
T(RZ,   -0x1.9e70190761768p-9,   -0x1.9e70464943223p-9,   0x1.ffffc2p-1, INEXACT) // -3.161910109784327876925047462464e-03
T(RD,    0x1.0d42cc64ab827p-3,    0x1.0e0af1ff8e35ep-3, -0x1.2f5082p-18, INEXACT) // 1.314750641080888182710140199561e-01
T(RU,    0x1.0d42cc64ab827p-3,    0x1.0e0af1ff8e35fp-3,   0x1.ffff68p-1, INEXACT) // 1.314750641080888182710140199561e-01
T(RZ,    0x1.0d42cc64ab827p-3,    0x1.0e0af1ff8e35ep-3, -0x1.2f5082p-18, INEXACT) // 1.314750641080888182710140199561e-01
T(RN,    0x1.b114ac1d3bd3dp-9,    0x1.b114dfc20758ap-9,    0x1.fffebp-2, INEXACT) // 3.304143915208306112735181514495e-03
T(RD,   -0x1.8727fe22bdf5fp-8,   -0x1.8728965701753p-8, -0x1.80503cp-19, INEXACT) // -5.968570275164924131272581320218e-03
T(RU,   -0x1.8727fe22bdf5fp-8,   -0x1.8728965701752p-8,    0x1.ffffap-1, INEXACT) // -5.968570275164924131272581320218e-03
T(RZ,   -0x1.8727fe22bdf5fp-8,   -0x1.8728965701752p-8,    0x1.ffffap-1, INEXACT) // -5.968570275164924131272581320218e-03
T(RD,  -0x1.022b6af23e462p-12,  -0x1.022b6b1e01029p-12, -0x1.aa9c94p-18, INEXACT) // -2.462097173885955227537469802712e-04
T(RU,  -0x1.022b6af23e462p-12,  -0x1.022b6b1e01028p-12,   0x1.ffff2ap-1, INEXACT) // -2.462097173885955227537469802712e-04
T(RZ,  -0x1.022b6af23e462p-12,  -0x1.022b6b1e01028p-12,   0x1.ffff2ap-1, INEXACT) // -2.462097173885955227537469802712e-04
T(RD,  -0x1.4a6e013d3ef59p-19,  -0x1.4a6e013d40649p-19, -0x1.83d3a2p-18, INEXACT) // -2.461893159220600362852753376086e-06
T(RU,  -0x1.4a6e013d3ef59p-19,  -0x1.4a6e013d40648p-19,   0x1.ffff3ep-1, INEXACT) // -2.461893159220600362852753376086e-06
T(RZ,  -0x1.4a6e013d3ef59p-19,  -0x1.4a6e013d40648p-19,   0x1.ffff3ep-1, INEXACT) // -2.461893159220600362852753376086e-06
T(RD,  -0x1.d12e9b985b3cdp-26,  -0x1.d12e9b985b3cep-26, -0x1.5e9726p-18, INEXACT) // -2.707715971008022260959427235816e-08
T(RU,  -0x1.d12e9b985b3cdp-26,  -0x1.d12e9b985b3cdp-26,    0x1.ffff5p-1, INEXACT) // -2.707715971008022260959427235816e-08
T(RZ,  -0x1.d12e9b985b3cdp-26,  -0x1.d12e9b985b3cdp-26,    0x1.ffff5p-1, INEXACT) // -2.707715971008022260959427235816e-08
T(RD,  -0x1.250c1a1430546p-25,  -0x1.250c1a1430548p-25,  -0x1.ffff6ep-1, INEXACT) // -3.411519258886821684644794243010e-08
T(RU,  -0x1.250c1a1430546p-25,  -0x1.250c1a1430547p-25,  0x1.253e46p-18, INEXACT) // -3.411519258886821684644794243010e-08
T(RZ,  -0x1.250c1a1430546p-25,  -0x1.250c1a1430547p-25,  0x1.253e46p-18, INEXACT) // -3.411519258886821684644794243010e-08
T(RD,  -0x1.d0938d6e95f32p-22,  -0x1.d0938d6e96032p-22,   -0x1.ffff8p-1, INEXACT) // -4.326704673754811516001484057725e-07
T(RU,  -0x1.d0938d6e95f32p-22,  -0x1.d0938d6e96031p-22,  0x1.011f1cp-18, INEXACT) // -4.326704673754811516001484057725e-07
T(RZ,  -0x1.d0938d6e95f32p-22,  -0x1.d0938d6e96031p-22,  0x1.011f1cp-18, INEXACT) // -4.326704673754811516001484057725e-07
T(RN,   0x1.302251b1b16b2p-17,   0x1.302251b1c34ddp-17,  -0x1.fffebep-2, INEXACT) // 9.063901276983161011064141221460e-06
T(RN,  -0x1.f902f261da037p-16,  -0x1.f902f263218f5p-16,  -0x1.fffea8p-2, INEXACT) // -3.010103171821617334589192560568e-05
T(RD,   0x1.e32afdc8d4cc9p-18,   0x1.e32afdc8e6ba3p-18,   -0x1.ffffdp-1, INEXACT) // 7.199763282300649770240139752042e-06
T(RU,   0x1.e32afdc8d4cc9p-18,   0x1.e32afdc8e6ba4p-18,  0x1.7fc79ep-20, INEXACT) // 7.199763282300649770240139752042e-06
T(RZ,   0x1.e32afdc8d4cc9p-18,   0x1.e32afdc8e6ba3p-18,   -0x1.ffffdp-1, INEXACT) // 7.199763282300649770240139752042e-06
T(RN,    0x1.05fe9e2f71ae7p-1,    0x1.13083023c8934p-1,   0x1.fffeaep-2, INEXACT) // 5.117082055010911956216546059295e-01
T(RN,   -0x1.0b890b7721697p-7,   -0x1.0b89ce4381f38p-7,  -0x1.fffe84p-2, INEXACT) // -8.164530371014762019643562496185e-03
T(RN,   -0x1.8a1b9c3700169p-5,   -0x1.8a4291b225d31p-5,  -0x1.ffff7cp-2, INEXACT) // -4.810886870109493812508461019206e-02
T(RD,  -0x1.e8d3d34d5bf76p-13,   -0x1.e8d3d3979f6ep-13,  -0x1.ffffbcp-1, INEXACT) // -2.330910887553512621066242882506e-04
T(RU,  -0x1.e8d3d34d5bf76p-13,  -0x1.e8d3d3979f6dfp-13,  0x1.10db34p-19, INEXACT) // -2.330910887553512621066242882506e-04
T(RZ,  -0x1.e8d3d34d5bf76p-13,  -0x1.e8d3d3979f6dfp-13,  0x1.10db34p-19, INEXACT) // -2.330910887553512621066242882506e-04
T(RN,  -0x1.a4a9123fc79fep-15,  -0x1.a4a91242bcd8fp-15,   0x1.ffff8ep-2, INEXACT) // -5.014663156387501351859276033096e-05
T(RD,   -0x1.a680242d44b1ap-4,   -0x1.a740ddcd201e7p-4,  -0x1.ffffe8p-1, INEXACT) // -1.031495488316917230608993349961e-01
T(RU,   -0x1.a680242d44b1ap-4,   -0x1.a740ddcd201e6p-4,  0x1.7142eap-21, INEXACT) // -1.031495488316917230608993349961e-01
T(RZ,   -0x1.a680242d44b1ap-4,   -0x1.a740ddcd201e6p-4,  0x1.7142eap-21, INEXACT) // -1.031495488316917230608993349961e-01
T(RD,   0x1.178eb17bd5a3bp-20,   0x1.178eb17bd5db3p-20,  -0x1.ffffa6p-1, INEXACT) // 1.041432454015229530205270506993e-06
T(RU,   0x1.178eb17bd5a3bp-20,   0x1.178eb17bd5db4p-20,  0x1.6a690ap-19, INEXACT) // 1.041432454015229530205270506993e-06
T(RZ,   0x1.178eb17bd5a3bp-20,   0x1.178eb17bd5db3p-20,  -0x1.ffffa6p-1, INEXACT) // 1.041432454015229530205270506993e-06
T(RD,   -0x1.818e5b80f9d6fp-4,   -0x1.8220b30ac22b7p-4,  -0x1.ffff9ap-1, INEXACT) // -9.412990325619373377374898836933e-02
T(RU,   -0x1.818e5b80f9d6fp-4,   -0x1.8220b30ac22b6p-4,  0x1.9bece2p-19, INEXACT) // -9.412990325619373377374898836933e-02
T(RZ,   -0x1.818e5b80f9d6fp-4,   -0x1.8220b30ac22b6p-4,  0x1.9bece2p-19, INEXACT) // -9.412990325619373377374898836933e-02
T(RN,   0x1.8c0fc6422fc94p-23,   0x1.8c0fc6422fcbcp-23,   0x1.ffffd4p-2, INEXACT) // 1.844305633265837124717631025084e-07
T(RN,   0x1.590442b42b103p-19,    0x1.590442b42cb2p-19,   0x1.ffff16p-2, INEXACT) // 2.570574304602597837842358971527e-06
T(RN,    0x1.37b6270c36918p-3,    0x1.38ed819b50e2dp-3,   0x1.fffebap-2, INEXACT) // 1.522028971292648247271017680760e-01
T(RN,    0x1.9490257264cddp-3,    0x1.973dd58018fbfp-3,   0x1.fffe62p-2, INEXACT) // 1.975405622039038411319467059002e-01
T(RN,    0x1.af170c3bc75f7p-7,    0x1.af1a3b401618bp-7,   0x1.ffffccp-2, INEXACT) // 1.315582368220711943773704177829e-02
T(RD,  -0x1.24b66c4a3aaafp-19,  -0x1.24b66c4a3baa1p-19, -0x1.488c58p-18, INEXACT) // -2.180878742587731089155487704256e-06
T(RU,  -0x1.24b66c4a3aaafp-19,   -0x1.24b66c4a3baap-19,   0x1.ffff5cp-1, INEXACT) // -2.180878742587731089155487704256e-06
T(RZ,  -0x1.24b66c4a3aaafp-19,   -0x1.24b66c4a3baap-19,   0x1.ffff5cp-1, INEXACT) // -2.180878742587731089155487704256e-06
T(RD,   0x1.99e38ad0dc6dep-11,   0x1.99e38d8d644cep-11,  -0x1.ffffe2p-1, INEXACT) // 7.818009126891697132405445458403e-04
T(RU,   0x1.99e38ad0dc6dep-11,   0x1.99e38d8d644cfp-11,  0x1.e2f43cp-21, INEXACT) // 7.818009126891697132405445458403e-04
T(RZ,   0x1.99e38ad0dc6dep-11,   0x1.99e38d8d644cep-11,  -0x1.ffffe2p-1, INEXACT) // 7.818009126891697132405445458403e-04
T(RN,  -0x1.e1667dad7e472p-20,  -0x1.e1667dad7f62ep-20,  -0x1.ffff16p-2, INEXACT) // -1.793356072864076895839085049045e-06
T(RD,   -0x1.12106014312fdp-4,   -0x1.1244d4ff0295bp-4,  -0x1.ffff12p-1, INEXACT) // -6.691014796076540094293960692085e-02
T(RU,   -0x1.12106014312fdp-4,   -0x1.1244d4ff0295ap-4,  0x1.da3c4ap-18, INEXACT) // -6.691014796076540094293960692085e-02
T(RZ,   -0x1.12106014312fdp-4,   -0x1.1244d4ff0295ap-4,  0x1.da3c4ap-18, INEXACT) // -6.691014796076540094293960692085e-02
T(RN,   0x1.c88b2380051a7p-23,   0x1.c88b2380051e3p-23,  -0x1.ffff12p-2, INEXACT) // 2.125946387826464682512206351081e-07
T(RN,   -0x1.ed7ae0697642p-13,  -0x1.ed7ae0b5ddbe6p-13,   0x1.fffeeep-2, INEXACT) // -2.353095945142611236655660889028e-04
T(RD,   -0x1.3052634bcd6ccp-5,   -0x1.3064515a06bdep-5, -0x1.632588p-18, INEXACT) // -3.714866060037777528712865660054e-02
T(RU,   -0x1.3052634bcd6ccp-5,   -0x1.3064515a06bddp-5,   0x1.ffff4ep-1, INEXACT) // -3.714866060037777528712865660054e-02
T(RZ,   -0x1.3052634bcd6ccp-5,   -0x1.3064515a06bddp-5,   0x1.ffff4ep-1, INEXACT) // -3.714866060037777528712865660054e-02
T(RN,  -0x1.713728521eb1ap-26,  -0x1.713728521eb1ap-26,   0x1.ffff8ap-2, INEXACT) // -2.149116824126626829896411830824e-08
T(RD,   0x1.d12ec05e7bf5bp-25,   0x1.d12ec05e7bf5ep-25,  -0x1.ffff28p-1, INEXACT) // 5.415438474379459274184035028586e-08
T(RU,   0x1.d12ec05e7bf5bp-25,   0x1.d12ec05e7bf5fp-25,  0x1.aef70cp-18, INEXACT) // 5.415438474379459274184035028586e-08
T(RZ,   0x1.d12ec05e7bf5bp-25,   0x1.d12ec05e7bf5ep-25,  -0x1.ffff28p-1, INEXACT) // 5.415438474379459274184035028586e-08
T(RN,     0x1.eb884b314e42p-6,    0x1.eb9b2d5ac86c1p-6,  -0x1.fffe6ap-2, INEXACT) // 3.000075667407398061214962581289e-02
T(RN,   0x1.717e7c3e8444fp-17,   0x1.717e7c3ea4577p-17,  -0x1.fffe58p-2, INEXACT) // 1.101178179133320061348477042484e-05
T(RN,  -0x1.be406d893c607p-23,  -0x1.be406d893c63fp-23,   0x1.fffe32p-2, INEXACT) // -2.078021277617205375540303203749e-07
T(RD,  -0x1.61246d4d7a609p-21,  -0x1.61246d4d7a7c9p-21, -0x1.bf2356p-18, INEXACT) // -6.577787787207562882695163937463e-07
T(RU,  -0x1.61246d4d7a609p-21,  -0x1.61246d4d7a7c8p-21,    0x1.ffff2p-1, INEXACT) // -6.577787787207562882695163937463e-07
T(RZ,  -0x1.61246d4d7a609p-21,  -0x1.61246d4d7a7c8p-21,    0x1.ffff2p-1, INEXACT) // -6.577787787207562882695163937463e-07
T(RD,   -0x1.0a944b3a556a7p-2,   -0x1.0dafa4cf2f0ccp-2, -0x1.785724p-19, INEXACT) // -2.603313211778676694585499262757e-01
T(RU,   -0x1.0a944b3a556a7p-2,   -0x1.0dafa4cf2f0cbp-2,   0x1.ffffa2p-1, INEXACT) // -2.603313211778676694585499262757e-01
T(RZ,   -0x1.0a944b3a556a7p-2,   -0x1.0dafa4cf2f0cbp-2,   0x1.ffffa2p-1, INEXACT) // -2.603313211778676694585499262757e-01
T(RN,    0x1.39887363e9148p-8,    0x1.3988c1c603e7dp-8,   0x1.ffff1cp-2, INEXACT) // 4.784134074644015577337796685242e-03
T(RN,    0x1.aafa37bb2d06p-13,   0x1.aafa37ecaaa41p-13,  -0x1.ffff5cp-2, INEXACT) // 2.035986961793660385278137425757e-04
T(RN,   0x1.41692d10ab1c3p-14,   0x1.41692d15f2282p-14,   -0x1.fffe7p-2, INEXACT) // 7.663031670785470136474798463766e-05
T(RD,   -0x1.1d83a670d8c28p-6,   -0x1.1d87599e64691p-6, -0x1.88c104p-19, INEXACT) // -1.742640737519365878860355678626e-02
T(RU,   -0x1.1d83a670d8c28p-6,    -0x1.1d87599e6469p-6,   0x1.ffff9ep-1, INEXACT) // -1.742640737519365878860355678626e-02
T(RZ,   -0x1.1d83a670d8c28p-6,    -0x1.1d87599e6469p-6,   0x1.ffff9ep-1, INEXACT) // -1.742640737519365878860355678626e-02
T(RN,   0x1.e85ccaa0f00a2p-11,   0x1.e85ccf41c45cbp-11,   0x1.fffe9ap-2, INEXACT) // 9.314774834976622622934039341658e-04
T(RN,   -0x1.dc1fe437265a6p-6,   -0x1.dc310dc442f4ap-6,   0x1.fffe06p-2, INEXACT) // -2.906033789313302445611597590869e-02
T(RD,   -0x1.d15755bb47b8bp-4,   -0x1.d25918a240459p-4, -0x1.ed7366p-20, INEXACT) // -1.136086796654877523193860611173e-01
T(RU,   -0x1.d15755bb47b8bp-4,   -0x1.d25918a240458p-4,   0x1.ffffc2p-1, INEXACT) // -1.136086796654877523193860611173e-01
T(RZ,   -0x1.d15755bb47b8bp-4,   -0x1.d25918a240458p-4,   0x1.ffffc2p-1, INEXACT) // -1.136086796654877523193860611173e-01
T(RN,   0x1.4400c7320bf8cp-22,   0x1.4400c7320bfe2p-22,  -0x1.fffe26p-2, INEXACT) // 3.017513449136568700492287350978e-07
T(RD,   0x1.cd28f57d9a434p-15,   0x1.cd28f5817fecdp-15,  -0x1.ffffc4p-1, INEXACT) // 5.497455547926640415969112840600e-05
T(RU,   0x1.cd28f57d9a434p-15,   0x1.cd28f5817fecep-15,  0x1.e375fap-20, INEXACT) // 5.497455547926640415969112840600e-05
T(RZ,   0x1.cd28f57d9a434p-15,   0x1.cd28f5817fecdp-15,  -0x1.ffffc4p-1, INEXACT) // 5.497455547926640415969112840600e-05
T(RN,    0x1.b17cd81ef5bd9p-7,    0x1.b18014d02c19bp-7,   -0x1.fffe1p-2, INEXACT) // 1.322899391918312857197026488620e-02
T(RD,   0x1.a6a57b618853ep-25,    0x1.a6a57b618854p-25,  -0x1.ffff3cp-1, INEXACT) // 4.920251829252188118616213310594e-08
T(RU,   0x1.a6a57b618853ep-25,   0x1.a6a57b6188541p-25,  0x1.87817ep-18, INEXACT) // 4.920251829252188118616213310594e-08
T(RZ,   0x1.a6a57b618853ep-25,    0x1.a6a57b618854p-25,  -0x1.ffff3cp-1, INEXACT) // 4.920251829252188118616213310594e-08
T(RD,   0x1.5019b3ae36153p-12,   0x1.5019b40ec43a7p-12, -0x1.268a34p-19, INEXACT) // 3.205303172655510931914057959347e-04
T(RU,   0x1.5019b3ae36153p-12,   0x1.5019b40ec43a8p-12,   0x1.ffffb6p-1, INEXACT) // 3.205303172655510931914057959347e-04
T(RZ,   0x1.5019b3ae36153p-12,   0x1.5019b40ec43a7p-12, -0x1.268a34p-19, INEXACT) // 3.205303172655510931914057959347e-04
T(RD,  -0x1.a6a5827574acfp-25,  -0x1.a6a5827574ad2p-25, -0x1.da577cp-19, INEXACT) // -4.920253086526496383880030570206e-08
T(RU,  -0x1.a6a5827574acfp-25,  -0x1.a6a5827574ad1p-25,   0x1.ffff8ap-1, INEXACT) // -4.920253086526496383880030570206e-08
T(RZ,  -0x1.a6a5827574acfp-25,  -0x1.a6a5827574ad1p-25,   0x1.ffff8ap-1, INEXACT) // -4.920253086526496383880030570206e-08
T(RD,   0x1.58868e6327367p-23,   0x1.58868e6327381p-23, -0x1.6ac006p-21, INEXACT) // 1.604322391366756583955141502937e-07
T(RU,   0x1.58868e6327367p-23,   0x1.58868e6327382p-23,   0x1.ffffeap-1, INEXACT) // 1.604322391366756583955141502937e-07
T(RZ,   0x1.58868e6327367p-23,   0x1.58868e6327381p-23, -0x1.6ac006p-21, INEXACT) // 1.604322391366756583955141502937e-07
T(RD,  -0x1.0a13c85f23828p-19,  -0x1.0a13c85f24423p-19,  -0x1.ffff74p-1, INEXACT) // -1.982430191178035104636670493683e-06
T(RU,  -0x1.0a13c85f23828p-19,  -0x1.0a13c85f24422p-19,  0x1.18b6eap-18, INEXACT) // -1.982430191178035104636670493683e-06
T(RZ,  -0x1.0a13c85f23828p-19,  -0x1.0a13c85f24422p-19,  0x1.18b6eap-18, INEXACT) // -1.982430191178035104636670493683e-06
T(RD,    0x1.304687176db64p-2,    0x1.34f0e5b0668a3p-2,  -0x1.ffffaap-1, INEXACT) // 2.971440418290767215836467585177e-01
T(RU,    0x1.304687176db64p-2,    0x1.34f0e5b0668a4p-2,  0x1.57fc8ap-19, INEXACT) // 2.971440418290767215836467585177e-01
T(RZ,    0x1.304687176db64p-2,    0x1.34f0e5b0668a3p-2,  -0x1.ffffaap-1, INEXACT) // 2.971440418290767215836467585177e-01
T(RN,  -0x1.b7a655ef1b9a1p-19,  -0x1.b7a655ef1efa8p-19,   0x1.fffe6ep-2, INEXACT) // -3.275645887471787335161162516006e-06
T(RN,   0x1.25ced9e17825ap-22,   0x1.25ced9e17829bp-22,   0x1.ffffaap-2, INEXACT) // 2.736300342681310455682773020991e-07
T(RD,  -0x1.f51a54bbdbb42p-25,  -0x1.f51a54bbdbb47p-25, -0x1.970ee4p-18, INEXACT) // -5.833605018392013813036041944629e-08
T(RU,  -0x1.f51a54bbdbb42p-25,  -0x1.f51a54bbdbb46p-25,   0x1.ffff34p-1, INEXACT) // -5.833605018392013813036041944629e-08
T(RZ,  -0x1.f51a54bbdbb42p-25,  -0x1.f51a54bbdbb46p-25,   0x1.ffff34p-1, INEXACT) // -5.833605018392013813036041944629e-08
T(RN,  -0x1.0f687dd8f0a3dp-20,  -0x1.0f687dd8f0d6ap-20,   0x1.fffe0cp-2, INEXACT) // -1.011074223664642963789917114170e-06
T(RD,  -0x1.36796e2605a8cp-13,  -0x1.36796e390cbf3p-13,  -0x1.ffff44p-1, INEXACT) // -1.480457005420165094919382475780e-04
T(RU,  -0x1.36796e2605a8cp-13,  -0x1.36796e390cbf2p-13,  0x1.76b89cp-18, INEXACT) // -1.480457005420165094919382475780e-04
T(RZ,  -0x1.36796e2605a8cp-13,  -0x1.36796e390cbf2p-13,  0x1.76b89cp-18, INEXACT) // -1.480457005420165094919382475780e-04
T(RD,  -0x1.90563768a5801p-19,  -0x1.90563768a80ccp-19, -0x1.345814p-18, INEXACT) // -2.982741467437260020589525136292e-06
T(RU,  -0x1.90563768a5801p-19,  -0x1.90563768a80cbp-19,   0x1.ffff66p-1, INEXACT) // -2.982741467437260020589525136292e-06
T(RZ,  -0x1.90563768a5801p-19,  -0x1.90563768a80cbp-19,   0x1.ffff66p-1, INEXACT) // -2.982741467437260020589525136292e-06
T(RN,   0x1.7136ed243a5d4p-26,   0x1.7136ed243a5d4p-26,  -0x1.fffe94p-2, INEXACT) // 2.149111567951995018677129782939e-08
T(RN,   0x1.a0a24c810c0a1p-15,   0x1.a0a24c83ebb9ep-15,   0x1.fffe5cp-2, INEXACT) // 4.966664074179781026121063836065e-05
T(RD,    0x1.8febfb9d61336p-3,    0x1.928211654b343p-3,  -0x1.ffff2cp-1, INEXACT) // 1.952743203547925854302036441368e-01
T(RU,    0x1.8febfb9d61336p-3,    0x1.928211654b344p-3,  0x1.a96a8ap-18, INEXACT) // 1.952743203547925854302036441368e-01
T(RZ,    0x1.8febfb9d61336p-3,    0x1.928211654b343p-3,  -0x1.ffff2cp-1, INEXACT) // 1.952743203547925854302036441368e-01
T(RD,   0x1.a43c156c44a2fp-13,    0x1.a43c159b7375p-13,  -0x1.ffffecp-1, INEXACT) // 2.003835210265410532014945799162e-04
T(RU,   0x1.a43c156c44a2fp-13,   0x1.a43c159b73751p-13,    0x1.3283p-21, INEXACT) // 2.003835210265410532014945799162e-04
T(RZ,   0x1.a43c156c44a2fp-13,    0x1.a43c159b7375p-13,  -0x1.ffffecp-1, INEXACT) // 2.003835210265410532014945799162e-04
T(RN,    -0x1.2f20355dfe49p-2,   -0x1.33bcb63ae9116p-2,  -0x1.ffff2cp-2, INEXACT) // -2.960213030451734894654691743199e-01
T(RN,  -0x1.366078cb0320dp-19,   -0x1.366078cb0451p-19,  -0x1.ffffc6p-2, INEXACT) // -2.312487685346295864359739483107e-06
T(RN,   -0x1.df855273fe079p-9,   -0x1.df85988e3e356p-9,   0x1.fffeb8p-2, INEXACT) // -3.658453288149895749753470752808e-03
T(RN,    0x1.d5089d56d3296p-2,    0x1.e735717dabc0fp-2,  -0x1.fffe56p-2, INEXACT) // 4.580406746143038665408653287159e-01
T(RN,  -0x1.1477c81a64425p-14,   -0x1.1477c81dc01cp-14,   0x1.fffe96p-2, INEXACT) // -6.591508318921962723564017538891e-05
T(RD,   0x1.67af052d146c3p-18,   0x1.67af052d1bd19p-18,  -0x1.ffff8cp-1, INEXACT) // 5.359704386158426645751350764213e-06
T(RU,   0x1.67af052d146c3p-18,   0x1.67af052d1bd1ap-18,  0x1.ceddfep-19, INEXACT) // 5.359704386158426645751350764213e-06
T(RZ,   0x1.67af052d146c3p-18,   0x1.67af052d1bd19p-18,  -0x1.ffff8cp-1, INEXACT) // 5.359704386158426645751350764213e-06
T(RN,   0x1.2f2f6d25e0f9ap-21,   0x1.2f2f6d25e10b5p-21,  -0x1.fffeeap-2, INEXACT) // 5.647265523965671024897135590881e-07
T(RD,  -0x1.210646985a04cp-16,  -0x1.21064698976b6p-16,  -0x1.ffffe4p-1, INEXACT) // -1.722720352984067552614549923007e-05
T(RU,  -0x1.210646985a04cp-16,  -0x1.21064698976b5p-16,  0x1.baa6cep-21, INEXACT) // -1.722720352984067552614549923007e-05
T(RZ,  -0x1.210646985a04cp-16,  -0x1.21064698976b5p-16,  0x1.baa6cep-21, INEXACT) // -1.722720352984067552614549923007e-05
T(RD,   -0x1.3102f455ec4fbp-8,   -0x1.31033c7ff60dbp-8, -0x1.b4ccf2p-19, INEXACT) // -4.654106762175698290551206781629e-03
T(RU,   -0x1.3102f455ec4fbp-8,   -0x1.31033c7ff60dap-8,   0x1.ffff92p-1, INEXACT) // -4.654106762175698290551206781629e-03
T(RZ,   -0x1.3102f455ec4fbp-8,   -0x1.31033c7ff60dap-8,   0x1.ffff92p-1, INEXACT) // -4.654106762175698290551206781629e-03
T(RN,   0x1.7c9d9bdb0b82dp-17,   0x1.7c9d9bdb2e914p-17,  -0x1.fffeccp-2, INEXACT) // 1.134323058779245625932261681834e-05
T(RD,  -0x1.78865a11b65e7p-13,  -0x1.78865a33a690ap-13,         -0x1p+0, INEXACT) // -1.795410212739732998526304141862e-04
T(RU,  -0x1.78865a11b65e7p-13,  -0x1.78865a33a6909p-13,  0x1.dd0236p-27, INEXACT) // -1.795410212739732998526304141862e-04
T(RZ,  -0x1.78865a11b65e7p-13,  -0x1.78865a33a6909p-13,  0x1.dd0236p-27, INEXACT) // -1.795410212739732998526304141862e-04
T(RD,     0x1.ebf6a756b62ep-1,    0x1.4a44cd969f7e6p+0, -0x1.2a743cp-18, INEXACT) // 9.608661931370896525095304241404e-01
T(RU,     0x1.ebf6a756b62ep-1,    0x1.4a44cd969f7e7p+0,   0x1.ffff6ap-1, INEXACT) // 9.608661931370896525095304241404e-01
T(RZ,     0x1.ebf6a756b62ep-1,    0x1.4a44cd969f7e6p+0, -0x1.2a743cp-18, INEXACT) // 9.608661931370896525095304241404e-01
T(RN,   -0x1.4d096b9c98b6ep-4,   -0x1.4d67a3cbcb00bp-4,  -0x1.fffff2p-2, INEXACT) // -8.130781207868917337400205269660e-02
T(RD,     -0x1.a1acd6e702fp-9,   -0x1.a1ad053a8531ap-9,  -0x1.0f5efp-18, INEXACT) // -3.186608536912660660789242683677e-03
T(RU,     -0x1.a1acd6e702fp-9,   -0x1.a1ad053a85319p-9,   0x1.ffff78p-1, INEXACT) // -3.186608536912660660789242683677e-03
T(RZ,     -0x1.a1acd6e702fp-9,   -0x1.a1ad053a85319p-9,   0x1.ffff78p-1, INEXACT) // -3.186608536912660660789242683677e-03
T(RD,    0x1.5a41567d7e61dp-2,    0x1.6137db17136b2p-2,  -0x1.ffff18p-1, INEXACT) // 3.381398691268218681393875613139e-01
T(RU,    0x1.5a41567d7e61dp-2,    0x1.6137db17136b3p-2,  0x1.d10c4ep-18, INEXACT) // 3.381398691268218681393875613139e-01
T(RZ,    0x1.5a41567d7e61dp-2,    0x1.6137db17136b2p-2,  -0x1.ffff18p-1, INEXACT) // 3.381398691268218681393875613139e-01
T(RN,  -0x1.24481e70ab16cp-22,  -0x1.24481e70ab1acp-22,  -0x1.fffec4p-2, INEXACT) // -2.722085588418197081545619672727e-07
T(RD,   -0x1.7c15b03dd049dp-3,   -0x1.7e4d1679c9e39p-3, -0x1.42427ep-19, INEXACT) // -1.855882424224874205354041123428e-01
T(RU,   -0x1.7c15b03dd049dp-3,   -0x1.7e4d1679c9e38p-3,    0x1.ffffbp-1, INEXACT) // -1.855882424224874205354041123428e-01
T(RZ,   -0x1.7c15b03dd049dp-3,   -0x1.7e4d1679c9e38p-3,    0x1.ffffbp-1, INEXACT) // -1.855882424224874205354041123428e-01
T(RN,    0x1.b783d416a28d9p-8,    0x1.b784ac02e1ac2p-8,   0x1.ffff02p-2, INEXACT) // 6.706465987585918421542974243721e-03
T(RD,    0x1.41f82183a9282p-8,    0x1.41f8766582d81p-8,  -0x1.ffff02p-1, INEXACT) // 4.912861044122808842904426285259e-03
T(RU,    0x1.41f82183a9282p-8,    0x1.41f8766582d82p-8,  0x1.fbcacep-18, INEXACT) // 4.912861044122808842904426285259e-03
T(RZ,    0x1.41f82183a9282p-8,    0x1.41f8766582d81p-8,  -0x1.ffff02p-1, INEXACT) // 4.912861044122808842904426285259e-03
T(RN,   -0x1.25edd3b1d6c4cp-7,   -0x1.25eed605deca8p-7,   0x1.fffef4p-2, INEXACT) // -8.970001570267303880878984045921e-03
T(RN,   0x1.d5fa9b9203f17p-24,   0x1.d5fa9b9203f28p-24,   0x1.ffff42p-2, INEXACT) // 1.094254982460990787402382493597e-07
T(RD,   -0x1.84e4930208955p-3,   -0x1.8744cba9067cep-3, -0x1.84a70ep-20, INEXACT) // -1.898890957828124614881204479389e-01
T(RU,   -0x1.84e4930208955p-3,   -0x1.8744cba9067cdp-3,    0x1.ffffdp-1, INEXACT) // -1.898890957828124614881204479389e-01
T(RZ,   -0x1.84e4930208955p-3,   -0x1.8744cba9067cdp-3,    0x1.ffffdp-1, INEXACT) // -1.898890957828124614881204479389e-01
T(RD,   -0x1.e61ff12e341a2p-6,   -0x1.e632357ffa43bp-6, -0x1.00dfccp-21, INEXACT) // -2.967070153028007056805748220540e-02
T(RU,   -0x1.e61ff12e341a2p-6,   -0x1.e632357ffa43ap-6,    0x1.fffffp-1, INEXACT) // -2.967070153028007056805748220540e-02
T(RZ,   -0x1.e61ff12e341a2p-6,   -0x1.e632357ffa43ap-6,    0x1.fffffp-1, INEXACT) // -2.967070153028007056805748220540e-02
T(RN,    0x1.433ced1613df1p-5,    0x1.435269d154c23p-5,   -0x1.ffffap-2, INEXACT) // 3.945776277452840014037249716239e-02
T(RD,    0x1.dd94c8b942a69p-8,     0x1.dd95ddbff725p-8,  -0x1.ffff22p-1, INEXACT) // 7.287310604861299036250077421073e-03
T(RU,    0x1.dd94c8b942a69p-8,    0x1.dd95ddbff7251p-8,  0x1.bc405ep-18, INEXACT) // 7.287310604861299036250077421073e-03
T(RZ,    0x1.dd94c8b942a69p-8,     0x1.dd95ddbff725p-8,  -0x1.ffff22p-1, INEXACT) // 7.287310604861299036250077421073e-03
T(RN,    0x1.c96a334b2fa9cp-7,    0x1.c96e00ee98f8ap-7,   0x1.ffff26p-2, INEXACT) // 1.395919327330590736790938422018e-02
T(RD,   -0x1.beea6a4e22ae7p-4,    -0x1.bfcea6822be4p-4,   -0x1.ffff3p-1, INEXACT) // -1.091102745578314964225441485723e-01
T(RU,   -0x1.beea6a4e22ae7p-4,   -0x1.bfcea6822be3fp-4,  0x1.a03678p-18, INEXACT) // -1.091102745578314964225441485723e-01
T(RZ,   -0x1.beea6a4e22ae7p-4,   -0x1.bfcea6822be3fp-4,  0x1.a03678p-18, INEXACT) // -1.091102745578314964225441485723e-01
T(RN,  -0x1.daaa1d01e57cep-10,  -0x1.daaa2e0180ffbp-10,  -0x1.ffff1ep-2, INEXACT) // -1.810701389762570372859995515569e-03
T(RN,   0x1.7bdfde1c75befp-15,   0x1.7bdfde1ea3613p-15,  -0x1.ffffeap-2, INEXACT) // 4.528456722468337662971735180228e-05
T(RD,   0x1.5836b0c89aba5p-11,   0x1.5836b26779b5bp-11,  -0x1.ffff4cp-1, INEXACT) // 6.565354061199747551583194571378e-04
T(RU,   0x1.5836b0c89aba5p-11,   0x1.5836b26779b5cp-11,  0x1.692c86p-18, INEXACT) // 6.565354061199747551583194571378e-04
T(RZ,   0x1.5836b0c89aba5p-11,   0x1.5836b26779b5bp-11,  -0x1.ffff4cp-1, INEXACT) // 6.565354061199747551583194571378e-04
T(RN,    0x1.3ae14b09e695fp-5,    0x1.3af527d47a0e7p-5,   0x1.fffe5cp-2, INEXACT) // 3.843750625601915354989657203078e-02
T(RD,  -0x1.b9c2e585b300dp-18,  -0x1.b9c2e585c0b4dp-18,  -0x1.ffff94p-1, INEXACT) // -6.582756560024477419338240907765e-06
T(RU,  -0x1.b9c2e585b300dp-18,  -0x1.b9c2e585c0b4cp-18,  0x1.b15582p-19, INEXACT) // -6.582756560024477419338240907765e-06
T(RZ,  -0x1.b9c2e585b300dp-18,  -0x1.b9c2e585c0b4cp-18,  0x1.b15582p-19, INEXACT) // -6.582756560024477419338240907765e-06
T(RD,   -0x1.c0826b00636bbp-2,   -0x1.d040352fba9b4p-2,  -0x1.ffff52p-1, INEXACT) // -4.379975050913846312816701811244e-01
T(RU,   -0x1.c0826b00636bbp-2,   -0x1.d040352fba9b3p-2,  0x1.5c2b44p-18, INEXACT) // -4.379975050913846312816701811244e-01
T(RZ,   -0x1.c0826b00636bbp-2,   -0x1.d040352fba9b3p-2,  0x1.5c2b44p-18, INEXACT) // -4.379975050913846312816701811244e-01
T(RN,   0x1.8db9c21822b86p-25,   0x1.8db9c21822b88p-25,  -0x1.ffff4cp-2, INEXACT) // 4.630135580590850785133032489413e-08
T(RD,  -0x1.250c2b09dc554p-25,  -0x1.250c2b09dc556p-25,  -0x1.ffff14p-1, INEXACT) // -3.411522271526881569364260480409e-08
T(RU,  -0x1.250c2b09dc554p-25,  -0x1.250c2b09dc555p-25,  0x1.d7080ap-18, INEXACT) // -3.411522271526881569364260480409e-08
T(RZ,  -0x1.250c2b09dc554p-25,  -0x1.250c2b09dc555p-25,  0x1.d7080ap-18, INEXACT) // -3.411522271526881569364260480409e-08
T(RD,    0x1.df747077e1d9bp-2,    0x1.f2f793038ef82p-2, -0x1.91b9f8p-18, INEXACT) // 4.682176182909302819545871443552e-01
T(RU,    0x1.df747077e1d9bp-2,    0x1.f2f793038ef83p-2,   0x1.ffff38p-1, INEXACT) // 4.682176182909302819545871443552e-01
T(RZ,    0x1.df747077e1d9bp-2,    0x1.f2f793038ef82p-2, -0x1.91b9f8p-18, INEXACT) // 4.682176182909302819545871443552e-01
T(RD,   0x1.e8a4b7569494ap-19,   0x1.e8a4b75699377p-19,  -0x1.ffffc6p-1, INEXACT) // 3.640677202634453751850258235168e-06
T(RU,   0x1.e8a4b7569494ap-19,   0x1.e8a4b75699378p-19,  0x1.d67534p-20, INEXACT) // 3.640677202634453751850258235168e-06
T(RZ,   0x1.e8a4b7569494ap-19,   0x1.e8a4b75699377p-19,  -0x1.ffffc6p-1, INEXACT) // 3.640677202634453751850258235168e-06
T(RN,   0x1.0b92b64b3ac85p-20,   0x1.0b92b64b3af91p-20,   0x1.fffe18p-2, INEXACT) // 9.967874515192363174396388350584e-07
T(RD,  -0x1.943f3c6cda383p-21,  -0x1.943f3c6cda624p-21,  -0x1.ffff02p-1, INEXACT) // -7.529687430066123014172295956070e-07
T(RU,  -0x1.943f3c6cda383p-21,  -0x1.943f3c6cda623p-21,  0x1.fb318cp-18, INEXACT) // -7.529687430066123014172295956070e-07
T(RZ,  -0x1.943f3c6cda383p-21,  -0x1.943f3c6cda623p-21,  0x1.fb318cp-18, INEXACT) // -7.529687430066123014172295956070e-07
T(RN,  -0x1.be03848340344p-18,  -0x1.be0384834e4e8p-18,   -0x1.fffe6p-2, INEXACT) // -6.646122645338079301538872223354e-06
T(RD,   0x1.8dcae84c43cc8p-14,   0x1.8dcae8564516fp-14,  -0x1.ffff32p-1, INEXACT) // 9.484114815826443379426224922213e-05
T(RU,   0x1.8dcae84c43cc8p-14,    0x1.8dcae8564517p-14,   0x1.9bd53p-18, INEXACT) // 9.484114815826443379426224922213e-05
T(RZ,   0x1.8dcae84c43cc8p-14,   0x1.8dcae8564516fp-14,  -0x1.ffff32p-1, INEXACT) // 9.484114815826443379426224922213e-05
T(RN,   -0x1.f8aa66adbfba2p-8,   -0x1.f8abad8fa7533p-8,  -0x1.ffffe6p-2, INEXACT) // -7.700586383861203823575358740072e-03
T(RD,  -0x1.7ee2ba6e18b8ep-21,  -0x1.7ee2ba6e18dc9p-21, -0x1.432eb2p-18, INEXACT) // -7.131801120881598975018633365663e-07
T(RU,  -0x1.7ee2ba6e18b8ep-21,  -0x1.7ee2ba6e18dc8p-21,   0x1.ffff5ep-1, INEXACT) // -7.131801120881598975018633365663e-07
T(RZ,  -0x1.7ee2ba6e18b8ep-21,  -0x1.7ee2ba6e18dc8p-21,   0x1.ffff5ep-1, INEXACT) // -7.131801120881598975018633365663e-07
T(RN,    0x1.ca2ef97dbdaa3p-3,    0x1.ce18296e6185cp-3,  -0x1.fffe38p-2, INEXACT) // 2.237224093912192068867028638124e-01
T(RN,   -0x1.53a0864d469c8p-9,   -0x1.53a09f3566fb2p-9,   0x1.ffff12p-2, INEXACT) // -2.591148752469882993176852892248e-03
T(RN,   -0x1.d9a9f1aeaa4cep-8,   -0x1.d9aafff27e57dp-8,  -0x1.fffefep-2, INEXACT) // -7.227536682571767887028890697820e-03
T(RD,  -0x1.d68de46937277p-10,   -0x1.d68df4f8c0ffp-10, -0x1.a1f9b2p-19, INEXACT) // -1.795022073841993351037138459958e-03
T(RU,  -0x1.d68de46937277p-10,  -0x1.d68df4f8c0fefp-10,   0x1.ffff98p-1, INEXACT) // -1.795022073841993351037138459958e-03
T(RZ,  -0x1.d68de46937277p-10,  -0x1.d68df4f8c0fefp-10,   0x1.ffff98p-1, INEXACT) // -1.795022073841993351037138459958e-03
T(RN,   -0x1.d1047c7b8a958p-8,   -0x1.d1057c372a7c6p-8,  -0x1.fffe32p-2, INEXACT) // -7.095604316001612177355895028086e-03
T(RN,   0x1.7737a290ddbe5p-20,   0x1.7737a290de44ap-20,  -0x1.fffe42p-2, INEXACT) // 1.397793458061388258316317008412e-06
T(RD,  -0x1.0a403a40f0778p-24,  -0x1.0a403a40f077cp-24,  -0x1.ffff4cp-1, INEXACT) // -6.199136583145031000459347289566e-08
T(RU,  -0x1.0a403a40f0778p-24,  -0x1.0a403a40f077bp-24,  0x1.69e33ap-18, INEXACT) // -6.199136583145031000459347289566e-08
T(RZ,  -0x1.0a403a40f0778p-24,  -0x1.0a403a40f077bp-24,  0x1.69e33ap-18, INEXACT) // -6.199136583145031000459347289566e-08
T(RN,   0x1.d38b794b19947p-13,   0x1.d38b798c146acp-13,   0x1.ffff24p-2, INEXACT) // 2.229427430819419335677328275480e-04
T(RD,   0x1.cc94b89ead9d2p-16,   0x1.cc94b89fa6174p-16,  -0x1.ffffbap-1, INEXACT) // 2.745276344270372272842253846825e-05
T(RU,   0x1.cc94b89ead9d2p-16,   0x1.cc94b89fa6175p-16,  0x1.16e408p-19, INEXACT) // 2.745276344270372272842253846825e-05
T(RZ,   0x1.cc94b89ead9d2p-16,   0x1.cc94b89fa6174p-16,  -0x1.ffffbap-1, INEXACT) // 2.745276344270372272842253846825e-05
T(RN,   0x1.184a0e8f5c1edp-24,   0x1.184a0e8f5c1f1p-24,   0x1.ffff6ap-2, INEXACT) // 6.525993455852370730194117855530e-08
T(RN,   0x1.c2256b0ea5f5bp-20,   0x1.c2256b0ea6ddap-20,  -0x1.ffffacp-2, INEXACT) // 1.676925140669700585446875822082e-06
T(RN,   0x1.8843e8960d3cdp-22,   0x1.8843e8960d467p-22,   0x1.ffff48p-2, INEXACT) // 3.653254990771797702858649393304e-07
T(RN,   -0x1.a9032974a6297p-2,   -0x1.b6455e5e3052ep-2,   0x1.fffee2p-2, INEXACT) // -4.150511243292753227329683340940e-01
T(RD,   -0x1.f948cb7f95c13p-3,   -0x1.fe8e69155b1adp-3,  -0x1.ffff94p-1, INEXACT) // -2.467208765326352748470384312895e-01
T(RU,   -0x1.f948cb7f95c13p-3,   -0x1.fe8e69155b1acp-3,  0x1.af23fcp-19, INEXACT) // -2.467208765326352748470384312895e-01
T(RZ,   -0x1.f948cb7f95c13p-3,   -0x1.fe8e69155b1acp-3,  0x1.af23fcp-19, INEXACT) // -2.467208765326352748470384312895e-01
T(RD,   0x1.be373795b42fcp-16,   0x1.be3737969621bp-16,  -0x1.ffffd4p-1, INEXACT) // 2.659652780928870757001097890893e-05
T(RU,   0x1.be373795b42fcp-16,   0x1.be3737969621cp-16,   0x1.60103p-20, INEXACT) // 2.659652780928870757001097890893e-05
T(RZ,   0x1.be373795b42fcp-16,   0x1.be3737969621bp-16,  -0x1.ffffd4p-1, INEXACT) // 2.659652780928870757001097890893e-05
T(RD,   -0x1.86a4aa38442bcp-5,   -0x1.86ca9acbd95c6p-5, -0x1.29fbc4p-18, INEXACT) // -4.768594022801184162396737065137e-02
T(RU,   -0x1.86a4aa38442bcp-5,   -0x1.86ca9acbd95c5p-5,   0x1.ffff6cp-1, INEXACT) // -4.768594022801184162396737065137e-02
T(RZ,   -0x1.86a4aa38442bcp-5,   -0x1.86ca9acbd95c5p-5,   0x1.ffff6cp-1, INEXACT) // -4.768594022801184162396737065137e-02
T(RN,   -0x1.04967dc0f595ap-1,    -0x1.11656c8e5027p-1,  -0x1.ffffeap-2, INEXACT) // -5.089606569334066410448258466204e-01
T(RD,  -0x1.94e366a4f22efp-18,  -0x1.94e366a4fcbbcp-18, -0x1.10b6e4p-18, INEXACT) // -6.033305599958208551047197237827e-06
T(RU,  -0x1.94e366a4f22efp-18,  -0x1.94e366a4fcbbbp-18,   0x1.ffff78p-1, INEXACT) // -6.033305599958208551047197237827e-06
T(RZ,  -0x1.94e366a4f22efp-18,  -0x1.94e366a4fcbbbp-18,   0x1.ffff78p-1, INEXACT) // -6.033305599958208551047197237827e-06
T(RD,  -0x1.ee9b5967f5ef6p-14,  -0x1.ee9b597b31618p-14,  -0x1.ffffa8p-1, INEXACT) // -1.179234583327212792288468667934e-04
T(RU,  -0x1.ee9b5967f5ef6p-14,  -0x1.ee9b597b31617p-14,  0x1.5fe998p-19, INEXACT) // -1.179234583327212792288468667934e-04
T(RZ,  -0x1.ee9b5967f5ef6p-14,  -0x1.ee9b597b31617p-14,  0x1.5fe998p-19, INEXACT) // -1.179234583327212792288468667934e-04
T(RD,  -0x1.41a0c5879861ep-13,  -0x1.41a0c59cbf881p-13,  -0x1.ffff92p-1, INEXACT) // -1.533641882245786818537991447187e-04
T(RU,  -0x1.41a0c5879861ep-13,   -0x1.41a0c59cbf88p-13,  0x1.b99c16p-19, INEXACT) // -1.533641882245786818537991447187e-04
T(RZ,  -0x1.41a0c5879861ep-13,   -0x1.41a0c59cbf88p-13,  0x1.b99c16p-19, INEXACT) // -1.533641882245786818537991447187e-04
T(RD,   0x1.daadd0b6361cdp-24,   0x1.daadd0b6361ddp-24,   -0x1.ffff6p-1, INEXACT) // 1.105198091684769393630552902948e-07
T(RU,   0x1.daadd0b6361cdp-24,   0x1.daadd0b6361dep-24,   0x1.410d8p-18, INEXACT) // 1.105198091684769393630552902948e-07
T(RZ,   0x1.daadd0b6361cdp-24,   0x1.daadd0b6361ddp-24,   -0x1.ffff6p-1, INEXACT) // 1.105198091684769393630552902948e-07
T(RN,    0x1.46814687f579dp-7,    0x1.4682a89fd4ff1p-7,   0x1.ffff4cp-2, INEXACT) // 9.964141310699942480355595364472e-03
T(RD,  -0x1.82a5faae62129p-22,  -0x1.82a5faae621bcp-22,  -0x1.eb506p-19, INEXACT) // -3.600943426986300400378644779448e-07
T(RU,  -0x1.82a5faae62129p-22,  -0x1.82a5faae621bbp-22,   0x1.ffff86p-1, INEXACT) // -3.600943426986300400378644779448e-07
T(RZ,  -0x1.82a5faae62129p-22,  -0x1.82a5faae621bbp-22,   0x1.ffff86p-1, INEXACT) // -3.600943426986300400378644779448e-07
T(RD,   0x1.250bd5500813cp-25,   0x1.250bd5500813cp-25,  -0x1.ffff2ap-1, INEXACT) // 3.411507043548888785308703924110e-08
T(RU,   0x1.250bd5500813cp-25,   0x1.250bd5500813dp-25,  0x1.aba162p-18, INEXACT) // 3.411507043548888785308703924110e-08
T(RZ,   0x1.250bd5500813cp-25,   0x1.250bd5500813cp-25,  -0x1.ffff2ap-1, INEXACT) // 3.411507043548888785308703924110e-08
T(RD,  -0x1.e120e27f50bb9p-18,  -0x1.e120e27f626f6p-18, -0x1.1f02a2p-18, INEXACT) // -7.169372678919360787673595997171e-06
T(RU,  -0x1.e120e27f50bb9p-18,  -0x1.e120e27f626f5p-18,    0x1.ffff7p-1, INEXACT) // -7.169372678919360787673595997171e-06
T(RZ,  -0x1.e120e27f50bb9p-18,  -0x1.e120e27f626f5p-18,    0x1.ffff7p-1, INEXACT) // -7.169372678919360787673595997171e-06
T(RN,  -0x1.127d8a62427c4p-18,  -0x1.127d8a6245c5cp-18,    0x1.fffe7p-2, INEXACT) // -4.090225589567804935367881236097e-06
T(RN,   0x1.8b793ec9c97b9p-15,   0x1.8b793ecc3eac1p-15,   0x1.ffffdap-2, INEXACT) // 4.714412859944901629293337319559e-05
T(RD,  -0x1.af2a62fe28cdap-13,  -0x1.af2a63311ee9dp-13,  -0x1.ffff7ap-1, INEXACT) // -2.055957665493050282208564727426e-04
T(RU,  -0x1.af2a62fe28cdap-13,  -0x1.af2a63311ee9cp-13,  0x1.0d38ecp-18, INEXACT) // -2.055957665493050282208564727426e-04
T(RZ,  -0x1.af2a62fe28cdap-13,  -0x1.af2a63311ee9cp-13,  0x1.0d38ecp-18, INEXACT) // -2.055957665493050282208564727426e-04
T(RD,     0x1.0baf6bf47f03p-8,    0x1.0baf9cbc47533p-8,   -0x1.ffff2p-1, INEXACT) // 4.084552627770007826590870081418e-03
T(RU,     0x1.0baf6bf47f03p-8,    0x1.0baf9cbc47534p-8,  0x1.be4202p-18, INEXACT) // 4.084552627770007826590870081418e-03
T(RZ,     0x1.0baf6bf47f03p-8,    0x1.0baf9cbc47533p-8,   -0x1.ffff2p-1, INEXACT) // 4.084552627770007826590870081418e-03
T(RD,   0x1.a2d93a5ca281dp-17,   0x1.a2d93a5cd1397p-17,  -0x1.ffffbcp-1, INEXACT) // 1.248265942279188550677413577228e-05
T(RU,   0x1.a2d93a5ca281dp-17,   0x1.a2d93a5cd1398p-17,  0x1.10a6e2p-19, INEXACT) // 1.248265942279188550677413577228e-05
T(RZ,   0x1.a2d93a5ca281dp-17,   0x1.a2d93a5cd1397p-17,  -0x1.ffffbcp-1, INEXACT) // 1.248265942279188550677413577228e-05
T(RN,   0x1.4c846eb56766ap-22,   0x1.4c846eb5676c8p-22,   0x1.fffffap-2, INEXACT) // 3.096808812388335098846081118451e-07
T(RN,   -0x1.0d97590fa9ac1p-1,   -0x1.1beb9786564d8p-1,   -0x1.ffff9p-2, INEXACT) // -5.265453178042990289853264584963e-01
T(RN,   -0x1.46bca7b648647p-3,   -0x1.48239d533a547p-3,   0x1.ffff4cp-2, INEXACT) // -1.595395185950556349308016024224e-01
T(RD,  -0x1.f5846e95fb581p-10,  -0x1.f58482a2b2da9p-10,  -0x1.ffffd8p-1, INEXACT) // -1.913136720300329324598309632677e-03
T(RU,  -0x1.f5846e95fb581p-10,  -0x1.f58482a2b2da8p-10,  0x1.3fc2cep-20, INEXACT) // -1.913136720300329324598309632677e-03
T(RZ,  -0x1.f5846e95fb581p-10,  -0x1.f58482a2b2da8p-10,  0x1.3fc2cep-20, INEXACT) // -1.913136720300329324598309632677e-03
T(RN,   -0x1.32e2defd73509p-2,   -0x1.37ad25d1ab666p-2,  -0x1.ffff0ep-2, INEXACT) // -2.996935693925740218368503064994e-01
T(RD,     0x1.daadd38551cp-23,   0x1.daadd38551c43p-23,  -0x1.ffffe8p-1, INEXACT) // 2.210396382962092048235502872444e-07
T(RU,     0x1.daadd38551cp-23,   0x1.daadd38551c44p-23,   0x1.8030dp-21, INEXACT) // 2.210396382962092048235502872444e-07
T(RZ,     0x1.daadd38551cp-23,   0x1.daadd38551c43p-23,  -0x1.ffffe8p-1, INEXACT) // 2.210396382962092048235502872444e-07
T(RD,  -0x1.a6a5897896b45p-25,  -0x1.a6a5897896b48p-25, -0x1.511058p-20, INEXACT) // -4.920254332150187405738617240671e-08
T(RU,  -0x1.a6a5897896b45p-25,  -0x1.a6a5897896b47p-25,   0x1.ffffd6p-1, INEXACT) // -4.920254332150187405738617240671e-08
T(RZ,  -0x1.a6a5897896b45p-25,  -0x1.a6a5897896b47p-25,   0x1.ffffd6p-1, INEXACT) // -4.920254332150187405738617240671e-08
T(RD,    0x1.671f0921ae6fdp-1,    0x1.8e03b16329bbap-1, -0x1.0b07e4p-19, INEXACT) // 7.014086583724005175000115741568e-01
T(RU,    0x1.671f0921ae6fdp-1,    0x1.8e03b16329bbbp-1,   0x1.ffffbep-1, INEXACT) // 7.014086583724005175000115741568e-01
T(RZ,    0x1.671f0921ae6fdp-1,    0x1.8e03b16329bbap-1, -0x1.0b07e4p-19, INEXACT) // 7.014086583724005175000115741568e-01
T(RN,  -0x1.f0e451092da15p-24,  -0x1.f0e451092da28p-24,   0x1.fffe8ap-2, INEXACT) // -1.156916519415052508253183923166e-07
T(RD,    0x1.0402811c6084p-19,   0x1.0402811c6136cp-19,  -0x1.ffff98p-1, INEXACT) // 1.937223841065100664662890217471e-06
T(RU,    0x1.0402811c6084p-19,   0x1.0402811c6136dp-19,  0x1.a0b692p-19, INEXACT) // 1.937223841065100664662890217471e-06
T(RZ,    0x1.0402811c6084p-19,   0x1.0402811c6136cp-19,  -0x1.ffff98p-1, INEXACT) // 1.937223841065100664662890217471e-06
T(RD,   -0x1.5bff8f9c45675p-3,   -0x1.5db1ef72127afp-3,  -0x1.ffffeep-1, INEXACT) // -1.699210376324803706271637793179e-01
T(RU,   -0x1.5bff8f9c45675p-3,   -0x1.5db1ef72127aep-3,  0x1.280ee6p-21, INEXACT) // -1.699210376324803706271637793179e-01
T(RZ,   -0x1.5bff8f9c45675p-3,   -0x1.5db1ef72127aep-3,  0x1.280ee6p-21, INEXACT) // -1.699210376324803706271637793179e-01
T(RD,   0x1.15c68be91c7c3p-17,   0x1.15c68be92a1cap-17, -0x1.bcb64ap-21, INEXACT) // 8.278357159083906592774403099266e-06
T(RU,   0x1.15c68be91c7c3p-17,   0x1.15c68be92a1cbp-17,   0x1.ffffe4p-1, INEXACT) // 8.278357159083906592774403099266e-06
T(RZ,   0x1.15c68be91c7c3p-17,   0x1.15c68be92a1cap-17, -0x1.bcb64ap-21, INEXACT) // 8.278357159083906592774403099266e-06
T(RD,   0x1.4e8add4a28e89p-17,   0x1.4e8add4a40b69p-17, -0x1.fbe9aep-18, INEXACT) // 9.970141622801162778933110886204e-06
T(RU,   0x1.4e8add4a28e89p-17,   0x1.4e8add4a40b6ap-17,   0x1.ffff02p-1, INEXACT) // 9.970141622801162778933110886204e-06
T(RZ,   0x1.4e8add4a28e89p-17,   0x1.4e8add4a40b69p-17, -0x1.fbe9aep-18, INEXACT) // 9.970141622801162778933110886204e-06
T(RD,   -0x1.62b51c5b9521bp-5,   -0x1.62d1823962ec5p-5,  -0x1.ffff2cp-1, INEXACT) // -4.329925097104966175143303530604e-02
T(RU,   -0x1.62b51c5b9521bp-5,   -0x1.62d1823962ec4p-5,  0x1.a9d128p-18, INEXACT) // -4.329925097104966175143303530604e-02
T(RZ,   -0x1.62b51c5b9521bp-5,   -0x1.62d1823962ec4p-5,  0x1.a9d128p-18, INEXACT) // -4.329925097104966175143303530604e-02
T(RN,  -0x1.52329da77ac58p-15,  -0x1.52329da904449p-15,   0x1.fffeb8p-2, INEXACT) // -4.031630970387976809973795688791e-05
T(RN,   0x1.45dd7e3a2387dp-24,   0x1.45dd7e3a23883p-24,   0x1.ffff94p-2, INEXACT) // 7.587140596536078146885294067395e-08
T(RD,   -0x1.fef02f52e808dp-2,   -0x1.0b7842a563141p-1, -0x1.d81d0ep-18, INEXACT) // -4.989631075241128255193245877308e-01
T(RU,   -0x1.fef02f52e808dp-2,    -0x1.0b7842a56314p-1,   0x1.ffff14p-1, INEXACT) // -4.989631075241128255193245877308e-01
T(RZ,   -0x1.fef02f52e808dp-2,    -0x1.0b7842a56314p-1,   0x1.ffff14p-1, INEXACT) // -4.989631075241128255193245877308e-01
T(RD,  -0x1.5ce31b1a8b94fp-23,  -0x1.5ce31b1a8b96ap-23, -0x1.4f0bb6p-18, INEXACT) // -1.624632311610152800545047195244e-07
T(RU,  -0x1.5ce31b1a8b94fp-23,  -0x1.5ce31b1a8b969p-23,   0x1.ffff58p-1, INEXACT) // -1.624632311610152800545047195244e-07
T(RZ,  -0x1.5ce31b1a8b94fp-23,  -0x1.5ce31b1a8b969p-23,   0x1.ffff58p-1, INEXACT) // -1.624632311610152800545047195244e-07
T(RN,   -0x1.afcac96802aafp-5,   -0x1.affe08e1e9366p-5,  -0x1.ffff42p-2, INEXACT) // -5.270900094190743984112756947980e-02
T(RD,    0x1.76ae79ee7ed7ap-4,    0x1.7734c068c54a5p-4, -0x1.35be4cp-20, INEXACT) // 9.147498731174677488731106222986e-02
T(RU,    0x1.76ae79ee7ed7ap-4,    0x1.7734c068c54a6p-4,   0x1.ffffdap-1, INEXACT) // 9.147498731174677488731106222986e-02
T(RZ,    0x1.76ae79ee7ed7ap-4,    0x1.7734c068c54a5p-4, -0x1.35be4cp-20, INEXACT) // 9.147498731174677488731106222986e-02
T(RN,  -0x1.11f1387a03f08p-20,  -0x1.11f1387a0424cp-20,   0x1.fffeb8p-2, INEXACT) // -1.020514473374453887359776527166e-06
T(RD,  -0x1.aabe8352e81b7p-11,  -0x1.aabe8669760ccp-11, -0x1.516712p-18, INEXACT) // -8.139499499187273457920244190689e-04
T(RU,  -0x1.aabe8352e81b7p-11,  -0x1.aabe8669760cbp-11,   0x1.ffff58p-1, INEXACT) // -8.139499499187273457920244190689e-04
T(RZ,  -0x1.aabe8352e81b7p-11,  -0x1.aabe8669760cbp-11,   0x1.ffff58p-1, INEXACT) // -8.139499499187273457920244190689e-04
T(RD,   0x1.7872063f8a7bep-14,   0x1.787206480528ap-14,  -0x1.ffff1ep-1, INEXACT) // 8.975157924653775413752210265983e-05
T(RU,   0x1.7872063f8a7bep-14,   0x1.787206480528bp-14,  0x1.c56aa8p-18, INEXACT) // 8.975157924653775413752210265983e-05
T(RZ,   0x1.7872063f8a7bep-14,   0x1.787206480528ap-14,  -0x1.ffff1ep-1, INEXACT) // 8.975157924653775413752210265983e-05
T(RD,    0x1.87339cbea1283p-8,    0x1.873435007579ap-8,  -0x1.ffff54p-1, INEXACT) // 5.969262855277992878277881771965e-03
T(RU,    0x1.87339cbea1283p-8,    0x1.873435007579bp-8,  0x1.591178p-18, INEXACT) // 5.969262855277992878277881771965e-03
T(RZ,    0x1.87339cbea1283p-8,    0x1.873435007579ap-8,  -0x1.ffff54p-1, INEXACT) // 5.969262855277992878277881771965e-03
T(RD,    -0x1.efba87f22da8p-1,   -0x1.5169481f5c578p+0, -0x1.f40ef6p-18, INEXACT) // -9.682199938896047797243227250874e-01
T(RU,    -0x1.efba87f22da8p-1,   -0x1.5169481f5c577p+0,   0x1.ffff06p-1, INEXACT) // -9.682199938896047797243227250874e-01
T(RZ,    -0x1.efba87f22da8p-1,   -0x1.5169481f5c577p+0,   0x1.ffff06p-1, INEXACT) // -9.682199938896047797243227250874e-01
T(RN,  -0x1.3b044b75a304bp-11,  -0x1.3b044cb3a38b9p-11,  -0x1.fffeb4p-2, INEXACT) // -6.008468178193641364912003233201e-04
T(RN,   0x1.a09c00a1d8d4cp-14,   0x1.a09c00ad570e8p-14,   0x1.ffffb8p-2, INEXACT) // 9.932741752787416526435104735526e-05
T(RD,    0x1.d17fb957b16e3p-6,    0x1.d18fc3303ecb8p-6,  -0x1.a106ep-19, INEXACT) // 2.841179942949779643757146629923e-02
T(RU,    0x1.d17fb957b16e3p-6,    0x1.d18fc3303ecb9p-6,   0x1.ffff98p-1, INEXACT) // 2.841179942949779643757146629923e-02
T(RZ,    0x1.d17fb957b16e3p-6,    0x1.d18fc3303ecb8p-6,  -0x1.a106ep-19, INEXACT) // 2.841179942949779643757146629923e-02
T(RN,   -0x1.c71911fdca4abp-4,   -0x1.c80a1ec9b842cp-4,   -0x1.ffff9p-2, INEXACT) // -1.111078932559787374456661268596e-01
T(RD,   0x1.c4193409bc8c2p-22,   0x1.c4193409bc9adp-22, -0x1.abc55cp-18, INEXACT) // 4.210494927013038256489942286198e-07
T(RU,   0x1.c4193409bc8c2p-22,   0x1.c4193409bc9aep-22,   0x1.ffff2ap-1, INEXACT) // 4.210494927013038256489942286198e-07
T(RZ,   0x1.c4193409bc8c2p-22,   0x1.c4193409bc9adp-22, -0x1.abc55cp-18, INEXACT) // 4.210494927013038256489942286198e-07
T(RN,  -0x1.f831425419746p-18,  -0x1.f83142542dd3bp-18,  -0x1.ffff1cp-2, INEXACT) // -7.513052498441858510227174539065e-06
T(RN,   0x1.2aec4e73356cbp-18,   0x1.2aec4e7339ab9p-18,    0x1.ffffbp-2, INEXACT) // 4.454300881214736386969326592533e-06
T(RN,   -0x1.bcee6f3be184p-25,  -0x1.bcee6f3be1843p-25,   0x1.ffffd8p-2, INEXACT) // -5.179683035178656309968810156352e-08
T(RD,   0x1.157cc1ffdf238p-12,   0x1.157cc236357f1p-12, -0x1.7e0874p-22, INEXACT) // 2.646325447057981498921730434404e-04
T(RU,   0x1.157cc1ffdf238p-12,   0x1.157cc236357f2p-12,   0x1.fffff4p-1, INEXACT) // 2.646325447057981498921730434404e-04
T(RZ,   0x1.157cc1ffdf238p-12,   0x1.157cc236357f1p-12, -0x1.7e0874p-22, INEXACT) // 2.646325447057981498921730434404e-04
T(RD,    0x1.ec56824dc249p-21,   0x1.ec56824dc294dp-21,  -0x1.ffff72p-1, INEXACT) // 9.170508492316516315325317099116e-07
T(RU,    0x1.ec56824dc249p-21,   0x1.ec56824dc294ep-21,  0x1.1b68cap-18, INEXACT) // 9.170508492316516315325317099116e-07
T(RZ,    0x1.ec56824dc249p-21,   0x1.ec56824dc294dp-21,  -0x1.ffff72p-1, INEXACT) // 9.170508492316516315325317099116e-07
T(RN,    0x1.c7311f11d3b48p-4,    0x1.c822523bf5a3ep-4,  -0x1.fffe62p-2, INEXACT) // 1.111308301599197578823918775015e-01
T(RD,   0x1.88aa3660c4b8ap-11,   0x1.88aa38c8a5a6ep-11,  -0x1.ffff46p-1, INEXACT) // 7.489488453721198941287484629470e-04
T(RU,   0x1.88aa3660c4b8ap-11,   0x1.88aa38c8a5a6fp-11,  0x1.7219dap-18, INEXACT) // 7.489488453721198941287484629470e-04
T(RZ,   0x1.88aa3660c4b8ap-11,   0x1.88aa38c8a5a6ep-11,  -0x1.ffff46p-1, INEXACT) // 7.489488453721198941287484629470e-04
T(RN,   0x1.e3cf519b30fb7p-25,   0x1.e3cf519b30fbcp-25,   0x1.fffedcp-2, INEXACT) // 5.632287810580322456720863094452e-08
T(RD,   0x1.d4f7bd50e6064p-13,   0x1.d4f7bd927933cp-13,  -0x1.3de78p-19, INEXACT) // 2.236212408461862215583448865175e-04
T(RU,   0x1.d4f7bd50e6064p-13,   0x1.d4f7bd927933dp-13,    0x1.ffffbp-1, INEXACT) // 2.236212408461862215583448865175e-04
T(RZ,   0x1.d4f7bd50e6064p-13,   0x1.d4f7bd927933cp-13,  -0x1.3de78p-19, INEXACT) // 2.236212408461862215583448865175e-04
T(RN,   -0x1.5f833a5db8073p-1,   -0x1.837234fe7c956p-1,  -0x1.ffff68p-2, INEXACT) // -6.865480651286034463609553313290e-01
T(RN,  -0x1.abd6c38ebb11cp-13,  -0x1.abd6c3c085882p-13,    0x1.fffe3p-2, INEXACT) // -2.040094954830561730860227775963e-04
T(RD,   0x1.d2cd307cafbf3p-17,   0x1.d2cd307cf06acp-17,  -0x1.fffff4p-1, INEXACT) // 1.391176942300111647862672498155e-05
T(RU,   0x1.d2cd307cafbf3p-17,   0x1.d2cd307cf06adp-17,  0x1.946c26p-22, INEXACT) // 1.391176942300111647862672498155e-05
T(RZ,   0x1.d2cd307cafbf3p-17,   0x1.d2cd307cf06acp-17,  -0x1.fffff4p-1, INEXACT) // 1.391176942300111647862672498155e-05
T(RD,   0x1.d12ebb1beb2c5p-26,   0x1.d12ebb1beb2c5p-26,  -0x1.ffffb8p-1, INEXACT) // 2.707718770005947442714698558414e-08
T(RU,   0x1.d12ebb1beb2c5p-26,   0x1.d12ebb1beb2c6p-26,  0x1.1cf48cp-19, INEXACT) // 2.707718770005947442714698558414e-08
T(RZ,   0x1.d12ebb1beb2c5p-26,   0x1.d12ebb1beb2c5p-26,  -0x1.ffffb8p-1, INEXACT) // 2.707718770005947442714698558414e-08
T(RD,   -0x1.803c6d9aec528p-5,   -0x1.806087c378e16p-5,  -0x1.ffffccp-1, INEXACT) // -4.690381438502760902409249865741e-02
T(RU,   -0x1.803c6d9aec528p-5,   -0x1.806087c378e15p-5,   0x1.9af18p-20, INEXACT) // -4.690381438502760902409249865741e-02
T(RZ,   -0x1.803c6d9aec528p-5,   -0x1.806087c378e15p-5,   0x1.9af18p-20, INEXACT) // -4.690381438502760902409249865741e-02
T(RN,  -0x1.cf0d9c34bec16p-22,  -0x1.cf0d9c34bed13p-22,  -0x1.fffef6p-2, INEXACT) // -4.312518655927376580913579738608e-07
T(RN,   0x1.f35ef934ee55fp-15,   0x1.f35ef939e11bcp-15,  -0x1.ffffa6p-2, INEXACT) // 5.952966095130562111268843206169e-05
T(RN,  -0x1.01a7eb87b57eep-22,  -0x1.01a7eb87b581ap-22,  -0x1.ffff46p-2, INEXACT) // -2.399607912211813692183906381039e-07
T(RN,   0x1.3fbe3d95f67f6p-19,   0x1.3fbe3d95f7cbfp-19,   0x1.ffff8ap-2, INEXACT) // 2.382271939699478963462214026192e-06
T(RN,   0x1.eaf951c10bf8fp-10,   0x1.eaf96490ce30ap-10,   0x1.ffffa4p-2, INEXACT) // 1.872916808007805055877326161351e-03
T(RN,  -0x1.be24c82c96a77p-19,  -0x1.be24c82c9a2edp-19,  -0x1.fffec8p-2, INEXACT) // -3.324029441293282435718149311898e-06
T(RN,  -0x1.e5ca637e77cfep-10,  -0x1.e5ca75b74ed2cp-10,  -0x1.fffeaap-2, INEXACT) // -1.853143999703210208912507184209e-03
T(RD,    0x1.64e2de58e16e4p-4,    0x1.6556dd8648ef5p-4,  -0x1.ffffc6p-1, INEXACT) // 8.713042120333686080257962203177e-02
T(RU,    0x1.64e2de58e16e4p-4,    0x1.6556dd8648ef6p-4,  0x1.d480bcp-20, INEXACT) // 8.713042120333686080257962203177e-02
T(RZ,    0x1.64e2de58e16e4p-4,    0x1.6556dd8648ef5p-4,  -0x1.ffffc6p-1, INEXACT) // 8.713042120333686080257962203177e-02
T(RN,  -0x1.a7be963618f0cp-22,  -0x1.a7be963618fcep-22,  -0x1.fffedep-2, INEXACT) // -3.946427996669123779686525962940e-07
T(RD,    0x1.c2a6a49b2b79p-20,   0x1.c2a6a49b2c61bp-20,  -0x1.ffffbep-1, INEXACT) // 1.678805609011083680099166159927e-06
T(RU,    0x1.c2a6a49b2b79p-20,   0x1.c2a6a49b2c61cp-20,  0x1.0b3da6p-19, INEXACT) // 1.678805609011083680099166159927e-06
T(RZ,    0x1.c2a6a49b2b79p-20,   0x1.c2a6a49b2c61bp-20,  -0x1.ffffbep-1, INEXACT) // 1.678805609011083680099166159927e-06
T(RN,   0x1.3d0e6c2480fb5p-19,   0x1.3d0e6c24823f8p-19,  -0x1.fffe04p-2, INEXACT) // 2.362253797240680841274538051544e-06
T(RN,   -0x1.e672265b6e872p-9,   -0x1.e6726f8a7e3f3p-9,  -0x1.fffeb2p-2, INEXACT) // -3.711287672300272490188977059233e-03
T(RD,  -0x1.4f7479bad88e8p-24,  -0x1.4f7479bad88efp-24,  -0x1.ffff68p-1, INEXACT) // -7.810419948081521148488268538324e-08
T(RU,  -0x1.4f7479bad88e8p-24,  -0x1.4f7479bad88eep-24,  0x1.2e7356p-18, INEXACT) // -7.810419948081521148488268538324e-08
T(RZ,  -0x1.4f7479bad88e8p-24,  -0x1.4f7479bad88eep-24,  0x1.2e7356p-18, INEXACT) // -7.810419948081521148488268538324e-08
T(RN,    0x1.9a3c8b30272aap-9,    0x1.9a3cb7153c7aep-9,   0x1.fffe46p-2, INEXACT) // 3.129856100782942192328750508068e-03
T(RD,   -0x1.32991bf38d69bp-4,   -0x1.32e2970f23d67p-4, -0x1.2e9ccap-19, INEXACT) // -7.485304754740200461338162085667e-02
T(RU,   -0x1.32991bf38d69bp-4,   -0x1.32e2970f23d66p-4,   0x1.ffffb4p-1, INEXACT) // -7.485304754740200461338162085667e-02
T(RZ,   -0x1.32991bf38d69bp-4,   -0x1.32e2970f23d66p-4,   0x1.ffffb4p-1, INEXACT) // -7.485304754740200461338162085667e-02
T(RD,    0x1.2a73ee14bb3dap-6,    0x1.2a7827f7231b5p-6,  -0x1.ffffe6p-1, INEXACT) // 1.821611642928986501965837874195e-02
T(RU,    0x1.2a73ee14bb3dap-6,    0x1.2a7827f7231b6p-6,   0x1.a33bdp-21, INEXACT) // 1.821611642928986501965837874195e-02
T(RZ,    0x1.2a73ee14bb3dap-6,    0x1.2a7827f7231b5p-6,  -0x1.ffffe6p-1, INEXACT) // 1.821611642928986501965837874195e-02
T(RD,   -0x1.d8aae30eced5ep-4,    -0x1.d9b910df62e7p-4, -0x1.bf9db6p-20, INEXACT) // -1.153973454901708606268329049271e-01
T(RU,   -0x1.d8aae30eced5ep-4,   -0x1.d9b910df62e6fp-4,   0x1.ffffc8p-1, INEXACT) // -1.153973454901708606268329049271e-01
T(RZ,   -0x1.d8aae30eced5ep-4,   -0x1.d9b910df62e6fp-4,   0x1.ffffc8p-1, INEXACT) // -1.153973454901708606268329049271e-01
T(RN,  -0x1.6758b70372124p-13,  -0x1.6758b720f28b7p-13,   0x1.ffffbep-2, INEXACT) // -1.713497841662271802334882586649e-04
T(RD,  -0x1.22a4710aa7e28p-20,   -0x1.22a4710aa821p-20,  -0x1.ffff66p-1, INEXACT) // -1.082727126323801384471558206801e-06
T(RU,  -0x1.22a4710aa7e28p-20,  -0x1.22a4710aa820fp-20,  0x1.3481bap-18, INEXACT) // -1.082727126323801384471558206801e-06
T(RZ,  -0x1.22a4710aa7e28p-20,  -0x1.22a4710aa820fp-20,  0x1.3481bap-18, INEXACT) // -1.082727126323801384471558206801e-06
T(RD,   0x1.6d1229dca96d3p-15,   0x1.6d1229de98603p-15, -0x1.3c9b6ap-18, INEXACT) // 4.351984873566879002048865543451e-05
T(RU,   0x1.6d1229dca96d3p-15,   0x1.6d1229de98604p-15,   0x1.ffff62p-1, INEXACT) // 4.351984873566879002048865543451e-05
T(RZ,   0x1.6d1229dca96d3p-15,   0x1.6d1229de98603p-15, -0x1.3c9b6ap-18, INEXACT) // 4.351984873566879002048865543451e-05
T(RN,  -0x1.42f5599d8c8e8p-18,  -0x1.42f5599d91e93p-18,  -0x1.ffff88p-2, INEXACT) // -4.812455157531524976236708690536e-06
T(RN,   0x1.dcb8eeb71651bp-17,   0x1.dcb8eeb75b338p-17,   0x1.fffe66p-2, INEXACT) // 1.420743443085680715457560369108e-05
T(RN,    0x1.fd77982075baap-8,    0x1.fd78e86dba496p-8,  -0x1.ffffe2p-2, INEXACT) // 7.773852005320694771861589345008e-03
T(RD,  -0x1.250c0ea0d286fp-25,  -0x1.250c0ea0d2871p-25,  -0x1.ffffaap-1, INEXACT) // -3.411517224842766290194507531990e-08
T(RU,  -0x1.250c0ea0d286fp-25,   -0x1.250c0ea0d287p-25,  0x1.5a6992p-19, INEXACT) // -3.411517224842766290194507531990e-08
T(RZ,  -0x1.250c0ea0d286fp-25,   -0x1.250c0ea0d287p-25,  0x1.5a6992p-19, INEXACT) // -3.411517224842766290194507531990e-08
T(RN,    0x1.3b7f6461ef365p-7,    0x1.3b80a3db38805p-7,   0x1.fffe84p-2, INEXACT) // 9.628223433418356749791122695115e-03
T(RD,    0x1.749edfc16759ap-1,     0x1.a1510c11b487p-1,  -0x1.ffffd2p-1, INEXACT) // 7.277746127689852517761437411536e-01
T(RU,    0x1.749edfc16759ap-1,    0x1.a1510c11b4871p-1,  0x1.6e8298p-20, INEXACT) // 7.277746127689852517761437411536e-01
T(RZ,    0x1.749edfc16759ap-1,     0x1.a1510c11b487p-1,  -0x1.ffffd2p-1, INEXACT) // 7.277746127689852517761437411536e-01
T(RN,  -0x1.51c4b772b5345p-23,  -0x1.51c4b772b535dp-23,   0x1.fffe52p-2, INEXACT) // -1.572856792227913934446257302260e-07
T(RD,   0x1.a8af59a19979dp-16,   0x1.a8af59a25c446p-16, -0x1.78327cp-21, INEXACT) // 2.531319626655031726600482422374e-05
T(RU,   0x1.a8af59a19979dp-16,   0x1.a8af59a25c447p-16,   0x1.ffffe8p-1, INEXACT) // 2.531319626655031726600482422374e-05
T(RZ,   0x1.a8af59a19979dp-16,   0x1.a8af59a25c446p-16, -0x1.78327cp-21, INEXACT) // 2.531319626655031726600482422374e-05
T(RD,   -0x1.ab5bf45b11c98p-8,   -0x1.ab5cbada937b8p-8, -0x1.57df5ap-19, INEXACT) // -6.520983845866322459183805904104e-03
T(RU,   -0x1.ab5bf45b11c98p-8,   -0x1.ab5cbada937b7p-8,   0x1.ffffaap-1, INEXACT) // -6.520983845866322459183805904104e-03
T(RZ,   -0x1.ab5bf45b11c98p-8,   -0x1.ab5cbada937b7p-8,   0x1.ffffaap-1, INEXACT) // -6.520983845866322459183805904104e-03
T(RD,  -0x1.9723913279eb8p-12,  -0x1.972391de1b8f3p-12,  -0x1.0042dp-23, INEXACT) // -3.882779448347406341113252636887e-04
T(RU,  -0x1.9723913279eb8p-12,  -0x1.972391de1b8f2p-12,   0x1.fffffcp-1, INEXACT) // -3.882779448347406341113252636887e-04
T(RZ,  -0x1.9723913279eb8p-12,  -0x1.972391de1b8f2p-12,   0x1.fffffcp-1, INEXACT) // -3.882779448347406341113252636887e-04
T(RN,   0x1.88e26a9b846cap-17,   0x1.88e26a9baafb3p-17,  -0x1.fffe46p-2, INEXACT) // 1.170886871818283212214224786596e-05
T(RD,   0x1.af8c06caacaebp-15,   0x1.af8c06cdde3adp-15,  -0x1.ffffbep-1, INEXACT) // 5.144440873063544841922375971954e-05
T(RU,   0x1.af8c06caacaebp-15,   0x1.af8c06cdde3aep-15,  0x1.08f742p-19, INEXACT) // 5.144440873063544841922375971954e-05
T(RZ,   0x1.af8c06caacaebp-15,   0x1.af8c06cdde3adp-15,  -0x1.ffffbep-1, INEXACT) // 5.144440873063544841922375971954e-05
T(RD,    0x1.d1417b4d96f48p-8,    0x1.d1427b6de635ap-8,  -0x1.ffff52p-1, INEXACT) // 7.099239924709462024043915562288e-03
T(RU,    0x1.d1417b4d96f48p-8,    0x1.d1427b6de635bp-8,  0x1.5c8f1cp-18, INEXACT) // 7.099239924709462024043915562288e-03
T(RZ,    0x1.d1417b4d96f48p-8,    0x1.d1427b6de635ap-8,  -0x1.ffff52p-1, INEXACT) // 7.099239924709462024043915562288e-03
T(RD,    0x1.f61f6d76e0fdap-8,    0x1.f620af6e2d5acp-8, -0x1.c71d78p-19, INEXACT) // 7.661785340022897808354152004995e-03
T(RU,    0x1.f61f6d76e0fdap-8,    0x1.f620af6e2d5adp-8,   0x1.ffff8ep-1, INEXACT) // 7.661785340022897808354152004995e-03
T(RZ,    0x1.f61f6d76e0fdap-8,    0x1.f620af6e2d5acp-8, -0x1.c71d78p-19, INEXACT) // 7.661785340022897808354152004995e-03
T(RN,    0x1.2dd66d998d63p-17,   0x1.2dd66d999edecp-17,  -0x1.fffe58p-2, INEXACT) // 8.995461757792163606448077040056e-06
T(RN,   0x1.6655e710c75c5p-15,   0x1.6655e7129b6aep-15,   0x1.fffef6p-2, INEXACT) // 4.271692717437327024019091958884e-05
T(RN,    0x1.ca6e4deb56aa4p-9,    0x1.ca6e8b2c4d865p-9,   0x1.fffefap-2, INEXACT) // 3.497550021774502651550342591236e-03
T(RN,    0x1.f1caf387a9e34p-8,    0x1.f1cc2d3cf6788p-8,   -0x1.fffeap-2, INEXACT) // 7.595715003538883874911746829639e-03
T(RN,  -0x1.6bbd609b19ee8p-11,  -0x1.6bbd6284a7eebp-11,  -0x1.ffffe8p-2, INEXACT) // -6.937785250444557585969285185001e-04
T(RD,  -0x1.3bacd9d83ff94p-24,  -0x1.3bacd9d83ff9ap-24,  -0x1.ffffaap-1, INEXACT) // -7.349885977961236054286958858939e-08
T(RU,  -0x1.3bacd9d83ff94p-24,  -0x1.3bacd9d83ff99p-24,  0x1.556944p-19, INEXACT) // -7.349885977961236054286958858939e-08
T(RZ,  -0x1.3bacd9d83ff94p-24,  -0x1.3bacd9d83ff99p-24,  0x1.556944p-19, INEXACT) // -7.349885977961236054286958858939e-08
T(RN,  -0x1.48ec189e7d614p-22,  -0x1.48ec189e7d66ep-22,   0x1.fffffap-2, INEXACT) // -3.063327173308130850346757759195e-07
T(RN,  -0x1.4f748e6232529p-25,  -0x1.4f748e623252bp-25,  -0x1.fffe98p-2, INEXACT) // -3.905213642877278445839065346319e-08
T(RN,   -0x1.660388ea1ff32p-1,   -0x1.8c76888648366p-1,   0x1.fffe62p-2, INEXACT) // -6.992457185551528286993061556132e-01
T(RN,   -0x1.cf706f49fd29ap-4,   -0x1.d06f0944126ddp-4,   0x1.fffffcp-2, INEXACT) // -1.131443354823410685217055515750e-01
T(RN,   -0x1.c88540d938acp-11,  -0x1.c88544a1134eep-11,  -0x1.ffff82p-2, INEXACT) // -8.707437911222512538778062207712e-04
T(RN,    0x1.6272a7f08ed43p-5,    0x1.628efdd902154p-5,  -0x1.fffe98p-2, INEXACT) // 4.326756287306434550776756964297e-02
T(RN,  -0x1.8d9992aa606bfp-17,  -0x1.8d9992aa88623p-17,   0x1.fffeb2p-2, INEXACT) // -1.184940022791751167749018519570e-05
T(RD,   0x1.e4ed4ae0abf5fp-10,   0x1.e4ed5d00ad017p-10, -0x1.4183f6p-19, INEXACT) // 1.849849410216784567281833595587e-03
T(RU,   0x1.e4ed4ae0abf5fp-10,   0x1.e4ed5d00ad018p-10,    0x1.ffffbp-1, INEXACT) // 1.849849410216784567281833595587e-03
T(RZ,   0x1.e4ed4ae0abf5fp-10,   0x1.e4ed5d00ad017p-10, -0x1.4183f6p-19, INEXACT) // 1.849849410216784567281833595587e-03
T(RD,   0x1.250bee2252b55p-25,   0x1.250bee2252b55p-25,  -0x1.ffffacp-1, INEXACT) // 3.411511452724363339378193062980e-08
T(RU,   0x1.250bee2252b55p-25,   0x1.250bee2252b56p-25,  0x1.4edb84p-19, INEXACT) // 3.411511452724363339378193062980e-08
T(RZ,   0x1.250bee2252b55p-25,   0x1.250bee2252b55p-25,  -0x1.ffffacp-1, INEXACT) // 3.411511452724363339378193062980e-08
T(RD,   -0x1.0d5dfa1e43584p-5,   -0x1.0d6a68cdee9c9p-5,   -0x1.ffffdp-1, INEXACT) // -3.288172579969297903978997510421e-02
T(RU,   -0x1.0d5dfa1e43584p-5,   -0x1.0d6a68cdee9c8p-5,  0x1.82399ap-20, INEXACT) // -3.288172579969297903978997510421e-02
T(RZ,   -0x1.0d5dfa1e43584p-5,   -0x1.0d6a68cdee9c8p-5,  0x1.82399ap-20, INEXACT) // -3.288172579969297903978997510421e-02
T(RD,  -0x1.c81246e8f1b7bp-21,   -0x1.c81246e8f1f4p-21, -0x1.82c2dcp-18, INEXACT) // -8.494991706680342756570121186266e-07
T(RU,  -0x1.c81246e8f1b7bp-21,  -0x1.c81246e8f1f3fp-21,   0x1.ffff3ep-1, INEXACT) // -8.494991706680342756570121186266e-07
T(RZ,  -0x1.c81246e8f1b7bp-21,  -0x1.c81246e8f1f3fp-21,   0x1.ffff3ep-1, INEXACT) // -8.494991706680342756570121186266e-07
T(RN,  -0x1.9622135ce4afcp-10,  -0x1.96221e02b23cdp-10,   -0x1.fffe5p-2, INEXACT) // -1.549274856391390751964021177400e-03
T(RN,  -0x1.8c50563705b22p-11,  -0x1.8c5058b03b016p-11,   0x1.fffedep-2, INEXACT) // -7.559086142262287037058010596979e-04
T(RD,  -0x1.31e757b2c0c4ap-16,  -0x1.31e757b309912p-16,  -0x1.ffff7cp-1, INEXACT) // -1.823328029627546790223183159618e-05
T(RU,  -0x1.31e757b2c0c4ap-16,  -0x1.31e757b309911p-16,  0x1.09c164p-18, INEXACT) // -1.823328029627546790223183159618e-05
T(RZ,  -0x1.31e757b2c0c4ap-16,  -0x1.31e757b309911p-16,  0x1.09c164p-18, INEXACT) // -1.823328029627546790223183159618e-05
T(RD,   0x1.b635990600524p-22,   0x1.b6359906005fap-22, -0x1.b45148p-18, INEXACT) // 4.081142751522634523842153822515e-07
T(RU,   0x1.b635990600524p-22,   0x1.b6359906005fbp-22,   0x1.ffff26p-1, INEXACT) // 4.081142751522634523842153822515e-07
T(RZ,   0x1.b635990600524p-22,   0x1.b6359906005fap-22, -0x1.b45148p-18, INEXACT) // 4.081142751522634523842153822515e-07
T(RN,   0x1.f8098b96d47d4p-18,   0x1.f8098b96e8d7bp-18,  -0x1.fffe0cp-2, INEXACT) // 7.510740849552309728780555286853e-06
T(RN,   0x1.c6e95a1cf3cc8p-19,   0x1.c6e95a1cf78a2p-19,  -0x1.fffe7ep-2, INEXACT) // 3.389355028172653293500396487481e-06
T(RN,    0x1.3d70e15fcc8b7p-8,    0x1.3d7132b99f411p-8,  -0x1.fffe12p-2, INEXACT) // 4.843764327050851213607440826081e-03
T(RN,   -0x1.ff591ef6930ep-20,   -0x1.ff591ef69462p-20,   0x1.ffffd2p-2, INEXACT) // -1.904920223022450980875780457424e-06
T(RD,   0x1.eec261ec94eaep-23,   0x1.eec261ec94efbp-23, -0x1.cc253ap-19, INEXACT) // 2.303902556672262876858185611656e-07
T(RU,   0x1.eec261ec94eaep-23,   0x1.eec261ec94efcp-23,   0x1.ffff8cp-1, INEXACT) // 2.303902556672262876858185611656e-07
T(RZ,   0x1.eec261ec94eaep-23,   0x1.eec261ec94efbp-23, -0x1.cc253ap-19, INEXACT) // 2.303902556672262876858185611656e-07
T(RD,  -0x1.9877019740aa5p-16,  -0x1.98770197edfabp-16,  -0x1.ffffcep-1, INEXACT) // -2.434640336180606383646891910377e-05
T(RU,  -0x1.9877019740aa5p-16,  -0x1.98770197edfaap-16,  0x1.8d8b5ep-20, INEXACT) // -2.434640336180606383646891910377e-05
T(RZ,  -0x1.9877019740aa5p-16,  -0x1.98770197edfaap-16,  0x1.8d8b5ep-20, INEXACT) // -2.434640336180606383646891910377e-05
T(RN,  -0x1.01e1a664537ccp-11,  -0x1.01e1a712c88e5p-11,  -0x1.fffeb2p-2, INEXACT) // -4.918698219087357624557110824526e-04
T(RN,    0x1.65af13b1e2b02p-1,    0x1.8c00715b44232p-1,   0x1.fffe04p-2, INEXACT) // 6.986013559956918417270799182006e-01
T(RN,   -0x1.22cafd77dfb4cp-5,   -0x1.22daa1f4160efp-5,  -0x1.ffffc6p-2, INEXACT) // -3.549718385237685125410678210756e-02
T(RD,  -0x1.3bacd86caf894p-24,  -0x1.3bacd86caf89ap-24,  -0x1.ffffcep-1, INEXACT) // -7.349885473414541374180303408281e-08
T(RU,  -0x1.3bacd86caf894p-24,  -0x1.3bacd86caf899p-24,  0x1.9669d6p-20, INEXACT) // -7.349885473414541374180303408281e-08
T(RZ,  -0x1.3bacd86caf894p-24,  -0x1.3bacd86caf899p-24,  0x1.9669d6p-20, INEXACT) // -7.349885473414541374180303408281e-08
T(RN,   0x1.c88b24db0c53dp-23,   0x1.c88b24db0c57ap-23,   0x1.fffec6p-2, INEXACT) // 2.125946484146144476528678341279e-07
T(RN,   -0x1.b168ae5925d28p-6,   -0x1.b175a017e6622p-6,  -0x1.fffe3ap-2, INEXACT) // -2.645318056292214614622082535789e-02
T(RN,  -0x1.47526fc801b65p-18,  -0x1.47526fc807494p-18,   0x1.ffff12p-2, INEXACT) // -4.877478154702686301985321143393e-06
T(RD,     0x1.f7af806ae2bfp-9,    0x1.f7afd1a94c0aep-9,  -0x1.ffff78p-1, INEXACT) // 3.842815805403791695749049495134e-03
T(RU,     0x1.f7af806ae2bfp-9,    0x1.f7afd1a94c0afp-9,  0x1.116904p-18, INEXACT) // 3.842815805403791695749049495134e-03
T(RZ,     0x1.f7af806ae2bfp-9,    0x1.f7afd1a94c0aep-9,  -0x1.ffff78p-1, INEXACT) // 3.842815805403791695749049495134e-03
T(RN,   -0x1.795fd96b4e021p-2,   -0x1.827c3299be563p-2,   0x1.fffe02p-2, INEXACT) // -3.685296985381701362349815553898e-01
T(RN,   0x1.ba84aae0ff5aep-21,    0x1.ba84aae0ff92p-21,   0x1.ffffacp-2, INEXACT) // 8.242544390354967101481936317398e-07
T(RN,  -0x1.c68e1f23e82b8p-10,  -0x1.c68e2e118aa82p-10,   0x1.ffff84p-2, INEXACT) // -1.733990336085051639503085141314e-03
T(RN,   0x1.27d9eb159ca6ep-12,   0x1.27d9eb57778aep-12,  -0x1.ffff88p-2, INEXACT) // 2.821457322631841469970370717135e-04
T(RN,  -0x1.a3c7386e4688fp-19,  -0x1.a3c7386e49796p-19,   0x1.fffe54p-2, INEXACT) // -3.127591347807058053310689735294e-06
T(RD,   0x1.f22f6eaee802cp-15,   0x1.f22f6eb3d1c81p-15, -0x1.d1947ap-18, INEXACT) // 5.938831360841086821032719367253e-05
T(RU,   0x1.f22f6eaee802cp-15,   0x1.f22f6eb3d1c82p-15,   0x1.ffff18p-1, INEXACT) // 5.938831360841086821032719367253e-05
T(RZ,   0x1.f22f6eaee802cp-15,   0x1.f22f6eb3d1c81p-15, -0x1.d1947ap-18, INEXACT) // 5.938831360841086821032719367253e-05
T(RN,   -0x1.fbfd4ffb0df7p-21,  -0x1.fbfd4ffb0e4a6p-21,  -0x1.fffed6p-2, INEXACT) // -9.462041811241828271781748038727e-07
T(RD,   0x1.2f13e4111ce68p-12,   0x1.2f13e457e998cp-12,  -0x1.fffff4p-1, INEXACT) // 2.890374171961918904616428704912e-04
T(RU,   0x1.2f13e4111ce68p-12,   0x1.2f13e457e998dp-12,  0x1.6f051ep-22, INEXACT) // 2.890374171961918904616428704912e-04
T(RZ,   0x1.2f13e4111ce68p-12,   0x1.2f13e457e998cp-12,  -0x1.fffff4p-1, INEXACT) // 2.890374171961918904616428704912e-04
T(RN,   0x1.e3cf55a90cf13p-25,   0x1.e3cf55a90cf18p-25,   0x1.fffe68p-2, INEXACT) // 5.632288530739822960671106337992e-08
T(RN,  -0x1.774844a13542ap-14,  -0x1.774844a99be09p-14,  -0x1.fffe92p-2, INEXACT) // -8.947427206192128134633334557435e-05
T(RN,   0x1.0b2c0a23d4f35p-22,   0x1.0b2c0a23d4f66p-22,   0x1.fffe8ap-2, INEXACT) // 2.488233425874585099731733667944e-07
T(RN,   0x1.51344cb07c8bfp-18,   0x1.51344cb082a42p-18,   0x1.ffff26p-2, INEXACT) // 5.024735557845003943095493065263e-06
T(RN,  -0x1.ecf4ead6182b6p-13,  -0x1.ecf4eb22417ffp-13,  -0x1.fffeb4p-2, INEXACT) // -2.350600759113607367105369672089e-04
T(RD,   -0x1.2f19d027129b1p-5,   -0x1.2f2b872895f6ep-5, -0x1.149a48p-19, INEXACT) // -3.699961333093727128273897619692e-02
T(RU,   -0x1.2f19d027129b1p-5,   -0x1.2f2b872895f6dp-5,   0x1.ffffbap-1, INEXACT) // -3.699961333093727128273897619692e-02
T(RZ,   -0x1.2f19d027129b1p-5,   -0x1.2f2b872895f6dp-5,   0x1.ffffbap-1, INEXACT) // -3.699961333093727128273897619692e-02
T(RD,   0x1.bccc00614ef81p-19,   0x1.bccc006152774p-19, -0x1.5d499cp-18, INEXACT) // 3.313995009660996086503200255824e-06
T(RU,   0x1.bccc00614ef81p-19,   0x1.bccc006152775p-19,   0x1.ffff52p-1, INEXACT) // 3.313995009660996086503200255824e-06
T(RZ,   0x1.bccc00614ef81p-19,   0x1.bccc006152774p-19, -0x1.5d499cp-18, INEXACT) // 3.313995009660996086503200255824e-06
T(RN,   -0x1.ee645b16cab2cp-1,   -0x1.4eca7bc9ad4f6p+0,   0x1.fffeacp-2, INEXACT) // -9.656094041177758491301119647687e-01
T(RD,   -0x1.815724cb5f9bep-3,   -0x1.83a6ab65bd70ep-3, -0x1.da9594p-19, INEXACT) // -1.881544947209032314638932348316e-01
T(RU,   -0x1.815724cb5f9bep-3,   -0x1.83a6ab65bd70dp-3,   0x1.ffff8ap-1, INEXACT) // -1.881544947209032314638932348316e-01
T(RZ,   -0x1.815724cb5f9bep-3,   -0x1.83a6ab65bd70dp-3,   0x1.ffff8ap-1, INEXACT) // -1.881544947209032314638932348316e-01
T(RN,   -0x1.9900d789f5a3p-23,  -0x1.9900d789f5a5bp-23,    0x1.ffff4p-2, INEXACT) // -1.904569980048930864129693579789e-07
T(RN,    0x1.4acaa96b587afp-9,    0x1.4acac06eadfa8p-9,  -0x1.fffee8p-2, INEXACT) // 2.523739987439342202096836942360e-03
T(RN,  -0x1.077389903522ep-10,  -0x1.07738c783caccp-10,   0x1.fffe32p-2, INEXACT) // -1.004987021635216342535512623613e-03
T(RN,  -0x1.b831f598136c5p-13,  -0x1.b831f5ce4e769p-13,  -0x1.ffff5cp-2, INEXACT) // -2.099014061535590220611974254794e-04
T(RD,  -0x1.ef110b216da28p-18,  -0x1.ef110b2180ebcp-18,  -0x1.ffffa6p-1, INEXACT) // -7.377066851990808518755443623505e-06
T(RU,  -0x1.ef110b216da28p-18,  -0x1.ef110b2180ebbp-18,  0x1.64cad6p-19, INEXACT) // -7.377066851990808518755443623505e-06
T(RZ,  -0x1.ef110b216da28p-18,  -0x1.ef110b2180ebbp-18,  0x1.64cad6p-19, INEXACT) // -7.377066851990808518755443623505e-06
T(RN,  -0x1.028b12fcfdab5p-12,  -0x1.028b1328f11e3p-12,   0x1.ffff78p-2, INEXACT) // -2.465660652996402445354118260212e-04
T(RD,   0x1.ca45be62ced2ep-17,   0x1.ca45be630c037p-17,  -0x1.ffff8cp-1, INEXACT) // 1.365758288828527823913737415662e-05
T(RU,   0x1.ca45be62ced2ep-17,   0x1.ca45be630c038p-17,  0x1.d08fdap-19, INEXACT) // 1.365758288828527823913737415662e-05
T(RZ,   0x1.ca45be62ced2ep-17,   0x1.ca45be630c037p-17,  -0x1.ffff8cp-1, INEXACT) // 1.365758288828527823913737415662e-05
T(RD,   0x1.451785868a03ep-20,   0x1.451785868a5b4p-20, -0x1.c7598cp-19, INEXACT) // 1.211061631098769104177307817660e-06
T(RU,   0x1.451785868a03ep-20,   0x1.451785868a5b5p-20,   0x1.ffff8ep-1, INEXACT) // 1.211061631098769104177307817660e-06
T(RZ,   0x1.451785868a03ep-20,   0x1.451785868a5b4p-20, -0x1.c7598cp-19, INEXACT) // 1.211061631098769104177307817660e-06
T(RD,  -0x1.b7f64b8e06f5ep-19,  -0x1.b7f64b8e0a583p-19, -0x1.1c55f8p-19, INEXACT) // -3.277973013927488412538099188387e-06
T(RU,  -0x1.b7f64b8e06f5ep-19,  -0x1.b7f64b8e0a582p-19,   0x1.ffffb8p-1, INEXACT) // -3.277973013927488412538099188387e-06
T(RZ,  -0x1.b7f64b8e06f5ep-19,  -0x1.b7f64b8e0a582p-19,   0x1.ffffb8p-1, INEXACT) // -3.277973013927488412538099188387e-06
T(RN,   0x1.30c7ee34b8bfbp-24,   0x1.30c7ee34b8bffp-24,  -0x1.ffffbap-2, INEXACT) // 7.096235139394495182630387365361e-08
T(RN,  -0x1.ab8502cdcced9p-11,  -0x1.ab8505e8ac0b5p-11,  -0x1.fffe26p-2, INEXACT) // -8.154288750347973195944928370693e-04
T(RN,  -0x1.7411a1543bbc8p-15,  -0x1.7411a15647b28p-15,  -0x1.fffe7cp-2, INEXACT) // -4.435406541058274166103303493003e-05
T(RD,  -0x1.8c28d5bb0f121p-18,  -0x1.8c28d5bb18f3fp-18,   -0x1.872fp-18, INEXACT) // -5.903236735934730960442210628836e-06
T(RU,  -0x1.8c28d5bb0f121p-18,  -0x1.8c28d5bb18f3ep-18,   0x1.ffff3cp-1, INEXACT) // -5.903236735934730960442210628836e-06
T(RZ,  -0x1.8c28d5bb0f121p-18,  -0x1.8c28d5bb18f3ep-18,   0x1.ffff3cp-1, INEXACT) // -5.903236735934730960442210628836e-06
T(RN,    0x1.2d2f6a84ee6f8p-9,    0x1.2d2f7be3c39a5p-9,    0x1.ffff1p-2, INEXACT) // 2.297860863532782266238641000200e-03
T(RN,    0x1.1a5409d544e89p-2,    0x1.1e088def3e1cbp-2,   0x1.ffff7ap-2, INEXACT) // 2.757112060946629861213352796767e-01
T(RD,   0x1.eecc1e51e482fp-16,   0x1.eecc1e5318952p-16, -0x1.e2e9eep-19, INEXACT) // 2.949221954613045308126427490603e-05
T(RU,   0x1.eecc1e51e482fp-16,   0x1.eecc1e5318953p-16,   0x1.ffff88p-1, INEXACT) // 2.949221954613045308126427490603e-05
T(RZ,   0x1.eecc1e51e482fp-16,   0x1.eecc1e5318952p-16, -0x1.e2e9eep-19, INEXACT) // 2.949221954613045308126427490603e-05
T(RD,   0x1.d06cac357d0f1p-21,   0x1.d06cac357d4ecp-21, -0x1.430324p-20, INEXACT) // 8.650580471379355579919783088283e-07
T(RU,   0x1.d06cac357d0f1p-21,   0x1.d06cac357d4edp-21,   0x1.ffffd8p-1, INEXACT) // 8.650580471379355579919783088283e-07
T(RZ,   0x1.d06cac357d0f1p-21,   0x1.d06cac357d4ecp-21, -0x1.430324p-20, INEXACT) // 8.650580471379355579919783088283e-07
T(RD,   0x1.2d202f955254cp-17,   0x1.2d202f9563b0ep-17,  -0x1.ffff4cp-1, INEXACT) // 8.974245967368698164486756629898e-06
T(RU,   0x1.2d202f955254cp-17,   0x1.2d202f9563b0fp-17,  0x1.6947fap-18, INEXACT) // 8.974245967368698164486756629898e-06
T(RZ,   0x1.2d202f955254cp-17,   0x1.2d202f9563b0ep-17,  -0x1.ffff4cp-1, INEXACT) // 8.974245967368698164486756629898e-06
T(RN,     0x1.2daee62979f2p-2,    0x1.323a297aa29b4p-2,   0x1.fffea2p-2, INEXACT) // 2.946124995055345863192997057922e-01
T(RN,   0x1.b59b7732310c9p-18,   0x1.b59b77323e5e8p-18,   0x1.ffffcap-2, INEXACT) // 6.520856731199485113259581986478e-06
T(RN,   -0x1.08da679fe3fddp-7,   -0x1.08db249f5a40ep-7,  -0x1.ffff84p-2, INEXACT) // -8.082676504073954895646103580020e-03
T(RD,    0x1.7828de39adfe4p-6,    0x1.783154797ddc1p-6,   -0x1.ffff9p-1, INEXACT) // 2.295896245661301071638860094026e-02
T(RU,    0x1.7828de39adfe4p-6,    0x1.783154797ddc2p-6,  0x1.bd4af6p-19, INEXACT) // 2.295896245661301071638860094026e-02
T(RZ,    0x1.7828de39adfe4p-6,    0x1.783154797ddc1p-6,   -0x1.ffff9p-1, INEXACT) // 2.295896245661301071638860094026e-02
T(RN,    0x1.cb9f9f37337cap-7,    0x1.cba37b06e73a4p-7,   0x1.fffe86p-2, INEXACT) // 1.402659677696850917816284720629e-02
T(RD,   0x1.713748ecdcbd4p-25,   0x1.713748ecdcbd6p-25, -0x1.221974p-20, INEXACT) // 4.298239439969224977171390143088e-08
T(RU,   0x1.713748ecdcbd4p-25,   0x1.713748ecdcbd7p-25,   0x1.ffffdcp-1, INEXACT) // 4.298239439969224977171390143088e-08
T(RZ,   0x1.713748ecdcbd4p-25,   0x1.713748ecdcbd6p-25, -0x1.221974p-20, INEXACT) // 4.298239439969224977171390143088e-08
T(RD,   0x1.3da1d1a07ea2bp-17,   0x1.3da1d1a093028p-17, -0x1.65f544p-19, INEXACT) // 9.466174391005690428083606258181e-06
T(RU,   0x1.3da1d1a07ea2bp-17,   0x1.3da1d1a093029p-17,   0x1.ffffa6p-1, INEXACT) // 9.466174391005690428083606258181e-06
T(RZ,   0x1.3da1d1a07ea2bp-17,   0x1.3da1d1a093028p-17, -0x1.65f544p-19, INEXACT) // 9.466174391005690428083606258181e-06
T(RD,  -0x1.610321a5206a4p-14,  -0x1.610321ac1e6fap-14,  -0x1.ffff6ep-1, INEXACT) // -8.416467479046646710597046059377e-05
T(RU,  -0x1.610321a5206a4p-14,  -0x1.610321ac1e6f9p-14,  0x1.22336cp-18, INEXACT) // -8.416467479046646710597046059377e-05
T(RZ,  -0x1.610321a5206a4p-14,  -0x1.610321ac1e6f9p-14,  0x1.22336cp-18, INEXACT) // -8.416467479046646710597046059377e-05
T(RD,  -0x1.4567abb747056p-14,  -0x1.4567abbcc1107p-14,  -0x1.ffff46p-1, INEXACT) // -7.758258913209808960674551681080e-05
T(RU,  -0x1.4567abb747056p-14,  -0x1.4567abbcc1106p-14,   0x1.72ffbp-18, INEXACT) // -7.758258913209808960674551681080e-05
T(RZ,  -0x1.4567abb747056p-14,  -0x1.4567abbcc1106p-14,   0x1.72ffbp-18, INEXACT) // -7.758258913209808960674551681080e-05
T(RN,   0x1.928088821d27fp-16,   0x1.92808882c2fd7p-16,   0x1.ffff62p-2, INEXACT) // 2.399099367563156678744527849911e-05
T(RN,    0x1.30853d104b71cp-7,    0x1.30865c563ccedp-7,  -0x1.ffff58p-2, INEXACT) // 9.293227020488674383624783104096e-03
T(RD,    0x1.7ec5f61b8df4bp-4,    0x1.7f55262d8b369p-4, -0x1.17b308p-18, INEXACT) // 9.345050941271641764540589747412e-02
T(RU,    0x1.7ec5f61b8df4bp-4,    0x1.7f55262d8b36ap-4,   0x1.ffff74p-1, INEXACT) // 9.345050941271641764540589747412e-02
T(RZ,    0x1.7ec5f61b8df4bp-4,    0x1.7f55262d8b369p-4, -0x1.17b308p-18, INEXACT) // 9.345050941271641764540589747412e-02
T(RD,   -0x1.94723f4963dd9p-8,   -0x1.9472e789c24b6p-8,  -0x1.ffff96p-1, INEXACT) // -6.171360445832851406022800944129e-03
T(RU,   -0x1.94723f4963dd9p-8,   -0x1.9472e789c24b5p-8,  0x1.a5befap-19, INEXACT) // -6.171360445832851406022800944129e-03
T(RZ,   -0x1.94723f4963dd9p-8,   -0x1.9472e789c24b5p-8,  0x1.a5befap-19, INEXACT) // -6.171360445832851406022800944129e-03
T(RN,    0x1.e058ebb348b5ep-1,    0x1.37a2ed36ea20bp+0,   0x1.fffe64p-2, INEXACT) // 9.381784111359185995837606242276e-01
T(RN,   -0x1.f5d3dd73d678ep-5,   -0x1.f624593a6b005p-5,   0x1.ffffcap-2, INEXACT) // -6.125825169028963068651449930258e-02
T(RD,   -0x1.26af9a7784d67p-3,   -0x1.27b660fa3f79ap-3, -0x1.90e43cp-19, INEXACT) // -1.438896243786118300800325187083e-01
T(RU,   -0x1.26af9a7784d67p-3,   -0x1.27b660fa3f799p-3,   0x1.ffff9cp-1, INEXACT) // -1.438896243786118300800325187083e-01
T(RZ,   -0x1.26af9a7784d67p-3,   -0x1.27b660fa3f799p-3,   0x1.ffff9cp-1, INEXACT) // -1.438896243786118300800325187083e-01
T(RN,   -0x1.28b23d713a994p-5,   -0x1.28c2dae4b5ac6p-5,  -0x1.fffe32p-2, INEXACT) // -3.621780395936294305592184628040e-02
T(RN,    0x1.f30e4638f3b2p-15,   0x1.f30e463de4122p-15,   0x1.ffffaap-2, INEXACT) // 5.949208247778823600848685515530e-05
T(RN,   -0x1.59272bdbb8469p-7,   -0x1.5928ce27efdf3p-7,   0x1.ffffa6p-2, INEXACT) // -1.053323403852087121468361630150e-02
T(RD,  -0x1.094c141d0022cp-11,  -0x1.094c14daf1eeep-11, -0x1.241abcp-19, INEXACT) // -5.060142171942664211792273221135e-04
T(RU,  -0x1.094c141d0022cp-11,  -0x1.094c14daf1eedp-11,   0x1.ffffb6p-1, INEXACT) // -5.060142171942664211792273221135e-04
T(RZ,  -0x1.094c141d0022cp-11,  -0x1.094c14daf1eedp-11,   0x1.ffffb6p-1, INEXACT) // -5.060142171942664211792273221135e-04
T(RD,  -0x1.41f8d9ef3e489p-10,   -0x1.41f8df3d6177p-10, -0x1.ff0682p-18, INEXACT) // -1.228225995701744685875689278021e-03
T(RU,  -0x1.41f8d9ef3e489p-10,  -0x1.41f8df3d6176fp-10,     0x1.ffffp-1, INEXACT) // -1.228225995701744685875689278021e-03
T(RZ,  -0x1.41f8d9ef3e489p-10,  -0x1.41f8df3d6176fp-10,     0x1.ffffp-1, INEXACT) // -1.228225995701744685875689278021e-03
T(RN,    0x1.a677e37bfa3b3p-3,    0x1.a985fcc89b6c2p-3,   0x1.ffff18p-2, INEXACT) // 2.062833568773193293477419274495e-01
T(RD,   -0x1.702b60846618cp-3,   -0x1.722e905ee32e5p-3,  -0x1.ffff52p-1, INEXACT) // -1.797702351002609111318975010363e-01
T(RU,   -0x1.702b60846618cp-3,   -0x1.722e905ee32e4p-3,  0x1.5c4abep-18, INEXACT) // -1.797702351002609111318975010363e-01
T(RZ,   -0x1.702b60846618cp-3,   -0x1.722e905ee32e4p-3,  0x1.5c4abep-18, INEXACT) // -1.797702351002609111318975010363e-01
T(RD,   0x1.250c0f38aeea7p-25,   0x1.250c0f38aeea8p-25, -0x1.66d97cp-19, INEXACT) // 3.411517330217428931288831009221e-08
T(RU,   0x1.250c0f38aeea7p-25,   0x1.250c0f38aeea9p-25,   0x1.ffffa6p-1, INEXACT) // 3.411517330217428931288831009221e-08
T(RZ,   0x1.250c0f38aeea7p-25,   0x1.250c0f38aeea8p-25, -0x1.66d97cp-19, INEXACT) // 3.411517330217428931288831009221e-08
T(RN,   0x1.c8a44a18b6714p-20,   0x1.c8a44a18b7636p-20,  -0x1.ffffa8p-2, INEXACT) // 1.701123102096394736429136457234e-06
T(RD,   0x1.a02cda552c0e5p-15,   0x1.a02cda5809509p-15,   -0x1.ffff3p-1, INEXACT) // 4.961195069464063601158768102017e-05
T(RU,   0x1.a02cda552c0e5p-15,   0x1.a02cda580950ap-15,  0x1.9e6d8cp-18, INEXACT) // 4.961195069464063601158768102017e-05
T(RZ,   0x1.a02cda552c0e5p-15,   0x1.a02cda5809509p-15,   -0x1.ffff3p-1, INEXACT) // 4.961195069464063601158768102017e-05
T(RD,  -0x1.38dc012ec01c1p-13,  -0x1.38dc014238521p-13,  -0x1.ffff1ap-1, INEXACT) // -1.491829838968905107710744006866e-04
T(RU,  -0x1.38dc012ec01c1p-13,   -0x1.38dc01423852p-13,  0x1.cb0fdcp-18, INEXACT) // -1.491829838968905107710744006866e-04
T(RZ,  -0x1.38dc012ec01c1p-13,   -0x1.38dc01423852p-13,  0x1.cb0fdcp-18, INEXACT) // -1.491829838968905107710744006866e-04
T(RD,    0x1.11b336282e435p-2,    0x1.151183c4f78adp-2, -0x1.76dcbcp-18, INEXACT) // 2.672852003120767538923985284782e-01
T(RU,    0x1.11b336282e435p-2,    0x1.151183c4f78aep-2,   0x1.ffff44p-1, INEXACT) // 2.672852003120767538923985284782e-01
T(RZ,    0x1.11b336282e435p-2,    0x1.151183c4f78adp-2, -0x1.76dcbcp-18, INEXACT) // 2.672852003120767538923985284782e-01
T(RN,   0x1.90b48b175af11p-15,   0x1.90b48b19e96eep-15,   0x1.ffff6ep-2, INEXACT) // 4.776778785750395301930651403843e-05
T(RN,  -0x1.2aca34173bac9p-11,  -0x1.2aca352694bafp-11,   0x1.fffff6p-2, INEXACT) // -5.698964258991852426319835167590e-04
T(RN,  -0x1.081c32958f186p-19,  -0x1.081c32958fd3cp-19,    0x1.ffffdp-2, INEXACT) // -1.967773935600088145651386656310e-06
T(RD,   0x1.91d3896df2b57p-22,   0x1.91d3896df2bfcp-22, -0x1.d0e8e8p-22, INEXACT) // 3.742299189395437717687035918818e-07
T(RU,   0x1.91d3896df2b57p-22,   0x1.91d3896df2bfdp-22,   0x1.fffff2p-1, INEXACT) // 3.742299189395437717687035918818e-07
T(RZ,   0x1.91d3896df2b57p-22,   0x1.91d3896df2bfcp-22, -0x1.d0e8e8p-22, INEXACT) // 3.742299189395437717687035918818e-07
T(RN,  -0x1.c98981921d447p-17,  -0x1.c98981925a29cp-17,   0x1.fffe84p-2, INEXACT) // -1.363566915222649371375578802867e-05
T(RN,   -0x1.54cc6210cc43bp-8,   -0x1.54ccc6ba55842p-8,  -0x1.ffffc2p-2, INEXACT) // -5.200170461464865938328028249771e-03
T(RD,  -0x1.a2e4818cd9c48p-13,  -0x1.a2e481bb953acp-13, -0x1.a24a9cp-18, INEXACT) // -1.997435578246795160467508267743e-04
T(RU,  -0x1.a2e4818cd9c48p-13,  -0x1.a2e481bb953abp-13,   0x1.ffff2ep-1, INEXACT) // -1.997435578246795160467508267743e-04
T(RZ,  -0x1.a2e4818cd9c48p-13,  -0x1.a2e481bb953abp-13,   0x1.ffff2ep-1, INEXACT) // -1.997435578246795160467508267743e-04
T(RN,   0x1.8f961a4fe75d6p-16,   0x1.8f961a50899eep-16,   -0x1.ffff6p-2, INEXACT) // 2.381720179266639739320762791941e-05
T(RN,   0x1.fdbecb90c53ddp-20,   0x1.fdbecb90c68eap-20,  -0x1.fffecep-2, INEXACT) // 1.898949197170035504167212754567e-06
T(RN,   0x1.9945a6dd70ddep-17,   0x1.9945a6dd9c73dp-17,  -0x1.fffe36p-2, INEXACT) // 1.219725839519172002635948037774e-05
T(RD,  -0x1.362ebe7cb9c3ep-11,  -0x1.362ebfac4facfp-11, -0x1.6c76f2p-20, INEXACT) // -5.916263467867844457609427522016e-04
T(RU,  -0x1.362ebe7cb9c3ep-11,  -0x1.362ebfac4facep-11,   0x1.ffffd2p-1, INEXACT) // -5.916263467867844457609427522016e-04
T(RZ,  -0x1.362ebe7cb9c3ep-11,  -0x1.362ebfac4facep-11,   0x1.ffffd2p-1, INEXACT) // -5.916263467867844457609427522016e-04
T(RD,  -0x1.11060fe45b80cp-16,  -0x1.11060fe48f42ap-16,  -0x1.ffff9ep-1, INEXACT) // -1.627347946125266744520770911819e-05
T(RU,  -0x1.11060fe45b80cp-16,  -0x1.11060fe48f429p-16,  0x1.892206p-19, INEXACT) // -1.627347946125266744520770911819e-05
T(RZ,  -0x1.11060fe45b80cp-16,  -0x1.11060fe48f429p-16,  0x1.892206p-19, INEXACT) // -1.627347946125266744520770911819e-05
T(RD,    0x1.5dbdbd09012abp-9,    0x1.5dbdd83be8bdbp-9,  -0x1.ffff4ap-1, INEXACT) // 2.668313336928148423593532001519e-03
T(RU,    0x1.5dbdbd09012abp-9,    0x1.5dbdd83be8bdcp-9,  0x1.6da606p-18, INEXACT) // 2.668313336928148423593532001519e-03
T(RZ,    0x1.5dbdbd09012abp-9,    0x1.5dbdd83be8bdbp-9,  -0x1.ffff4ap-1, INEXACT) // 2.668313336928148423593532001519e-03
T(RD,   0x1.3f81698d51f9fp-12,   0x1.3f8169e044911p-12, -0x1.4cbfbep-18, INEXACT) // 3.047042053663187740307483064583e-04
T(RU,   0x1.3f81698d51f9fp-12,   0x1.3f8169e044912p-12,   0x1.ffff5ap-1, INEXACT) // 3.047042053663187740307483064583e-04
T(RZ,   0x1.3f81698d51f9fp-12,   0x1.3f8169e044911p-12, -0x1.4cbfbep-18, INEXACT) // 3.047042053663187740307483064583e-04
T(RN,   -0x1.6473fc5e7c48p-19,  -0x1.6473fc5e7e14cp-19,  -0x1.ffff9ep-2, INEXACT) // -2.655782324050492363559650144111e-06
T(RN,   0x1.be1b016ea63bdp-10,   0x1.be1b0f8b19eb9p-10,   0x1.ffff9ap-2, INEXACT) // 1.701757395187394232907718283343e-03
T(RN,  -0x1.11ab4986ffe07p-21,  -0x1.11ab4986ffed7p-21,    0x1.ffffdp-2, INEXACT) // -5.097484042648224183380783851305e-07
T(RD,   0x1.07d5a8d05d708p-17,   0x1.07d5a8d0691d9p-17,  -0x1.fffffcp-1, INEXACT) // 7.862884019198542275876084861608e-06
T(RU,   0x1.07d5a8d05d708p-17,   0x1.07d5a8d0691dap-17,   0x1.30073p-23, INEXACT) // 7.862884019198542275876084861608e-06
T(RZ,   0x1.07d5a8d05d708p-17,   0x1.07d5a8d0691d9p-17,  -0x1.fffffcp-1, INEXACT) // 7.862884019198542275876084861608e-06
T(RN,    0x1.e054d12e15c5ap-3,    0x1.e4d900bcd836fp-3,   0x1.ffff6ap-2, INEXACT) // 2.345367757977523948120790464600e-01
T(RN,  -0x1.8d926cdc0d1c1p-12,  -0x1.8d926d7bdd9dfp-12,   0x1.fffe42p-2, INEXACT) // -3.791541801121644226536810950989e-04
T(RN,   -0x1.0b4d8a6085abbp-8,   -0x1.0b4dbaf2deb66p-8,   0x1.ffffeep-2, INEXACT) // -4.078718455750414244309620670492e-03
T(RN,    0x1.6a6788dc4745ap-1,    0x1.92a431c15ecc1p-1,  -0x1.ffffc6p-2, INEXACT) // 7.078211563963450192460413745721e-01
T(RD,   -0x1.ae7ac23a25965p-7,   -0x1.ae7dedc9399adp-7,  -0x1.ffff6ap-1, INEXACT) // -1.313719257113339124176665251298e-02
T(RU,   -0x1.ae7ac23a25965p-7,   -0x1.ae7dedc9399acp-7,  0x1.2c006cp-18, INEXACT) // -1.313719257113339124176665251298e-02
T(RZ,   -0x1.ae7ac23a25965p-7,   -0x1.ae7dedc9399acp-7,  0x1.2c006cp-18, INEXACT) // -1.313719257113339124176665251298e-02
T(RD,   0x1.713746fadfa61p-25,   0x1.713746fadfa63p-25, -0x1.413bfap-21, INEXACT) // 4.298239094420194571679252480874e-08
T(RU,   0x1.713746fadfa61p-25,   0x1.713746fadfa64p-25,   0x1.ffffecp-1, INEXACT) // 4.298239094420194571679252480874e-08
T(RZ,   0x1.713746fadfa61p-25,   0x1.713746fadfa63p-25, -0x1.413bfap-21, INEXACT) // 4.298239094420194571679252480874e-08
T(RD,   0x1.822bd0bc40b3fp-13,   0x1.822bd0e0dde95p-13,   -0x1.ffffdp-1, INEXACT) // 1.841407555574717670298506844162e-04
T(RU,   0x1.822bd0bc40b3fp-13,   0x1.822bd0e0dde96p-13,   0x1.785bap-20, INEXACT) // 1.841407555574717670298506844162e-04
T(RZ,   0x1.822bd0bc40b3fp-13,   0x1.822bd0e0dde95p-13,   -0x1.ffffdp-1, INEXACT) // 1.841407555574717670298506844162e-04
T(RN,   0x1.692d9afdca733p-15,   0x1.692d9affa9bbfp-15,   -0x1.fffeep-2, INEXACT) // 4.305579021342126197968366851931e-05
T(RN,  -0x1.0dc0d2dc56bddp-12,  -0x1.0dc0d30e4216ep-12,   0x1.ffff9ep-2, INEXACT) // -2.572567152775965160400872822066e-04
T(RD,  -0x1.2f97e99cfe0c2p-16,  -0x1.2f97e99d45358p-16, -0x1.db87dap-18, INEXACT) // -1.809557726414955607487436428649e-05
T(RU,  -0x1.2f97e99cfe0c2p-16,  -0x1.2f97e99d45357p-16,   0x1.ffff12p-1, INEXACT) // -1.809557726414955607487436428649e-05
T(RZ,  -0x1.2f97e99cfe0c2p-16,  -0x1.2f97e99d45357p-16,   0x1.ffff12p-1, INEXACT) // -1.809557726414955607487436428649e-05
T(RN,  -0x1.7aa728ee5499dp-15,  -0x1.7aa728f07cdf6p-15,   0x1.fffe6cp-2, INEXACT) // -4.513895133819170263573053447637e-05
T(RD,  -0x1.45dd79b5bcc4fp-23,  -0x1.45dd79b5bcc65p-23, -0x1.fa78fap-18, INEXACT) // -1.517427798341347563385316269888e-07
T(RU,  -0x1.45dd79b5bcc4fp-23,  -0x1.45dd79b5bcc64p-23,   0x1.ffff02p-1, INEXACT) // -1.517427798341347563385316269888e-07
T(RZ,  -0x1.45dd79b5bcc4fp-23,  -0x1.45dd79b5bcc64p-23,   0x1.ffff02p-1, INEXACT) // -1.517427798341347563385316269888e-07
T(RD,  -0x1.c63a65f15c45fp-12,  -0x1.c63a66dfb2772p-12, -0x1.13d086p-20, INEXACT) // -4.331856899489390662870424986153e-04
T(RU,  -0x1.c63a65f15c45fp-12,  -0x1.c63a66dfb2771p-12,   0x1.ffffdep-1, INEXACT) // -4.331856899489390662870424986153e-04
T(RZ,  -0x1.c63a65f15c45fp-12,  -0x1.c63a66dfb2771p-12,   0x1.ffffdep-1, INEXACT) // -4.331856899489390662870424986153e-04
T(RN,  -0x1.d5da405de89f1p-18,  -0x1.d5da405df91bbp-18,   -0x1.ffff8p-2, INEXACT) // -7.001348505316575466692844559313e-06
T(RN,   0x1.01a7ebe6cca36p-22,   0x1.01a7ebe6cca62p-22,   0x1.fffe86p-2, INEXACT) // 2.399607964997589828838923074750e-07
T(RD,   0x1.416326c0b6525p-19,   0x1.416326c0b7a3fp-19,   -0x1.ffff5p-1, INEXACT) // 2.394522056509004621227413092677e-06
T(RU,   0x1.416326c0b6525p-19,    0x1.416326c0b7a4p-19,  0x1.5eee44p-18, INEXACT) // 2.394522056509004621227413092677e-06
T(RZ,   0x1.416326c0b6525p-19,   0x1.416326c0b7a3fp-19,   -0x1.ffff5p-1, INEXACT) // 2.394522056509004621227413092677e-06
T(RN,   -0x1.b9b1d23f8d78ep-4,   -0x1.ba8e1f7275668p-4,   0x1.fffe68p-2, INEXACT) // -1.078355992147790043400590320744e-01
T(RN,  -0x1.ef3a35770f4a4p-21,  -0x1.ef3a35770f977p-21,   0x1.ffffbcp-2, INEXACT) // -9.224328739798311710504797461541e-07
T(RN,   0x1.feb5802c9d9bfp-19,    0x1.feb5802ca2e7p-19,   0x1.ffff68p-2, INEXACT) // 3.805078469472383003688624111827e-06
T(RN,  -0x1.b7de0bc5f069bp-10,  -0x1.b7de194cf4aecp-10,  -0x1.fffe52p-2, INEXACT) // -1.677960842684822788048459862864e-03
T(RN,   0x1.43ed79bb6f2e2p-10,   0x1.43ed7f2278186p-10,  -0x1.ffff6ep-2, INEXACT) // 1.235685877744412564799292297835e-03
T(RD,  -0x1.af1b44f4fd86bp-18,  -0x1.af1b44f50a42ep-18, -0x1.edd8f2p-18, INEXACT) // -6.423987760398063445201315840860e-06
T(RU,  -0x1.af1b44f4fd86bp-18,  -0x1.af1b44f50a42dp-18,   0x1.ffff0ap-1, INEXACT) // -6.423987760398063445201315840860e-06
T(RZ,  -0x1.af1b44f4fd86bp-18,  -0x1.af1b44f50a42dp-18,   0x1.ffff0ap-1, INEXACT) // -6.423987760398063445201315840860e-06
T(RD,  -0x1.250c02a9d99c8p-25,  -0x1.250c02a9d99cap-25,  -0x1.ffffe8p-1, INEXACT) // -3.411515099478765363278016421733e-08
T(RU,  -0x1.250c02a9d99c8p-25,  -0x1.250c02a9d99c9p-25,  0x1.7e3dbcp-21, INEXACT) // -3.411515099478765363278016421733e-08
T(RZ,  -0x1.250c02a9d99c8p-25,  -0x1.250c02a9d99c9p-25,  0x1.7e3dbcp-21, INEXACT) // -3.411515099478765363278016421733e-08
T(RN,   -0x1.c8ae5888c9cdp-20,  -0x1.c8ae5888cabf4p-20,  -0x1.ffffaap-2, INEXACT) // -1.701269441942328941976339540254e-06
T(RN,    0x1.2b92b507077bbp-6,    0x1.2b96fb24268ecp-6,  -0x1.fffe6ap-2, INEXACT) // 1.828448942625702719477764901512e-02
T(RD,  -0x1.e5b135fddcc1dp-20,  -0x1.e5b135fddde54p-20,  -0x1.ffffeap-1, INEXACT) // -1.809344552819410166589792106351e-06
T(RU,  -0x1.e5b135fddcc1dp-20,  -0x1.e5b135fddde53p-20,  0x1.63311ep-21, INEXACT) // -1.809344552819410166589792106351e-06
T(RZ,  -0x1.e5b135fddcc1dp-20,  -0x1.e5b135fddde53p-20,  0x1.63311ep-21, INEXACT) // -1.809344552819410166589792106351e-06
T(RN,   0x1.fc0d909071b8dp-22,   0x1.fc0d909071cdbp-22,   0x1.fffe58p-2, INEXACT) // 4.731612160104995559702708175093e-07
T(RN,  -0x1.40cb3a8e67ce7p-18,  -0x1.40cb3a8e6d0dbp-18,   0x1.fffe98p-2, INEXACT) // -4.780201051351345974420228163160e-06
T(RN,  -0x1.c7863742d036dp-19,  -0x1.c7863742d3f85p-19,   0x1.ffff7ep-2, INEXACT) // -3.393920367328700559095494906914e-06
T(RD,   -0x1.25835eb7cd9f1p-5,   -0x1.259374ae97d51p-5,  -0x1.ffff04p-1, INEXACT) // -3.582924365621299039874614322798e-02
T(RU,   -0x1.25835eb7cd9f1p-5,    -0x1.259374ae97d5p-5,  0x1.f93b48p-18, INEXACT) // -3.582924365621299039874614322798e-02
T(RZ,   -0x1.25835eb7cd9f1p-5,    -0x1.259374ae97d5p-5,  0x1.f93b48p-18, INEXACT) // -3.582924365621299039874614322798e-02
T(RN,   0x1.25051fa97f80cp-18,   0x1.25051fa983807p-18,  -0x1.ffff16p-2, INEXACT) // 4.366338467230386938570593780007e-06
T(RD,   0x1.184a0a76815d5p-22,   0x1.184a0a768160cp-22,  -0x1.ffffc8p-1, INEXACT) // 2.610396800109732232539002955846e-07
T(RU,   0x1.184a0a76815d5p-22,   0x1.184a0a768160dp-22,  0x1.c2bddep-20, INEXACT) // 2.610396800109732232539002955846e-07
T(RZ,   0x1.184a0a76815d5p-22,   0x1.184a0a768160cp-22,  -0x1.ffffc8p-1, INEXACT) // 2.610396800109732232539002955846e-07
T(RN,    0x1.b1bbeb88ba374p-2,    0x1.bfe0caf3a8d0dp-2,  -0x1.ffff7ep-2, INEXACT) // 4.235684206201348889209157277946e-01
T(RD,  -0x1.d12ea1f07ddb8p-26,  -0x1.d12ea1f07ddb9p-26, -0x1.34b1a2p-18, INEXACT) // -2.707716534493125935187114294161e-08
T(RU,  -0x1.d12ea1f07ddb8p-26,  -0x1.d12ea1f07ddb8p-26,   0x1.ffff66p-1, INEXACT) // -2.707716534493125935187114294161e-08
T(RZ,  -0x1.d12ea1f07ddb8p-26,  -0x1.d12ea1f07ddb8p-26,   0x1.ffff66p-1, INEXACT) // -2.707716534493125935187114294161e-08
T(RN,   0x1.71370e4dff3edp-26,   0x1.71370e4dff3edp-26,  -0x1.ffff1ep-2, INEXACT) // 2.149114513432336182291444812587e-08
T(RN,   0x1.e592166f85303p-20,   0x1.e592166f86535p-20,  -0x1.fffe7ap-2, INEXACT) // 1.808891649695058341884112800002e-06
T(RD,   0x1.daadd449328ecp-23,    0x1.daadd4493293p-23, -0x1.20b3a8p-18, INEXACT) // 2.210396437329201405657861344289e-07
T(RU,   0x1.daadd449328ecp-23,   0x1.daadd44932931p-23,    0x1.ffff7p-1, INEXACT) // 2.210396437329201405657861344289e-07
T(RZ,   0x1.daadd449328ecp-23,    0x1.daadd4493293p-23, -0x1.20b3a8p-18, INEXACT) // 2.210396437329201405657861344289e-07
T(RN,   0x1.71375c8603bffp-26,     0x1.71375c8603cp-26,   0x1.ffff9cp-2, INEXACT) // 2.149121460659017367129137857703e-08
T(RN,   0x1.4fa628ed33451p-10,   0x1.4fa62eefdebe7p-10,   0x1.fffe46p-2, INEXACT) // 1.280399558982088037764612842295e-03
T(RD,   -0x1.369e31c59ba6bp-2,   -0x1.3b971a009ecaap-2,  -0x1.ffff9cp-1, INEXACT) // -3.033378388271674164222702074767e-01
T(RU,   -0x1.369e31c59ba6bp-2,   -0x1.3b971a009eca9p-2,   0x1.91e0dp-19, INEXACT) // -3.033378388271674164222702074767e-01
T(RZ,   -0x1.369e31c59ba6bp-2,   -0x1.3b971a009eca9p-2,   0x1.91e0dp-19, INEXACT) // -3.033378388271674164222702074767e-01
T(RD,    0x1.6b3cb4c107b88p-6,    0x1.6b44534c1d7b5p-6,  -0x1.ffff06p-1, INEXACT) // 2.217023517379915209524199326552e-02
T(RU,    0x1.6b3cb4c107b88p-6,    0x1.6b44534c1d7b6p-6,  0x1.f3b9d2p-18, INEXACT) // 2.217023517379915209524199326552e-02
T(RZ,    0x1.6b3cb4c107b88p-6,    0x1.6b44534c1d7b5p-6,  -0x1.ffff06p-1, INEXACT) // 2.217023517379915209524199326552e-02
T(RN,   -0x1.38c8c58832198p-7,   -0x1.38c9fcd5658a7p-7,  -0x1.ffff7cp-2, INEXACT) // -9.545418215922293891928518405621e-03
T(RD,    0x1.e42b4c7fbb47ap-7,    0x1.e42fcf2e96998p-7, -0x1.acbddap-18, INEXACT) // 1.477566943455087614123222294893e-02
T(RU,    0x1.e42b4c7fbb47ap-7,    0x1.e42fcf2e96999p-7,   0x1.ffff2ap-1, INEXACT) // 1.477566943455087614123222294893e-02
T(RZ,    0x1.e42b4c7fbb47ap-7,    0x1.e42fcf2e96998p-7, -0x1.acbddap-18, INEXACT) // 1.477566943455087614123222294893e-02
T(RN,  -0x1.c65f82b5b68afp-17,  -0x1.c65f82b5f22f1p-17,   0x1.ffffe8p-2, INEXACT) // -1.354137325953007845314845364326e-05
T(RN,   0x1.aab040508a026p-14,   0x1.aab0405ce2fcfp-14,   0x1.fffe1ep-2, INEXACT) // 1.017304614455710341704847143873e-04
T(RD,   0x1.250c2619c108dp-25,   0x1.250c2619c108ep-25, -0x1.a34464p-18, INEXACT) // 3.411521394376699155336500114168e-08
T(RU,   0x1.250c2619c108dp-25,   0x1.250c2619c108fp-25,   0x1.ffff2ep-1, INEXACT) // 3.411521394376699155336500114168e-08
T(RZ,   0x1.250c2619c108dp-25,   0x1.250c2619c108ep-25, -0x1.a34464p-18, INEXACT) // 3.411521394376699155336500114168e-08
T(RN,   -0x1.e927970169ac2p-2,   -0x1.fdf9e133af198p-2,  -0x1.fffff8p-2, INEXACT) // -4.776900858509344205415914075274e-01
T(RN,    0x1.bf0e16d9687b1p-5,    0x1.bf46f8a0cd468p-5,  -0x1.ffff18p-2, INEXACT) // 5.457214796776044957171691862641e-02
T(RD,   -0x1.a6a8b35d38188p-8,   -0x1.a6a973626e27bp-8,  -0x1.18cf3p-19, INEXACT) // -6.449264326164778904360019851083e-03
T(RU,   -0x1.a6a8b35d38188p-8,   -0x1.a6a973626e27ap-8,   0x1.ffffbap-1, INEXACT) // -6.449264326164778904360019851083e-03
T(RZ,   -0x1.a6a8b35d38188p-8,   -0x1.a6a973626e27ap-8,   0x1.ffffbap-1, INEXACT) // -6.449264326164778904360019851083e-03
T(RD,   -0x1.87589082b3bb1p-9,   -0x1.8758b69dd522fp-9,  -0x1.ffffeep-1, INEXACT) // -2.985732689331631762447161193563e-03
T(RU,   -0x1.87589082b3bb1p-9,   -0x1.8758b69dd522ep-9,  0x1.22cd2ep-21, INEXACT) // -2.985732689331631762447161193563e-03
T(RZ,   -0x1.87589082b3bb1p-9,   -0x1.8758b69dd522ep-9,  0x1.22cd2ep-21, INEXACT) // -2.985732689331631762447161193563e-03
T(RD,  -0x1.1556adfcbc14ep-20,  -0x1.1556adfcbc4b2p-20, -0x1.77d11cp-18, INEXACT) // -1.033166767413427839455248788414e-06
T(RU,  -0x1.1556adfcbc14ep-20,  -0x1.1556adfcbc4b1p-20,   0x1.ffff44p-1, INEXACT) // -1.033166767413427839455248788414e-06
T(RZ,  -0x1.1556adfcbc14ep-20,  -0x1.1556adfcbc4b1p-20,   0x1.ffff44p-1, INEXACT) // -1.033166767413427839455248788414e-06
T(RD,   0x1.0600e7d92499dp-10,   0x1.0600eab4f930cp-10,  -0x1.ffffeap-1, INEXACT) // 9.994641789360166495709281164750e-04
T(RU,   0x1.0600e7d92499dp-10,   0x1.0600eab4f930dp-10,  0x1.50c9e2p-21, INEXACT) // 9.994641789360166495709281164750e-04
T(RZ,   0x1.0600e7d92499dp-10,   0x1.0600eab4f930cp-10,  -0x1.ffffeap-1, INEXACT) // 9.994641789360166495709281164750e-04
T(RN,  -0x1.d144f7141ba2fp-12,  -0x1.d144f8144037cp-12,   0x1.fffe1ap-2, INEXACT) // -4.437154723352679740709658684494e-04
T(RD,   -0x1.5a196bc309fccp-9,   -0x1.5a19861eaf7bep-9,  -0x1.ffff3ep-1, INEXACT) // -2.640528111005102304686964487246e-03
T(RU,   -0x1.5a196bc309fccp-9,   -0x1.5a19861eaf7bdp-9,   0x1.859c6p-18, INEXACT) // -2.640528111005102304686964487246e-03
T(RZ,   -0x1.5a196bc309fccp-9,   -0x1.5a19861eaf7bdp-9,   0x1.859c6p-18, INEXACT) // -2.640528111005102304686964487246e-03
T(RD,  -0x1.a95c494638f47p-12,  -0x1.a95c4a09f1dcfp-12,  -0x1.ffff78p-1, INEXACT) // -4.056553774616122507411242192887e-04
T(RU,  -0x1.a95c494638f47p-12,  -0x1.a95c4a09f1dcep-12,  0x1.117bd2p-18, INEXACT) // -4.056553774616122507411242192887e-04
T(RZ,  -0x1.a95c494638f47p-12,  -0x1.a95c4a09f1dcep-12,  0x1.117bd2p-18, INEXACT) // -4.056553774616122507411242192887e-04
T(RN,   -0x1.83aa57d9b2216p-4,   -0x1.843f1b4ec8e0fp-4,  -0x1.ffff8ep-2, INEXACT) // -9.464487377693617253804347910773e-02
T(RD,    0x1.8099521f52d18p-2,    0x1.8a44b826f28c9p-2, -0x1.aa8faap-18, INEXACT) // 3.755848724001267235905743291369e-01
T(RU,    0x1.8099521f52d18p-2,    0x1.8a44b826f28cap-2,   0x1.ffff2ap-1, INEXACT) // 3.755848724001267235905743291369e-01
T(RZ,    0x1.8099521f52d18p-2,    0x1.8a44b826f28c9p-2, -0x1.aa8faap-18, INEXACT) // 3.755848724001267235905743291369e-01
T(RD,   -0x1.8ba0083931334p-3,   -0x1.8e20c38fc8ae6p-3, -0x1.f4488ap-20, INEXACT) // -1.931763308004065260448101071233e-01
T(RU,   -0x1.8ba0083931334p-3,   -0x1.8e20c38fc8ae5p-3,   0x1.ffffc2p-1, INEXACT) // -1.931763308004065260448101071233e-01
T(RZ,   -0x1.8ba0083931334p-3,   -0x1.8e20c38fc8ae5p-3,   0x1.ffffc2p-1, INEXACT) // -1.931763308004065260448101071233e-01
T(RN,   0x1.9c7ca428cfbdcp-15,   0x1.9c7ca42b99ad6p-15,   0x1.ffff8ap-2, INEXACT) // 4.917226789879328738112895802459e-05
T(RN,   -0x1.f55d297fe14fp-22,  -0x1.f55d297fe1631p-22,  -0x1.ffff78p-2, INEXACT) // -4.669315316552298086492066298003e-07
T(RN,   0x1.8db9b7e106d22p-25,   0x1.8db9b7e106d24p-25,  -0x1.fffe86p-2, INEXACT) // 4.630133765994473400048723902081e-08
T(RD,   -0x1.1c309c14038bp-15,  -0x1.1c309c14ed069p-15, -0x1.a8117ep-18, INEXACT) // -3.387807387876648392704970191858e-05
T(RU,   -0x1.1c309c14038bp-15,  -0x1.1c309c14ed068p-15,   0x1.ffff2cp-1, INEXACT) // -3.387807387876648392704970191858e-05
T(RZ,   -0x1.1c309c14038bp-15,  -0x1.1c309c14ed068p-15,   0x1.ffff2cp-1, INEXACT) // -3.387807387876648392704970191858e-05
T(RN,  -0x1.852145126f921p-13,  -0x1.85214537e5e26p-13,  -0x1.fffe52p-2, INEXACT) // -1.855516243959932150709574161240e-04
T(RD,   -0x1.efe94f8ad9e01p-4,   -0x1.f12187fe3a3c9p-4,  -0x1.ffffe2p-1, INEXACT) // -1.210721118092053100179228408706e-01
T(RU,   -0x1.efe94f8ad9e01p-4,   -0x1.f12187fe3a3c8p-4,  0x1.ef8b7ep-21, INEXACT) // -1.210721118092053100179228408706e-01
T(RZ,   -0x1.efe94f8ad9e01p-4,   -0x1.f12187fe3a3c8p-4,  0x1.ef8b7ep-21, INEXACT) // -1.210721118092053100179228408706e-01
T(RN,   0x1.4f7496cbd5c64p-25,   0x1.4f7496cbd5c66p-25,   0x1.fffe26p-2, INEXACT) // 3.905215137264173231404246634108e-08
T(RD,   -0x1.606b7ba8d83dcp-7,    -0x1.606d38f059a1p-7, -0x1.90c034p-18, INEXACT) // -1.075500047744697845741868036384e-02
T(RU,   -0x1.606b7ba8d83dcp-7,   -0x1.606d38f059a0fp-7,   0x1.ffff38p-1, INEXACT) // -1.075500047744697845741868036384e-02
T(RZ,   -0x1.606b7ba8d83dcp-7,   -0x1.606d38f059a0fp-7,   0x1.ffff38p-1, INEXACT) // -1.075500047744697845741868036384e-02
T(RN,   0x1.95284180699c2p-10,   0x1.95284c129d29bp-10,   0x1.fffe74p-2, INEXACT) // 1.545552251721469139839060247255e-03
T(RD,   -0x1.5277b6552ed95p-9,   -0x1.5277cefc3b34bp-9,  -0x1.ffff36p-1, INEXACT) // -2.582303054251953392667084941081e-03
T(RU,   -0x1.5277b6552ed95p-9,   -0x1.5277cefc3b34ap-9,  0x1.92df1cp-18, INEXACT) // -2.582303054251953392667084941081e-03
T(RZ,   -0x1.5277b6552ed95p-9,   -0x1.5277cefc3b34ap-9,  0x1.92df1cp-18, INEXACT) // -2.582303054251953392667084941081e-03
T(RD,   0x1.61246f3cdfff6p-23,   0x1.61246f3ce0012p-23, -0x1.bb6722p-18, INEXACT) // 1.644447084302167034557627927488e-07
T(RU,   0x1.61246f3cdfff6p-23,   0x1.61246f3ce0013p-23,   0x1.ffff22p-1, INEXACT) // 1.644447084302167034557627927488e-07
T(RZ,   0x1.61246f3cdfff6p-23,   0x1.61246f3ce0012p-23, -0x1.bb6722p-18, INEXACT) // 1.644447084302167034557627927488e-07
T(RN,   -0x1.eebfb45f16e04p-5,   -0x1.ef0cd38b75a67p-5,  -0x1.fffe34p-2, INEXACT) // -6.039414624020980615348719311442e-02
T(RD,  -0x1.11c7470d97626p-20,  -0x1.11c7470d9796ap-20,  -0x1.ffff68p-1, INEXACT) // -1.019904121511171453867477740274e-06
T(RU,  -0x1.11c7470d97626p-20,  -0x1.11c7470d97969p-20,  0x1.2fe9ccp-18, INEXACT) // -1.019904121511171453867477740274e-06
T(RZ,  -0x1.11c7470d97626p-20,  -0x1.11c7470d97969p-20,  0x1.2fe9ccp-18, INEXACT) // -1.019904121511171453867477740274e-06
T(RN,   -0x1.f158cd15161c6p-4,   -0x1.f293c0c40721cp-4,    0x1.ffff7p-2, INEXACT) // -1.214225779562020102186892245300e-01
T(RN,   0x1.30ecdbf1f7257p-15,   0x1.30ecdbf3178e3p-15,   0x1.ffff5ap-2, INEXACT) // 3.634992016518918234819698898086e-05
T(RN,    0x1.ed4570243ae71p-2,    0x1.0155786866be1p-1,   0x1.fffffcp-2, INEXACT) // 4.817101976502505267241360797925e-01
T(RD,  -0x1.6b2f5ccdc5fdbp-15,  -0x1.6b2f5ccfad4f3p-15,   -0x1.ffff9p-1, INEXACT) // -4.329502699657014527226048250519e-05
T(RU,  -0x1.6b2f5ccdc5fdbp-15,  -0x1.6b2f5ccfad4f2p-15,  0x1.be3cb6p-19, INEXACT) // -4.329502699657014527226048250519e-05
T(RZ,  -0x1.6b2f5ccdc5fdbp-15,  -0x1.6b2f5ccfad4f2p-15,  0x1.be3cb6p-19, INEXACT) // -4.329502699657014527226048250519e-05
T(RD,   0x1.a29b4619088c9p-16,   0x1.a29b4619c3187p-16, -0x1.55e5cep-21, INEXACT) // 2.495089401944523932832566137652e-05
T(RU,   0x1.a29b4619088c9p-16,   0x1.a29b4619c3188p-16,   0x1.ffffeap-1, INEXACT) // 2.495089401944523932832566137652e-05
T(RZ,   0x1.a29b4619088c9p-16,   0x1.a29b4619c3187p-16, -0x1.55e5cep-21, INEXACT) // 2.495089401944523932832566137652e-05
T(RD,  -0x1.d12edbddd291ep-25,  -0x1.d12edbddd2923p-25,  -0x1.ffff6cp-1, INEXACT) // -5.415443358901635401047089521040e-08
T(RU,  -0x1.d12edbddd291ep-25,  -0x1.d12edbddd2922p-25,  0x1.2763fcp-18, INEXACT) // -5.415443358901635401047089521040e-08
T(RZ,  -0x1.d12edbddd291ep-25,  -0x1.d12edbddd2922p-25,  0x1.2763fcp-18, INEXACT) // -5.415443358901635401047089521040e-08
T(RD,   0x1.699bcd7b3ecdfp-21,    0x1.699bcd7b3eecp-21, -0x1.83a526p-21, INEXACT) // 6.735485124359874405800051137827e-07
T(RU,   0x1.699bcd7b3ecdfp-21,   0x1.699bcd7b3eec1p-21,   0x1.ffffe8p-1, INEXACT) // 6.735485124359874405800051137827e-07
T(RZ,   0x1.699bcd7b3ecdfp-21,    0x1.699bcd7b3eecp-21, -0x1.83a526p-21, INEXACT) // 6.735485124359874405800051137827e-07
T(RN,    0x1.086808c1cd403p-3,    0x1.09257f0efa2b7p-3,   -0x1.ffffep-2, INEXACT) // 1.291046795028308602493183343540e-01
T(RN,  -0x1.9708f6c918b8cp-22,  -0x1.9708f6c918c38p-22,  -0x1.ffff0ep-2, INEXACT) // -3.790808987323184865036616517098e-07
T(RN,  -0x1.dc6c48b7e4102p-10,  -0x1.dc6c59e80aacdp-10,   0x1.fffea8p-2, INEXACT) // -1.817409456609964547163516002115e-03
T(RD,  -0x1.98e31c4cb3422p-15,  -0x1.98e31c4f6aaa6p-15, -0x1.55a9cap-18, INEXACT) // -4.874314672562880259524403792071e-05
T(RU,  -0x1.98e31c4cb3422p-15,  -0x1.98e31c4f6aaa5p-15,   0x1.ffff56p-1, INEXACT) // -4.874314672562880259524403792071e-05
T(RZ,  -0x1.98e31c4cb3422p-15,  -0x1.98e31c4f6aaa5p-15,   0x1.ffff56p-1, INEXACT) // -4.874314672562880259524403792071e-05
T(RN,    0x1.ed2e6b7a10c66p-3,    0x1.f213a82fce4eap-3,   0x1.ffff0ap-2, INEXACT) // 2.408111950518076471716710784676e-01
T(RD,  -0x1.89776f933c5cbp-13,   -0x1.89776fb9f6e5p-13, -0x1.fc4634p-18, INEXACT) // -1.876194697625746044596789507963e-04
T(RU,  -0x1.89776f933c5cbp-13,  -0x1.89776fb9f6e4fp-13,   0x1.ffff02p-1, INEXACT) // -1.876194697625746044596789507963e-04
T(RZ,  -0x1.89776f933c5cbp-13,  -0x1.89776fb9f6e4fp-13,   0x1.ffff02p-1, INEXACT) // -1.876194697625746044596789507963e-04
T(RD,  -0x1.c31d465141c9ap-19,  -0x1.c31d4651456f8p-19, -0x1.051e52p-18, INEXACT) // -3.361063854459881562839352470151e-06
T(RU,  -0x1.c31d465141c9ap-19,  -0x1.c31d4651456f7p-19,   0x1.ffff7ep-1, INEXACT) // -3.361063854459881562839352470151e-06
T(RZ,  -0x1.c31d465141c9ap-19,  -0x1.c31d4651456f7p-19,   0x1.ffff7ep-1, INEXACT) // -3.361063854459881562839352470151e-06
T(RN,   -0x1.5aac28325abbbp-4,   -0x1.5b1674d50ec18p-4,  -0x1.ffff02p-2, INEXACT) // -8.463683797678715758916467848394e-02
T(RD,  -0x1.72d78caa77bc6p-12,  -0x1.72d78d2c2a991p-12,  -0x1.ffffacp-1, INEXACT) // -3.536624814425816864735252487151e-04
T(RU,  -0x1.72d78caa77bc6p-12,   -0x1.72d78d2c2a99p-12,  0x1.4cb8bep-19, INEXACT) // -3.536624814425816864735252487151e-04
T(RZ,  -0x1.72d78caa77bc6p-12,   -0x1.72d78d2c2a99p-12,  0x1.4cb8bep-19, INEXACT) // -3.536624814425816864735252487151e-04
T(RN,  -0x1.6a4dc33b7584cp-13,  -0x1.6a4dc359b1fd1p-13,  -0x1.fffec6p-2, INEXACT) // -1.727598954476848363767671479252e-04
T(RN,     0x1.b20494990fbfp-9,    0x1.b204c893de2c6p-9,   0x1.fffefcp-2, INEXACT) // 3.311293734923996534558199300591e-03
T(RD,   0x1.7a0d027921d69p-12,   0x1.7a0d03028ae23p-12, -0x1.fffadep-18, INEXACT) // 3.605373563648402190397190825166e-04
T(RU,   0x1.7a0d027921d69p-12,   0x1.7a0d03028ae24p-12,     0x1.ffffp-1, INEXACT) // 3.605373563648402190397190825166e-04
T(RZ,   0x1.7a0d027921d69p-12,   0x1.7a0d03028ae23p-12, -0x1.fffadep-18, INEXACT) // 3.605373563648402190397190825166e-04
T(RN,  -0x1.8f45fa1e34674p-21,  -0x1.8f45fa1e348fcp-21,   -0x1.ffff9p-2, INEXACT) // -7.437045643992835042247139393234e-07
T(RD,  -0x1.82c381c203d37p-16,  -0x1.82c381c296f52p-16, -0x1.0d7944p-19, INEXACT) // -2.305291287290936363594227864748e-05
T(RU,  -0x1.82c381c203d37p-16,  -0x1.82c381c296f51p-16,   0x1.ffffbcp-1, INEXACT) // -2.305291287290936363594227864748e-05
T(RZ,  -0x1.82c381c203d37p-16,  -0x1.82c381c296f51p-16,   0x1.ffffbcp-1, INEXACT) // -2.305291287290936363594227864748e-05
T(RD,  -0x1.250c03ab12f28p-25,  -0x1.250c03ab12f2ap-25,  -0x1.ffffe2p-1, INEXACT) // -3.411515277963748063691268481989e-08
T(RU,  -0x1.250c03ab12f28p-25,  -0x1.250c03ab12f29p-25,  0x1.d28182p-21, INEXACT) // -3.411515277963748063691268481989e-08
T(RZ,  -0x1.250c03ab12f28p-25,  -0x1.250c03ab12f29p-25,  0x1.d28182p-21, INEXACT) // -3.411515277963748063691268481989e-08
T(RN,  -0x1.e29c633775f0ep-14,  -0x1.e29c634953c5cp-14,  -0x1.ffffecp-2, INEXACT) // -1.150634023966390871978465737513e-04
T(RD,   0x1.75e5fa8dd93f2p-13,   0x1.75e5faaf14e4bp-13,  -0x1.ffff76p-1, INEXACT) // 1.782886287699233054428182843054e-04
T(RU,   0x1.75e5fa8dd93f2p-13,   0x1.75e5faaf14e4cp-13,  0x1.155f92p-18, INEXACT) // 1.782886287699233054428182843054e-04
T(RZ,   0x1.75e5fa8dd93f2p-13,   0x1.75e5faaf14e4bp-13,  -0x1.ffff76p-1, INEXACT) // 1.782886287699233054428182843054e-04
T(RD,  -0x1.bbefa00c7ce47p-21,  -0x1.bbefa00c7d1c2p-21,  -0x1.ffff3ep-1, INEXACT) // -8.268953038390437137590788067854e-07
T(RU,  -0x1.bbefa00c7ce47p-21,  -0x1.bbefa00c7d1c1p-21,  0x1.84b7c4p-18, INEXACT) // -8.268953038390437137590788067854e-07
T(RZ,  -0x1.bbefa00c7ce47p-21,  -0x1.bbefa00c7d1c1p-21,  0x1.84b7c4p-18, INEXACT) // -8.268953038390437137590788067854e-07
T(RN,   0x1.28f40e3b2fd1bp-20,   0x1.28f40e3b30145p-20,   0x1.ffffdcp-2, INEXACT) // 1.106237404610420266799840176286e-06
T(RD,    0x1.81a80559e93b4p-5,    0x1.81cc8671fc83cp-5,  -0x1.ffffe4p-1, INEXACT) // 4.707718892249293518581509943033e-02
T(RU,    0x1.81a80559e93b4p-5,    0x1.81cc8671fc83dp-5,  0x1.cb1cb2p-21, INEXACT) // 4.707718892249293518581509943033e-02
T(RZ,    0x1.81a80559e93b4p-5,    0x1.81cc8671fc83cp-5,  -0x1.ffffe4p-1, INEXACT) // 4.707718892249293518581509943033e-02
T(RN,    0x1.070bb53afbe64p-4,    0x1.073a14d8811e1p-4,   0x1.fffff2p-2, INEXACT) // 6.422014992835439750606951747613e-02
T(RN,    0x1.08f2454aade0bp-6,    0x1.08f53a2612529p-6,   0x1.fffff4p-2, INEXACT) // 1.617104307908160884532655643397e-02
T(RD,  -0x1.35cffc4017eb7p-19,  -0x1.35cffc401919fp-19, -0x1.8c9a26p-18, INEXACT) // -2.308282574900316071420071015186e-06
T(RU,  -0x1.35cffc4017eb7p-19,  -0x1.35cffc401919ep-19,   0x1.ffff3ap-1, INEXACT) // -2.308282574900316071420071015186e-06
T(RZ,  -0x1.35cffc4017eb7p-19,  -0x1.35cffc401919ep-19,   0x1.ffff3ap-1, INEXACT) // -2.308282574900316071420071015186e-06
T(RN,  -0x1.de3b8c16a68a2p-12,  -0x1.de3b8d2cce24dp-12,   0x1.ffffb4p-2, INEXACT) // -4.560781539254631479843316022027e-04
T(RN,   0x1.7a220f0e9d9b7p-22,   0x1.7a220f0e9da41p-22,   0x1.ffff66p-2, INEXACT) // 3.521638384582444513140554644831e-07
T(RD,   -0x1.ee099a5b39906p-8,   -0x1.ee0acd04a645bp-8,  -0x1.ffff5ap-1, INEXACT) // -7.538414177565627358190702977936e-03
T(RU,   -0x1.ee099a5b39906p-8,   -0x1.ee0acd04a645ap-8,   0x1.4c151p-18, INEXACT) // -7.538414177565627358190702977936e-03
T(RZ,   -0x1.ee099a5b39906p-8,   -0x1.ee0acd04a645ap-8,   0x1.4c151p-18, INEXACT) // -7.538414177565627358190702977936e-03
T(RN,  -0x1.e1d7812262639p-22,  -0x1.e1d7812262756p-22,  -0x1.ffff46p-2, INEXACT) // -4.487501589425419825200044929986e-07
T(RD,    0x1.da6157b68b461p-7,    0x1.da6595c32cf1bp-7,  -0x1.ffffe2p-1, INEXACT) // 1.447693617691409202763441754769e-02
T(RU,    0x1.da6157b68b461p-7,    0x1.da6595c32cf1cp-7,  0x1.d1669ap-21, INEXACT) // 1.447693617691409202763441754769e-02
T(RZ,    0x1.da6157b68b461p-7,    0x1.da6595c32cf1bp-7,  -0x1.ffffe2p-1, INEXACT) // 1.447693617691409202763441754769e-02
T(RD,   -0x1.250bd492ddf1p-25,  -0x1.250bd492ddf11p-25,  -0x1.b3606p-18, INEXACT) // -3.411506912289584843414646034288e-08
T(RU,   -0x1.250bd492ddf1p-25,   -0x1.250bd492ddf1p-25,   0x1.ffff26p-1, INEXACT) // -3.411506912289584843414646034288e-08
T(RZ,   -0x1.250bd492ddf1p-25,   -0x1.250bd492ddf1p-25,   0x1.ffff26p-1, INEXACT) // -3.411506912289584843414646034288e-08
T(RN,   0x1.68c8d285005afp-19,   0x1.68c8d2850238bp-19,   0x1.fffee2p-2, INEXACT) // 2.688053714284327531616356973809e-06
T(RN,    0x1.af16bd445f15fp-3,    0x1.b256605523c3dp-3,  -0x1.fffe9ep-2, INEXACT) // 2.104925905695251564520020792770e-01
T(RN,   0x1.bf0c5a7f3263ap-17,   0x1.bf0c5a7f6b314p-17,   0x1.fffe0ep-2, INEXACT) // 1.332307624437027132710716081920e-05
T(RN,  -0x1.27795f325563ep-18,  -0x1.27795f32597d9p-18,  -0x1.ffffeap-2, INEXACT) // -4.402907324359932791642095739615e-06
T(RN,   0x1.d203a4c119449p-21,   0x1.d203a4c11984fp-21,   0x1.fffed8p-2, INEXACT) // 8.680191500130776594806977959629e-07
T(RN,  -0x1.a81bf022f1f7bp-23,  -0x1.a81bf022f1fabp-23,    0x1.fffefp-2, INEXACT) // -1.974912048048667507026387437849e-07
T(RN,   0x1.7f5d8ede52ec2p-15,   0x1.7f5d8ee090126p-15,   0x1.fffe7cp-2, INEXACT) // 4.570072427387057332429792788631e-05
T(RD,   -0x1.ee02788a304f8p-9,   -0x1.ee02c530d92f4p-9,  -0x1.ffff66p-1, INEXACT) // -3.768994535761845815491355438098e-03
T(RU,   -0x1.ee02788a304f8p-9,   -0x1.ee02c530d92f3p-9,  0x1.3413e2p-18, INEXACT) // -3.768994535761845815491355438098e-03
T(RZ,   -0x1.ee02788a304f8p-9,   -0x1.ee02c530d92f3p-9,  0x1.3413e2p-18, INEXACT) // -3.768994535761845815491355438098e-03
T(RN,   -0x1.1ac51039ad37p-22,  -0x1.1ac51039ad3a9p-22,   0x1.fffe4ap-2, INEXACT) // -2.633498784419330542515801096837e-07
T(RD,  -0x1.e3b5f6a75fc1cp-14,  -0x1.e3b5f6b95cee9p-14, -0x1.41b798p-19, INEXACT) // -1.153256404133749433126021610718e-04
T(RU,  -0x1.e3b5f6a75fc1cp-14,  -0x1.e3b5f6b95cee8p-14,    0x1.ffffbp-1, INEXACT) // -1.153256404133749433126021610718e-04
T(RZ,  -0x1.e3b5f6a75fc1cp-14,  -0x1.e3b5f6b95cee8p-14,    0x1.ffffbp-1, INEXACT) // -1.153256404133749433126021610718e-04
T(RN,   0x1.bd43e1a21226fp-10,   0x1.bd43efaa259abp-10,    0x1.ffff4p-2, INEXACT) // 1.698551794577476048084263560156e-03
T(RN,   0x1.6bc63d604c145p-11,   0x1.6bc63f49fdddep-11,  -0x1.ffffa2p-2, INEXACT) // 6.938445549505087165190198028597e-04
T(RD,   0x1.4bc1dffc51477p-11,   0x1.4bc1e16fc24ecp-11,  -0x1.ffffa6p-1, INEXACT) // 6.327768783555139065974404211090e-04
T(RU,   0x1.4bc1dffc51477p-11,   0x1.4bc1e16fc24edp-11,  0x1.6b85e8p-19, INEXACT) // 6.327768783555139065974404211090e-04
T(RZ,   0x1.4bc1dffc51477p-11,   0x1.4bc1e16fc24ecp-11,  -0x1.ffffa6p-1, INEXACT) // 6.327768783555139065974404211090e-04
T(RN,    -0x1.1cfc145e881ep-7,   -0x1.1cfcffd30bb09p-7,  -0x1.ffff28p-2, INEXACT) // -8.697042413644717750997870098217e-03
T(RN,   -0x1.c5b9bf6e0b1ep-13,  -0x1.c5b9bfa96e17ap-13,   0x1.fffee6p-2, INEXACT) // -2.163532148541499541827271002603e-04
T(RN,    0x1.c3acf641392abp-7,    0x1.c3b09fb337699p-7,   -0x1.fffe2p-2, INEXACT) // 1.378404640349491748485544206915e-02
T(RN,   0x1.7d97f9cef8fd3p-13,   0x1.7d97f9f24cd0ep-13,   0x1.ffff02p-2, INEXACT) // 1.819580342888859074337165599999e-04
T(RN,   0x1.7136d720299e9p-26,   0x1.7136d720299e9p-26,  -0x1.fffe38p-2, INEXACT) // 2.149109612548999362950903158163e-08
T(RD,   -0x1.8b784fed1bc67p-3,   -0x1.8df84823085c6p-3,  -0x1.ffff16p-1, INEXACT) // -1.931005710825701437993728859510e-01
T(RU,   -0x1.8b784fed1bc67p-3,   -0x1.8df84823085c5p-3,  0x1.d42464p-18, INEXACT) // -1.931005710825701437993728859510e-01
T(RZ,   -0x1.8b784fed1bc67p-3,   -0x1.8df84823085c5p-3,  0x1.d42464p-18, INEXACT) // -1.931005710825701437993728859510e-01
T(RN,  -0x1.e4ed524a8dd1fp-23,  -0x1.e4ed524a8dd68p-23,   -0x1.ffff4p-2, INEXACT) // -2.258117482599182502264414549795e-07
T(RN,    0x1.325477bd3b7abp-5,    0x1.3266c14c9926ap-5,  -0x1.fffe62p-2, INEXACT) // 3.739379297790831196968142080550e-02
T(RD,    0x1.1fe4fa431f007p-5,    0x1.1ff428261774ep-5,  -0x1.ffff0ep-1, INEXACT) // 3.514336470922790195414719960354e-02
T(RU,    0x1.1fe4fa431f007p-5,    0x1.1ff428261774fp-5,  0x1.e33a36p-18, INEXACT) // 3.514336470922790195414719960354e-02
T(RZ,    0x1.1fe4fa431f007p-5,    0x1.1ff428261774ep-5,  -0x1.ffff0ep-1, INEXACT) // 3.514336470922790195414719960354e-02
T(RD,  -0x1.71373f87dabcdp-24,  -0x1.71373f87dabd5p-24,  -0x1.4f3a5p-18, INEXACT) // -8.596475542319630888818214999383e-08
T(RU,  -0x1.71373f87dabcdp-24,  -0x1.71373f87dabd4p-24,   0x1.ffff58p-1, INEXACT) // -8.596475542319630888818214999383e-08
T(RZ,  -0x1.71373f87dabcdp-24,  -0x1.71373f87dabd4p-24,   0x1.ffff58p-1, INEXACT) // -8.596475542319630888818214999383e-08
T(RD,  -0x1.ba59fc13e00cep-13,  -0x1.ba59fc4ae81d5p-13, -0x1.2d9486p-21, INEXACT) // -2.109296334502686379695768348341e-04
T(RU,  -0x1.ba59fc13e00cep-13,  -0x1.ba59fc4ae81d4p-13,   0x1.ffffeep-1, INEXACT) // -2.109296334502686379695768348341e-04
T(RZ,  -0x1.ba59fc13e00cep-13,  -0x1.ba59fc4ae81d4p-13,   0x1.ffffeep-1, INEXACT) // -2.109296334502686379695768348341e-04
T(RN,  -0x1.f12d662bccaa3p-11,  -0x1.f12d6b0df3af4p-11,   -0x1.fffe1p-2, INEXACT) // -9.482905202048041081938634100368e-04
T(RN,  -0x1.f87d441c2a20fp-20,  -0x1.f87d441c2b677p-20,    0x1.fffeap-2, INEXACT) // -1.879369171434622806408031546466e-06
T(RD,    -0x1.476caaa93698p-9,   -0x1.476cc0fa7755ap-9, -0x1.39260ep-19, INEXACT) // -2.498050530090611953681900558877e-03
T(RU,    -0x1.476caaa93698p-9,   -0x1.476cc0fa77559p-9,   0x1.ffffb2p-1, INEXACT) // -2.498050530090611953681900558877e-03
T(RZ,    -0x1.476caaa93698p-9,   -0x1.476cc0fa77559p-9,   0x1.ffffb2p-1, INEXACT) // -2.498050530090611953681900558877e-03
T(RD,   0x1.3b0462883d9eep-10,   0x1.3b04678040fa6p-10, -0x1.366a26p-19, INEXACT) // 1.201694978644969862696667561863e-03
T(RU,   0x1.3b0462883d9eep-10,   0x1.3b04678040fa7p-10,   0x1.ffffb2p-1, INEXACT) // 1.201694978644969862696667561863e-03
T(RZ,   0x1.3b0462883d9eep-10,   0x1.3b04678040fa6p-10, -0x1.366a26p-19, INEXACT) // 1.201694978644969862696667561863e-03
T(RD,   0x1.a7c527bdb5fb2p-17,   0x1.a7c527bde65d6p-17, -0x1.c7a3d4p-21, INEXACT) // 1.262933426053589711806658668625e-05
T(RU,   0x1.a7c527bdb5fb2p-17,   0x1.a7c527bde65d7p-17,   0x1.ffffe4p-1, INEXACT) // 1.262933426053589711806658668625e-05
T(RZ,   0x1.a7c527bdb5fb2p-17,   0x1.a7c527bde65d6p-17, -0x1.c7a3d4p-21, INEXACT) // 1.262933426053589711806658668625e-05
T(RN,    0x1.7a2c11ce0ea1dp-7,    0x1.7a2e3802304b6p-7,   -0x1.ffff7p-2, INEXACT) // 1.154089803104790291909953481309e-02
T(RD,  -0x1.f91bd38160184p-12,  -0x1.f91bd4c91c5ddp-12,  -0x1.ffff96p-1, INEXACT) // -4.817091904314662557246018437240e-04
T(RU,  -0x1.f91bd38160184p-12,  -0x1.f91bd4c91c5dcp-12,  0x1.a9cd88p-19, INEXACT) // -4.817091904314662557246018437240e-04
T(RZ,  -0x1.f91bd38160184p-12,  -0x1.f91bd4c91c5dcp-12,  0x1.a9cd88p-19, INEXACT) // -4.817091904314662557246018437240e-04
T(RD,  -0x1.49e6a43cc017cp-15,  -0x1.49e6a43e2d557p-15,  -0x1.e9201p-19, INEXACT) // -3.932725710420727975417942712255e-05
T(RU,  -0x1.49e6a43cc017cp-15,  -0x1.49e6a43e2d556p-15,   0x1.ffff86p-1, INEXACT) // -3.932725710420727975417942712255e-05
T(RZ,  -0x1.49e6a43cc017cp-15,  -0x1.49e6a43e2d556p-15,   0x1.ffff86p-1, INEXACT) // -3.932725710420727975417942712255e-05
T(RD,   0x1.29ecf44af1722p-21,   0x1.29ecf44af182fp-21, -0x1.934fd6p-18, INEXACT) // 5.549296785360033522962195165484e-07
T(RU,   0x1.29ecf44af1722p-21,    0x1.29ecf44af183p-21,   0x1.ffff36p-1, INEXACT) // 5.549296785360033522962195165484e-07
T(RZ,   0x1.29ecf44af1722p-21,   0x1.29ecf44af182fp-21, -0x1.934fd6p-18, INEXACT) // 5.549296785360033522962195165484e-07
T(RD,   0x1.31426ac4f058dp-12,   0x1.31426b0d47496p-12, -0x1.c56f1cp-18, INEXACT) // 2.911180893612967776791500273958e-04
T(RU,   0x1.31426ac4f058dp-12,   0x1.31426b0d47497p-12,   0x1.ffff1ep-1, INEXACT) // 2.911180893612967776791500273958e-04
T(RZ,   0x1.31426ac4f058dp-12,   0x1.31426b0d47496p-12, -0x1.c56f1cp-18, INEXACT) // 2.911180893612967776791500273958e-04
T(RD,    0x1.a72cd0391154p-14,   0x1.a72cd0451cdd2p-14,  -0x1.8b83dp-21, INEXACT) // 1.008927946638165165649247967394e-04
T(RU,    0x1.a72cd0391154p-14,   0x1.a72cd0451cdd3p-14,   0x1.ffffe8p-1, INEXACT) // 1.008927946638165165649247967394e-04
T(RZ,    0x1.a72cd0391154p-14,   0x1.a72cd0451cdd2p-14,  -0x1.8b83dp-21, INEXACT) // 1.008927946638165165649247967394e-04
T(RD,   -0x1.1b66bfa239d79p-2,   -0x1.1f2662e4dd9c1p-2, -0x1.6aa66cp-18, INEXACT) // -2.767591421856746003449245563388e-01
T(RU,   -0x1.1b66bfa239d79p-2,    -0x1.1f2662e4dd9cp-2,   0x1.ffff4ap-1, INEXACT) // -2.767591421856746003449245563388e-01
T(RZ,   -0x1.1b66bfa239d79p-2,    -0x1.1f2662e4dd9cp-2,   0x1.ffff4ap-1, INEXACT) // -2.767591421856746003449245563388e-01
T(RN,   -0x1.3f904695270cap-5,   -0x1.3fa509c3dafecp-5,  -0x1.ffff62p-2, INEXACT) // -3.900922570866922900467699264482e-02
T(RN,  -0x1.0e07f5de72be5p-12,    -0x1.0e07f61085ap-12,  -0x1.fffedcp-2, INEXACT) // -2.575217203257248251187239151960e-04
T(RD,    0x1.509045355312cp-5,    0x1.50a8870b5e8dcp-5,  -0x1.ffffa6p-1, INEXACT) // 4.108441846128338403865143391158e-02
T(RU,    0x1.509045355312cp-5,    0x1.50a8870b5e8ddp-5,  0x1.653386p-19, INEXACT) // 4.108441846128338403865143391158e-02
T(RZ,    0x1.509045355312cp-5,    0x1.50a8870b5e8dcp-5,  -0x1.ffffa6p-1, INEXACT) // 4.108441846128338403865143391158e-02
T(RN,  -0x1.b8a206f0cead4p-19,  -0x1.b8a206f0d2139p-19,  -0x1.fffe68p-2, INEXACT) // -3.282971072241438952412674601167e-06
T(RN,  -0x1.d81c06b1033eap-12,  -0x1.d81c07bc9e90ap-12,  -0x1.ffffa6p-2, INEXACT) // -4.502386828456038945014960894753e-04
T(RD,   -0x1.f41f8c8825b9ep-1,   -0x1.5ae05d5a666c9p+0,  -0x1.ffff3cp-1, INEXACT) // -9.768031994052426281172074595816e-01
T(RU,   -0x1.f41f8c8825b9ep-1,   -0x1.5ae05d5a666c8p+0,  0x1.87cbeap-18, INEXACT) // -9.768031994052426281172074595816e-01
T(RZ,   -0x1.f41f8c8825b9ep-1,   -0x1.5ae05d5a666c8p+0,  0x1.87cbeap-18, INEXACT) // -9.768031994052426281172074595816e-01
T(RN,  -0x1.e80ab9756dc8cp-15,   -0x1.e80ab97a0c48p-15,   0x1.fffe8cp-2, INEXACT) // -5.817912726107610731605956910784e-05
T(RD,    0x1.717d5e388a0bep-3,    0x1.73862c50dbde3p-3, -0x1.fb5ce8p-19, INEXACT) // 1.804149018291862360818811339414e-01
T(RU,    0x1.717d5e388a0bep-3,    0x1.73862c50dbde4p-3,   0x1.ffff82p-1, INEXACT) // 1.804149018291862360818811339414e-01
T(RZ,    0x1.717d5e388a0bep-3,    0x1.73862c50dbde3p-3, -0x1.fb5ce8p-19, INEXACT) // 1.804149018291862360818811339414e-01
T(RN,   0x1.43b6949237d45p-17,   0x1.43b694924d657p-17,  -0x1.fffed2p-2, INEXACT) // 9.647405282141511729415185583125e-06
T(RN,  -0x1.1d92b332ab5f6p-10,  -0x1.1d92b6e64db3ap-10,  -0x1.fffe18p-2, INEXACT) // -1.089374720929623448911760519309e-03
T(RD,    0x1.41fafe574fd16p-7,    0x1.41fc51ea9a40ap-7,  -0x1.ffff56p-1, INEXACT) // 9.826063337298889671655999222821e-03
T(RU,    0x1.41fafe574fd16p-7,    0x1.41fc51ea9a40bp-7,  0x1.530282p-18, INEXACT) // 9.826063337298889671655999222821e-03
T(RZ,    0x1.41fafe574fd16p-7,    0x1.41fc51ea9a40ap-7,  -0x1.ffff56p-1, INEXACT) // 9.826063337298889671655999222821e-03
T(RD,   0x1.f26e44d2e9717p-11,   0x1.f26e49be8b0d3p-11, -0x1.03279cp-18, INEXACT) // 9.506811860446631691143326570170e-04
T(RU,   0x1.f26e44d2e9717p-11,   0x1.f26e49be8b0d4p-11,   0x1.ffff7ep-1, INEXACT) // 9.506811860446631691143326570170e-04
T(RZ,   0x1.f26e44d2e9717p-11,   0x1.f26e49be8b0d3p-11, -0x1.03279cp-18, INEXACT) // 9.506811860446631691143326570170e-04
T(RN,   0x1.bc35801ce1ff8p-12,   0x1.bc3580fbcb21cp-12,   0x1.ffffccp-2, INEXACT) // 4.236307011571400875371562477767e-04
T(RD,  -0x1.b19bb0a650e22p-12,  -0x1.b19bb175a53f8p-12, -0x1.02ef84p-19, INEXACT) // -4.135209695912152707067410695174e-04
T(RU,  -0x1.b19bb0a650e22p-12,  -0x1.b19bb175a53f7p-12,    0x1.ffffcp-1, INEXACT) // -4.135209695912152707067410695174e-04
T(RZ,  -0x1.b19bb0a650e22p-12,  -0x1.b19bb175a53f7p-12,    0x1.ffffcp-1, INEXACT) // -4.135209695912152707067410695174e-04
T(RD,   0x1.11734045f93dap-23,   0x1.11734045f93e7p-23, -0x1.a3bdb2p-18, INEXACT) // 1.273351719059289281176232822707e-07
T(RU,   0x1.11734045f93dap-23,   0x1.11734045f93e8p-23,   0x1.ffff2ep-1, INEXACT) // 1.273351719059289281176232822707e-07
T(RZ,   0x1.11734045f93dap-23,   0x1.11734045f93e7p-23, -0x1.a3bdb2p-18, INEXACT) // 1.273351719059289281176232822707e-07
T(RD,  -0x1.2d2d8de727c0bp-18,  -0x1.2d2d8de72c185p-18, -0x1.2d0ed8p-19, INEXACT) // -4.487901129084622844727086449224e-06
T(RU,  -0x1.2d2d8de727c0bp-18,  -0x1.2d2d8de72c184p-18,   0x1.ffffb4p-1, INEXACT) // -4.487901129084622844727086449224e-06
T(RZ,  -0x1.2d2d8de727c0bp-18,  -0x1.2d2d8de72c184p-18,   0x1.ffffb4p-1, INEXACT) // -4.487901129084622844727086449224e-06
T(RN,   -0x1.7dc39c729d67p-15,  -0x1.7dc39c74d3664p-15,  -0x1.fffe3ep-2, INEXACT) // -4.550982784660712997942821900210e-05
T(RD,   0x1.c819d6ab7304bp-19,   0x1.c819d6ab76c9ep-19, -0x1.6a4b34p-18, INEXACT) // 3.398216753080736241254258475641e-06
T(RU,   0x1.c819d6ab7304bp-19,   0x1.c819d6ab76c9fp-19,   0x1.ffff4ap-1, INEXACT) // 3.398216753080736241254258475641e-06
T(RZ,   0x1.c819d6ab7304bp-19,   0x1.c819d6ab76c9ep-19, -0x1.6a4b34p-18, INEXACT) // 3.398216753080736241254258475641e-06
T(RN,   -0x1.81af11263190ep-9,   -0x1.81af359ffffffp-9,   0x1.fffff2p-2, INEXACT) // -2.942534297378013828649923055991e-03
T(RN,  -0x1.943f372833bc7p-24,  -0x1.943f372833bd1p-24,   0x1.fffe64p-2, INEXACT) // -9.412107415954348962983062659368e-08
T(RN,  -0x1.dd9d065e7bedep-12,  -0x1.dd9d07738f499p-12,  -0x1.fffeb4p-2, INEXACT) // -4.554876121849303237040795799828e-04
T(RN,    0x1.fbb66aff484bp-18,   0x1.fbb66aff5d184p-18,  -0x1.fffefcp-2, INEXACT) // 7.565506847912923413072838751958e-06
T(RN,   -0x1.b6534d6b6ccd4p-8,   -0x1.b65423980f92cp-8,   0x1.fffff2p-2, INEXACT) // -6.688314820553393352797755255779e-03
T(RN,   -0x1.36a97a4b9f0d3p-8,   -0x1.36a9c68b8666dp-8,   0x1.fffe5ep-2, INEXACT) // -4.740326268457733908945339607044e-03
T(RN,   0x1.8d5ec8a8000bfp-11,   0x1.8d5ecb2649218p-11,   -0x1.fffebp-2, INEXACT) // 7.579236016681741320774601256005e-04
T(RN,   -0x1.8bc087b2b1b49p-4,   -0x1.8c5ed366a9a5bp-4,   0x1.ffff9cp-2, INEXACT) // -9.661915785828258107503785367953e-02
T(RD,    0x1.571ab4278ddf5p-1,    0x1.780064b615d49p-1,  -0x1.ffff44p-1, INEXACT) // 6.701256082805558955683977728768e-01
T(RU,    0x1.571ab4278ddf5p-1,    0x1.780064b615d4ap-1,  0x1.786d08p-18, INEXACT) // 6.701256082805558955683977728768e-01
T(RZ,    0x1.571ab4278ddf5p-1,    0x1.780064b615d49p-1,  -0x1.ffff44p-1, INEXACT) // 6.701256082805558955683977728768e-01
T(RN,   0x1.2bb702ad96533p-15,   0x1.2bb702aea8336p-15,   -0x1.fffe1p-2, INEXACT) // 3.572879846265100554003266153380e-05
T(RD,   0x1.3c87e67214b3fp-18,   0x1.3c87e67219be5p-18,  -0x1.ffffd2p-1, INEXACT) // 4.716677368748696811057759953334e-06
T(RU,   0x1.3c87e67214b3fp-18,   0x1.3c87e67219be6p-18,  0x1.6d54b4p-20, INEXACT) // 4.716677368748696811057759953334e-06
T(RZ,   0x1.3c87e67214b3fp-18,   0x1.3c87e67219be5p-18,  -0x1.ffffd2p-1, INEXACT) // 4.716677368748696811057759953334e-06
T(RN,   0x1.662561d590c69p-17,   0x1.662561d5adfb9p-17,  -0x1.fffe78p-2, INEXACT) // 1.067358327156414401191714819150e-05
T(RN,   0x1.85d7149d34563p-11,   0x1.85d716f7e3142p-11,   0x1.fffe72p-2, INEXACT) // 7.435610929410859304064529418099e-04
T(RN,   0x1.e3cf544d91284p-25,   0x1.e3cf544d91289p-25,    0x1.fffe9p-2, INEXACT) // 5.632288289624684818515502632980e-08
T(RN,   0x1.bcee8321d58a5p-25,   0x1.bcee8321d58a9p-25,   0x1.fffe48p-2, INEXACT) // 5.179686569818751731329874881705e-08
T(RD,    0x1.ba4cf988a25fp-14,   0x1.ba4cf996632c6p-14,  -0x1.77613p-20, INEXACT) // 1.054527002769740148119259615100e-04
T(RU,    0x1.ba4cf988a25fp-14,   0x1.ba4cf996632c7p-14,   0x1.ffffd2p-1, INEXACT) // 1.054527002769740148119259615100e-04
T(RZ,    0x1.ba4cf988a25fp-14,   0x1.ba4cf996632c6p-14,  -0x1.77613p-20, INEXACT) // 1.054527002769740148119259615100e-04
T(RN,   0x1.2eff6037956a1p-13,   0x1.2eff604944fecp-13,   0x1.fffe0ap-2, INEXACT) // 1.444804963621109446681584076444e-04
T(RN,    0x1.a3bb0c6c447bap-6,    0x1.a3c6ce2a0c639p-6,   -0x1.ffffep-2, INEXACT) // 2.561832631278779942585188678095e-02
T(RN,    0x1.756bfe811cebep-5,    0x1.758d2199a97e1p-5,   0x1.fffef6p-2, INEXACT) // 4.558372218971616651739253711639e-02
T(RN,  -0x1.1fadd034a6741p-13,  -0x1.1fadd043c9773p-13,   0x1.ffffb8p-2, INEXACT) // -1.371760169107065073946377653513e-04
T(RN,    -0x1.982be977657dp-5,   -0x1.9857320c3fdf5p-5,    0x1.fffe2p-2, INEXACT) // -4.982562636284593171609458295279e-02
T(RD,   0x1.0a82a9bdcc1cdp-10,   0x1.0a82acc00c04bp-10, -0x1.fc6fa6p-18, INEXACT) // 1.016656503861057591134309241454e-03
T(RU,   0x1.0a82a9bdcc1cdp-10,   0x1.0a82acc00c04cp-10,   0x1.ffff02p-1, INEXACT) // 1.016656503861057591134309241454e-03
T(RZ,   0x1.0a82a9bdcc1cdp-10,   0x1.0a82acc00c04bp-10, -0x1.fc6fa6p-18, INEXACT) // 1.016656503861057591134309241454e-03
T(RD,   -0x1.13e08eaab2739p-6,    -0x1.13e3e5205b3fp-6, -0x1.854838p-20, INEXACT) // -1.683820659926668975026053942656e-02
T(RU,   -0x1.13e08eaab2739p-6,   -0x1.13e3e5205b3efp-6,    0x1.ffffdp-1, INEXACT) // -1.683820659926668975026053942656e-02
T(RZ,   -0x1.13e08eaab2739p-6,   -0x1.13e3e5205b3efp-6,    0x1.ffffdp-1, INEXACT) // -1.683820659926668975026053942656e-02
T(RD,  -0x1.16026045161cfp-16,  -0x1.160260454cc1fp-16, -0x1.4cb4ecp-21, INEXACT) // -1.657064446578139556439344948213e-05
T(RU,  -0x1.16026045161cfp-16,  -0x1.160260454cc1ep-16,   0x1.ffffecp-1, INEXACT) // -1.657064446578139556439344948213e-05
T(RZ,  -0x1.16026045161cfp-16,  -0x1.160260454cc1ep-16,   0x1.ffffecp-1, INEXACT) // -1.657064446578139556439344948213e-05
T(RD,      0x1.2e4708d812bp-8,    0x1.2e474f15c14dbp-8, -0x1.9c93d8p-18, INEXACT) // 4.612388285816448885157115000766e-03
T(RU,      0x1.2e4708d812bp-8,    0x1.2e474f15c14dcp-8,   0x1.ffff32p-1, INEXACT) // 4.612388285816448885157115000766e-03
T(RZ,      0x1.2e4708d812bp-8,    0x1.2e474f15c14dbp-8, -0x1.9c93d8p-18, INEXACT) // 4.612388285816448885157115000766e-03
T(RN,   -0x1.f7a62065d2408p-5,    -0x1.f7f77d9551cdp-5,  -0x1.ffff12p-2, INEXACT) // -6.148058250125393309204469005635e-02
T(RD,   0x1.bfdb82d32ad5bp-10,    0x1.bfdb911a5909p-10, -0x1.fefe38p-18, INEXACT) // 1.708440647045636777076604850834e-03
T(RU,   0x1.bfdb82d32ad5bp-10,   0x1.bfdb911a59091p-10,     0x1.ffffp-1, INEXACT) // 1.708440647045636777076604850834e-03
T(RZ,   0x1.bfdb82d32ad5bp-10,    0x1.bfdb911a5909p-10, -0x1.fefe38p-18, INEXACT) // 1.708440647045636777076604850834e-03
T(RD,    0x1.0793fd919f553p-7,    0x1.0794b7d9a58e5p-7, -0x1.2caf52p-18, INEXACT) // 8.043764889630244593887731241466e-03
T(RU,    0x1.0793fd919f553p-7,    0x1.0794b7d9a58e6p-7,   0x1.ffff6ap-1, INEXACT) // 8.043764889630244593887731241466e-03
T(RZ,    0x1.0793fd919f553p-7,    0x1.0794b7d9a58e5p-7, -0x1.2caf52p-18, INEXACT) // 8.043764889630244593887731241466e-03
T(RD,  -0x1.3a29cc2993383p-12,  -0x1.3a29cc786e5efp-12,  -0x1.ffffb6p-1, INEXACT) // -2.996094432077754904190924900576e-04
T(RU,  -0x1.3a29cc2993383p-12,  -0x1.3a29cc786e5eep-12,  0x1.24b676p-19, INEXACT) // -2.996094432077754904190924900576e-04
T(RZ,  -0x1.3a29cc2993383p-12,  -0x1.3a29cc786e5eep-12,  0x1.24b676p-19, INEXACT) // -2.996094432077754904190924900576e-04
T(RD,   0x1.a6a59fff119c4p-25,   0x1.a6a59fff119c7p-25, -0x1.96e8a8p-18, INEXACT) // 4.920258333449549795057126073267e-08
T(RU,   0x1.a6a59fff119c4p-25,   0x1.a6a59fff119c8p-25,   0x1.ffff34p-1, INEXACT) // 4.920258333449549795057126073267e-08
T(RZ,   0x1.a6a59fff119c4p-25,   0x1.a6a59fff119c7p-25, -0x1.96e8a8p-18, INEXACT) // 4.920258333449549795057126073267e-08
T(RD,    0x1.085c7aaa68bb9p-8,    0x1.085ca9a6bd3d6p-8, -0x1.800ca2p-21, INEXACT) // 4.033832500144046186163482303755e-03
T(RU,    0x1.085c7aaa68bb9p-8,    0x1.085ca9a6bd3d7p-8,   0x1.ffffe8p-1, INEXACT) // 4.033832500144046186163482303755e-03
T(RZ,    0x1.085c7aaa68bb9p-8,    0x1.085ca9a6bd3d6p-8, -0x1.800ca2p-21, INEXACT) // 4.033832500144046186163482303755e-03
T(RD,   -0x1.7268c22179d4bp-9,   -0x1.7268e271317fcp-9, -0x1.6d0132p-18, INEXACT) // -2.825998017886332310671937406710e-03
T(RU,   -0x1.7268c22179d4bp-9,   -0x1.7268e271317fbp-9,   0x1.ffff4ap-1, INEXACT) // -2.825998017886332310671937406710e-03
T(RZ,   -0x1.7268c22179d4bp-9,   -0x1.7268e271317fbp-9,   0x1.ffff4ap-1, INEXACT) // -2.825998017886332310671937406710e-03
T(RN,    0x1.29c2b40bcaea8p-8,    0x1.29c2f72f5b5f4p-8,   0x1.ffff1ap-2, INEXACT) // 4.543465572890127701644047419904e-03
T(RD,    0x1.736f04f11d3f9p-1,    0x1.9f96c856af8e9p-1,  -0x1.ffffaep-1, INEXACT) // 7.254563850716514439298521210731e-01
T(RU,    0x1.736f04f11d3f9p-1,    0x1.9f96c856af8eap-1,    0x1.449dp-19, INEXACT) // 7.254563850716514439298521210731e-01
T(RZ,    0x1.736f04f11d3f9p-1,    0x1.9f96c856af8e9p-1,  -0x1.ffffaep-1, INEXACT) // 7.254563850716514439298521210731e-01
T(RN,  -0x1.30c7f9dfc917fp-24,  -0x1.30c7f9dfc9184p-24,  -0x1.fffe34p-2, INEXACT) // -7.096239284778318317047340326939e-08
T(RN,   -0x1.8d40d3863381dp-5,   -0x1.8d68b9e1ccdb1p-5,   0x1.ffff6cp-2, INEXACT) // -4.849282563519372729610168448744e-02
T(RD,   -0x1.dd8995cb07328p-3,   -0x1.e1f95f7a8ce07p-3,  -0x1.ffff26p-1, INEXACT) // -2.331725790581000712364811988664e-01
T(RU,   -0x1.dd8995cb07328p-3,   -0x1.e1f95f7a8ce06p-3,  0x1.b24962p-18, INEXACT) // -2.331725790581000712364811988664e-01
T(RZ,   -0x1.dd8995cb07328p-3,   -0x1.e1f95f7a8ce06p-3,  0x1.b24962p-18, INEXACT) // -2.331725790581000712364811988664e-01
T(RD,  -0x1.0a402ba497f9bp-24,  -0x1.0a402ba497f9ep-24, -0x1.1fb238p-19, INEXACT) // -6.199131392372677738641988066590e-08
T(RU,  -0x1.0a402ba497f9bp-24,  -0x1.0a402ba497f9dp-24,   0x1.ffffb8p-1, INEXACT) // -6.199131392372677738641988066590e-08
T(RZ,  -0x1.0a402ba497f9bp-24,  -0x1.0a402ba497f9dp-24,   0x1.ffffb8p-1, INEXACT) // -6.199131392372677738641988066590e-08
T(RD,     0x1.bec20e8beb37p-5,    0x1.befad34bdeeebp-5, -0x1.6e8dd2p-18, INEXACT) // 5.453589287876681179767501816968e-02
T(RU,     0x1.bec20e8beb37p-5,    0x1.befad34bdeeecp-5,   0x1.ffff48p-1, INEXACT) // 5.453589287876681179767501816968e-02
T(RZ,     0x1.bec20e8beb37p-5,    0x1.befad34bdeeebp-5, -0x1.6e8dd2p-18, INEXACT) // 5.453589287876681179767501816968e-02
T(RN,     -0x1.fba11d79b8ep-9,   -0x1.fba170a484d18p-9,  -0x1.ffffcap-2, INEXACT) // -3.872904632645335354368398839142e-03
T(RN,    0x1.7ae100fba3af7p-1,    0x1.aa87c994d4f09p-1,   0x1.fffed8p-2, INEXACT) // 7.399978930642124863581443605653e-01
T(RD,  -0x1.d12e932a93b57p-26,  -0x1.d12e932a93b58p-26, -0x1.9640c2p-18, INEXACT) // -2.707715222377902764876361535375e-08
T(RU,  -0x1.d12e932a93b57p-26,  -0x1.d12e932a93b57p-26,   0x1.ffff34p-1, INEXACT) // -2.707715222377902764876361535375e-08
T(RZ,  -0x1.d12e932a93b57p-26,  -0x1.d12e932a93b57p-26,   0x1.ffff34p-1, INEXACT) // -2.707715222377902764876361535375e-08
T(RD,  -0x1.fb4a463e5b233p-23,  -0x1.fb4a463e5b286p-23, -0x1.92e1a8p-19, INEXACT) // -2.362253769915280595848055189209e-07
T(RU,  -0x1.fb4a463e5b233p-23,  -0x1.fb4a463e5b285p-23,   0x1.ffff9cp-1, INEXACT) // -2.362253769915280595848055189209e-07
T(RZ,  -0x1.fb4a463e5b233p-23,  -0x1.fb4a463e5b285p-23,   0x1.ffff9cp-1, INEXACT) // -2.362253769915280595848055189209e-07
T(RN,    0x1.d487ff9efd407p-8,    0x1.d4890531eb373p-8,   0x1.ffff3ap-2, INEXACT) // 7.149219424708703161941425463510e-03
T(RN,  -0x1.9b11f81f03ad5p-15,  -0x1.9b11f821c6483p-15,   0x1.fffe86p-2, INEXACT) // -4.900338557699771008116865211868e-05
T(RD,  -0x1.a6a58032c5dccp-25,  -0x1.a6a58032c5dcfp-25, -0x1.1e762cp-18, INEXACT) // -4.920252684984596522114704605227e-08
T(RU,  -0x1.a6a58032c5dccp-25,  -0x1.a6a58032c5dcep-25,    0x1.ffff7p-1, INEXACT) // -4.920252684984596522114704605227e-08
T(RZ,  -0x1.a6a58032c5dccp-25,  -0x1.a6a58032c5dcep-25,    0x1.ffff7p-1, INEXACT) // -4.920252684984596522114704605227e-08
T(RN,    0x1.74144380249b6p-7,    0x1.74164f89057c4p-7,   0x1.ffff98p-2, INEXACT) // 1.135495468068801680483481675310e-02
T(RD,   0x1.d12eb57b4e3cbp-26,   0x1.d12eb57b4e3cbp-26,  -0x1.ffffa6p-1, INEXACT) // 2.707718270192898373572170679906e-08
T(RU,   0x1.d12eb57b4e3cbp-26,   0x1.d12eb57b4e3ccp-26,  0x1.6747b8p-19, INEXACT) // 2.707718270192898373572170679906e-08
T(RZ,   0x1.d12eb57b4e3cbp-26,   0x1.d12eb57b4e3cbp-26,  -0x1.ffffa6p-1, INEXACT) // 2.707718270192898373572170679906e-08
T(RN,  -0x1.aeb98b775ece5p-15,  -0x1.aeb98b7a8bb09p-15,  -0x1.ffffb8p-2, INEXACT) // -5.134639553269221024520488350085e-05
T(RN,   0x1.80da6e528feaep-16,   0x1.80da6e5320e13p-16,   0x1.fffea2p-2, INEXACT) // 2.293904101180351651862940332016e-05
T(RN,    0x1.98419796120e5p-3,    0x1.9b0276c7b2046p-3,   0x1.fffecep-2, INEXACT) // 1.993438570664302356139074845487e-01
T(RN,  -0x1.ecf20c59d5bbap-21,  -0x1.ecf20c59d607cp-21,   0x1.fffee2p-2, INEXACT) // -9.181825461984532066648080975146e-07
T(RN,   0x1.e3cf45a43d46cp-25,    0x1.e3cf45a43d47p-25,  -0x1.ffffcep-2, INEXACT) // 5.632285685230443157221877272661e-08
T(RD,  -0x1.6fbe0ef6ce2a4p-17,  -0x1.6fbe0ef6edc8ap-17,  -0x1.ffff98p-1, INEXACT) // -1.095957803230854953795495032587e-05
T(RU,  -0x1.6fbe0ef6ce2a4p-17,  -0x1.6fbe0ef6edc89p-17,  0x1.9e1682p-19, INEXACT) // -1.095957803230854953795495032587e-05
T(RZ,  -0x1.6fbe0ef6ce2a4p-17,  -0x1.6fbe0ef6edc89p-17,  0x1.9e1682p-19, INEXACT) // -1.095957803230854953795495032587e-05
T(RN,   -0x1.cc7217a5e2937p-4,   -0x1.cd6bc5f3f8018p-4,  -0x1.fffe1cp-2, INEXACT) // -1.124134944676925401685352312597e-01
T(RN,    0x1.4a0f09c96fa6ep-7,    0x1.4a107791a2a4bp-7,  -0x1.fffedep-2, INEXACT) // 1.007259347795505174949504123560e-02
T(RN,    -0x1.4ae6b3750d02p-7,   -0x1.4ae8240c1e178p-7,   0x1.ffff26p-2, INEXACT) // -1.009830248413129405449240039161e-02
T(RD,    0x1.3583709cdaa7p-19,   0x1.3583709cdbd49p-19,  -0x1.ffff4ep-1, INEXACT) // 2.306054808822337917183914468566e-06
T(RU,    0x1.3583709cdaa7p-19,   0x1.3583709cdbd4ap-19,  0x1.62d764p-18, INEXACT) // 2.306054808822337917183914468566e-06
T(RZ,    0x1.3583709cdaa7p-19,   0x1.3583709cdbd49p-19,  -0x1.ffff4ep-1, INEXACT) // 2.306054808822337917183914468566e-06
T(RN,    0x1.fc9a2cf0389f3p-3,    0x1.00fd8956e4591p-2,  -0x1.fffef4p-2, INEXACT) // 2.483409415063558556280298716956e-01
T(RN,  -0x1.acb97fe0d5125p-10,  -0x1.acb98c67486f6p-10,   0x1.ffff72p-2, INEXACT) // -1.635454588002246663694383421728e-03
T(RD,   0x1.3b37749a94b67p-12,   0x1.3b3774ea3b99bp-12,  -0x1.ffff42p-1, INEXACT) // 3.006139974434579912286602532134e-04
T(RU,   0x1.3b37749a94b67p-12,   0x1.3b3774ea3b99cp-12,  0x1.7c0b0cp-18, INEXACT) // 3.006139974434579912286602532134e-04
T(RZ,   0x1.3b37749a94b67p-12,   0x1.3b3774ea3b99bp-12,  -0x1.ffff42p-1, INEXACT) // 3.006139974434579912286602532134e-04
T(RN,    0x1.30c7f16392d3p-24,   0x1.30c7f16392d35p-24,   0x1.ffffb6p-2, INEXACT) // 7.096236270228612064831213296356e-08
T(RD,    0x1.03e77c7a2eb46p-9,    0x1.03e787a3b47c1p-9, -0x1.bd1e52p-18, INEXACT) // 1.982912011127354982853443488011e-03
T(RU,    0x1.03e77c7a2eb46p-9,    0x1.03e787a3b47c2p-9,   0x1.ffff22p-1, INEXACT) // 1.982912011127354982853443488011e-03
T(RZ,    0x1.03e77c7a2eb46p-9,    0x1.03e787a3b47c1p-9, -0x1.bd1e52p-18, INEXACT) // 1.982912011127354982853443488011e-03
T(RD,    0x1.d36212fd71d2ap-2,    0x1.e55a545f5331cp-2,  -0x1.ffff7ep-1, INEXACT) // 4.564288108053512482698010899185e-01
T(RU,    0x1.d36212fd71d2ap-2,    0x1.e55a545f5331dp-2,  0x1.04694ap-18, INEXACT) // 4.564288108053512482698010899185e-01
T(RZ,    0x1.d36212fd71d2ap-2,    0x1.e55a545f5331cp-2,  -0x1.ffff7ep-1, INEXACT) // 4.564288108053512482698010899185e-01
T(RD,    0x1.fd51c209ca12p-24,   0x1.fd51c209ca135p-24, -0x1.70cb9cp-18, INEXACT) // 1.185851560529712794584290130873e-07
T(RU,    0x1.fd51c209ca12p-24,   0x1.fd51c209ca136p-24,   0x1.ffff48p-1, INEXACT) // 1.185851560529712794584290130873e-07
T(RZ,    0x1.fd51c209ca12p-24,   0x1.fd51c209ca135p-24, -0x1.70cb9cp-18, INEXACT) // 1.185851560529712794584290130873e-07
T(RD,    0x1.28286e4d5e9b3p-2,    0x1.2c734717b9b5ap-2,  -0x1.ffff14p-1, INEXACT) // 2.892167315218571732593488832208e-01
T(RU,    0x1.28286e4d5e9b3p-2,    0x1.2c734717b9b5bp-2,  0x1.d6c418p-18, INEXACT) // 2.892167315218571732593488832208e-01
T(RZ,    0x1.28286e4d5e9b3p-2,    0x1.2c734717b9b5ap-2,  -0x1.ffff14p-1, INEXACT) // 2.892167315218571732593488832208e-01
T(RN,   0x1.313b781ffd0fdp-19,   0x1.313b781ffe311p-19,   -0x1.ffff9p-2, INEXACT) // 2.274157864684999155003653284468e-06
T(RD,   0x1.184a0b2919f23p-23,   0x1.184a0b2919f31p-23, -0x1.3b80aep-20, INEXACT) // 1.305198449625219952456876620558e-07
T(RU,   0x1.184a0b2919f23p-23,   0x1.184a0b2919f32p-23,   0x1.ffffd8p-1, INEXACT) // 1.305198449625219952456876620558e-07
T(RZ,   0x1.184a0b2919f23p-23,   0x1.184a0b2919f31p-23, -0x1.3b80aep-20, INEXACT) // 1.305198449625219952456876620558e-07
T(RD,   -0x1.40912e2b30923p-3,   -0x1.41e409dc27c7bp-3, -0x1.45a7fcp-19, INEXACT) // -1.565269095354518691376455308273e-01
T(RU,   -0x1.40912e2b30923p-3,   -0x1.41e409dc27c7ap-3,   0x1.ffffaep-1, INEXACT) // -1.565269095354518691376455308273e-01
T(RZ,   -0x1.40912e2b30923p-3,   -0x1.41e409dc27c7ap-3,   0x1.ffffaep-1, INEXACT) // -1.565269095354518691376455308273e-01
T(RD,   0x1.99cfbe48df71bp-12,   0x1.99cfbef7e8076p-12,  -0x1.ffffaap-1, INEXACT) // 3.908266995081719689768273706676e-04
T(RU,   0x1.99cfbe48df71bp-12,   0x1.99cfbef7e8077p-12,  0x1.5a45e2p-19, INEXACT) // 3.908266995081719689768273706676e-04
T(RZ,   0x1.99cfbe48df71bp-12,   0x1.99cfbef7e8076p-12,  -0x1.ffffaap-1, INEXACT) // 3.908266995081719689768273706676e-04
T(RD,   0x1.6e20146f261d9p-19,   0x1.6e20146f2810dp-19, -0x1.ff83a4p-18, INEXACT) // 2.727846144145513113322314494025e-06
T(RU,   0x1.6e20146f261d9p-19,   0x1.6e20146f2810ep-19,     0x1.ffffp-1, INEXACT) // 2.727846144145513113322314494025e-06
T(RZ,   0x1.6e20146f261d9p-19,   0x1.6e20146f2810dp-19, -0x1.ff83a4p-18, INEXACT) // 2.727846144145513113322314494025e-06
T(RD,  -0x1.73e4ecb7bef5cp-13,  -0x1.73e4ecd87288dp-13, -0x1.889df2p-19, INEXACT) // -1.773329911357546207970048435243e-04
T(RU,  -0x1.73e4ecb7bef5cp-13,  -0x1.73e4ecd87288cp-13,   0x1.ffff9ep-1, INEXACT) // -1.773329911357546207970048435243e-04
T(RZ,  -0x1.73e4ecb7bef5cp-13,  -0x1.73e4ecd87288cp-13,   0x1.ffff9ep-1, INEXACT) // -1.773329911357546207970048435243e-04
T(RN,   -0x1.713734ecce88p-26,   -0x1.713734ecce88p-26,   0x1.ffffbep-2, INEXACT) // -2.149117943608517647163975994307e-08
T(RD,  -0x1.67480e48b27efp-15,  -0x1.67480e4a8a44fp-15,   -0x1.ffffep-1, INEXACT) // -4.282968854381330041673422992510e-05
T(RU,  -0x1.67480e48b27efp-15,  -0x1.67480e4a8a44ep-15,  0x1.fcec06p-21, INEXACT) // -4.282968854381330041673422992510e-05
T(RZ,  -0x1.67480e48b27efp-15,  -0x1.67480e4a8a44ep-15,  0x1.fcec06p-21, INEXACT) // -4.282968854381330041673422992510e-05
T(RD,    0x1.2b145cfacc901p-6,    0x1.2b189db1becddp-6,   -0x1.ffff7p-1, INEXACT) // 1.825436668441060908407713725410e-02
T(RU,    0x1.2b145cfacc901p-6,    0x1.2b189db1becdep-6,  0x1.202b2ep-18, INEXACT) // 1.825436668441060908407713725410e-02
T(RZ,    0x1.2b145cfacc901p-6,    0x1.2b189db1becddp-6,   -0x1.ffff7p-1, INEXACT) // 1.825436668441060908407713725410e-02
T(RD,   0x1.a2f21032c40cbp-22,   0x1.a2f21032c4185p-22,   -0x1.ffff5p-1, INEXACT) // 3.901734572523306907524526503800e-07
T(RU,   0x1.a2f21032c40cbp-22,   0x1.a2f21032c4186p-22,  0x1.61c5eep-18, INEXACT) // 3.901734572523306907524526503800e-07
T(RZ,   0x1.a2f21032c40cbp-22,   0x1.a2f21032c4185p-22,   -0x1.ffff5p-1, INEXACT) // 3.901734572523306907524526503800e-07
T(RD,   0x1.b213352e9aa4cp-24,   0x1.b213352e9aa58p-24,  -0x1.ffff98p-1, INEXACT) // 1.010659686856995640655005729708e-07
T(RU,   0x1.b213352e9aa4cp-24,   0x1.b213352e9aa59p-24,  0x1.9f93e6p-19, INEXACT) // 1.010659686856995640655005729708e-07
T(RZ,   0x1.b213352e9aa4cp-24,   0x1.b213352e9aa58p-24,  -0x1.ffff98p-1, INEXACT) // 1.010659686856995640655005729708e-07
T(RD,   0x1.1b940b0d57d1dp-16,   0x1.1b940b0d91d07p-16, -0x1.0f99c4p-18, INEXACT) // 1.690258345854205840439084262972e-05
T(RU,   0x1.1b940b0d57d1dp-16,   0x1.1b940b0d91d08p-16,   0x1.ffff78p-1, INEXACT) // 1.690258345854205840439084262972e-05
T(RZ,   0x1.1b940b0d57d1dp-16,   0x1.1b940b0d91d07p-16, -0x1.0f99c4p-18, INEXACT) // 1.690258345854205840439084262972e-05
T(RN,   -0x1.82885bac05c78p-4,   -0x1.831bd15f2158dp-4,  -0x1.ffff42p-2, INEXACT) // -9.436832246170634430626478206250e-02
T(RN,   0x1.79b2c256ca297p-12,   0x1.79b2c2dfd0e38p-12,  -0x1.ffff1cp-2, INEXACT) // 3.602011469632597473987389857797e-04
T(RN,   0x1.f7af5c9869ab3p-13,   0x1.f7af5ce9a7dfep-13,  -0x1.ffffe2p-2, INEXACT) // 2.401757271972192132793860741558e-04
T(RN,  -0x1.ce7b15e36012dp-10,  -0x1.ce7b259c6b1ebp-10,  -0x1.fffe52p-2, INEXACT) // -1.764224253605627167409974909162e-03
T(RN,    0x1.ec318d33f561cp-2,    0x1.00b81cb7c3cbfp-1,  -0x1.ffff7ep-2, INEXACT) // 4.806577742541280340304865603684e-01
T(RD,   -0x1.6a9a09d472d04p-9,   -0x1.6a9a28240ebb6p-9,  -0x1.ffffbap-1, INEXACT) // -2.766431522308489612815840530402e-03
T(RU,   -0x1.6a9a09d472d04p-9,   -0x1.6a9a28240ebb5p-9,  0x1.1bc65cp-19, INEXACT) // -2.766431522308489612815840530402e-03
T(RZ,   -0x1.6a9a09d472d04p-9,   -0x1.6a9a28240ebb5p-9,  0x1.1bc65cp-19, INEXACT) // -2.766431522308489612815840530402e-03
T(RD,  -0x1.61246e63abf8ep-23,  -0x1.61246e63abfabp-23,  -0x1.ffff8ap-1, INEXACT) // -1.644447024016161907102853614177e-07
T(RU,  -0x1.61246e63abf8ep-23,  -0x1.61246e63abfaap-23,  0x1.d97c7cp-19, INEXACT) // -1.644447024016161907102853614177e-07
T(RZ,  -0x1.61246e63abf8ep-23,  -0x1.61246e63abfaap-23,  0x1.d97c7cp-19, INEXACT) // -1.644447024016161907102853614177e-07
T(RD,   0x1.33fd352e07654p-15,   0x1.33fd352f3095fp-15,   -0x1.fffffp-1, INEXACT) // 3.671516093127201473857168512183e-05
T(RU,   0x1.33fd352e07654p-15,    0x1.33fd352f3096p-15,   0x1.efc32p-22, INEXACT) // 3.671516093127201473857168512183e-05
T(RZ,   0x1.33fd352e07654p-15,   0x1.33fd352f3095fp-15,   -0x1.fffffp-1, INEXACT) // 3.671516093127201473857168512183e-05
T(RD,   0x1.33e57383e783ap-18,   0x1.33e57383ec275p-18, -0x1.c7d344p-20, INEXACT) // 4.588012305987689554696330740402e-06
T(RU,   0x1.33e57383e783ap-18,   0x1.33e57383ec276p-18,   0x1.ffffc8p-1, INEXACT) // 4.588012305987689554696330740402e-06
T(RZ,   0x1.33e57383e783ap-18,   0x1.33e57383ec275p-18, -0x1.c7d344p-20, INEXACT) // 4.588012305987689554696330740402e-06
T(RN,  -0x1.89f6298220d7bp-22,  -0x1.89f6298220e17p-22,  -0x1.ffff56p-2, INEXACT) // -3.669053044790421896951214657950e-07
T(RD,   -0x1.2c58c4aae62cp-12,   -0x1.2c58c4efcd52p-12, -0x1.670d54p-19, INEXACT) // -2.864329823580140377270453200254e-04
T(RU,   -0x1.2c58c4aae62cp-12,  -0x1.2c58c4efcd51fp-12,   0x1.ffffa6p-1, INEXACT) // -2.864329823580140377270453200254e-04
T(RZ,   -0x1.2c58c4aae62cp-12,  -0x1.2c58c4efcd51fp-12,   0x1.ffffa6p-1, INEXACT) // -2.864329823580140377270453200254e-04
T(RD,   0x1.c865eaa5ffe9cp-12,   0x1.c865eb97c4be1p-12,  -0x1.ffffeep-1, INEXACT) // 4.352551571855463232590954802959e-04
T(RU,   0x1.c865eaa5ffe9cp-12,   0x1.c865eb97c4be2p-12,  0x1.217798p-21, INEXACT) // 4.352551571855463232590954802959e-04
T(RZ,   0x1.c865eaa5ffe9cp-12,   0x1.c865eb97c4be1p-12,  -0x1.ffffeep-1, INEXACT) // 4.352551571855463232590954802959e-04
T(RD,   0x1.c9104e0e17d74p-19,   0x1.c9104e0e1ba28p-19,  -0x1.ffffa4p-1, INEXACT) // 3.405389867913445647016647266359e-06
T(RU,   0x1.c9104e0e17d74p-19,   0x1.c9104e0e1ba29p-19,  0x1.6d5a26p-19, INEXACT) // 3.405389867913445647016647266359e-06
T(RZ,   0x1.c9104e0e17d74p-19,   0x1.c9104e0e1ba28p-19,  -0x1.ffffa4p-1, INEXACT) // 3.405389867913445647016647266359e-06
T(RN,    0x1.b35000e6e95f2p-5,    0x1.b384842a12875p-5,   0x1.ffffe8p-2, INEXACT) // 5.313873459025932055599383829758e-02
T(RD,   -0x1.982afc6e3576fp-4,   -0x1.98d8b30e17043p-4, -0x1.9a1354p-20, INEXACT) // -9.965036969819406065251854442977e-02
T(RU,   -0x1.982afc6e3576fp-4,   -0x1.98d8b30e17042p-4,   0x1.ffffccp-1, INEXACT) // -9.965036969819406065251854442977e-02
T(RZ,   -0x1.982afc6e3576fp-4,   -0x1.98d8b30e17042p-4,   0x1.ffffccp-1, INEXACT) // -9.965036969819406065251854442977e-02
T(RN,   0x1.4360a94db03f1p-23,   0x1.4360a94db0407p-23,    0x1.fffebp-2, INEXACT) // 1.505844217566516057112206402116e-07
T(RN,   0x1.664469198e266p-18,   0x1.6644691995759p-18,   0x1.fffe1cp-2, INEXACT) // 5.338597725273140298467809683469e-06
T(RN,   -0x1.f8be952f8fc2cp-2,   -0x1.07e744755e6f2p-1,  -0x1.ffff96p-2, INEXACT) // -4.929145155219341045693681735429e-01
T(RN,   0x1.c2635826eebcdp-11,   0x1.c2635bc84df68p-11,   0x1.ffffecp-2, INEXACT) // 8.590470578079212543923248723843e-04
T(RD,     0x1.553cbdf8a542p-4,    0x1.55a21c03a1bb3p-4, -0x1.e4ef2ep-18, INEXACT) // 8.330988128211957999269543506671e-02
T(RU,     0x1.553cbdf8a542p-4,    0x1.55a21c03a1bb4p-4,   0x1.ffff0ep-1, INEXACT) // 8.330988128211957999269543506671e-02
T(RZ,     0x1.553cbdf8a542p-4,    0x1.55a21c03a1bb3p-4, -0x1.e4ef2ep-18, INEXACT) // 8.330988128211957999269543506671e-02
T(RD,    0x1.1fbfb46a530d7p-8,    0x1.1fbff101cec04p-8, -0x1.5df5fep-19, INEXACT) // 4.390698954306957411952705427893e-03
T(RU,    0x1.1fbfb46a530d7p-8,    0x1.1fbff101cec05p-8,   0x1.ffffa8p-1, INEXACT) // 4.390698954306957411952705427893e-03
T(RZ,    0x1.1fbfb46a530d7p-8,    0x1.1fbff101cec04p-8, -0x1.5df5fep-19, INEXACT) // 4.390698954306957411952705427893e-03
T(RN,    0x1.d9f8b8b3cfb99p-3,    0x1.de4ed59108798p-3,  -0x1.ffff8ap-2, INEXACT) // 2.314314298509685674520852671776e-01
T(RN,  -0x1.ee06f65c2ddd4p-18,  -0x1.ee06f65c41076p-18,   0x1.fffe1ap-2, INEXACT) // -7.361578891521920248912705386779e-06
T(RD,   0x1.fa96be9d0b309p-20,   0x1.fa96be9d0c7b2p-20,  -0x1.ffff7ap-1, INEXACT) // 1.887190513426275585416613291001e-06
T(RU,   0x1.fa96be9d0b309p-20,   0x1.fa96be9d0c7b3p-20,   0x1.0bcaep-18, INEXACT) // 1.887190513426275585416613291001e-06
T(RZ,   0x1.fa96be9d0b309p-20,   0x1.fa96be9d0c7b2p-20,  -0x1.ffff7ap-1, INEXACT) // 1.887190513426275585416613291001e-06
T(RD,  -0x1.250c0100d8df9p-25,  -0x1.250c0100d8dfbp-25,   -0x1.fffffp-1, INEXACT) // -3.411514804573773993627412129577e-08
T(RU,  -0x1.250c0100d8df9p-25,  -0x1.250c0100d8dfap-25,  0x1.e606cap-22, INEXACT) // -3.411514804573773993627412129577e-08
T(RZ,  -0x1.250c0100d8df9p-25,  -0x1.250c0100d8dfap-25,  0x1.e606cap-22, INEXACT) // -3.411514804573773993627412129577e-08
T(RD,   -0x1.386174a21b5bcp-3,   -0x1.399ad5458cbd8p-3,  -0x1.3dfa2p-18, INEXACT) // -1.525296318026628794584098613996e-01
T(RU,   -0x1.386174a21b5bcp-3,   -0x1.399ad5458cbd7p-3,   0x1.ffff62p-1, INEXACT) // -1.525296318026628794584098613996e-01
T(RZ,   -0x1.386174a21b5bcp-3,   -0x1.399ad5458cbd7p-3,   0x1.ffff62p-1, INEXACT) // -1.525296318026628794584098613996e-01
T(RN,  -0x1.fa5b375c0e482p-18,  -0x1.fa5b375c22eadp-18,   0x1.fffffap-2, INEXACT) // -7.545297048544153320080891955701e-06
T(RN,    0x1.4bf5b90f2bbfp-12,   0x1.4bf5b96c33906p-12,  -0x1.ffff84p-2, INEXACT) // 3.165815878202740338287490828861e-04
T(RD,   0x1.6b65217e243c5p-17,   0x1.6b65217e42befp-17, -0x1.2c3a18p-18, INEXACT) // 1.083001620497289482563611079380e-05
T(RU,   0x1.6b65217e243c5p-17,    0x1.6b65217e42bfp-17,   0x1.ffff6ap-1, INEXACT) // 1.083001620497289482563611079380e-05
T(RZ,   0x1.6b65217e243c5p-17,   0x1.6b65217e42befp-17, -0x1.2c3a18p-18, INEXACT) // 1.083001620497289482563611079380e-05
T(RD,  -0x1.eb8ca7a28910bp-11,  -0x1.eb8cac5ab663ap-11,  -0x1.fffffap-1, INEXACT) // -9.375561388123299913152641771319e-04
T(RU,  -0x1.eb8ca7a28910bp-11,  -0x1.eb8cac5ab6639p-11,  0x1.833fd4p-23, INEXACT) // -9.375561388123299913152641771319e-04
T(RZ,  -0x1.eb8ca7a28910bp-11,  -0x1.eb8cac5ab6639p-11,  0x1.833fd4p-23, INEXACT) // -9.375561388123299913152641771319e-04
T(RN,   -0x1.12df7498849dap-2,   -0x1.16492569dda67p-2,   0x1.ffff52p-2, INEXACT) // -2.684305399026506444570827625284e-01
T(RD,  -0x1.d6fcc5b050687p-19,  -0x1.d6fcc5b0548f4p-19, -0x1.2fb194p-18, INEXACT) // -3.509129520435513778135001514147e-06
T(RU,  -0x1.d6fcc5b050687p-19,  -0x1.d6fcc5b0548f3p-19,   0x1.ffff68p-1, INEXACT) // -3.509129520435513778135001514147e-06
T(RZ,  -0x1.d6fcc5b050687p-19,  -0x1.d6fcc5b0548f3p-19,   0x1.ffff68p-1, INEXACT) // -3.509129520435513778135001514147e-06
T(RN,   0x1.4dbe3f86b178dp-14,    0x1.4dbe3f8c9a14p-14,  -0x1.ffff94p-2, INEXACT) // 7.957056923676830283587851910809e-05
T(RN,   -0x1.490ae8fbf5d97p-5,   -0x1.4921938f0facap-5,  -0x1.fffe36p-2, INEXACT) // -4.016633515100947321441182680246e-02
