﻿// exp.testdata
// copyright (C) 2005 Ch. Q. Lauter, F. de Dinechin and V.Lefevre
// This file is part of crlibm and is distributed under the GNU Public Licence
// See file COPYING for details
// The following lines are either comments (beginning with a #)
// or give
//   1/ a rounding mode : RN|RU|RD|RZ (crlibm syntax) or  N|P|M|Z (libmcr syntax)
//   2/ The high and low hexadecimal halves of an input
//   3/ The high and low hexadecimal halves of the expected corresponding output
// Special cases
T(RN,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RN,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RU,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RU,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RD,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RD,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RZ,                  0x0p+0,                  0x1p+0,          0x0p+0, 0) // zero
T(RZ,                 -0x0p+0,                  0x1p+0,          0x0p+0, 0) // -zero
T(RN,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RN,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RU,               0x1p-1074,    0x1.0000000000001p+0,          0x1p+0, INEXACT) // smallest denorm positive
T(RU,              -0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm negative
T(RD,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RD,              -0x1p-1074,    0x1.fffffffffffffp-1,         -0x1p+0, INEXACT) // smallest denorm negative
T(RZ,               0x1p-1074,                  0x1p+0,          0x0p+0, INEXACT) // smallest denorm positive
T(RZ,              -0x1p-1074,    0x1.fffffffffffffp-1,         -0x1p+0, INEXACT) // smallest denorm negative
T(RN,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RN,                    -inf,                  0x0p+0,          0x0p+0, 0) // -inf
T(RU,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RU,                    -inf,                  0x0p+0,          0x0p+0, 0) // -inf
T(RD,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RD,                    -inf,                  0x0p+0,          0x0p+0, 0) // -inf
T(RZ,                     inf,                     inf,          0x0p+0, 0) // +inf
T(RZ,                    -inf,                  0x0p+0,          0x0p+0, 0) // -inf
T(RN,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RU,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RD,                     nan,                     nan,          0x0p+0, 0) // NaN
T(RZ,                     nan,                     nan,          0x0p+0, 0) // NaN
// Some boundary cases specific to the exp
// TODO add a few denormals
T(RN,    0x1.62e42fefa39efp+9, 0x1.fffffffffff2ap+1023,  -0x1.b0e264p-4, INEXACT) // the last value before the exp gets infinite
T(RN,     0x1.62e42fefa39fp+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // the first value that gives infinite exp
T(RU,    0x1.62e42fefa39efp+9, 0x1.fffffffffff2bp+1023,   0x1.c9e3b4p-1, INEXACT) // the last value before the exp gets infinite
T(RU,     0x1.62e42fefa39fp+9,                     inf,          0x0p+0, INEXACT|OVERFLOW) // the first value that gives infinite exp
T(RD,    0x1.62e42fefa39efp+9, 0x1.fffffffffff2ap+1023,  -0x1.b0e264p-4, INEXACT) // the last value before the exp gets infinite
T(RD,     0x1.62e42fefa39fp+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW) // the first value that gives infinite exp, rounded down
T(RZ,    0x1.62e42fefa39efp+9, 0x1.fffffffffff2ap+1023,  -0x1.b0e264p-4, INEXACT) // the last value before the exp gets infinite
T(RZ,     0x1.62e42fefa39fp+9, 0x1.fffffffffffffp+1023,         -0x1p+0, INEXACT|OVERFLOW) // the first value that gives infinite exp, rounded down
T(RN,   -0x1.74910d52d3051p+9,               0x1p-1074,          0x1p-1, INEXACT|UNDERFLOW) //  The last value before the exp flushes to zero
T(RN,   -0x1.74910d52d3052p+9,                  0x0p+0,         -0x1p-1, INEXACT|UNDERFLOW) // The first value at which the exp flushes to zero
T(RU,   -0x1.6232bdd7abcd2p+9, 0x1.000000000007cp-1022,   0x1.0c013ep-2, INEXACT) // The last value before the exp flushes to subnormal
T(RD,   -0x1.6232bdd7abcd2p+9, 0x1.000000000007bp-1022,   -0x1.79ff6p-1, INEXACT)
T(RN,   -0x1.6232bdd7abcd2p+9, 0x1.000000000007cp-1022,   0x1.0c013ep-2, INEXACT)
T(RU,   -0x1.6232bdd7abcd3p+9, 0x1.ffffffffffcf8p-1023,   0x1.0c013ep-2, INEXACT|UNDERFLOW) // The first value for which exp flushes to subnormal
T(RD,   -0x1.6232bdd7abcd3p+9, 0x1.ffffffffffcf6p-1023,   -0x1.79ff6p-1, INEXACT|UNDERFLOW)
T(RN,   -0x1.6232bdd7abcd3p+9, 0x1.ffffffffffcf8p-1023,   0x1.0c013ep-2, INEXACT|UNDERFLOW)
// In rounding up  we get non-zero results all the way to -infty
T(RU,   -0x1.74910d52d3051p+9,               0x1p-1074,          0x1p-1, INEXACT|UNDERFLOW)
T(RD,   -0x1.74385446d71c3p+9,               0x1p-1074,  -0x1.8e56ap-45, INEXACT|UNDERFLOW) // The last value before the exp flushes to zero
T(RD,   -0x1.74385446d71c4p+9,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // The first value at which the exp flushes to zero
T(RZ,   -0x1.74385446d71c3p+9,               0x1p-1074,  -0x1.8e56ap-45, INEXACT|UNDERFLOW) // The last value before the exp flushes to zero
T(RZ,   -0x1.74385446d71c4p+9,                  0x0p+0,         -0x1p+0, INEXACT|UNDERFLOW) // The first value at which the exp flushes to zero
// One in five of the very worst cases computed by Lefevre and Muller.
// Rounding these values requires evaluating the function to at least 2^(-100).
// These worst cases have been selected thanks to the filterlists 5 script
// If you want the full list please contact Jean-Michel Muller
T(RN,    0x1.005ae04256babp-1,    0x1.a65d89abf3d1fp+0,          0x1p-1, INEXACT) // 5.006933289508784801213892023952e-01
T(RN,    0x1.41c9e095cd545p-1,    0x1.dff1d425de879p+0,          0x1p-1, INEXACT) // 6.284933264602520219810344315192e-01
T(RZ,    0x1.0727af5fee8f6p-1,    0x1.ac032a8d2ec23p+0, -0x1.05a628p-52, INEXACT) // 5.139746479610767249113223442691e-01
T(RZ,    0x1.12fcce02efb32p-1,    0x1.b604e1942098cp+0,         -0x1p+0, INEXACT) // 5.370849970421203156689671232016e-01
T(RN,     0x1.accfbe46b4efp-1,     0x1.27c2e4bc1ee7p+1,         -0x1p-1, INEXACT) // 8.375224553405740124389922129922e-01
T(RN,    0x1.b3738e335ea89p-1,     0x1.2b9f331610fbp+1,          0x1p-1, INEXACT) // 8.504909932810998940411195690103e-01
T(RN,    0x1.a083788425ab6p+0,    0x1.45abe6a4c4281p+2,          0x1p-1, INEXACT) // 1.627006084692465659458093796275e+00
T(RN,    0x1.aca7ae8da5a7bp+0,    0x1.557d4acd7e557p+2,          0x1p-1, INEXACT) // 1.674433621961411544631914694037e+00
T(RZ,    0x1.53068b2bacac1p+1,    0x1.c44ff9a896f5dp+3,         -0x1p+0, INEXACT) // 2.648637195897521667831142622163e+00
T(RZ,    0x1.df801ca8a88cbp+1,    0x1.52d7f797be69ap+5,         -0x1p+0, INEXACT) // 3.746097166397793554182271691388e+00
T(RZ,    0x1.333a83013057ep+2,    0x1.e642354c34a34p+6, -0x1.3df4a4p-53, INEXACT) // 4.800446273003556640901479113381e+00
T(RN,    0x1.aa1b465630fa4p+2,    0x1.8576653f47e5ep+9,          0x1p-1, INEXACT) // 6.657914718791207775439033866860e+00
T(RN,    0x1.60bb5fb993b99p+3,   0x1.de96d34fcccfep+15,          0x1p-1, INEXACT) // 1.102287279363172167734319373267e+01
T(RN,    0x1.6d2883e37b4d7p+3,   0x1.60d75c9585ca5p+16,          0x1p-1, INEXACT) // 1.141119570188531717747082439018e+01
T(RN,    0x1.796c771af1e4bp+3,   0x1.02d419f8e15f2p+17,          0x1p-1, INEXACT) // 1.179449038756060552657345397165e+01
T(RZ,    0x1.08f51434652c3p+4,   0x1.daac459b157e5p+23,  -0x1.c6823p-55, INEXACT) // 1.655983372179867885165549523663e+01
T(RZ,    0x1.0ae38aa7bf73ep+5,   0x1.181ea60203d39p+48, -0x1.aa817ap-51, INEXACT) // 3.336110430768029289083642652258e+01
T(RZ,    0x1.94925476814e9p+5,    0x1.f1b76b88f075p+72, -0x1.b710acp-51, INEXACT) // 5.057145016271699233811887097545e+01
T(RN,    0x1.a1d3b2f33674ep+5,   0x1.4632f06b68116p+75,         -0x1p-1, INEXACT) // 5.222836866388261967131256824359e+01
T(RZ,    0x1.e07e71bfcf06fp+5,   0x1.91ec4412c344fp+86,  -0x1.09d28p-57, INEXACT) // 6.006174039698168343193174223416e+01
T(RN,    0x1.f0a1fc4b9f04bp+5,    0x1.79ba395af901p+89,          0x1p-1, INEXACT) // 6.207909449652705546895958832465e+01
T(RN,    0x1.181ccd8144be7p+6,  0x1.053d7702a0c15p+101,         -0x1p-1, INEXACT) // 7.002812768919066854778066044673e+01
T(RZ,    0x1.7945e34b18a9ap+7,  0x1.1b0e4936a8c9ap+272,         -0x1p+0, INEXACT) // 1.886364997356038770703889895231e+02
T(RZ,    0x1.f44c934fc9053p+7,  0x1.da4255c59658dp+360,         -0x1p+0, INEXACT) // 2.501495613987814010670263087377e+02
T(RZ,    0x1.204684c1167e9p+8,  0x1.db9797d3d32e7p+415,         -0x1p+0, INEXACT) // 2.882754631690900737339688930660e+02
T(RZ,     0x1.532627c210d1p+8,  0x1.38b3af1b0b785p+489,         -0x1p+0, INEXACT) // 3.391490441599898986169137060642e+02
T(RN,    0x1.4b857492a59ebp+8,  0x1.37bab2ac649f8p+478,         -0x1p-1, INEXACT) // 3.315213100103707688504073303193e+02
T(RZ,     0x1.2da9e5e6af0bp+8,  0x1.27d6fe867d6f6p+435,  -0x1.0a1d5p-53, INEXACT) // 3.016636642625189779209904372692e+02
T(RN,    0x1.9cd6b6d99965bp+8,  0x1.84208270e2e4cp+595,          0x1p-1, INEXACT) // 4.128387275695328639812942128628e+02
T(RZ,    0x1.c7206c1b753e4p+8,  0x1.8670de0b68cacp+656,         -0x1p+0, INEXACT) // 4.551266495858419602882349863648e+02
T(RN,    0x1.fee02d3d0ec9ap+8,  0x1.06ccf59e5ed14p+737,         -0x1p-1, INEXACT) // 5.108756902848341496792272664607e+02
T(RZ,    0x1.f419d873a3f83p+8,  0x1.685463d30fb68p+721,         -0x1p+0, INEXACT) // 5.001009590411487693017988931388e+02
T(RZ,    0x1.0bc04af1b09f5p+9,  0x1.7b1d97c902985p+772, -0x1.551dfcp-53, INEXACT) // 5.355022871124662060537957586348e+02
T(RN,   -0x1.f31bfe026a32ep-2,     0x1.3a7a4a4e1918p-1,          0x1p-1, INEXACT) // -4.874114693616772298057071566291e-01
T(RZ,   -0x1.add1dce7cd5bcp-2,    0x1.507e542d9849dp-1,  -0x1.39809p-52, INEXACT) // -4.197458759766410363312161280192e-01
T(RN,   -0x1.f193dbe5f18bbp-3,    0x1.91905fbb3dfe8p-1,          0x1p-1, INEXACT) // -2.429577998684119000127878962303e-01
T(RZ,   -0x1.cddf723d3e52fp-3,     0x1.98a04e083309p-1,         -0x1p+0, INEXACT) // -2.255238461437243102647443038222e-01
T(RZ,   -0x1.290ea09e36479p-3,    0x1.baded30cbf1c3p-1,         -0x1p+0, INEXACT) // -1.450474308283309643474723316103e-01
T(RN,   -0x1.3b89bb1b787cdp-3,    0x1.b6e458ffe8ff2p-1,         -0x1p-1, INEXACT) // -1.540712945707682079987677070676e-01
T(RZ,  -0x1.c000000000003p-51,    0x1.ffffffffffff9p-1,        -0x1p-54, INEXACT) // -7.771561172376098741193816255430e-16
T(RN,  -0x1.9000000000005p-50,    0x1.ffffffffffff3p-1,         -0x1p-1, INEXACT) // -1.387778780781446661605671111378e-15
T(RZ,  -0x1.e00000000000ep-49,    0x1.fffffffffffe2p-1,        -0x1p-52, INEXACT) // -3.330669073875475143297231551355e-15
T(RZ,  -0x1.200000000000ap-48,    0x1.fffffffffffdcp-1,        -0x1p-50, INEXACT) // -3.996802888650571434134126215245e-15
T(RN,  -0x1.3c0000000000cp-48,    0x1.fffffffffffd9p-1,          0x1p-1, INEXACT) // -4.385380947269377801004207741100e-15
T(RN,  -0x1.5c0000000000fp-48,    0x1.fffffffffffd4p-1,         -0x1p-1, INEXACT) // -4.829470157119442783756376071372e-15
T(RN,  -0x1.bc00000000018p-48,    0x1.fffffffffffc9p-1,          0x1p-1, INEXACT) // -6.161737786669637732012881062187e-15
T(RZ,  -0x1.e00000000001cp-48,    0x1.fffffffffffc4p-1,        -0x1p-50, INEXACT) // -6.661338147750961330647136196875e-15
T(RZ,   -0x1.000000000001p-47,     0x1.fffffffffffcp-1,          0x0p+0, INEXACT) // -7.105427357601027102260209748159e-15
T(RN,  -0x1.1600000000013p-47,    0x1.fffffffffffbap-1,         -0x1p-1, INEXACT) // -7.716050021144867932658638491680e-15
T(RZ,  -0x1.2c00000000016p-47,    0x1.fffffffffffb4p-1,         -0x1p+0, INEXACT) // -8.326672684688708763057067235201e-15
T(RN,  -0x1.460000000001ap-47,    0x1.fffffffffffaep-1,         -0x1p-1, INEXACT) // -9.048317650695066825219669587554e-15
T(RZ,  -0x1.640000000001fp-47,    0x1.fffffffffffa6p-1,         -0x1p+0, INEXACT) // -9.880984919163942119146445548740e-15
T(RN,  -0x1.8600000000025p-47,    0x1.fffffffffff9fp-1,          0x1p-1, INEXACT) // -1.082467449009533464483739511876e-14
T(RN,  -0x1.8a00000000026p-47,    0x1.fffffffffff9dp-1,         -0x1p-1, INEXACT) // -1.093569679255785187660156872759e-14
T(RZ,   -0x1.bc0000000003p-47,    0x1.fffffffffff91p-1,     -0x1.08p-49, INEXACT) // -1.232347557333931332934921273294e-14
T(RZ,  -0x1.c000000000031p-47,     0x1.fffffffffff9p-1,          0x0p+0, INEXACT) // -1.243449787580183056111338634177e-14
T(RZ,  -0x1.c400000000032p-47,    0x1.fffffffffff8ep-1,         -0x1p+0, INEXACT) // -1.254552017826434779287755995061e-14
T(RZ,  -0x1.c800000000033p-47,    0x1.fffffffffff8dp-1,         -0x1p+0, INEXACT) // -1.265654248072686502464173355944e-14
T(RZ,  -0x1.1a00000000027p-46,    0x1.fffffffffff72p-1,         -0x1p+0, INEXACT) // -1.565414464721483028227442099792e-14
T(RZ,  -0x1.1e00000000028p-46,     0x1.fffffffffff7p-1,         -0x1p+0, INEXACT) // -1.587618925213986474580276821559e-14
T(RZ,  -0x1.2200000000029p-46,    0x1.fffffffffff6fp-1,     -0x1.08p-49, INEXACT) // -1.609823385706489920933111543325e-14
T(RZ,  -0x1.260000000002ap-46,    0x1.fffffffffff6dp-1,     -0x1.a4p-48, INEXACT) // -1.632027846198993367285946265092e-14
T(RN,   -0x1.390000000003p-46,    0x1.fffffffffff63p-1,         -0x1p-1, INEXACT) // -1.737499033538385131892363803989e-14
T(RN,  -0x1.3d00000000031p-46,    0x1.fffffffffff62p-1,          0x1p-1, INEXACT) // -1.759703494030888578245198525755e-14
T(RZ,  -0x1.4c00000000036p-46,    0x1.fffffffffff59p-1,         -0x1p+0, INEXACT) // -1.842970220877776896498781342886e-14
T(RZ,  -0x1.5000000000037p-46,    0x1.fffffffffff58p-1,        -0x1p-48, INEXACT) // -1.865174681370280342851616064652e-14
T(RN,  -0x1.5b0000000003bp-46,    0x1.fffffffffff52p-1,         -0x1p-1, INEXACT) // -1.926236947724665214752364160016e-14
T(RN,  -0x1.5f0000000003cp-46,    0x1.fffffffffff51p-1,          0x1p-1, INEXACT) // -1.948441408217168661105198881783e-14
T(RZ,   -0x1.6a0000000004p-46,    0x1.fffffffffff4ap-1,         -0x1p+0, INEXACT) // -2.009503674571553533005946977147e-14
T(RN,  -0x1.7500000000044p-46,    0x1.fffffffffff45p-1,         -0x1p-1, INEXACT) // -2.070565940925938404906695072510e-14
T(RZ,  -0x1.8000000000048p-46,     0x1.fffffffffff4p-1,          0x0p+0, INEXACT) // -2.131628207280323276807443167874e-14
T(RN,  -0x1.8b0000000004cp-46,    0x1.fffffffffff3bp-1,          0x1p-1, INEXACT) // -2.192690473634708148708191263238e-14
T(RZ,  -0x1.920000000004fp-46,    0x1.fffffffffff36p-1,         -0x1p+0, INEXACT) // -2.231548279496589574256104636836e-14
T(RZ,  -0x1.a400000000056p-46,    0x1.fffffffffff2ep-1,      -0x1.1p-48, INEXACT) // -2.331468351712855871704766105797e-14
T(RN,  -0x1.ab00000000059p-46,    0x1.fffffffffff2bp-1,          0x1p-1, INEXACT) // -2.370326157574737297252679479394e-14
T(RZ,  -0x1.b20000000005cp-46,    0x1.fffffffffff26p-1,         -0x1p+0, INEXACT) // -2.409183963436618722800592852992e-14
T(RN,  -0x1.b90000000005fp-46,    0x1.fffffffffff23p-1,         -0x1p-1, INEXACT) // -2.448041769298500148348506226589e-14
T(RZ,  -0x1.c000000000062p-46,     0x1.fffffffffff2p-1,          0x0p+0, INEXACT) // -2.486899575160381573896419600186e-14
T(RN,  -0x1.c700000000065p-46,    0x1.fffffffffff1dp-1,          0x1p-1, INEXACT) // -2.525757381022262999444332973784e-14
T(RZ,  -0x1.ce00000000068p-46,    0x1.fffffffffff19p-1,     -0x1.c4p-48, INEXACT) // -2.564615186884144424992246347381e-14
T(RZ,  -0x1.d80000000006dp-46,    0x1.fffffffffff13p-1,         -0x1p+0, INEXACT) // -2.620126338115403829735238372809e-14
T(RN,   -0x1.df0000000007p-46,    0x1.fffffffffff11p-1,          0x1p-1, INEXACT) // -2.658984143977285255283151746406e-14
T(RN,  -0x1.e900000000075p-46,    0x1.fffffffffff0bp-1,         -0x1p-1, INEXACT) // -2.714495295208544660026143771835e-14
T(RZ,  -0x1.f000000000078p-46,    0x1.fffffffffff08p-1,        -0x1p-48, INEXACT) // -2.753353101070426085574057145432e-14
T(RZ,  -0x1.fa0000000007dp-46,    0x1.fffffffffff03p-1,      -0x1.2p-51, INEXACT) // -2.808864252301685490317049170860e-14
T(RZ,   -0x1.000000000004p-45,      0x1.fffffffffffp-1,          0x0p+0, INEXACT) // -2.842170943040441133162844386117e-14
T(RN,    0x1.bcab27d05abdep-2,    0x1.8b367381d82f5p+0,          0x1p-1, INEXACT) // 4.342466565055341787271458997566e-01
T(RN,    0x1.a3a7add74f25ap-2,    0x1.81acf88d11547p+0,          0x1p-1, INEXACT) // 4.098193323768889451130803536216e-01
T(RZ,    0x1.12fcce02efb32p-1,    0x1.b604e1942098cp+0,         -0x1p+0, INEXACT) // 5.370849970421203156689671232016e-01
T(RN,    0x1.005ae04256babp-1,    0x1.a65d89abf3d1fp+0,          0x1p-1, INEXACT) // 5.006933289508784801213892023952e-01
T(RZ,    0x1.0727af5fee8f6p-1,    0x1.ac032a8d2ec23p+0, -0x1.05a628p-52, INEXACT) // 5.139746479610767249113223442691e-01
T(RN,    0x1.41c9e095cd545p-1,    0x1.dff1d425de879p+0,          0x1p-1, INEXACT) // 6.284933264602520219810344315192e-01
T(RZ,   0x1.fffffffffffffp-53,                  0x1p+0,         -0x1p+0, INEXACT) // 2.220446049250312834328230454615e-16
T(RZ,   0x1.ffffffffffffep-52,    0x1.0000000000001p+0,         -0x1p+0, INEXACT) // 4.440892098500625175618395146099e-16
T(RN,   0x1.5fffffffffffcp-50,    0x1.0000000000005p+0,         -0x1p-1, INEXACT) // 1.221245327087671405605089613888e-15
T(RN,   0x1.dfffffffffff9p-50,    0x1.0000000000008p+0,          0x1p-1, INEXACT) // 1.665334536937733430128863365366e-15
T(RZ,   0x1.7ffffffffffeep-48,    0x1.0000000000017p+0,         -0x1p+0, INEXACT) // 5.329070518200737194537138028623e-15
T(RZ,   0x1.effffffffffe2p-48,    0x1.000000000001fp+0, -0x1.fffff8p-54, INEXACT) // 6.883382752675946884799359711809e-15
T(RN,   0x1.33fffffffffe9p-47,    0x1.0000000000027p+0,          0x1p-1, INEXACT) // 8.548717289613669073660323677756e-15
T(RZ,   0x1.3ffffffffffe7p-47,    0x1.0000000000027p+0,         -0x1p+0, INEXACT) // 8.881784197001212880343792294136e-15
T(RN,   0x1.4bfffffffffe5p-47,    0x1.0000000000029p+0,         -0x1p-1, INEXACT) // 9.214851104388756687027260910516e-15
T(RZ,   0x1.57fffffffffe3p-47,    0x1.000000000002ap+0,         -0x1p+0, INEXACT) // 9.547918011776300493710729526896e-15
T(RN,   0x1.63fffffffffe1p-47,    0x1.000000000002cp+0,         -0x1p-1, INEXACT) // 9.880984919163844300394198143276e-15
T(RZ,   0x1.6ffffffffffdfp-47,    0x1.000000000002ep+0, -0x1.fffffep-52, INEXACT) // 1.021405182655138810707766675966e-14
T(RZ,   0x1.a7fffffffffd4p-47,    0x1.0000000000034p+0,         -0x1p+0, INEXACT) // 1.176836406102658990873083623272e-14
T(RZ,   0x1.c7fffffffffcdp-47,    0x1.0000000000038p+0,         -0x1p+0, INEXACT) // 1.265654248072670409701706847303e-14
T(RZ,   0x1.e7fffffffffc6p-47,    0x1.000000000003dp+0,      -0x1.2p-50, INEXACT) // 1.354472090042681828530330071334e-14
T(RN,   0x1.fbfffffffffc1p-47,     0x1.000000000004p+0,          0x1p-1, INEXACT) // 1.409983241273938866690606433727e-14
T(RZ,   0x1.13fffffffffdbp-46,    0x1.0000000000045p+0,      -0x1.9p-49, INEXACT) // 1.532107773982704350643214430991e-14
T(RN,   0x1.21fffffffffd7p-46,    0x1.0000000000049p+0,          0x1p-1, INEXACT) // 1.609823385706464046295420294138e-14
T(RZ,   0x1.2ffffffffffd3p-46,    0x1.000000000004cp+0,        -0x1p-49, INEXACT) // 1.687538997430223741947626157286e-14
T(RN,   0x1.45fffffffffccp-46,    0x1.0000000000051p+0,         -0x1p-1, INEXACT) // 1.809663530138988752583691021942e-14
T(RZ,   0x1.5bfffffffffc5p-46,    0x1.0000000000057p+0,      -0x1.1p-49, INEXACT) // 1.931788062847753763219755886599e-14
T(RZ,   0x1.63fffffffffc2p-46,    0x1.0000000000058p+0,         -0x1p+0, INEXACT) // 1.976196983832759078203614888109e-14
T(RZ,   0x1.9bfffffffffadp-46,    0x1.0000000000066p+0,         -0x1p+0, INEXACT) // 2.287059430727796283090627898675e-14
T(RZ,   0x1.a3fffffffffaap-46,    0x1.0000000000069p+0,      -0x1.1p-49, INEXACT) // 2.331468351712801598074486900185e-14
T(RN,   0x1.bdfffffffff9fp-46,     0x1.000000000007p+0,          0x1p-1, INEXACT) // 2.475797344914068477341576044584e-14
T(RZ,   0x1.cffffffffff97p-46,    0x1.0000000000074p+0,        -0x1p-49, INEXACT) // 2.575717417130330041624806187475e-14
T(RZ,   0x1.ebfffffffff8ap-46,    0x1.000000000007bp+0,      -0x1.9p-49, INEXACT) // 2.731148640577847855207407471746e-14
T(RN,   0x1.f5fffffffff85p-46,    0x1.000000000007ep+0,          0x1p-1, INEXACT) // 2.786659791809104104506778613127e-14
T(RZ,    0x1.fffffffffff8p-46,    0x1.000000000007fp+0,         -0x1p+0, INEXACT) // 2.842170943040360353806149754508e-14
T(RZ,   0x1.01fffffffffbfp-45,    0x1.0000000000081p+0, -0x1.fffff8p-54, INEXACT) // 2.864375403532862853525898211060e-14
T(RZ,   0x1.0bfffffffffbap-45,    0x1.0000000000086p+0,      -0x1.2p-48, INEXACT) // 2.975397705995375352124640493822e-14
T(RN,   0x1.16fffffffffb4p-45,    0x1.000000000008cp+0,          0x1p-1, INEXACT) // 3.097522238704138785038894916456e-14
T(RZ,   0x1.21fffffffffaep-45,    0x1.0000000000091p+0,     -0x1.08p-48, INEXACT) // 3.219646771412902217953149339089e-14
T(RZ,   0x1.2dfffffffffa7p-45,    0x1.0000000000097p+0,      -0x1.1p-49, INEXACT) // 3.352873534367916585182915901594e-14
T(RN,   0x1.3afffffffff9fp-45,    0x1.000000000009dp+0,         -0x1p-1, INEXACT) // 3.497202527569181886728194603970e-14
T(RZ,   0x1.47fffffffff97p-45,    0x1.00000000000a4p+0,        -0x1p-49, INEXACT) // 3.641531520770447188273473306346e-14
T(RZ,   0x1.55fffffffff8ep-45,    0x1.00000000000abp+0,     -0x1.c8p-48, INEXACT) // 3.796962744217963424134264148594e-14
T(RN,   0x1.56fffffffff8dp-45,    0x1.00000000000abp+0,         -0x1p-1, INEXACT) // 3.808064974464214358449776288465e-14
T(RZ,   0x1.65fffffffff83p-45,    0x1.00000000000b3p+0,     -0x1.48p-48, INEXACT) // 3.974598428157981528626079270585e-14
T(RN,   0x1.66fffffffff82p-45,    0x1.00000000000b3p+0,         -0x1p-1, INEXACT) // 3.985700658404232462941591410456e-14
T(RZ,   0x1.77fffffffff76p-45,    0x1.00000000000bcp+0,        -0x1p-49, INEXACT) // 4.174438572590501501748918672318e-14
T(RN,   0x1.78fffffffff75p-45,    0x1.00000000000bcp+0,         -0x1p-1, INEXACT) // 4.185540802836752436064430812190e-14
T(RZ,   0x1.8bfffffffff67p-45,    0x1.00000000000c6p+0,      -0x1.2p-48, INEXACT) // 4.396483177515523343502782353795e-14
T(RN,   0x1.8cfffffffff66p-45,    0x1.00000000000c6p+0,         -0x1p-1, INEXACT) // 4.407585407761774277818294493666e-14
T(RN,   0x1.a4fffffffff53p-45,    0x1.00000000000d3p+0,          0x1p-1, INEXACT) // 4.674038933671799856834206734628e-14
T(RZ,   0x1.a5fffffffff52p-45,    0x1.00000000000d2p+0,         -0x1p+0, INEXACT) // 4.685141163918050791149718874500e-14
T(RN,   0x1.c6fffffffff36p-45,    0x1.00000000000e4p+0,          0x1p-1, INEXACT) // 5.051514762044334779005240374305e-14
T(RZ,   0x1.c7fffffffff35p-45,    0x1.00000000000e4p+0,        -0x1p-49, INEXACT) // 5.062616992290585713320752514177e-14
T(RN,   0x1.c8fffffffff34p-45,    0x1.00000000000e4p+0,         -0x1p-1, INEXACT) // 5.073719222536836647636264654048e-14
T(RZ,   0x1.c9fffffffff33p-45,    0x1.00000000000e4p+0,         -0x1p+0, INEXACT) // 5.084821452783087581951776793920e-14
// The following are one fifth of Sun's values distributed with libmcr 0.9,
// again using filterlists 5
T(RU,  -0x1.912c88c32b6b4p-15,    0x1.fff9bb57af9b4p-1,  0x1.e2921ep-11, INEXACT)
T(RZ,  -0x1.912c88c32b6b4p-15,    0x1.fff9bb57af9b3p-1,  -0x1.ff875cp-1, INEXACT)
T(RN,   0x1.2b0f0015d0d6bp-15,    0x1.00025620bae5dp+0,  -0x1.fff6cep-2, INEXACT)
T(RN,   0x1.3a1a9e5c61812p-15,    0x1.000274383f85dp+0,   -0x1.fff8ap-2, INEXACT)
T(RU,     0x1.cb141e65b93p-15,    0x1.0003962eab557p+0,  0x1.ea8d5cp-19, INEXACT)
T(RZ,     0x1.cb141e65b93p-15,    0x1.0003962eab556p+0,  -0x1.ffff86p-1, INEXACT)
T(RU,   0x1.298fb6b75d569p-15,    0x1.00025322212e6p+0,  0x1.fb3b16p-11, INEXACT)
T(RZ,   0x1.298fb6b75d569p-15,    0x1.00025322212e5p+0,  -0x1.ff8132p-1, INEXACT)
T(RZ,   0x1.bf34747f589aep-15,    0x1.00037e6f03764p+0, -0x1.94a48ep-13, INEXACT)
T(RU,   0x1.bf34747f589aep-15,    0x1.00037e6f03765p+0,   0x1.ffe6b6p-1, INEXACT)
T(RN,   0x1.b0de4fd66465fp-15,    0x1.000361c257915p+0,  -0x1.ffbdecp-2, INEXACT)
T(RN,   0x1.cabf6d0d348d9p-15,    0x1.0003958546451p+0,   -0x1.ff6bap-2, INEXACT)
T(RN,  -0x1.d64b21b171a98p-15,    0x1.fff8a6e0f9098p-1,  -0x1.ff68a2p-2, INEXACT)
T(RN,  -0x1.a2bf9e37232a6p-15,     0x1.fff9750c3af1p-1,  -0x1.ff9ddep-2, INEXACT)
T(RN,   0x1.937489641e76dp-14,    0x1.00064de6047b2p+0,  -0x1.ffbbbep-2, INEXACT)
T(RN,  -0x1.f6a580882bdd4p-14,    0x1.fff04b11a9f51p-1,  -0x1.ff553ep-2, INEXACT)
T(RN,  -0x1.2af6160a5b7fap-14,    0x1.fff6a86521a8ap-1,  -0x1.ff376cp-2, INEXACT)
T(RN,  -0x1.8380ac8357f2cp-14,    0x1.fff3e41f447fep-1,  -0x1.ff34a2p-2, INEXACT)
T(RN,  -0x1.a9806088cc36bp-14,    0x1.fff2b4292f0fbp-1,  -0x1.ff2ed6p-2, INEXACT)
T(RN,  -0x1.1156b6a9b1f25p-14,    0x1.fff7755c88396p-1,  -0x1.ff839ep-2, INEXACT)
T(RZ,  -0x1.cd63baeaf1977p-14,    0x1.fff195162130fp-1, -0x1.f31868p-12, INEXACT)
T(RU,  -0x1.cd63baeaf1977p-14,     0x1.fff195162131p-1,   0x1.ffc19cp-1, INEXACT)
T(RU,   0x1.ac51c354840dep-14,      0x1.0006b15d729p+0,  0x1.3e3c92p-11, INEXACT)
T(RZ,   0x1.ac51c354840dep-14,    0x1.0006b15d728ffp+0,   -0x1.ffb07p-1, INEXACT)
T(RN,   0x1.f79989ac6ebb5p-14,    0x1.0007de851c68ap+0,   -0x1.ff8edp-2, INEXACT)
T(RZ,   0x1.67f7b0ceb2f51p-14,    0x1.00059fee949d8p+0,  -0x1.a1793p-11, INEXACT)
T(RU,   0x1.67f7b0ceb2f51p-14,    0x1.00059fee949d9p+0,   0x1.ff97a2p-1, INEXACT)
T(RN,  -0x1.6a9a89d04333ap-14,    0x1.fff4ab4bcad7fp-1,  -0x1.fffc8cp-2, INEXACT)
T(RU,  -0x1.f189e4f349209p-14,    0x1.fff073ed47547p-1,   0x1.82ca5p-13, INEXACT)
T(RZ,  -0x1.f189e4f349209p-14,    0x1.fff073ed47546p-1,  -0x1.ffe7d4p-1, INEXACT)
T(RU,  -0x1.f0c814cc796b1p-14,    0x1.fff079fb997f2p-1,   0x1.91ee3p-11, INEXACT)
T(RZ,  -0x1.f0c814cc796b1p-14,    0x1.fff079fb997f1p-1,  -0x1.ff9b84p-1, INEXACT)
T(RN,  -0x1.2c4d5bb535b29p-14,    0x1.fff69dab268a4p-1,  -0x1.ff859ep-2, INEXACT)
T(RN,   0x1.7d7a73302b381p-13,    0x1.000bec1aa9526p+0,   -0x1.ff5f6p-2, INEXACT)
T(RU,   0x1.343f990416c72p-13,    0x1.0009a22b2dd8bp+0,  0x1.abfd94p-11, INEXACT)
T(RZ,   0x1.343f990416c72p-13,    0x1.0009a22b2dd8ap+0,    -0x1.ff95p-1, INEXACT)
T(RN,  -0x1.d143b12afadc2p-13,    0x1.ffe2ec984f0ebp-1,  -0x1.ff08a6p-2, INEXACT)
T(RZ,  -0x1.7d8a6be9358bcp-13,    0x1.ffe827e7688bbp-1, -0x1.84aa0ep-11, INEXACT)
T(RU,  -0x1.7d8a6be9358bcp-13,    0x1.ffe827e7688bcp-1,   0x1.ff9ed6p-1, INEXACT)
T(RU,   0x1.92e36f008ad91p-13,    0x1.000c976abb335p+0,  0x1.25f71ap-16, INEXACT)
T(RZ,   0x1.92e36f008ad91p-13,    0x1.000c976abb334p+0,  -0x1.fffdb4p-1, INEXACT)
T(RN,    0x1.a83a499461f1p-13,    0x1.000d422a2e4b8p+0,  -0x1.ff3534p-2, INEXACT)
T(RN,  -0x1.282784a244394p-13,    0x1.ffed7ddd5badbp-1,  -0x1.ff2eeep-2, INEXACT)
T(RU,  -0x1.76ccc46a04b4dp-12,    0x1.ffd1288c1cf4dp-1,  0x1.54dbeep-11, INEXACT)
T(RZ,  -0x1.76ccc46a04b4dp-12,    0x1.ffd1288c1cf4cp-1,  -0x1.ffaacap-1, INEXACT)
T(RU,  -0x1.f8c8acebfb0f5p-12,    0x1.ffc0eacd9064cp-1,  0x1.95eef6p-11, INEXACT)
T(RZ,  -0x1.f8c8acebfb0f5p-12,    0x1.ffc0eacd9064bp-1,  -0x1.ff9a84p-1, INEXACT)
T(RZ,  -0x1.c7e7a75d8ec25p-12,     0x1.ffc70636df76p-1, -0x1.df826ap-12, INEXACT)
T(RU,  -0x1.c7e7a75d8ec25p-12,    0x1.ffc70636df761p-1,    0x1.ffc41p-1, INEXACT)
T(RN,  -0x1.bd8bcf669a07dp-12,    0x1.ffc8518d666b2p-1,  -0x1.fffe14p-2, INEXACT)
T(RU,   0x1.4aa9d57e87971p-12,    0x1.0014ab72eacd4p+0,  0x1.30d92cp-13, INEXACT)
T(RZ,   0x1.4aa9d57e87971p-12,    0x1.0014ab72eacd3p+0,  -0x1.ffecf2p-1, INEXACT)
T(RU,  -0x1.6ee801caacff4p-12,    0x1.ffd2250d932e8p-1,  0x1.d4a516p-12, INEXACT)
T(RZ,  -0x1.6ee801caacff4p-12,    0x1.ffd2250d932e7p-1,  -0x1.ffc56cp-1, INEXACT)
T(RN,  -0x1.b650fc1eba15ap-12,    0x1.ffc938ceda9ccp-1,  -0x1.ff2188p-2, INEXACT)
T(RN,   0x1.3624131964b45p-12,    0x1.001362fd1405ep+0,   -0x1.ff14ap-2, INEXACT)
T(RN,   0x1.113387b5f0677p-12,    0x1.001113ca4615bp+0,  -0x1.ffde18p-2, INEXACT)
T(RZ,  -0x1.b624f07ae06aap-11,    0x1.ff92827a951cap-1, -0x1.845c38p-11, INEXACT)
T(RU,  -0x1.b624f07ae06aap-11,    0x1.ff92827a951cbp-1,   0x1.ff9ee8p-1, INEXACT)
T(RU,  -0x1.a2a47c1f266ffp-11,    0x1.ff976192b3e3dp-1,  0x1.ca2fbep-12, INEXACT)
T(RZ,  -0x1.a2a47c1f266ffp-11,    0x1.ff976192b3e3cp-1,  -0x1.ffc6bap-1, INEXACT)
T(RN,  -0x1.8152f411a956dp-11,    0x1.ff9fb4525491dp-1,  -0x1.ff93dap-2, INEXACT)
T(RN,   0x1.1000ece67db68p-10,    0x1.00440944161fcp+0,  -0x1.ff5b9cp-2, INEXACT)
T(RN,  -0x1.2560d98e8dda8p-10,    0x1.ff6d6494a48adp-1,  -0x1.ff1378p-2, INEXACT)
T(RN,  -0x1.befc4cb83db69p-10,    0x1.ff20b299ccf7bp-1,  -0x1.ff2cb4p-2, INEXACT)
T(RN,   0x1.479fd74fbd41ep-10,    0x1.0051f51187a61p+0,  -0x1.ff4b3ep-2, INEXACT)
T(RN,    0x1.2e00807d7929fp-9,    0x1.00972cd1a778ap+0,  -0x1.ff6ef2p-2, INEXACT)
T(RZ,   -0x1.260ad0b37a1bep-9,    0x1.feda498e5aea8p-1, -0x1.28ebe8p-11, INEXACT)
T(RU,   -0x1.260ad0b37a1bep-9,    0x1.feda498e5aea9p-1,   0x1.ffb5c6p-1, INEXACT)
T(RZ,    0x1.cbec1e4d11e4fp-9,    0x1.00e65d772c80ap+0, -0x1.f550aap-12, INEXACT)
T(RU,    0x1.cbec1e4d11e4fp-9,    0x1.00e65d772c80bp+0,   0x1.ffc156p-1, INEXACT)
T(RU,    0x1.21c2e58f33245p-9,    0x1.00910a79b86a3p+0,  0x1.77f756p-11, INEXACT)
T(RZ,    0x1.21c2e58f33245p-9,    0x1.00910a79b86a2p+0,  -0x1.ffa202p-1, INEXACT)
T(RN,    0x1.3fbf5b08c395ep-9,    0x1.00a011a3b8da4p+0,  -0x1.ff18c4p-2, INEXACT)
T(RN,    0x1.6230a96475c61p-9,    0x1.00b155a42862ep+0,  -0x1.ff8a48p-2, INEXACT)
T(RZ,   -0x1.1c1e4910bc5d9p-8,    0x1.fdc8fe4c8d5bdp-1, -0x1.5215f6p-12, INEXACT)
T(RU,   -0x1.1c1e4910bc5d9p-8,    0x1.fdc8fe4c8d5bep-1,   0x1.ffd5bep-1, INEXACT)
T(RZ,    0x1.57ed830e42924p-8,    0x1.0158d4f1cf76dp+0, -0x1.b39218p-12, INEXACT)
T(RU,    0x1.57ed830e42924p-8,    0x1.0158d4f1cf76ep+0,   0x1.ffc98ep-1, INEXACT)
T(RZ,    0x1.d849419ce94dep-7,    0x1.03b76986a86bfp+0, -0x1.0847ccp-12, INEXACT)
T(RU,    0x1.d849419ce94dep-7,     0x1.03b76986a86cp+0,   0x1.ffdef8p-1, INEXACT)
T(RZ,    0x1.51ad063f707b1p-7,    0x1.02a6d7efde632p+0, -0x1.ea88d8p-12, INEXACT)
T(RU,    0x1.51ad063f707b1p-7,    0x1.02a6d7efde633p+0,   0x1.ffc2aep-1, INEXACT)
T(RN,   -0x1.b919a82a436dap-7,    0x1.f9276bec78f6ap-1,  -0x1.ff4c7ep-2, INEXACT)
T(RN,    0x1.d94350233a84ap-7,    0x1.03b964e84ab8cp+0,  -0x1.ff5a26p-2, INEXACT)
T(RZ,   -0x1.140600fbe665cp-6,    0x1.f7724f2652a92p-1, -0x1.765e1ep-14, INEXACT)
T(RU,   -0x1.140600fbe665cp-6,    0x1.f7724f2652a93p-1,   0x1.fff44ep-1, INEXACT)
T(RN,    0x1.e28a6e69e5771p-6,    0x1.07a6de1d087fep+0,  -0x1.fffa88p-2, INEXACT)
T(RU,   -0x1.094bcf84a2988p-6,    0x1.f7c6b8bedbc3ap-1,   0x1.19ae3p-12, INEXACT)
T(RZ,   -0x1.094bcf84a2988p-6,    0x1.f7c6b8bedbc39p-1,  -0x1.ffdccap-1, INEXACT)
T(RN,   -0x1.348ce997314e2p-6,    0x1.f672b1bbea488p-1,  -0x1.ffb114p-2, INEXACT)
T(RN,   -0x1.00949184e368ep-6,    0x1.f80b58a653909p-1,  -0x1.ffb43ap-2, INEXACT)
T(RZ,   -0x1.7b44c5bc05afep-6,    0x1.f448b324a0ab4p-1, -0x1.8470c6p-12, INEXACT)
T(RU,   -0x1.7b44c5bc05afep-6,    0x1.f448b324a0ab5p-1,   0x1.ffcf72p-1, INEXACT)
T(RZ,    0x1.9123dede600c6p-6,    0x1.06585d5140cfdp+0, -0x1.12682ap-11, INEXACT)
T(RU,    0x1.9123dede600c6p-6,    0x1.06585d5140cfep+0,   0x1.ffbb66p-1, INEXACT)
T(RN,   -0x1.608d951da6f2cp-6,    0x1.f519b445a50dep-1,  -0x1.ff1b2cp-2, INEXACT)
T(RN,    0x1.518d8d6141f9ep-6,     0x1.05543779c9dfp+0,  -0x1.ff26cap-2, INEXACT)
T(RN,   -0x1.baff26ae5d117p-6,    0x1.f257825e36715p-1,  -0x1.ff1cbap-2, INEXACT)
T(RN,   -0x1.8dd8af003db1ap-6,    0x1.f3b78f8d927a2p-1,  -0x1.ff8fb2p-2, INEXACT)
T(RN,    0x1.c691688f8cfc6p-6,    0x1.0733bb053b58ep+0,  -0x1.ff2b88p-2, INEXACT)
T(RN,    0x1.1f75cea6e65acp-5,    0x1.0924818355d3ep+0,   -0x1.ffef7p-2, INEXACT)
T(RZ,   -0x1.a111fcf84dabdp-5,    0x1.e695e663a991fp-1, -0x1.127036p-11, INEXACT)
T(RU,   -0x1.a111fcf84dabdp-5,     0x1.e695e663a992p-1,   0x1.ffbb64p-1, INEXACT)
T(RN,    0x1.23d6420e7c02cp-5,    0x1.0948c7b83fcc7p+0,  -0x1.ffa46cp-2, INEXACT)
T(RU,    0x1.3a4ef10c3d552p-5,    0x1.0a0353b567e66p+0,  0x1.db5e04p-13, INEXACT)
T(RZ,    0x1.3a4ef10c3d552p-5,    0x1.0a0353b567e65p+0,  -0x1.ffe24ap-1, INEXACT)
T(RZ,    0x1.4459309c24695p-5,    0x1.0a56d70a32e09p+0, -0x1.0292d2p-12, INEXACT)
T(RU,    0x1.4459309c24695p-5,    0x1.0a56d70a32e0ap+0,   0x1.ffdfaep-1, INEXACT)
T(RU,    0x1.94d2702ec51eep-5,    0x1.0cf7ee42c0fa9p+0,  0x1.5676dcp-11, INEXACT)
T(RZ,    0x1.94d2702ec51eep-5,    0x1.0cf7ee42c0fa8p+0,  -0x1.ffaa62p-1, INEXACT)
T(RN,   -0x1.5f5f6606c4889p-5,    0x1.ea80e6b386601p-1,  -0x1.ffb8cep-2, INEXACT)
T(RN,   -0x1.ea5175f3c63fdp-5,    0x1.e24112392ca74p-1,   -0x1.ff3d1p-2, INEXACT)
T(RZ,   -0x1.942565e6790d3p-4,    0x1.cfe4df4921005p-1, -0x1.a7225cp-11, INEXACT)
T(RU,   -0x1.942565e6790d3p-4,    0x1.cfe4df4921006p-1,   0x1.ff9638p-1, INEXACT)
T(RU,   -0x1.09d2c04879969p-4,    0x1.dfd3cdd50a915p-1,  0x1.397914p-11, INEXACT)
T(RZ,   -0x1.09d2c04879969p-4,    0x1.dfd3cdd50a914p-1,  -0x1.ffb1a2p-1, INEXACT)
T(RN,    0x1.6392d0e9fc9b3p-4,    0x1.17376afac6032p+0,   -0x1.ff99cp-2, INEXACT)
T(RN,    0x1.357ef089d86adp-4,    0x1.1417d24e90b4cp+0,  -0x1.ff3d0ep-2, INEXACT)
T(RZ,   -0x1.6dfdfc954bd89p-4,    0x1.d43c40947a98bp-1, -0x1.ceadaap-12, INEXACT)
T(RU,   -0x1.6dfdfc954bd89p-4,    0x1.d43c40947a98cp-1,   0x1.ffc62ap-1, INEXACT)
T(RN,   -0x1.f92df0e4e37e8p-4,    0x1.c49767eaec9a3p-1,  -0x1.ffeadcp-2, INEXACT)
T(RN,   -0x1.0b206203c484ap-3,    0x1.c163ea6d28e86p-1,    -0x1.ffdfp-2, INEXACT)
T(RN,    0x1.9b0f3248a1156p-3,    0x1.38e6e91324385p+0,  -0x1.ffbe62p-2, INEXACT)
T(RN,    0x1.2e1f7da943e44p-3,    0x1.28b17266a05e7p+0,  -0x1.ff1986p-2, INEXACT)
T(RZ,    0x1.bce489eaae15dp-3,    0x1.3e1d37b918233p+0, -0x1.e2d76ap-11, INEXACT)
T(RU,    0x1.bce489eaae15dp-3,    0x1.3e1d37b918234p+0,   0x1.ff874ap-1, INEXACT)
T(RN,    0x1.e49c96df62e06p-3,    0x1.44580702938a4p+0,  -0x1.ff8c36p-2, INEXACT)
T(RN,    0x1.e2be36054f3c6p-3,    0x1.440c4cf8bf4ffp+0,  -0x1.ff5bcep-2, INEXACT)
T(RN,    0x1.f06def277bebfp-3,    0x1.46388a14e845cp+0,   -0x1.ff8cbp-2, INEXACT)
T(RU,   -0x1.8132ba37fb38ap-3,    0x1.a836f3a1533a3p-1,  0x1.645196p-11, INEXACT)
T(RZ,   -0x1.8132ba37fb38ap-3,    0x1.a836f3a1533a2p-1,  -0x1.ffa6ecp-1, INEXACT)
T(RU,    0x1.a005dc0206c4bp-3,    0x1.39a94878b3f6fp+0,  0x1.9f5758p-11, INEXACT)
T(RZ,    0x1.a005dc0206c4bp-3,    0x1.39a94878b3f6ep+0,  -0x1.ff982ap-1, INEXACT)
T(RZ,   -0x1.1f9eb37645593p-3,    0x1.bcea7674ca727p-1, -0x1.6e092ep-16, INEXACT)
T(RU,   -0x1.1f9eb37645593p-3,    0x1.bcea7674ca728p-1,   0x1.fffd24p-1, INEXACT)
T(RN,    0x1.e76c30533c59bp-3,    0x1.44ca11bf51dfbp+0,  -0x1.ff3174p-2, INEXACT)
T(RN,     0x1.6062285d4099p-2,    0x1.69272f9fbcf1dp+0,  -0x1.ffc994p-2, INEXACT)
T(RU,    0x1.e53fc3d9974c3p-2,    0x1.9b3070d0a5c43p+0,  0x1.094b18p-11, INEXACT)
T(RZ,    0x1.e53fc3d9974c3p-2,    0x1.9b3070d0a5c42p+0,  -0x1.ffbdaep-1, INEXACT)
T(RU,     -0x1.0bebb9b5694p-2,    0x1.8a2185fd26fa1p-1,  0x1.01a648p-16, INEXACT)
T(RZ,     -0x1.0bebb9b5694p-2,     0x1.8a2185fd26fap-1,  -0x1.fffdfcp-1, INEXACT)
T(RU,    0x1.3ce5646f7b4cap-2,    0x1.5cd9fa397b632p+0,  0x1.58b6f2p-11, INEXACT)
T(RZ,    0x1.3ce5646f7b4cap-2,    0x1.5cd9fa397b631p+0,  -0x1.ffa9d2p-1, INEXACT)
T(RU,   -0x1.d160633274ffbp-2,    0x1.4502830e715d6p-1,  0x1.f3b30ep-11, INEXACT)
T(RZ,   -0x1.d160633274ffbp-2,    0x1.4502830e715d5p-1,  -0x1.ff8314p-1, INEXACT)
T(RZ,    0x1.245d4ce761781p-2,    0x1.5497ede6defeap+0, -0x1.7fa9eap-11, INEXACT)
T(RU,    0x1.245d4ce761781p-2,    0x1.5497ede6defebp+0,   0x1.ffa016p-1, INEXACT)
T(RN,    0x1.73aebe4e3b2abp-2,    0x1.700632a6c1a7fp+0,  -0x1.ffc32ap-2, INEXACT)
T(RZ,    0x1.e0a20aaa088ddp-1,    0x1.474387c1b77b1p+1, -0x1.0123d6p-17, INEXACT)
T(RU,    0x1.e0a20aaa088ddp-1,    0x1.474387c1b77b2p+1,   0x1.fffefep-1, INEXACT)
T(RZ,    0x1.cfc03df291d3ap-1,    0x1.3ca62349303a8p+1, -0x1.ebd90ep-12, INEXACT)
T(RU,    0x1.cfc03df291d3ap-1,    0x1.3ca62349303a9p+1,   0x1.ffc284p-1, INEXACT)
T(RZ,   -0x1.b093a12f95e1fp-1,    0x1.b7ebcfc0eab47p-2, -0x1.000cbep-12, INEXACT)
T(RU,   -0x1.b093a12f95e1fp-1,    0x1.b7ebcfc0eab48p-2,   0x1.ffdffep-1, INEXACT)
T(RN,    0x1.98eab8db8ceb4p-1,    0x1.1c7d4a6119a68p+1,   -0x1.ff374p-2, INEXACT)
T(RU,    -0x1.46ec5d43e46ap-1,    0x1.0e5f7e30fbf5fp-1,  0x1.9b4638p-12, INEXACT)
T(RZ,    -0x1.46ec5d43e46ap-1,    0x1.0e5f7e30fbf5ep-1,  -0x1.ffcc98p-1, INEXACT)
T(RU,   -0x1.b1b1cc2b89af2p-1,    0x1.b6f632c317721p-2,  0x1.2f6374p-11, INEXACT)
T(RZ,   -0x1.b1b1cc2b89af2p-1,     0x1.b6f632c31772p-2,  -0x1.ffb428p-1, INEXACT)
T(RU,   -0x1.81495f3ea5b46p-1,    0x1.e27d4791891d5p-2,  0x1.c39b06p-12, INEXACT)
T(RZ,   -0x1.81495f3ea5b46p-1,    0x1.e27d4791891d4p-2,  -0x1.ffc78cp-1, INEXACT)
T(RZ,   -0x1.47b9ee2a05c61p-1,    0x1.0df30638661efp-1,  -0x1.5f665p-14, INEXACT)
T(RU,   -0x1.47b9ee2a05c61p-1,     0x1.0df30638661fp-1,   0x1.fff504p-1, INEXACT)
T(RN,   -0x1.84c10fdd5b03ap-1,    0x1.df3b94a0cefbbp-2,   -0x1.ff052p-2, INEXACT)
T(RN,   -0x1.543bb62fac993p-1,    0x1.076f5a7c0d0d3p-1,  -0x1.ff26bcp-2, INEXACT)
T(RN,   -0x1.ecf0d22063314p-1,    0x1.86fef11d944bap-2,  -0x1.ffb064p-2, INEXACT)
T(RZ,   -0x1.ae27e15ab48c1p+0,    0x1.7d94b7bee8561p-3, -0x1.9e8074p-13, INEXACT)
T(RU,   -0x1.ae27e15ab48c1p+0,    0x1.7d94b7bee8562p-3,   0x1.ffe618p-1, INEXACT)
T(RU,   -0x1.2f6fa2391edf9p+0,    0x1.38fdb6c89b56ap-2,  0x1.5dd824p-12, INEXACT)
T(RZ,   -0x1.2f6fa2391edf9p+0,    0x1.38fdb6c89b569p-2,  -0x1.ffd444p-1, INEXACT)
T(RU,   -0x1.e0e03475dac93p+0,    0x1.38ff934848e49p-3,  0x1.8c462ep-12, INEXACT)
T(RZ,   -0x1.e0e03475dac93p+0,    0x1.38ff934848e48p-3,  -0x1.ffce78p-1, INEXACT)
T(RU,   -0x1.e314d233ef9f8p+0,    0x1.3650367154dcbp-3,  0x1.8ec9e8p-11, INEXACT)
T(RZ,   -0x1.e314d233ef9f8p+0,    0x1.3650367154dcap-3,  -0x1.ff9c4ep-1, INEXACT)
T(RN,   -0x1.7242b89efd35bp+0,    0x1.e22a7d5af2cf1p-3,  -0x1.ffe648p-2, INEXACT)
T(RU,   -0x1.61771338a0945p+0,    0x1.016e219069401p-2,  0x1.b2b99ep-11, INEXACT)
T(RZ,   -0x1.61771338a0945p+0,      0x1.016e2190694p-2,  -0x1.ff9352p-1, INEXACT)
T(RN,   -0x1.bf9f55bd3afc9p+1,    0x1.f03731a302642p-6,  -0x1.ffa976p-2, INEXACT)
T(RZ,   -0x1.af79022c2ba7bp+1,    0x1.1978d4bb1dc57p-5, -0x1.7c3b96p-21, INEXACT)
T(RU,   -0x1.af79022c2ba7bp+1,    0x1.1978d4bb1dc58p-5,   0x1.ffffe8p-1, INEXACT)
T(RU,   -0x1.2df92c8b84beep+1,    0x1.831151665053ap-4,  0x1.a142e6p-11, INEXACT)
T(RZ,   -0x1.2df92c8b84beep+1,    0x1.8311516650539p-4,   -0x1.ff97bp-1, INEXACT)
T(RN,   -0x1.24d1d4fc72087p+1,    0x1.9fc308209a949p-4,  -0x1.ff8f22p-2, INEXACT)
T(RN,     0x1.9975aeaef053p+1,    0x1.88172902b54c5p+4,   -0x1.ff18cp-2, INEXACT)
T(RN,   -0x1.422a2d8f95d0ap+1,    0x1.4a94ede9e8409p-4,  -0x1.ff622ap-2, INEXACT)
T(RU,   -0x1.c42e6536d0c0bp+1,    0x1.deda7d5bd0565p-6,  0x1.8616dep-12, INEXACT)
T(RZ,   -0x1.c42e6536d0c0bp+1,    0x1.deda7d5bd0564p-6,  -0x1.ffcf3ep-1, INEXACT)
T(RU,    0x1.9ff3c1ddc28b7p+1,    0x1.9c7dc58f3575fp+4,  0x1.623c3cp-11, INEXACT)
T(RZ,    0x1.9ff3c1ddc28b7p+1,    0x1.9c7dc58f3575ep+4,   -0x1.ffa77p-1, INEXACT)
T(RN,    0x1.a9ac3b0eb23ecp+1,    0x1.bd0974c7d5d54p+4,  -0x1.ff2f16p-2, INEXACT)
T(RZ,    0x1.3139d8826d4c3p+2,    0x1.d7476392f9491p+6, -0x1.16066ap-13, INEXACT)
T(RU,    0x1.3139d8826d4c3p+2,    0x1.d7476392f9492p+6,    0x1.ffeeap-1, INEXACT)
T(RZ,   -0x1.cde9841b24dddp+2,   0x1.80aec3022ce0ep-11, -0x1.b64d4ap-11, INEXACT)
T(RU,   -0x1.cde9841b24dddp+2,   0x1.80aec3022ce0fp-11,   0x1.ff926cp-1, INEXACT)
T(RU,   -0x1.0c34a58b85966p+2,    0x1.eff5a660d947cp-7,  0x1.0ddc6ap-12, INEXACT)
T(RZ,   -0x1.0c34a58b85966p+2,    0x1.eff5a660d947bp-7,  -0x1.ffde44p-1, INEXACT)
T(RN,    0x1.dbed550861c02p+2,   0x1.a82420d622f57p+10,   -0x1.ffc75p-2, INEXACT)
T(RN,    0x1.7e60830d79b98p+2,    0x1.8953a40ef07a4p+8,  -0x1.ff847ap-2, INEXACT)
T(RN,    0x1.be323335d435bp+2,    0x1.0a89eafde3e8p+10,   -0x1.ff751p-2, INEXACT)
T(RZ,   -0x1.0193e16011de3p+3,   0x1.4ed618e76dd58p-12, -0x1.9a9ff4p-11, INEXACT)
T(RU,   -0x1.0193e16011de3p+3,   0x1.4ed618e76dd59p-12,   0x1.ff9958p-1, INEXACT)
T(RZ,     0x1.f345acc49a2dp+3,   0x1.6c610a3b43734p+22, -0x1.a1263cp-11, INEXACT)
T(RU,     0x1.f345acc49a2dp+3,   0x1.6c610a3b43735p+22,   0x1.ff97b6p-1, INEXACT)
T(RZ,   -0x1.4e41f0592dbadp+3,   0x1.e7d67fe59ed13p-16, -0x1.a56efep-11, INEXACT)
T(RU,   -0x1.4e41f0592dbadp+3,   0x1.e7d67fe59ed14p-16,   0x1.ff96a4p-1, INEXACT)
T(RN,    0x1.9a4042411611bp+3,   0x1.68ff79d28d14fp+18,   -0x1.ff41ep-2, INEXACT)
T(RN,    0x1.37a150ceba515p+3,   0x1.08f4658013fb8p+14,  -0x1.ff8d4ap-2, INEXACT)
T(RN,   -0x1.a7e33e2332ebfp+3,   0x1.da337a6af8a1ep-20,  -0x1.ff52d6p-2, INEXACT)
T(RU,   -0x1.cb976c29d0b35p+4,   0x1.793e506a67eb4p-42,  0x1.70c7b4p-13, INEXACT)
T(RZ,   -0x1.cb976c29d0b35p+4,   0x1.793e506a67eb3p-42,  -0x1.ffe8f4p-1, INEXACT)
T(RU,    0x1.30a14fe9b71e4p+4,   0x1.621a3d7a8e17bp+27,  0x1.dc068ep-11, INEXACT)
T(RZ,    0x1.30a14fe9b71e4p+4,   0x1.621a3d7a8e17ap+27,  -0x1.ff88fep-1, INEXACT)
T(RN,    0x1.f31390a791555p+4,   0x1.002ad77e82fafp+45,  -0x1.ff3fcep-2, INEXACT)
T(RZ,   -0x1.20e7933a124aap+4,   0x1.ee88846105e79p-27, -0x1.32c798p-11, INEXACT)
T(RU,   -0x1.20e7933a124aap+4,   0x1.ee88846105e7ap-27,   0x1.ffb34ep-1, INEXACT)
T(RU,   -0x1.4262ba03cc8bep+4,   0x1.e815c61fe7568p-30,  0x1.8e3082p-11, INEXACT)
T(RZ,   -0x1.4262ba03cc8bep+4,   0x1.e815c61fe7567p-30,  -0x1.ff9c74p-1, INEXACT)
T(RU,     0x1.00966bbf797cp+4,   0x1.195399a8425bfp+23,  0x1.e8949ep-12, INEXACT)
T(RZ,     0x1.00966bbf797cp+4,   0x1.195399a8425bep+23,  -0x1.ffc2eep-1, INEXACT)
T(RZ,    0x1.154215f649803p+4,    0x1.fffa106b0494p+24, -0x1.d92136p-13, INEXACT)
T(RU,    0x1.154215f649803p+4,   0x1.fffa106b04941p+24,   0x1.ffe26ep-1, INEXACT)
T(RN,    0x1.a72084deb60b7p+4,   0x1.1c9529fbbd033p+38,  -0x1.ff6924p-2, INEXACT)
T(RZ,   -0x1.a492875aa6abcp+5,   0x1.1d17d815102d5p-76, -0x1.ab6516p-13, INEXACT)
T(RU,   -0x1.a492875aa6abcp+5,   0x1.1d17d815102d6p-76,   0x1.ffe54ap-1, INEXACT)
T(RU,   -0x1.45e72a8750ad4p+5,   0x1.2bc2eec9112bap-59,  0x1.950758p-14, INEXACT)
T(RZ,   -0x1.45e72a8750ad4p+5,   0x1.2bc2eec9112b9p-59,  -0x1.fff358p-1, INEXACT)
T(RN,    0x1.6bf4de1052e5cp+5,   0x1.8d7df5be694bcp+65,  -0x1.ff74f2p-2, INEXACT)
T(RZ,    0x1.a52e7eff10793p+5,   0x1.f021cc3ee27cdp+75, -0x1.32c076p-14, INEXACT)
T(RU,    0x1.a52e7eff10793p+5,   0x1.f021cc3ee27cep+75,   0x1.fff66ap-1, INEXACT)
T(RN,    0x1.3ae3916835096p+5,   0x1.b971d0f525cf9p+56,  -0x1.ffb18cp-2, INEXACT)
T(RZ,   -0x1.05b8261ba4023p+6,   0x1.854a748cff3d6p-95, -0x1.0bdaa2p-11, INEXACT)
T(RU,   -0x1.05b8261ba4023p+6,   0x1.854a748cff3d7p-95,   0x1.ffbd0ap-1, INEXACT)
T(RU,    0x1.ae619707dc958p+6,   0x1.2baa642dd57fp+155,  0x1.3f8a86p-12, INEXACT)
T(RZ,    0x1.ae619707dc958p+6,  0x1.2baa642dd57efp+155,  -0x1.ffd80ep-1, INEXACT)
T(RZ,    0x1.eccc64080e798p+6,  0x1.ab671bf82594cp+177, -0x1.2cf4f4p-11, INEXACT)
T(RU,    0x1.eccc64080e798p+6,  0x1.ab671bf82594dp+177,   0x1.ffb4c2p-1, INEXACT)
T(RN,    0x1.de16517d75bb1p+7,  0x1.d2e91cfea05afp+344,  -0x1.ffde26p-2, INEXACT)
T(RU,    0x1.c0a32b6983669p+7,  0x1.8a62ac3ec8a18p+323,  0x1.1cf2bap-11, INEXACT)
T(RZ,    0x1.c0a32b6983669p+7,  0x1.8a62ac3ec8a17p+323,  -0x1.ffb8c4p-1, INEXACT)
T(RZ,   -0x1.834735faec218p+7,  0x1.8e56dfe7bca1ep-280, -0x1.5fa3fcp-13, INEXACT)
T(RU,   -0x1.834735faec218p+7,  0x1.8e56dfe7bca1fp-280,   0x1.ffea06p-1, INEXACT)
T(RU,    -0x1.78feea525b97p+7,  0x1.09f49ce931de6p-272,  0x1.5b6bacp-11, INEXACT)
T(RZ,    -0x1.78feea525b97p+7,  0x1.09f49ce931de5p-272,  -0x1.ffa926p-1, INEXACT)
T(RU,    0x1.7954851232847p+7,  0x1.2342fd04f415bp+272,  0x1.dca268p-13, INEXACT)
T(RZ,    0x1.7954851232847p+7,  0x1.2342fd04f415ap+272,  -0x1.ffe236p-1, INEXACT)
T(RN,    0x1.11ed68a34d0fcp+7,  0x1.832c4ed680b21p+197,  -0x1.ffddc6p-2, INEXACT)
T(RN,    0x1.e95f152b10b15p+7,  0x1.013846abdee36p+353,  -0x1.ffc7dep-2, INEXACT)
T(RN,    0x1.5101e4d0df545p+7,  0x1.124501eadaac7p+243,  -0x1.ff5904p-2, INEXACT)
T(RN,    0x1.e18631578bc59p+7,  0x1.45728bc2dc0ddp+347,  -0x1.ff1796p-2, INEXACT)
T(RN,    -0x1.d9e1203714d4p+8,  0x1.43421410d642ep-684,  -0x1.ff6c86p-2, INEXACT)
T(RN,    0x1.de3f5501fbb6fp+8,  0x1.f3c6c59b9cf6bp+689,  -0x1.ffbd56p-2, INEXACT)
T(RN,    -0x1.22e1e7876172p+8,  0x1.453cacbac6f2ap-420,  -0x1.ffd68cp-2, INEXACT)
T(RN,    0x1.c298a22f9274cp+8,  0x1.0d46840162343p+650,  -0x1.ff9434p-2, INEXACT)
T(RU,    0x1.f25be4348e243p+8,  0x1.f8f254a280b1bp+718,  0x1.ddb07cp-19, INEXACT)
T(RZ,    0x1.f25be4348e243p+8,  0x1.f8f254a280b1ap+718,  -0x1.ffff88p-1, INEXACT)
T(RN,   -0x1.25fd2cbd8f519p+8,  0x1.d1cddc2c1d016p-425,  -0x1.ff5718p-2, INEXACT)
T(RZ,   -0x1.a2880efb5b593p+8,  0x1.235eddc12bc0bp-604, -0x1.e0c80ap-12, INEXACT)
T(RU,   -0x1.a2880efb5b593p+8,  0x1.235eddc12bc0cp-604,   0x1.ffc3e6p-1, INEXACT)
T(RN,    0x1.d07680fc9bd8cp+8,  0x1.0e48a09d377c7p+670,  -0x1.ff1f9cp-2, INEXACT)
T(RZ,    0x1.f23d7472551e1p+8,  0x1.c057f5b2f1779p+718, -0x1.ffa998p-19, INEXACT)
T(RU,    0x1.f23d7472551e1p+8,  0x1.c057f5b2f177ap+718,    0x1.ffff8p-1, INEXACT)
T(RU,   -0x1.a577863622faap+8,  0x1.ef2dc0b159b37p-609,  0x1.f52ef4p-14, INEXACT)
T(RZ,   -0x1.a577863622faap+8,  0x1.ef2dc0b159b36p-609,  -0x1.fff056p-1, INEXACT)
T(RN,    0x1.d93801ae176f2p+8,  0x1.a2e05d1d76086p+682,  -0x1.ffedf2p-2, INEXACT)
T(RN,   -0x1.f50c6872001bep+8,  0x1.1a0f64c656f26p-723,  -0x1.ff8d24p-2, INEXACT)
T(RN,    0x1.5b542c23eea84p+8,  0x1.1064183058ee5p+501,  -0x1.ffe094p-2, INEXACT)
T(RN,   -0x1.9d33188d4a432p+8,  0x1.d6cee82a9b6e6p-597,  -0x1.ff5974p-2, INEXACT)
T(RN,   -0x1.4abaf42f158f1p+8,  0x1.cfb39ddbd026ep-478,  -0x1.ff21ecp-2, INEXACT)
T(RZ,  -0x1.629e5e9099dd6p-15,      0x1.fffa758e32ap-1, -0x1.cba2fcp-13, INEXACT)
T(RU,  -0x1.629e5e9099dd6p-15,    0x1.fffa758e32a01p-1,   0x1.ffe346p-1, INEXACT)
T(RU,    0x1.8f4d5b526e4fp-15,    0x1.00031e9f944e6p+0,  0x1.af9c38p-15, INEXACT)
T(RZ,    0x1.8f4d5b526e4fp-15,    0x1.00031e9f944e5p+0,  -0x1.fff942p-1, INEXACT)
T(RU,   0x1.2e6f8e6d91f0ep-15,    0x1.00025ce1e7742p+0,  0x1.76c32cp-16, INEXACT)
T(RZ,   0x1.2e6f8e6d91f0ep-15,    0x1.00025ce1e7741p+0,  -0x1.fffd12p-1, INEXACT)
T(RZ,  -0x1.7b325d541f99ap-15,    0x1.fffa133f515f8p-1, -0x1.658852p-14, INEXACT)
T(RU,  -0x1.7b325d541f99ap-15,    0x1.fffa133f515f9p-1,   0x1.fff4d4p-1, INEXACT)
T(RU,   0x1.c84da2a5de894p-15,    0x1.000390a19ffcap+0,  0x1.00f704p-13, INEXACT)
T(RZ,   0x1.c84da2a5de894p-15,    0x1.000390a19ffc9p+0,   -0x1.ffeffp-1, INEXACT)
T(RN,   0x1.8548f570652f2p-15,    0x1.00030a968ad31p+0,  -0x1.fffa2cp-2, INEXACT)
T(RN,   0x1.09e14c99e5ee2p-15,    0x1.000213c4c17dbp+0,  -0x1.fff078p-2, INEXACT)
T(RU,  -0x1.123a42943e00cp-15,    0x1.fffbb71b8caedp-1,  0x1.86ba3ep-13, INEXACT)
T(RZ,  -0x1.123a42943e00cp-15,    0x1.fffbb71b8caecp-1,  -0x1.ffe794p-1, INEXACT)
T(RN,   0x1.a75a7ecc311cdp-15,    0x1.00034eba75d6cp+0,  -0x1.ffc43ep-2, INEXACT)
T(RN,  -0x1.b9b2606991df7p-15,    0x1.fff9194266ac3p-1,  -0x1.ffd31ep-2, INEXACT)
T(RN,   0x1.43dc9dd4ae0c5p-15,    0x1.000287bc6f18fp+0,   -0x1.ffd91p-2, INEXACT)
T(RZ,   0x1.64afac0d77539p-14,    0x1.000592ce381b3p+0, -0x1.c994f4p-13, INEXACT)
T(RU,   0x1.64afac0d77539p-14,    0x1.000592ce381b4p+0,   0x1.ffe366p-1, INEXACT)
T(RZ,   0x1.040f0a27d54fbp-14,    0x1.000410446a1efp+0, -0x1.9c5b52p-13, INEXACT)
T(RU,   0x1.040f0a27d54fbp-14,     0x1.000410446a1fp+0,   0x1.ffe63ap-1, INEXACT)
T(RU,   0x1.8560d08e4ceb1p-14,    0x1.00061595c459bp+0,  0x1.9bc1d4p-13, INEXACT)
T(RZ,   0x1.8560d08e4ceb1p-14,    0x1.00061595c459ap+0,  -0x1.ffe644p-1, INEXACT)
T(RU,   0x1.9fbc3fc385dafp-14,    0x1.00067f06185adp+0,    0x1.e2fap-13, INEXACT)
T(RZ,   0x1.9fbc3fc385dafp-14,    0x1.00067f06185acp+0,   -0x1.ffe1dp-1, INEXACT)
T(RU,  -0x1.ef0ae0ab5e47ep-14,    0x1.fff087e4cebbep-1,  0x1.ab0feep-14, INEXACT)
T(RZ,  -0x1.ef0ae0ab5e47ep-14,    0x1.fff087e4cebbdp-1,  -0x1.fff2a8p-1, INEXACT)
T(RN,   0x1.9253f84021a07p-14,    0x1.00064963a3888p+0,  -0x1.fff03cp-2, INEXACT)
T(RZ,   0x1.c581474d23de4p-13,    0x1.000e2c6ea89c8p+0, -0x1.bdb5c4p-13, INEXACT)
T(RU,   0x1.c581474d23de4p-13,    0x1.000e2c6ea89c9p+0,   0x1.ffe424p-1, INEXACT)
T(RN,  -0x1.146b21418836cp-13,    0x1.ffeeb99888dbcp-1,  -0x1.ffd062p-2, INEXACT)
T(RU,   0x1.3b6b01f2183dbp-13,    0x1.0009db88a440dp+0,  0x1.b9691ap-15, INEXACT)
T(RZ,   0x1.3b6b01f2183dbp-13,    0x1.0009db88a440cp+0,  -0x1.fff91ap-1, INEXACT)
T(RU,   0x1.0dc413a170de7p-13,    0x1.00086e4426245p+0,  0x1.7dcda6p-14, INEXACT)
T(RZ,   0x1.0dc413a170de7p-13,    0x1.00086e4426244p+0,  -0x1.fff412p-1, INEXACT)
T(RZ,  -0x1.140d6611e45acp-13,    0x1.ffeebf740944fp-1, -0x1.9d6728p-13, INEXACT)
T(RU,  -0x1.140d6611e45acp-13,     0x1.ffeebf740945p-1,   0x1.ffe62ap-1, INEXACT)
T(RZ,   0x1.197ea327d0266p-13,    0x1.0008cc1bca981p+0, -0x1.bee4bep-14, INEXACT)
T(RU,   0x1.197ea327d0266p-13,    0x1.0008cc1bca982p+0,   0x1.fff208p-1, INEXACT)
T(RU,   0x1.5d31901ffb3c7p-13,     0x1.000ae9c80bdep+0,  0x1.b90334p-13, INEXACT)
T(RZ,   0x1.5d31901ffb3c7p-13,    0x1.000ae9c80bddfp+0,   -0x1.ffe47p-1, INEXACT)
T(RN,  -0x1.f20a11d43116fp-13,    0x1.ffe0e051189fcp-1,  -0x1.fff1e8p-2, INEXACT)
T(RU,  -0x1.b417edef67f3cp-13,    0x1.ffe4bf3ad61f1p-1,  0x1.af4456p-15, INEXACT)
T(RZ,  -0x1.b417edef67f3cp-13,     0x1.ffe4bf3ad61fp-1,  -0x1.fff942p-1, INEXACT)
T(RU,  -0x1.d9ed0a7e55c05p-13,    0x1.ffe2620aab52fp-1,  0x1.e7478ep-13, INEXACT)
T(RZ,  -0x1.d9ed0a7e55c05p-13,    0x1.ffe2620aab52ep-1,  -0x1.ffe18cp-1, INEXACT)
T(RN,   0x1.2c45d8c31beffp-13,    0x1.0009625acd1b7p+0,  -0x1.ffe998p-2, INEXACT)
T(RZ,  -0x1.aa8007e08966dp-12,    0x1.ffcab2c579a02p-1, -0x1.47aafep-14, INEXACT)
T(RU,  -0x1.aa8007e08966dp-12,    0x1.ffcab2c579a03p-1,   0x1.fff5c2p-1, INEXACT)
T(RZ,   -0x1.f8ad95148454p-12,    0x1.ffc0ee302084bp-1, -0x1.169842p-14, INEXACT)
T(RU,   -0x1.f8ad95148454p-12,    0x1.ffc0ee302084cp-1,   0x1.fff74cp-1, INEXACT)
T(RU,    0x1.a74733759a81p-12,    0x1.001a75d13197bp+0,   0x1.9b0c9p-15, INEXACT)
T(RZ,    0x1.a74733759a81p-12,    0x1.001a75d13197ap+0,  -0x1.fff994p-1, INEXACT)
T(RN,  -0x1.4e875472895e9p-12,    0x1.ffd630ca8b305p-1,  -0x1.ffe64cp-2, INEXACT)
T(RU,  -0x1.355eabba5ddc4p-12,    0x1.ffd955a05cf86p-1,  0x1.d258a2p-14, INEXACT)
T(RZ,  -0x1.355eabba5ddc4p-12,    0x1.ffd955a05cf85p-1,  -0x1.fff16ep-1, INEXACT)
T(RN,   0x1.2176f5e53832dp-12,    0x1.001218130915bp+0,  -0x1.fffe98p-2, INEXACT)
T(RN,   0x1.a23059c941f63p-12,    0x1.001a245b392b6p+0,  -0x1.ffd3aap-2, INEXACT)
T(RN,  -0x1.505a6889eff05p-11,    0x1.ffabf04d328b6p-1,  -0x1.fffa48p-2, INEXACT)
T(RN,  -0x1.35cd9ef1c2f63p-11,    0x1.ffb29273a00f4p-1,  -0x1.fffeeap-2, INEXACT)
T(RU,   0x1.435c97d2b9ae9p-11,    0x1.00286ec40ae88p+0,  0x1.981c1cp-13, INEXACT)
T(RZ,   0x1.435c97d2b9ae9p-11,    0x1.00286ec40ae87p+0,  -0x1.ffe67ep-1, INEXACT)
T(RN,  -0x1.ee6fd0abb58b2p-11,    0x1.ff8472f670a7fp-1,  -0x1.ffce3cp-2, INEXACT)
T(RN,  -0x1.40b7e33fb19bbp-11,    0x1.ffafd84e0d226p-1,  -0x1.ffc702p-2, INEXACT)
T(RN,   0x1.804299e26894dp-11,    0x1.00300cd51433ep+0,  -0x1.ffe842p-2, INEXACT)
T(RN,   0x1.1fbdb3c8208c2p-11,    0x1.0023fa3d6d1b8p+0,    -0x1.fff9p-2, INEXACT)
T(RN,   0x1.c1362b15db80ep-10,    0x1.00706630586c6p+0,  -0x1.ffc6a4p-2, INEXACT)
T(RZ,  -0x1.2b376c6e7bf0fp-10,    0x1.ff6a7a2350186p-1, -0x1.16b37ap-13, INEXACT)
T(RU,  -0x1.2b376c6e7bf0fp-10,    0x1.ff6a7a2350187p-1,   0x1.ffee94p-1, INEXACT)
T(RU,   0x1.af9b97dee3becp-10,    0x1.006bfda694336p+0,   0x1.ee652p-13, INEXACT)
T(RZ,   0x1.af9b97dee3becp-10,    0x1.006bfda694335p+0,  -0x1.ffe11ap-1, INEXACT)
T(RN,   0x1.d179fb2597116p-10,     0x1.007478f5aeafp+0,  -0x1.ffc77ap-2, INEXACT)
T(RN,  -0x1.8dd33aba7b159p-10,    0x1.ff393d012f703p-1,  -0x1.ffd696p-2, INEXACT)
T(RN,   0x1.4958bb30db8b8p-10,    0x1.0052636de13a6p+0,  -0x1.ffda3ep-2, INEXACT)
T(RN,  -0x1.aee914bdc97d7p-10,    0x1.ff28b8c48345cp-1,  -0x1.ffe086p-2, INEXACT)
T(RU,   -0x1.1c49f3f7d2c5fp-9,    0x1.fee404ea793e1p-1,  0x1.ea96e2p-16, INEXACT)
T(RZ,   -0x1.1c49f3f7d2c5fp-9,     0x1.fee404ea793ep-1,  -0x1.fffc2ap-1, INEXACT)
T(RZ,   -0x1.aa878ff8bf8adp-9,    0x1.fe5629e898771p-1, -0x1.0c1892p-13, INEXACT)
T(RU,   -0x1.aa878ff8bf8adp-9,    0x1.fe5629e898772p-1,   0x1.ffef3ep-1, INEXACT)
T(RU,    0x1.7f0fc02a5c15cp-9,    0x1.00bfcf97fb112p+0,  0x1.025c06p-16, INEXACT)
T(RZ,    0x1.7f0fc02a5c15cp-9,    0x1.00bfcf97fb111p+0,  -0x1.fffdfcp-1, INEXACT)
T(RU,    0x1.7af0b348de5fbp-9,    0x1.00bdbe886a587p+0,  0x1.bbb2b6p-13, INEXACT)
T(RZ,    0x1.7af0b348de5fbp-9,    0x1.00bdbe886a586p+0,  -0x1.ffe444p-1, INEXACT)
T(RZ,    0x1.4e85e75fdf9bbp-9,    0x1.00a779a3ce133p+0,  -0x1.32699p-13, INEXACT)
T(RU,    0x1.4e85e75fdf9bbp-9,    0x1.00a779a3ce134p+0,   0x1.ffecdap-1, INEXACT)
T(RN,   -0x1.e56d662d17091p-9,    0x1.fe1b786f179adp-1,  -0x1.fffb74p-2, INEXACT)
T(RN,   -0x1.673b412f7682bp-9,    0x1.fe9942a72c1e8p-1,  -0x1.ffcc92p-2, INEXACT)
T(RU,    0x1.6312c7290ba71p-9,    0x1.00b1c70174d32p+0,  0x1.84fa9cp-13, INEXACT)
T(RZ,    0x1.6312c7290ba71p-9,    0x1.00b1c70174d31p+0,   -0x1.ffe7bp-1, INEXACT)
T(RZ,   -0x1.b68ed73ea6ae2p-9,    0x1.fe4a2cc6722c3p-1,  -0x1.fad25p-13, INEXACT)
T(RU,   -0x1.b68ed73ea6ae2p-9,    0x1.fe4a2cc6722c4p-1,   0x1.ffe052p-1, INEXACT)
T(RN,    0x1.f0d18bfe42f8fp-9,    0x1.00f8e172996c2p+0,  -0x1.ffd44cp-2, INEXACT)
T(RN,    0x1.3a266578234e1p-9,    0x1.009d436cdf7d5p+0,   -0x1.fff91p-2, INEXACT)
T(RN,   -0x1.a5ece7391e45ap-9,    0x1.fe5ac0c25273ep-1,  -0x1.ffc06ep-2, INEXACT)
T(RN,    0x1.e3c90b6ab16dap-9,    0x1.00f256f1c455bp+0,  -0x1.ffccbcp-2, INEXACT)
T(RZ,    0x1.f54b783512a95p-8,    0x1.01f737896d98bp+0, -0x1.5495c6p-14, INEXACT)
T(RU,    0x1.f54b783512a95p-8,    0x1.01f737896d98cp+0,   0x1.fff55cp-1, INEXACT)
T(RN,    0x1.a9641af603a83p-8,    0x1.01aac64dcf799p+0,   -0x1.ffebcp-2, INEXACT)
T(RN,   -0x1.607c521fb47d9p-8,    0x1.fd40ebd36ab26p-1,  -0x1.ffcf1ap-2, INEXACT)
T(RZ,    0x1.ac9fa400e6c03p-8,    0x1.01ae073fafb32p+0, -0x1.764b72p-13, INEXACT)
T(RU,    0x1.ac9fa400e6c03p-8,    0x1.01ae073fafb33p+0,   0x1.ffe89cp-1, INEXACT)
T(RZ,    0x1.05ac767d69ce4p-8,    0x1.01063260a9137p+0, -0x1.d6f88ep-14, INEXACT)
T(RU,    0x1.05ac767d69ce4p-8,    0x1.01063260a9138p+0,   0x1.fff148p-1, INEXACT)
T(RZ,   -0x1.c5ae289fbfb5fp-8,    0x1.fc77c5d6717dbp-1, -0x1.f860f8p-17, INEXACT)
T(RU,   -0x1.c5ae289fbfb5fp-8,    0x1.fc77c5d6717dcp-1,   0x1.fffe08p-1, INEXACT)
T(RN,    0x1.cc3a10ece1281p-8,    0x1.01cdd8b9a107fp+0,  -0x1.ffeeb4p-2, INEXACT)
T(RN,   -0x1.0c702f7c179b9p-8,    0x1.fde838b9d36f8p-1,  -0x1.fff8b2p-2, INEXACT)
T(RN,   -0x1.aa8b0813a2059p-8,    0x1.fcadaf18c75f9p-1,  -0x1.ffc764p-2, INEXACT)
T(RN,    0x1.a2d7d601eddb2p-8,    0x1.01a42f33f1c43p+0,  -0x1.ffceecp-2, INEXACT)
T(RU,   -0x1.737fb7b3d1eeap-7,    0x1.fa3a656e95ccep-1,  0x1.5d0c3ep-13, INEXACT)
T(RZ,   -0x1.737fb7b3d1eeap-7,    0x1.fa3a656e95ccdp-1,   -0x1.ffea3p-1, INEXACT)
T(RU,    0x1.cdb57505eea49p-7,    0x1.03a1f431a406dp+0,  0x1.33bbc2p-13, INEXACT)
T(RZ,    0x1.cdb57505eea49p-7,    0x1.03a1f431a406cp+0,  -0x1.ffecc4p-1, INEXACT)
T(RN,   -0x1.69d07de3a3d55p-7,    0x1.fa60b3fd2a46bp-1,   -0x1.ffcabp-2, INEXACT)
T(RU,   -0x1.6b4fa1fe7243ep-7,    0x1.fa5ac849d6f3cp-1,  0x1.ce7ecap-13, INEXACT)
T(RZ,   -0x1.6b4fa1fe7243ep-7,    0x1.fa5ac849d6f3bp-1,  -0x1.ffe318p-1, INEXACT)
T(RN,    0x1.03befa0a9902bp-7,    0x1.02098e714cd42p+0,   -0x1.ffdd1p-2, INEXACT)
T(RN,    0x1.28ea271130d2bp-7,    0x1.0254872083806p+0,  -0x1.ffd886p-2, INEXACT)
T(RU,    -0x1.10ec9c83f69cp-7,    0x1.fbc0d63310022p-1,  0x1.e64f6ap-14, INEXACT)
T(RZ,    -0x1.10ec9c83f69cp-7,    0x1.fbc0d63310021p-1,  -0x1.fff0cep-1, INEXACT)
T(RZ,    0x1.0351b7d4df5c5p-7,    0x1.0208b2300e4cdp+0, -0x1.fbe6cep-13, INEXACT)
T(RU,    0x1.0351b7d4df5c5p-7,    0x1.0208b2300e4cep+0,   0x1.ffe042p-1, INEXACT)
T(RN,    0x1.3eb2b91eb6917p-7,    0x1.0280818769a9ap+0,  -0x1.ffced4p-2, INEXACT)
T(RN,    0x1.87bfa131bb3bcp-7,    0x1.0314330310991p+0,  -0x1.ffe93cp-2, INEXACT)
T(RN,    0x1.9d0d936a1ed21p-7,    0x1.033f55aebaf14p+0,  -0x1.ffee9cp-2, INEXACT)
T(RN,   -0x1.adf969b82269ap-6,    0x1.f2bcf3248cd04p-1,  -0x1.ffe37ep-2, INEXACT)
T(RU,   -0x1.13a2a1cd7f9a2p-6,    0x1.f7755cda3ea68p-1,  0x1.4f3614p-13, INEXACT)
T(RZ,   -0x1.13a2a1cd7f9a2p-6,    0x1.f7755cda3ea67p-1,  -0x1.ffeb0cp-1, INEXACT)
T(RU,    0x1.5d76f13c56d02p-6,    0x1.0584df78ad51fp+0,  0x1.0c24d6p-13, INEXACT)
T(RZ,    0x1.5d76f13c56d02p-6,    0x1.0584df78ad51ep+0,  -0x1.ffef3ep-1, INEXACT)
T(RU,    0x1.4aab9f6c6b211p-6,    0x1.05381e8fa9bfbp+0,  0x1.1d054ep-17, INEXACT)
T(RZ,    0x1.4aab9f6c6b211p-6,    0x1.05381e8fa9bfap+0,  -0x1.fffee2p-1, INEXACT)
T(RZ,    0x1.0c4eb785e5aa3p-6,    0x1.043a10da03668p+0, -0x1.464328p-13, INEXACT)
T(RU,    0x1.0c4eb785e5aa3p-6,    0x1.043a10da03669p+0,   0x1.ffeb9cp-1, INEXACT)
T(RU,   -0x1.744b786f5c975p-6,    0x1.f47f39b4f7733p-1,  0x1.2c84d8p-14, INEXACT)
T(RZ,   -0x1.744b786f5c975p-6,    0x1.f47f39b4f7732p-1,  -0x1.fff69cp-1, INEXACT)
T(RN,    -0x1.42a55a144b72p-6,    0x1.f60414f59e6b9p-1,  -0x1.ffc732p-2, INEXACT)
T(RN,   -0x1.5bbdda37407c9p-6,    0x1.f53f61c1f80e9p-1,  -0x1.ffd25ap-2, INEXACT)
T(RN,   -0x1.42ce1a366f426p-6,    0x1.f602d5505f0b9p-1,   -0x1.ffd7ap-2, INEXACT)
T(RZ,   -0x1.ce3b111e7ecefp-5,     0x1.e3e916a08697p-1,  -0x1.e1531p-14, INEXACT)
T(RU,   -0x1.ce3b111e7ecefp-5,    0x1.e3e916a086971p-1,   0x1.fff0f6p-1, INEXACT)
T(RZ,     0x1.bb5f80d19da6p-5,    0x1.0e3cb9db761b9p+0, -0x1.284ff4p-13, INEXACT)
T(RU,     0x1.bb5f80d19da6p-5,    0x1.0e3cb9db761bap+0,   0x1.ffed7cp-1, INEXACT)
T(RU,   -0x1.411d2915722c5p-5,    0x1.ec51926a99162p-1,  0x1.12a25cp-14, INEXACT)
T(RZ,   -0x1.411d2915722c5p-5,    0x1.ec51926a99161p-1,  -0x1.fff76ap-1, INEXACT)
T(RN,    0x1.e352d37924de3p-5,    0x1.0f8eeda692feep+0,  -0x1.ffe7c8p-2, INEXACT)
T(RN,   -0x1.53ca77a6a72bep-5,    0x1.eb328e0118819p-1,  -0x1.ffe39ep-2, INEXACT)
T(RN,   -0x1.9bb95759631f8p-5,    0x1.e6e7388d2650fp-1,   -0x1.ffd5dp-2, INEXACT)
T(RN,   -0x1.14b7c0bafffa3p-5,    0x1.eefe75663ef88p-1,  -0x1.ffe8c8p-2, INEXACT)
T(RN,   -0x1.511081701de57p-4,    0x1.d78dceebb724bp-1,  -0x1.ffee22p-2, INEXACT)
T(RU,    0x1.5535cc6594eddp-4,    0x1.163d339c93829p+0,  0x1.10aa5cp-13, INEXACT)
T(RZ,    0x1.5535cc6594eddp-4,    0x1.163d339c93828p+0,  -0x1.ffeef6p-1, INEXACT)
T(RN,   -0x1.f24596227a777p-4,     0x1.c55af7807483p-1,  -0x1.ffe4b6p-2, INEXACT)
T(RN,   -0x1.093f4f9225928p-4,    0x1.dfe513c2b9c11p-1,   -0x1.ffe0dp-2, INEXACT)
T(RN,    0x1.a3e8412bd36e7p-4,    0x1.1ba2f8980486ep+0,  -0x1.ffc314p-2, INEXACT)
T(RN,   -0x1.3487ae21c6d61p-3,    0x1.b86579e5d8786p-1,  -0x1.fff5c6p-2, INEXACT)
T(RU,    -0x1.a7d8b3d1d6cap-3,     0x1.a048c4daba29p-1,  0x1.0dc7a8p-15, INEXACT)
T(RZ,    -0x1.a7d8b3d1d6cap-3,    0x1.a048c4daba28fp-1,  -0x1.fffbc8p-1, INEXACT)
T(RN,   -0x1.9115827bbaa02p-3,    0x1.a4efd542837f9p-1,   -0x1.ffcb5p-2, INEXACT)
T(RU,   -0x1.6c86f52f3c143p-3,    0x1.ac849e4c8dfafp-1,   0x1.a2e66p-14, INEXACT)
T(RZ,   -0x1.6c86f52f3c143p-3,    0x1.ac849e4c8dfaep-1,  -0x1.fff2e8p-1, INEXACT)
T(RZ,    0x1.c22e449e4a172p-3,    0x1.3eefc354c1937p+0, -0x1.0e8358p-15, INEXACT)
T(RU,    0x1.c22e449e4a172p-3,    0x1.3eefc354c1938p+0,   0x1.fffbc6p-1, INEXACT)
T(RZ,    0x1.b5f5db6a64df1p-3,    0x1.3d0a061c396a2p+0,  -0x1.3c2b6p-15, INEXACT)
T(RU,    0x1.b5f5db6a64df1p-3,    0x1.3d0a061c396a3p+0,    0x1.fffb1p-1, INEXACT)
T(RN,   -0x1.fe4cc4b7559efp-3,    0x1.8f13c047bd233p-1,  -0x1.ffd122p-2, INEXACT)
T(RN,   -0x1.afe1738f48994p-3,    0x1.9ea7867a385dcp-1,  -0x1.ffed94p-2, INEXACT)
T(RN,   -0x1.487bbbbc5ca0fp-3,    0x1.b420634333368p-1,  -0x1.ffd83ap-2, INEXACT)
T(RZ,    0x1.7a33e87ec3175p-2,     0x1.726001e22906p+0, -0x1.bb6a5ep-14, INEXACT)
T(RU,    0x1.7a33e87ec3175p-2,    0x1.726001e229061p+0,   0x1.fff224p-1, INEXACT)
T(RZ,   -0x1.056c426af74b4p-2,     0x1.8ca3d0fd5e74p-1, -0x1.b13fd2p-18, INEXACT)
T(RU,   -0x1.056c426af74b4p-2,    0x1.8ca3d0fd5e741p-1,   0x1.ffff28p-1, INEXACT)
T(RZ,   -0x1.7a5c741fcd4bap-2,    0x1.61d5d0d098df1p-1,  -0x1.1e772p-13, INEXACT)
T(RU,   -0x1.7a5c741fcd4bap-2,    0x1.61d5d0d098df2p-1,   0x1.ffee18p-1, INEXACT)
T(RZ,    0x1.9efd8d9b65e84p-2,    0x1.7fec3e0febf66p+0, -0x1.98699cp-14, INEXACT)
T(RU,    0x1.9efd8d9b65e84p-2,    0x1.7fec3e0febf67p+0,   0x1.fff33cp-1, INEXACT)
T(RN,   -0x1.5e71aa4c40e73p-2,    0x1.6b9d4dc100e49p-1,  -0x1.ffdb98p-2, INEXACT)
T(RU,    0x1.f7eaadf16dd47p-1,    0x1.567d73cdc117bp+1,  0x1.1b1138p-21, INEXACT)
T(RZ,    0x1.f7eaadf16dd47p-1,    0x1.567d73cdc117ap+1,  -0x1.ffffeep-1, INEXACT)
T(RN,   -0x1.0053b5a3bd923p-1,    0x1.36586e318494dp-1,  -0x1.ffe9bcp-2, INEXACT)
T(RU,   -0x1.fa15cbf64136bp-1,    0x1.7d15efd3258f5p-2,  0x1.9189dep-13, INEXACT)
T(RZ,   -0x1.fa15cbf64136bp-1,    0x1.7d15efd3258f4p-2,  -0x1.ffe6e8p-1, INEXACT)
T(RU,   -0x1.e9ca0affb3f4cp-1,    0x1.8968f2eced0b2p-2,  0x1.4ca7bcp-14, INEXACT)
T(RZ,   -0x1.e9ca0affb3f4cp-1,    0x1.8968f2eced0b1p-2,  -0x1.fff59ap-1, INEXACT)
T(RZ,   -0x1.c1399f1346c91p-1,    0x1.a9d8b756adcd8p-2, -0x1.25f462p-16, INEXACT)
T(RU,   -0x1.c1399f1346c91p-1,    0x1.a9d8b756adcd9p-2,   0x1.fffdb4p-1, INEXACT)
T(RN,    0x1.25619ae8a4df1p-1,    0x1.c60a85f8684b6p+0,  -0x1.fff64cp-2, INEXACT)
T(RN,    0x1.dd88d0ef7b69ap+0,    0x1.9d5514a76a3b6p+2,  -0x1.ffc3e6p-2, INEXACT)
T(RN,   -0x1.730d38cc94d5ap+0,    0x1.e0adad1a4616ep-3,  -0x1.ffc192p-2, INEXACT)
T(RZ,   -0x1.878ea311fba29p+0,    0x1.bbad8884a680fp-3, -0x1.0b5654p-13, INEXACT)
T(RU,   -0x1.878ea311fba29p+0,     0x1.bbad8884a681p-3,   0x1.ffef4ap-1, INEXACT)
T(RU,    0x1.300e2733e98ccp+0,    0x1.a3c9575fdbd2bp+1,  0x1.83d372p-13, INEXACT)
T(RZ,    0x1.300e2733e98ccp+0,    0x1.a3c9575fdbd2ap+1,  -0x1.ffe7c2p-1, INEXACT)
T(RU,    0x1.6e2006c2f6323p+1,    0x1.177b9efb49925p+4,  0x1.530778p-14, INEXACT)
T(RZ,    0x1.6e2006c2f6323p+1,    0x1.177b9efb49924p+4,  -0x1.fff568p-1, INEXACT)
T(RN,    0x1.ff7be81d7ccd3p+1,    0x1.b3072a5bf321dp+5,  -0x1.fff8fap-2, INEXACT)
T(RU,   -0x1.562f93056cec9p+1,    0x1.1ab70a139e688p-4,  0x1.801082p-13, INEXACT)
T(RZ,   -0x1.562f93056cec9p+1,    0x1.1ab70a139e687p-4,  -0x1.ffe7fep-1, INEXACT)
T(RN,    -0x1.ae5247e8d02ep+1,    0x1.1c03dc401e3fcp-5,  -0x1.ffef82p-2, INEXACT)
T(RN,    0x1.b03b52cb283adp+1,    0x1.d46f92bc26c1ap+4,  -0x1.ffdaf6p-2, INEXACT)
T(RU,    0x1.603d8e1801556p+2,    0x1.eb39d7c889c95p+7,  0x1.45e168p-14, INEXACT)
T(RZ,    0x1.603d8e1801556p+2,    0x1.eb39d7c889c94p+7,   -0x1.fff5dp-1, INEXACT)
T(RU,   -0x1.a751f451e8e03p+2,   0x1.5f859e6c93ed2p-10,  0x1.b81e9ep-14, INEXACT)
T(RZ,   -0x1.a751f451e8e03p+2,   0x1.5f859e6c93ed1p-10,   -0x1.fff24p-1, INEXACT)
T(RZ,   -0x1.50223dd949421p+2,    0x1.572ef22b40863p-8, -0x1.f35272p-17, INEXACT)
T(RU,   -0x1.50223dd949421p+2,    0x1.572ef22b40864p-8,   0x1.fffe0cp-1, INEXACT)
T(RU,   -0x1.9be2b9fddfccbp+2,   0x1.a44945ddb3995p-10,  0x1.b34c78p-13, INEXACT)
T(RZ,   -0x1.9be2b9fddfccbp+2,   0x1.a44945ddb3994p-10,  -0x1.ffe4ccp-1, INEXACT)
T(RU,   -0x1.b1a08252dbf72p+2,   0x1.2b3c0852100d2p-10,  0x1.bcab98p-17, INEXACT)
T(RZ,   -0x1.b1a08252dbf72p+2,   0x1.2b3c0852100d1p-10,  -0x1.fffe44p-1, INEXACT)
T(RN,   -0x1.b04ab13be38c4p+2,   0x1.318aff776dd98p-10,  -0x1.ffc704p-2, INEXACT)
T(RN,    0x1.5dc7757528414p+2,    0x1.d8b16a0bdddb1p+7,  -0x1.fff8bep-2, INEXACT)
T(RN,    0x1.0d8da0430704dp+2,    0x1.0de73acad7effp+6,   -0x1.ffc67p-2, INEXACT)
T(RN,    0x1.02e11f981dfd8p+2,    0x1.c8e2975621311p+5,  -0x1.ffef6ap-2, INEXACT)
T(RN,   -0x1.f0c13102116ebp+2,   0x1.be5f2b7e4d51dp-12,  -0x1.ffd55ep-2, INEXACT)
T(RN,    0x1.fa5216712c59ap+2,   0x1.54fa6e9499caap+11,  -0x1.ffcbbcp-2, INEXACT)
T(RU,    0x1.8b847bbf423d7p+3,   0x1.c7978d0d28455p+17,  0x1.cc898cp-15, INEXACT)
T(RZ,    0x1.8b847bbf423d7p+3,   0x1.c7978d0d28454p+17,  -0x1.fff8cep-1, INEXACT)
T(RU,    0x1.0ff07d9598ee5p+3,   0x1.3297909429773p+12,  0x1.6c4d48p-14, INEXACT)
T(RZ,    0x1.0ff07d9598ee5p+3,   0x1.3297909429772p+12,  -0x1.fff49ep-1, INEXACT)
T(RZ,    -0x1.bf7a50780a9ep+3,   0x1.c5c4c0533551cp-21, -0x1.fa534ep-17, INEXACT)
T(RU,    -0x1.bf7a50780a9ep+3,   0x1.c5c4c0533551dp-21,   0x1.fffe06p-1, INEXACT)
T(RZ,   -0x1.25ad38eb06d38p+3,    0x1.b17a8c4c2033p-14, -0x1.ad5ce2p-13, INEXACT)
T(RU,   -0x1.25ad38eb06d38p+3,   0x1.b17a8c4c20331p-14,   0x1.ffe52ap-1, INEXACT)
T(RZ,   -0x1.1fe76a354699cp+3,   0x1.0396459db77c8p-13, -0x1.e27c36p-14, INEXACT)
T(RU,   -0x1.1fe76a354699cp+3,   0x1.0396459db77c9p-13,   0x1.fff0ecp-1, INEXACT)
T(RU,    0x1.44429db757b39p+3,   0x1.892c3115d3c99p+14,  0x1.cca6b2p-13, INEXACT)
T(RZ,    0x1.44429db757b39p+3,   0x1.892c3115d3c98p+14,  -0x1.ffe336p-1, INEXACT)
T(RN,    0x1.a8ebd885fa886p+3,   0x1.1d7acb01fb32fp+19,  -0x1.ffe3c6p-2, INEXACT)
T(RN,   -0x1.b0fa5cf69a279p+3,   0x1.64efdbce97c44p-20,  -0x1.ffe6a6p-2, INEXACT)
T(RN,    0x1.1e619194f8d17p+3,   0x1.e1758ee776a1dp+12,  -0x1.ffe146p-2, INEXACT)
T(RU,   -0x1.2266b6495380dp+4,   0x1.c25f5f943b7efp-27,  0x1.a122e6p-13, INEXACT)
T(RZ,   -0x1.2266b6495380dp+4,   0x1.c25f5f943b7eep-27,  -0x1.ffe5eep-1, INEXACT)
T(RU,      0x1.366f8eb3b42p+4,   0x1.fcfedc3bb88bdp+27,  0x1.52528ap-15, INEXACT)
T(RZ,      0x1.366f8eb3b42p+4,   0x1.fcfedc3bb88bcp+27,  -0x1.fffab6p-1, INEXACT)
T(RN,    0x1.fe9b4da922928p+4,    0x1.074ec00c77c1p+46,  -0x1.ffc224p-2, INEXACT)
T(RZ,    0x1.abaab158f139ep+4,   0x1.79f2c8eccdf18p+38, -0x1.198682p-19, INEXACT)
T(RU,    0x1.abaab158f139ep+4,   0x1.79f2c8eccdf19p+38,   0x1.ffffbap-1, INEXACT)
T(RN,   -0x1.c4b4efe4443d8p+4,   0x1.220ba4ec15a4cp-41,  -0x1.ffc46ep-2, INEXACT)
T(RU,     -0x1.45ff83fb0fep+4,   0x1.8570c5ab6bd61p-30,   0x1.5582ap-13, INEXACT)
T(RZ,     -0x1.45ff83fb0fep+4,    0x1.8570c5ab6bd6p-30,  -0x1.ffeaa8p-1, INEXACT)
T(RN,     0x1.67ab944c0d43p+4,   0x1.591b9fc26a85ep+32,  -0x1.ffc418p-2, INEXACT)
T(RN,    0x1.ead575d509f48p+4,   0x1.3212137cca2bdp+44,  -0x1.ffc698p-2, INEXACT)
T(RN,    0x1.98f731661dc6bp+4,   0x1.d5c362a6c4361p+36,  -0x1.ffefd6p-2, INEXACT)
T(RN,   -0x1.e35a832ee7b54p+4,   0x1.55bde9ddc8c53p-44,   -0x1.ffc45p-2, INEXACT)
T(RN,     0x1.ef12ec499517p+4,    0x1.8ef1b2402d1dp+44,  -0x1.ffe5b8p-2, INEXACT)
T(RN,    0x1.6ff69833b808ap+5,   0x1.47f4071bea985p+66,  -0x1.ffcc02p-2, INEXACT)
T(RU,   -0x1.efd1c8db1b041p+5,   0x1.80222492931afp-90,  0x1.eeee38p-15, INEXACT)
T(RZ,   -0x1.efd1c8db1b041p+5,   0x1.80222492931aep-90,  -0x1.fff844p-1, INEXACT)
T(RN,    0x1.1b7888d9111c2p+5,   0x1.16406da3c9cfep+51,  -0x1.ffeecap-2, INEXACT)
T(RZ,    0x1.2ce83247656f8p+5,   0x1.338a5f5f191e4p+54,  -0x1.39608p-13, INEXACT)
T(RU,    0x1.2ce83247656f8p+5,   0x1.338a5f5f191e5p+54,   0x1.ffec6ap-1, INEXACT)
T(RN,   -0x1.d6128874542e5p+5,   0x1.2bf4f0d405e1ep-85,  -0x1.ffff22p-2, INEXACT)
T(RU,   -0x1.6eeccb39e5081p+5,   0x1.c70de06225ccfp-67,  0x1.643deep-14, INEXACT)
T(RZ,   -0x1.6eeccb39e5081p+5,   0x1.c70de06225ccep-67,  -0x1.fff4dep-1, INEXACT)
T(RN,   -0x1.d9bda618ccf9ap+5,   0x1.7b43a16a4e8c9p-86,  -0x1.ffd138p-2, INEXACT)
T(RN,   -0x1.c465f41b40273p+5,   0x1.558a3107cd9c3p-82,  -0x1.ffc334p-2, INEXACT)
T(RN,    0x1.386a2951dbad6p+5,   0x1.44025bea60b7dp+56,  -0x1.fffc96p-2, INEXACT)
T(RN,   -0x1.33c7472351f8ep+5,   0x1.6915fe1033c7bp-56,   -0x1.ffce5p-2, INEXACT)
T(RU,   -0x1.8dd5782c8fbc4p+6,  0x1.6d00bbcf4f9b8p-144,   0x1.5c543p-13, INEXACT)
T(RZ,   -0x1.8dd5782c8fbc4p+6,  0x1.6d00bbcf4f9b7p-144,  -0x1.ffea3ap-1, INEXACT)
T(RZ,   -0x1.b70ed9872c235p+6,  0x1.8fd85f1992acep-159, -0x1.f1a314p-15, INEXACT)
T(RU,   -0x1.b70ed9872c235p+6,  0x1.8fd85f1992acfp-159,   0x1.fff83ap-1, INEXACT)
T(RZ,     0x1.25e4aa4f8c57p+6,  0x1.ffd95002ac95fp+105, -0x1.9096bep-13, INEXACT)
T(RU,     0x1.25e4aa4f8c57p+6,   0x1.ffd95002ac96p+105,   0x1.ffe6f6p-1, INEXACT)
T(RN,    0x1.ec37142a38f98p+6,  0x1.7169a44166161p+177,  -0x1.fffe5ap-2, INEXACT)
T(RN,   -0x1.56d4d15746fc7p+6,  0x1.463a7e06ad275p-124,   -0x1.ffeebp-2, INEXACT)
T(RN,   -0x1.16524d3d0ab87p+6,  0x1.888d67153b73fp-101,  -0x1.ffd8ccp-2, INEXACT)
T(RN,    0x1.1709630d1b1a4p+6,  0x1.8f43efc0d9073p+100,  -0x1.ffc89ep-2, INEXACT)
T(RU,    0x1.a334837396e56p+6,  0x1.254fcbcb51ec2p+151,  0x1.aa36eap-13, INEXACT)
T(RZ,    0x1.a334837396e56p+6,  0x1.254fcbcb51ec1p+151,  -0x1.ffe55cp-1, INEXACT)
T(RN,    0x1.90dd12b15cee6p+6,  0x1.7ef05225ef3f9p+144,  -0x1.fff8dap-2, INEXACT)
T(RN,   -0x1.a72bf179bf708p+6,  0x1.4b8d25db50e39p-153,  -0x1.ffc44cp-2, INEXACT)
T(RZ,   -0x1.17d1acae24c6fp+7,  0x1.1cafa78da5aebp-202, -0x1.1249b8p-13, INEXACT)
T(RU,   -0x1.17d1acae24c6fp+7,  0x1.1cafa78da5aecp-202,   0x1.ffeedcp-1, INEXACT)
T(RU,   -0x1.30ef351504741p+7,  0x1.0687011ece336p-220,  0x1.1da388p-13, INEXACT)
T(RZ,   -0x1.30ef351504741p+7,  0x1.0687011ece335p-220,  -0x1.ffee26p-1, INEXACT)
T(RU,   -0x1.d10f59ed3631ep+7,  0x1.71aef7ddd4027p-336,  0x1.c1e398p-14, INEXACT)
T(RZ,   -0x1.d10f59ed3631ep+7,  0x1.71aef7ddd4026p-336,   -0x1.fff1fp-1, INEXACT)
T(RU,    0x1.ab4e937f2ae1ap+7,  0x1.2daa1135aed82p+308,  0x1.e9dc6ap-16, INEXACT)
T(RZ,    0x1.ab4e937f2ae1ap+7,  0x1.2daa1135aed81p+308,  -0x1.fffc2cp-1, INEXACT)
T(RN,    0x1.fd1df97b9227bp+7,  0x1.3082bcd513b81p+367,   -0x1.ffea6p-2, INEXACT)
T(RU,    0x1.fb877891c77c5p+8,  0x1.28141b6b603b6p+732,  0x1.8261f2p-14, INEXACT)
T(RZ,    0x1.fb877891c77c5p+8,  0x1.28141b6b603b5p+732,  -0x1.fff3ecp-1, INEXACT)
T(RN,   -0x1.34b0d20a103b3p+8,  0x1.92ab47637fe15p-446,  -0x1.ffc47ep-2, INEXACT)
T(RN,    0x1.0b51b092d62d6p+8,  0x1.947c09cf924e4p+385,  -0x1.ffc904p-2, INEXACT)
T(RN,    0x1.6ce0578d983a4p+8,  0x1.53085bf28b058p+526,  -0x1.fff51cp-2, INEXACT)
T(RU,    0x1.06dd93fdd48b6p+8,  0x1.2d3f9c472a3ecp+379,  0x1.b836f4p-13, INEXACT)
T(RZ,    0x1.06dd93fdd48b6p+8,  0x1.2d3f9c472a3ebp+379,  -0x1.ffe47cp-1, INEXACT)
T(RN,    0x1.8a083cc65f3dep+8,  0x1.6229a2a8ca806p+568,  -0x1.ffcb0ep-2, INEXACT)
T(RN,   -0x1.50bb00da34fb8p+8,  0x1.26309c940cd1ep-486,  -0x1.ffe6d6p-2, INEXACT)
T(RN,   -0x1.0f82b25594cc6p+8,  0x1.39ab491b8a875p-392,  -0x1.ffd682p-2, INEXACT)
T(RN,   0x1.2a5f043294c01p-15,    0x1.000254c0bfe9fp+0,  -0x1.fffd64p-2, INEXACT)
T(RN,   0x1.aae04932dc965p-15,    0x1.000355c6220a5p+0,  -0x1.fffd52p-2, INEXACT)
T(RZ,  -0x1.dc83c1fe0890ep-15,    0x1.fff88dfed3dfap-1, -0x1.fbed34p-15, INEXACT)
T(RU,  -0x1.dc83c1fe0890ep-15,    0x1.fff88dfed3dfbp-1,    0x1.fff81p-1, INEXACT)
T(RZ,  -0x1.50f96e68379cap-15,    0x1.fffabc213497ep-1, -0x1.719d88p-15, INEXACT)
T(RU,  -0x1.50f96e68379cap-15,    0x1.fffabc213497fp-1,   0x1.fffa3ap-1, INEXACT)
T(RN,   0x1.7a4be714c85d1p-15,    0x1.0002f49c2c365p+0,  -0x1.fff448p-2, INEXACT)
T(RU,  -0x1.2a01d76c4c539p-15,    0x1.fffb57fe0debcp-1,  0x1.718b62p-16, INEXACT)
T(RZ,  -0x1.2a01d76c4c539p-15,    0x1.fffb57fe0debbp-1,  -0x1.fffd1cp-1, INEXACT)
T(RU,  -0x1.661a4720ae7e3p-15,     0x1.fffa679eb72cp-1,  0x1.23d1eep-16, INEXACT)
T(RZ,  -0x1.661a4720ae7e3p-15,    0x1.fffa679eb72bfp-1,  -0x1.fffdb8p-1, INEXACT)
T(RN,   0x1.40e99f47f0668p-15,    0x1.000281d663244p+0,   -0x1.fffe3p-2, INEXACT)
T(RN,   0x1.4e5f02d089197p-15,    0x1.00029cc16f1c2p+0,  -0x1.fff856p-2, INEXACT)
T(RN,   0x1.90166301f92aap-15,    0x1.00032031a894fp+0,  -0x1.fff94ap-2, INEXACT)
T(RN,  -0x1.ca4f3e47d21d1p-15,    0x1.fff8d6cfd8cffp-1,  -0x1.fff456p-2, INEXACT)
T(RN,   0x1.02750e05cbe6ap-14,    0x1.000409dc5fa35p+0,  -0x1.fff7b8p-2, INEXACT)
T(RN,   0x1.4e3fa99735c3cp-14,     0x1.0005390c49c6p+0,  -0x1.fff15ap-2, INEXACT)
T(RN,  -0x1.111419fb8263bp-14,    0x1.fff7777164c81p-1,   -0x1.fff2fp-2, INEXACT)
T(RN,  -0x1.2b4d73fd80ca5p-14,    0x1.fff6a5aa3ed22p-1,  -0x1.fff7ecp-2, INEXACT)
T(RU,  -0x1.17a668ec89e12p-14,    0x1.fff742dfd0423p-1,   0x1.178b6p-15, INEXACT)
T(RZ,  -0x1.17a668ec89e12p-14,    0x1.fff742dfd0422p-1,  -0x1.fffba2p-1, INEXACT)
T(RN,   0x1.13752c381a42dp-14,    0x1.00044dddf4154p+0,  -0x1.fff462p-2, INEXACT)
T(RN,   0x1.1201ec1a5a0b4p-14,    0x1.00044810dab76p+0,  -0x1.fffe1ap-2, INEXACT)
T(RU,   0x1.de8318b1d670fp-13,    0x1.000ef48895767p+0,  0x1.5ae29ap-17, INEXACT)
T(RZ,   0x1.de8318b1d670fp-13,    0x1.000ef48895766p+0,  -0x1.fffea6p-1, INEXACT)
T(RN,  -0x1.d28b57075ddf8p-13,    0x1.ffe2d81f1b665p-1,  -0x1.fffa4ap-2, INEXACT)
T(RN,   -0x1.8702828764fap-13,    0x1.ffe7906d23544p-1,  -0x1.fff8c8p-2, INEXACT)
T(RU,  -0x1.fc096e5e79d35p-13,    0x1.ffe04065223e3p-1,  0x1.f55816p-19, INEXACT)
T(RZ,  -0x1.fc096e5e79d35p-13,    0x1.ffe04065223e2p-1,  -0x1.ffff82p-1, INEXACT)
T(RZ,   0x1.51d75e1e4bc49p-13,    0x1.000a8ef2accdep+0, -0x1.365006p-15, INEXACT)
T(RU,   0x1.51d75e1e4bc49p-13,    0x1.000a8ef2accdfp+0,   0x1.fffb26p-1, INEXACT)
T(RN,  -0x1.5c4ddb1c68ec6p-13,    0x1.ffea3b98c57c7p-1,   -0x1.fff12p-2, INEXACT)
T(RN,  -0x1.758bcf8c268fcp-12,    0x1.ffd150a70ea0ep-1,  -0x1.fff836p-2, INEXACT)
T(RN,   -0x1.df69844f701ep-12,    0x1.ffc416511f14ap-1,  -0x1.fff484p-2, INEXACT)
T(RU,  -0x1.f762618d7353fp-12,    0x1.ffc1179179878p-1,  0x1.466924p-15, INEXACT)
T(RZ,  -0x1.f762618d7353fp-12,    0x1.ffc1179179877p-1,  -0x1.fffae6p-1, INEXACT)
T(RN,   0x1.cb99ef4bf3173p-12,    0x1.001cbb3b94dc4p+0,  -0x1.fffa98p-2, INEXACT)
T(RU,   0x1.0b51bfc9fa569p-12,    0x1.0010b5a791791p+0,  0x1.92a1d4p-15, INEXACT)
T(RZ,   0x1.0b51bfc9fa569p-12,     0x1.0010b5a79179p+0,  -0x1.fff9b6p-1, INEXACT)
T(RN,  -0x1.eb6203a6a8d44p-12,    0x1.ffc2976e9693fp-1,  -0x1.ffff48p-2, INEXACT)
T(RN,  -0x1.a0115e8370e8ap-12,    0x1.ffcc007851214p-1,  -0x1.fffd8ep-2, INEXACT)
T(RZ,    0x1.bcc1c39c933bp-11,    0x1.00379e4244d92p+0, -0x1.c8f8a2p-16, INEXACT)
T(RU,    0x1.bcc1c39c933bp-11,    0x1.00379e4244d93p+0,   0x1.fffc6ep-1, INEXACT)
T(RZ,  -0x1.d9f016701e50ep-11,    0x1.ff8991aef99e1p-1, -0x1.5f03f8p-15, INEXACT)
T(RU,  -0x1.d9f016701e50ep-11,    0x1.ff8991aef99e2p-1,   0x1.fffa84p-1, INEXACT)
T(RN,   0x1.16fc9d9e763c6p-11,    0x1.0022e1f3e2ab7p+0,  -0x1.fff77ap-2, INEXACT)
T(RN,  -0x1.21996313e07c8p-11,    0x1.ffb79ec56bfbfp-1,  -0x1.fffeb6p-2, INEXACT)
T(RN,   0x1.7f4537a5eec7ap-11,    0x1.002fed22dcb6cp+0,  -0x1.fff54ap-2, INEXACT)
T(RN,   0x1.ed6f177fffe79p-11,    0x1.003db551b2eeap+0,  -0x1.fff0e6p-2, INEXACT)
T(RN,  -0x1.8c6e3439182aap-11,    0x1.ff9cee09e7d48p-1,  -0x1.fff10ep-2, INEXACT)
T(RU,  -0x1.7d1db81c071b4p-10,    0x1.ff419495a3bf6p-1,  0x1.026a7cp-15, INEXACT)
T(RZ,  -0x1.7d1db81c071b4p-10,    0x1.ff419495a3bf5p-1,  -0x1.fffbf6p-1, INEXACT)
T(RZ,   0x1.7155a547106ddp-10,    0x1.005c66121289bp+0, -0x1.6a29b2p-16, INEXACT)
T(RU,   0x1.7155a547106ddp-10,    0x1.005c66121289cp+0,   0x1.fffd2cp-1, INEXACT)
T(RZ,   0x1.a475363b1f67ep-10,    0x1.006932e509b39p+0, -0x1.a13368p-16, INEXACT)
T(RU,   0x1.a475363b1f67ep-10,    0x1.006932e509b3ap+0,   0x1.fffcbep-1, INEXACT)
T(RU,   0x1.16c5ac5708a47p-10,    0x1.0045bae8818a9p+0,  0x1.70d638p-15, INEXACT)
T(RZ,   0x1.16c5ac5708a47p-10,    0x1.0045bae8818a8p+0,  -0x1.fffa3cp-1, INEXACT)
T(RN,  -0x1.0b247499983fdp-10,    0x1.ff7a7f308074cp-1,  -0x1.fffd14p-2, INEXACT)
T(RN,  -0x1.0c4f09a74fa26p-10,    0x1.ff79ea0cfcc28p-1,  -0x1.fff8b6p-2, INEXACT)
T(RN,   0x1.cc10f0c2413aap-10,    0x1.00731e1676a6fp+0,  -0x1.fffd96p-2, INEXACT)
T(RN,  -0x1.6403df41b5561p-10,    0x1.ff4e1cfe75b95p-1,  -0x1.fff754p-2, INEXACT)
T(RZ,    0x1.f600a411c878p-10,    0x1.007d9ef140134p+0, -0x1.3a829ep-19, INEXACT)
T(RU,    0x1.f600a411c878p-10,    0x1.007d9ef140135p+0,   0x1.ffffb2p-1, INEXACT)
T(RN,   0x1.9ab1737e56ed2p-10,    0x1.0066c0f6878d9p+0,  -0x1.fff7b4p-2, INEXACT)
T(RN,   0x1.7186ce30a9d22p-10,    0x1.005c7260bccf1p+0,  -0x1.fff45cp-2, INEXACT)
T(RN,  -0x1.1dcf8529bb9b7p-10,    0x1.ff712c2d0baebp-1,  -0x1.fff2cep-2, INEXACT)
T(RZ,    0x1.f40f2656a9e69p-9,     0x1.00fa81d45b04p+0,  -0x1.28affp-17, INEXACT)
T(RU,    0x1.f40f2656a9e69p-9,    0x1.00fa81d45b041p+0,   0x1.fffed8p-1, INEXACT)
T(RN,   -0x1.13f7d7440a8e2p-9,    0x1.feec527afb14fp-1,  -0x1.fff478p-2, INEXACT)
T(RZ,   -0x1.4d64d218b48bdp-9,    0x1.feb307a23840dp-1, -0x1.fa8f06p-18, INEXACT)
T(RU,   -0x1.4d64d218b48bdp-9,    0x1.feb307a23840ep-1,   0x1.ffff02p-1, INEXACT)
T(RN,    0x1.1b7c5007f9c1bp-9,    0x1.008de56cc5a9cp+0,  -0x1.fff512p-2, INEXACT)
T(RU,    0x1.c9b691d1e5a5fp-9,    0x1.00e541b3164a8p+0,  0x1.89ed0cp-18, INEXACT)
T(RZ,    0x1.c9b691d1e5a5fp-9,    0x1.00e541b3164a7p+0,  -0x1.ffff3cp-1, INEXACT)
T(RU,   -0x1.e97840089a4b9p-9,    0x1.fe17716ca1fb2p-1,  0x1.9cd7f6p-16, INEXACT)
T(RZ,   -0x1.e97840089a4b9p-9,    0x1.fe17716ca1fb1p-1,  -0x1.fffcc6p-1, INEXACT)
T(RN,   -0x1.effd8f0dcb151p-9,    0x1.fe10f261140c5p-1,  -0x1.fffc18p-2, INEXACT)
T(RN,    0x1.fb7a67d672e17p-9,    0x1.00fe3b1d43924p+0,  -0x1.fffdbcp-2, INEXACT)
T(RZ,    0x1.b9667036a9f0dp-8,    0x1.01bae3d456519p+0,  -0x1.11407p-15, INEXACT)
T(RU,    0x1.b9667036a9f0dp-8,    0x1.01bae3d45651ap+0,   0x1.fffbbap-1, INEXACT)
T(RZ,    0x1.b0cb58a218205p-8,    0x1.01b239fe99bccp+0, -0x1.838c1cp-18, INEXACT)
T(RU,    0x1.b0cb58a218205p-8,    0x1.01b239fe99bcdp+0,   0x1.ffff3ep-1, INEXACT)
T(RZ,    0x1.46fd904a34296p-8,    0x1.0147cebeb4237p+0, -0x1.6ece4ep-16, INEXACT)
T(RU,    0x1.46fd904a34296p-8,    0x1.0147cebeb4238p+0,   0x1.fffd22p-1, INEXACT)
T(RU,   -0x1.d589b8042f2a5p-8,    0x1.fc5847b44b248p-1,  0x1.d4894ap-15, INEXACT)
T(RZ,   -0x1.d589b8042f2a5p-8,    0x1.fc5847b44b247p-1,  -0x1.fff8aep-1, INEXACT)
T(RZ,   -0x1.67330bdb1daa4p-8,    0x1.fd3390fd18331p-1, -0x1.2714c8p-15, INEXACT)
T(RU,   -0x1.67330bdb1daa4p-8,    0x1.fd3390fd18332p-1,   0x1.fffb64p-1, INEXACT)
T(RN,    0x1.5c5807abfe2bap-8,    0x1.015d457309346p+0,  -0x1.fffa64p-2, INEXACT)
T(RN,   -0x1.c5bcfa97d7e16p-8,    0x1.fc77a866daf98p-1,  -0x1.fff152p-2, INEXACT)
T(RN,   -0x1.0b912fefc3aafp-8,    0x1.fde9f4e6f7e88p-1,  -0x1.fff26cp-2, INEXACT)
T(RN,    0x1.0aea8e912315dp-8,    0x1.010b75e51db7dp+0,  -0x1.fffd0ap-2, INEXACT)
T(RN,   -0x1.aeab81c0d4a59p-8,    0x1.fca57beb7a679p-1,  -0x1.fffccep-2, INEXACT)
T(RN,     0x1.19874d9c20afp-8,    0x1.011a225392b08p+0,  -0x1.fffb0cp-2, INEXACT)
T(RU,   -0x1.40ff7ba4e6d2fp-7,    0x1.fb0246d1adfd5p-1,  0x1.a3961cp-18, INEXACT)
T(RZ,   -0x1.40ff7ba4e6d2fp-7,    0x1.fb0246d1adfd4p-1,  -0x1.ffff2ep-1, INEXACT)
T(RU,    0x1.2dd8453716282p-7,    0x1.025e7a87ced28p+0,  0x1.960514p-15, INEXACT)
T(RZ,    0x1.2dd8453716282p-7,    0x1.025e7a87ced27p+0,  -0x1.fff9a8p-1, INEXACT)
T(RN,    0x1.b155f5fb0f2d1p-7,     0x1.03686d70c423p+0,  -0x1.fffa36p-2, INEXACT)
T(RN,   -0x1.5f4a9ecfa1385p-7,     0x1.fa8a56dc5553p-1,  -0x1.fff282p-2, INEXACT)
T(RU,    0x1.b753079ec506ap-7,    0x1.037490ade1cbap+0,  0x1.fa82b2p-15, INEXACT)
T(RZ,    0x1.b753079ec506ap-7,    0x1.037490ade1cb9p+0,  -0x1.fff816p-1, INEXACT)
T(RN,    0x1.a98fbe459b378p-7,    0x1.0358ac7ed295ep+0,   -0x1.fff5bp-2, INEXACT)
T(RZ,    0x1.08d9f3ff5557dp-6,    0x1.042c03be1772dp+0, -0x1.f22434p-16, INEXACT)
T(RU,    0x1.08d9f3ff5557dp-6,    0x1.042c03be1772ep+0,   0x1.fffc1cp-1, INEXACT)
T(RN,    0x1.d99894edba10cp-6,    0x1.078207840ab79p+0,  -0x1.fff81cp-2, INEXACT)
T(RN,    0x1.9f48ab92fa0d7p-6,    0x1.06925de6fdebbp+0,  -0x1.fffef4p-2, INEXACT)
T(RN,    0x1.dc07e38abf249p-6,    0x1.078c0e0e4a87ep+0,  -0x1.fff038p-2, INEXACT)
T(RN,   -0x1.4614f4202250fp-6,    0x1.f5e9221669cd4p-1,  -0x1.fff57cp-2, INEXACT)
T(RZ,   -0x1.8ad7fbe26984dp-6,    0x1.f3cf022baad4dp-1, -0x1.5a6e92p-15, INEXACT)
T(RU,   -0x1.8ad7fbe26984dp-6,    0x1.f3cf022baad4ep-1,   0x1.fffa96p-1, INEXACT)
T(RU,   -0x1.d1e5c0b827174p-6,    0x1.f1a55092f856fp-1,  0x1.97d15ap-17, INEXACT)
T(RZ,   -0x1.d1e5c0b827174p-6,    0x1.f1a55092f856ep-1,  -0x1.fffe68p-1, INEXACT)
T(RN,    0x1.b8fb820d7a84bp-6,    0x1.06fbe1f87e41ep+0,  -0x1.fff21cp-2, INEXACT)
T(RN,    0x1.cab20821c2dc3p-6,    0x1.0744b4f728b39p+0,  -0x1.fff992p-2, INEXACT)
T(RN,    0x1.0a401ed5b58b5p-5,    0x1.0874fee99dcf2p+0,  -0x1.fff398p-2, INEXACT)
T(RZ,   -0x1.77601590a2552p-5,    0x1.e911855d77052p-1, -0x1.77b1d8p-15, INEXACT)
T(RU,   -0x1.77601590a2552p-5,    0x1.e911855d77053p-1,   0x1.fffa22p-1, INEXACT)
T(RZ,   -0x1.c0f13b4090fb8p-5,    0x1.e4b2339e9bda1p-1, -0x1.86abf8p-15, INEXACT)
T(RU,   -0x1.c0f13b4090fb8p-5,    0x1.e4b2339e9bda2p-1,   0x1.fff9e6p-1, INEXACT)
T(RN,   -0x1.a7ac2cc1b9ae4p-5,    0x1.e6318c1b054eap-1,  -0x1.fff84cp-2, INEXACT)
T(RU,   -0x1.3842ee4dd2a48p-5,    0x1.ecd9d71b9b067p-1,   0x1.baa45p-23, INEXACT)
T(RZ,   -0x1.3842ee4dd2a48p-5,    0x1.ecd9d71b9b066p-1,  -0x1.fffffap-1, INEXACT)
T(RU,   -0x1.462fe226d5a37p-5,    0x1.ec038bce1482ep-1,  0x1.988158p-15, INEXACT)
T(RZ,   -0x1.462fe226d5a37p-5,    0x1.ec038bce1482dp-1,  -0x1.fff99ep-1, INEXACT)
T(RZ,   -0x1.7e88397f3ca6bp-4,    0x1.d25930af5c43fp-1, -0x1.f3d66ep-20, INEXACT)
T(RU,   -0x1.7e88397f3ca6bp-4,     0x1.d25930af5c44p-1,   0x1.ffffc2p-1, INEXACT)
T(RZ,   -0x1.8d511914c8b3cp-4,    0x1.d0ab0ab086256p-1, -0x1.4d8e68p-15, INEXACT)
T(RU,   -0x1.8d511914c8b3cp-4,    0x1.d0ab0ab086257p-1,   0x1.fffacap-1, INEXACT)
T(RZ,    0x1.23158aa1f4138p-4,    0x1.12dad34dadf22p+0, -0x1.0ead88p-16, INEXACT)
T(RU,    0x1.23158aa1f4138p-4,    0x1.12dad34dadf23p+0,   0x1.fffde2p-1, INEXACT)
T(RZ,     0x1.98dcd6b2812bp-4,    0x1.1adf71b176828p+0,  -0x1.4dc8fp-15, INEXACT)
T(RU,     0x1.98dcd6b2812bp-4,    0x1.1adf71b176829p+0,   0x1.fffac8p-1, INEXACT)
T(RZ,    0x1.6f8d699aaab0ep-4,    0x1.1808c4934ba5ep+0,  -0x1.978cap-15, INEXACT)
T(RU,    0x1.6f8d699aaab0ep-4,    0x1.1808c4934ba5fp+0,   0x1.fff9a2p-1, INEXACT)
T(RU,   -0x1.57f825708cee1p-4,    0x1.d6c27ab0162a1p-1,   0x1.be283p-15, INEXACT)
T(RZ,   -0x1.57f825708cee1p-4,     0x1.d6c27ab0162ap-1,  -0x1.fff908p-1, INEXACT)
T(RU,    0x1.f98abbc60b45ep-4,    0x1.21a105a1eb104p+0,  0x1.cf8674p-16, INEXACT)
T(RZ,    0x1.f98abbc60b45ep-4,    0x1.21a105a1eb103p+0,   -0x1.fffc6p-1, INEXACT)
T(RZ,    0x1.a12a79c5466efp-4,     0x1.1b72641e85c5p+0, -0x1.f72b28p-18, INEXACT)
T(RU,    0x1.a12a79c5466efp-4,    0x1.1b72641e85c51p+0,   0x1.ffff04p-1, INEXACT)
T(RN,   -0x1.77a118c29f36cp-4,    0x1.d3228e304a64fp-1,  -0x1.fffb44p-2, INEXACT)
T(RN,    0x1.88ee16ea8df2dp-4,    0x1.19c64f4d693dfp+0,  -0x1.fff442p-2, INEXACT)
T(RN,   -0x1.2b6ebf8e6959dp-4,    0x1.dbe8027970bf4p-1,  -0x1.fff816p-2, INEXACT)
T(RN,    0x1.8deaa2a2fbfa6p-4,    0x1.1a1e2e21d7541p+0,  -0x1.fff0eap-2, INEXACT)
T(RN,   -0x1.1349be612111ep-4,    0x1.deb84a16a2141p-1,  -0x1.fffcdep-2, INEXACT)
T(RN,   -0x1.2335b60cc1643p-4,    0x1.dcdcd5e3d1ba3p-1,  -0x1.fff4dap-2, INEXACT)
T(RN,   -0x1.92ebdb1401737p-4,    0x1.d008634b560c3p-1,  -0x1.fffd4ep-2, INEXACT)
T(RZ,   -0x1.f99ff7589d7c3p-3,    0x1.8ffd3a86d8024p-1, -0x1.bf7d1ap-15, INEXACT)
T(RU,   -0x1.f99ff7589d7c3p-3,    0x1.8ffd3a86d8025p-1,   0x1.fff902p-1, INEXACT)
T(RN,   -0x1.9cb804a46311dp-3,    0x1.a28d6117c9e51p-1,  -0x1.fff328p-2, INEXACT)
T(RU,   -0x1.7bc7a0dfa6c9ap-3,    0x1.a956a67b32984p-1,  0x1.0a3e78p-15, INEXACT)
T(RZ,   -0x1.7bc7a0dfa6c9ap-3,    0x1.a956a67b32983p-1,  -0x1.fffbd8p-1, INEXACT)
T(RN,    0x1.ced9550c7f9f9p-3,    0x1.40ea5f816b1f6p+0,  -0x1.fff642p-2, INEXACT)
T(RN,    0x1.b3791608a2e59p-3,    0x1.3ca782429e36cp+0,  -0x1.fffd4cp-2, INEXACT)
T(RN,    0x1.b3d98cec572bcp-2,    0x1.87d2deb574bcap+0,  -0x1.fffb84p-2, INEXACT)
T(RU,   -0x1.9829cd27d6b95p-2,    0x1.57af8c070ebf9p-1,  0x1.c72c0ep-22, INEXACT)
T(RZ,   -0x1.9829cd27d6b95p-2,    0x1.57af8c070ebf8p-1,  -0x1.fffff2p-1, INEXACT)
T(RN,   -0x1.3da303688cda7p-2,    0x1.7773e35d68cc7p-1,  -0x1.fffa04p-2, INEXACT)
T(RZ,   -0x1.1ddc636b427e4p-2,    0x1.83493b582b73bp-1, -0x1.f12464p-16, INEXACT)
T(RU,   -0x1.1ddc636b427e4p-2,    0x1.83493b582b73cp-1,   0x1.fffc1ep-1, INEXACT)
T(RZ,    0x1.5c18cdcc1608ep-2,    0x1.67a4f8899f8e3p+0, -0x1.b8160cp-15, INEXACT)
T(RU,    0x1.5c18cdcc1608ep-2,    0x1.67a4f8899f8e4p+0,    0x1.fff92p-1, INEXACT)
T(RZ,   -0x1.4b83b66a24aa6p-2,    0x1.72661139fe548p-1, -0x1.7a7fb8p-15, INEXACT)
T(RU,   -0x1.4b83b66a24aa6p-2,    0x1.72661139fe549p-1,   0x1.fffa16p-1, INEXACT)
T(RN,    0x1.e2bbb36e164bfp-2,    0x1.9a2e220622845p+0,  -0x1.fff49ap-2, INEXACT)
T(RZ,   -0x1.d46fbd58a9d5dp-1,    0x1.9a29f4617f459p-2, -0x1.605736p-15, INEXACT)
T(RU,   -0x1.d46fbd58a9d5dp-1,    0x1.9a29f4617f45ap-2,   0x1.fffa7ep-1, INEXACT)
T(RZ,    0x1.5fe6f6ed03674p-1,    0x1.fd0501b858ad2p+0, -0x1.c4a632p-16, INEXACT)
T(RU,    0x1.5fe6f6ed03674p-1,    0x1.fd0501b858ad3p+0,   0x1.fffc76p-1, INEXACT)
T(RU,   -0x1.68e8ad5970e79p-1,    0x1.fa0487060701ap-2,  0x1.9dd6c2p-15, INEXACT)
T(RZ,   -0x1.68e8ad5970e79p-1,    0x1.fa04870607019p-2,  -0x1.fff988p-1, INEXACT)
T(RN,    0x1.a1ff5c6c952b5p-1,    0x1.21947bab83a8ep+1,  -0x1.fff7d6p-2, INEXACT)
T(RN,    0x1.5b42711242fc2p-1,      0x1.f86cbe57345p+0,  -0x1.fffebep-2, INEXACT)
T(RN,    0x1.e4561c772db83p-1,    0x1.49a3b895f207cp+1,   -0x1.ffffep-2, INEXACT)
T(RN,    0x1.330c3a4c6fe1ap-1,    0x1.d252e07e40d72p+0,  -0x1.fffceep-2, INEXACT)
T(RN,    0x1.1bdc79d0faeadp-1,    0x1.bdad3f950fae8p+0,  -0x1.fffe72p-2, INEXACT)
T(RU,    0x1.aa8db66c5d6a7p+0,    0x1.52b29bf38fb95p+2,  0x1.ab692cp-19, INEXACT)
T(RZ,    0x1.aa8db66c5d6a7p+0,    0x1.52b29bf38fb94p+2,  -0x1.ffff96p-1, INEXACT)
T(RZ,    0x1.afeee36357e7ap+0,    0x1.59e3f1a1dbd7fp+2, -0x1.98bc2cp-18, INEXACT)
T(RU,    0x1.afeee36357e7ap+0,     0x1.59e3f1a1dbd8p+2,   0x1.ffff34p-1, INEXACT)
T(RN,   -0x1.6d1c9aa0d28f5p+0,    0x1.ebf63f0c1e5d7p-3,  -0x1.fff0aap-2, INEXACT)
T(RZ,    0x1.3daeb62271fe4p+0,    0x1.babcd71e90e1ap+1, -0x1.58b71ep-16, INEXACT)
T(RU,    0x1.3daeb62271fe4p+0,    0x1.babcd71e90e1bp+1,   0x1.fffd4ep-1, INEXACT)
T(RN,   -0x1.be20d2542b186p+0,    0x1.66802f2f2e77ep-3,  -0x1.fffc3ep-2, INEXACT)
T(RU,    0x1.3e627bb999565p+0,    0x1.bbf42c254af11p+1,  0x1.ad59dcp-18, INEXACT)
T(RZ,    0x1.3e627bb999565p+0,     0x1.bbf42c254af1p+1,  -0x1.ffff2ap-1, INEXACT)
T(RU,    0x1.79aa6faa1c1cep+0,    0x1.17d1734b083e5p+2,  0x1.808836p-15, INEXACT)
T(RZ,    0x1.79aa6faa1c1cep+0,    0x1.17d1734b083e4p+2,  -0x1.fff9fep-1, INEXACT)
T(RN,     0x1.a72d05216104p+1,    0x1.b4708d6ad382ap+4,  -0x1.fff3e6p-2, INEXACT)
T(RU,    0x1.6f2a318ca9834p+1,    0x1.19c327316f83cp+4,  0x1.db0da4p-17, INEXACT)
T(RZ,    0x1.6f2a318ca9834p+1,    0x1.19c327316f83bp+4,  -0x1.fffe24p-1, INEXACT)
T(RN,    0x1.305a0fb05029bp+1,    0x1.58fab20b713f4p+3,  -0x1.fff26ep-2, INEXACT)
T(RZ,   -0x1.5c9e06d439a62p+1,    0x1.0cdc59e543e4dp-4, -0x1.4ecb36p-15, INEXACT)
T(RU,   -0x1.5c9e06d439a62p+1,    0x1.0cdc59e543e4ep-4,   0x1.fffac4p-1, INEXACT)
T(RN,   -0x1.0e085f1af2435p+2,    0x1.e20053567330ep-7,  -0x1.fff166p-2, INEXACT)
T(RN,    0x1.95622738140a8p+2,    0x1.19bc4864f79f8p+9,  -0x1.fff9d2p-2, INEXACT)
T(RZ,   -0x1.002a6aa283907p+2,    0x1.2b4ebb59f32cdp-6, -0x1.f41e32p-15, INEXACT)
T(RU,   -0x1.002a6aa283907p+2,    0x1.2b4ebb59f32cep-6,    0x1.fff83p-1, INEXACT)
T(RZ,    0x1.fe98e37bf8fabp+2,   0x1.6c8a971e7cc17p+11, -0x1.a50052p-15, INEXACT)
T(RU,    0x1.fe98e37bf8fabp+2,   0x1.6c8a971e7cc18p+11,   0x1.fff96cp-1, INEXACT)
T(RN,    0x1.71fb9b7f62038p+2,    0x1.4413c6534ceaep+8,  -0x1.ffff06p-2, INEXACT)
T(RU,   -0x1.5b6ce57f113b1p+2,    0x1.1facf29a94124p-8,  0x1.f80bd8p-17, INEXACT)
T(RZ,   -0x1.5b6ce57f113b1p+2,    0x1.1facf29a94123p-8,  -0x1.fffe08p-1, INEXACT)
T(RU,    -0x1.067a742191cdp+2,    0x1.0f31cfa53f04fp-6,  0x1.5063f6p-16, INEXACT)
T(RZ,    -0x1.067a742191cdp+2,    0x1.0f31cfa53f04ep-6,   -0x1.fffd6p-1, INEXACT)
T(RN,   -0x1.953ba1872a993p+2,   0x1.d2536bb26a362p-10,  -0x1.fff22ap-2, INEXACT)
T(RN,    0x1.c0ae8cd7c1678p+2,   0x1.15183e7395dc7p+10,   -0x1.fffe3p-2, INEXACT)
T(RN,   -0x1.dfbabc03b5df3p+2,   0x1.2334399743a74p-11,  -0x1.fffd22p-2, INEXACT)
T(RN,    0x1.eb26adeb5e2adp+2,   0x1.0d05b52c115d2p+11,  -0x1.fff248p-2, INEXACT)
T(RN,    0x1.55beea261138ap+2,    0x1.a0eec1d05b75bp+7,  -0x1.fff0ccp-2, INEXACT)
T(RN,    0x1.d92076ef05801p+2,   0x1.95fbbc0d9f452p+10,  -0x1.fff1d2p-2, INEXACT)
T(RN,    0x1.f00dfa6ac0a68p+2,    0x1.2271b9d5f892p+11,  -0x1.fff918p-2, INEXACT)
T(RZ,    0x1.31b59cbcd1466p+3,   0x1.b8666aeffb63fp+13, -0x1.0ad038p-19, INEXACT)
T(RU,    0x1.31b59cbcd1466p+3,    0x1.b8666aeffb64p+13,   0x1.ffffbep-1, INEXACT)
T(RZ,    0x1.018e70f6398cbp+3,   0x1.8730eeff8d5d4p+11, -0x1.adf7cep-15, INEXACT)
T(RU,    0x1.018e70f6398cbp+3,   0x1.8730eeff8d5d5p+11,   0x1.fff948p-1, INEXACT)
T(RN,   -0x1.db8d4cc08c648p+3,   0x1.797126a9e7bd3p-22,  -0x1.fff61ap-2, INEXACT)
T(RU,    0x1.e22a2114a9798p+3,   0x1.aafa0730f9911p+21,  0x1.cff0dcp-15, INEXACT)
T(RZ,    0x1.e22a2114a9798p+3,    0x1.aafa0730f991p+21,   -0x1.fff8cp-1, INEXACT)
T(RN,   -0x1.920b7049865d2p+3,    0x1.d53904cf0a61p-19,  -0x1.fff52cp-2, INEXACT)
T(RN,   -0x1.66ff995b1a74dp+3,   0x1.c2543a483c9acp-17,  -0x1.fff542p-2, INEXACT)
T(RN,    0x1.05d3b631a52a5p+3,   0x1.bf0ab569bb535p+11,  -0x1.fffc14p-2, INEXACT)
T(RZ,   -0x1.3563820983bd5p+3,   0x1.094b6c9cf263bp-14, -0x1.9dc74ep-16, INEXACT)
T(RU,   -0x1.3563820983bd5p+3,   0x1.094b6c9cf263cp-14,   0x1.fffcc4p-1, INEXACT)
T(RZ,    0x1.71ad01c9f6ac3p+3,   0x1.96572d868f6f3p+16,  -0x1.bf2a8p-16, INEXACT)
T(RU,    0x1.71ad01c9f6ac3p+3,   0x1.96572d868f6f4p+16,   0x1.fffc82p-1, INEXACT)
T(RN,    0x1.848129c928cd1p+3,   0x1.6dee1bf6602a2p+17,  -0x1.fff7eep-2, INEXACT)
T(RN,    0x1.276a3d8f4ff06p+3,   0x1.3f40aff2198a5p+13,  -0x1.fff7a2p-2, INEXACT)
T(RN,   -0x1.1baab98c40df2p+3,   0x1.285680b738b73p-13,  -0x1.fff7bep-2, INEXACT)
T(RN,    0x1.4965312454f79p+3,   0x1.cd9c0ce413391p+14,  -0x1.fff28ap-2, INEXACT)
T(RZ,   -0x1.dfee97697c8f1p+4,   0x1.a7398dacc0cffp-44, -0x1.1e2b5ep-15, INEXACT)
T(RU,   -0x1.dfee97697c8f1p+4,     0x1.a7398dacc0dp-44,   0x1.fffb88p-1, INEXACT)
T(RN,    0x1.2f6001708edb6p+4,   0x1.47630761c3d2cp+27,  -0x1.fff262p-2, INEXACT)
T(RZ,    0x1.1f5977f29f814p+4,   0x1.e0fcbec566f0dp+25, -0x1.89b52cp-15, INEXACT)
T(RU,    0x1.1f5977f29f814p+4,   0x1.e0fcbec566f0ep+25,   0x1.fff9dap-1, INEXACT)
T(RN,    0x1.83fcaba8da51cp+4,   0x1.fa6ac0d58f15cp+34,  -0x1.fff26ep-2, INEXACT)
T(RN,   -0x1.87d31307e75bbp+4,   0x1.9741c26ac50b1p-36,  -0x1.fff68ap-2, INEXACT)
T(RN,   -0x1.6581edf9487aap+4,   0x1.b2c4b13a682d6p-33,  -0x1.fff9b8p-2, INEXACT)
T(RN,    0x1.34b9bd8b14585p+4,   0x1.c965789194d7dp+27,  -0x1.fffbf2p-2, INEXACT)
T(RN,   -0x1.8f0168a73d22ap+4,   0x1.03fcb2522d217p-36,  -0x1.fff8aap-2, INEXACT)
T(RZ,   -0x1.8ca6de8038e3fp+5,   0x1.625a87865d001p-72, -0x1.c074acp-17, INEXACT)
T(RU,   -0x1.8ca6de8038e3fp+5,   0x1.625a87865d002p-72,    0x1.fffe4p-1, INEXACT)
T(RZ,    0x1.059cb0f41af4bp+5,   0x1.21ad85b69e4bcp+47, -0x1.74a58ep-16, INEXACT)
T(RU,    0x1.059cb0f41af4bp+5,   0x1.21ad85b69e4bdp+47,   0x1.fffd16p-1, INEXACT)
T(RN,   -0x1.9f5ec859f4adap+5,   0x1.11206897219b8p-75,  -0x1.fffd6ap-2, INEXACT)
T(RZ,   -0x1.e168268a06d3cp+5,   0x1.22f168e735927p-87, -0x1.65df4ap-17, INEXACT)
T(RU,   -0x1.e168268a06d3cp+5,   0x1.22f168e735928p-87,   0x1.fffe9ap-1, INEXACT)
T(RN,   -0x1.2730ccf8f93d5p+5,   0x1.b369ebddcd104p-54,  -0x1.fff418p-2, INEXACT)
T(RN,    0x1.7f3ee6d0e5af1p+5,   0x1.14ec046a15221p+69,  -0x1.fff2d8p-2, INEXACT)
T(RZ,   -0x1.9d028c9b65e14p+5,   0x1.6edb4efa8ead5p-75, -0x1.78f50ap-15, INEXACT)
T(RU,   -0x1.9d028c9b65e14p+5,   0x1.6edb4efa8ead6p-75,   0x1.fffa1cp-1, INEXACT)
T(RZ,   -0x1.822e2d9aef0b4p+5,   0x1.47f9294c0786bp-70, -0x1.397fb4p-17, INEXACT)
T(RU,   -0x1.822e2d9aef0b4p+5,   0x1.47f9294c0786cp-70,   0x1.fffec6p-1, INEXACT)
T(RN,   -0x1.2940e371ce4ccp+5,   0x1.50727f08b86f4p-54,  -0x1.fffe32p-2, INEXACT)
T(RU,    0x1.f8a1ee2b8d10fp+5,   0x1.00af7c6445976p+91,  0x1.6da3b4p-15, INEXACT)
T(RZ,    0x1.f8a1ee2b8d10fp+5,   0x1.00af7c6445975p+91,  -0x1.fffa4ap-1, INEXACT)
T(RN,   -0x1.8758b4207e788p+5,   0x1.57e33bc5cb869p-71,  -0x1.fff39ap-2, INEXACT)
T(RN,   -0x1.5ad8bb2168301p+5,   0x1.5de45132788dbp-63,  -0x1.fff346p-2, INEXACT)
T(RZ,    -0x1.d910360388a7p+6,  0x1.4cca76709855fp-171, -0x1.28064ap-15, INEXACT)
T(RU,    -0x1.d910360388a7p+6,   0x1.4cca76709856p-171,    0x1.fffb6p-1, INEXACT)
T(RN,   -0x1.163bcee84c175p+6,  0x1.91454b15455abp-101,  -0x1.fff604p-2, INEXACT)
T(RU,   -0x1.58e7e895e7787p+6,  0x1.846cf8e6dcc99p-125,  0x1.e8d984p-15, INEXACT)
T(RZ,   -0x1.58e7e895e7787p+6,  0x1.846cf8e6dcc98p-125,  -0x1.fff85cp-1, INEXACT)
T(RN,    0x1.d5fb503f38684p+6,  0x1.6c92ba6374f88p+169,   -0x1.fffe1p-2, INEXACT)
T(RN,    0x1.a793d96634aabp+6,  0x1.b58cb08800918p+152,  -0x1.fff87ep-2, INEXACT)
T(RN,   -0x1.2dae6fef14332p+7,  0x1.4dcec535410e4p-218,  -0x1.fff1fap-2, INEXACT)
T(RZ,   -0x1.f7b49dfc0e228p+7,  0x1.929db47ba46e8p-364, -0x1.226606p-18, INEXACT)
T(RU,   -0x1.f7b49dfc0e228p+7,  0x1.929db47ba46e9p-364,   0x1.ffff6ep-1, INEXACT)
T(RU,   -0x1.9147eb5139c9cp+7,  0x1.737123e0496acp-290,  0x1.456f92p-15, INEXACT)
T(RZ,   -0x1.9147eb5139c9cp+7,  0x1.737123e0496abp-290,  -0x1.fffaeap-1, INEXACT)
T(RN,     0x1.3859e464914dp+7,  0x1.3e2f5110cfbf7p+225,  -0x1.fff696p-2, INEXACT)
T(RU,    0x1.c0616ad66ff9ap+8,  0x1.d5f447269768ap+646,  0x1.fe1ae6p-16, INEXACT)
T(RZ,    0x1.c0616ad66ff9ap+8,  0x1.d5f4472697689p+646,  -0x1.fffc04p-1, INEXACT)
T(RZ,     0x1.ac0029f570f9p+8,  0x1.63abe10df6b58p+617, -0x1.9a873cp-16, INEXACT)
T(RU,     0x1.ac0029f570f9p+8,  0x1.63abe10df6b59p+617,   0x1.fffccap-1, INEXACT)
T(RN,   -0x1.b36f190a10e97p+8,  0x1.be34726116d9ap-629,  -0x1.fff9d2p-2, INEXACT)
T(RU,    0x1.7d2713bd740bap+8,  0x1.d9700b6cc3bdep+549,  0x1.c1b8a2p-17, INEXACT)
T(RZ,    0x1.7d2713bd740bap+8,  0x1.d9700b6cc3bddp+549,  -0x1.fffe3ep-1, INEXACT)
T(RZ,     0x1.bd1b27b77c3ep+8,  0x1.1c821da8cf36ep+642, -0x1.000a6ap-15, INEXACT)
T(RU,     0x1.bd1b27b77c3ep+8,  0x1.1c821da8cf36fp+642,     0x1.fffcp-1, INEXACT)
T(RU,  -0x1.11c32b6416a07p-15,    0x1.fffbb8f7e573cp-1,  0x1.d6dcd2p-19, INEXACT)
T(RZ,  -0x1.11c32b6416a07p-15,    0x1.fffbb8f7e573bp-1,  -0x1.ffff8ap-1, INEXACT)
T(RN,  -0x1.4cca814ade9edp-15,    0x1.fffaccdcbd462p-1,   -0x1.fffd4p-2, INEXACT)
T(RN,   0x1.02a766b8ab74ap-15,    0x1.00020550d81e6p+0,  -0x1.fffdb2p-2, INEXACT)
T(RU,   0x1.3ebcefa28fcecp-15,    0x1.00027d7cf8fb9p+0,  0x1.3e5d4ap-18, INEXACT)
T(RZ,   0x1.3ebcefa28fcecp-15,    0x1.00027d7cf8fb8p+0,   -0x1.ffff6p-1, INEXACT)
T(RN,  -0x1.30f563f38a1aap-15,    0x1.fffb3c301d4c3p-1,  -0x1.fffd36p-2, INEXACT)
T(RN,  -0x1.d622b250afcd2p-14,    0x1.fff14f20632d1p-1,  -0x1.fffc4cp-2, INEXACT)
T(RN,   0x1.7c8d3640d58c5p-14,    0x1.0005f24686c29p+0,  -0x1.fffcf2p-2, INEXACT)
T(RU,  -0x1.8f1ed96a05e94p-14,    0x1.fff387301871dp-1,  0x1.5b152ep-17, INEXACT)
T(RZ,  -0x1.8f1ed96a05e94p-14,    0x1.fff387301871cp-1,  -0x1.fffea4p-1, INEXACT)
T(RU,  -0x1.6125a5d443b09p-14,    0x1.fff4f6f143b37p-1,  0x1.048282p-17, INEXACT)
T(RZ,  -0x1.6125a5d443b09p-14,    0x1.fff4f6f143b36p-1,  -0x1.fffefcp-1, INEXACT)
T(RU,   0x1.006871e56d3e9p-14,    0x1.000401a9ce28ep+0,  0x1.73d056p-17, INEXACT)
T(RZ,   0x1.006871e56d3e9p-14,    0x1.000401a9ce28dp+0,  -0x1.fffe8cp-1, INEXACT)
T(RN,   0x1.03bc1312937a9p-14,    0x1.00040ef888863p+0,  -0x1.fffcbcp-2, INEXACT)
T(RU,   0x1.0fa308203b8b4p-13,    0x1.00087d3c48ba3p+0,   0x1.12745p-17, INEXACT)
T(RZ,   0x1.0fa308203b8b4p-13,    0x1.00087d3c48ba2p+0,  -0x1.fffeeep-1, INEXACT)
T(RU,  -0x1.ff525a15cb371p-13,     0x1.ffe00bd9abcbp-1,  0x1.3fec76p-17, INEXACT)
T(RZ,  -0x1.ff525a15cb371p-13,    0x1.ffe00bd9abcafp-1,   -0x1.fffecp-1, INEXACT)
T(RU,   0x1.f1faabc275fcfp-13,    0x1.000f904e76706p+0,  0x1.085706p-18, INEXACT)
T(RZ,   0x1.f1faabc275fcfp-13,    0x1.000f904e76705p+0,  -0x1.ffff7cp-1, INEXACT)
T(RN,  -0x1.63e7b0f1a6fe5p-13,    0x1.ffe9c200a2349p-1,  -0x1.ffff44p-2, INEXACT)
T(RN,  -0x1.80a3a54e7af01p-13,    0x1.ffe7f65623ab9p-1,  -0x1.fffdb8p-2, INEXACT)
T(RN,   0x1.b45f7c19a86fcp-13,    0x1.000da358dd203p+0,  -0x1.fffc8ep-2, INEXACT)
T(RN,   0x1.fa05d6b491047p-13,    0x1.000fd0abbf9a3p+0,  -0x1.ffff38p-2, INEXACT)
T(RN,  -0x1.9ce69e6f83899p-13,    0x1.ffe6323c94032p-1,  -0x1.fffe42p-2, INEXACT)
T(RN,   -0x1.0a361c70471bp-13,    0x1.ffef5ce36d5b4p-1,  -0x1.fffffcp-2, INEXACT)
T(RZ,   0x1.55c879eedcf91p-12,    0x1.00155d6bcd1f7p+0, -0x1.2da0fcp-19, INEXACT)
T(RU,   0x1.55c879eedcf91p-12,    0x1.00155d6bcd1f8p+0,   0x1.ffffb4p-1, INEXACT)
T(RU,  -0x1.6df3e5b24e554p-12,    0x1.ffd2438e5b879p-1,  0x1.64c106p-18, INEXACT)
T(RZ,  -0x1.6df3e5b24e554p-12,    0x1.ffd2438e5b878p-1,  -0x1.ffff4ep-1, INEXACT)
T(RU,   0x1.30b11866d5208p-12,    0x1.00130bc6dd76ap+0,  0x1.72981ap-19, INEXACT)
T(RZ,   0x1.30b11866d5208p-12,    0x1.00130bc6dd769p+0,  -0x1.ffffa4p-1, INEXACT)
T(RZ,   0x1.81a5b7487aaadp-12,    0x1.00181b7df793fp+0, -0x1.d2f2d2p-17, INEXACT)
T(RU,   0x1.81a5b7487aaadp-12,     0x1.00181b7df794p+0,   0x1.fffe2ep-1, INEXACT)
T(RZ,  -0x1.8897f18dbc7acp-12,    0x1.ffceef5bccba8p-1, -0x1.6e2d82p-17, INEXACT)
T(RU,  -0x1.8897f18dbc7acp-12,    0x1.ffceef5bccba9p-1,   0x1.fffe92p-1, INEXACT)
T(RN,   0x1.ee1dd00ac01e7p-12,    0x1.001ee3b9ef629p+0,  -0x1.fffc8cp-2, INEXACT)
T(RU,  -0x1.66f89ad3dbb23p-11,    0x1.ffa649b64674cp-1,  0x1.98d55ep-18, INEXACT)
T(RZ,  -0x1.66f89ad3dbb23p-11,    0x1.ffa649b64674bp-1,  -0x1.ffff34p-1, INEXACT)
T(RU,   0x1.9ced268ca9a85p-11,    0x1.0033a2d943805p+0,  0x1.592a0cp-18, INEXACT)
T(RZ,   0x1.9ced268ca9a85p-11,    0x1.0033a2d943804p+0,  -0x1.ffff54p-1, INEXACT)
T(RZ,   0x1.6b1a8a9c51488p-11,    0x1.002d675798fc4p+0, -0x1.d8520cp-18, INEXACT)
T(RU,   0x1.6b1a8a9c51488p-11,    0x1.002d675798fc5p+0,   0x1.ffff14p-1, INEXACT)
T(RN,   0x1.5e547134249aap-11,    0x1.002bce4d3335ep+0,  -0x1.ffffb6p-2, INEXACT)
T(RN,  -0x1.5ee3e5056f58bp-11,    0x1.ffa84e8a208e5p-1,  -0x1.fffc56p-2, INEXACT)
T(RN,   0x1.b3b1f9e09bd97p-11,    0x1.00367c0ab1ea2p+0,  -0x1.fffda2p-2, INEXACT)
T(RU,  -0x1.04ca5b86dc3ebp-10,    0x1.ff7dab6b8e6bap-1,    0x1.6fa8p-17, INEXACT)
T(RZ,  -0x1.04ca5b86dc3ebp-10,    0x1.ff7dab6b8e6b9p-1,   -0x1.fffe9p-1, INEXACT)
T(RZ,  -0x1.4f8620f7b380ap-10,    0x1.ff58586888f4bp-1, -0x1.781efcp-17, INEXACT)
T(RU,  -0x1.4f8620f7b380ap-10,    0x1.ff58586888f4cp-1,   0x1.fffe88p-1, INEXACT)
T(RZ,   0x1.cfd32985b8088p-10,    0x1.00740f1144e2dp+0,  -0x1.2d65ep-22, INEXACT)
T(RU,   0x1.cfd32985b8088p-10,    0x1.00740f1144e2ep+0,   0x1.fffff6p-1, INEXACT)
T(RU,  -0x1.ba95fb7d0d85cp-10,    0x1.ff22e4ce026d7p-1,   0x1.a1144p-19, INEXACT)
T(RZ,  -0x1.ba95fb7d0d85cp-10,    0x1.ff22e4ce026d6p-1,  -0x1.ffff98p-1, INEXACT)
T(RZ,   0x1.231ff242d129dp-10,    0x1.0048d25618eb1p+0, -0x1.487106p-18, INEXACT)
T(RU,   0x1.231ff242d129dp-10,    0x1.0048d25618eb2p+0,   0x1.ffff5cp-1, INEXACT)
T(RU,   0x1.00917f77b9128p-10,    0x1.00402c69a4546p+0,  0x1.2893e2p-19, INEXACT)
T(RZ,   0x1.00917f77b9128p-10,    0x1.00402c69a4545p+0,  -0x1.ffffb6p-1, INEXACT)
T(RN,   -0x1.fddecd497c75p-10,    0x1.ff015006cfb98p-1,  -0x1.ffff68p-2, INEXACT)
T(RU,    0x1.aa83a2a25f281p-9,    0x1.00d59abd4c28bp+0,  0x1.7051bep-18, INEXACT)
T(RZ,    0x1.aa83a2a25f281p-9,    0x1.00d59abd4c28ap+0,  -0x1.ffff48p-1, INEXACT)
T(RN,   -0x1.918afde838905p-9,    0x1.fe6f124e24e5bp-1,  -0x1.fffc2cp-2, INEXACT)
T(RN,    0x1.64c2b5da65f7ap-9,    0x1.00b29f8f22bf2p+0,  -0x1.fffd66p-2, INEXACT)
T(RN,   -0x1.dfd900d96d0a2p-9,     0x1.fe2107946a6fp-1,  -0x1.fffc28p-2, INEXACT)
T(RN,    0x1.60a0205aa0a9ep-9,     0x1.00b08cd537a5p+0,  -0x1.ffff6ap-2, INEXACT)
T(RN,    0x1.f4113de0eb609p-9,    0x1.00fa82e1262b9p+0,  -0x1.fffed2p-2, INEXACT)
T(RN,   -0x1.6142edc56075dp-9,     0x1.fe9f36d4a181p-1,  -0x1.ffff34p-2, INEXACT)
T(RN,    0x1.5acad3361e139p-8,    0x1.015bb621dcd7ap+0,   -0x1.fffe1p-2, INEXACT)
T(RN,     0x1.844e916f1eaep-8,    0x1.018575a5ae7bdp+0,  -0x1.fffceep-2, INEXACT)
T(RU,    0x1.22fde7a155a6fp-8,    0x1.0123a3887b30ep+0,  0x1.ed6c66p-21, INEXACT)
T(RZ,    0x1.22fde7a155a6fp-8,    0x1.0123a3887b30dp+0,  -0x1.ffffe2p-1, INEXACT)
T(RZ,     0x1.6a131b7bee16p-8,    0x1.016b13a16369cp+0, -0x1.026c22p-19, INEXACT)
T(RU,     0x1.6a131b7bee16p-8,    0x1.016b13a16369dp+0,    0x1.ffffcp-1, INEXACT)
T(RN,    0x1.8153251291e0ep-8,    0x1.018275b4607eap+0,   -0x1.fffecp-2, INEXACT)
T(RN,    -0x1.07e3dec4b892p-8,    0x1.fdf147eb15147p-1,  -0x1.ffffe2p-2, INEXACT)
T(RU,   -0x1.71e212b452962p-7,    0x1.fa40c965e1bc7p-1,  0x1.ea2f96p-19, INEXACT)
T(RZ,   -0x1.71e212b452962p-7,    0x1.fa40c965e1bc6p-1,  -0x1.ffff86p-1, INEXACT)
T(RU,   -0x1.c0bd7360fec53p-7,    0x1.f9094640b5fb5p-1,  0x1.30021ep-17, INEXACT)
T(RZ,   -0x1.c0bd7360fec53p-7,    0x1.f9094640b5fb4p-1,   -0x1.fffedp-1, INEXACT)
T(RU,    0x1.b384f188e6ab5p-7,    0x1.036cda53791f5p+0,  0x1.042176p-17, INEXACT)
T(RZ,    0x1.b384f188e6ab5p-7,    0x1.036cda53791f4p+0,  -0x1.fffefcp-1, INEXACT)
T(RZ,    0x1.756460028b40bp-7,    0x1.02ef0e217ddbep+0, -0x1.741b4ap-18, INEXACT)
T(RU,    0x1.756460028b40bp-7,    0x1.02ef0e217ddbfp+0,   0x1.ffff46p-1, INEXACT)
T(RU,     0x1.a218df790d4cp-7,    0x1.03498d3d19d7dp+0,  0x1.e02f2ep-17, INEXACT)
T(RZ,     0x1.a218df790d4cp-7,    0x1.03498d3d19d7cp+0,   -0x1.fffe2p-1, INEXACT)
T(RN,   -0x1.443e03c9e4c3ep-7,    0x1.faf56d3d56456p-1,  -0x1.ffffcap-2, INEXACT)
T(RN,   -0x1.2682af7fcb0a8p-7,    0x1.fb6b3c76a15adp-1,  -0x1.fffefep-2, INEXACT)
T(RN,    0x1.9aabcbdec7d07p-7,    0x1.033a82b2bc4efp+0,  -0x1.ffff92p-2, INEXACT)
T(RN,    0x1.22bdce0fc49b9p-7,     0x1.024811f665f5p+0,   -0x1.fffd9p-2, INEXACT)
T(RN,    0x1.81280f5ed4149p-7,    0x1.0306db9fa3bedp+0,  -0x1.fffc7ep-2, INEXACT)
T(RN,   -0x1.b9833f89618c2p-6,    0x1.f26310a68e4fep-1,   -0x1.fffc4p-2, INEXACT)
T(RZ,    0x1.986121da7c982p-6,    0x1.06760bc7fa46ap+0, -0x1.67312cp-17, INEXACT)
T(RU,    0x1.986121da7c982p-6,    0x1.06760bc7fa46bp+0,   0x1.fffe98p-1, INEXACT)
T(RN,    0x1.81933d8f4190ep-6,    0x1.06189780e2fccp+0,  -0x1.fffc18p-2, INEXACT)
T(RU,    0x1.86dd8f0f26638p-6,    0x1.062e42ac2c667p+0,  0x1.3712fep-17, INEXACT)
T(RZ,    0x1.86dd8f0f26638p-6,    0x1.062e42ac2c666p+0,  -0x1.fffec8p-1, INEXACT)
T(RN,    0x1.e7ffad57ccbcfp-6,    0x1.07bd5b1c2650fp+0,  -0x1.fffd1ap-2, INEXACT)
T(RN,   -0x1.8e3c3d7efbc53p-6,    0x1.f3b486376021cp-1,   -0x1.fffeep-2, INEXACT)
T(RU,   -0x1.2f8706f6fe27dp-6,    0x1.f69a227223b86p-1,  0x1.396dfap-19, INEXACT)
T(RZ,   -0x1.2f8706f6fe27dp-6,    0x1.f69a227223b85p-1,  -0x1.ffffb2p-1, INEXACT)
T(RU,    0x1.1743b102ec071p-6,    0x1.0466a1d0f69c8p+0,  0x1.f93348p-18, INEXACT)
T(RZ,    0x1.1743b102ec071p-6,    0x1.0466a1d0f69c7p+0,  -0x1.ffff04p-1, INEXACT)
T(RZ,    0x1.59ff40015ce2fp-5,    0x1.0b0b432aad28cp+0, -0x1.93f646p-17, INEXACT)
T(RU,    0x1.59ff40015ce2fp-5,    0x1.0b0b432aad28dp+0,   0x1.fffe6cp-1, INEXACT)
T(RZ,     0x1.6f7ea9f43419p-5,    0x1.0bbee627f592cp+0, -0x1.2a001cp-18, INEXACT)
T(RU,     0x1.6f7ea9f43419p-5,    0x1.0bbee627f592dp+0,   0x1.ffff6ap-1, INEXACT)
T(RN,    0x1.7e882707e601dp-5,    0x1.0c3cd49c4d35fp+0,   -0x1.fffd5p-2, INEXACT)
T(RZ,    0x1.324454975d5c4p-5,    0x1.09c08310572f5p+0, -0x1.04d68cp-19, INEXACT)
T(RU,    0x1.324454975d5c4p-5,    0x1.09c08310572f6p+0,   0x1.ffffbep-1, INEXACT)
T(RN,    0x1.d96571256f43bp-5,    0x1.0f3abc06b06afp+0,  -0x1.fffcc8p-2, INEXACT)
T(RN,   -0x1.ef61f1cb3e5fcp-5,    0x1.e1f4c5ad3bc0dp-1,  -0x1.fffe8cp-2, INEXACT)
T(RU,    0x1.36c4f3b50b709p-4,    0x1.142dccca82a0ep+0,  0x1.a765fep-17, INEXACT)
T(RZ,    0x1.36c4f3b50b709p-4,    0x1.142dccca82a0dp+0,  -0x1.fffe58p-1, INEXACT)
T(RN,   -0x1.c4f3c56a3a337p-4,    0x1.ca6636e6504a2p-1,  -0x1.fffc42p-2, INEXACT)
T(RU,    0x1.5e267541446b7p-4,    0x1.16d8d6bc0edc8p+0,  0x1.1cd1fcp-17, INEXACT)
T(RZ,    0x1.5e267541446b7p-4,    0x1.16d8d6bc0edc7p+0,  -0x1.fffee4p-1, INEXACT)
T(RN,     0x1.89ae9d671f4ap-4,    0x1.19d38e293fa98p+0,  -0x1.fffeb2p-2, INEXACT)
T(RN,    -0x1.2271d7ddae38p-4,    0x1.dcf3a410c93bbp-1,  -0x1.fffea4p-2, INEXACT)
T(RU,    0x1.852aaa8f17005p-4,    0x1.19841054247bfp+0,  0x1.9e1322p-17, INEXACT)
T(RZ,    0x1.852aaa8f17005p-4,    0x1.19841054247bep+0,  -0x1.fffe62p-1, INEXACT)
T(RN,    0x1.0b15504cd10d1p-4,    0x1.113fbbc850edfp+0,  -0x1.fffcc8p-2, INEXACT)
T(RN,    0x1.67b3dd55541b2p-4,    0x1.177f82dd96ac9p+0,   -0x1.fffd5p-2, INEXACT)
T(RN,    0x1.d9a923f812df6p-4,    0x1.1f62277ccaef1p+0,  -0x1.fffe28p-2, INEXACT)
T(RN,    -0x1.e7e606cf0b7fp-3,    0x1.93775e1fcd6e2p-1,  -0x1.fffca8p-2, INEXACT)
T(RU,    0x1.f069b0cd3a745p-3,    0x1.4637dd0a3a889p+0,  0x1.0f357ap-18, INEXACT)
T(RZ,    0x1.f069b0cd3a745p-3,    0x1.4637dd0a3a888p+0,  -0x1.ffff78p-1, INEXACT)
T(RZ,    0x1.4ce6b30f516b7p-3,    0x1.2d2f869864c97p+0, -0x1.3316dap-20, INEXACT)
T(RU,    0x1.4ce6b30f516b7p-3,    0x1.2d2f869864c98p+0,   0x1.ffffdap-1, INEXACT)
T(RU,    0x1.bd5fa18d2624ap-3,    0x1.3e3056f93c59dp+0,  0x1.221e62p-24, INEXACT)
T(RZ,    0x1.bd5fa18d2624ap-3,    0x1.3e3056f93c59cp+0,  -0x1.fffffep-1, INEXACT)
T(RU,   -0x1.55807b1ead265p-3,    0x1.b15cec0f25889p-1,  0x1.f3114ep-17, INEXACT)
T(RZ,   -0x1.55807b1ead265p-3,    0x1.b15cec0f25888p-1,  -0x1.fffe0cp-1, INEXACT)
T(RN,    -0x1.268beeaf08e5p-3,    0x1.bb69e3b1849a6p-1,  -0x1.ffffaap-2, INEXACT)
T(RU,    0x1.ec355412386b6p-3,    0x1.458c96f148854p+0,  0x1.2984eep-20, INEXACT)
T(RZ,    0x1.ec355412386b6p-3,    0x1.458c96f148853p+0,  -0x1.ffffdap-1, INEXACT)
T(RN,   -0x1.2c840f3eb4b62p-3,    0x1.ba1f83f48baa1p-1,  -0x1.fffd1ep-2, INEXACT)
T(RU,    0x1.a05d6f1882cafp-3,    0x1.39b6b25a0abe7p+0,   0x1.e6e97p-17, INEXACT)
T(RZ,    0x1.a05d6f1882cafp-3,    0x1.39b6b25a0abe6p+0,  -0x1.fffe1ap-1, INEXACT)
T(RZ,   -0x1.d01ad960b674cp-3,    0x1.982e5ba863584p-1,  -0x1.9b9e2p-17, INEXACT)
T(RU,   -0x1.d01ad960b674cp-3,    0x1.982e5ba863585p-1,   0x1.fffe64p-1, INEXACT)
T(RU,   -0x1.ef7c37bdec581p-3,    0x1.91f9743f634d6p-1,  0x1.e36368p-17, INEXACT)
T(RZ,   -0x1.ef7c37bdec581p-3,    0x1.91f9743f634d5p-1,  -0x1.fffe1cp-1, INEXACT)
T(RN,   -0x1.e300f3b89a257p-3,    0x1.946e865f5be41p-1,  -0x1.ffff2ap-2, INEXACT)
T(RN,   -0x1.1e7b0fcd6d438p-3,    0x1.bd29d656434d3p-1,  -0x1.fffe12p-2, INEXACT)
T(RN,   -0x1.8aa87b429293ep-3,    0x1.a64279d15ab81p-1,  -0x1.fffe16p-2, INEXACT)
T(RZ,   -0x1.29baa2e7f790fp-2,    0x1.7ed2c5b43a2fep-1, -0x1.510da2p-18, INEXACT)
T(RU,   -0x1.29baa2e7f790fp-2,    0x1.7ed2c5b43a2ffp-1,   0x1.ffff58p-1, INEXACT)
T(RU,   -0x1.f19b54c681306p-2,    0x1.3af08255edab8p-1,  0x1.0339fep-20, INEXACT)
T(RZ,   -0x1.f19b54c681306p-2,    0x1.3af08255edab7p-1,   -0x1.ffffep-1, INEXACT)
T(RZ,   -0x1.7948091fb7ce4p-2,    0x1.6235615062ef5p-1, -0x1.63334ap-17, INEXACT)
T(RU,   -0x1.7948091fb7ce4p-2,    0x1.6235615062ef6p-1,   0x1.fffe9cp-1, INEXACT)
T(RN,    0x1.b5b3f0175a65ap-2,    0x1.88888dd5f8b09p+0,  -0x1.fffc06p-2, INEXACT)
T(RZ,    0x1.3c68ff9b8100fp-1,    0x1.daede8bb7aa14p+0, -0x1.6faf38p-17, INEXACT)
T(RU,    0x1.3c68ff9b8100fp-1,    0x1.daede8bb7aa15p+0,    0x1.fffe9p-1, INEXACT)
T(RN,   -0x1.07a94f2e4e948p-1,    0x1.31ee72cff327ep-1,  -0x1.ffff82p-2, INEXACT)
T(RZ,   -0x1.0659ad6fb9425p-1,    0x1.32b740c3554e4p-1, -0x1.9f1a74p-17, INEXACT)
T(RU,   -0x1.0659ad6fb9425p-1,    0x1.32b740c3554e5p-1,    0x1.fffe6p-1, INEXACT)
T(RU,   -0x1.ff26891502651p-1,    0x1.795585c19abddp-2,  0x1.376c6ep-19, INEXACT)
T(RZ,   -0x1.ff26891502651p-1,    0x1.795585c19abdcp-2,  -0x1.ffffb2p-1, INEXACT)
T(RN,    0x1.2728d520299aep-1,    0x1.c79eeb9f68365p+0,  -0x1.fffe04p-2, INEXACT)
T(RN,    0x1.eb017bb5b0f1fp+0,    0x1.b3aa562d9642dp+2,   -0x1.fffebp-2, INEXACT)
T(RZ,    0x1.040063ba872b5p+0,    0x1.616be315586f2p+1, -0x1.42ac16p-18, INEXACT)
T(RU,    0x1.040063ba872b5p+0,    0x1.616be315586f3p+1,   0x1.ffff5ep-1, INEXACT)
T(RU,    0x1.873f6a846f3bbp+0,    0x1.27108cec96a37p+2,  0x1.36f822p-17, INEXACT)
T(RZ,    0x1.873f6a846f3bbp+0,    0x1.27108cec96a36p+2,  -0x1.fffecap-1, INEXACT)
T(RU,    0x1.7e9a59b61a1a9p+0,    0x1.1d445ddb3125ep+2,  0x1.65a2dcp-19, INEXACT)
T(RZ,    0x1.7e9a59b61a1a9p+0,    0x1.1d445ddb3125dp+2,  -0x1.ffffa6p-1, INEXACT)
T(RN,   -0x1.43577a3842bebp+0,    0x1.21937db1367dcp-2,  -0x1.ffffecp-2, INEXACT)
T(RN,   -0x1.fbe421c6296edp+0,     0x1.19a6b139f88cp-3,  -0x1.ffff36p-2, INEXACT)
T(RN,   -0x1.f9583f9e6efa6p+0,    0x1.1c77791e94516p-3,  -0x1.fffd66p-2, INEXACT)
T(RN,    0x1.0438b18cad2e6p+0,    0x1.61b9a6ab7d63fp+1,   -0x1.ffffep-2, INEXACT)
T(RZ,   -0x1.2a5e8fd39d902p+1,    0x1.8e1ee9eee5337p-4, -0x1.a13124p-18, INEXACT)
T(RU,   -0x1.2a5e8fd39d902p+1,    0x1.8e1ee9eee5338p-4,    0x1.ffff3p-1, INEXACT)
T(RU,    0x1.d8a6ce9405a37p+1,    0x1.413093c9624b7p+5,   0x1.0bfaep-17, INEXACT)
T(RZ,    0x1.d8a6ce9405a37p+1,    0x1.413093c9624b6p+5,  -0x1.fffef4p-1, INEXACT)
T(RN,    0x1.3882ff7648041p+1,    0x1.6fb005fea98bep+3,  -0x1.fffc8ap-2, INEXACT)
T(RN,    0x1.c1bc7f8ac1106p+1,    0x1.0c8ab2dc138d4p+5,  -0x1.ffff38p-2, INEXACT)
T(RN,   -0x1.411b915e93a28p+1,    0x1.4d52b8460c801p-4,  -0x1.ffff64p-2, INEXACT)
T(RN,   -0x1.3b04553f7aa0ap+1,    0x1.5d914222b6a3ep-4,  -0x1.ffffcap-2, INEXACT)
T(RN,   -0x1.df6be3c1a112ep+1,    0x1.830f6fdb9b06ep-6,  -0x1.fffc8ap-2, INEXACT)
T(RZ,    0x1.4d63bf15359b5p+1,    0x1.b0d43094965f3p+3, -0x1.c15e5ap-18, INEXACT)
T(RU,    0x1.4d63bf15359b5p+1,    0x1.b0d43094965f4p+3,    0x1.ffff2p-1, INEXACT)
T(RN,    0x1.d135d5c28430cp+1,    0x1.2f0cbbdc46072p+5,  -0x1.fffe94p-2, INEXACT)
T(RN,   -0x1.222cd33a96899p+1,    0x1.a870eb0b71148p-4,  -0x1.fffec6p-2, INEXACT)
T(RN,   -0x1.f0366d8cd78e3p+1,    0x1.537988153a09ep-6,  -0x1.fffedcp-2, INEXACT)
T(RU,    0x1.552cffd0a057bp+2,    0x1.9d3c66b558784p+7,  0x1.b59a98p-18, INEXACT)
T(RZ,    0x1.552cffd0a057bp+2,    0x1.9d3c66b558783p+7,  -0x1.ffff26p-1, INEXACT)
T(RZ,    0x1.933347f6e1131p+2,    0x1.10498cb14d098p+9, -0x1.cdadfcp-17, INEXACT)
T(RU,    0x1.933347f6e1131p+2,    0x1.10498cb14d099p+9,   0x1.fffe32p-1, INEXACT)
T(RN,    0x1.2f68ffdc7e4eap+2,    0x1.ca187cf306dd2p+6,  -0x1.ffff02p-2, INEXACT)
T(RN,   -0x1.7702bd142ac76p+2,    0x1.75e3acf694e41p-9,  -0x1.fffc6ep-2, INEXACT)
T(RN,    0x1.2f75814c65b1dp+2,    0x1.ca7208c42ad46p+6,  -0x1.fffc02p-2, INEXACT)
T(RN,    0x1.5d7057ee257b5p+2,    0x1.d62fb3eb0df58p+7,   -0x1.ffff8p-2, INEXACT)
T(RZ,    0x1.8c2b18b72e3e6p+3,   0x1.d0f3f37ee813fp+17, -0x1.4d85cep-18, INEXACT)
T(RU,    0x1.8c2b18b72e3e6p+3,    0x1.d0f3f37ee814p+17,   0x1.ffff5ap-1, INEXACT)
T(RZ,    0x1.1455d782f53f1p+3,   0x1.5fbd3cd183afbp+12, -0x1.eb7a92p-19, INEXACT)
T(RU,    0x1.1455d782f53f1p+3,   0x1.5fbd3cd183afcp+12,   0x1.ffff86p-1, INEXACT)
T(RU,    0x1.e194600553115p+3,   0x1.a33e022d03db9p+21,  0x1.5deaeap-17, INEXACT)
T(RZ,    0x1.e194600553115p+3,   0x1.a33e022d03db8p+21,  -0x1.fffea2p-1, INEXACT)
T(RZ,   -0x1.4bd5825756d3ep+3,   0x1.071c26037193bp-15, -0x1.5f15a4p-17, INEXACT)
T(RU,   -0x1.4bd5825756d3ep+3,   0x1.071c26037193cp-15,    0x1.fffeap-1, INEXACT)
T(RZ,   -0x1.b194caac74e0cp+3,   0x1.5e4574259c783p-20, -0x1.89f5fcp-17, INEXACT)
T(RU,   -0x1.b194caac74e0cp+3,   0x1.5e4574259c784p-20,   0x1.fffe76p-1, INEXACT)
T(RN,    0x1.a3b39e242e16ap+3,   0x1.e506dda9db669p+18,  -0x1.ffffdep-2, INEXACT)
T(RN,    0x1.888a635d93d62p+3,   0x1.9f1ecebe27aedp+17,   -0x1.fffc7p-2, INEXACT)
T(RN,   -0x1.2e6ef0d02e96bp+3,   0x1.49b43c16a0ca7p-14,  -0x1.fffff6p-2, INEXACT)
T(RU,   -0x1.4aad03584f0cbp+4,   0x1.22b7c791ea165p-30,  0x1.3052acp-17, INEXACT)
T(RZ,   -0x1.4aad03584f0cbp+4,   0x1.22b7c791ea164p-30,   -0x1.fffedp-1, INEXACT)
T(RU,    0x1.5e030b7cde9d2p+4,   0x1.796b7b32dba95p+31,  0x1.415ae6p-18, INEXACT)
T(RZ,    0x1.5e030b7cde9d2p+4,   0x1.796b7b32dba94p+31,   -0x1.ffff6p-1, INEXACT)
T(RN,    0x1.60157fdf2a059p+4,   0x1.ad9a9cc32a30cp+31,  -0x1.ffffb4p-2, INEXACT)
T(RU,   -0x1.10206160b60cap+4,   0x1.60d15712a5c79p-25,  0x1.568122p-19, INEXACT)
T(RZ,   -0x1.10206160b60cap+4,   0x1.60d15712a5c78p-25,  -0x1.ffffaap-1, INEXACT)
T(RN,   -0x1.0f2d8aaf94be4p+4,   0x1.765e1f204f43fp-25,  -0x1.fffcf8p-2, INEXACT)
T(RN,    0x1.c90aeb581a9a9p+4,   0x1.2847fa82ea15ap+41,   -0x1.fffe8p-2, INEXACT)
T(RN,   -0x1.b740d80bcd9e8p+4,   0x1.50358f19b9347p-40,  -0x1.fffca4p-2, INEXACT)
T(RZ,    0x1.0e5c334a7b50dp+5,   0x1.b04e3457f158fp+48, -0x1.cc45cep-17, INEXACT)
T(RU,    0x1.0e5c334a7b50dp+5,    0x1.b04e3457f159p+48,   0x1.fffe34p-1, INEXACT)
T(RN,    0x1.5b69e68aac3f3p+5,   0x1.921fd8f741224p+62,   -0x1.fffdfp-2, INEXACT)
T(RU,    0x1.fab3be2d3fe3dp+5,   0x1.4c7846287f496p+91,  0x1.869fdcp-17, INEXACT)
T(RZ,    0x1.fab3be2d3fe3dp+5,   0x1.4c7846287f495p+91,  -0x1.fffe7ap-1, INEXACT)
T(RN,    0x1.29057861a6a08p+5,   0x1.7a6fb485b56fdp+53,  -0x1.ffffa2p-2, INEXACT)
T(RN,   -0x1.8f3f05b66d75fp+5,   0x1.00360c992ec45p-72,  -0x1.fffe36p-2, INEXACT)
T(RU,   -0x1.7688ca33aabbep+6,  0x1.e2cdbf91ebf08p-136,  0x1.ce8b9ep-20, INEXACT)
T(RZ,   -0x1.7688ca33aabbep+6,  0x1.e2cdbf91ebf07p-136,  -0x1.ffffc6p-1, INEXACT)
T(RZ,    0x1.25583ee351646p+6,  0x1.be4276476414cp+105, -0x1.f9a4ccp-17, INEXACT)
T(RU,    0x1.25583ee351646p+6,  0x1.be4276476414dp+105,   0x1.fffe06p-1, INEXACT)
T(RU,    0x1.d43a662f52352p+6,  0x1.d65a228051fe9p+168,  0x1.800c2ep-17, INEXACT)
T(RZ,    0x1.d43a662f52352p+6,  0x1.d65a228051fe8p+168,   -0x1.fffe8p-1, INEXACT)
T(RZ,    0x1.223e55680b94cp+6,   0x1.9b0fcc00bca4p+104, -0x1.e22666p-20, INEXACT)
T(RU,    0x1.223e55680b94cp+6,  0x1.9b0fcc00bca41p+104,   0x1.ffffc4p-1, INEXACT)
T(RU,    0x1.6d37db0555576p+6,  0x1.a707b1a2f20ccp+131,  0x1.fa4002p-17, INEXACT)
T(RZ,    0x1.6d37db0555576p+6,  0x1.a707b1a2f20cbp+131,  -0x1.fffe06p-1, INEXACT)
T(RN,    0x1.471be97402c41p+6,  0x1.f8d39de612f7ep+117,  -0x1.fffc9cp-2, INEXACT)
T(RN,   -0x1.fcbfa068e63b7p+6,  0x1.6bfd272ebc28dp-184,  -0x1.ffff4cp-2, INEXACT)
T(RN,   -0x1.08bab2970db3dp+6,   0x1.6edc9721c16efp-96,  -0x1.ffffb8p-2, INEXACT)
T(RN,    0x1.0da2ea16c0cc9p+6,   0x1.3099698c93804p+97,  -0x1.ffffa8p-2, INEXACT)
T(RN,   -0x1.b8ea2ebdfd277p+7,  0x1.ed9b7554695a2p-319,  -0x1.ffff2ap-2, INEXACT)
T(RU,    -0x1.9d9cf0810c7bp+7,  0x1.8f4796b06e81ep-299,  0x1.850014p-18, INEXACT)
T(RZ,    -0x1.9d9cf0810c7bp+7,  0x1.8f4796b06e81dp-299,  -0x1.ffff3ep-1, INEXACT)
T(RU,   -0x1.0b8b5538064f6p+7,  0x1.015a5f52658dfp-193,  0x1.284452p-19, INEXACT)
T(RZ,   -0x1.0b8b5538064f6p+7,  0x1.015a5f52658dep-193,  -0x1.ffffb6p-1, INEXACT)
T(RU,   -0x1.2be1c35143b41p+7,  0x1.9a6a9bb1e1c86p-217,   0x1.ce6e5p-21, INEXACT)
T(RZ,   -0x1.2be1c35143b41p+7,  0x1.9a6a9bb1e1c85p-217,  -0x1.ffffe4p-1, INEXACT)
T(RN,   -0x1.2397f505b730ap+7,  0x1.946a35f1be28dp-211,  -0x1.ffff8cp-2, INEXACT)
T(RZ,     0x1.02b5832fe30bp+8,  0x1.2df71db9ce0bbp+373, -0x1.5ae9b6p-18, INEXACT)
T(RU,     0x1.02b5832fe30bp+8,  0x1.2df71db9ce0bcp+373,   0x1.ffff52p-1, INEXACT)
T(RZ,   -0x1.c7dc4f3fcf765p+8,  0x1.42491ae3d8e4bp-658, -0x1.474deap-17, INEXACT)
T(RU,   -0x1.c7dc4f3fcf765p+8,  0x1.42491ae3d8e4cp-658,   0x1.fffeb8p-1, INEXACT)
T(RN,   -0x1.2721edb13ea85p+8,   0x1.28e26f645eddp-426,  -0x1.ffff24p-2, INEXACT)
T(RZ,    0x1.1c96b6649be14p+8,  0x1.7d49a1c8c9293p+410, -0x1.d08e0cp-22, INEXACT)
T(RU,    0x1.1c96b6649be14p+8,  0x1.7d49a1c8c9294p+410,   0x1.fffff2p-1, INEXACT)
T(RU,   -0x1.2e3bbba03d9a4p+8,  0x1.f547878e3dfabp-437,  0x1.b356bep-17, INEXACT)
T(RZ,   -0x1.2e3bbba03d9a4p+8,  0x1.f547878e3dfaap-437,  -0x1.fffe4cp-1, INEXACT)
T(RZ,   -0x1.c67456f3103f9p+8,  0x1.48be322ee269ap-656, -0x1.1e42aep-17, INEXACT)
T(RU,   -0x1.c67456f3103f9p+8,  0x1.48be322ee269bp-656,   0x1.fffee2p-1, INEXACT)
T(RU,    0x1.72d232fe9bb05p+8,  0x1.f9904145304a5p+534,  0x1.43802ep-18, INEXACT)
T(RZ,    0x1.72d232fe9bb05p+8,  0x1.f9904145304a4p+534,  -0x1.ffff5ep-1, INEXACT)
T(RU,    0x1.433cf3915b125p+8,  0x1.42afe01403a04p+466,  0x1.5a0d8ep-18, INEXACT)
T(RZ,    0x1.433cf3915b125p+8,  0x1.42afe01403a03p+466,  -0x1.ffff52p-1, INEXACT)
T(RN,    0x1.8c44cb1977d38p+8,    0x1.9e698d2bcacp+571,  -0x1.fffd5ep-2, INEXACT)
T(RZ,    0x1.9b419b7c61ca1p+8,  0x1.3efef12de59c9p+593, -0x1.24215ap-17, INEXACT)
T(RU,    0x1.9b419b7c61ca1p+8,  0x1.3efef12de59cap+593,   0x1.fffedcp-1, INEXACT)
T(RN,   0x1.9801715fffae7p-15,    0x1.00033007f74e9p+0,  -0x1.ffff82p-2, INEXACT)
T(RN,   0x1.fee7aef078afdp-15,    0x1.0003fdd7552b6p+0,  -0x1.ffffeap-2, INEXACT)
T(RU,  -0x1.1fda5c8ddf27ap-15,    0x1.fffb809b9c721p-1,  0x1.c0fdd6p-19, INEXACT)
T(RZ,  -0x1.1fda5c8ddf27ap-15,     0x1.fffb809b9c72p-1,   -0x1.ffff9p-1, INEXACT)
T(RU,  -0x1.a75426967777cp-15,    0x1.fff962ba55b6ep-1,  0x1.bdcde8p-19, INEXACT)
T(RZ,  -0x1.a75426967777cp-15,    0x1.fff962ba55b6dp-1,   -0x1.ffff9p-1, INEXACT)
T(RU,  -0x1.c2f3c737e3a92p-15,    0x1.fff8f43d4c89ap-1,  0x1.232bf6p-20, INEXACT)
T(RZ,  -0x1.c2f3c737e3a92p-15,    0x1.fff8f43d4c899p-1,  -0x1.ffffdcp-1, INEXACT)
T(RN,   0x1.2998885b089e6p-15,    0x1.00025333c49ebp+0,  -0x1.ffff6ap-2, INEXACT)
T(RN,   0x1.a28d61e388586p-15,    0x1.000345201c70ep+0,  -0x1.ffff1cp-2, INEXACT)
T(RZ,  -0x1.470826b31919cp-14,    0x1.fff5c7d8e697fp-1, -0x1.503bf6p-19, INEXACT)
T(RU,  -0x1.470826b31919cp-14,     0x1.fff5c7d8e698p-1,   0x1.ffffacp-1, INEXACT)
T(RZ,   0x1.beeb69cc7d64cp-14,    0x1.0006fbc60933ap+0, -0x1.8b673ep-20, INEXACT)
T(RU,   0x1.beeb69cc7d64cp-14,    0x1.0006fbc60933bp+0,   0x1.ffffcep-1, INEXACT)
T(RZ,    0x1.d2f806bf1acdp-14,    0x1.00074bfab99c7p+0, -0x1.9a7266p-20, INEXACT)
T(RU,    0x1.d2f806bf1acdp-14,    0x1.00074bfab99c8p+0,   0x1.ffffccp-1, INEXACT)
T(RZ,   0x1.4a2e2b1aec60fp-14,    0x1.000528c5fb5b1p+0, -0x1.dcff1ap-20, INEXACT)
T(RU,   0x1.4a2e2b1aec60fp-14,    0x1.000528c5fb5b2p+0,   0x1.ffffc4p-1, INEXACT)
T(RU,  -0x1.7de6bd05ded68p-14,    0x1.fff410edb3142p-1,  0x1.a8d8cap-19, INEXACT)
T(RZ,  -0x1.7de6bd05ded68p-14,    0x1.fff410edb3141p-1,  -0x1.ffff96p-1, INEXACT)
T(RN,  -0x1.525309e833781p-14,    0x1.fff56d83a2833p-1,  -0x1.ffff6cp-2, INEXACT)
T(RN,  -0x1.48794194bdea4p-14,    0x1.fff5bc504a9c1p-1,  -0x1.ffff0ep-2, INEXACT)
T(RN,   0x1.20148a9362489p-14,    0x1.0004805c4bce8p+0,  -0x1.ffff02p-2, INEXACT)
T(RN,   0x1.b3ff372235e8dp-14,    0x1.0006d01411282p+0,   -0x1.ffffcp-2, INEXACT)
T(RN,  -0x1.16553a10769bep-14,    0x1.fff74d6919344p-1,  -0x1.fffff2p-2, INEXACT)
T(RN,   0x1.08653ad1834f4p-13,    0x1.0008434bf9084p+0,  -0x1.ffffaep-2, INEXACT)
T(RZ,   0x1.c3c672a07292dp-13,    0x1.000e1e973f72dp+0, -0x1.2c0ec2p-21, INEXACT)
T(RU,   0x1.c3c672a07292dp-13,    0x1.000e1e973f72ep+0,   0x1.ffffeep-1, INEXACT)
T(RZ,  -0x1.f69b1add86c62p-13,    0x1.ffe09744fe46fp-1, -0x1.915878p-20, INEXACT)
T(RU,  -0x1.f69b1add86c62p-13,     0x1.ffe09744fe47p-1,   0x1.ffffcep-1, INEXACT)
T(RN,   0x1.2419cf6ee9298p-13,    0x1.000920f825528p+0,  -0x1.ffff08p-2, INEXACT)
T(RU,   0x1.60334b9e12002p-13,    0x1.000b01d6ef721p+0,    0x1.98ddp-19, INEXACT)
T(RZ,   0x1.60334b9e12002p-13,     0x1.000b01d6ef72p+0,  -0x1.ffff9ap-1, INEXACT)
T(RU,  -0x1.5c59920e96e57p-13,    0x1.ffea3add5e51bp-1,  0x1.516f7ep-20, INEXACT)
T(RZ,  -0x1.5c59920e96e57p-13,    0x1.ffea3add5e51ap-1,  -0x1.ffffd6p-1, INEXACT)
T(RN,   0x1.854fda799f4f1p-13,    0x1.000c2ac8d671fp+0,  -0x1.ffffaap-2, INEXACT)
T(RN,  -0x1.817243c86aeb1p-13,    0x1.ffe7e96cd76b8p-1,  -0x1.ffff7cp-2, INEXACT)
T(RN,   0x1.260bb4339f15ap-13,    0x1.00093087d9fa9p+0,  -0x1.ffff2cp-2, INEXACT)
T(RN,   0x1.b6bf276c05ecdp-12,    0x1.001b6d6a7d822p+0,  -0x1.ffffd2p-2, INEXACT)
T(RN,  -0x1.f545c3f135f3ap-12,     0x1.ffc15b1ce3f4p-1,  -0x1.ffffc6p-2, INEXACT)
T(RZ,  -0x1.f1af20c2c5f66p-12,    0x1.ffc1cde349edap-1, -0x1.c26fdep-19, INEXACT)
T(RU,  -0x1.f1af20c2c5f66p-12,    0x1.ffc1cde349edbp-1,    0x1.ffff9p-1, INEXACT)
T(RU,   0x1.1e1242ed1097bp-12,    0x1.0011e1c408f12p+0,  0x1.372f36p-22, INEXACT)
T(RZ,   0x1.1e1242ed1097bp-12,    0x1.0011e1c408f11p+0,  -0x1.fffff6p-1, INEXACT)
T(RN,   0x1.180a56cabb7e9p-12,    0x1.0011813e9b788p+0,  -0x1.ffff78p-2, INEXACT)
T(RN,   0x1.8caaa4ddbe9bep-12,    0x1.0018cbdda7f7ap+0,  -0x1.ffffbcp-2, INEXACT)
T(RU,   0x1.13605e0d9f0cbp-12,    0x1.0011369a0042ep+0,   0x1.49ff7p-20, INEXACT)
T(RZ,   0x1.13605e0d9f0cbp-12,    0x1.0011369a0042dp+0,  -0x1.ffffd6p-1, INEXACT)
T(RU,  -0x1.cbebc95e86288p-11,    0x1.ff8d11f5ce784p-1,   0x1.03647p-24, INEXACT)
T(RZ,  -0x1.cbebc95e86288p-11,    0x1.ff8d11f5ce783p-1,  -0x1.fffffep-1, INEXACT)
T(RN,  -0x1.69beecbbb7487p-11,    0x1.ffa5984108ccap-1,  -0x1.ffffb6p-2, INEXACT)
T(RZ,   0x1.8463ba2ce6d72p-11,    0x1.003091120d062p+0,  -0x1.3f938p-19, INEXACT)
T(RU,   0x1.8463ba2ce6d72p-11,    0x1.003091120d063p+0,    0x1.ffffbp-1, INEXACT)
T(RN,  -0x1.1bd8694a8307ap-11,    0x1.ffb90ed053f79p-1,  -0x1.ffff4cp-2, INEXACT)
T(RU,   0x1.aa045d68ecb69p-11,    0x1.00354615f4814p+0,  0x1.5e0eb8p-20, INEXACT)
T(RZ,   0x1.aa045d68ecb69p-11,    0x1.00354615f4813p+0,  -0x1.ffffd4p-1, INEXACT)
T(RU,  -0x1.bd44434ef0f26p-11,    0x1.ff90bb08255f1p-1,  0x1.7ced3cp-19, INEXACT)
T(RZ,  -0x1.bd44434ef0f26p-11,     0x1.ff90bb08255fp-1,   -0x1.ffffap-1, INEXACT)
T(RZ,   0x1.e5b8a40afd832p-11,    0x1.003cbe483d648p+0, -0x1.4188cep-23, INEXACT)
T(RU,   0x1.e5b8a40afd832p-11,    0x1.003cbe483d649p+0,   0x1.fffffap-1, INEXACT)
T(RN,  -0x1.aa8bf4a0828c7p-11,     0x1.ff95681ceae7p-1,  -0x1.ffff32p-2, INEXACT)
T(RN,   0x1.8d0c7f6776d9ap-11,    0x1.0031a65fdc11dp+0,  -0x1.ffff74p-2, INEXACT)
T(RN,   0x1.fa6415cf8716dp-11,    0x1.003f5456beb43p+0,  -0x1.ffffeep-2, INEXACT)
T(RZ,  -0x1.97e1a140ef9cdp-10,    0x1.ff3437c7eed7bp-1,  -0x1.90065p-20, INEXACT)
T(RU,  -0x1.97e1a140ef9cdp-10,    0x1.ff3437c7eed7cp-1,   0x1.ffffcep-1, INEXACT)
T(RU,   0x1.2080bdfaad8d4p-10,    0x1.00482a598264ap+0,  0x1.111facp-19, INEXACT)
T(RZ,   0x1.2080bdfaad8d4p-10,    0x1.00482a5982649p+0,  -0x1.ffffbcp-1, INEXACT)
T(RN,   0x1.865153e9d56b1p-10,    0x1.0061a6f036c17p+0,   -0x1.ffff5p-2, INEXACT)
T(RU,   0x1.07c321e973bf8p-10,    0x1.0041f9474936fp+0,  0x1.f6464cp-19, INEXACT)
T(RZ,   0x1.07c321e973bf8p-10,    0x1.0041f9474936ep+0,  -0x1.ffff82p-1, INEXACT)
T(RZ,   0x1.5cb32ead273c8p-10,    0x1.00573ba517df2p+0, -0x1.7b9f2ep-19, INEXACT)
T(RU,   0x1.5cb32ead273c8p-10,    0x1.00573ba517df3p+0,   0x1.ffffa2p-1, INEXACT)
T(RZ,  -0x1.9c7caf1b94581p-10,    0x1.ff31eb2cf7ebap-1, -0x1.ea1b0ep-19, INEXACT)
T(RU,  -0x1.9c7caf1b94581p-10,    0x1.ff31eb2cf7ebbp-1,   0x1.ffff86p-1, INEXACT)
T(RZ,   0x1.9fb05ac2e7197p-10,     0x1.0068013175b3p+0, -0x1.c38348p-19, INEXACT)
T(RU,   0x1.9fb05ac2e7197p-10,    0x1.0068013175b31p+0,    0x1.ffff9p-1, INEXACT)
T(RZ,    0x1.7b4504b61657ep-9,    0x1.00bde8d063df3p+0, -0x1.f7c7a6p-21, INEXACT)
T(RU,    0x1.7b4504b61657ep-9,    0x1.00bde8d063df4p+0,    0x1.ffffep-1, INEXACT)
T(RZ,    0x1.5d81f112dd13fp-9,    0x1.00aefcab8fe08p+0, -0x1.f2376ap-19, INEXACT)
T(RU,    0x1.5d81f112dd13fp-9,    0x1.00aefcab8fe09p+0,   0x1.ffff84p-1, INEXACT)
T(RU,   -0x1.09dc1e502a034p-9,    0x1.fef668dc1be71p-1,  0x1.61b024p-20, INEXACT)
T(RZ,   -0x1.09dc1e502a034p-9,     0x1.fef668dc1be7p-1,  -0x1.ffffd4p-1, INEXACT)
T(RZ,    0x1.d7c309a14fe7bp-9,    0x1.00ec4e52211dcp+0, -0x1.a7274ep-19, INEXACT)
T(RU,    0x1.d7c309a14fe7bp-9,    0x1.00ec4e52211ddp+0,   0x1.ffff96p-1, INEXACT)
T(RN,   -0x1.55e1e5782961bp-9,    0x1.feaa902609434p-1,  -0x1.ffff7cp-2, INEXACT)
T(RN,    0x1.e8d510f58493bp-9,    0x1.00f4df5b45e43p+0,  -0x1.ffffeep-2, INEXACT)
T(RN,   -0x1.6a3310bd06db6p-9,    0x1.fe964cee2fe81p-1,  -0x1.ffffaep-2, INEXACT)
T(RZ,    0x1.c072ee30c2f54p-8,    0x1.01c1fc9d2ace1p+0, -0x1.03a194p-20, INEXACT)
T(RU,    0x1.c072ee30c2f54p-8,    0x1.01c1fc9d2ace2p+0,    0x1.ffffep-1, INEXACT)
T(RU,    0x1.08dd129eabcf7p-8,    0x1.01096646467f9p+0,  0x1.1e716ap-19, INEXACT)
T(RZ,    0x1.08dd129eabcf7p-8,    0x1.01096646467f8p+0,  -0x1.ffffb8p-1, INEXACT)
T(RZ,    0x1.e785975ee98b9p-8,    0x1.01e956f55f617p+0, -0x1.a46eacp-20, INEXACT)
T(RU,    0x1.e785975ee98b9p-8,    0x1.01e956f55f618p+0,   0x1.ffffccp-1, INEXACT)
T(RZ,   -0x1.6907af922e9c2p-8,     0x1.fd2fecd88462p-1,  -0x1.9066bp-19, INEXACT)
T(RU,   -0x1.6907af922e9c2p-8,    0x1.fd2fecd884621p-1,   0x1.ffff9cp-1, INEXACT)
T(RU,   -0x1.e9bd015028338p-8,    0x1.fc302c8ca80f5p-1,  0x1.698ac2p-21, INEXACT)
T(RZ,   -0x1.e9bd015028338p-8,    0x1.fc302c8ca80f4p-1,  -0x1.ffffeap-1, INEXACT)
T(RN,    0x1.7150d9227b607p-8,    0x1.01725bbe8117fp+0,  -0x1.ffff4ep-2, INEXACT)
T(RZ,    0x1.a9982acfae588p-8,    0x1.01aafab4792cap+0, -0x1.80e344p-19, INEXACT)
T(RU,    0x1.a9982acfae588p-8,    0x1.01aafab4792cbp+0,    0x1.ffffap-1, INEXACT)
T(RZ,   -0x1.ad6be505060d4p-8,    0x1.fca7f6f6a63c7p-1, -0x1.4ac99ap-22, INEXACT)
T(RU,   -0x1.ad6be505060d4p-8,    0x1.fca7f6f6a63c8p-1,   0x1.fffff6p-1, INEXACT)
T(RN,   -0x1.8393066b0de6cp-7,    0x1.f9fad5c3c7ee3p-1,  -0x1.ffff46p-2, INEXACT)
T(RZ,    0x1.f7dffe189156ap-7,    0x1.03f789b4eb573p+0, -0x1.7f5d26p-19, INEXACT)
T(RU,    0x1.f7dffe189156ap-7,    0x1.03f789b4eb574p+0,    0x1.ffffap-1, INEXACT)
T(RN,    0x1.e47ad46f76a44p-7,     0x1.03d0287c6556p+0,  -0x1.ffff92p-2, INEXACT)
T(RZ,    0x1.9a6ba91c5b807p-7,    0x1.033a00cf36356p+0, -0x1.debbd8p-19, INEXACT)
T(RU,    0x1.9a6ba91c5b807p-7,    0x1.033a00cf36357p+0,   0x1.ffff88p-1, INEXACT)
T(RU,    0x1.b33c66bed3534p-7,    0x1.036c474d1d0f8p+0,  0x1.872bc4p-19, INEXACT)
T(RZ,    0x1.b33c66bed3534p-7,    0x1.036c474d1d0f7p+0,  -0x1.ffff9ep-1, INEXACT)
T(RU,    0x1.9da5b87212353p-7,    0x1.034089d5a83d8p+0,  0x1.0dc49ap-20, INEXACT)
T(RZ,    0x1.9da5b87212353p-7,    0x1.034089d5a83d7p+0,  -0x1.ffffdep-1, INEXACT)
T(RU,    0x1.c2eeee7795df7p-6,    0x1.0724c8d40f7fbp+0,  0x1.b5656ap-19, INEXACT)
T(RZ,    0x1.c2eeee7795df7p-6,    0x1.0724c8d40f7fap+0,  -0x1.ffff92p-1, INEXACT)
T(RN,    0x1.ae754ed43d92ap-6,    0x1.06d0a6b95f94dp+0,  -0x1.ffff1ap-2, INEXACT)
T(RU,    0x1.6e3451af2caddp-6,    0x1.05c94f79e9342p+0,  0x1.d17058p-20, INEXACT)
T(RZ,    0x1.6e3451af2caddp-6,    0x1.05c94f79e9341p+0,  -0x1.ffffc6p-1, INEXACT)
T(RN,    0x1.5d71cab2efab2p-6,    0x1.0584ca6cd45abp+0,  -0x1.ffff7cp-2, INEXACT)
T(RU,   -0x1.9b8e0a27957e4p-6,    0x1.f34c91af54027p-1,  0x1.9c12ccp-20, INEXACT)
T(RZ,   -0x1.9b8e0a27957e4p-6,    0x1.f34c91af54026p-1,  -0x1.ffffccp-1, INEXACT)
T(RZ,   -0x1.f8f5758f407bfp-6,     0x1.f075f252528ep-1, -0x1.044c06p-20, INEXACT)
T(RU,   -0x1.f8f5758f407bfp-6,    0x1.f075f252528e1p-1,    0x1.ffffep-1, INEXACT)
T(RN,   -0x1.e2364ef8381d9p-6,    0x1.f12685080331ep-1,  -0x1.ffff96p-2, INEXACT)
T(RN,     0x1.15277d6b16adp-5,    0x1.08cf2aef7ee13p+0,  -0x1.ffffbep-2, INEXACT)
T(RU,    0x1.4a25f992ec29ep-5,    0x1.0a87216e3ece6p+0,  0x1.173d26p-22, INEXACT)
T(RZ,    0x1.4a25f992ec29ep-5,    0x1.0a87216e3ece5p+0,  -0x1.fffff8p-1, INEXACT)
T(RU,    0x1.f994cc0f081fcp-5,    0x1.104c11817e20dp+0,  0x1.189eaep-22, INEXACT)
T(RZ,    0x1.f994cc0f081fcp-5,    0x1.104c11817e20cp+0,  -0x1.fffff8p-1, INEXACT)
T(RZ,    0x1.357fbf65b539cp-5,    0x1.09db5be9a2be9p+0, -0x1.d2a428p-20, INEXACT)
T(RU,    0x1.357fbf65b539cp-5,    0x1.09db5be9a2beap+0,   0x1.ffffc6p-1, INEXACT)
T(RZ,     0x1.18c9d94c2507p-5,    0x1.08ed3fa1e1e39p+0, -0x1.f47354p-19, INEXACT)
T(RU,     0x1.18c9d94c2507p-5,    0x1.08ed3fa1e1e3ap+0,   0x1.ffff82p-1, INEXACT)
T(RU,    0x1.0975bcf97ee54p-5,    0x1.086e7672fee94p+0,  0x1.8f2e16p-20, INEXACT)
T(RZ,    0x1.0975bcf97ee54p-5,    0x1.086e7672fee93p+0,  -0x1.ffffcep-1, INEXACT)
T(RN,    0x1.aaecacdbef76dp-5,    0x1.0db1f57558361p+0,  -0x1.ffff44p-2, INEXACT)
T(RN,   -0x1.2e669a1fc5905p-5,    0x1.ed71cd32cfff7p-1,  -0x1.ffff96p-2, INEXACT)
T(RN,   -0x1.7980ec5ad4a7fp-5,    0x1.e8f0ff75c6ce2p-1,  -0x1.ffff56p-2, INEXACT)
T(RZ,    0x1.0bf3d3e453816p-4,    0x1.114e944b2de17p+0, -0x1.e75624p-20, INEXACT)
T(RU,    0x1.0bf3d3e453816p-4,    0x1.114e944b2de18p+0,   0x1.ffffc4p-1, INEXACT)
T(RN,   -0x1.72dc55c42647ep-4,    0x1.d3addc3974d29p-1,  -0x1.ffff56p-2, INEXACT)
T(RN,   -0x1.719d01b9c4da8p-4,    0x1.d3d253982cbfbp-1,   -0x1.ffff6p-2, INEXACT)
T(RU,   -0x1.fb370fb85428ep-4,    0x1.c45dd6aa5c1ecp-1,   0x1.cff39p-19, INEXACT)
T(RZ,   -0x1.fb370fb85428ep-4,    0x1.c45dd6aa5c1ebp-1,  -0x1.ffff8cp-1, INEXACT)
T(RN,    0x1.b063efef465fdp-4,    0x1.1c8099cb35e24p+0,  -0x1.ffffd2p-2, INEXACT)
T(RN,   -0x1.7a4f627bdc4dep-4,    0x1.d2d44fec861a6p-1,  -0x1.ffff64p-2, INEXACT)
T(RN,    0x1.bfb965d1c5918p-4,    0x1.1d91c4c7839aap+0,  -0x1.ffff9ap-2, INEXACT)
T(RZ,    0x1.552adc9c815a8p-3,    0x1.2e675d4f635fep+0, -0x1.1c17aep-19, INEXACT)
T(RU,    0x1.552adc9c815a8p-3,    0x1.2e675d4f635ffp+0,   0x1.ffffb8p-1, INEXACT)
T(RN,    0x1.5f1ace2a4ba8dp-3,    0x1.2fdfe94066093p+0,  -0x1.ffff2cp-2, INEXACT)
T(RN,    0x1.d43c420261995p-3,    0x1.41c2bb23e343ep+0,  -0x1.ffff8ap-2, INEXACT)
T(RZ,    0x1.43478a9214c6ap-3,    0x1.2bc6229ac0bc4p+0,  -0x1.75e08p-19, INEXACT)
T(RU,    0x1.43478a9214c6ap-3,    0x1.2bc6229ac0bc5p+0,   0x1.ffffa2p-1, INEXACT)
T(RU,   -0x1.5e0dab6be8659p-3,    0x1.af8ea62306e16p-1,  0x1.8633e2p-22, INEXACT)
T(RZ,   -0x1.5e0dab6be8659p-3,    0x1.af8ea62306e15p-1,  -0x1.fffff4p-1, INEXACT)
T(RN,    0x1.b9c8be5c24d0ep-3,    0x1.3da1b38437b2ap+0,   -0x1.ffff3p-2, INEXACT)
T(RN,    0x1.4c3201f9717eap-3,    0x1.2d14f50c2d38ep+0,  -0x1.ffffbcp-2, INEXACT)
T(RU,    0x1.949378eabb8ebp-2,    0x1.7c09ba97f880ep+0,  0x1.41fb16p-19, INEXACT)
T(RZ,    0x1.949378eabb8ebp-2,    0x1.7c09ba97f880dp+0,   -0x1.ffffbp-1, INEXACT)
T(RU,   -0x1.eff07e2ac9698p-2,    0x1.3b73e4c5654b2p-1,  0x1.03e9a4p-19, INEXACT)
T(RZ,   -0x1.eff07e2ac9698p-2,    0x1.3b73e4c5654b1p-1,   -0x1.ffffcp-1, INEXACT)
T(RZ,   -0x1.2067d84c2bd94p-2,    0x1.825326a481b47p-1, -0x1.184a24p-19, INEXACT)
T(RU,   -0x1.2067d84c2bd94p-2,    0x1.825326a481b48p-1,   0x1.ffffbap-1, INEXACT)
T(RZ,    -0x1.62d9212efa02p-2,    0x1.6a0dcf3fd52fep-1, -0x1.560b76p-20, INEXACT)
T(RU,    -0x1.62d9212efa02p-2,    0x1.6a0dcf3fd52ffp-1,   0x1.ffffd6p-1, INEXACT)
T(RN,   -0x1.896984b35cd53p-2,     0x1.5cac27f2b3b9p-1,   -0x1.ffff4p-2, INEXACT)
T(RN,    0x1.0c36dc53bfd97p-2,    0x1.4ca7a45d6e767p+0,  -0x1.ffff1ep-2, INEXACT)
T(RN,   -0x1.46e6114f79004p-2,    0x1.741274257f274p-1,  -0x1.ffff54p-2, INEXACT)
T(RN,   -0x1.595fc50305fcfp-2,    0x1.6d6b51b7cd5cap-1,  -0x1.ffffd4p-2, INEXACT)
T(RN,    0x1.9a72707b20815p-2,    0x1.7e3920e08ff9dp+0,  -0x1.ffff74p-2, INEXACT)
T(RN,   -0x1.f373dff8844e6p-1,    0x1.820def43717d2p-2,  -0x1.ffff2ap-2, INEXACT)
T(RN,   -0x1.0527cb8e41d8ap-1,     0x1.336eb5056631p-1,  -0x1.ffff78p-2, INEXACT)
T(RN,   -0x1.3cdacc9ff4695p-1,     0x1.13be1afa1994p-1,   -0x1.ffff7p-2, INEXACT)
T(RU,   -0x1.18257632b24e5p-1,    0x1.283cf9ca622b7p-1,  0x1.697364p-19, INEXACT)
T(RZ,   -0x1.18257632b24e5p-1,    0x1.283cf9ca622b6p-1,  -0x1.ffffa6p-1, INEXACT)
T(RZ,    0x1.a8238af3a209dp-1,    0x1.25130a9312756p+1, -0x1.3b537ap-19, INEXACT)
T(RU,    0x1.a8238af3a209dp-1,    0x1.25130a9312757p+1,   0x1.ffffb2p-1, INEXACT)
T(RZ,    0x1.72d5c6e915077p-1,    0x1.0818e70b7c8c8p+1, -0x1.22e3bep-22, INEXACT)
T(RU,    0x1.72d5c6e915077p-1,    0x1.0818e70b7c8c9p+1,   0x1.fffff6p-1, INEXACT)
T(RZ,   -0x1.18380299d7ab4p-1,    0x1.28323e9b032c8p-1, -0x1.2cfc0ep-19, INEXACT)
T(RU,   -0x1.18380299d7ab4p-1,    0x1.28323e9b032c9p-1,   0x1.ffffb4p-1, INEXACT)
T(RN,    0x1.4ace261028c43p-1,    0x1.e878bfa082046p+0,   -0x1.ffffbp-2, INEXACT)
T(RN,    0x1.77c7632ea64afp-1,    0x1.0aa8e2a271785p+1,  -0x1.ffff44p-2, INEXACT)
T(RU,    0x1.3ad1dca575333p-1,    0x1.d974d62ecf922p+0,  0x1.876e88p-19, INEXACT)
T(RZ,    0x1.3ad1dca575333p-1,    0x1.d974d62ecf921p+0,  -0x1.ffff9ep-1, INEXACT)
T(RU,   -0x1.fbbddc3138307p-1,    0x1.7bdad02617e5ep-2,  0x1.2f62bap-22, INEXACT)
T(RZ,   -0x1.fbbddc3138307p-1,    0x1.7bdad02617e5dp-2,  -0x1.fffff6p-1, INEXACT)
T(RZ,    0x1.0128820c68ca4p-1,    0x1.a7074dabb618ap+0, -0x1.134beep-19, INEXACT)
T(RU,    0x1.0128820c68ca4p-1,    0x1.a7074dabb618bp+0,   0x1.ffffbcp-1, INEXACT)
T(RZ,   -0x1.37245e709040ap-1,    0x1.16d61f2d3ee7ep-1, -0x1.2e956ep-20, INEXACT)
T(RU,   -0x1.37245e709040ap-1,    0x1.16d61f2d3ee7fp-1,   0x1.ffffdap-1, INEXACT)
T(RU,   -0x1.ebfa512e5e7ddp+0,    0x1.2bb6f040e6385p-3,  0x1.ff6feep-24, INEXACT)
T(RZ,   -0x1.ebfa512e5e7ddp+0,    0x1.2bb6f040e6384p-3,  -0x1.fffffcp-1, INEXACT)
T(RN,   -0x1.37050274a4976p+0,    0x1.2fdaf5386ba63p-2,  -0x1.ffff52p-2, INEXACT)
T(RU,    0x1.c91c31ce51615p+0,    0x1.7da309c14f28fp+2,  0x1.02e0ecp-20, INEXACT)
T(RZ,    0x1.c91c31ce51615p+0,    0x1.7da309c14f28ep+2,   -0x1.ffffep-1, INEXACT)
T(RN,   -0x1.b3071aafeb539p+0,    0x1.76633ee533197p-3,  -0x1.ffff28p-2, INEXACT)
T(RU,    0x1.7b9ae10c221adp+0,    0x1.19f224829ccf9p+2,  0x1.c90838p-19, INEXACT)
T(RZ,    0x1.7b9ae10c221adp+0,    0x1.19f224829ccf8p+2,  -0x1.ffff8ep-1, INEXACT)
T(RN,    0x1.59385fe803444p+0,    0x1.ed04bd2ff915ap+1,  -0x1.ffff84p-2, INEXACT)
T(RN,   -0x1.d93b3fe2cce29p+0,    0x1.427c53fe51c6ap-3,  -0x1.ffff92p-2, INEXACT)
T(RN,   -0x1.9427c8e8abc84p+0,    0x1.a65f48912b572p-3,   -0x1.ffff1p-2, INEXACT)
T(RN,    0x1.f3e29c1b62312p+1,    0x1.8d5745c72bb33p+5,  -0x1.ffff6ep-2, INEXACT)
T(RZ,   -0x1.97f3d9462158bp+1,    0x1.523fe7c927795p-5, -0x1.03a0d8p-19, INEXACT)
T(RU,   -0x1.97f3d9462158bp+1,    0x1.523fe7c927796p-5,    0x1.ffffcp-1, INEXACT)
T(RZ,   -0x1.9911caf9d1837p+1,    0x1.4f4f90587409fp-5, -0x1.03893cp-22, INEXACT)
T(RU,   -0x1.9911caf9d1837p+1,     0x1.4f4f9058740ap-5,   0x1.fffff8p-1, INEXACT)
T(RN,     0x1.b6f14df48f63p+1,    0x1.eda686590430cp+4,  -0x1.ffff06p-2, INEXACT)
T(RN,   -0x1.a88c5687c4855p+1,    0x1.291e4cb5536d4p-5,  -0x1.ffff8cp-2, INEXACT)
T(RN,   -0x1.728f3d6334ec8p+1,    0x1.c502e2f18a4c1p-5,  -0x1.ffff9cp-2, INEXACT)
T(RU,   -0x1.c9b61c18b73edp+1,    0x1.ca9b0587dc44dp-6,  0x1.4b6316p-19, INEXACT)
T(RZ,   -0x1.c9b61c18b73edp+1,    0x1.ca9b0587dc44cp-6,  -0x1.ffffaep-1, INEXACT)
T(RN,   -0x1.7be041ba8f8f9p+1,    0x1.a535d1d0ab60fp-5,  -0x1.ffffbap-2, INEXACT)
T(RU,   -0x1.339055520e2c7p+2,    0x1.0c24ce525aedap-7,  0x1.62d3bap-20, INEXACT)
T(RZ,   -0x1.339055520e2c7p+2,    0x1.0c24ce525aed9p-7,  -0x1.ffffd4p-1, INEXACT)
T(RU,   -0x1.c70b8be18d46cp+2,   0x1.ac410c3613876p-11,  0x1.8d81b4p-19, INEXACT)
T(RZ,   -0x1.c70b8be18d46cp+2,   0x1.ac410c3613875p-11,  -0x1.ffff9cp-1, INEXACT)
T(RZ,   -0x1.cc3fb26ad8843p+2,   0x1.8acfc4b991fa8p-11, -0x1.2d0998p-20, INEXACT)
T(RU,   -0x1.cc3fb26ad8843p+2,   0x1.8acfc4b991fa9p-11,   0x1.ffffdap-1, INEXACT)
T(RU,    0x1.99bcdc76c1607p+2,    0x1.2d922372962a4p+9,  0x1.9e88ecp-21, INEXACT)
T(RZ,    0x1.99bcdc76c1607p+2,    0x1.2d922372962a3p+9,  -0x1.ffffe6p-1, INEXACT)
T(RN,   -0x1.ef9bc6d4aabf2p+2,   0x1.c6700aeb41c69p-12,  -0x1.ffffc8p-2, INEXACT)
T(RZ,    -0x1.3abd053686a2p+2,     0x1.df6a692441c5p-8, -0x1.112fb2p-20, INEXACT)
T(RU,    -0x1.3abd053686a2p+2,    0x1.df6a692441c51p-8,   0x1.ffffdep-1, INEXACT)
T(RN,    0x1.51b534f025e82p+2,    0x1.8770a1be5fbf2p+7,  -0x1.ffff4cp-2, INEXACT)
T(RU,   -0x1.819af873829b5p+3,   0x1.8827e7490ce01p-18,   0x1.a31d1p-19, INEXACT)
T(RZ,   -0x1.819af873829b5p+3,     0x1.8827e7490cep-18,  -0x1.ffff98p-1, INEXACT)
T(RU,    0x1.9848441cd7cd9p+3,   0x1.5375348852d5ap+18,  0x1.667568p-20, INEXACT)
T(RZ,    0x1.9848441cd7cd9p+3,   0x1.5375348852d59p+18,  -0x1.ffffd4p-1, INEXACT)
T(RN,   -0x1.8fbf753f47ca4p+3,   0x1.f823a67bc16a1p-19,  -0x1.ffff6ep-2, INEXACT)
T(RN,    0x1.028dfd9304309p+3,   0x1.939630b0450d5p+11,  -0x1.ffffa8p-2, INEXACT)
T(RN,   -0x1.ef81d395de87bp+3,   0x1.94a068074d6ddp-23,  -0x1.ffffc4p-2, INEXACT)
T(RN,    0x1.c1a5b20217977p+3,   0x1.351d32a5711d6p+20,  -0x1.ffff42p-2, INEXACT)
T(RN,   -0x1.20f54cac3b98ap+3,   0x1.f6593a0a8d5bep-14,  -0x1.ffff48p-2, INEXACT)
T(RZ,    0x1.d6154e3f8daabp+4,   0x1.4eb003e0bbb47p+42, -0x1.7fa3b8p-19, INEXACT)
T(RU,    0x1.d6154e3f8daabp+4,   0x1.4eb003e0bbb48p+42,    0x1.ffffap-1, INEXACT)
T(RN,   -0x1.01fd8acff3d05p+4,   0x1.aacc2d542501cp-24,  -0x1.ffffc6p-2, INEXACT)
T(RU,    0x1.e20b36bafd2abp+4,   0x1.61651ef827777p+43,  0x1.4f936ap-21, INEXACT)
T(RZ,    0x1.e20b36bafd2abp+4,   0x1.61651ef827776p+43,  -0x1.ffffecp-1, INEXACT)
T(RN,    0x1.15375335ab906p+4,   0x1.fea2300530753p+24,  -0x1.ffff76p-2, INEXACT)
T(RN,   -0x1.495078aadc9b2p+4,   0x1.3c89fd80eb9cep-30,  -0x1.ffffe6p-2, INEXACT)
T(RN,   -0x1.901395a1735dep+4,   0x1.e64ecbe7cbf3cp-37,  -0x1.ffff9cp-2, INEXACT)
T(RN,   -0x1.d03634376f802p+4,   0x1.1aa0572aa523bp-42,  -0x1.ffff52p-2, INEXACT)
T(RN,   -0x1.8f9cf3a447233p+4,   0x1.f4994611694b7p-37,  -0x1.ffff7ap-2, INEXACT)
T(RN,    0x1.45b59764064a6p+5,   0x1.aacc0c2f948d7p+58,  -0x1.ffff16p-2, INEXACT)
T(RZ,    0x1.de2e11814645ep+5,   0x1.2cf899e99171bp+86, -0x1.4a5108p-19, INEXACT)
T(RU,    0x1.de2e11814645ep+5,   0x1.2cf899e99171cp+86,   0x1.ffffaep-1, INEXACT)
T(RZ,    0x1.1f9e9949cf3fcp+5,   0x1.d35d9ee97c13ap+51, -0x1.bc418ap-19, INEXACT)
T(RU,    0x1.1f9e9949cf3fcp+5,   0x1.d35d9ee97c13bp+51,    0x1.ffff9p-1, INEXACT)
T(RN,   -0x1.ecfe9ef0166e9p+5,   0x1.1167614b78854p-89,  -0x1.ffff62p-2, INEXACT)
T(RU,    -0x1.142350c79367p+5,   0x1.2681058969cb8p-50,  0x1.ee096cp-20, INEXACT)
T(RZ,    -0x1.142350c79367p+5,   0x1.2681058969cb7p-50,  -0x1.ffffc2p-1, INEXACT)
T(RZ,   -0x1.a8f8e1852a918p+5,   0x1.48f9fec1df309p-77, -0x1.05099cp-22, INEXACT)
T(RU,   -0x1.a8f8e1852a918p+5,   0x1.48f9fec1df30ap-77,   0x1.fffff8p-1, INEXACT)
T(RZ,    0x1.0e6dc93fa080cp+5,   0x1.b4089972f7b11p+48, -0x1.80f662p-25, INEXACT)
T(RU,    0x1.0e6dc93fa080cp+5,   0x1.b4089972f7b12p+48,   0x1.fffffep-1, INEXACT)
T(RN,   -0x1.5dd445f2472e1p+5,   0x1.e20079963e326p-64,  -0x1.ffffecp-2, INEXACT)
T(RN,   -0x1.d69231b3923d9p+5,   0x1.19d478a695249p-85,  -0x1.ffffacp-2, INEXACT)
T(RN,   -0x1.d81aceaf28b04p+6,   0x1.a6e9b4165441p-171,  -0x1.ffff02p-2, INEXACT)
T(RU,   -0x1.e8e164f05b7b2p+6,  0x1.9858c740d579dp-177,  0x1.bd6ba2p-19, INEXACT)
T(RZ,   -0x1.e8e164f05b7b2p+6,  0x1.9858c740d579cp-177,   -0x1.ffff9p-1, INEXACT)
T(RU,    0x1.628d10382b1a6p+6,  0x1.d63d61164ee18p+127,  0x1.52d3a2p-19, INEXACT)
T(RZ,    0x1.628d10382b1a6p+6,  0x1.d63d61164ee17p+127,  -0x1.ffffacp-1, INEXACT)
T(RN,   -0x1.a646232a5bfa4p+6,  0x1.9ef7eddecbf0dp-153,   -0x1.ffff1p-2, INEXACT)
T(RN,   -0x1.296d8697a899bp+7,  0x1.5dfd5e41fdd25p-215,  -0x1.ffffccp-2, INEXACT)
T(RU,    0x1.33af0776536aap+7,  0x1.ed7da952987b6p+221,  0x1.1c43ecp-20, INEXACT)
T(RZ,    0x1.33af0776536aap+7,  0x1.ed7da952987b5p+221,  -0x1.ffffdcp-1, INEXACT)
T(RZ,   -0x1.2dfd74c3d4fbap+7,  0x1.1e118a0535362p-218, -0x1.95eec2p-19, INEXACT)
T(RU,   -0x1.2dfd74c3d4fbap+7,  0x1.1e118a0535363p-218,   0x1.ffff9ap-1, INEXACT)
T(RN,   -0x1.5327a662727e1p+7,  0x1.469e8d0777674p-245,   -0x1.ffffcp-2, INEXACT)
T(RN,    0x1.f73ee8905816fp+7,  0x1.02afe1890fb1fp+363,  -0x1.ffffe6p-2, INEXACT)
T(RU,   -0x1.15968459b03d8p+7,  0x1.b251fddcdf90cp-201,  0x1.b03dacp-21, INEXACT)
T(RZ,   -0x1.15968459b03d8p+7,  0x1.b251fddcdf90bp-201,  -0x1.ffffe4p-1, INEXACT)
T(RN,   -0x1.bda2341be94afp+7,  0x1.7511e44dbdce3p-322,  -0x1.ffff9cp-2, INEXACT)
T(RN,    0x1.cd59cb603a7fcp+7,  0x1.bbf113923545cp+332,  -0x1.ffff5ep-2, INEXACT)
T(RZ,   -0x1.b0aa6e2e7d208p+7,  0x1.dcee7d8a5cb34p-313, -0x1.ce8aaap-19, INEXACT)
T(RU,   -0x1.b0aa6e2e7d208p+7,  0x1.dcee7d8a5cb35p-313,   0x1.ffff8cp-1, INEXACT)
T(RU,   -0x1.e3932d610e759p+8,  0x1.46086c18fa97bp-698,  0x1.5afb48p-22, INEXACT)
T(RZ,   -0x1.e3932d610e759p+8,  0x1.46086c18fa97ap-698,  -0x1.fffff6p-1, INEXACT)
T(RU,    0x1.0614438c9efbcp+8,  0x1.126e44eeaeafbp+378,  0x1.f5752ap-19, INEXACT)
T(RZ,    0x1.0614438c9efbcp+8,  0x1.126e44eeaeafap+378,  -0x1.ffff82p-1, INEXACT)
T(RN,   -0x1.08ae34f3ba5a3p+8,  0x1.1b69b5782f475p-382,  -0x1.ffff08p-2, INEXACT)
T(RZ,   -0x1.8805f1979d321p+8,  0x1.58e73c5f9fb2cp-566, -0x1.3ee412p-22, INEXACT)
T(RU,   -0x1.8805f1979d321p+8,  0x1.58e73c5f9fb2dp-566,   0x1.fffff6p-1, INEXACT)
T(RN,    0x1.562e2f77dc961p+8,  0x1.950ebdb8c3448p+493,  -0x1.ffff1cp-2, INEXACT)
T(RZ,    0x1.d08300a6e35d9p+8,  0x1.1bcea542465bfp+670, -0x1.cf261ep-19, INEXACT)
T(RU,    0x1.d08300a6e35d9p+8,   0x1.1bcea542465cp+670,   0x1.ffff8cp-1, INEXACT)
T(RN,   -0x1.c83bf971e511ep+8,  0x1.bb96545ed4295p-659,  -0x1.ffff84p-2, INEXACT)
T(RZ,    0x1.c2f50d9e0671ap+8,  0x1.825a22d1c2913p+650, -0x1.4d51eap-19, INEXACT)
T(RU,    0x1.c2f50d9e0671ap+8,  0x1.825a22d1c2914p+650,   0x1.ffffacp-1, INEXACT)
T(RN,   -0x1.4701089ef7592p+8,  0x1.2cd95fdd19294p-472,  -0x1.ffff02p-2, INEXACT)
T(RU,   0x1.7edd109e50998p-15,    0x1.0002fdbe9a721p+0,  0x1.a5945ep-21, INEXACT)
T(RZ,   0x1.7edd109e50998p-15,     0x1.0002fdbe9a72p+0,  -0x1.ffffe6p-1, INEXACT)
T(RN,  -0x1.38b5bbbaf18a5p-15,    0x1.fffb1d2f08fd4p-1,  -0x1.ffffdcp-2, INEXACT)
T(RU,  -0x1.c7cea0e08f561p-15,    0x1.fff8e0d22aaf5p-1,  0x1.87c88ap-21, INEXACT)
T(RZ,  -0x1.c7cea0e08f561p-15,    0x1.fff8e0d22aaf4p-1,  -0x1.ffffe8p-1, INEXACT)
T(RU,   0x1.661586f645a41p-15,    0x1.0002cc2ef7b0ap+0,  0x1.fb9d12p-21, INEXACT)
T(RZ,   0x1.661586f645a41p-15,    0x1.0002cc2ef7b09p+0,   -0x1.ffffep-1, INEXACT)
T(RN,  -0x1.1099c4d5b2922p-15,    0x1.fffbbd9d75c27p-1,  -0x1.ffffcap-2, INEXACT)
T(RN,   0x1.02cc1a2f1c2c6p-15,    0x1.0002059a3f9fap+0,  -0x1.ffffc8p-2, INEXACT)
T(RN,  -0x1.efa631698255fp-15,    0x1.fff8417638d71p-1,  -0x1.ffffccp-2, INEXACT)
T(RN,  -0x1.c966724ae19c7p-15,    0x1.fff8da72fbc0fp-1,  -0x1.ffffc2p-2, INEXACT)
T(RN,   0x1.9959f511d1874p-15,    0x1.000332b9074a3p+0,   -0x1.ffffep-2, INEXACT)
T(RU,   0x1.f6fdc6500b184p-14,    0x1.0007dc15fbd32p+0,  0x1.68101ap-21, INEXACT)
T(RZ,   0x1.f6fdc6500b184p-14,    0x1.0007dc15fbd31p+0,  -0x1.ffffeap-1, INEXACT)
T(RN,  -0x1.d9ae86df59407p-14,    0x1.fff132c28fe46p-1,  -0x1.ffffe2p-2, INEXACT)
T(RN,  -0x1.944270ef1232ap-14,    0x1.fff35e145e4fcp-1,   -0x1.ffffep-2, INEXACT)
T(RN,   0x1.df2b335ce2362p-14,     0x1.00077cc8d4cfp+0,  -0x1.ffffd8p-2, INEXACT)
T(RN,   0x1.20f53ca79973ep-14,    0x1.000483df23f35p+0,  -0x1.ffffd2p-2, INEXACT)
T(RZ,   0x1.2c6c366c8e19ap-14,    0x1.0004b1bbde31ep+0,  -0x1.00b2cp-21, INEXACT)
T(RU,   0x1.2c6c366c8e19ap-14,    0x1.0004b1bbde31fp+0,    0x1.fffffp-1, INEXACT)
T(RU,  -0x1.9a5b9c1a63eadp-14,    0x1.fff32d4c3b6e1p-1,  0x1.fea322p-22, INEXACT)
T(RZ,  -0x1.9a5b9c1a63eadp-14,     0x1.fff32d4c3b6ep-1,   -0x1.fffffp-1, INEXACT)
T(RN,   0x1.1a1bad3763358p-14,    0x1.000468786bf3bp+0,  -0x1.ffffe6p-2, INEXACT)
T(RN,  -0x1.0f72f5282879dp-14,    0x1.fff7847a53eebp-1,  -0x1.fffff2p-2, INEXACT)
T(RU,   0x1.b2097351d966dp-13,    0x1.000d90a798b02p+0,  0x1.37bd7ap-21, INEXACT)
T(RZ,   0x1.b2097351d966dp-13,    0x1.000d90a798b01p+0,  -0x1.ffffecp-1, INEXACT)
T(RU,   0x1.e7dcf1ebfd3a2p-13,    0x1.000f3f5bc8fa7p+0,  0x1.95a99cp-24, INEXACT)
T(RZ,   0x1.e7dcf1ebfd3a2p-13,    0x1.000f3f5bc8fa6p+0,  -0x1.fffffcp-1, INEXACT)
T(RU,   0x1.c142cc9926222p-13,    0x1.000e0a78f402dp+0,  0x1.f504f4p-22, INEXACT)
T(RZ,   0x1.c142cc9926222p-13,    0x1.000e0a78f402cp+0,   -0x1.fffffp-1, INEXACT)
T(RZ,  -0x1.75500bf4fe231p-13,    0x1.ffe8ab875735ep-1, -0x1.191832p-21, INEXACT)
T(RU,  -0x1.75500bf4fe231p-13,    0x1.ffe8ab875735fp-1,   0x1.ffffeep-1, INEXACT)
T(RZ,   0x1.21cdbf135b45cp-13,    0x1.00090e96fb5c8p+0, -0x1.66f42cp-24, INEXACT)
T(RU,   0x1.21cdbf135b45cp-13,    0x1.00090e96fb5c9p+0,   0x1.fffffep-1, INEXACT)
T(RU,   0x1.ff7dcd73e443ap-13,    0x1.000ffc6e2d36dp+0,  0x1.38b1c8p-22, INEXACT)
T(RZ,   0x1.ff7dcd73e443ap-13,    0x1.000ffc6e2d36cp+0,  -0x1.fffff6p-1, INEXACT)
T(RN,  -0x1.a8091ae46b34cp-13,    0x1.ffe5801de63c1p-1,  -0x1.ffffc2p-2, INEXACT)
T(RN,   0x1.7635a3ec06eafp-13,    0x1.000bb1f180838p+0,  -0x1.ffffd8p-2, INEXACT)
T(RN,   0x1.3554568c3a8ecp-13,    0x1.0009aad16d8efp+0,  -0x1.ffffcap-2, INEXACT)
T(RN,   0x1.11122694b66ddp-13,    0x1.000888b59e043p+0,  -0x1.ffffe8p-2, INEXACT)
T(RU,   0x1.a98e79c3aff89p-12,     0x1.001a9a495dabp+0,  0x1.211f76p-22, INEXACT)
T(RZ,   0x1.a98e79c3aff89p-12,    0x1.001a9a495daafp+0,  -0x1.fffff6p-1, INEXACT)
T(RU,   -0x1.0c0c63e2f99ep-12,    0x1.ffde7f8c27735p-1,   0x1.a7dd7p-21, INEXACT)
T(RZ,   -0x1.0c0c63e2f99ep-12,    0x1.ffde7f8c27734p-1,  -0x1.ffffe6p-1, INEXACT)
T(RU,   0x1.a39a61a32ac3fp-12,    0x1.001a3afe074d7p+0,  0x1.6a660ap-21, INEXACT)
T(RZ,   0x1.a39a61a32ac3fp-12,    0x1.001a3afe074d6p+0,  -0x1.ffffeap-1, INEXACT)
T(RN,  -0x1.2ab3effeed9abp-12,    0x1.ffdaaade7f12cp-1,  -0x1.ffffdep-2, INEXACT)
T(RN,  -0x1.15f82f29ce0e9p-12,    0x1.ffdd4227e6f92p-1,  -0x1.fffff8p-2, INEXACT)
T(RZ,   0x1.4b29d81dca89dp-11,     0x1.00296893fc61p+0,  -0x1.7d0bap-21, INEXACT)
T(RU,   0x1.4b29d81dca89dp-11,    0x1.00296893fc611p+0,   0x1.ffffe8p-1, INEXACT)
T(RU,  -0x1.a09851144c62dp-11,    0x1.ff97e482c0a01p-1,  0x1.0e2fd2p-24, INEXACT)
T(RZ,  -0x1.a09851144c62dp-11,      0x1.ff97e482c0ap-1,  -0x1.fffffep-1, INEXACT)
T(RU,  -0x1.9544477f1a81ap-11,    0x1.ff9ab8f3bb6d3p-1,  0x1.84a5b4p-22, INEXACT)
T(RZ,  -0x1.9544477f1a81ap-11,    0x1.ff9ab8f3bb6d2p-1,  -0x1.fffff4p-1, INEXACT)
T(RN,   0x1.508e37253cd7ep-11,    0x1.002a153c00627p+0,  -0x1.ffffdap-2, INEXACT)
T(RZ,  -0x1.ae6e0986c054bp-10,    0x1.ff28f63044511p-1, -0x1.29843ap-22, INEXACT)
T(RU,  -0x1.ae6e0986c054bp-10,    0x1.ff28f63044512p-1,   0x1.fffff6p-1, INEXACT)
T(RU,   0x1.b2aa78376f23dp-10,    0x1.006cc1b185246p+0,   0x1.5c5aep-21, INEXACT)
T(RZ,   0x1.b2aa78376f23dp-10,    0x1.006cc1b185245p+0,  -0x1.ffffeap-1, INEXACT)
T(RU,  -0x1.77cce87c09448p-10,    0x1.ff443c0229ebap-1,  0x1.024856p-21, INEXACT)
T(RZ,  -0x1.77cce87c09448p-10,    0x1.ff443c0229eb9p-1,   -0x1.fffffp-1, INEXACT)
T(RN,  -0x1.ffc0f535b757ep-10,    0x1.ff005f6afe043p-1,  -0x1.ffffcap-2, INEXACT)
T(RZ,  -0x1.535932fd73e78p-10,    0x1.ff566f80bc3c3p-1, -0x1.35aeb4p-22, INEXACT)
T(RU,  -0x1.535932fd73e78p-10,    0x1.ff566f80bc3c4p-1,   0x1.fffff6p-1, INEXACT)
T(RN,  -0x1.8abc20d0c6dcfp-10,    0x1.ff3ac7f52eb24p-1,  -0x1.ffffc4p-2, INEXACT)
T(RU,   0x1.f3331ee4bb0e9p-10,    0x1.007ceb382de67p+0,   0x1.2dce7p-21, INEXACT)
T(RZ,   0x1.f3331ee4bb0e9p-10,    0x1.007ceb382de66p+0,  -0x1.ffffeep-1, INEXACT)
T(RN,   0x1.db6f0123c400fp-10,    0x1.0076f75c37954p+0,  -0x1.ffffd2p-2, INEXACT)
T(RZ,   0x1.41611e6f55f72p-10,    0x1.005064e49332fp+0, -0x1.c1ca92p-21, INEXACT)
T(RU,   0x1.41611e6f55f72p-10,     0x1.005064e49333p+0,   0x1.ffffe4p-1, INEXACT)
T(RN,   0x1.81c84ae541bd6p-10,    0x1.0060843fe2062p+0,  -0x1.ffffd8p-2, INEXACT)
T(RN,   0x1.6b1e4f9dd6d2ap-10,    0x1.005ad7ae4678bp+0,         -0x1p-1, INEXACT)
T(RN,  -0x1.b4ebd3d894e14p-10,    0x1.ff25b8aab5a5bp-1,  -0x1.fffff8p-2, INEXACT)
T(RU,   -0x1.c7c9c7e72bc12p-9,    0x1.fe3900dbabdeep-1,  0x1.11a788p-22, INEXACT)
T(RZ,   -0x1.c7c9c7e72bc12p-9,    0x1.fe3900dbabdedp-1,  -0x1.fffff8p-1, INEXACT)
T(RN,   -0x1.d818c2e825f14p-9,    0x1.fe28c0a116196p-1,  -0x1.ffffc8p-2, INEXACT)
T(RN,    0x1.254496c1974fdp-9,    0x1.0092cc5229042p+0,  -0x1.ffffc8p-2, INEXACT)
T(RZ,    0x1.97727285c1344p-9,    0x1.00cc0a5e6b416p+0, -0x1.c7e2fcp-23, INEXACT)
T(RU,    0x1.97727285c1344p-9,    0x1.00cc0a5e6b417p+0,   0x1.fffff8p-1, INEXACT)
T(RZ,    0x1.848811b2f5508p-9,    0x1.00c28dd119d52p+0,  -0x1.f04a3p-23, INEXACT)
T(RU,    0x1.848811b2f5508p-9,    0x1.00c28dd119d53p+0,   0x1.fffff8p-1, INEXACT)
T(RZ,   -0x1.d376a56dccea7p-9,    0x1.fe2d5e80347ecp-1, -0x1.c90086p-21, INEXACT)
T(RU,   -0x1.d376a56dccea7p-9,    0x1.fe2d5e80347edp-1,   0x1.ffffe4p-1, INEXACT)
T(RZ,    0x1.5e044e9ff0196p-9,    0x1.00af3e06ecdccp+0, -0x1.53b764p-21, INEXACT)
T(RU,    0x1.5e044e9ff0196p-9,    0x1.00af3e06ecdcdp+0,   0x1.ffffeap-1, INEXACT)
T(RZ,    -0x1.998ef5be35e1p-9,    0x1.fe6714ad2460ap-1, -0x1.1b2196p-22, INEXACT)
T(RU,    -0x1.998ef5be35e1p-9,    0x1.fe6714ad2460bp-1,   0x1.fffff8p-1, INEXACT)
T(RN,   -0x1.08f84afee0f69p-9,    0x1.fef74c3971a59p-1,  -0x1.fffff4p-2, INEXACT)
T(RN,    0x1.a471439b2e4edp-9,    0x1.00d28f09edceep+0,  -0x1.ffffe6p-2, INEXACT)
T(RN,    -0x1.5d7cfa03b999p-9,     0x1.fea2fa325ccbp-1,  -0x1.ffffeap-2, INEXACT)
T(RZ,   -0x1.545b3e7c62a58p-8,    0x1.fd590d3d3e1dbp-1, -0x1.aeadb4p-22, INEXACT)
T(RU,   -0x1.545b3e7c62a58p-8,    0x1.fd590d3d3e1dcp-1,   0x1.fffff2p-1, INEXACT)
T(RN,     0x1.6ecf5ba75a0fp-8,    0x1.016fd6a420f8ap+0,  -0x1.ffffe8p-2, INEXACT)
T(RZ,    0x1.c78b5b67cbf28p-8,    0x1.01c9219c926d5p+0, -0x1.d9d702p-22, INEXACT)
T(RU,    0x1.c78b5b67cbf28p-8,    0x1.01c9219c926d6p+0,   0x1.fffff2p-1, INEXACT)
T(RN,   -0x1.a92a15b311662p-8,    0x1.fcb06c6b17a5dp-1,  -0x1.ffffd8p-2, INEXACT)
T(RN,   -0x1.3fe7026b95249p-8,    0x1.fd81c11661a9cp-1,  -0x1.fffff4p-2, INEXACT)
T(RZ,    0x1.2e8a6bd92cb56p-7,    0x1.025fe22226b03p+0, -0x1.ec605ap-21, INEXACT)
T(RU,    0x1.2e8a6bd92cb56p-7,    0x1.025fe22226b04p+0,   0x1.ffffe2p-1, INEXACT)
T(RU,    0x1.e128aa48c1888p-7,    0x1.03c96aeaec3f3p+0,  0x1.19569ap-21, INEXACT)
T(RZ,    0x1.e128aa48c1888p-7,    0x1.03c96aeaec3f2p+0,  -0x1.ffffeep-1, INEXACT)
T(RZ,    0x1.84edc18fce391p-7,     0x1.030e7df6bc45p+0,  -0x1.26221p-24, INEXACT)
T(RU,    0x1.84edc18fce391p-7,    0x1.030e7df6bc451p+0,   0x1.fffffep-1, INEXACT)
T(RU,   -0x1.62e17c350b17cp-7,    0x1.fa7c22cb056c6p-1,   0x1.26d2fp-22, INEXACT)
T(RZ,   -0x1.62e17c350b17cp-7,    0x1.fa7c22cb056c5p-1,  -0x1.fffff6p-1, INEXACT)
T(RN,    0x1.3b12664086552p-7,    0x1.02792ed6f1c74p+0,  -0x1.ffffecp-2, INEXACT)
T(RZ,   -0x1.475a9c0d49e0dp-6,    0x1.f5df2846f9f99p-1,  -0x1.a1256p-21, INEXACT)
T(RU,   -0x1.475a9c0d49e0dp-6,    0x1.f5df2846f9f9ap-1,   0x1.ffffe6p-1, INEXACT)
T(RN,    0x1.50602528f61bcp-6,    0x1.054f68cb78357p+0,  -0x1.fffffap-2, INEXACT)
T(RU,   -0x1.43e9836b00d95p-6,    0x1.f5fa2655d8dd2p-1,  0x1.1571b6p-26, INEXACT)
T(RZ,   -0x1.43e9836b00d95p-6,    0x1.f5fa2655d8dd1p-1,         -0x1p+0, INEXACT)
T(RN,    0x1.1ad731ba1094dp-6,    0x1.04752f3012c1cp+0,  -0x1.ffffe6p-2, INEXACT)
T(RZ,    0x1.8d082fd3e3739p-6,    0x1.064786daf9327p+0, -0x1.9f339cp-23, INEXACT)
T(RU,    0x1.8d082fd3e3739p-6,    0x1.064786daf9328p+0,   0x1.fffffap-1, INEXACT)
T(RN,   -0x1.4e0784bea9711p-6,    0x1.f5aad22d87648p-1,   -0x1.ffffdp-2, INEXACT)
T(RN,   -0x1.5082e08646dd1p-6,    0x1.f5975e43ce10dp-1,  -0x1.fffffcp-2, INEXACT)
T(RN,    0x1.1992c6c063b2ap-6,    0x1.047006f88bd7bp+0,  -0x1.fffff2p-2, INEXACT)
T(RN,    0x1.46df7f9712a3bp-6,    0x1.05289f3f1f734p+0,  -0x1.ffffd2p-2, INEXACT)
T(RZ,   -0x1.da3768011dc8cp-5,    0x1.e333f880afd0bp-1, -0x1.b8e9d4p-22, INEXACT)
T(RU,   -0x1.da3768011dc8cp-5,    0x1.e333f880afd0cp-1,   0x1.fffff2p-1, INEXACT)
T(RN,    0x1.9fa246a40a37cp-5,    0x1.0d52de07804fbp+0,  -0x1.fffffcp-2, INEXACT)
T(RZ,   -0x1.6c87da28b2e97p-5,    0x1.e9b75fb236ec9p-1, -0x1.e6985ep-22, INEXACT)
T(RU,   -0x1.6c87da28b2e97p-5,    0x1.e9b75fb236ecap-1,    0x1.fffffp-1, INEXACT)
T(RU,   -0x1.834410d31cc58p-5,    0x1.e85becc26f237p-1,  0x1.20a16ep-22, INEXACT)
T(RZ,   -0x1.834410d31cc58p-5,    0x1.e85becc26f236p-1,  -0x1.fffff6p-1, INEXACT)
T(RN,    0x1.1a2814ce1d024p-5,    0x1.08f8936f6fb03p+0,  -0x1.ffffe4p-2, INEXACT)
T(RN,    0x1.b8508cdfcce66p-5,    0x1.0e22e71f4f59dp+0,   -0x1.ffffep-2, INEXACT)
T(RZ,   -0x1.653b43f51a5f1p-5,    0x1.ea27209ba333cp-1,  -0x1.9af2bp-21, INEXACT)
T(RU,   -0x1.653b43f51a5f1p-5,    0x1.ea27209ba333dp-1,   0x1.ffffe6p-1, INEXACT)
T(RU,    0x1.a441fb0c66ebdp-5,    0x1.0d79cb5547bd6p+0,  0x1.802ed8p-25, INEXACT)
T(RZ,    0x1.a441fb0c66ebdp-5,    0x1.0d79cb5547bd5p+0,  -0x1.fffffep-1, INEXACT)
T(RN,    0x1.ccb8214566334p-5,    0x1.0ecf5e4b5b71ep+0,  -0x1.ffffc8p-2, INEXACT)
T(RN,   -0x1.69a06b7985c3dp-5,    0x1.e9e3d2ee1ae8ep-1,  -0x1.ffffd8p-2, INEXACT)
T(RN,   -0x1.8a9e458ccc18fp-4,    0x1.d0f9701c3192bp-1,  -0x1.fffffcp-2, INEXACT)
T(RN,    0x1.19ab90940b39fp-4,    0x1.12394b3d1fc97p+0,  -0x1.ffffdcp-2, INEXACT)
T(RN,   -0x1.de111adff99acp-4,    0x1.c798e255c1ed4p-1,  -0x1.ffffd2p-2, INEXACT)
T(RN,   -0x1.aafead3edfb82p-4,    0x1.cd504114181adp-1,  -0x1.ffffd4p-2, INEXACT)
T(RU,   -0x1.a924a17dcb824p-4,    0x1.cd85a7e78d911p-1,  0x1.7ea776p-21, INEXACT)
T(RZ,   -0x1.a924a17dcb824p-4,     0x1.cd85a7e78d91p-1,  -0x1.ffffe8p-1, INEXACT)
T(RN,   -0x1.556ce88d9dd66p-4,    0x1.d70d59abf2b0cp-1,  -0x1.fffff8p-2, INEXACT)
T(RZ,   -0x1.a9368bfc588fcp-3,    0x1.a001ae96601e3p-1, -0x1.6de64cp-21, INEXACT)
T(RU,   -0x1.a9368bfc588fcp-3,    0x1.a001ae96601e4p-1,   0x1.ffffeap-1, INEXACT)
T(RN,   -0x1.aafc8923cad8ap-3,    0x1.9fa58102c7231p-1,  -0x1.ffffccp-2, INEXACT)
T(RN,     0x1.b4139704e4dfp-3,    0x1.3cbf66b3571fcp+0,  -0x1.fffffep-2, INEXACT)
T(RN,    0x1.2cdc32e24a272p-3,    0x1.2882a0471e48fp+0,  -0x1.ffffdap-2, INEXACT)
T(RN,   -0x1.1095ced4a7d6dp-3,    0x1.c031b04a3d926p-1,   -0x1.fffffp-2, INEXACT)
T(RN,   -0x1.c1e70768a122cp-3,     0x1.9b0585823e3ap-1,   -0x1.ffffep-2, INEXACT)
T(RZ,   -0x1.c0526438f496dp-3,     0x1.9b56c2df7cabp-1,  -0x1.be36ap-24, INEXACT)
T(RU,   -0x1.c0526438f496dp-3,    0x1.9b56c2df7cab1p-1,   0x1.fffffcp-1, INEXACT)
T(RN,   -0x1.48ef8703e55e5p-3,    0x1.b407bb5a20861p-1,  -0x1.ffffe8p-2, INEXACT)
T(RN,    0x1.fb96069984af8p-3,    0x1.4800b876889f6p+0,  -0x1.ffffccp-2, INEXACT)
T(RN,   -0x1.bff48ad7be774p-2,    0x1.4a96247daeab4p-1,  -0x1.ffffd4p-2, INEXACT)
T(RU,   -0x1.c1bd5129a88f1p-2,    0x1.4a02ce79d16f1p-1,  0x1.8042f8p-26, INEXACT)
T(RZ,   -0x1.c1bd5129a88f1p-2,     0x1.4a02ce79d16fp-1,         -0x1p+0, INEXACT)
T(RN,    0x1.adcc89195479fp-2,    0x1.8583e6ef67ba4p+0,  -0x1.ffffd2p-2, INEXACT)
T(RN,   -0x1.51c0b08aafbd5p-2,    0x1.70262b3246b36p-1,  -0x1.ffffeep-2, INEXACT)
T(RN,   -0x1.b1b699143da67p-2,    0x1.4f376aac54bbdp-1,  -0x1.ffffd6p-2, INEXACT)
T(RN,   -0x1.c7045ab4ead33p-2,    0x1.485084efc951fp-1,  -0x1.ffffcep-2, INEXACT)
T(RU,    0x1.e23342b5fed67p-2,    0x1.99f77e62c8b25p+0,  0x1.4d2358p-21, INEXACT)
T(RZ,    0x1.e23342b5fed67p-2,    0x1.99f77e62c8b24p+0,  -0x1.ffffecp-1, INEXACT)
T(RZ,   -0x1.f57cf1d8bbf1cp-2,    0x1.39bf7e5fed66cp-1, -0x1.a2c34ep-22, INEXACT)
T(RU,   -0x1.f57cf1d8bbf1cp-2,    0x1.39bf7e5fed66dp-1,   0x1.fffff2p-1, INEXACT)
T(RN,    0x1.c51fa0bce43d4p-2,    0x1.8e7d4992035cdp+0,  -0x1.ffffdcp-2, INEXACT)
T(RN,   -0x1.6761b1ee87041p-1,    0x1.fb8784a39027ap-2,  -0x1.ffffd4p-2, INEXACT)
T(RN,   -0x1.50a88022d56b5p-1,    0x1.0947e5a512e0bp-1,  -0x1.fffff8p-2, INEXACT)
T(RZ,     0x1.3749cc211359p-1,    0x1.d633b503c32b2p+0, -0x1.316a82p-21, INEXACT)
T(RU,     0x1.3749cc211359p-1,    0x1.d633b503c32b3p+0,   0x1.ffffecp-1, INEXACT)
T(RU,    0x1.8f3bbf05ce914p-1,    0x1.1728ced3df40ap+1,  0x1.d58b72p-21, INEXACT)
T(RZ,    0x1.8f3bbf05ce914p-1,    0x1.1728ced3df409p+1,  -0x1.ffffe2p-1, INEXACT)
T(RN,   -0x1.28017772c72ffp-1,    0x1.1f33e7dda1917p-1,  -0x1.ffffc4p-2, INEXACT)
T(RN,   -0x1.c1a59ced1e4ebp-1,    0x1.a97eeee1e0475p-2,  -0x1.ffffd8p-2, INEXACT)
T(RU,    0x1.a5d5ca94933b4p-1,    0x1.23c2382f62f2ap+1,  0x1.811f7ep-21, INEXACT)
T(RZ,    0x1.a5d5ca94933b4p-1,    0x1.23c2382f62f29p+1,  -0x1.ffffe8p-1, INEXACT)
T(RN,    0x1.89ed381080b7bp-1,    0x1.1447eb5108cccp+1,  -0x1.ffffe8p-2, INEXACT)
T(RN,    0x1.7abe0aed9c4ccp-1,    0x1.0c352754c5fb3p+1,  -0x1.ffffd8p-2, INEXACT)
T(RN,   -0x1.4758b0688085fp-1,    0x1.0e265031429ddp-1,  -0x1.ffffe8p-2, INEXACT)
T(RN,   -0x1.563382056848bp+0,    0x1.0d028be6f1b42p-2,  -0x1.ffffc4p-2, INEXACT)
T(RU,    0x1.aa48d6fcfe221p+0,     0x1.52578925fe1ap+2,  0x1.d1f1b6p-22, INEXACT)
T(RZ,    0x1.aa48d6fcfe221p+0,    0x1.52578925fe19fp+2,  -0x1.fffff2p-1, INEXACT)
T(RZ,    0x1.efa3622f9d19dp+0,    0x1.bb9ee4bfd7548p+2, -0x1.4555aap-22, INEXACT)
T(RU,    0x1.efa3622f9d19dp+0,    0x1.bb9ee4bfd7549p+2,   0x1.fffff6p-1, INEXACT)
T(RZ,   -0x1.054cbdb7549d5p+0,    0x1.70fd718458b79p-2, -0x1.5a6cbap-21, INEXACT)
T(RU,   -0x1.054cbdb7549d5p+0,    0x1.70fd718458b7ap-2,   0x1.ffffeap-1, INEXACT)
T(RN,   -0x1.c03157cdfffddp+0,    0x1.639f05db48983p-3,  -0x1.ffffecp-2, INEXACT)
T(RZ,    0x1.b989ac5756e1ap+0,    0x1.671d332cbf819p+2, -0x1.cd3948p-21, INEXACT)
T(RU,    0x1.b989ac5756e1ap+0,    0x1.671d332cbf81ap+2,   0x1.ffffe4p-1, INEXACT)
T(RU,    0x1.0a8bf70035012p+0,    0x1.6a92ee7e87404p+1,  0x1.17868cp-21, INEXACT)
T(RZ,    0x1.0a8bf70035012p+0,    0x1.6a92ee7e87403p+1,  -0x1.ffffeep-1, INEXACT)
T(RN,    0x1.e6fd89c8cd511p+0,    0x1.ace29c0f80311p+2,  -0x1.ffffeep-2, INEXACT)
T(RN,   -0x1.cba730f48f293p+0,    0x1.540d5c340c7e9p-3,  -0x1.fffffap-2, INEXACT)
T(RU,   -0x1.860f41d5be295p+1,    0x1.84ff5789268f2p-5,  0x1.8f3cdap-21, INEXACT)
T(RZ,   -0x1.860f41d5be295p+1,    0x1.84ff5789268f1p-5,  -0x1.ffffe8p-1, INEXACT)
T(RN,   -0x1.920d4b8afd2ddp+1,    0x1.62351813344f7p-5,  -0x1.ffffdap-2, INEXACT)
T(RZ,   -0x1.83e6fdd070f68p+1,    0x1.8b9bec8bc1f79p-5,  -0x1.8278cp-21, INEXACT)
T(RU,   -0x1.83e6fdd070f68p+1,    0x1.8b9bec8bc1f7ap-5,   0x1.ffffe8p-1, INEXACT)
T(RN,    0x1.68922f69581e6p+1,    0x1.0b9d7a7656dd7p+4,  -0x1.ffffccp-2, INEXACT)
T(RU,   -0x1.893b482882a1ep+1,    0x1.7b79e3f3cefc8p-5,   0x1.ea3ffp-27, INEXACT)
T(RZ,   -0x1.893b482882a1ep+1,    0x1.7b79e3f3cefc7p-5,         -0x1p+0, INEXACT)
T(RN,   -0x1.fdaef6b1498d4p+1,    0x1.319054864335fp-6,  -0x1.ffffc6p-2, INEXACT)
T(RN,    0x1.301a7dee8d792p+1,    0x1.584f8855d7b1ap+3,   -0x1.fffffp-2, INEXACT)
T(RN,   -0x1.ccb3aca79619bp+1,    0x1.c003e839c6a9fp-6,  -0x1.ffffd6p-2, INEXACT)
T(RN,    0x1.acf25b8c460cep+1,    0x1.c89115e5ac8cbp+4,  -0x1.ffffeap-2, INEXACT)
T(RN,    0x1.3ade365a313aep+2,    0x1.11f43495005e4p+7,   -0x1.fffffp-2, INEXACT)
T(RN,    0x1.b8916e400e995p+2,    0x1.e833b49d12d52p+9,  -0x1.fffff8p-2, INEXACT)
T(RU,   -0x1.ca2feb946e96fp+2,   0x1.97bc98120db29p-11,  0x1.31d696p-21, INEXACT)
T(RZ,   -0x1.ca2feb946e96fp+2,   0x1.97bc98120db28p-11,  -0x1.ffffecp-1, INEXACT)
T(RU,   -0x1.7787f7e20a357p+2,     0x1.72dc803aa353p-9,  0x1.34bb1ep-21, INEXACT)
T(RZ,   -0x1.7787f7e20a357p+2,    0x1.72dc803aa352fp-9,  -0x1.ffffecp-1, INEXACT)
T(RU,    0x1.7107a05372ebdp+2,     0x1.3f497aa16d88p+8,  0x1.740704p-22, INEXACT)
T(RZ,    0x1.7107a05372ebdp+2,    0x1.3f497aa16d87fp+8,  -0x1.fffff4p-1, INEXACT)
T(RZ,    0x1.ebb0099112b6ap+2,   0x1.0f4983f4713f2p+11, -0x1.339ba8p-22, INEXACT)
T(RU,    0x1.ebb0099112b6ap+2,   0x1.0f4983f4713f3p+11,   0x1.fffff6p-1, INEXACT)
T(RZ,   -0x1.1cafc832b84bfp+2,    0x1.7f5c95bcab82ep-7, -0x1.7dd11cp-24, INEXACT)
T(RU,   -0x1.1cafc832b84bfp+2,    0x1.7f5c95bcab82fp-7,   0x1.fffffep-1, INEXACT)
T(RZ,    0x1.f6983a750763bp+2,   0x1.41b193fa4dc2cp+11, -0x1.54efa8p-22, INEXACT)
T(RU,    0x1.f6983a750763bp+2,   0x1.41b193fa4dc2dp+11,   0x1.fffff6p-1, INEXACT)
T(RN,   -0x1.fb2bda318654dp+2,   0x1.7b531365afc07p-12,  -0x1.ffffd6p-2, INEXACT)
T(RU,    0x1.0f8ba4fab343ap+3,   0x1.2ed747e3987c5p+12,  0x1.e0d0b2p-22, INEXACT)
T(RZ,    0x1.0f8ba4fab343ap+3,   0x1.2ed747e3987c4p+12,   -0x1.fffffp-1, INEXACT)
T(RN,    0x1.8bae48e3635cbp+3,   0x1.c9ec353e85ce8p+17,  -0x1.ffffc2p-2, INEXACT)
T(RZ,   -0x1.efcf3aee91dfbp+3,   0x1.90d2474678e12p-23, -0x1.002bccp-23, INEXACT)
T(RU,   -0x1.efcf3aee91dfbp+3,   0x1.90d2474678e13p-23,   0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.c45c840a5a547p+3,   0x1.858b100d3825bp-21,   0x1.57043p-22, INEXACT)
T(RZ,   -0x1.c45c840a5a547p+3,   0x1.858b100d3825ap-21,  -0x1.fffff6p-1, INEXACT)
T(RZ,   -0x1.610fce8b88571p+3,   0x1.0f103bd83c858p-16, -0x1.ad419ap-23, INEXACT)
T(RU,   -0x1.610fce8b88571p+3,   0x1.0f103bd83c859p-16,   0x1.fffffap-1, INEXACT)
T(RN,   -0x1.1a309a556f69cp+3,   0x1.365631b8120cdp-13,  -0x1.ffffcap-2, INEXACT)
T(RN,   -0x1.3e1f8458dd1c4p+3,   0x1.93d903e2b2e89p-15,  -0x1.ffffeep-2, INEXACT)
T(RN,   -0x1.7f9b700cac5f8p+3,   0x1.a16c87d7e9318p-18,   -0x1.ffffdp-2, INEXACT)
T(RZ,   -0x1.b22edd7e1d267p+4,   0x1.cd90a62cd6428p-40, -0x1.2d0ba4p-22, INEXACT)
T(RU,   -0x1.b22edd7e1d267p+4,   0x1.cd90a62cd6429p-40,   0x1.fffff6p-1, INEXACT)
T(RN,    0x1.4adfc4b7ad978p+4,   0x1.c87a5436d350ap+29,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.943e024878e0cp+4,   0x1.76d598cc74889p-37,  -0x1.ffffc2p-2, INEXACT)
T(RZ,    -0x1.30c0df704187p+4,   0x1.6f4fc21783d17p-28, -0x1.511d94p-21, INEXACT)
T(RU,    -0x1.30c0df704187p+4,   0x1.6f4fc21783d18p-28,   0x1.ffffeap-1, INEXACT)
T(RZ,   -0x1.7d56bf81e56b3p+4,   0x1.8826f6b4748dcp-35, -0x1.cde98ap-22, INEXACT)
T(RU,   -0x1.7d56bf81e56b3p+4,   0x1.8826f6b4748ddp-35,   0x1.fffff2p-1, INEXACT)
T(RN,    0x1.3f425714812cep+4,   0x1.b9c0f91e1705bp+28,         -0x1p-1, INEXACT)
T(RU,    0x1.0b55332c49775p+4,   0x1.1352c098775aap+24,  0x1.0cf32ep-26, INEXACT)
T(RZ,    0x1.0b55332c49775p+4,   0x1.1352c098775a9p+24,         -0x1p+0, INEXACT)
T(RU,   -0x1.39f997990b856p+4,   0x1.9cd1c0fa3bfbfp-29,  0x1.8db34cp-21, INEXACT)
T(RZ,   -0x1.39f997990b856p+4,   0x1.9cd1c0fa3bfbep-29,  -0x1.ffffe8p-1, INEXACT)
T(RN,    0x1.6e03ad612eab8p+4,   0x1.0085e21708cc4p+33,  -0x1.ffffc4p-2, INEXACT)
T(RN,    0x1.a9d888f7dc37fp+4,   0x1.514accd459c49p+38,  -0x1.fffff6p-2, INEXACT)
T(RN,    0x1.34a4019ebb69ap+5,   0x1.944d7a678e407p+55,   -0x1.ffffep-2, INEXACT)
T(RU,    0x1.fb1b1a72e8a34p+5,    0x1.5dae0b673832p+91,  0x1.1cfda4p-22, INEXACT)
T(RZ,    0x1.fb1b1a72e8a34p+5,   0x1.5dae0b673831fp+91,  -0x1.fffff8p-1, INEXACT)
T(RN,     0x1.f5b3da8d9717p+5,   0x1.63ef90fdc5babp+90,  -0x1.ffffdep-2, INEXACT)
T(RU,   -0x1.570cbe9a45408p+5,   0x1.19342d11d4717p-62,   0x1.248c6p-22, INEXACT)
T(RZ,   -0x1.570cbe9a45408p+5,   0x1.19342d11d4716p-62,  -0x1.fffff6p-1, INEXACT)
T(RN,    0x1.5f228c695dc4ep+5,   0x1.402527afe1c07p+63,  -0x1.ffffc6p-2, INEXACT)
T(RN,   -0x1.e26be086ee3cfp+5,   0x1.004a1f13719c9p-87,  -0x1.fffffap-2, INEXACT)
T(RU,   -0x1.556e7549057bfp+6,  0x1.ceec07852de7bp-124,  0x1.3577b4p-21, INEXACT)
T(RZ,   -0x1.556e7549057bfp+6,  0x1.ceec07852de7ap-124,  -0x1.ffffecp-1, INEXACT)
T(RZ,   -0x1.c8791b8be934bp+6,  0x1.490b665a079dep-165, -0x1.34ddfap-21, INEXACT)
T(RU,   -0x1.c8791b8be934bp+6,  0x1.490b665a079dfp-165,   0x1.ffffecp-1, INEXACT)
T(RU,    0x1.08e57099f8943p+6,   0x1.7481f70d539f7p+95,  0x1.167336p-23, INEXACT)
T(RZ,    0x1.08e57099f8943p+6,   0x1.7481f70d539f6p+95,  -0x1.fffffcp-1, INEXACT)
T(RN,    0x1.9bf063018464ep+6,  0x1.7d8391cd5da23p+148,  -0x1.fffff4p-2, INEXACT)
T(RU,   -0x1.67c639eb013ddp+6,  0x1.2e17796f07453p-130,    0x1.a1fep-21, INEXACT)
T(RZ,   -0x1.67c639eb013ddp+6,  0x1.2e17796f07452p-130,  -0x1.ffffe6p-1, INEXACT)
T(RU,    0x1.c8c6fb028a9b2p+6,  0x1.add0d7faa6414p+164,  0x1.3df38cp-23, INEXACT)
T(RZ,    0x1.c8c6fb028a9b2p+6,  0x1.add0d7faa6413p+164,  -0x1.fffffcp-1, INEXACT)
T(RU,    0x1.e4284bbb42da2p+6,  0x1.8a395bc95e954p+174,  0x1.2b3064p-21, INEXACT)
T(RZ,    0x1.e4284bbb42da2p+6,  0x1.8a395bc95e953p+174,  -0x1.ffffeep-1, INEXACT)
T(RN,    0x1.2a4c70f7975eep+6,   0x1.80efc92bdebbp+107,  -0x1.ffffeep-2, INEXACT)
T(RN,   -0x1.8c1fe11adf922p+6,  0x1.17ce0595dee15p-143,  -0x1.ffffc4p-2, INEXACT)
T(RN,    0x1.dda40fc5dbef5p+7,  0x1.7585f1b330879p+344,  -0x1.ffffc8p-2, INEXACT)
T(RU,   -0x1.1a2e3be7781a9p+7,  0x1.5da39c6f6a895p-204,  0x1.8bb3eep-23, INEXACT)
T(RZ,   -0x1.1a2e3be7781a9p+7,  0x1.5da39c6f6a894p-204,  -0x1.fffffap-1, INEXACT)
T(RN,   -0x1.0181e55a88c14p+7,  0x1.2ff22d74d9cfap-186,  -0x1.fffffcp-2, INEXACT)
T(RU,   -0x1.ddef37f3d79ffp+7,  0x1.2effdbba6bdfbp-345,  0x1.7cb8e2p-23, INEXACT)
T(RZ,   -0x1.ddef37f3d79ffp+7,  0x1.2effdbba6bdfap-345,  -0x1.fffffap-1, INEXACT)
T(RN,   -0x1.bcf591adb70eep+7,  0x1.05553d7f277b6p-321,  -0x1.ffffd8p-2, INEXACT)
T(RN,    0x1.62a7f969c90dcp+7,  0x1.c7315dd200a5fp+255,  -0x1.ffffcep-2, INEXACT)
T(RU,    0x1.ad142ec736a8fp+7,   0x1.6dcfbb47e515p+309,   0x1.98ae3p-21, INEXACT)
T(RZ,    0x1.ad142ec736a8fp+7,  0x1.6dcfbb47e514fp+309,  -0x1.ffffe6p-1, INEXACT)
T(RZ,   -0x1.c0b53feaaaa24p+8,  0x1.9209731801407p-648, -0x1.36905ep-21, INEXACT)
T(RU,   -0x1.c0b53feaaaa24p+8,  0x1.9209731801408p-648,   0x1.ffffecp-1, INEXACT)
T(RZ,   -0x1.ea1996f999488p+8,  0x1.e9849ee9fc5eep-708, -0x1.a1f396p-21, INEXACT)
T(RU,   -0x1.ea1996f999488p+8,  0x1.e9849ee9fc5efp-708,   0x1.ffffe6p-1, INEXACT)
T(RU,     0x1.fb170a450786p+8,  0x1.7daeb339cf6c1p+731,  0x1.c964a4p-21, INEXACT)
T(RZ,     0x1.fb170a450786p+8,   0x1.7daeb339cf6cp+731,  -0x1.ffffe4p-1, INEXACT)
T(RZ,    -0x1.2330a507d4e5p+8,  0x1.de3e9d5b81629p-421, -0x1.529c9cp-22, INEXACT)
T(RU,    -0x1.2330a507d4e5p+8,  0x1.de3e9d5b8162ap-421,   0x1.fffff6p-1, INEXACT)
T(RN,    0x1.2e43f14e9f71fp+8,  0x1.0dff0097b6877p+436,  -0x1.fffffap-2, INEXACT)
T(RZ,  -0x1.4b5c0ac046ca8p-15,    0x1.fffad2968895bp-1, -0x1.924ba2p-23, INEXACT)
T(RU,  -0x1.4b5c0ac046ca8p-15,    0x1.fffad2968895cp-1,   0x1.fffffap-1, INEXACT)
T(RN,  -0x1.894791a77871bp-15,    0x1.fff9daeb2a0bbp-1,  -0x1.fffff4p-2, INEXACT)
T(RU,  -0x1.b936eed994facp-15,    0x1.fff91b3026454p-1,  0x1.23fc64p-23, INEXACT)
T(RZ,  -0x1.b936eed994facp-15,    0x1.fff91b3026453p-1,  -0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.bcd8786f99565p-15,     0x1.fff90caa3232p-1,  0x1.e34188p-27, INEXACT)
T(RZ,  -0x1.bcd8786f99565p-15,    0x1.fff90caa3231fp-1,         -0x1p+0, INEXACT)
T(RU,   0x1.02e9384d1d7e9p-15,    0x1.000205d47c517p+0,  0x1.ad362ap-23, INEXACT)
T(RZ,   0x1.02e9384d1d7e9p-15,    0x1.000205d47c516p+0,  -0x1.fffffap-1, INEXACT)
T(RU,   0x1.ae83610ebed3ap-15,    0x1.00035d0c6a1f1p+0,  0x1.855756p-25, INEXACT)
T(RZ,   0x1.ae83610ebed3ap-15,     0x1.00035d0c6a1fp+0,  -0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.92dd0f234d505p-15,    0x1.fff9b495ab547p-1, -0x1.5c6826p-26, INEXACT)
T(RU,  -0x1.92dd0f234d505p-15,    0x1.fff9b495ab548p-1,          0x1p+0, INEXACT)
T(RN,   -0x1.73bea67c17f1p-15,      0x1.fffa310dd55p-1,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.fd8ba6bef0ee6p-15,    0x1.0003fb1f39f1ap+0,  -0x1.fffff8p-2, INEXACT)
T(RN,    0x1.de6e7002580dp-15,    0x1.0003bce3dc4e9p+0,  -0x1.fffff4p-2, INEXACT)
T(RZ,  -0x1.443812cf3d0b7p-14,    0x1.fff5de59133a8p-1, -0x1.e4e0fcp-25, INEXACT)
T(RU,  -0x1.443812cf3d0b7p-14,    0x1.fff5de59133a9p-1,   0x1.fffffep-1, INEXACT)
T(RU,  -0x1.0e5ad6408a49ap-14,    0x1.fff78d3b261e5p-1,  0x1.9e35fep-24, INEXACT)
T(RZ,  -0x1.0e5ad6408a49ap-14,    0x1.fff78d3b261e4p-1,  -0x1.fffffcp-1, INEXACT)
T(RU,  -0x1.e178b2afed607p-14,    0x1.fff0f473025f3p-1,  0x1.4b99e6p-23, INEXACT)
T(RZ,  -0x1.e178b2afed607p-14,    0x1.fff0f473025f2p-1,  -0x1.fffffap-1, INEXACT)
T(RU,   0x1.6120fcc349854p-14,    0x1.000584932c091p+0,  0x1.f4c8dap-24, INEXACT)
T(RZ,   0x1.6120fcc349854p-14,     0x1.000584932c09p+0,  -0x1.fffffcp-1, INEXACT)
T(RU,   0x1.90027ad6b3cadp-14,    0x1.0006401d73c18p+0,  0x1.f76f1ap-23, INEXACT)
T(RZ,   0x1.90027ad6b3cadp-14,    0x1.0006401d73c17p+0,  -0x1.fffff8p-1, INEXACT)
T(RU,  -0x1.82c5481716382p-13,    0x1.ffe7d43d92237p-1,  0x1.3cd7a2p-23, INEXACT)
T(RZ,  -0x1.82c5481716382p-13,    0x1.ffe7d43d92236p-1,  -0x1.fffffcp-1, INEXACT)
T(RN,   0x1.8a24f81968978p-13,    0x1.000c51739cbcdp+0,  -0x1.fffff2p-2, INEXACT)
T(RN,   0x1.15513d4eb1de5p-13,    0x1.0008aaaf77ff1p+0,  -0x1.fffffcp-2, INEXACT)
T(RN,  -0x1.9fc7a11660217p-13,    0x1.ffe6042ebdf4dp-1,  -0x1.fffff6p-2, INEXACT)
T(RN,  -0x1.d473ea747d582p-13,    0x1.ffe2b997a2a3ep-1,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.916a93b6c444bp-13,     0x1.000c8ba34ce1p+0,  -0x1.fffff8p-2, INEXACT)
T(RZ,  -0x1.a98d03041a563p-13,    0x1.ffe567e0a60eep-1, -0x1.b7fae2p-25, INEXACT)
T(RU,  -0x1.a98d03041a563p-13,    0x1.ffe567e0a60efp-1,   0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.d47621878a7b3p-13,    0x1.ffe2b9743379ep-1, -0x1.1f6b7ep-23, INEXACT)
T(RU,  -0x1.d47621878a7b3p-13,    0x1.ffe2b9743379fp-1,   0x1.fffffcp-1, INEXACT)
T(RN,  -0x1.5bbff0ec8a547p-13,    0x1.ffea447708055p-1,  -0x1.fffffap-2, INEXACT)
T(RN,   0x1.0504a9a978d13p-12,    0x1.001050cfaeac3p+0,  -0x1.fffff2p-2, INEXACT)
T(RZ,  -0x1.b2f8e4b0bf4d8p-12,    0x1.ffc9a3c66098dp-1, -0x1.e1424ap-24, INEXACT)
T(RU,  -0x1.b2f8e4b0bf4d8p-12,    0x1.ffc9a3c66098ep-1,   0x1.fffffcp-1, INEXACT)
T(RU,   0x1.fbdbb79c53057p-12,    0x1.001fbfb34e9aap+0,  0x1.6acfdep-24, INEXACT)
T(RZ,   0x1.fbdbb79c53057p-12,    0x1.001fbfb34e9a9p+0,  -0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.f29e720359901p-12,    0x1.ffc1affcc5033p-1,  -0x1.a4d8dp-23, INEXACT)
T(RU,  -0x1.f29e720359901p-12,    0x1.ffc1affcc5034p-1,   0x1.fffffap-1, INEXACT)
T(RZ,   0x1.3cdd90e27b4d3p-12,    0x1.0013ce9d2d151p+0, -0x1.83525ep-23, INEXACT)
T(RU,   0x1.3cdd90e27b4d3p-12,    0x1.0013ce9d2d152p+0,   0x1.fffffap-1, INEXACT)
T(RU,   -0x1.9da7be9f2605p-12,    0x1.ffcc4da47c46ap-1,  0x1.e322bep-23, INEXACT)
T(RZ,   -0x1.9da7be9f2605p-12,    0x1.ffcc4da47c469p-1,  -0x1.fffff8p-1, INEXACT)
T(RN,  -0x1.20c3498b9b05cp-12,    0x1.ffdbe8dc7edfbp-1,  -0x1.fffff8p-2, INEXACT)
T(RN,   0x1.c2981fda0c949p-12,    0x1.001c2b0e99c0fp+0,  -0x1.fffff2p-2, INEXACT)
T(RZ,  -0x1.69427a05c7396p-11,    0x1.ffa5b75838e22p-1,  -0x1.80d3ap-26, INEXACT)
T(RU,  -0x1.69427a05c7396p-11,    0x1.ffa5b75838e23p-1,          0x1p+0, INEXACT)
T(RN,  -0x1.37a53845fb702p-11,    0x1.ffb21c9f2cefdp-1,  -0x1.fffff2p-2, INEXACT)
T(RN,  -0x1.a959fe9dd2be1p-11,    0x1.ff95b48a849bep-1,  -0x1.fffff2p-2, INEXACT)
T(RN,   0x1.5f006a343cb63p-11,    0x1.002be3d001cd4p+0,  -0x1.fffff4p-2, INEXACT)
T(RZ,  -0x1.e94be369ef7fep-11,    0x1.ff85bba2c7b22p-1,  -0x1.e2db1p-25, INEXACT)
T(RU,  -0x1.e94be369ef7fep-11,    0x1.ff85bba2c7b23p-1,   0x1.fffffep-1, INEXACT)
T(RZ,  -0x1.82ca54fea1833p-11,     0x1.ff9f568bc856p-1, -0x1.6ecf6ep-23, INEXACT)
T(RU,  -0x1.82ca54fea1833p-11,    0x1.ff9f568bc8561p-1,   0x1.fffffap-1, INEXACT)
T(RU,   0x1.3ea8d06e0d1a6p-11,    0x1.0027d8338692bp+0,  0x1.97637cp-25, INEXACT)
T(RZ,   0x1.3ea8d06e0d1a6p-11,    0x1.0027d8338692ap+0,  -0x1.fffffep-1, INEXACT)
T(RN,   0x1.4273c7b2128b3p-11,    0x1.002851a56fd33p+0,  -0x1.fffff4p-2, INEXACT)
T(RN,  -0x1.18ed3f074388bp-11,    0x1.ffb9c9812525fp-1,  -0x1.fffff2p-2, INEXACT)
T(RZ,  -0x1.2470e5f8ffe37p-10,    0x1.ff6ddc6c22b64p-1, -0x1.ec0e16p-23, INEXACT)
T(RU,  -0x1.2470e5f8ffe37p-10,    0x1.ff6ddc6c22b65p-1,   0x1.fffff8p-1, INEXACT)
T(RU,   0x1.e9a7f391f1f35p-10,    0x1.007a874627c5dp+0,  0x1.c828ecp-23, INEXACT)
T(RZ,   0x1.e9a7f391f1f35p-10,    0x1.007a874627c5cp+0,  -0x1.fffff8p-1, INEXACT)
T(RN,   0x1.599437ab36f1ep-10,    0x1.005673a39563dp+0,  -0x1.fffff4p-2, INEXACT)
T(RZ,   0x1.4db0fd0e0ae85p-10,    0x1.005379d86d00ep+0, -0x1.e28178p-23, INEXACT)
T(RU,   0x1.4db0fd0e0ae85p-10,    0x1.005379d86d00fp+0,   0x1.fffff8p-1, INEXACT)
T(RN,  -0x1.cab703e3e371ep-10,    0x1.ff1ad7d598f4ep-1,  -0x1.fffffep-2, INEXACT)
T(RZ,  -0x1.b8f12e91f59dbp-10,    0x1.ff23b6d9c6bb2p-1, -0x1.958454p-23, INEXACT)
T(RU,  -0x1.b8f12e91f59dbp-10,    0x1.ff23b6d9c6bb3p-1,   0x1.fffffap-1, INEXACT)
T(RN,  -0x1.7315a82742091p-10,      0x1.ff4696c6599p-1,  -0x1.fffff8p-2, INEXACT)
T(RU,  -0x1.9a06bfa8af5b4p-10,    0x1.ff3325a64b9d4p-1,  0x1.389028p-24, INEXACT)
T(RZ,  -0x1.9a06bfa8af5b4p-10,    0x1.ff3325a64b9d3p-1,  -0x1.fffffep-1, INEXACT)
T(RN,  -0x1.c00f0dea557b2p-10,     0x1.ff20297530a9p-1,  -0x1.fffffcp-2, INEXACT)
T(RN,   0x1.1c7691d03b144p-10,    0x1.00472786189abp+0,  -0x1.fffffap-2, INEXACT)
T(RU,    0x1.6f3cb593ff61fp-9,    0x1.00b7e0446f329p+0,  0x1.a2039ap-23, INEXACT)
T(RZ,    0x1.6f3cb593ff61fp-9,    0x1.00b7e0446f328p+0,  -0x1.fffffap-1, INEXACT)
T(RU,   -0x1.1ae14f17fc422p-9,    0x1.fee56cc7cfd49p-1,  0x1.72bb88p-24, INEXACT)
T(RZ,   -0x1.1ae14f17fc422p-9,    0x1.fee56cc7cfd48p-1,  -0x1.fffffep-1, INEXACT)
T(RN,   -0x1.34d2c548abfcep-9,    0x1.fecb8a4af66bep-1,  -0x1.fffff2p-2, INEXACT)
T(RZ,    0x1.630a4f5cddc53p-9,    0x1.00b1c2c29e108p+0, -0x1.ce904ap-23, INEXACT)
T(RU,    0x1.630a4f5cddc53p-9,    0x1.00b1c2c29e109p+0,   0x1.fffff8p-1, INEXACT)
T(RN,   -0x1.86e878f0f0d81p-9,    0x1.fe79ac9b64d1cp-1,  -0x1.fffff6p-2, INEXACT)
T(RZ,    0x1.d8065b8f5caf3p-9,    0x1.00ec701a2c6cbp+0, -0x1.a2a8d4p-23, INEXACT)
T(RU,    0x1.d8065b8f5caf3p-9,    0x1.00ec701a2c6ccp+0,   0x1.fffffap-1, INEXACT)
T(RN,    -0x1.4a972da684fap-9,    0x1.feb5d375eb59bp-1,  -0x1.fffff2p-2, INEXACT)
T(RZ,   -0x1.7f68ac7bc654ep-8,    0x1.fd036bc326862p-1, -0x1.fa3b5cp-23, INEXACT)
T(RU,   -0x1.7f68ac7bc654ep-8,    0x1.fd036bc326863p-1,   0x1.fffff8p-1, INEXACT)
T(RZ,    0x1.2830b7d8f3573p-8,    0x1.0128dc525a362p+0, -0x1.822446p-25, INEXACT)
T(RU,    0x1.2830b7d8f3573p-8,    0x1.0128dc525a363p+0,   0x1.fffffep-1, INEXACT)
T(RN,    0x1.d1de922173dd4p-8,    0x1.01d38778e1623p+0,  -0x1.fffff2p-2, INEXACT)
T(RZ,   -0x1.7d0d7e6547258p-7,    0x1.fa149e0643708p-1, -0x1.cdca14p-23, INEXACT)
T(RU,   -0x1.7d0d7e6547258p-7,    0x1.fa149e0643709p-1,   0x1.fffff8p-1, INEXACT)
T(RU,   -0x1.010fc4b9bc209p-7,    0x1.fbffc6bde98aap-1,   0x1.b3bd9p-25, INEXACT)
T(RZ,   -0x1.010fc4b9bc209p-7,    0x1.fbffc6bde98a9p-1,  -0x1.fffffep-1, INEXACT)
T(RN,   -0x1.cf99084ce73bcp-7,    0x1.f8ceaa42717a6p-1,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.4491f36d4b5c4p-7,    0x1.faf420cd81024p-1,  -0x1.fffffcp-2, INEXACT)
T(RU,    0x1.f4998d882eea5p-7,    0x1.03f0e2ed7ce93p+0,  0x1.b54114p-23, INEXACT)
T(RZ,    0x1.f4998d882eea5p-7,    0x1.03f0e2ed7ce92p+0,  -0x1.fffffap-1, INEXACT)
T(RZ,    0x1.5e555986dff72p-7,    0x1.02c06cfb2a27ep+0, -0x1.7f7488p-23, INEXACT)
T(RU,    0x1.5e555986dff72p-7,    0x1.02c06cfb2a27fp+0,   0x1.fffffap-1, INEXACT)
T(RN,   -0x1.328895c4e6ecep-7,     0x1.fb3b9542e7bep-1,  -0x1.fffff6p-2, INEXACT)
T(RN,    0x1.49e46242308d4p-6,    0x1.0534f16076a67p+0,  -0x1.fffff6p-2, INEXACT)
T(RZ,   -0x1.d0e58622f3516p-6,    0x1.f1ad18ff54f98p-1, -0x1.23b162p-28, INEXACT)
T(RU,   -0x1.d0e58622f3516p-6,    0x1.f1ad18ff54f99p-1,          0x1p+0, INEXACT)
T(RN,    0x1.307178536789ep-6,    0x1.04cd2854eac6ep+0,  -0x1.fffffap-2, INEXACT)
T(RU,   -0x1.754aee0beb9e2p-6,    0x1.f4776c01df9ccp-1,  0x1.4b5e0cp-25, INEXACT)
T(RZ,   -0x1.754aee0beb9e2p-6,    0x1.f4776c01df9cbp-1,  -0x1.fffffep-1, INEXACT)
T(RZ,    0x1.b4b97d879cac5p-6,    0x1.06ea638902d31p+0,  -0x1.37646p-26, INEXACT)
T(RU,    0x1.b4b97d879cac5p-6,    0x1.06ea638902d32p+0,          0x1p+0, INEXACT)
T(RZ,    0x1.62f4a298cdaedp-6,    0x1.059b506cd3f02p+0, -0x1.26f896p-23, INEXACT)
T(RU,    0x1.62f4a298cdaedp-6,    0x1.059b506cd3f03p+0,   0x1.fffffcp-1, INEXACT)
T(RN,    0x1.d83ecb8779731p-6,    0x1.077c77dce6d0fp+0,  -0x1.fffff2p-2, INEXACT)
T(RN,    0x1.f8e71e657e583p-5,    0x1.10464bb02c09fp+0,  -0x1.fffff4p-2, INEXACT)
T(RN,    -0x1.c0d722437ba3p-5,    0x1.e4b3beea8606fp-1,  -0x1.fffff4p-2, INEXACT)
T(RN,    0x1.3eff146644811p-5,    0x1.0a2a4f32fa232p+0,  -0x1.fffff8p-2, INEXACT)
T(RN,    0x1.801e5f5c1c572p-5,    0x1.0c4a220cb153dp+0,         -0x1p-1, INEXACT)
T(RN,    0x1.57cd09de043c9p-4,    0x1.166a44f792cccp+0,  -0x1.fffff6p-2, INEXACT)
T(RZ,   -0x1.c41ed28bd61c6p-4,    0x1.ca7e0c7d6fc04p-1, -0x1.553dc2p-23, INEXACT)
T(RU,   -0x1.c41ed28bd61c6p-4,    0x1.ca7e0c7d6fc05p-1,   0x1.fffffap-1, INEXACT)
T(RZ,    0x1.f7493eae45d8ap-4,    0x1.217832eb6ff75p+0, -0x1.4708bap-23, INEXACT)
T(RU,    0x1.f7493eae45d8ap-4,    0x1.217832eb6ff76p+0,   0x1.fffffap-1, INEXACT)
T(RU,    0x1.57bcc987b63aap-4,     0x1.16692a2e5696p+0,    0x1.2d3bp-23, INEXACT)
T(RZ,    0x1.57bcc987b63aap-4,    0x1.16692a2e5695fp+0,  -0x1.fffffcp-1, INEXACT)
T(RN,   -0x1.f0f13f3ba984ep-4,    0x1.c580a47c83b55p-1,  -0x1.fffffap-2, INEXACT)
T(RU,    0x1.7f42661a56a68p-4,    0x1.191c338d31e21p+0,  0x1.4392f4p-23, INEXACT)
T(RZ,    0x1.7f42661a56a68p-4,     0x1.191c338d31e2p+0,  -0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.0eafe984f00a9p-4,    0x1.df420698f100bp-1, -0x1.7e9efcp-23, INEXACT)
T(RU,   -0x1.0eafe984f00a9p-4,    0x1.df420698f100cp-1,   0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.dc0c07eefff15p-4,    0x1.c7d2698eac474p-1, -0x1.b0dafep-23, INEXACT)
T(RU,   -0x1.dc0c07eefff15p-4,    0x1.c7d2698eac475p-1,   0x1.fffffap-1, INEXACT)
T(RN,    0x1.c72cd3f98721fp-4,    0x1.1e16dfbf026e8p+0,  -0x1.fffff8p-2, INEXACT)
T(RN,   -0x1.da329c2740e34p-4,    0x1.c8071bd51417fp-1,  -0x1.fffff2p-2, INEXACT)
T(RN,   -0x1.510069a6bcdc8p-4,    0x1.d78fa9377f817p-1,  -0x1.fffffap-2, INEXACT)
T(RN,    0x1.88922801e8cdbp-4,    0x1.19bffc584a73ap+0,  -0x1.fffff2p-2, INEXACT)
T(RZ,    0x1.416b0e0ac37cfp-3,    0x1.2b806befd18a2p+0, -0x1.cc7faap-25, INEXACT)
T(RU,    0x1.416b0e0ac37cfp-3,    0x1.2b806befd18a3p+0,   0x1.fffffep-1, INEXACT)
T(RZ,    0x1.fce7a46b3e20cp-3,    0x1.4836cf50bf885p+0, -0x1.c85f1ep-23, INEXACT)
T(RU,    0x1.fce7a46b3e20cp-3,    0x1.4836cf50bf886p+0,   0x1.fffff8p-1, INEXACT)
T(RU,   -0x1.c66002e0201f4p-3,    0x1.9a1ffb251902fp-1,   0x1.c6d97p-24, INEXACT)
T(RZ,   -0x1.c66002e0201f4p-3,    0x1.9a1ffb251902ep-1,  -0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.ed15f23b0db9fp-3,    0x1.9272178452a9ap-1,  0x1.1f96f6p-24, INEXACT)
T(RZ,   -0x1.ed15f23b0db9fp-3,    0x1.9272178452a99p-1,  -0x1.fffffep-1, INEXACT)
T(RU,   -0x1.003d3590af92dp-3,    0x1.c3c9216c91977p-1,   0x1.dbbfcp-23, INEXACT)
T(RZ,   -0x1.003d3590af92dp-3,    0x1.c3c9216c91976p-1,  -0x1.fffff8p-1, INEXACT)
T(RN,    0x1.801b0c627f4f4p-3,    0x1.34cf95847a968p+0,  -0x1.fffff6p-2, INEXACT)
T(RU,    0x1.7c29308bc2045p-3,    0x1.3437751d977cbp+0,    0x1.8b6ap-25, INEXACT)
T(RZ,    0x1.7c29308bc2045p-3,    0x1.3437751d977cap+0,  -0x1.fffffep-1, INEXACT)
T(RN,    0x1.7b1a939487f83p-3,    0x1.340ebddf2b551p+0,  -0x1.fffff2p-2, INEXACT)
T(RN,    0x1.35d64bdf650a9p-3,    0x1.29d0136a675f6p+0,  -0x1.fffff2p-2, INEXACT)
T(RU,    0x1.b957582a576bep-3,    0x1.3d901d9b4d32bp+0,  0x1.0400acp-23, INEXACT)
T(RZ,    0x1.b957582a576bep-3,    0x1.3d901d9b4d32ap+0,  -0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.b5606a57f287ap-3,    0x1.9d8b0ac3b141cp-1,  0x1.6ecc02p-23, INEXACT)
T(RZ,   -0x1.b5606a57f287ap-3,    0x1.9d8b0ac3b141bp-1,  -0x1.fffffap-1, INEXACT)
T(RZ,    0x1.176aff86fd891p-2,    0x1.50507ef5e6fcap+0, -0x1.9dd90ap-23, INEXACT)
T(RU,    0x1.176aff86fd891p-2,    0x1.50507ef5e6fcbp+0,   0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.4d6ea20d26a06p-2,    0x1.71b4a8b0ef52fp-1, -0x1.a8c2e4p-23, INEXACT)
T(RU,   -0x1.4d6ea20d26a06p-2,     0x1.71b4a8b0ef53p-1,   0x1.fffffap-1, INEXACT)
T(RN,    0x1.52896cd10d217p-2,    0x1.644d69fe48ddap+0,  -0x1.fffff6p-2, INEXACT)
T(RU,   -0x1.09132cbc994d6p-2,    0x1.8b3a53ed72aafp-1,  0x1.38e3fap-24, INEXACT)
T(RZ,   -0x1.09132cbc994d6p-2,    0x1.8b3a53ed72aaep-1,  -0x1.fffffep-1, INEXACT)
T(RN,    0x1.9ad7f5d0962d7p-2,    0x1.7e5f07a8d12ecp+0,  -0x1.fffff6p-2, INEXACT)
T(RN,    0x1.3f28f63373923p-2,    0x1.5d9fa40d0616fp+0,  -0x1.fffffep-2, INEXACT)
T(RN,   -0x1.3e5e4cd34bef8p-1,     0x1.12edb8a2bbe4p-1,  -0x1.fffff4p-2, INEXACT)
T(RN,   -0x1.b36a729afcce9p-1,    0x1.b57d0ae1cfcf1p-2,  -0x1.fffff8p-2, INEXACT)
T(RN,   -0x1.b41ba7d5f53afp-1,    0x1.b4e5b9dcd9257p-2,  -0x1.fffff2p-2, INEXACT)
T(RN,    0x1.690af85110305p-1,    0x1.031823f68433ep+1,  -0x1.fffff6p-2, INEXACT)
T(RN,   -0x1.60bf127f2abdcp-1,    0x1.01132227d5ea3p-1,  -0x1.fffffep-2, INEXACT)
T(RN,   -0x1.431433800c3a4p-1,    0x1.10692883e690fp-1,  -0x1.fffff6p-2, INEXACT)
T(RN,   -0x1.92ca6cd4872d2p-1,    0x1.d245df8236eb3p-2,         -0x1p-1, INEXACT)
T(RU,   -0x1.b9a14bc94c187p+0,    0x1.6cdb0617802aep-3,  0x1.9a0d72p-23, INEXACT)
T(RZ,   -0x1.b9a14bc94c187p+0,    0x1.6cdb0617802adp-3,  -0x1.fffffap-1, INEXACT)
T(RU,    0x1.dccbc14ac1059p+0,    0x1.9c24443155642p+2,  0x1.597cfap-23, INEXACT)
T(RZ,    0x1.dccbc14ac1059p+0,    0x1.9c24443155641p+2,  -0x1.fffffap-1, INEXACT)
T(RZ,   -0x1.1d5c077283989p+0,    0x1.4fe40fc85fb44p-2, -0x1.ba4b42p-23, INEXACT)
T(RU,   -0x1.1d5c077283989p+0,    0x1.4fe40fc85fb45p-2,   0x1.fffffap-1, INEXACT)
T(RN,    0x1.df60f946e3598p+0,    0x1.a0522b5c3f128p+2,  -0x1.fffffcp-2, INEXACT)
T(RN,   -0x1.f08733e636ab8p+0,    0x1.266f2f98b49c6p-3,   -0x1.fffffp-2, INEXACT)
T(RN,   -0x1.87183771a1cb3p+0,    0x1.bc7af4886d6b1p-3,  -0x1.fffff6p-2, INEXACT)
T(RN,    0x1.a2db7e04f7e0ep+1,    0x1.a5f5ee0610ae9p+4,  -0x1.fffff8p-2, INEXACT)
T(RU,    0x1.35fc1a293ed18p+1,    0x1.687fffde31012p+3,  0x1.a379f4p-26, INEXACT)
T(RZ,    0x1.35fc1a293ed18p+1,    0x1.687fffde31011p+3,         -0x1p+0, INEXACT)
T(RN,    0x1.bc2ef113faa25p+1,    0x1.0124106d4dffdp+5,  -0x1.fffffep-2, INEXACT)
T(RZ,   -0x1.201173cf2d313p+1,    0x1.af7c4000d1842p-4, -0x1.06967ep-23, INEXACT)
T(RU,   -0x1.201173cf2d313p+1,    0x1.af7c4000d1843p-4,   0x1.fffffcp-1, INEXACT)
T(RN,    0x1.e7b09068bbb7bp+1,    0x1.693b1be3e9568p+5,  -0x1.fffffap-2, INEXACT)
T(RU,   -0x1.dc0b75b47d617p+2,   0x1.347623b4a82d2p-11,  0x1.4cafc6p-25, INEXACT)
T(RZ,   -0x1.dc0b75b47d617p+2,   0x1.347623b4a82d1p-11,  -0x1.fffffep-1, INEXACT)
T(RN,   -0x1.aa472cfda57dep+2,   0x1.4fa534227e097p-10,  -0x1.fffff2p-2, INEXACT)
T(RU,   -0x1.7af8136129b09p+2,    0x1.5f7717ff6d676p-9,  0x1.9e0eb2p-23, INEXACT)
T(RZ,   -0x1.7af8136129b09p+2,    0x1.5f7717ff6d675p-9,  -0x1.fffffap-1, INEXACT)
T(RN,    0x1.ff9b5d4748d9cp+2,   0x1.72568840c2e4dp+11,  -0x1.fffffcp-2, INEXACT)
T(RN,   -0x1.fd47306f09b4ap+2,    0x1.6f0a7f324b84p-12,  -0x1.fffffcp-2, INEXACT)
T(RN,    0x1.d71c9e180fd34p+2,   0x1.896670f77109fp+10,  -0x1.fffff4p-2, INEXACT)
T(RZ,   -0x1.c6604919d143dp+3,   0x1.6dc60c3cf91bfp-21, -0x1.604c68p-23, INEXACT)
T(RU,   -0x1.c6604919d143dp+3,    0x1.6dc60c3cf91cp-21,   0x1.fffffap-1, INEXACT)
T(RZ,    0x1.909b13acd25a9p+3,   0x1.0b0e57c5fe85dp+18, -0x1.7ec654p-25, INEXACT)
T(RU,    0x1.909b13acd25a9p+3,   0x1.0b0e57c5fe85ep+18,   0x1.fffffep-1, INEXACT)
T(RU,   -0x1.344923d39e3c2p+3,   0x1.12993259cfa56p-14,  0x1.ee8d8ap-23, INEXACT)
T(RZ,   -0x1.344923d39e3c2p+3,   0x1.12993259cfa55p-14,  -0x1.fffff8p-1, INEXACT)
T(RU,    0x1.0b129ed1e91dbp+3,   0x1.075640596ac4ep+12,  0x1.c8424cp-23, INEXACT)
T(RZ,    0x1.0b129ed1e91dbp+3,   0x1.075640596ac4dp+12,  -0x1.fffff8p-1, INEXACT)
T(RN,    0x1.da25550ea47c2p+3,   0x1.4c55c97370049p+21,  -0x1.fffff8p-2, INEXACT)
T(RN,   -0x1.c5516c5a7b04dp+3,   0x1.7a11df6318acdp-21,  -0x1.fffff6p-2, INEXACT)
T(RN,    0x1.5c5a3f479a04ap+3,   0x1.a1601f2f162d9p+15,   -0x1.fffffp-2, INEXACT)
T(RN,    0x1.b1b7c3d0a7725p+3,   0x1.77cd64a870017p+19,  -0x1.fffff6p-2, INEXACT)
T(RZ,   -0x1.2a48311981aadp+4,   0x1.133530f40ff9cp-27, -0x1.7a228ep-23, INEXACT)
T(RU,   -0x1.2a48311981aadp+4,   0x1.133530f40ff9dp-27,   0x1.fffffap-1, INEXACT)
T(RZ,    0x1.02224624b76a7p+4,   0x1.35df48c05c96cp+23, -0x1.fbc736p-24, INEXACT)
T(RU,    0x1.02224624b76a7p+4,   0x1.35df48c05c96dp+23,   0x1.fffffcp-1, INEXACT)
T(RN,   -0x1.80c1f8d5eb8d7p+4,   0x1.3cb49b8d06853p-35,  -0x1.fffff4p-2, INEXACT)
T(RZ,   -0x1.56a07327816d7p+4,   0x1.137e9896c1d2ap-31, -0x1.bb242ep-23, INEXACT)
T(RU,   -0x1.56a07327816d7p+4,   0x1.137e9896c1d2bp-31,   0x1.fffffap-1, INEXACT)
T(RN,   -0x1.c68c7efcd99bcp+4,   0x1.0281043c292c4p-41,         -0x1p-1, INEXACT)
T(RU,     0x1.f2889fe5be84p+4,   0x1.ef3f4b3202ac4p+44,  0x1.3138d6p-26, INEXACT)
T(RZ,     0x1.f2889fe5be84p+4,   0x1.ef3f4b3202ac3p+44,         -0x1p+0, INEXACT)
T(RN,    0x1.ecdc85918bd2ap+4,   0x1.5b6bfff816b21p+44,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.7e9416adab235p+4,   0x1.6aeac4748cf18p-35,  -0x1.fffff2p-2, INEXACT)
T(RN,    0x1.ef46ff8e2f00ap+4,   0x1.940c6e33b7f6ep+44,  -0x1.fffff2p-2, INEXACT)
T(RN,   -0x1.1296430479488p+4,   0x1.2e8705ab488e9p-25,  -0x1.fffff2p-2, INEXACT)
T(RU,   -0x1.267d8ae3ea8b3p+5,   0x1.db3e122e39784p-54,  0x1.4f8d3ap-24, INEXACT)
T(RZ,   -0x1.267d8ae3ea8b3p+5,   0x1.db3e122e39783p-54,  -0x1.fffffep-1, INEXACT)
T(RU,   -0x1.51433ecd413d3p+5,    0x1.21d66e2ac155p-61,  0x1.665f98p-25, INEXACT)
T(RZ,   -0x1.51433ecd413d3p+5,   0x1.21d66e2ac154fp-61,  -0x1.fffffep-1, INEXACT)
T(RN,   -0x1.0584d30b41ae1p+5,   0x1.c9c76a0df65c2p-48,  -0x1.fffff4p-2, INEXACT)
T(RU,    0x1.53d00af05d111p+5,   0x1.36ff31c9edc16p+61,  0x1.e761f6p-24, INEXACT)
T(RZ,    0x1.53d00af05d111p+5,   0x1.36ff31c9edc15p+61,  -0x1.fffffcp-1, INEXACT)
T(RU,   -0x1.4b33e4aa98c6fp+5,   0x1.3519fda4b977cp-60,  0x1.e3ef22p-23, INEXACT)
T(RZ,   -0x1.4b33e4aa98c6fp+5,   0x1.3519fda4b977bp-60,  -0x1.fffff8p-1, INEXACT)
T(RZ,    0x1.6b3aea52bde1cp+5,   0x1.6afdb02de9831p+65, -0x1.54db4ep-23, INEXACT)
T(RU,    0x1.6b3aea52bde1cp+5,   0x1.6afdb02de9832p+65,   0x1.fffffap-1, INEXACT)
T(RN,   -0x1.abcb57701b545p+5,   0x1.ce5f384c80db4p-78,  -0x1.fffff8p-2, INEXACT)
T(RZ,    0x1.e4a01127c3d87p+5,   0x1.50d059a55f844p+87, -0x1.04caacp-25, INEXACT)
T(RU,    0x1.e4a01127c3d87p+5,   0x1.50d059a55f845p+87,   0x1.fffffep-1, INEXACT)
T(RN,    0x1.c8593c89a4acap+5,   0x1.3a679d07a50c9p+82,  -0x1.fffffap-2, INEXACT)
T(RU,   -0x1.fc63ca5d5a6d8p+6,  0x1.8e242d9c8d666p-184,  0x1.c4cfb2p-24, INEXACT)
T(RZ,   -0x1.fc63ca5d5a6d8p+6,  0x1.8e242d9c8d665p-184,  -0x1.fffffcp-1, INEXACT)
T(RN,   -0x1.528418a765fedp+6,  0x1.dfc1de932fb84p-123,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.218f6d178a638p+6,  0x1.7a411c1768dafp-105,  -0x1.fffff6p-2, INEXACT)
T(RN,   -0x1.67bfd35a682e8p+6,  0x1.2ffc62342b6ebp-130,  -0x1.fffff6p-2, INEXACT)
T(RN,    0x1.de3a9160a62b5p+7,  0x1.f52a8a2c39d24p+344,  -0x1.fffffap-2, INEXACT)
T(RN,   -0x1.623765fd8adacp+9, 0x1.edb51c27d3736p-1023,  -0x1.0d7f44p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.61dca57a786c3p+9, 0x1.f598b313d214cp-1022,   0x1.32b78ep-2, INEXACT)
T(RN,   -0x1.6181e4f765fdap+9, 0x1.fd9c8f7442ad6p-1021,   0x1.31e3e8p-2, INEXACT)
T(RN,   -0x1.61272474538f1p+9, 0x1.02e09aa5f9c6bp-1019,   0x1.a4928ap-3, INEXACT)
T(RN,   -0x1.60cc63f141208p+9, 0x1.0703955cdb0bbp-1018,  -0x1.78ae2ap-2, INEXACT)
T(RN,   -0x1.6071a36e2eb1fp+9, 0x1.0b377c007fe13p-1017,  -0x1.2c1bb2p-4, INEXACT)
T(RN,   -0x1.6016e2eb1c436p+9, 0x1.0f7c93c957337p-1016,  -0x1.d60b22p-3, INEXACT)
T(RN,   -0x1.5fbc226809d4dp+9, 0x1.13d3230af834fp-1015,  -0x1.c56becp-2, INEXACT)
T(RN,   -0x1.5f6161e4f7664p+9, 0x1.183b7138a8ab4p-1014,  -0x1.2fa828p-3, INEXACT)
T(RN,   -0x1.5f06a161e4f7bp+9, 0x1.1cb5c6e9f5be1p-1013,   0x1.b8d16ep-2, INEXACT)
T(RN,   -0x1.5eabe0ded2892p+9, 0x1.21426ddf5f943p-1012,  -0x1.fd70cap-2, INEXACT)
T(RN,   -0x1.5e51205bc01a9p+9, 0x1.25e1b107180bep-1011,   0x1.68c54cp-2, INEXACT)
T(RN,    -0x1.5df65fd8adacp+9,  0x1.2a93dc81d4dbp-1010,  -0x1.4b1248p-6, INEXACT)
T(RN,   -0x1.5d9b9f559b3d7p+9, 0x1.2f593da7b5691p-1009,   0x1.52f494p-2, INEXACT)
T(RN,   -0x1.5d40ded288ceep+9, 0x1.3432230d3cb11p-1008,   0x1.a87b2ap-2, INEXACT)
T(RN,   -0x1.5ce61e4f76605p+9, 0x1.391edc885f7f2p-1007,  -0x1.bbd8b4p-6, INEXACT)
T(RN,   -0x1.5c8b5dcc63f1cp+9, 0x1.3e1fbb35a75c4p-1006,   0x1.b396bap-2, INEXACT)
T(RN,   -0x1.5c309d4951833p+9, 0x1.4335117d6a7c9p-1005,   -0x1.f6da4p-2, INEXACT)
T(RN,   -0x1.5bd5dcc63f14ap+9, 0x1.485f331919075p-1004,   0x1.aa02b6p-2, INEXACT)
T(RN,   -0x1.5b7b1c432ca61p+9, 0x1.4d9e7518a00dcp-1003,   0x1.02b51cp-2, INEXACT)
T(RN,   -0x1.5b205bc01a378p+9, 0x1.52f32de7e28c4p-1002,   0x1.425012p-2, INEXACT)
T(RN,   -0x1.5ac59b3d07c8fp+9, 0x1.585db55448cd7p-1001,  -0x1.3d7c2p-10, INEXACT)
T(RN,   -0x1.5a6adab9f55a6p+9, 0x1.5dde6492668c8p-1000,   0x1.de78b6p-4, INEXACT)
T(RN,   -0x1.5a101a36e2ebdp+9,  0x1.63759643b832cp-999,  -0x1.a719d4p-6, INEXACT)
T(RN,   -0x1.59b559b3d07d4p+9,  0x1.6923a67c778fbp-998,  -0x1.c2cf74p-3, INEXACT)
T(RN,   -0x1.595a9930be0ebp+9,  0x1.6ee8f2c9886b1p-997,  -0x1.a83332p-3, INEXACT)
T(RN,   -0x1.58ffd8adaba02p+9,  0x1.74c5da367d52cp-996,   0x1.b8c744p-5, INEXACT)
T(RN,   -0x1.58a5182a99319p+9,  0x1.7ababd53b5078p-995,  -0x1.93780ep-2, INEXACT)
T(RN,    -0x1.584a57a786c3p+9,  0x1.80c7fe3c90ed9p-994,  -0x1.e1a68ep-3, INEXACT)
T(RN,   -0x1.57ef972474547p+9,  0x1.86ee009dc4e6dp-993,   0x1.f6f062p-3, INEXACT)
T(RN,   -0x1.5794d6a161e5ep+9,  0x1.8d2d29bbc0ff1p-992,  -0x1.9cc5cep-3, INEXACT)
T(RN,   -0x1.573a161e4f775p+9,  0x1.9385e07935542p-991,   0x1.af01e2p-2, INEXACT)
T(RN,   -0x1.56df559b3d08cp+9,   0x1.99f88d5db0a4p-990,   0x1.b5ae62p-3, INEXACT)
T(RN,   -0x1.568495182a9a3p+9,  0x1.a0859a9c59efcp-989,  -0x1.f3c20ap-2, INEXACT)
T(RN,   -0x1.5629d495182bap+9,  0x1.a72d741ac5a09p-988,   0x1.8f69fep-5, INEXACT)
T(RN,   -0x1.55cf141205bd1p+9,  0x1.adf08777e69fbp-987,  -0x1.a3488cp-2, INEXACT)
T(RN,   -0x1.5574538ef34e8p+9,  0x1.b4cf44131bd4bp-986,  -0x1.27a146p-2, INEXACT)
T(RN,   -0x1.5519930be0dffp+9,  0x1.bbca1b135a7c8p-985,   0x1.22e3d6p-3, INEXACT)
T(RN,   -0x1.54bed288ce716p+9,  0x1.c2e17f6e75d0ap-984,    0x1.bbe85p-2, INEXACT)
T(RN,   -0x1.54641205bc02dp+9,  0x1.ca15e5f08475dp-983,   0x1.fd3e0ap-2, INEXACT)
T(RN,   -0x1.54095182a9944p+9,  0x1.d167c543642c1p-982,  -0x1.07584cp-4, INEXACT)
T(RN,   -0x1.53ae90ff9725bp+9,  0x1.d8d795f65c3bfp-981,  -0x1.30efd6p-4, INEXACT)
T(RN,   -0x1.5353d07c84b72p+9,  0x1.e065d285df1e7p-980,  -0x1.c3d4b4p-3, INEXACT)
T(RN,   -0x1.52f90ff972489p+9,  0x1.e812f7636bdffp-979,   0x1.44d944p-3, INEXACT)
T(RN,    -0x1.529e4f765fdap+9,  0x1.efdf82fd8fbf3p-978,   0x1.0225fcp-2, INEXACT)
T(RN,   -0x1.52438ef34d6b7p+9,  0x1.f7cbf5c8088cfp-977,   0x1.947198p-5, INEXACT)
T(RN,   -0x1.51e8ce703afcep+9,  0x1.ffd8d2440851bp-976,   0x1.fda1b4p-4, INEXACT)
T(RN,   -0x1.518e0ded288e5p+9,  0x1.04034e844d60ep-974,   0x1.7be58cp-5, INEXACT)
T(RN,   -0x1.51334d6a161fcp+9,  0x1.082aee6596851p-973,  -0x1.ca5be4p-2, INEXACT)
T(RN,   -0x1.50d88ce703b13p+9,  0x1.0c638d341c416p-972,  -0x1.3c273cp-2, INEXACT)
T(RN,   -0x1.507dcc63f142ap+9,  0x1.10ad7076086a1p-971,   0x1.c56706p-2, INEXACT)
T(RN,   -0x1.50230be0ded41p+9,  0x1.1508decdeb111p-970,  -0x1.362f64p-3, INEXACT)
T(RN,   -0x1.4fc84b5dcc658p+9,   0x1.19761fff45e8p-969,   0x1.493cccp-2, INEXACT)
T(RN,   -0x1.4f6d8adab9f6fp+9,  0x1.1df57cf32a384p-968,   -0x1.bf377p-8, INEXACT)
T(RN,   -0x1.4f12ca57a7886p+9,  0x1.22873fbce9bf1p-967,   0x1.883372p-2, INEXACT)
T(RN,   -0x1.4eb809d49519dp+9,  0x1.272bb39edab92p-966,   0x1.ddace2p-3, INEXACT)
T(RN,   -0x1.4e5d495182ab4p+9,  0x1.2be3250f2f6d9p-965,  -0x1.9afaf8p-2, INEXACT)
T(RN,   -0x1.4e0288ce703cbp+9,  0x1.30ade1bce1874p-964,   0x1.b4b782p-3, INEXACT)
T(RN,   -0x1.4da7c84b5dce2p+9,  0x1.358c3894b18d5p-963,  -0x1.dea656p-3, INEXACT)
T(RN,   -0x1.4d4d07c84b5f9p+9,  0x1.3a7e79c63ace6p-962,   0x1.6f50c8p-8, INEXACT)
T(RN,    -0x1.4cf2474538f1p+9,  0x1.3f84f6c91c106p-961,  -0x1.d718a6p-2, INEXACT)
T(RN,   -0x1.4c9786c226827p+9,  0x1.44a00262355bbp-960,  -0x1.5ba406p-3, INEXACT)
T(RN,   -0x1.4c3cc63f1413ep+9,  0x1.49cff0a8fb366p-959,   0x1.163c92p-3, INEXACT)
T(RN,   -0x1.4be205bc01a55p+9,  0x1.4f15170cdfa87p-958,   0x1.c4e85ap-4, INEXACT)
T(RN,   -0x1.4b874538ef36cp+9,  0x1.546fcc5ad1619p-957,   0x1.47df62p-2, INEXACT)
T(RN,   -0x1.4b2c84b5dcc83p+9,  0x1.59e068c2d15aep-956,   0x1.5de246p-3, INEXACT)
T(RN,   -0x1.4ad1c432ca59ap+9,  0x1.5f6745dd9f511p-955,  -0x1.a1ef08p-2, INEXACT)
T(RN,   -0x1.4a7703afb7eb1p+9,  0x1.6504beb27d741p-954,   0x1.340942p-2, INEXACT)
T(RN,   -0x1.4a1c432ca57c8p+9,  0x1.6ab92fbd0baadp-953,  -0x1.a6f032p-2, INEXACT)
T(RN,   -0x1.49c182a9930dfp+9,   0x1.7084f6f33acdp-952,   0x1.1aa37ap-2, INEXACT)
T(RN,   -0x1.4966c226809f6p+9,  0x1.766873cb58328p-951,  -0x1.f52cb4p-4, INEXACT)
T(RN,   -0x1.490c01a36e30dp+9,  0x1.7c64074231feap-950,  -0x1.199ceap-3, INEXACT)
T(RN,   -0x1.48b141205bc24p+9,  0x1.827813e1548a2p-949,  -0x1.c38662p-2, INEXACT)
T(RN,   -0x1.4856809d4953bp+9,  0x1.88a4fdc561545p-948,   0x1.322f32p-2, INEXACT)
T(RN,   -0x1.47fbc01a36e52p+9,  0x1.8eeb2aa47fe28p-947,   0x1.4f1d24p-3, INEXACT)
T(RN,   -0x1.47a0ff9724769p+9,  0x1.954b01d4e8f92p-946,  -0x1.7703c4p-7, INEXACT)
T(RN,    -0x1.47463f141208p+9,  0x1.9bc4ec538c991p-945,   0x1.4ba234p-3, INEXACT)
T(RN,   -0x1.46eb7e90ff997p+9,  0x1.a25954cad32f6p-944,   0x1.90b426p-3, INEXACT)
T(RN,   -0x1.4690be0ded2aep+9,  0x1.a908a7997a66bp-943,   0x1.b6f034p-5, INEXACT)
T(RN,   -0x1.4635fd8adabc5p+9,   0x1.afd352d98e0bp-942,  -0x1.c7ec3ep-3, INEXACT)
T(RN,   -0x1.45db3d07c84dcp+9,  0x1.b6b9c6677d72fp-941,   0x1.b41a2cp-5, INEXACT)
T(RN,   -0x1.45807c84b5df3p+9,  0x1.bdbc73e94de2ep-940,   0x1.8c72a2p-9, INEXACT)
T(RN,   -0x1.4525bc01a370ap+9,  0x1.c4dbced5ea60fp-939,  -0x1.6103c8p-2, INEXACT)
T(RN,   -0x1.44cafb7e91021p+9,  0x1.cc184c7c9171ep-938,   0x1.f75216p-3, INEXACT)
T(RN,   -0x1.44703afb7e938p+9,   0x1.d372640c6139p-937,  -0x1.2a3b84p-2, INEXACT)
T(RN,   -0x1.44157a786c24fp+9,  0x1.daea8e9c02789p-936,   0x1.c01662p-2, INEXACT)
T(RN,   -0x1.43bab9f559b66p+9,   0x1.e281473172efp-935,  -0x1.8c3f52p-2, INEXACT)
T(RN,   -0x1.435ff9724747dp+9,  0x1.ea370ac9ef93cp-934,   0x1.bb4acep-4, INEXACT)
T(RN,   -0x1.430538ef34d94p+9,  0x1.f20c5861ff336p-933,   0x1.63f5a6p-3, INEXACT)
T(RN,   -0x1.42aa786c226abp+9,  0x1.fa01b0fd9df1dp-932,   -0x1.c6131p-3, INEXACT)
T(RN,   -0x1.424fb7e90ffc2p+9,  0x1.010bcbd8451bfp-930,   0x1.3b71cep-2, INEXACT)
T(RN,   -0x1.41f4f765fd8d9p+9,  0x1.052748d359ca6p-929,   0x1.93080cp-3, INEXACT)
T(RN,    -0x1.419a36e2eb1fp+9,  0x1.09539316660fcp-928,  -0x1.e66bdap-2, INEXACT)
T(RN,   -0x1.413f765fd8b07p+9,  0x1.0d90ef5c7e725p-927,   0x1.e9129ap-6, INEXACT)
T(RN,   -0x1.40e4b5dcc641ep+9,  0x1.11dfa379def75p-926,  -0x1.dbcde4p-5, INEXACT)
T(RN,   -0x1.4089f559b3d35p+9,  0x1.163ff660693ebp-925,  -0x1.1b1494p-7, INEXACT)
T(RN,   -0x1.402f34d6a164cp+9,  0x1.1ab2302434feep-924,   0x1.1fccacp-2, INEXACT)
T(RN,   -0x1.3fd474538ef63p+9,  0x1.1f369a00332cbp-923,   0x1.8db2f8p-3, INEXACT)
T(RN,   -0x1.3f79b3d07c87ap+9,  0x1.23cd7e5ae41b9p-922,   0x1.230776p-2, INEXACT)
T(RN,   -0x1.3f1ef34d6a191p+9,  0x1.287728cb20e36p-921,   -0x1.baf0cp-2, INEXACT)
T(RN,   -0x1.3ec432ca57aa8p+9,  0x1.2d33e61cf85b6p-920,  -0x1.9abd08p-3, INEXACT)
T(RN,   -0x1.3e697247453bfp+9,  0x1.320404569ff95p-919,   0x1.46fb0ep-3, INEXACT)
T(RN,   -0x1.3e0eb1c432cd6p+9,  0x1.36e7d2bd78e74p-918,   0x1.297e3cp-2, INEXACT)
T(RN,   -0x1.3db3f141205edp+9,   0x1.3bdfa1db29a2p-917,  -0x1.592b68p-3, INEXACT)
T(RN,   -0x1.3d5930be0df04p+9,  0x1.40ebc382cc749p-916,   0x1.ccdc0ap-2, INEXACT)
T(RN,   -0x1.3cfe703afb81bp+9,  0x1.460c8ad633254p-915,  -0x1.a718aep-4, INEXACT)
T(RN,   -0x1.3ca3afb7e9132p+9,  0x1.4b424c4b402c9p-914,  -0x1.ae11dap-3, INEXACT)
T(RN,   -0x1.3c48ef34d6a49p+9,  0x1.508d5db155cc3p-913,   -0x1.4f708p-2, INEXACT)
T(RN,    -0x1.3bee2eb1c436p+9,  0x1.55ee1636db611p-912,   0x1.6a2f36p-2, INEXACT)
T(RN,   -0x1.3b936e2eb1c77p+9,  0x1.5b64ce6ed94a6p-911,  -0x1.4a09ecp-2, INEXACT)
T(RN,   -0x1.3b38adab9f58ep+9,  0x1.60f1e056abc31p-910,  -0x1.98a76ap-2, INEXACT)
T(RN,   -0x1.3added288cea5p+9,  0x1.6695a75bcd0a2p-909,  -0x1.2f600ep-3, INEXACT)
T(RN,   -0x1.3a832ca57a7bcp+9,  0x1.6c508061b73a8p-908,   0x1.c6c37ap-2, INEXACT)
T(RN,   -0x1.3a286c22680d3p+9,  0x1.7222c9c7de329p-907,  -0x1.056376p-4, INEXACT)
T(RN,   -0x1.39cdab9f559eap+9,  0x1.780ce36fc1ee5p-906,   -0x1.c08b4p-2, INEXACT)
T(RN,   -0x1.3972eb1c43301p+9,  0x1.7e0f2ec319b77p-905,   0x1.850116p-3, INEXACT)
T(RN,   -0x1.39182a9930c18p+9,  0x1.842a0eba18915p-904,  -0x1.fd3cc2p-2, INEXACT)
T(RN,   -0x1.38bd6a161e52fp+9,  0x1.8a5de7e1cb48dp-903,  -0x1.811b0ap-3, INEXACT)
T(RN,   -0x1.3862a9930be46p+9,  0x1.90ab2062908f2p-902,  -0x1.dd893ap-2, INEXACT)
T(RN,   -0x1.3807e90ff975dp+9,  0x1.97122006ab8c1p-901,  -0x1.dc4e0ap-2, INEXACT)
T(RN,   -0x1.37ad288ce7074p+9,  0x1.9d935040f152ap-900,   0x1.4b3266p-2, INEXACT)
T(RN,   -0x1.37526809d498bp+9,  0x1.a42f1c3391a67p-899,   0x1.7fdcdcp-2, INEXACT)
T(RN,   -0x1.36f7a786c22a2p+9,  0x1.aae5f0b6fb821p-898,  -0x1.d2ae68p-3, INEXACT)
T(RN,   -0x1.369ce703afbb9p+9,  0x1.b1b83c60ddcf2p-897,  -0x1.ddf794p-3, INEXACT)
T(RN,    -0x1.364226809d4dp+9,  0x1.b8a66f8b44c3bp-896,  -0x1.400868p-3, INEXACT)
T(RN,   -0x1.35e765fd8ade7p+9,  0x1.bfb0fc5bd45a9p-895,     0x1.8de1p-2, INEXACT)
T(RN,   -0x1.358ca57a786fep+9,  0x1.c6d856cb205cfp-894,   0x1.670e28p-4, INEXACT)
T(RN,   -0x1.3531e4f766015p+9,   0x1.ce1cf4ac2277p-893,  -0x1.e10e3ep-3, INEXACT)
T(RN,   -0x1.34d724745392cp+9,  0x1.d57f4db3ced1bp-892,     0x1.b445p-2, INEXACT)
T(RN,   -0x1.347c63f141243p+9,  0x1.dcffdb80c7aebp-891,  -0x1.18e1bap-3, INEXACT)
T(RN,   -0x1.3421a36e2eb5ap+9,  0x1.e49f19a330865p-890,   0x1.084ce6p-2, INEXACT)
T(RN,   -0x1.33c6e2eb1c471p+9,  0x1.ec5d85a4a1267p-889,  -0x1.b28058p-3, INEXACT)
T(RN,   -0x1.336c226809d88p+9,  0x1.f43b9f1039577p-888,   0x1.1e6be4p-2, INEXACT)
T(RN,   -0x1.331161e4f769fp+9,  0x1.fc39e77ad58a3p-887,   -0x1.faa9ep-2, INEXACT)
T(RN,   -0x1.32b6a161e4fb6p+9,  0x1.022c7145b28c2p-885,  -0x1.4cfb6cp-3, INEXACT)
T(RN,   -0x1.325be0ded28cdp+9,  0x1.064c8b01b14ecp-884,  -0x1.b2aec4p-2, INEXACT)
T(RN,   -0x1.3201205bc01e4p+9,  0x1.0a7d84e3b77c6p-883,   0x1.273166p-3, INEXACT)
T(RN,   -0x1.31a65fd8adafbp+9,  0x1.0ebfa3f407bf8p-882,  -0x1.6e36b8p-3, INEXACT)
T(RN,   -0x1.314b9f559b412p+9,  0x1.13132e5547f9ep-881,   -0x1.c8999p-3, INEXACT)
T(RN,   -0x1.30f0ded288d29p+9,  0x1.17786b49046b1p-880,   0x1.305576p-3, INEXACT)
T(RN,    -0x1.30961e4f7664p+9,  0x1.1befa334454c9p-879,   -0x1.b28b8p-3, INEXACT)
T(RN,   -0x1.303b5dcc63f57p+9,   0x1.20791fa4372fp-878,  -0x1.b12eeap-2, INEXACT)
T(RN,   -0x1.2fe09d495186ep+9,  0x1.25152b52e6648p-877,  -0x1.a3f95ep-4, INEXACT)
T(RN,   -0x1.2f85dcc63f185p+9,  0x1.29c4122c0dc6bp-876,    0x1.d05abp-3, INEXACT)
T(RN,   -0x1.2f2b1c432ca9cp+9,  0x1.2e862151f9277p-875,  -0x1.6d2f26p-4, INEXACT)
T(RN,   -0x1.2ed05bc01a3b3p+9,  0x1.335ba7227bbcdp-874,  -0x1.582e46p-4, INEXACT)
T(RN,   -0x1.2e759b3d07ccap+9,  0x1.3844f33bfad99p-873,  -0x1.a7186ep-3, INEXACT)
T(RN,   -0x1.2e1adab9f55e1p+9,  0x1.3d4256828d45ep-872,   0x1.911e92p-3, INEXACT)
T(RN,   -0x1.2dc01a36e2ef8p+9,  0x1.425423252f8c1p-871,   0x1.a90222p-5, INEXACT)
T(RN,   -0x1.2d6559b3d080fp+9,  0x1.477aaca30d8fap-870,  -0x1.092b98p-4, INEXACT)
T(RN,   -0x1.2d0a9930be126p+9,  0x1.4cb647d0e1c51p-869,   0x1.0138d2p-2, INEXACT)
T(RN,   -0x1.2cafd8adaba3dp+9,  0x1.52074ade6a634p-868,  -0x1.9d73bap-2, INEXACT)
T(RN,   -0x1.2c55182a99354p+9,  0x1.576e0d5bf4e8bp-867,   0x1.ceab9ap-6, INEXACT)
T(RN,   -0x1.2bfa57a786c6bp+9,  0x1.5ceae840004ecp-866,  0x1.4019c4p-13, INEXACT)
T(RN,   -0x1.2b9f972474582p+9,  0x1.627e35ecf6495p-865,    0x1.72fe6p-2, INEXACT)
T(RN,   -0x1.2b44d6a161e99p+9,  0x1.68285236fbef9p-864,   0x1.d6e99ap-4, INEXACT)
T(RN,    -0x1.2aea161e4f7bp+9,  0x1.6de99a69da2efp-863,   0x1.f7826ap-2, INEXACT)
T(RN,   -0x1.2a8f559b3d0c7p+9,  0x1.73c26d4efe687p-862,    0x1.de078p-2, INEXACT)
T(RN,   -0x1.2a3495182a9dep+9,  0x1.79b32b33939c3p-861,  -0x1.8eaeaep-4, INEXACT)
T(RN,   -0x1.29d9d495182f5p+9,  0x1.7fbc35eeb4871p-860,   0x1.1b41cep-2, INEXACT)
T(RN,   -0x1.297f141205c0cp+9,  0x1.85ddf0e7b7184p-859,   0x1.fcb4d8p-3, INEXACT)
T(RN,   -0x1.2924538ef3523p+9,  0x1.8c18c11c91a75p-858,     0x1.e80ep-3, INEXACT)
T(RN,   -0x1.28c9930be0e3ap+9,  0x1.926d0d285a531p-857,  -0x1.46f498p-2, INEXACT)
T(RN,   -0x1.286ed288ce751p+9,  0x1.98db3d49e0f51p-856,  -0x1.41321cp-2, INEXACT)
T(RN,   -0x1.28141205bc068p+9,  0x1.9f63bb6a6415dp-855,   0x1.f2b122p-2, INEXACT)
T(RN,   -0x1.27b95182a997fp+9,  0x1.a606f32461508p-854,   0x1.e7cc28p-3, INEXACT)
T(RN,   -0x1.275e90ff97296p+9,  0x1.acc551ca8196dp-853,  -0x1.f2a0eep-2, INEXACT)
T(RN,   -0x1.2703d07c84badp+9,  0x1.b39f466ea1c62p-852,   0x1.076b5cp-3, INEXACT)
T(RN,   -0x1.26a90ff9724c4p+9,   0x1.ba9541e8f802p-851,  -0x1.a90594p-3, INEXACT)
T(RN,   -0x1.264e4f765fddbp+9,  0x1.c1a7b6df564adp-850,   0x1.c424f8p-2, INEXACT)
T(RN,   -0x1.25f38ef34d6f2p+9,  0x1.c8d719cc8ac63p-849,   0x1.b4b936p-5, INEXACT)
T(RN,   -0x1.2598ce703b009p+9,  0x1.d023e107de34cp-848,   0x1.1adc38p-3, INEXACT)
T(RN,    -0x1.253e0ded2892p+9,  0x1.d78e84ccb10edp-847,   0x1.f8564cp-5, INEXACT)
T(RN,   -0x1.24e34d6a16237p+9,  0x1.df177f4237c6cp-846,  -0x1.afe2a2p-3, INEXACT)
T(RN,   -0x1.24888ce703b4ep+9,  0x1.e6bf4c8356afcp-845,  -0x1.a96596p-2, INEXACT)
T(RN,   -0x1.242dcc63f1465p+9,  0x1.ee866aa69e0a9p-844,  -0x1.840838p-2, INEXACT)
T(RN,   -0x1.23d30be0ded7cp+9,  0x1.f66d59c666bbdp-843,   0x1.7aa14ep-2, INEXACT)
T(RN,   -0x1.23784b5dcc693p+9,  0x1.fe749c0910314p-842,   0x1.2c9eccp-7, INEXACT)
T(RN,   -0x1.231d8adab9faap+9,  0x1.034e5ad4afff3p-840,  -0x1.f7d2aep-6, INEXACT)
T(RN,   -0x1.22c2ca57a78c1p+9,  0x1.0773167f81dcap-839,   0x1.8bba08p-2, INEXACT)
T(RN,   -0x1.226809d4951d8p+9,  0x1.0ba8c5439ad23p-838,   0x1.e0c694p-2, INEXACT)
T(RN,   -0x1.220d495182aefp+9,  0x1.0fefac76c25a1p-837,   0x1.526254p-4, INEXACT)
T(RN,   -0x1.21b288ce70406p+9,  0x1.1448128a603ffp-836,  -0x1.df820cp-4, INEXACT)
T(RN,   -0x1.2157c84b5dd1dp+9,  0x1.18b23f1004d8ep-835,  -0x1.6fcdf2p-3, INEXACT)
T(RN,   -0x1.20fd07c84b634p+9,  0x1.1d2e7abe03c56p-834,  -0x1.4fdc9cp-2, INEXACT)
T(RN,   -0x1.20a2474538f4bp+9,  0x1.21bd0f7421896p-833,   0x1.9f77aap-3, INEXACT)
T(RN,   -0x1.204786c226862p+9,  0x1.265e48405446fp-832,    0x1.428aep-3, INEXACT)
T(RN,   -0x1.1fecc63f14179p+9,  0x1.2b12716397ea9p-831,  -0x1.a89be8p-2, INEXACT)
T(RN,    -0x1.1f9205bc01a9p+9,  0x1.2fd9d856d6181p-830,  -0x1.25865ep-7, INEXACT)
T(RN,   -0x1.1f374538ef3a7p+9,  0x1.34b4cbcfe228cp-829,   0x1.dd465ap-2, INEXACT)
T(RN,   -0x1.1edc84b5dccbep+9,  0x1.39a39bc6898dbp-828,   0x1.337c9ap-2, INEXACT)
T(RN,   -0x1.1e81c432ca5d5p+9,  0x1.3ea69979b8e8ep-827,  -0x1.ab8adcp-2, INEXACT)
T(RN,   -0x1.1e2703afb7eecp+9,  0x1.43be1774b6324p-826,  -0x1.83f908p-6, INEXACT)
T(RN,   -0x1.1dcc432ca5803p+9,  0x1.48ea6994703e4p-825,   0x1.88ac0cp-3, INEXACT)
T(RN,   -0x1.1d7182a99311ap+9,  0x1.4e2be50ce3fe4p-824,    -0x1.59ecp-2, INEXACT)
T(RN,   -0x1.1d16c22680a31p+9,  0x1.5382e06e97d31p-823,  -0x1.b348cep-2, INEXACT)
T(RN,   -0x1.1cbc01a36e348p+9,  0x1.58efb3ac2d4bbp-822,   -0x1.4629ap-2, INEXACT)
T(RN,   -0x1.1c6141205bc5fp+9,  0x1.5e72b82009acap-821,    0x1.dcc83p-3, INEXACT)
T(RN,   -0x1.1c06809d49576p+9,  0x1.640c4892159c6p-820,  -0x1.19f982p-4, INEXACT)
T(RN,   -0x1.1babc01a36e8dp+9,  0x1.69bcc13d94547p-819,   -0x1.20449p-5, INEXACT)
T(RN,   -0x1.1b50ff97247a4p+9,  0x1.6f847fd712b62p-818,  -0x1.0ab838p-6, INEXACT)
T(RN,   -0x1.1af63f14120bbp+9,  0x1.7563e3926ea5dp-817,   0x1.1f4984p-2, INEXACT)
T(RN,   -0x1.1a9b7e90ff9d2p+9,  0x1.7b5b4d28f70f5p-816,   0x1.d0fc68p-2, INEXACT)
T(RN,   -0x1.1a40be0ded2e9p+9,  0x1.816b1edfa4f8ap-815,   0x1.c85bd4p-2, INEXACT)
T(RN,     -0x1.19e5fd8adacp+9,  0x1.8793bc8d6e095p-814,   0x1.831cfcp-5, INEXACT)
T(RN,   -0x1.198b3d07c8517p+9,  0x1.8dd58ba1b0eedp-813,  -0x1.cbb84ap-3, INEXACT)
T(RN,   -0x1.19307c84b5e2ep+9,  0x1.9430f32abc075p-812,   0x1.8878e4p-2, INEXACT)
T(RN,   -0x1.18d5bc01a3745p+9,  0x1.9aa65bdc6ebeap-811,   0x1.d9c032p-3, INEXACT)
T(RN,   -0x1.187afb7e9105cp+9,  0x1.a1363016f60aep-810,    0x1.0dbcdp-2, INEXACT)
T(RN,   -0x1.18203afb7e973p+9,  0x1.a7e0dbeda476fp-809,   0x1.a0a1ccp-2, INEXACT)
T(RN,   -0x1.17c57a786c28ap+9,  0x1.aea6cd2de62c2p-808,  -0x1.26c5dep-3, INEXACT)
T(RN,   -0x1.176ab9f559ba1p+9,  0x1.b5887366516d9p-807,   -0x1.f8d93p-4, INEXACT)
T(RN,   -0x1.170ff972474b8p+9,  0x1.bc863fedd3f91p-806,   0x1.f522fcp-2, INEXACT)
T(RN,   -0x1.16b538ef34dcfp+9,  0x1.c3a0a5eafdc44p-805,  -0x1.6dcbd4p-2, INEXACT)
T(RN,   -0x1.165a786c226e6p+9,  0x1.cad81a5b698e6p-804,   0x1.102168p-2, INEXACT)
T(RN,   -0x1.15ffb7e90fffdp+9,  0x1.d22d141b43bf4p-803,  -0x1.ec7c16p-4, INEXACT)
T(RN,   -0x1.15a4f765fd914p+9,  0x1.d9a00becf011ap-802,   0x1.0869cep-2, INEXACT)
T(RN,   -0x1.154a36e2eb22bp+9,  0x1.e1317c80ce84ap-801,  -0x1.37ab6ap-4, INEXACT)
T(RN,   -0x1.14ef765fd8b42p+9,  0x1.e8e1e27d20162p-800,   0x1.3138dcp-4, INEXACT)
T(RN,   -0x1.1494b5dcc6459p+9,  0x1.f0b1bc860bc69p-799,  -0x1.84be22p-3, INEXACT)
T(RN,    -0x1.1439f559b3d7p+9,  0x1.f8a18b45c46b8p-798,   0x1.31de78p-2, INEXACT)
T(RN,   -0x1.13df34d6a1687p+9,   0x1.0058e8ba67ebp-796,  -0x1.062bdap-3, INEXACT)
T(RN,   -0x1.138474538ef9ep+9,  0x1.047189f137eb4p-795,   0x1.6da3cap-2, INEXACT)
T(RN,   -0x1.1329b3d07c8b5p+9,  0x1.089aecbe96d37p-794,   0x1.0e5e5ap-2, INEXACT)
T(RN,   -0x1.12cef34d6a1ccp+9,  0x1.0cd555adc424dp-793,  -0x1.000a58p-7, INEXACT)
T(RN,   -0x1.127432ca57ae3p+9,  0x1.11210a626335ap-792,  -0x1.0d9a9ap-3, INEXACT)
T(RN,   -0x1.12197247453fap+9,   0x1.157e519cf62cp-791,  -0x1.df818ep-2, INEXACT)
T(RN,   -0x1.11beb1c432d11p+9,  0x1.19ed733f6b4cep-790,  -0x1.700bdap-3, INEXACT)
T(RN,   -0x1.1163f14120628p+9,  0x1.1e6eb851bce98p-789,  -0x1.9d07fap-2, INEXACT)
T(RN,   -0x1.110930be0df3fp+9,  0x1.23026b06a4387p-788,  -0x1.bbfdf8p-3, INEXACT)
T(RN,   -0x1.10ae703afb856p+9,  0x1.27a8d6c05f669p-787,   0x1.9bd2dap-2, INEXACT)
T(RN,   -0x1.1053afb7e916dp+9,  0x1.2c6248158b2f4p-786,  -0x1.7a3484p-2, INEXACT)
T(RN,   -0x1.0ff8ef34d6a84p+9,  0x1.312f0cd6104bfp-785,  -0x1.c3c10ap-3, INEXACT)
T(RN,   -0x1.0f9e2eb1c439bp+9,  0x1.360f7410250afp-784,  -0x1.46b8acp-2, INEXACT)
T(RN,   -0x1.0f436e2eb1cb2p+9,  0x1.3b03ce156361ap-783,   0x1.c9df3ep-3, INEXACT)
T(RN,   -0x1.0ee8adab9f5c9p+9,  0x1.400c6c7ff3cc5p-782,  -0x1.3fea22p-2, INEXACT)
T(RN,    -0x1.0e8ded288ceep+9,  0x1.4529a237cd524p-781,   0x1.f1a77ap-4, INEXACT)
T(RN,   -0x1.0e332ca57a7f7p+9,  0x1.4a5bc3780b02bp-780,   0x1.e60ea8p-3, INEXACT)
T(RN,   -0x1.0dd86c226810ep+9,  0x1.4fa325d457447p-779,   0x1.911516p-3, INEXACT)
T(RN,   -0x1.0d7dab9f55a25p+9,  0x1.5500203e6d501p-778,   0x1.896c24p-3, INEXACT)
T(RN,   -0x1.0d22eb1c4333cp+9,  0x1.5a730b0bb12fdp-777,  -0x1.15c9d2p-4, INEXACT)
T(RN,   -0x1.0cc82a9930c53p+9,  0x1.5ffc3ffadea18p-776,  -0x1.7bae56p-4, INEXACT)
T(RN,   -0x1.0c6d6a161e56ap+9,  0x1.659c1a39cf37ap-775,   -0x1.7661ep-3, INEXACT)
T(RN,   -0x1.0c12a9930be81p+9,  0x1.6b52f66b58193p-774,  -0x1.bf5702p-2, INEXACT)
T(RN,   -0x1.0bb7e90ff9798p+9,  0x1.712132ad3fc0ap-773,  -0x1.50b094p-4, INEXACT)
T(RN,   -0x1.0b5d288ce70afp+9,  0x1.77072e9e4c1bep-772,   0x1.1b4e72p-2, INEXACT)
T(RN,   -0x1.0b026809d49c6p+9,  0x1.7d054b646971bp-771,  -0x1.9aa50cp-3, INEXACT)
T(RN,   -0x1.0aa7a786c22ddp+9,  0x1.831bebb2ea716p-770,  -0x1.fbf746p-3, INEXACT)
T(RN,   -0x1.0a4ce703afbf4p+9,  0x1.894b73d0e1d38p-769,  -0x1.812a6cp-5, INEXACT)
T(RN,   -0x1.09f226809d50bp+9,  0x1.8f94499f95f4cp-768,  -0x1.62dd9ep-4, INEXACT)
T(RN,   -0x1.099765fd8ae22p+9,  0x1.95f6d4a10ed4fp-767,  -0x1.f324acp-2, INEXACT)
T(RN,   -0x1.093ca57a78739p+9,  0x1.9c737dfebee62p-766,   -0x1.b8776p-4, INEXACT)
T(RN,    -0x1.08e1e4f76605p+9,  0x1.a30ab09047194p-765,  -0x1.69c406p-2, INEXACT)
T(RN,   -0x1.0887247453967p+9,  0x1.a9bcd8e256989p-764,   0x1.5d9686p-2, INEXACT)
T(RN,   -0x1.082c63f14127ep+9,  0x1.b08a653da69fcp-763,   -0x1.63c05p-4, INEXACT)
T(RN,   -0x1.07d1a36e2eb95p+9,  0x1.b773c5ae12e66p-762,   -0x1.d2014p-2, INEXACT)
T(RN,   -0x1.0776e2eb1c4acp+9,    0x1.be796c09cf1p-761,   0x1.b1afe6p-3, INEXACT)
T(RN,   -0x1.071c226809dc3p+9,  0x1.c59bcbf8b9997p-760,    0x1.b0584p-3, INEXACT)
T(RN,   -0x1.06c161e4f76dap+9,  0x1.ccdb5afbccbc2p-759,  -0x1.742a14p-2, INEXACT)
T(RN,   -0x1.0666a161e4ff1p+9,  0x1.d4389074adc17p-758,  -0x1.60782ap-4, INEXACT)
T(RN,   -0x1.060be0ded2908p+9,  0x1.dbb3e5ad5b429p-757,   0x1.7b0c46p-3, INEXACT)
T(RN,   -0x1.05b1205bc021fp+9,  0x1.e34dd5dffad41p-756,   0x1.f699dcp-2, INEXACT)
T(RN,   -0x1.05565fd8adb36p+9,  0x1.eb06de3ec69cfp-755,   0x1.73397ep-2, INEXACT)
T(RN,   -0x1.04fb9f559b44dp+9,  0x1.f2df7dfc1b5c3p-754,  -0x1.b6bd94p-2, INEXACT)
T(RN,   -0x1.04a0ded288d64p+9,  0x1.fad83652a7618p-753,   0x1.9badfap-2, INEXACT)
T(RN,   -0x1.04461e4f7667bp+9,  0x1.0178c546dd7f9p-751,  -0x1.b060aep-5, INEXACT)
T(RN,   -0x1.03eb5dcc63f92p+9,  0x1.05960008dd7fdp-750,   0x1.82b936p-6, INEXACT)
T(RN,   -0x1.03909d49518a9p+9,  0x1.09c40f325ad43p-749,   -0x1.7b773p-6, INEXACT)
T(RN,    -0x1.0335dcc63f1cp+9,   0x1.0e03379b8d6cp-748,  -0x1.6ff924p-2, INEXACT)
T(RN,   -0x1.02db1c432cad7p+9,  0x1.1253bf364be7cp-747,  -0x1.46b512p-2, INEXACT)
T(RN,   -0x1.02805bc01a3eep+9,  0x1.16b5ed128b9bfp-746,    0x1.c8ad2p-3, INEXACT)
T(RN,   -0x1.02259b3d07d05p+9,  0x1.1b2a0962f2fc6p-745,  -0x1.41bebep-2, INEXACT)
T(RN,   -0x1.01cadab9f561cp+9,  0x1.1fb05d817ebbbp-744, -0x1.1cdb76p-14, INEXACT)
T(RN,   -0x1.01701a36e2f33p+9,  0x1.244933f439ea6p-743,    0x1.0f3fdp-3, INEXACT)
T(RN,   -0x1.011559b3d084ap+9,  0x1.28f4d87209649p-742,   0x1.222b7cp-2, INEXACT)
T(RN,   -0x1.00ba9930be161p+9,  0x1.2db397e78adc6p-741,   0x1.f74594p-3, INEXACT)
T(RN,   -0x1.005fd8adaba78p+9,  0x1.3285c07c07d1bp-740,   0x1.d9f2aep-3, INEXACT)
T(RN,   -0x1.0005182a9938fp+9,  0x1.376ba1967cc88p-739,  -0x1.844266p-5, INEXACT)
T(RN,   -0x1.ff54af4f0d94cp+8,   0x1.3c658be2b511p-738,  -0x1.760422p-4, INEXACT)
T(RN,   -0x1.fe9f2e48e8b7ap+8,  0x1.4173d1567b752p-737,  -0x1.61350cp-2, INEXACT)
T(RN,   -0x1.fde9ad42c3da8p+8,  0x1.4696c536e0219p-736,   0x1.469c6ap-2, INEXACT)
T(RN,   -0x1.fd342c3c9efd6p+8,  0x1.4bcebc1d94205p-735,  -0x1.d31a78p-3, INEXACT)
T(RN,   -0x1.fc7eab367a204p+8,  0x1.511c0bfe5abe4p-734,  -0x1.5760bep-2, INEXACT)
T(RN,   -0x1.fbc92a3055432p+8,  0x1.567f0c2c9133dp-733,   -0x1.eb514p-6, INEXACT)
T(RN,    -0x1.fb13a92a3066p+8,  0x1.5bf81560cced1p-732,  -0x1.ea91b8p-3, INEXACT)
T(RN,   -0x1.fa5e28240b88ep+8,  0x1.618781be90cd6p-731,  -0x1.5b5814p-2, INEXACT)
T(RN,   -0x1.f9a8a71de6abcp+8,  0x1.672dacda19cc6p-730,  -0x1.efed44p-3, INEXACT)
T(RN,   -0x1.f8f32617c1ceap+8,  0x1.6ceaf3be434c1p-729,  -0x1.251812p-2, INEXACT)
T(RN,   -0x1.f83da5119cf18p+8,  0x1.72bfb4f283892p-728,   0x1.a28e82p-2, INEXACT)
T(RN,   -0x1.f788240b78146p+8,  0x1.78ac508100879p-727,  -0x1.7c3c06p-2, INEXACT)
T(RN,   -0x1.f6d2a30553374p+8,  0x1.7eb127fcbde0fp-726,   0x1.b5492cp-4, INEXACT)
T(RN,   -0x1.f61d21ff2e5a2p+8,  0x1.84ce9e87e3d82p-725,  -0x1.8741fap-2, INEXACT)
T(RN,    -0x1.f567a0f9097dp+8,  0x1.8b0518da201c4p-724,  -0x1.8c70e8p-3, INEXACT)
T(RN,   -0x1.f4b21ff2e49fep+8,  0x1.9154fd4720a1cp-723,  -0x1.eed078p-8, INEXACT)
T(RN,   -0x1.f3fc9eecbfc2cp+8,  0x1.97beb3c528fddp-722,   0x1.624d7cp-2, INEXACT)
T(RN,   -0x1.f3471de69ae5ap+8,  0x1.9e42a5f3c2afbp-721,  -0x1.e0532cp-2, INEXACT)
T(RN,   -0x1.f2919ce076088p+8,  0x1.a4e13f2288c6ep-720,   0x1.980ed2p-3, INEXACT)
T(RN,   -0x1.f1dc1bda512b6p+8,  0x1.ab9aec580f54bp-719,  -0x1.cbf5a4p-2, INEXACT)
T(RN,   -0x1.f1269ad42c4e4p+8,  0x1.b2701c58e71d1p-718,  -0x1.c4026cp-2, INEXACT)
T(RN,   -0x1.f07119ce07712p+8,  0x1.b9613faebdf7ep-717,   0x1.8be39cp-2, INEXACT)
T(RN,    -0x1.efbb98c7e294p+8,  0x1.c06ec8af9c599p-716,  -0x1.126956p-7, INEXACT)
T(RN,   -0x1.ef0617c1bdb6ep+8,  0x1.c7992b85407a5p-715,    -0x1.c4bep-4, INEXACT)
T(RN,   -0x1.ee5096bb98d9cp+8,  0x1.cee0de349793ep-714,  -0x1.ae9722p-2, INEXACT)
T(RN,   -0x1.ed9b15b573fcap+8,  0x1.d64658a555b26p-713,   0x1.27a0acp-3, INEXACT)
T(RN,   -0x1.ece594af4f1f8p+8,  0x1.ddca14a9ac942p-712,    0x1.2557fp-4, INEXACT)
T(RN,   -0x1.ec3013a92a426p+8,  0x1.e56c8e0622189p-711,   0x1.7bb772p-2, INEXACT)
T(RN,   -0x1.eb7a92a305654p+8,  0x1.ed2e427986be3p-710,  -0x1.b3fc24p-2, INEXACT)
T(RN,   -0x1.eac5119ce0882p+8,   0x1.f50fb1c50cb4p-709,   0x1.a7eabap-3, INEXACT)
T(RN,    -0x1.ea0f9096bbabp+8,   0x1.fd115db48002p-708,  -0x1.c119aap-3, INEXACT)
T(RN,   -0x1.e95a0f9096cdep+8,  0x1.0299e51350292p-706,   0x1.31ab0ap-3, INEXACT)
T(RN,   -0x1.e8a48e8a71f0cp+8,  0x1.06bbbe8ace70ep-705,  -0x1.687d68p-3, INEXACT)
T(RN,   -0x1.e7ef0d844d13ap+8,  0x1.0aee7f4fd9938p-704,  -0x1.cf70dep-2, INEXACT)
T(RN,   -0x1.e7398c7e28368p+8,  0x1.0f326c87f85d4p-703,  -0x1.4593acp-2, INEXACT)
T(RN,   -0x1.e6840b7803596p+8,  0x1.1387cc738c893p-702,    0x1.fe0fdp-3, INEXACT)
T(RN,   -0x1.e5ce8a71de7c4p+8,  0x1.17eee67257d1bp-701,   0x1.9c279cp-2, INEXACT)
T(RN,   -0x1.e519096bb99f2p+8,  0x1.1c680308137e4p-700,   0x1.7d0bbcp-2, INEXACT)
T(RN,    -0x1.e463886594c2p+8,  0x1.20f36be11ab9ep-699,  -0x1.dfcc66p-3, INEXACT)
T(RN,   -0x1.e3ae075f6fe4ep+8,  0x1.25916bd727ff5p-698,   -0x1.b69bep-3, INEXACT)
T(RN,   -0x1.e2f886594b07cp+8,  0x1.2a424ef625e8bp-697,   0x1.141a38p-2, INEXACT)
T(RN,   -0x1.e2430553262aap+8,  0x1.2f06628113b25p-696,  -0x1.fe055ap-2, INEXACT)
T(RN,   -0x1.e18d844d014d8p+8,  0x1.33ddf4f6fdc18p-695,   0x1.e3e796p-2, INEXACT)
T(RN,   -0x1.e0d80346dc706p+8,  0x1.38c956180a7fcp-694,  -0x1.6962eep-2, INEXACT)
T(RN,   -0x1.e0228240b7934p+8,  0x1.3dc8d6ea9be02p-693,   0x1.8da656p-2, INEXACT)
T(RN,   -0x1.df6d013a92b62p+8,  0x1.42dcc9c085e02p-692,  -0x1.9911c8p-4, INEXACT)
T(RN,    -0x1.deb780346dd9p+8,  0x1.4805823c5a5d1p-691,  -0x1.521faap-5, INEXACT)
T(RN,   -0x1.de01ff2e48fbep+8,  0x1.4d435556ca929p-690,  -0x1.03c22cp-2, INEXACT)
T(RN,   -0x1.dd4c7e28241ecp+8,  0x1.529699641e9cap-689,  -0x1.9adcd4p-3, INEXACT)
T(RN,   -0x1.dc96fd21ff41ap+8,  0x1.57ffa619c3564p-688,    0x1.b414bp-2, INEXACT)
T(RN,   -0x1.dbe17c1bda648p+8,  0x1.5d7ed493eef07p-687,  -0x1.30665ep-4, INEXACT)
T(RN,   -0x1.db2bfb15b5876p+8,  0x1.63147f5b5c9efp-686,  -0x1.c25b5ap-2, INEXACT)
T(RN,   -0x1.da767a0f90aa4p+8,  0x1.68c1026b1fb84p-685,   0x1.d1b264p-2, INEXACT)
T(RN,   -0x1.d9c0f9096bcd2p+8,  0x1.6e84bb368ea95p-684,   0x1.e899fap-2, INEXACT)
T(RN,     -0x1.d90b780346fp+8,  0x1.746008af461eep-683,  -0x1.92d848p-2, INEXACT)
T(RN,   -0x1.d855f6fd2212ep+8,  0x1.7a534b4b44c6cp-682,   0x1.8f8f62p-2, INEXACT)
T(RN,   -0x1.d7a075f6fd35cp+8,  0x1.805ee50b200d5p-681,  -0x1.e233eap-3, INEXACT)
T(RN,   -0x1.d6eaf4f0d858ap+8,  0x1.86833980523f3p-680,  -0x1.9a2238p-3, INEXACT)
T(RN,   -0x1.d63573eab37b8p+8,  0x1.8cc0add3a274ap-679,  -0x1.afe66ap-3, INEXACT)
T(RN,   -0x1.d57ff2e48e9e6p+8,  0x1.9317a8cba6b1fp-678,  -0x1.c49c76p-2, INEXACT)
T(RN,   -0x1.d4ca71de69c14p+8,  0x1.998892d360a75p-677,  -0x1.c40e1cp-4, INEXACT)
T(RN,   -0x1.d414f0d844e42p+8,  0x1.a013d600f57cep-676,  -0x1.c1d60ep-2, INEXACT)
T(RN,    -0x1.d35f6fd22007p+8,  0x1.a6b9de1c811a5p-675,  -0x1.75a1ccp-2, INEXACT)
T(RN,   -0x1.d2a9eecbfb29ep+8,  0x1.ad7b18a705599p-674,   0x1.810a7ep-2, INEXACT)
T(RN,   -0x1.d1f46dc5d64ccp+8,  0x1.b457f4e175976p-673,   0x1.949a66p-2, INEXACT)
T(RN,   -0x1.d13eecbfb16fap+8,  0x1.bb50e3d3df15fp-672,   0x1.d5d8dcp-2, INEXACT)
T(RN,   -0x1.d0896bb98c928p+8,  0x1.c2665854aea6bp-671,  -0x1.2f8482p-2, INEXACT)
T(RN,   -0x1.cfd3eab367b56p+8,  0x1.c998c71014141p-670,  -0x1.04d8a2p-3, INEXACT)
T(RN,   -0x1.cf1e69ad42d84p+8,  0x1.d0e8a68f83c3cp-669,  -0x1.be8622p-2, INEXACT)
T(RN,   -0x1.ce68e8a71dfb2p+8,  0x1.d8566f41570e7p-668,    0x1.788cap-2, INEXACT)
T(RN,    -0x1.cdb367a0f91ep+8,  0x1.dfe29b808bc92p-667,   0x1.4da274p-3, INEXACT)
T(RN,   -0x1.ccfde69ad440ep+8,  0x1.e78da79ca3814p-666,  -0x1.15fc14p-2, INEXACT)
T(RN,   -0x1.cc486594af63cp+8,  0x1.ef5811e1a2ebep-665,   0x1.975e5ep-3, INEXACT)
T(RN,   -0x1.cb92e48e8a86ap+8,  0x1.f7425aa0320c3p-664,  -0x1.06f25ep-2, INEXACT)
T(RN,   -0x1.cadd638865a98p+8,  0x1.ff4d0435dd97dp-663,   0x1.608402p-3, INEXACT)
T(RN,   -0x1.ca27e28240cc6p+8,  0x1.03bc498abd0fcp-661,   0x1.ea9458p-2, INEXACT)
T(RN,   -0x1.c972617c1bef4p+8,  0x1.07e2c6e7d4c3cp-660,  -0x1.368f72p-2, INEXACT)
T(RN,   -0x1.c8bce075f7122p+8,  0x1.0c1a3e8dc1ae1p-659,  -0x1.6b63f8p-2, INEXACT)
T(RN,    -0x1.c8075f6fd235p+8,  0x1.1062f5efb047bp-658,   0x1.7ea006p-2, INEXACT)
T(RN,   -0x1.c751de69ad57ep+8,  0x1.14bd339ce5992p-657,   -0x1.e74ccp-2, INEXACT)
T(RN,   -0x1.c69c5d63887acp+8,  0x1.19293f45495ebp-656,  -0x1.1e2e4cp-3, INEXACT)
T(RN,   -0x1.c5e6dc5d639dap+8,  0x1.1da761be02bdbp-655,   0x1.38872cp-4, INEXACT)
T(RN,   -0x1.c5315b573ec08p+8,  0x1.2237e50627d87p-654,   0x1.deb964p-2, INEXACT)
T(RN,   -0x1.c47bda5119e36p+8,  0x1.26db144b808ccp-653,  -0x1.808952p-2, INEXACT)
T(RN,   -0x1.c3c6594af5064p+8,  0x1.2b913bef5cac7p-652,  -0x1.aceb2ep-2, INEXACT)
T(RN,   -0x1.c310d844d0292p+8,  0x1.305aa98b7dfe4p-651,  -0x1.9abed4p-3, INEXACT)
T(RN,    -0x1.c25b573eab4cp+8,  0x1.3537abf716597p-650,   0x1.b3c9f6p-8, INEXACT)
T(RN,   -0x1.c1a5d638866eep+8,  0x1.3a28934bda2d7p-649,   0x1.aa2bacp-3, INEXACT)
T(RN,   -0x1.c0f055326191cp+8,  0x1.3f2db0eb27c96p-648,   0x1.66ad84p-3, INEXACT)
T(RN,   -0x1.c03ad42c3cb4ap+8,  0x1.4447578343b86p-647,   0x1.6503d4p-2, INEXACT)
T(RN,   -0x1.bf85532617d78p+8,  0x1.4975db14aa88bp-646,   0x1.9727acp-2, INEXACT)
T(RN,   -0x1.becfd21ff2fa6p+8,  0x1.4eb990f778558p-645,  -0x1.7fc1c8p-2, INEXACT)
T(RN,   -0x1.be1a5119ce1d4p+8,  0x1.5412cfe0e66c8p-644,   0x1.eff8e8p-7, INEXACT)
T(RN,   -0x1.bd64d013a9402p+8,  0x1.5981efe8df68ep-643,  -0x1.844f7cp-5, INEXACT)
T(RN,    -0x1.bcaf4f0d8463p+8,  0x1.5f074a8faa20fp-642,  -0x1.dc78ecp-2, INEXACT)
T(RN,   -0x1.bbf9ce075f85ep+8,  0x1.64a33ac3abc2ap-641,  -0x1.b9725ap-4, INEXACT)
T(RN,   -0x1.bb444d013aa8cp+8,  0x1.6a561ce7417dfp-640,   0x1.49a034p-4, INEXACT)
T(RN,   -0x1.ba8ecbfb15cbap+8,  0x1.70204ed6b21e3p-639,  -0x1.36b902p-3, INEXACT)
T(RN,   -0x1.b9d94af4f0ee8p+8,  0x1.76022fee37f37p-638,  -0x1.47984cp-5, INEXACT)
T(RN,   -0x1.b923c9eecc116p+8,  0x1.7bfc2110236f9p-637,  -0x1.223c04p-2, INEXACT)
T(RN,   -0x1.b86e48e8a7344p+8,  0x1.820e84ab16dc8p-636,  -0x1.b6486cp-4, INEXACT)
T(RN,   -0x1.b7b8c7e282572p+8,  0x1.8839bec05b91bp-635,   0x1.e6f1e2p-2, INEXACT)
T(RN,    -0x1.b70346dc5d7ap+8,  0x1.8e7e34ea51117p-634,   0x1.55463ep-2, INEXACT)
T(RN,   -0x1.b64dc5d6389cep+8,  0x1.94dc4e62f6785p-633,    0x1.2bb7ep-2, INEXACT)
T(RN,   -0x1.b59844d013bfcp+8,  0x1.9b54740a8ea99p-632,  -0x1.497a7ep-7, INEXACT)
T(RN,   -0x1.b4e2c3c9eee2ap+8,  0x1.a1e7106e5fa6cp-631,   0x1.666b8ap-2, INEXACT)
T(RN,   -0x1.b42d42c3ca058p+8,  0x1.a8948fcf8d80fp-630,  -0x1.b2753ep-2, INEXACT)
T(RN,   -0x1.b377c1bda5286p+8,  0x1.af5d602a11557p-629,    0x1.de631p-4, INEXACT)
T(RN,   -0x1.b2c240b7804b4p+8,  0x1.b641f13bccc73p-628,   0x1.c7da42p-3, INEXACT)
T(RN,   -0x1.b20cbfb15b6e2p+8,  0x1.bd42b48bba6b3p-627,   0x1.6a445cp-2, INEXACT)
T(RN,    -0x1.b1573eab3691p+8,  0x1.c4601d713b9cep-626,  -0x1.176c0ep-4, INEXACT)
T(RN,   -0x1.b0a1bda511b3ep+8,  0x1.cb9aa11b8433bp-625,  -0x1.7916c8p-2, INEXACT)
T(RN,   -0x1.afec3c9eecd6cp+8,  0x1.d2f2b69924937p-624,  -0x1.53767cp-2, INEXACT)
T(RN,   -0x1.af36bb98c7f9ap+8,  0x1.da68d6dfb2941p-623,   0x1.1b4b2cp-2, INEXACT)
T(RN,   -0x1.ae813a92a31c8p+8,  0x1.e1fd7cd391beap-622,  -0x1.49a10ap-3, INEXACT)
T(RN,   -0x1.adcbb98c7e3f6p+8,  0x1.e9b1254fdb605p-621,  -0x1.197d18p-3, INEXACT)
T(RN,   -0x1.ad16388659624p+8,  0x1.f1844f2e66f4ap-620,   0x1.d8b814p-3, INEXACT)
T(RN,   -0x1.ac60b78034852p+8,   0x1.f9777b4ff36cp-619,  -0x1.0b6b8cp-3, INEXACT)
T(RN,    -0x1.abab367a0fa8p+8,  0x1.00c5965238ea9p-617,   0x1.1148e2p-4, INEXACT)
T(RN,   -0x1.aaf5b573eacaep+8,  0x1.04dff419b8f87p-616,   0x1.b8eb16p-2, INEXACT)
T(RN,   -0x1.aa40346dc5edcp+8,  0x1.090b1a92589e2p-615,   -0x1.c149ep-2, INEXACT)
T(RN,   -0x1.a98ab367a110ap+8,  0x1.0d474e64667efp-614,   0x1.bc6572p-4, INEXACT)
T(RN,   -0x1.a8d532617c338p+8,  0x1.1194d5510bf1ep-613,   0x1.bfa0cep-3, INEXACT)
T(RN,   -0x1.a81fb15b57566p+8,  0x1.15f3f636c9e33p-612,  -0x1.0256eap-2, INEXACT)
T(RN,   -0x1.a76a305532794p+8,  0x1.1a64f91608113p-611,  -0x1.5f49e6p-2, INEXACT)
T(RN,   -0x1.a6b4af4f0d9c2p+8,  0x1.1ee82715b6efcp-610,   0x1.40dd18p-5, INEXACT)
T(RN,    -0x1.a5ff2e48e8bfp+8,   0x1.237dca88047fp-609,   0x1.f17942p-6, INEXACT)
T(RN,   -0x1.a549ad42c3e1ep+8,  0x1.28262eef2462cp-608,   0x1.663b8cp-2, INEXACT)
T(RN,   -0x1.a4942c3c9f04cp+8,  0x1.2ce1a1022b88fp-607,   0x1.95f672p-2, INEXACT)
T(RN,   -0x1.a3deab367a27ap+8,  0x1.31b06eb1ffafbp-606,  -0x1.3a94dep-2, INEXACT)
T(RN,   -0x1.a3292a30554a8p+8,  0x1.3692e72e5b1c1p-605,    0x1.9f8a1p-7, INEXACT)
T(RN,   -0x1.a273a92a306d6p+8,  0x1.3b895aeae4d39p-604,  -0x1.0659a6p-2, INEXACT)
T(RN,   -0x1.a1be28240b904p+8,  0x1.40941ba45dad8p-603,  -0x1.40878ap-4, INEXACT)
T(RN,   -0x1.a108a71de6b32p+8,  0x1.45b37c65e2902p-602,  -0x1.4cdf7cp-4, INEXACT)
T(RN,    -0x1.a0532617c1d6p+8,  0x1.4ae7d18e44313p-601,  -0x1.a4f76cp-6, INEXACT)
T(RN,   -0x1.9f9da5119cf8ep+8,  0x1.503170d574b14p-600,  -0x1.8de198p-2, INEXACT)
T(RN,   -0x1.9ee8240b781bcp+8,  0x1.5590b1520b6bbp-599,   0x1.eef8fap-2, INEXACT)
T(RN,   -0x1.9e32a305533eap+8,  0x1.5b05eb7edf556p-598,   0x1.5b3152p-2, INEXACT)
T(RN,   -0x1.9d7d21ff2e618p+8,  0x1.60917940b847bp-597,   -0x1.b5a35p-2, INEXACT)
T(RN,   -0x1.9cc7a0f909846p+8,  0x1.6633b5ec17945p-596,   0x1.d35348p-3, INEXACT)
T(RN,   -0x1.9c121ff2e4a74p+8,  0x1.6becfe4b18415p-595,   0x1.71896cp-2, INEXACT)
T(RN,   -0x1.9b5c9eecbfca2p+8,  0x1.71bdb0a3674f4p-594,   0x1.341cf6p-2, INEXACT)
T(RN,    -0x1.9aa71de69aedp+8,  0x1.77a62cbc546a6p-593,   -0x1.80538p-2, INEXACT)
T(RN,   -0x1.99f19ce0760fep+8,  0x1.7da6d3e4fb6bcp-592,   0x1.fecc66p-2, INEXACT)
T(RN,   -0x1.993c1bda5132cp+8,  0x1.83c008fa870ebp-591,  -0x1.e926eep-2, INEXACT)
T(RN,   -0x1.98869ad42c55ap+8,  0x1.89f2306e8d43ap-590,   0x1.f52834p-3, INEXACT)
T(RN,   -0x1.97d119ce07788p+8,  0x1.903db04d85865p-589,   0x1.667164p-3, INEXACT)
T(RN,   -0x1.971b98c7e29b6p+8,  0x1.96a2f04559a4cp-588,   0x1.3f8c24p-2, INEXACT)
T(RN,   -0x1.966617c1bdbe4p+8,  0x1.9d2259ac1160bp-587,   0x1.eb7c18p-7, INEXACT)
T(RN,   -0x1.95b096bb98e12p+8,   0x1.a3bc5786995bp-586,   0x1.8b8528p-2, INEXACT)
T(RN,    -0x1.94fb15b57404p+8,  0x1.aa71568fa5b79p-585,   0x1.ffd8eep-3, INEXACT)
T(RN,   -0x1.944594af4f26ep+8,   0x1.b141c53eb0ecp-584,   0x1.167af4p-2, INEXACT)
T(RN,   -0x1.939013a92a49cp+8,  0x1.b82e13cf172b9p-583,  -0x1.ce157ap-3, INEXACT)
T(RN,   -0x1.92da92a3056cap+8,  0x1.bf36b4474ee61p-582,   0x1.5bd3e2p-2, INEXACT)
T(RN,   -0x1.9225119ce08f8p+8,  0x1.c65c1a803ecfdp-581,   0x1.7e9c78p-2, INEXACT)
T(RN,   -0x1.916f9096bbb26p+8,  0x1.cd9ebc2cb1ecap-580,   0x1.8ee1ccp-2, INEXACT)
T(RN,   -0x1.90ba0f9096d54p+8,  0x1.d4ff10e0ea177p-579,  -0x1.d7367ep-4, INEXACT)
T(RN,   -0x1.90048e8a71f82p+8,  0x1.dc7d921a51843p-578,   0x1.30e874p-2, INEXACT)
T(RN,    -0x1.8f4f0d844d1bp+8,  0x1.e41abb474bb9cp-577,  -0x1.7011eep-2, INEXACT)
T(RN,   -0x1.8e998c7e283dep+8,   0x1.ebd709cf2686p-576,   0x1.1e80ecp-6, INEXACT)
T(RN,   -0x1.8de40b780360cp+8,  0x1.f3b2fd1a2b6d1p-575,   0x1.4084c8p-2, INEXACT)
T(RN,   -0x1.8d2e8a71de83ap+8,  0x1.fbaf1699d21a4p-574,  -0x1.8e62b8p-4, INEXACT)
T(RN,   -0x1.8c79096bb9a68p+8,  0x1.01e5ece88a2c7p-572,    0x1.0cb9dp-3, INEXACT)
T(RN,   -0x1.8bc3886594c96p+8,  0x1.0604e62e720efp-571,   0x1.ab0e18p-2, INEXACT)
T(RN,   -0x1.8b0e075f6fec4p+8,  0x1.0a34bafe62172p-570,  -0x1.1ebd64p-2, INEXACT)
T(RN,   -0x1.8a5886594b0f2p+8,  0x1.0e75b04dc1f81p-569,    0x1.cfde4p-2, INEXACT)
T(RN,    -0x1.89a305532632p+8,  0x1.12c80c2c0f7a1p-568,  -0x1.486b96p-2, INEXACT)
T(RN,   -0x1.88ed844d0154ep+8,  0x1.172c15c76066bp-567,   0x1.c33c06p-2, INEXACT)
T(RN,   -0x1.88380346dc77cp+8,  0x1.1ba21570f6e3ap-566,   0x1.b5d554p-2, INEXACT)
T(RN,   -0x1.87828240b79aap+8,  0x1.202a54a1e88a8p-565,   0x1.5eb39cp-3, INEXACT)
T(RN,   -0x1.86cd013a92bd8p+8,  0x1.24c51dffd8885p-564,  -0x1.61522cp-2, INEXACT)
T(RN,   -0x1.861780346de06p+8,  0x1.2972bd61c5136p-563,  -0x1.673d52p-2, INEXACT)
T(RN,   -0x1.8561ff2e49034p+8,  0x1.2e337fd4e8866p-562,   0x1.5c33eep-3, INEXACT)
T(RN,   -0x1.84ac7e2824262p+8,  0x1.3307b3a1ae713p-561,   0x1.e69544p-3, INEXACT)
T(RN,    -0x1.83f6fd21ff49p+8,  0x1.37efa850bcf12p-560,  -0x1.be5072p-2, INEXACT)
T(RN,   -0x1.83417c1bda6bep+8,  0x1.3cebaeb012a37p-559,   -0x1.2909ep-4, INEXACT)
T(RN,   -0x1.828bfb15b58ecp+8,  0x1.41fc18d83985fp-558,  -0x1.c97714p-3, INEXACT)
T(RN,   -0x1.81d67a0f90b1ap+8,  0x1.47213a318f1c8p-557,   0x1.1e7be6p-4, INEXACT)
T(RN,   -0x1.8120f9096bd48p+8,  0x1.4c5b6779a2312p-556,   0x1.d10282p-2, INEXACT)
T(RN,   -0x1.806b780346f76p+8,  0x1.51aaf6c8a687dp-555,  -0x1.64e37cp-2, INEXACT)
T(RN,   -0x1.7fb5f6fd221a4p+8,  0x1.57103f96fee01p-554,    0x1.4e378p-2, INEXACT)
T(RN,   -0x1.7f0075f6fd3d2p+8,  0x1.5c8b9ac2dd9e1p-553,  -0x1.068cdcp-2, INEXACT)
T(RN,     -0x1.7e4af4f0d86p+8,  0x1.621d6295fc7a6p-552,    0x1.a889bp-3, INEXACT)
T(RN,   -0x1.7d9573eab382ep+8,  0x1.67c5f2cb6b93dp-551,   -0x1.b685ep-2, INEXACT)
T(RN,   -0x1.7cdff2e48ea5cp+8,  0x1.6d85a89578459p-550,   0x1.41ccc6p-5, INEXACT)
T(RN,   -0x1.7c2a71de69c8ap+8,  0x1.735ce2a3ac209p-549, -0x1.74d186p-13, INEXACT)
T(RN,   -0x1.7b74f0d844eb8p+8,  0x1.794c0128e46cdp-548,  -0x1.799482p-3, INEXACT)
T(RN,   -0x1.7abf6fd2200e6p+8,  0x1.7f5365e18295ap-547,   0x1.a507d6p-3, INEXACT)
T(RN,   -0x1.7a09eecbfb314p+8,  0x1.85737419b5e73p-546,   0x1.da59c2p-3, INEXACT)
T(RN,   -0x1.79546dc5d6542p+8,  0x1.8bac90b3df055p-545,  -0x1.60042ap-3, INEXACT)
T(RN,    -0x1.789eecbfb177p+8,  0x1.91ff222f0d843p-544,   0x1.585f32p-2, INEXACT)
T(RN,   -0x1.77e96bb98c99ep+8,  0x1.986b90ad980ddp-543,  -0x1.94ff9ep-2, INEXACT)
T(RN,   -0x1.7733eab367bccp+8,  0x1.9ef245fbcf81ep-542,  -0x1.dc892cp-4, INEXACT)
T(RN,   -0x1.767e69ad42dfap+8,  0x1.a593ad96cd7cap-541,   -0x1.4fcb7p-6, INEXACT)
T(RN,   -0x1.75c8e8a71e028p+8,  0x1.ac5034b35eb6ap-540,   -0x1.6dae5p-4, INEXACT)
T(RN,   -0x1.751367a0f9256p+8,  0x1.b3284a4509ae2p-539,   -0x1.5be27p-2, INEXACT)
T(RN,   -0x1.745de69ad4484p+8,  0x1.ba1c5f05320e5p-538,   0x1.f1b9ccp-2, INEXACT)
T(RN,   -0x1.73a86594af6b2p+8,  0x1.c12ce57a59497p-537,  -0x1.506654p-2, INEXACT)
T(RN,    -0x1.72f2e48e8a8ep+8,  0x1.c85a51ff7cde9p-536,  -0x1.d99cecp-2, INEXACT)
T(RN,   -0x1.723d638865b0ep+8,  0x1.cfa51acb92c26p-535, -0x1.0a6feap-10, INEXACT)
T(RN,   -0x1.7187e28240d3cp+8,  0x1.d70db7f92467fp-534,  -0x1.4204dcp-4, INEXACT)
T(RN,   -0x1.70d2617c1bf6ap+8,  0x1.de94a38e08e63p-533,   0x1.4f8c72p-7, INEXACT)
T(RN,   -0x1.701ce075f7198p+8,   0x1.e63a59833eb9p-532,  -0x1.e68b04p-5, INEXACT)
T(RN,   -0x1.6f675f6fd23c6p+8,  0x1.edff57cce59fcp-531,  -0x1.b0932ap-4, INEXACT)
T(RN,   -0x1.6eb1de69ad5f4p+8,  0x1.f5e41e62591c5p-530,  -0x1.894cf8p-2, INEXACT)
T(RN,   -0x1.6dfc5d6388822p+8,  0x1.fde92f466c184p-529,  -0x1.f64afcp-2, INEXACT)
T(RN,    -0x1.6d46dc5d63a5p+8,  0x1.03078747e31bcp-527,  -0x1.a40fc4p-2, INEXACT)
T(RN,   -0x1.6c915b573ec7ep+8,  0x1.072b2138b1b16p-526,     0x1.2b52p-4, INEXACT)
T(RN,   -0x1.6bdbda5119eacp+8,  0x1.0b5fa9a19b0a5p-525,  -0x1.8282d2p-2, INEXACT)
T(RN,   -0x1.6b26594af50dap+8,  0x1.0fa565c5767cdp-524,   0x1.c1216ep-3, INEXACT)
T(RN,   -0x1.6a70d844d0308p+8,  0x1.13fc9c026e384p-523,   0x1.9d6ddap-3, INEXACT)
T(RN,   -0x1.69bb573eab536p+8,  0x1.186593d686409p-522,   0x1.50f6fep-3, INEXACT)
T(RN,   -0x1.6905d63886764p+8,  0x1.1ce095e435ee2p-521,  -0x1.6dbd8cp-4, INEXACT)
T(RN,   -0x1.6850553261992p+8,  0x1.216debf7143ebp-520,   0x1.64d0f4p-2, INEXACT)
T(RN,    -0x1.679ad42c3cbcp+8,  0x1.260de1089743bp-519,  -0x1.39fc1ap-3, INEXACT)
T(RN,   -0x1.66e5532617deep+8,  0x1.2ac0c144e6fd1p-518,   -0x1.b7cb4p-4, INEXACT)
T(RN,   -0x1.662fd21ff301cp+8,  0x1.2f86da0fc3eecp-517,  -0x1.9f7984p-4, INEXACT)
T(RN,   -0x1.657a5119ce24ap+8,  0x1.34607a0981c2cp-516,  -0x1.3939aep-2, INEXACT)
T(RN,   -0x1.64c4d013a9478p+8,  0x1.394df11416492p-515,  -0x1.95da24p-2, INEXACT)
T(RN,   -0x1.640f4f0d846a6p+8,  0x1.3e4f90583d296p-514,   0x1.5b61dep-5, INEXACT)
T(RN,   -0x1.6359ce075f8d4p+8,  0x1.4365aa4ab099dp-513,   0x1.0d93b6p-2, INEXACT)
T(RN,   -0x1.62a44d013ab02p+8,  0x1.489092b177733p-512,   0x1.f5e84cp-3, INEXACT)
T(RN,    -0x1.61eecbfb15d3p+8,  0x1.4dd09ea948f79p-511,  -0x1.193deep-2, INEXACT)
T(RN,   -0x1.61394af4f0f5ep+8,  0x1.532624ab06a59p-510,   0x1.55f61ap-5, INEXACT)
T(RN,   -0x1.6083c9eecc18cp+8,  0x1.58917c914c71ap-509,  -0x1.fe2da8p-3, INEXACT)
T(RN,   -0x1.5fce48e8a73bap+8,  0x1.5e12ff9e17c1ep-508,  -0x1.0b3c16p-4, INEXACT)
T(RN,   -0x1.5f18c7e2825e8p+8,  0x1.63ab088085888p-507,  -0x1.49eceap-2, INEXACT)
T(RN,   -0x1.5e6346dc5d816p+8,  0x1.6959f35aa7dc6p-506,   0x1.969942p-2, INEXACT)
T(RN,   -0x1.5dadc5d638a44p+8,  0x1.6f201dc7736edp-505,   -0x1.e5aa2p-2, INEXACT)
T(RN,   -0x1.5cf844d013c72p+8,  0x1.74fde6e0c541cp-504,   0x1.ee678ap-2, INEXACT)
T(RN,    -0x1.5c42c3c9eeeap+8,  0x1.7af3af4580ff2p-503,  -0x1.93efc4p-4, INEXACT)
T(RN,   -0x1.5b8d42c3ca0cep+8,  0x1.8101d91fc8593p-502,  -0x1.16ed5ep-2, INEXACT)
T(RN,   -0x1.5ad7c1bda52fcp+8,  0x1.8728c82b4bd76p-501,   0x1.439b3cp-5, INEXACT)
T(RN,   -0x1.5a2240b78052ap+8,  0x1.8d68e1bbb5798p-500,     0x1.0715p-2, INEXACT)
T(RN,   -0x1.596cbfb15b758p+8,  0x1.93c28cc32d9a6p-499,  -0x1.6fa8e4p-3, INEXACT)
T(RN,   -0x1.58b73eab36986p+8,  0x1.9a3631d8fa7d6p-498,   0x1.96e704p-2, INEXACT)
T(RN,   -0x1.5801bda511bb4p+8,  0x1.a0c43b403af37p-497,    0x1.c3e98p-3, INEXACT)
T(RN,   -0x1.574c3c9eecde2p+8,  0x1.a76d14eebc879p-496,   0x1.1dda24p-2, INEXACT)
T(RN,    -0x1.5696bb98c801p+8,   0x1.ae312c93eda2p-495,  -0x1.0b62fap-2, INEXACT)
T(RN,   -0x1.55e13a92a323ep+8,  0x1.b510f19fec15cp-494,   0x1.83e284p-3, INEXACT)
T(RN,   -0x1.552bb98c7e46cp+8,  0x1.bc0cd54ab08b7p-493,   0x1.e6bcf6p-5, INEXACT)
T(RN,   -0x1.547638865969ap+8,  0x1.c3254a9b5740fp-492,  -0x1.5a8b44p-3, INEXACT)
T(RN,   -0x1.53c0b780348c8p+8,  0x1.ca5ac66f8694ap-491,   0x1.f4fa34p-2, INEXACT)
T(RN,   -0x1.530b367a0faf6p+8,  0x1.d1adbf82f3d67p-490,  -0x1.73adc2p-6, INEXACT)
T(RN,   -0x1.5255b573ead24p+8,  0x1.d91eae7706db6p-489,   0x1.0213f6p-2, INEXACT)
T(RN,   -0x1.51a0346dc5f52p+8,  0x1.e0ae0dda9ccfbp-488,  -0x1.c8ecb6p-4, INEXACT)
T(RN,    -0x1.50eab367a118p+8,  0x1.e85c5a31eac95p-487,   0x1.ea696ap-9, INEXACT)
T(RN,   -0x1.503532617c3aep+8,  0x1.f02a11fe809afp-486,  -0x1.9e90b2p-2, INEXACT)
T(RN,   -0x1.4f7fb15b575dcp+8,  0x1.f817b5c76c6cep-485,   0x1.74ff2cp-3, INEXACT)
T(RN,   -0x1.4eca30553280ap+8,  0x1.0012e410bfd05p-483,   0x1.d18e8cp-2, INEXACT)
T(RN,   -0x1.4e14af4f0da38p+8,  0x1.042a66dbdac43p-482,   0x1.fcee18p-2, INEXACT)
T(RN,   -0x1.4d5f2e48e8c66p+8,  0x1.0852a6a9de3e2p-481,   0x1.29fa88p-2, INEXACT)
T(RN,   -0x1.4ca9ad42c3e94p+8,  0x1.0c8be7f350ecfp-480,  -0x1.35a758p-3, INEXACT)
T(RN,   -0x1.4bf42c3c9f0c2p+8,  0x1.10d67048d0bebp-479,   0x1.10afdap-6, INEXACT)
T(RN,    -0x1.4b3eab367a2fp+8,  0x1.153286578ca23p-478,   0x1.9cd0b6p-2, INEXACT)
T(RN,   -0x1.4a892a305551ep+8,  0x1.19a071edd0979p-477,  -0x1.83856ap-4, INEXACT)
T(RN,   -0x1.49d3a92a3074cp+8,  0x1.1e207bffa45acp-476,  -0x1.cc4e4ep-2, INEXACT)
T(RN,   -0x1.491e28240b97ap+8,  0x1.22b2eeab7cf39p-475,   0x1.c7ee7ap-3, INEXACT)
T(RN,   -0x1.4868a71de6ba8p+8,  0x1.2758153f0178fp-474,   0x1.920372p-2, INEXACT)
T(RN,   -0x1.47b32617c1dd6p+8,  0x1.2c103c3be3565p-473,   0x1.9d7a0cp-3, INEXACT)
T(RN,   -0x1.46fda5119d004p+8,  0x1.30dbb15cca623p-472,   0x1.63fec6p-3, INEXACT)
T(RN,   -0x1.4648240b78232p+8,  0x1.35bac39a55175p-471,   0x1.b0d072p-2, INEXACT)
T(RN,    -0x1.4592a3055346p+8,  0x1.3aadc3302d42dp-470,  -0x1.faac96p-2, INEXACT)
T(RN,   -0x1.44dd21ff2e68ep+8,  0x1.3fb501a2317b6p-469,   0x1.0f8cep-11, INEXACT)
T(RN,   -0x1.4427a0f9098bcp+8,  0x1.44d0d1c1b3b53p-468,  -0x1.f647ecp-2, INEXACT)
T(RN,   -0x1.43721ff2e4aeap+8,  0x1.4a0187b2cd4b1p-467,   0x1.d3e0b2p-6, INEXACT)
T(RN,   -0x1.42bc9eecbfd18p+8,  0x1.4f4778f1c8d24p-466,  -0x1.b9a7fep-2, INEXACT)
T(RN,   -0x1.42071de69af46p+8,  0x1.54a2fc58a2144p-465,   0x1.d088dcp-2, INEXACT)
T(RN,   -0x1.41519ce076174p+8,  0x1.5a146a249c871p-464,  -0x1.059ec2p-4, INEXACT)
T(RN,   -0x1.409c1bda513a2p+8,  0x1.5f9c1bfbf0a23p-463,  -0x1.8e174cp-2, INEXACT)
T(RN,    -0x1.3fe69ad42c5dp+8,  0x1.653a6cf3906bcp-462,  -0x1.b17cf8p-2, INEXACT)
T(RN,   -0x1.3f3119ce077fep+8,  0x1.6aefb995039e3p-461,   0x1.88e3a4p-2, INEXACT)
T(RN,   -0x1.3e7b98c7e2a2cp+8,  0x1.70bc5fe45bc63p-460,  -0x1.dbec6ap-2, INEXACT)
T(RN,   -0x1.3dc617c1bdc5ap+8,   0x1.76a0bf6640bcp-459,   -0x1.8d4d6p-2, INEXACT)
T(RN,   -0x1.3d1096bb98e88p+8,   0x1.7c9d392615dap-458,   0x1.2f62dcp-5, INEXACT)
T(RN,   -0x1.3c5b15b5740b6p+8,  0x1.82b22fbc38577p-457,   0x1.372adap-6, INEXACT)
T(RN,   -0x1.3ba594af4f2e4p+8,  0x1.88e00754572d7p-456,   0x1.58f3c8p-2, INEXACT)
T(RN,   -0x1.3af013a92a512p+8,  0x1.8f2725b3e4ee8p-455,   0x1.5970d2p-2, INEXACT)
T(RN,    -0x1.3a3a92a30574p+8,  0x1.9587f240a3fb4p-454,  -0x1.8ecf62p-3, INEXACT)
T(RN,   -0x1.3985119ce096ep+8,  0x1.9c02d6074d7ffp-453,   0x1.d5e912p-3, INEXACT)
T(RN,   -0x1.38cf9096bbb9cp+8,  0x1.a2983bc253a7fp-452,   0x1.a85e8ap-2, INEXACT)
T(RN,   -0x1.381a0f9096dcap+8,  0x1.a9488fe0bf777p-451,   0x1.81a1acp-2, INEXACT)
T(RN,   -0x1.37648e8a71ff8p+8,  0x1.b014408d2abb9p-450,   0x1.ae3704p-9, INEXACT)
T(RN,   -0x1.36af0d844d226p+8,  0x1.b6fbbdb4d6845p-449,   0x1.3cf194p-5, INEXACT)
T(RN,   -0x1.35f98c7e28454p+8,  0x1.bdff790ede9cbp-448,  -0x1.a9e9b4p-2, INEXACT)
T(RN,   -0x1.35440b7803682p+8,  0x1.c51fe6238a784p-447,   0x1.d04f4cp-2, INEXACT)
T(RN,    -0x1.348e8a71de8bp+8,  0x1.cc5d7a53bc0d8p-446,   0x1.9cbc04p-2, INEXACT)
T(RN,   -0x1.33d9096bb9adep+8,  0x1.d3b8ace07d191p-445,   0x1.c87c5ep-2, INEXACT)
T(RN,   -0x1.3323886594d0cp+8,  0x1.db31f6f2ab447p-444,   0x1.499202p-3, INEXACT)
T(RN,   -0x1.326e075f6ff3ap+8,  0x1.e2c9d3a2c3afep-443,   0x1.c761a2p-4, INEXACT)
T(RN,   -0x1.31b886594b168p+8,  0x1.ea80c000ce5f1p-442,   0x1.5b3d54p-3, INEXACT)
T(RN,   -0x1.3103055326396p+8,  0x1.f2573b1c6a0b7p-441,   -0x1.0f4d1p-2, INEXACT)
T(RN,   -0x1.304d844d015c4p+8,  0x1.fa4dc60cf8e0bp-440,   0x1.de77bap-2, INEXACT)
T(RN,   -0x1.2f980346dc7f2p+8,  0x1.013271fcf754bp-438,   0x1.26c828p-3, INEXACT)
T(RN,    -0x1.2ee28240b7a2p+8,  0x1.054e8d11a07afp-437,    0x1.f316bp-2, INEXACT)
T(RN,   -0x1.2e2d013a92c4ep+8,  0x1.097b77f4fce36p-436,  -0x1.32e18ep-3, INEXACT)
T(RN,   -0x1.2d7780346de7cp+8,   0x1.0db9776c76a5p-435,   0x1.560c9ap-3, INEXACT)
T(RN,   -0x1.2cc1ff2e490aap+8,  0x1.1208d156c99bfp-434,   0x1.d7ad7ap-4, INEXACT)
T(RN,   -0x1.2c0c7e28242d8p+8,   0x1.1669ccb08232p-433,   0x1.16b43cp-2, INEXACT)
T(RN,   -0x1.2b56fd21ff506p+8,  0x1.1adcb1988e8a3p-432,  -0x1.235b94p-4, INEXACT)
T(RN,   -0x1.2aa17c1bda734p+8,  0x1.1f61c954e25b4p-431,   0x1.2bcd6ap-6, INEXACT)
T(RN,   -0x1.29ebfb15b5962p+8,   0x1.23f95e572dc5p-430,    0x1.906f5p-2, INEXACT)
T(RN,    -0x1.29367a0f90b9p+8,  0x1.28a3bc41a76e9p-429,   0x1.05f134p-3, INEXACT)
T(RN,   -0x1.2880f9096bdbep+8,  0x1.2d612febea3c6p-428,   -0x1.1478dp-2, INEXACT)
T(RN,   -0x1.27cb780346fecp+8,  0x1.32320767e6edcp-427,  -0x1.21d292p-3, INEXACT)
T(RN,   -0x1.2715f6fd2221ap+8,  0x1.37169206e9f3ap-426,  -0x1.8fc3acp-3, INEXACT)
T(RN,   -0x1.266075f6fd448p+8,  0x1.3c0f205eb5d38p-425,   0x1.c635b4p-5, INEXACT)
T(RN,   -0x1.25aaf4f0d8676p+8,  0x1.411c044eb26a1p-424,   0x1.4f57b8p-3, INEXACT)
T(RN,   -0x1.24f573eab38a4p+8,  0x1.463d910531636p-423,  -0x1.631f78p-2, INEXACT)
T(RN,   -0x1.243ff2e48ead2p+8,  0x1.4b741b04c83f4p-422,  -0x1.3dd83ep-3, INEXACT)
T(RN,     -0x1.238a71de69dp+8,  0x1.50bff829c0399p-421,    0x1.47956p-2, INEXACT)
T(RN,   -0x1.22d4f0d844f2ep+8,  0x1.56217faf9c70bp-420,   0x1.8fd9a4p-3, INEXACT)
T(RN,   -0x1.221f6fd22015cp+8,  0x1.5b990a36b6a4dp-419,   0x1.f6f3fep-2, INEXACT)
T(RN,   -0x1.2169eecbfb38ap+8,  0x1.6126f1c9f2ec1p-418,  -0x1.8c0826p-2, INEXACT)
T(RN,   -0x1.20b46dc5d65b8p+8,  0x1.66cb91e48aba8p-417,   0x1.56625ep-2, INEXACT)
T(RN,   -0x1.1ffeecbfb17e6p+8,  0x1.6c874777ef9bap-416,  -0x1.624898p-2, INEXACT)
T(RN,   -0x1.1f496bb98ca14p+8,  0x1.725a70f1c600bp-415,  -0x1.ede7f4p-2, INEXACT)
T(RN,   -0x1.1e93eab367c42p+8,  0x1.78456e41f883ep-414,  -0x1.9f3dcep-2, INEXACT)
T(RN,    -0x1.1dde69ad42e7p+8,  0x1.7e48a0e0e4063p-413,   0x1.0f7972p-3, INEXACT)
T(RN,   -0x1.1d28e8a71e09ep+8,  0x1.84646bd59d0ccp-412,   0x1.4f97f6p-2, INEXACT)
T(RN,   -0x1.1c7367a0f92ccp+8,  0x1.8a9933bc4ec55p-411,  -0x1.64b5dcp-2, INEXACT)
T(RN,   -0x1.1bbde69ad44fap+8,  0x1.90e75eccb41acp-410,   0x1.6c0d48p-3, INEXACT)
T(RN,   -0x1.1b086594af728p+8,  0x1.974f54e0ab439p-409,   0x1.dac6f8p-4, INEXACT)
T(RN,   -0x1.1a52e48e8a956p+8,   0x1.9dd17f7ae438p-408,   -0x1.f6a59p-2, INEXACT)
T(RN,   -0x1.199d638865b84p+8,  0x1.a46e49cdaa7ccp-407,   0x1.69ebc8p-2, INEXACT)
T(RN,   -0x1.18e7e28240db2p+8,  0x1.ab2620c1cab1fp-406,   0x1.10efd2p-2, INEXACT)
T(RN,    -0x1.1832617c1bfep+8,  0x1.b1f972fd94595p-405,   0x1.f91266p-3, INEXACT)
T(RN,   -0x1.177ce075f720ep+8,  0x1.b8e8b0ebf8456p-404,   0x1.55b3d6p-6, INEXACT)
T(RN,   -0x1.16c75f6fd243cp+8,  0x1.bff44cc3c427ep-403,  -0x1.6871d2p-6, INEXACT)
T(RN,   -0x1.1611de69ad66ap+8,  0x1.c71cba8efbb63p-402,  -0x1.30f5b6p-2, INEXACT)
T(RN,   -0x1.155c5d6388898p+8,   0x1.ce6270324fddp-401,  -0x1.5290ecp-2, INEXACT)
T(RN,   -0x1.14a6dc5d63ac6p+8,  0x1.d5c5e574b47dep-400,  -0x1.199ceap-2, INEXACT)
T(RN,   -0x1.13f15b573ecf4p+8,  0x1.dd4794071533fp-399,  -0x1.e6e308p-2, INEXACT)
T(RN,   -0x1.133bda5119f22p+8,  0x1.e4e7f78c299e9p-398,   0x1.6ed6bap-3, INEXACT)
T(RN,    -0x1.1286594af515p+8,  0x1.eca78da069b29p-397,   -0x1.9ee98p-4, INEXACT)
T(RN,   -0x1.11d0d844d037ep+8,  0x1.f486d5e22295fp-396,   0x1.d3be54p-2, INEXACT)
T(RN,   -0x1.111b573eab5acp+8,  0x1.fc8651f9ac89cp-395,   -0x1.8d66ap-3, INEXACT)
T(RN,   -0x1.1065d638867dap+8,  0x1.025342d0e1359p-393,   -0x1.b6d46p-2, INEXACT)
T(RN,   -0x1.0fb0553261a08p+8,  0x1.0673fb57fda9ap-392,   0x1.2e17d4p-4, INEXACT)
T(RN,   -0x1.0efad42c3cc36p+8,  0x1.0aa5968eb3714p-391,   0x1.fcfd24p-2, INEXACT)
T(RN,   -0x1.0e45532617e64p+8,  0x1.0ee85987a6628p-390,  -0x1.e8bae2p-2, INEXACT)
T(RN,   -0x1.0d8fd21ff3092p+8,  0x1.133c8a7008006p-389,    0x1.c30ddp-2, INEXACT)
T(RN,    -0x1.0cda5119ce2cp+8,  0x1.17a270941b4eap-388,   0x1.e6076cp-3, INEXACT)
T(RN,   -0x1.0c24d013a94eep+8,   0x1.1c1a5463cb1fp-387,  -0x1.6e714cp-5, INEXACT)
T(RN,   -0x1.0b6f4f0d8471cp+8,  0x1.20a47f7753213p-386,  -0x1.ffa746p-2, INEXACT)
T(RN,   -0x1.0ab9ce075f94ap+8,  0x1.25413c93fc03ap-385,  -0x1.d94bfap-3, INEXACT)
T(RN,   -0x1.0a044d013ab78p+8,  0x1.29f0d7b0eaf27p-384,   0x1.5555aap-2, INEXACT)
T(RN,   -0x1.094ecbfb15da6p+8,  0x1.2eb39dfc04c43p-383,  -0x1.311b92p-7, INEXACT)
T(RN,   -0x1.08994af4f0fd4p+8,  0x1.3389dddee524fp-382,   0x1.c528eap-3, INEXACT)
T(RN,   -0x1.07e3c9eecc202p+8,  0x1.3873e703ea10bp-381,   0x1.87166ap-6, INEXACT)
T(RN,    -0x1.072e48e8a743p+8,  0x1.3d720a5b53f16p-380,  -0x1.429762p-2, INEXACT)
T(RN,   -0x1.0678c7e28265ep+8,   0x1.42849a207ab4p-379,  -0x1.a1e932p-3, INEXACT)
T(RN,   -0x1.05c346dc5d88cp+8,  0x1.47abe9df182afp-378,   0x1.fefcc4p-3, INEXACT)
T(RN,   -0x1.050dc5d638abap+8,  0x1.4ce84e78a814ap-377,   0x1.36857cp-6, INEXACT)
T(RN,   -0x1.045844d013ce8p+8,  0x1.523a1e29de1f5p-376,   0x1.f7178cp-3, INEXACT)
T(RN,   -0x1.03a2c3c9eef16p+8,  0x1.57a1b09032432p-375,  -0x1.e51ff8p-2, INEXACT)
T(RN,   -0x1.02ed42c3ca144p+8,   0x1.5d1f5eaf83cfp-374,    0x1.2e60fp-2, INEXACT)
T(RN,   -0x1.0237c1bda5372p+8,  0x1.62b382f7d383bp-373,  -0x1.502f8ep-3, INEXACT)
T(RN,    -0x1.018240b7805ap+8,  0x1.685e794b151d4p-372,  -0x1.24c778p-2, INEXACT)
T(RN,   -0x1.00ccbfb15b7cep+8,  0x1.6e209f0318a8dp-371,    0x1.45d15p-2, INEXACT)
T(RN,   -0x1.00173eab369fcp+8,  0x1.73fa52f78c092p-370,  -0x1.47061ap-2, INEXACT)
T(RN,   -0x1.ffe5e353f81a4p+7,  0x1.aca5b0441d774p-370,   0x1.d93826p-4, INEXACT)
T(RN,     -0x1.fe7ae147ae6p+7,  0x1.b37f238404362p-369,  -0x1.31566ep-3, INEXACT)
T(RN,   -0x1.fd0fdf3b64a5cp+7,  0x1.ba749b88d50e1p-368,   0x1.49b676p-5, INEXACT)
T(RN,   -0x1.fba4dd2f1aeb8p+7,   0x1.c1868aefecd3p-367,    0x1.a48c4p-4, INEXACT)
T(RN,   -0x1.fa39db22d1314p+7,  0x1.c8b5662b81e57p-366,   0x1.2c96f4p-2, INEXACT)
T(RN,    -0x1.f8ced9168777p+7,  0x1.d001a38a221a1p-365,   -0x1.7b1fap-2, INEXACT)
T(RN,   -0x1.f763d70a3dbccp+7,  0x1.d76bbb3e4f474p-364,  -0x1.5ec8e6p-3, INEXACT)
T(RN,   -0x1.f5f8d4fdf4028p+7,  0x1.def427663af4ep-363,   0x1.b9be7cp-2, INEXACT)
T(RN,   -0x1.f48dd2f1aa484p+7,  0x1.e69b6413a1aecp-362,   0x1.d43144p-3, INEXACT)
T(RN,    -0x1.f322d0e5608ep+7,  0x1.ee61ef53c67acp-361,  -0x1.d0f01cp-2, INEXACT)
T(RN,   -0x1.f1b7ced916d3cp+7,  0x1.f64849378ef5ep-360,  -0x1.211a96p-3, INEXACT)
T(RN,   -0x1.f04ccccccd198p+7,  0x1.fe4ef3dbc09dcp-359,   -0x1.9d10cp-2, INEXACT)
T(RN,   -0x1.eee1cac0835f4p+7,  0x1.033b39b8afe79p-357,  -0x1.3d0d3ep-4, INEXACT)
T(RN,    -0x1.ed76c8b439a5p+7,   0x1.075fa7231881p-356,  -0x1.391eaep-6, INEXACT)
T(RN,   -0x1.ec0bc6a7efeacp+7,  0x1.0b950666ae684p-355,  -0x1.121d94p-4, INEXACT)
T(RN,   -0x1.eaa0c49ba6308p+7,  0x1.0fdb9cd41bab2p-354,   -0x1.4c8fbp-6, INEXACT)
T(RN,   -0x1.e935c28f5c764p+7,  0x1.1433b0d795bc7p-353,  -0x1.872876p-2, INEXACT)
T(RN,    -0x1.e7cac08312bcp+7,  0x1.189d89fd65568p-352,  -0x1.9f7e8ep-2, INEXACT)
T(RN,   -0x1.e65fbe76c901cp+7,  0x1.1d1970f680e61p-351,  -0x1.d0cc02p-3, INEXACT)
T(RN,   -0x1.e4f4bc6a7f478p+7,  0x1.21a7af9d39c9fp-350,  -0x1.123e46p-3, INEXACT)
T(RN,   -0x1.e389ba5e358d4p+7,  0x1.264890f9fcb42p-349,  -0x1.afb88cp-2, INEXACT)
T(RN,    -0x1.e21eb851ebd3p+7,  0x1.2afc6148257adp-348,   0x1.3336bcp-5, INEXACT)
T(RN,   -0x1.e0b3b645a218cp+7,  0x1.2fc36dfae6a86p-347,    0x1.733c3p-2, INEXACT)
T(RN,   -0x1.df48b439585e8p+7,  0x1.349e05c2451bdp-346,  -0x1.8f2b8cp-4, INEXACT)
T(RN,   -0x1.ddddb22d0ea44p+7,  0x1.398c7890280b5p-345,   0x1.559c74p-6, INEXACT)
T(RN,    -0x1.dc72b020c4eap+7,   0x1.3e8f179d7dbcp-344,   0x1.4737f6p-2, INEXACT)
T(RN,   -0x1.db07ae147b2fcp+7,  0x1.43a6356f75444p-343,  -0x1.e9303cp-4, INEXACT)
T(RN,   -0x1.d99cac0831758p+7,  0x1.48d225dccdae7p-342,   0x1.c39402p-2, INEXACT)
T(RN,   -0x1.d831a9fbe7bb4p+7,  0x1.4e133e133ad2ep-341,   0x1.a9e7a8p-2, INEXACT)
T(RN,    -0x1.d6c6a7ef9e01p+7,  0x1.5369d49ce0431p-340,   0x1.4daa42p-2, INEXACT)
T(RN,   -0x1.d55ba5e35446cp+7,  0x1.58d64165e29f5p-339,   0x1.e370f4p-2, INEXACT)
T(RN,   -0x1.d3f0a3d70a8c8p+7,   0x1.5e58ddc20fb3p-338,  -0x1.7d4312p-2, INEXACT)
T(RN,   -0x1.d285a1cac0d24p+7,  0x1.63f204729db4fp-337,   0x1.0af456p-4, INEXACT)
T(RN,    -0x1.d11a9fbe7718p+7,  0x1.69a211ac02096p-336,   0x1.b2dcb4p-2, INEXACT)
T(RN,   -0x1.cfaf9db22d5dcp+7,  0x1.6f69631bdfe74p-335,  -0x1.1bb26cp-2, INEXACT)
T(RN,   -0x1.ce449ba5e3a38p+7,  0x1.754857ef0f41ap-334,   0x1.c12484p-3, INEXACT)
T(RN,   -0x1.ccd9999999e94p+7,   0x1.7b3f50d7bc58p-333,  -0x1.04d918p-3, INEXACT)
T(RN,    -0x1.cb6e978d502fp+7,  0x1.814eb013a053fp-332,  -0x1.046a98p-2, INEXACT)
T(RN,   -0x1.ca0395810674cp+7,  0x1.8776d9725358dp-331,  -0x1.286548p-4, INEXACT)
T(RN,   -0x1.c8989374bcba8p+7,  0x1.8db8325bb86edp-330,   0x1.65befap-2, INEXACT)
T(RN,   -0x1.c72d916873004p+7,  0x1.941321d683b29p-329,   0x1.00bbfap-2, INEXACT)
T(RN,    -0x1.c5c28f5c2946p+7,  0x1.9a88108edb351p-328,   0x1.2e2b38p-6, INEXACT)
T(RN,   -0x1.c4578d4fdf8bcp+7,  0x1.a11768dd12f8cp-327,  -0x1.6fefe2p-2, INEXACT)
T(RN,   -0x1.c2ec8b4395d18p+7,   0x1.a7c196cc847bp-326,   0x1.cd0442p-4, INEXACT)
T(RN,   -0x1.c18189374c174p+7,  0x1.ae870822823a4p-325,  -0x1.d83b88p-3, INEXACT)
T(RN,    -0x1.c016872b025dp+7,  0x1.b5682c6567ac2p-324,  -0x1.24e036p-2, INEXACT)
T(RN,   -0x1.beab851eb8a2cp+7,  0x1.bc6574e3c616cp-323,   0x1.db0edep-3, INEXACT)
T(RN,   -0x1.bd4083126ee88p+7,  0x1.c37f54bbaec43p-322,   0x1.68b754p-2, INEXACT)
T(RN,   -0x1.bbd58106252e4p+7,  0x1.cab640e21b081p-321,   0x1.f9a024p-2, INEXACT)
T(RN,    -0x1.ba6a7ef9db74p+7,  0x1.d20ab02a7290ep-320,   0x1.c64afcp-2, INEXACT)
T(RN,   -0x1.b8ff7ced91b9cp+7,  0x1.d97d1b4e30816p-319,  -0x1.19c9a8p-2, INEXACT)
T(RN,   -0x1.b7947ae147ff8p+7,  0x1.e10dfcf4a7cfep-318,  -0x1.19cfbep-2, INEXACT)
T(RN,   -0x1.b62978d4fe454p+7,  0x1.e8bdd1bae76afp-317,   -0x1.e01d1p-3, INEXACT)
T(RN,    -0x1.b4be76c8b48bp+7,  0x1.f08d183bbea63p-316,  -0x1.a5a4bap-2, INEXACT)
T(RN,   -0x1.b35374bc6ad0cp+7,  0x1.f87c5117e272dp-315,   0x1.fcadb6p-2, INEXACT)
T(RN,   -0x1.b1e872b021168p+7,  0x1.0045ff7f19f4dp-313,   0x1.4a64a4p-2, INEXACT)
T(RN,   -0x1.b07d70a3d75c4p+7,   0x1.045e535a1458p-312,   0x1.4ef27ap-2, INEXACT)
T(RN,    -0x1.af126e978da2p+7,  0x1.0887678f2ae08p-311,   0x1.c89e44p-2, INEXACT)
T(RN,   -0x1.ada76c8b43e7cp+7,   0x1.0cc180a48e94p-310,   0x1.6c2384p-3, INEXACT)
T(RN,   -0x1.ac3c6a7efa2d8p+7,  0x1.110ce438bf9dfp-309,  -0x1.c53ee8p-2, INEXACT)
T(RN,   -0x1.aad16872b0734p+7,  0x1.1569d90707f5ep-308,    0x1.77653p-2, INEXACT)
T(RN,    -0x1.a966666666b9p+7,   0x1.19d8a6ec0858p-307,   0x1.ec40c2p-2, INEXACT)
T(RN,   -0x1.a7fb645a1cfecp+7,  0x1.1e5996ea57dbep-306,   0x1.0f0656p-3, INEXACT)
T(RN,   -0x1.a690624dd3448p+7,  0x1.22ecf32f36745p-305,  -0x1.243d28p-2, INEXACT)
T(RN,   -0x1.a5256041898a4p+7,  0x1.2793071752a67p-304,    0x1.1aa36p-2, INEXACT)
T(RN,     -0x1.a3ba5e353fdp+7,  0x1.2c4c1f33a2c62p-303,   0x1.451a28p-4, INEXACT)
T(RN,   -0x1.a24f5c28f615cp+7,  0x1.3118894e52087p-302,  -0x1.fdf36cp-2, INEXACT)
T(RN,   -0x1.a0e45a1cac5b8p+7,  0x1.35f8946fc1bc5p-301,   0x1.1876bep-3, INEXACT)
T(RN,   -0x1.9f79581062a14p+7,  0x1.3aec90e39efc1p-300,   0x1.b247c4p-3, INEXACT)
T(RN,    -0x1.9e0e560418e7p+7,  0x1.3ff4d03e0d2c5p-299,   0x1.79f3a4p-2, INEXACT)
T(RN,   -0x1.9ca353f7cf2ccp+7,  0x1.4511a560e59c4p-298,   0x1.bc2014p-2, INEXACT)
T(RN,   -0x1.9b3851eb85728p+7,  0x1.4a4364810c9e7p-297,   0x1.b607fcp-5, INEXACT)
T(RN,   -0x1.99cd4fdf3bb84p+7,  0x1.4f8a632bdc71dp-296,  -0x1.45b3fap-6, INEXACT)
T(RN,    -0x1.98624dd2f1fep+7,  0x1.54e6f84ca653ep-295,   0x1.45bc64p-2, INEXACT)
T(RN,   -0x1.96f74bc6a843cp+7,   0x1.5a597c324a17p-294,   0x1.fbd054p-3, INEXACT)
T(RN,   -0x1.958c49ba5e898p+7,   0x1.5fe24894e499p-293,   -0x1.c6b11p-2, INEXACT)
T(RN,   -0x1.942147ae14cf4p+7,  0x1.6581b89b95776p-292,  -0x1.f9648ep-3, INEXACT)
T(RN,    -0x1.92b645a1cb15p+7,    0x1.6b3828e25c6p-291,  -0x1.6d5efep-2, INEXACT)
T(RN,   -0x1.914b4395815acp+7,  0x1.7105f7800e5fcp-290,  -0x1.c1e3aep-4, INEXACT)
T(RN,   -0x1.8fe0418937a08p+7,  0x1.76eb840c63903p-289,   0x1.c8ffe8p-2, INEXACT)
T(RN,   -0x1.8e753f7cede64p+7,  0x1.7ce92fa61d889p-288,  -0x1.945e22p-2, INEXACT)
T(RN,    -0x1.8d0a3d70a42cp+7,  0x1.82ff5cf946f7cp-287,  -0x1.4dd794p-5, INEXACT)
T(RN,   -0x1.8b9f3b645a71cp+7,  0x1.892e70458cccbp-286,  -0x1.6e85d8p-2, INEXACT)
T(RN,   -0x1.8a34395810b78p+7,  0x1.8f76cf64b157dp-285,  -0x1.413042p-4, INEXACT)
T(RN,   -0x1.88c9374bc6fd4p+7,  0x1.95d8e1d119cdfp-284,   0x1.ee7526p-2, INEXACT)
T(RN,    -0x1.875e353f7d43p+7,  0x1.9c5510ac76999p-283,  -0x1.b2283ep-2, INEXACT)
T(RN,   -0x1.85f333333388cp+7,  0x1.a2ebc6c686e85p-282,  -0x1.8ba016p-2, INEXACT)
T(RN,   -0x1.84883126e9ce8p+7,  0x1.a99d70a3f7e2cp-281,  -0x1.dba8b4p-3, INEXACT)
T(RN,   -0x1.831d2f1aa0144p+7,  0x1.b06a7c8560014p-280,  -0x1.770762p-2, INEXACT)
T(RN,    -0x1.81b22d0e565ap+7,  0x1.b7535a6e56f01p-279,   0x1.7b5b96p-4, INEXACT)
T(RN,   -0x1.80472b020c9fcp+7,  0x1.be587c2caa775p-278,   0x1.a103d2p-4, INEXACT)
T(RN,   -0x1.7edc28f5c2e58p+7,  0x1.c57a555fb0de5p-277,   0x1.1c23c2p-2, INEXACT)
T(RN,   -0x1.7d7126e9792b4p+7,  0x1.ccb95b7fb941fp-276,  -0x1.bd1112p-3, INEXACT)
T(RN,    -0x1.7c0624dd2f71p+7,  0x1.d41605e59a597p-275,   0x1.a5234cp-3, INEXACT)
T(RN,   -0x1.7a9b22d0e5b6cp+7,  0x1.db90cdd260252p-274,  -0x1.b333aep-3, INEXACT)
T(RN,   -0x1.793020c49bfc8p+7,  0x1.e32a2e771906cp-273,  -0x1.dc938ap-2, INEXACT)
T(RN,   -0x1.77c51eb852424p+7,  0x1.eae2a4fcc2c2cp-272,   0x1.aaa306p-2, INEXACT)
T(RN,    -0x1.765a1cac0888p+7,  0x1.f2bab08c57ed7p-271,   0x1.70015ap-9, INEXACT)
T(RN,   -0x1.74ef1a9fbecdcp+7,  0x1.fab2d256fe497p-270,   -0x1.f32f4p-2, INEXACT)
T(RN,   -0x1.7384189375138p+7,  0x1.0165c6cf2b4e6p-268,  -0x1.4cee9ep-2, INEXACT)
T(RN,   -0x1.721916872b594p+7,  0x1.0582b3de77433p-267,  -0x1.0a69bep-3, INEXACT)
T(RN,    -0x1.70ae147ae19fp+7,  0x1.09b074176a6f9p-266,  -0x1.d358b6p-2, INEXACT)
T(RN,   -0x1.6f43126e97e4cp+7,  0x1.0def4c4d2899cp-265,  -0x1.c634e2p-2, INEXACT)
T(RN,   -0x1.6dd810624e2a8p+7,  0x1.123f826c5f729p-264,  -0x1.30abfcp-3, INEXACT)
T(RN,   -0x1.6c6d0e5604704p+7,  0x1.16a15d7fc6435p-263,  -0x1.3cafecp-3, INEXACT)
T(RN,    -0x1.6b020c49bab6p+7,  0x1.1b1525b4b002fp-262,  -0x1.ef4ddap-3, INEXACT)
T(RN,   -0x1.69970a3d70fbcp+7,  0x1.1f9b245fb01d7p-261,   0x1.961d32p-2, INEXACT)
T(RN,   -0x1.682c083127418p+7,   0x1.2433a401523ap-260,  -0x1.4b90aap-2, INEXACT)
T(RN,   -0x1.66c10624dd874p+7,  0x1.28def04ae54e6p-259,  -0x1.9a1d96p-2, INEXACT)
T(RN,    -0x1.6556041893cdp+7,  0x1.2d9d56235a4cfp-258,  -0x1.ce83ecp-2, INEXACT)
T(RN,   -0x1.63eb020c4a12cp+7,  0x1.326f23ac36bf2p-257,  -0x1.c04296p-2, INEXACT)
T(RN,   -0x1.6280000000588p+7,  0x1.3754a8469b9cep-256,  -0x1.d9eff6p-3, INEXACT)
T(RN,   -0x1.6114fdf3b69e4p+7,  0x1.3c4e349860b42p-255,   0x1.2ee14ep-2, INEXACT)
T(RN,    -0x1.5fa9fbe76ce4p+7,  0x1.415c1a9144f46p-254,  -0x1.52f9d2p-3, INEXACT)
T(RN,   -0x1.5e3ef9db2329cp+7,  0x1.467ead7033f43p-253,  -0x1.fa4458p-2, INEXACT)
T(RN,   -0x1.5cd3f7ced96f8p+7,  0x1.4bb641c8a106bp-252,  -0x1.3c5e0ap-3, INEXACT)
T(RN,   -0x1.5b68f5c28fb54p+7,  0x1.51032d87f839dp-251,  -0x1.eab588p-2, INEXACT)
T(RN,    -0x1.59fdf3b645fbp+7,  0x1.5665c7fb25973p-250,  -0x1.5907aep-3, INEXACT)
T(RN,   -0x1.5892f1a9fc40cp+7,  0x1.5bde69d43301cp-249,   0x1.334088p-3, INEXACT)
T(RN,   -0x1.5727ef9db2868p+7,  0x1.616d6d2ffd0dap-248,   0x1.4aa474p-3, INEXACT)
T(RN,   -0x1.55bced9168cc4p+7,  0x1.67132d9bff2fbp-247,    0x1.f56fep-4, INEXACT)
T(RN,    -0x1.5451eb851f12p+7,  0x1.6cd0081c37a46p-246,   0x1.4be412p-2, INEXACT)
T(RN,   -0x1.52e6e978d557cp+7,  0x1.72a45b31236ecp-245,  -0x1.de0494p-2, INEXACT)
T(RN,   -0x1.517be76c8b9d8p+7,  0x1.789086ddd2d2ep-244,   0x1.86021cp-2, INEXACT)
T(RN,   -0x1.5010e56041e34p+7,  0x1.7e94ecae16ae5p-243,   0x1.e1fbb4p-2, INEXACT)
T(RN,    -0x1.4ea5e353f829p+7,  0x1.84b1efbcc7167p-242,   0x1.7e3678p-2, INEXACT)
T(RN,   -0x1.4d3ae147ae6ecp+7,  0x1.8ae7f4ba23a22p-241,  -0x1.56f6e8p-2, INEXACT)
T(RN,   -0x1.4bcfdf3b64b48p+7,   0x1.913761f24dc9p-240,  -0x1.08d33cp-2, INEXACT)
T(RN,   -0x1.4a64dd2f1afa4p+7,  0x1.97a09f53ddc22p-239,   0x1.2291f8p-2, INEXACT)
T(RN,     -0x1.48f9db22d14p+7,  0x1.9e241676924f3p-238,  -0x1.ed9d7ep-7, INEXACT)
T(RN,   -0x1.478ed9168785cp+7,  0x1.a4c232a21be24p-237,   0x1.ad14acp-2, INEXACT)
T(RN,   -0x1.4623d70a3dcb8p+7,  0x1.ab7b60d5038d2p-236,  -0x1.b15458p-3, INEXACT)
T(RN,   -0x1.44b8d4fdf4114p+7,  0x1.b2500fcbae2d8p-235,   -0x1.5053ep-2, INEXACT)
T(RN,    -0x1.434dd2f1aa57p+7,  0x1.b940b0077c47cp-234,  -0x1.586b96p-3, INEXACT)
T(RN,   -0x1.41e2d0e5609ccp+7,  0x1.c04db3d60706fp-233,  -0x1.85fd1ep-2, INEXACT)
T(RN,   -0x1.4077ced916e28p+7,  0x1.c7778f587ad8ep-232,   0x1.fba30ap-2, INEXACT)
T(RN,   -0x1.3f0ccccccd284p+7,  0x1.cebeb88b101ecp-231,  -0x1.0cbc96p-2, INEXACT)
T(RN,    -0x1.3da1cac0836ep+7,  0x1.d623a74ca26efp-230,    0x1.95fe8p-2, INEXACT)
T(RN,   -0x1.3c36c8b439b3cp+7,  0x1.dda6d56666e2bp-229,   0x1.2ba0aap-3, INEXACT)
T(RN,   -0x1.3acbc6a7eff98p+7,  0x1.e548be93c1f14p-228,  -0x1.500c86p-2, INEXACT)
T(RN,   -0x1.3960c49ba63f4p+7,  0x1.ed09e08a3d579p-227,   -0x1.b8d24p-3, INEXACT)
T(RN,    -0x1.37f5c28f5c85p+7,  0x1.f4eabb019e907p-226,    0x1.d3703p-2, INEXACT)
T(RN,   -0x1.368ac08312cacp+7,  0x1.fcebcfbc1e626p-225,   0x1.bef77ep-2, INEXACT)
T(RN,   -0x1.351fbe76c9108p+7,  0x1.0286d14761054p-223,   0x1.178e3ep-5, INEXACT)
T(RN,   -0x1.33b4bc6a7f564p+7,  0x1.06a85cb4eb46dp-222,  -0x1.5f7ce4p-2, INEXACT)
T(RN,    -0x1.3249ba5e359cp+7,  0x1.0adace30c75dep-221,   0x1.af02dap-2, INEXACT)
T(RN,   -0x1.30deb851ebe1cp+7,  0x1.0f1e6adb62396p-220,  -0x1.58b3f2p-2, INEXACT)
T(RN,   -0x1.2f73b645a2278p+7,  0x1.137378efeed99p-219,  -0x1.92b34cp-4, INEXACT)
T(RN,   -0x1.2e08b439586d4p+7,  0x1.17da3fc8eb0aap-218,   0x1.36fce4p-5, INEXACT)
T(RN,    -0x1.2c9db22d0eb3p+7,  0x1.1c5307e4b69bfp-217,  -0x1.29f456p-3, INEXACT)
T(RN,   -0x1.2b32b020c4f8cp+7,  0x1.20de1aea3d5e7p-216,    0x1.4f7ebp-5, INEXACT)
T(RN,   -0x1.29c7ae147b3e8p+7,  0x1.257bc3adb4371p-215,  -0x1.5a5da4p-2, INEXACT)
T(RN,   -0x1.285cac0831844p+7,  0x1.2a2c4e356993ep-214,   0x1.553fd2p-2, INEXACT)
T(RN,    -0x1.26f1a9fbe7cap+7,  0x1.2ef007bea9922p-213,    0x1.b3c09p-2, INEXACT)
T(RN,   -0x1.2586a7ef9e0fcp+7,  0x1.33c73ec2b6272p-212,   0x1.540ff2p-2, INEXACT)
T(RN,   -0x1.241ba5e354558p+7,  0x1.38b242fbd39cap-211,   0x1.03bfb2p-2, INEXACT)
T(RN,   -0x1.22b0a3d70a9b4p+7,  0x1.3db1656a69b47p-210,   0x1.1c1c84p-6, INEXACT)
T(RN,    -0x1.2145a1cac0e1p+7,  0x1.42c4f85a39c7cp-209,     0x1.88e4p-3, INEXACT)
T(RN,   -0x1.1fda9fbe7726cp+7,  0x1.47ed4f67aa37bp-208,   0x1.48673ep-3, INEXACT)
T(RN,   -0x1.1e6f9db22d6c8p+7,  0x1.4d2abf852786cp-207,  -0x1.0f16c8p-3, INEXACT)
T(RN,   -0x1.1d049ba5e3b24p+7,  0x1.527d9f009b736p-206,  -0x1.599d56p-2, INEXACT)
T(RN,    -0x1.1b99999999f8p+7,  0x1.57e64588fa6dcp-205,   0x1.522c0ep-8, INEXACT)
T(RN,   -0x1.1a2e978d503dcp+7,  0x1.5d650c33e7c44p-204,  -0x1.a2dc7ep-3, INEXACT)
T(RN,   -0x1.18c3958106838p+7,  0x1.62fa4d8370e3dp-203,  -0x1.371b8cp-2, INEXACT)
T(RN,   -0x1.17589374bcc94p+7,   0x1.68a6656be00ap-202,   0x1.22aab4p-4, INEXACT)
T(RN,    -0x1.15ed9168730fp+7,  0x1.6e69b159a6c91p-201,   0x1.689376p-6, INEXACT)
T(RN,   -0x1.14828f5c2954cp+7,  0x1.7444903760bfap-200,   0x1.f791fcp-2, INEXACT)
T(RN,   -0x1.13178d4fdf9a8p+7,  0x1.7a376273eee65p-199,   0x1.ed0bf4p-2, INEXACT)
T(RN,   -0x1.11ac8b4395e04p+7,  0x1.80428a08abd8cp-198,   0x1.08377cp-3, INEXACT)
T(RN,    -0x1.104189374c26p+7,  0x1.86666a7fb97f7p-197,  -0x1.4e1caep-2, INEXACT)
T(RN,   -0x1.0ed6872b026bcp+7,  0x1.8ca368fa6882bp-196,   0x1.b072d8p-3, INEXACT)
T(RN,   -0x1.0d6b851eb8b18p+7,  0x1.92f9ec37b9efbp-195,  -0x1.9cd888p-2, INEXACT)
T(RN,   -0x1.0c0083126ef74p+7,  0x1.996a5c9afb7bep-194,  -0x1.bb91eep-4, INEXACT)
T(RN,    -0x1.0a958106253dp+7,  0x1.9ff524327ed1ep-193,   0x1.6039d6p-2, INEXACT)
T(RN,   -0x1.092a7ef9db82cp+7,  0x1.a69aaebe6c582p-192,   0x1.0da87ap-4, INEXACT)
T(RN,   -0x1.07bf7ced91c88p+7,  0x1.ad5b69b7b1e0fp-191,   0x1.22759ap-2, INEXACT)
T(RN,   -0x1.06547ae1480e4p+7,  0x1.b437c4570db5dp-190,   0x1.3a859ap-2, INEXACT)
T(RN,    -0x1.04e978d4fe54p+7,  0x1.bb302f9c3672dp-189,   0x1.6052dap-3, INEXACT)
T(RN,   -0x1.037e76c8b499cp+7,  0x1.c2451e5520274p-188,   0x1.023a82p-2, INEXACT)
T(RN,   -0x1.021374bc6adf8p+7,  0x1.c97705255f339p-187,   0x1.77746cp-8, INEXACT)
T(RN,   -0x1.00a872b021254p+7,  0x1.d0c65a8da95e5p-186,   0x1.9fbf54p-2, INEXACT)
T(RN,   -0x1.ff9d4951836afp+6,  0x1.63998a523890fp-185,  -0x1.7f2778p-3, INEXACT)
T(RN,   -0x1.fcc74538eff62p+6,  0x1.69482d9da3788p-184,   -0x1.d2886p-5, INEXACT)
T(RN,   -0x1.f9f141205c815p+6,  0x1.6f0e0f56fff97p-183,  -0x1.6cc80cp-4, INEXACT)
T(RN,   -0x1.f71b3d07c90c8p+6,  0x1.74eb8e937dad4p-182,   0x1.ac940ap-2, INEXACT)
T(RN,   -0x1.f44538ef3597bp+6,  0x1.7ae10bed3fb39p-181,   0x1.7589a4p-2, INEXACT)
T(RN,   -0x1.f16f34d6a222ep+6,  0x1.80eee98993c3ap-180,    0x1.f7a62p-3, INEXACT)
T(RN,   -0x1.ee9930be0eae1p+6,   0x1.87158b1f42aap-179,   0x1.24af3ep-2, INEXACT)
T(RN,   -0x1.ebc32ca57b394p+6,  0x1.8d5555fcfa9aep-178,   0x1.27262cp-2, INEXACT)
T(RN,   -0x1.e8ed288ce7c47p+6,  0x1.93aeb10fd3c29p-177,  -0x1.8c1d0ep-2, INEXACT)
T(RN,   -0x1.e6172474544fap+6,  0x1.9a2204e9ef7fbp-176,  -0x1.566ef2p-2, INEXACT)
T(RN,   -0x1.e341205bc0dadp+6,  0x1.a0afbbc932b39p-175,   -0x1.4b2d7p-3, INEXACT)
T(RN,    -0x1.e06b1c432d66p+6,  0x1.a758419e1b986p-174,   -0x1.113aap-5, INEXACT)
T(RN,   -0x1.dd95182a99f13p+6,  0x1.ae1c0412b38d3p-173,    0x1.72678p-6, INEXACT)
T(RN,   -0x1.dabf1412067c6p+6,  0x1.b4fb72919d4a5p-172,  -0x1.e575b6p-8, INEXACT)
T(RN,   -0x1.d7e90ff973079p+6,  0x1.bbf6fe4d3ff24p-171,  -0x1.6f674cp-2, INEXACT)
T(RN,   -0x1.d5130be0df92cp+6,  0x1.c30f1a470f756p-170,   0x1.38d1a2p-3, INEXACT)
T(RN,   -0x1.d23d07c84c1dfp+6,  0x1.ca443b56f2bfep-169,    0x1.d4a51p-2, INEXACT)
T(RN,   -0x1.cf6703afb8a92p+6,  0x1.d196d832c82c9p-168,     0x1.8972p-2, INEXACT)
T(RN,   -0x1.cc90ff9725345p+6,  0x1.d907697608b7bp-167,   -0x1.86ccap-2, INEXACT)
T(RN,   -0x1.c9bafb7e91bf8p+6,    0x1.e09669a98a7p-166,  -0x1.99e06ap-3, INEXACT)
T(RN,   -0x1.c6e4f765fe4abp+6,  0x1.e844554b62a54p-165,   -0x1.3e399p-4, INEXACT)
T(RN,   -0x1.c40ef34d6ad5ep+6,  0x1.f011aad6e856ep-164,   -0x1.e1f98p-2, INEXACT)
T(RN,   -0x1.c138ef34d7611p+6,  0x1.f7feeaccd7663p-163,   0x1.9ecae8p-9, INEXACT)
T(RN,   -0x1.be62eb1c43ec4p+6,  0x1.00064bddca88fp-161,   0x1.07490ap-2, INEXACT)
T(RN,   -0x1.bb8ce703b0777p+6,  0x1.041d9b23cb21ep-160,   0x1.de3058p-2, INEXACT)
T(RN,   -0x1.b8b6e2eb1d02ap+6,  0x1.0845a699f41d3p-159,   0x1.998e7cp-4, INEXACT)
T(RN,   -0x1.b5e0ded2898ddp+6,  0x1.0c7eb2b56e0dep-158,   0x1.0229a2p-3, INEXACT)
T(RN,    -0x1.b30adab9f619p+6,  0x1.10c905036aff7p-157,  -0x1.1babaap-3, INEXACT)
T(RN,   -0x1.b034d6a162a43p+6,  0x1.1524e42d9fff5p-156,  -0x1.e2b69cp-2, INEXACT)
T(RN,   -0x1.ad5ed288cf2f6p+6,  0x1.199297fed0f42p-155,  -0x1.6ff5e4p-3, INEXACT)
T(RN,   -0x1.aa88ce703bba9p+6,  0x1.1e1269676f0dcp-154,    0x1.abd9cp-2, INEXACT)
T(RN,   -0x1.a7b2ca57a845cp+6,  0x1.22a4a2824a1a7p-153,   0x1.0f5cc8p-2, INEXACT)
T(RN,   -0x1.a4dcc63f14d0fp+6,  0x1.27498e99550e5p-152,  -0x1.746262p-5, INEXACT)
T(RN,   -0x1.a206c226815c2p+6,  0x1.2c017a2a7e0b6p-151,  -0x1.72bc12p-3, INEXACT)
T(RN,   -0x1.9f30be0dede75p+6,  0x1.30ccb2ec9a3a3p-150,   0x1.f4b454p-3, INEXACT)
T(RN,   -0x1.9c5ab9f55a728p+6,  0x1.35ab87d465c41p-149,   0x1.4fa03cp-2, INEXACT)
T(RN,   -0x1.9984b5dcc6fdbp+6,  0x1.3a9e491998417p-148,   0x1.17e9d8p-2, INEXACT)
T(RN,   -0x1.96aeb1c43388ep+6,  0x1.3fa5483c0defap-147,  -0x1.0096bap-3, INEXACT)
T(RN,   -0x1.93d8adaba0141p+6,  0x1.44c0d80906036p-146,   0x1.02a13ap-5, INEXACT)
T(RN,   -0x1.9102a9930c9f4p+6,  0x1.49f14ca0766e2p-145,  -0x1.e77e92p-2, INEXACT)
T(RN,   -0x1.8e2ca57a792a7p+6,  0x1.4f36fb7a756e8p-144,   0x1.774b08p-3, INEXACT)
T(RN,   -0x1.8b56a161e5b5ap+6,  0x1.54923b6cb943fp-143,   0x1.59fdc4p-3, INEXACT)
T(RN,   -0x1.88809d495240dp+6,  0x1.5a0364b02e619p-142,   0x1.11daaap-2, INEXACT)
T(RN,    -0x1.85aa9930beccp+6,  0x1.5f8ad0e6a47aep-141,  -0x1.8b7b02p-6, INEXACT)
T(RN,   -0x1.82d495182b573p+6,  0x1.6528db2092c8cp-140,  -0x1.920522p-2, INEXACT)
T(RN,   -0x1.7ffe90ff97e26p+6,  0x1.6adddfe2f3e53p-139,  -0x1.f72e9ap-3, INEXACT)
T(RN,   -0x1.7d288ce7046d9p+6,  0x1.70aa3d2d399e7p-138,   0x1.4b068ap-3, INEXACT)
T(RN,   -0x1.7a5288ce70f8cp+6,  0x1.768e527f5923bp-137,    0x1.93538p-2, INEXACT)
T(RN,   -0x1.777c84b5dd83fp+6,  0x1.7c8a80dfefeecp-136,  -0x1.8df3f6p-2, INEXACT)
T(RN,   -0x1.74a6809d4a0f2p+6,  0x1.829f2ae281d04p-135,   0x1.3b4586p-2, INEXACT)
T(RN,   -0x1.71d07c84b69a5p+6,  0x1.88ccb4add0842p-134,  -0x1.8e7a8ep-7, INEXACT)
T(RN,   -0x1.6efa786c23258p+6,  0x1.8f1384024d38cp-133,   0x1.e780e4p-2, INEXACT)
T(RN,   -0x1.6c2474538fb0bp+6,  0x1.95740040a470ap-132,  -0x1.3a6098p-3, INEXACT)
T(RN,   -0x1.694e703afc3bep+6,  0x1.9bee927064ac8p-131,  -0x1.697eacp-3, INEXACT)
T(RN,   -0x1.66786c2268c71p+6,  0x1.a283a546c049bp-130,  -0x1.ce4fdap-5, INEXACT)
T(RN,   -0x1.63a26809d5524p+6,  0x1.a933a52d6b053p-129,  -0x1.f02feep-3, INEXACT)
T(RN,   -0x1.60cc63f141dd7p+6,  0x1.afff004993942p-128,  -0x1.965b14p-4, INEXACT)
T(RN,   -0x1.5df65fd8ae68ap+6,  0x1.b6e62682f9c44p-127,  -0x1.c2f862p-5, INEXACT)
T(RN,   -0x1.5b205bc01af3dp+6,  0x1.bde9898b2199ap-126,  -0x1.aa79acp-2, INEXACT)
T(RN,    -0x1.584a57a7877fp+6,  0x1.c5099ce4a3dfep-125,  -0x1.31290ap-3, INEXACT)
T(RN,   -0x1.5574538ef40a3p+6,  0x1.cc46d5ea9ca73p-124,  -0x1.db2ad6p-3, INEXACT)
T(RN,   -0x1.529e4f7660956p+6,  0x1.d3a1abd838283p-123, -0x1.c9a3fep-10, INEXACT)
T(RN,   -0x1.4fc84b5dcd209p+6,  0x1.db1a97d05e8a3p-122,  -0x1.827d8ap-3, INEXACT)
T(RN,   -0x1.4cf2474539abcp+6,  0x1.e2b214e57f0afp-121,  -0x1.3359c6p-3, INEXACT)
T(RN,   -0x1.4a1c432ca636fp+6,  0x1.ea68a0217b079p-120,  -0x1.95c01ep-4, INEXACT)
T(RN,   -0x1.47463f1412c22p+6,  0x1.f23eb88db169ap-119,   0x1.8a7f86p-5, INEXACT)
T(RN,   -0x1.44703afb7f4d5p+6,  0x1.fa34df3b2afc8p-118,   0x1.f71704p-3, INEXACT)
T(RN,   -0x1.419a36e2ebd88p+6,  0x1.0125cba57418ep-116,  -0x1.0dc904p-2, INEXACT)
T(RN,   -0x1.3ec432ca5863bp+6,  0x1.0541b2fb286edp-115,   0x1.c04d14p-4, INEXACT)
T(RN,   -0x1.3bee2eb1c4eeep+6,  0x1.096e694be33acp-114,   0x1.21c644p-5, INEXACT)
T(RN,   -0x1.39182a99317a1p+6,  0x1.0dac3359acafap-113,  -0x1.54eff4p-3, INEXACT)
T(RN,   -0x1.364226809e054p+6,  0x1.11fb56ffd0efap-112,  -0x1.a8549cp-2, INEXACT)
T(RN,   -0x1.336c22680a907p+6,  0x1.165c1b375e9bep-111,  -0x1.eb419ap-4, INEXACT)
T(RN,   -0x1.30961e4f771bap+6,  0x1.1acec81bb7c68p-110,  -0x1.461f18p-2, INEXACT)
T(RN,   -0x1.2dc01a36e3a6dp+6,  0x1.1f53a6ef3592dp-109,   0x1.2c3368p-6, INEXACT)
T(RN,    -0x1.2aea161e5032p+6,  0x1.23eb021fdecf3p-108,   -0x1.826eap-5, INEXACT)
T(RN,   -0x1.28141205bcbd3p+6,  0x1.2895254c31d73p-107,  -0x1.e261eep-3, INEXACT)
T(RN,   -0x1.253e0ded29486p+6,  0x1.2d525d48020c2p-106,   0x1.b6556ep-2, INEXACT)
T(RN,   -0x1.226809d495d39p+6,  0x1.3222f82169344p-105,   0x1.39231ap-2, INEXACT)
T(RN,   -0x1.1f9205bc025ecp+6,  0x1.37074525cd12bp-104,   0x1.f0003cp-2, INEXACT)
T(RN,   -0x1.1cbc01a36ee9fp+6,  0x1.3bff94e6f989bp-103,   0x1.80409cp-2, INEXACT)
T(RN,   -0x1.19e5fd8adb752p+6,  0x1.410c39404f9c4p-102,   0x1.927472p-5, INEXACT)
T(RN,   -0x1.170ff97248005p+6,  0x1.462d855c09a3fp-101,   0x1.2aa5d2p-2, INEXACT)
T(RN,   -0x1.1439f559b48b8p+6,  0x1.4b63cdb895119p-100,  -0x1.d7d0b2p-2, INEXACT)
T(RN,   -0x1.1163f1412116bp+6,   0x1.50af682e0211ap-99,  -0x1.49cfacp-2, INEXACT)
T(RN,   -0x1.0e8ded288da1ep+6,   0x1.5610abf3896ccp-98,   0x1.40c852p-3, INEXACT)
T(RN,   -0x1.0bb7e90ffa2d1p+6,   0x1.5b87f1a529005p-97,  -0x1.86f1cap-6, INEXACT)
T(RN,   -0x1.08e1e4f766b84p+6,   0x1.61159349572b3p-96,  -0x1.23d7d2p-3, INEXACT)
T(RN,   -0x1.060be0ded3437p+6,   0x1.66b9ec56cd8c4p-95,   0x1.108582p-2, INEXACT)
T(RN,   -0x1.0335dcc63fceap+6,   0x1.6c7559ba6b725p-94,  -0x1.3b7e36p-5, INEXACT)
T(RN,   -0x1.005fd8adac59dp+6,   0x1.724839dd305ecp-93,   0x1.6958aap-2, INEXACT)
T(RN,   -0x1.fd58793ddaf44p+5,   0x1.1b4da51532acfp-92,   0x1.dfcab2p-2, INEXACT)
T(RN,   -0x1.f7ac710cb40aap+5,   0x1.1fd48adcf62bcp-91,   0x1.c202dap-4, INEXACT)
T(RN,    -0x1.f20068db8d21p+5,   0x1.246df54cc2a0bp-90,  -0x1.e9ed92p-4, INEXACT)
T(RN,   -0x1.ec5460aa66376p+5,   0x1.291a302502532p-89,   0x1.fe676cp-2, INEXACT)
T(RN,   -0x1.e6a858793f4dcp+5,   0x1.2dd9885bff52fp-88,  -0x1.5569dcp-3, INEXACT)
T(RN,   -0x1.e0fc504818642p+5,   0x1.32ac4c22d70ffp-87,   -0x1.b6eabp-2, INEXACT)
T(RN,   -0x1.db504816f17a8p+5,   0x1.3792caea8231ep-86,   0x1.9e7524p-2, INEXACT)
T(RN,   -0x1.d5a43fe5ca90ep+5,   0x1.3c8d5568f104cp-85,   0x1.4dd41ep-5, INEXACT)
T(RN,   -0x1.cff837b4a3a74p+5,    0x1.419c3d9e3ccep-84,   0x1.2f0e8ep-3, INEXACT)
T(RN,   -0x1.ca4c2f837cbdap+5,   0x1.46bfd6d9ee5ebp-83,   -0x1.586efp-3, INEXACT)
T(RN,    -0x1.c4a0275255d4p+5,   0x1.4bf875c05a3b2p-82,   0x1.77a7d8p-2, INEXACT)
T(RN,   -0x1.bef41f212eea6p+5,   0x1.5146705012aeep-81,   -0x1.35656p-2, INEXACT)
T(RN,   -0x1.b94816f00800cp+5,   0x1.56aa1de770284p-80,  -0x1.655342p-2, INEXACT)
T(RN,   -0x1.b39c0ebee1172p+5,   0x1.5c23d74a3034dp-79,  -0x1.126b4cp-3, INEXACT)
T(RN,   -0x1.adf0068dba2d8p+5,   0x1.61b3f6a72b7cdp-78,   0x1.4a7bc2p-3, INEXACT)
T(RN,   -0x1.a843fe5c9343ep+5,   0x1.675ad79e231afp-77,   0x1.82d2cep-2, INEXACT)
T(RN,   -0x1.a297f62b6c5a4p+5,   0x1.6d18d745a5b01p-76,  -0x1.3a02cep-2, INEXACT)
T(RN,   -0x1.9cebedfa4570ap+5,   0x1.72ee54310c946p-75,  -0x1.9277b4p-6, INEXACT)
T(RN,    -0x1.973fe5c91e87p+5,   0x1.78dbae769187bp-74,  -0x1.760ebep-4, INEXACT)
T(RN,   -0x1.9193dd97f79d6p+5,   0x1.7ee147b57d467p-73,   0x1.afa7acp-2, INEXACT)
T(RN,   -0x1.8be7d566d0b3cp+5,   0x1.84ff831c6f67ep-72,    0x1.3d9fbp-2, INEXACT)
T(RN,   -0x1.863bcd35a9ca2p+5,    0x1.8b36c56fbfeep-71,  -0x1.291c1ep-4, INEXACT)
T(RN,   -0x1.808fc50482e08p+5,   0x1.9187750ffaef9p-70,   0x1.6dadccp-2, INEXACT)
T(RN,   -0x1.7ae3bcd35bf6ep+5,    0x1.97f1fa0076c7p-69,   -0x1.82344p-2, INEXACT)
T(RN,   -0x1.7537b4a2350d4p+5,   0x1.9e76bdee0533bp-68,   0x1.76835ep-3, INEXACT)
T(RN,   -0x1.6f8bac710e23ap+5,    0x1.a5162c35bfdap-67,   0x1.cac70ep-3, INEXACT)
T(RN,    -0x1.69dfa43fe73ap+5,   0x1.abd0b1ebf0942p-66,   0x1.75c6c8p-4, INEXACT)
T(RN,   -0x1.64339c0ec0506p+5,   0x1.b2a6bde31603ep-65,  -0x1.c3eb94p-2, INEXACT)
T(RN,   -0x1.5e8793dd9966cp+5,   0x1.b998c0b304d9fp-64,  -0x1.c114b8p-2, INEXACT)
T(RN,   -0x1.58db8bac727d2p+5,   0x1.c0a72cc026478p-63,   0x1.d3d0d4p-2, INEXACT)
T(RN,   -0x1.532f837b4b938p+5,   0x1.c7d27642d411cp-62,  -0x1.21af66p-3, INEXACT)
T(RN,   -0x1.4d837b4a24a9ep+5,   0x1.cf1b134ed2c11p-61,  -0x1.a90416p-2, INEXACT)
T(RN,   -0x1.47d77318fdc04p+5,   0x1.d6817bdaea65bp-60,   0x1.1605fap-2, INEXACT)
T(RN,   -0x1.422b6ae7d6d6ap+5,   0x1.de0629c89e701p-59,  -0x1.280646p-2, INEXACT)
T(RN,    -0x1.3c7f62b6afedp+5,   0x1.e5a998ec051c3p-58,  -0x1.255e8ap-8, INEXACT)
T(RN,   -0x1.36d35a8589036p+5,   0x1.ed6c4713beefcp-57,   0x1.2a5882p-5, INEXACT)
T(RN,   -0x1.312752546219cp+5,   0x1.f54eb4110ecfep-56,    0x1.b9f1bp-7, INEXACT)
T(RN,   -0x1.2b7b4a233b302p+5,   0x1.fd5161c01332bp-55,  -0x1.e3f818p-3, INEXACT)
T(RN,   -0x1.25cf41f214468p+5,   0x1.02ba6a08107a5p-53,  -0x1.effefep-2, INEXACT)
T(RN,   -0x1.202339c0ed5cep+5,   0x1.06dcc886202d9p-52,  -0x1.fd9306p-5, INEXACT)
T(RN,   -0x1.1a77318fc6734p+5,   0x1.0b101071e667ep-51,  -0x1.4c33d6p-2, INEXACT)
T(RN,   -0x1.14cb295e9f89ap+5,   0x1.0f5486f99bf1cp-50,  -0x1.5b5776p-4, INEXACT)
T(RN,     -0x1.0f1f212d78ap+5,   0x1.13aa726678142p-49,  -0x1.f2deeep-2, INEXACT)
T(RN,   -0x1.097318fc51b66p+5,   0x1.18121a21363acp-48,   0x1.be408ap-2, INEXACT)
T(RN,   -0x1.03c710cb2acccp+5,   0x1.1c8bc6b6ae154p-47,   0x1.e3c202p-2, INEXACT)
T(RN,   -0x1.f9f141205e9c3p+4,   0x1.4d228dfbd905ep-46,   -0x1.abd95p-4, INEXACT)
T(RN,   -0x1.ee9930be10c94p+4,    0x1.52754bf2fdf8p-45,  -0x1.eb8a3ep-5, INEXACT)
T(RN,   -0x1.e341205bc2f65p+4,   0x1.57ddd06df2d77p-44,   0x1.052752p-2, INEXACT)
T(RN,   -0x1.d7e90ff975236p+4,    0x1.5d5c74802a18p-43,    0x1.6b0a2p-2, INEXACT)
T(RN,   -0x1.cc90ff9727507p+4,   0x1.62f192a97755bp-42,  -0x1.1f0d18p-2, INEXACT)
T(RN,   -0x1.c138ef34d97d8p+4,   0x1.689d86dbe1e26p-41,   0x1.35d486p-2, INEXACT)
T(RN,   -0x1.b5e0ded28baa9p+4,   0x1.6e60ae818f244p-40,  -0x1.fdc242p-2, INEXACT)
T(RN,   -0x1.aa88ce703dd7ap+4,   0x1.743b6882c5281p-39,  -0x1.1766f4p-2, INEXACT)
T(RN,   -0x1.9f30be0df004bp+4,    0x1.7a2e154c05c8p-38,  -0x1.000d16p-2, INEXACT)
T(RN,   -0x1.93d8adaba231cp+4,   0x1.803916d442cdcp-37,  -0x1.002086p-2, INEXACT)
T(RN,   -0x1.88809d49545edp+4,   0x1.865cd0a32b74bp-36,   0x1.d5d756p-3, INEXACT)
T(RN,   -0x1.7d288ce7068bep+4,   0x1.8c99a7d793b45p-35,  -0x1.11bcc8p-3, INEXACT)
T(RN,   -0x1.71d07c84b8b8fp+4,   0x1.92f0032df5bcep-34,  -0x1.6a59dap-3, INEXACT)
T(RN,    -0x1.66786c226ae6p+4,   0x1.99604b070e107p-33,   0x1.2109d8p-4, INEXACT)
T(RN,   -0x1.5b205bc01d131p+4,    0x1.9feae96e92a6p-32,  -0x1.c8351cp-4, INEXACT)
T(RN,   -0x1.4fc84b5dcf402p+4,   0x1.a6904a2205852p-31,  -0x1.075766p-3, INEXACT)
T(RN,   -0x1.44703afb816d3p+4,   0x1.ad50da97a34a2p-30,    0x1.f5064p-2, INEXACT)
T(RN,   -0x1.39182a99339a4p+4,   0x1.b42d0a056e052p-29,  -0x1.e34f0cp-2, INEXACT)
T(RN,   -0x1.2dc01a36e5c75p+4,   0x1.bb25496854e8bp-28,  -0x1.d8ca14p-2, INEXACT)
T(RN,   -0x1.226809d497f46p+4,   0x1.c23a0b8b793c4p-27,  -0x1.d1e91ep-3, INEXACT)
T(RN,   -0x1.170ff9724a217p+4,   0x1.c96bc50f910bdp-26,  -0x1.5c3448p-5, INEXACT)
T(RN,   -0x1.0bb7e90ffc4e8p+4,   0x1.d0baec72680d8p-25,  -0x1.6fb206p-2, INEXACT)
T(RN,   -0x1.005fd8adae7b9p+4,    0x1.d827fa167f39p-24,  -0x1.005df4p-2, INEXACT)
T(RN,   -0x1.ea0f9096c1514p+3,   0x1.dfb3684acb8e1p-23,   0x1.9b6c48p-2, INEXACT)
T(RN,   -0x1.d35f6fd225ab6p+3,   0x1.e75db3529489fp-22,  -0x1.64ff06p-4, INEXACT)
T(RN,   -0x1.bcaf4f0d8a058p+3,   0x1.ef27596d72cdbp-21,   0x1.4979c8p-2, INEXACT)
T(RN,   -0x1.a5ff2e48ee5fap+3,   0x1.f710dadf6f77dp-20,  -0x1.7db5f6p-2, INEXACT)
T(RN,   -0x1.8f4f0d8452b9cp+3,   0x1.ff1ab9f944b8dp-19,   0x1.0a23a8p-2, INEXACT)
T(RN,   -0x1.789eecbfb713ep+3,   0x1.03a2bd9060144p-17,   0x1.ccc7c6p-5, INEXACT)
T(RN,    -0x1.61eecbfb1b6ep+3,   0x1.07c8d26ca3b42p-16,  -0x1.31f118p-3, INEXACT)
T(RN,   -0x1.4b3eab367fc82p+3,   0x1.0bffdfe63fce7p-15,   -0x1.18245p-3, INEXACT)
T(RN,   -0x1.348e8a71e4224p+3,   0x1.10482b698c27bp-14,   0x1.ba216ap-3, INEXACT)
T(RN,   -0x1.1dde69ad487c6p+3,   0x1.14a1fb7edd22ap-13,   0x1.705cd4p-2, INEXACT)
T(RN,   -0x1.072e48e8acd68p+3,   0x1.190d97cf0d71ep-12,   0x1.e8868ep-2, INEXACT)
T(RN,    -0x1.ea0f9096c70ap+2,   0x1.ef965c2047857p-12,   0x1.8cfabep-2, INEXACT)
T(RN,   -0x1.bcaf4f0d8fbe4p+2,   0x1.f781a3ad828cep-11,    0x1.3066dp-4, INEXACT)
T(RN,   -0x1.8f4f0d8458728p+2,   0x1.ff8d50242e85bp-10,   0x1.1f2902p-6, INEXACT)
T(RN,   -0x1.61eecbfb2126cp+2,    0x1.03dcf303e3e92p-8,   0x1.075a68p-4, INEXACT)
T(RN,    -0x1.348e8a71e9dbp+2,    0x1.0803f5fcee253p-7,  -0x1.b2b18ap-4, INEXACT)
T(RN,   -0x1.072e48e8b28f4p+2,    0x1.0c3bf5615a531p-6,  -0x1.7cf0e8p-2, INEXACT)
T(RN,   -0x1.c5c28f5c3fd88p+1,    0x1.d8fbc7637d03ep-6,   -0x1.43054p-2, INEXACT)
T(RN,    -0x1.6b020c49d141p+1,    0x1.e08a9800b6475p-5,  -0x1.80372cp-2, INEXACT)
T(RN,   -0x1.1041893762a98p+1,    0x1.e83853499c728p-4,  -0x1.d5b434p-4, INEXACT)
T(RN,    -0x1.b39c0ebf0d6ap+0,    0x1.7589a7eb9d04ap-3,  -0x1.d687ecp-2, INEXACT)
T(RN,   -0x1.b39c0ebf3b2fep-1,    0x1.b552a90ce11edp-2,  -0x1.84bceep-3, INEXACT)
T(RN,    0x1.b39c0ebe288d4p-2,    0x1.87bb57d26b9d5p+0,   0x1.dd730ap-2, INEXACT)
T(RN,    0x1.b39c0ebe8418dp-1,    0x1.2bb6e7af4db8ep+1,  -0x1.ae6f1ap-3, INEXACT)
T(RN,    0x1.46b50b0ef9f57p+0,    0x1.ca9fb149d187bp+1,   0x1.75eeaap-2, INEXACT)
T(RN,    0x1.fc361133d7247p+0,    0x1.d1f3c44829f18p+2,   0x1.ddc254p-3, INEXACT)
T(RN,    0x1.58db8bac5a29cp+1,    0x1.d965d1a862d62p+3,  -0x1.4fa8e4p-4, INEXACT)
T(RN,    0x1.b39c0ebec8c14p+1,    0x1.e0f6540bc6d9fp+4,  -0x1.cf2608p-4, INEXACT)
T(RN,    0x1.072e48e89bac6p+2,    0x1.e8a5c80943ecbp+5,  -0x1.99bebcp-2, INEXACT)
T(RN,    0x1.348e8a71d2f82p+2,    0x1.f074ac356f50fp+6,   0x1.ad96b2p-2, INEXACT)
T(RN,    0x1.61eecbfb0a43ep+2,    0x1.f863812aaa6dbp+7,  -0x1.1f906ep-3, INEXACT)
T(RN,    0x1.8f4f0d84418fap+2,    0x1.003964c8b4788p+9,  -0x1.f722b8p-2, INEXACT)
T(RN,    0x1.bcaf4f0d78db6p+2,   0x1.045185144c655p+10,   0x1.f2cca2p-2, INEXACT)
T(RN,    0x1.ea0f9096b0272p+2,   0x1.087a64e716449p+11,   0x1.db224ap-2, INEXACT)
T(RN,    0x1.10418937460ddp+3,    0x1.35a3ea3967acp+12,  -0x1.ac8912p-4, INEXACT)
T(RN,    0x1.26f1a9fbe1b3bp+3,   0x1.3a968c576dacap+13,    0x1.711e1p-2, INEXACT)
T(RN,    0x1.3da1cac07d599p+3,   0x1.3f9d6bd34723cp+14,  -0x1.e8393cp-3, INEXACT)
T(RN,    0x1.5451eb8518ff7p+3,   0x1.44b8db7829f9ap+15,   0x1.ce6918p-2, INEXACT)
T(RN,    0x1.6b020c49b4a55p+3,   0x1.49e92f63fa7e9p+16,  -0x1.405feap-7, INEXACT)
T(RN,    0x1.81b22d0e504b3p+3,   0x1.4f2ebd0cb4d99p+17,  -0x1.f264fcp-2, INEXACT)
T(RN,    0x1.98624dd2ebf11p+3,   0x1.5489db45ec998p+18,  -0x1.4ef34ap-4, INEXACT)
T(RN,    0x1.af126e978796fp+3,   0x1.59fae24662c45p+19,  -0x1.38c346p-4, INEXACT)
T(RN,    0x1.c5c28f5c233cdp+3,   0x1.5f822badb2c07p+20,   -0x1.81faep-4, INEXACT)
T(RN,    0x1.dc72b020bee2bp+3,   0x1.6520128a16754p+21,  -0x1.b771a8p-4, INEXACT)
T(RN,    0x1.f322d0e55a889p+3,    0x1.6ad4f35e4202p+22,    0x1.968cep-3, INEXACT)
T(RN,    0x1.072e48e8a4417p+4,   0x1.a8c9f4030563fp+23,  -0x1.c777a6p-2, INEXACT)
T(RN,    0x1.1286594af2146p+4,   0x1.af939ec5812cfp+24,   0x1.05f36ep-8, INEXACT)
T(RN,    0x1.1dde69ad3fe75p+4,   0x1.b6790dbca1733p+25,   0x1.d10e5cp-3, INEXACT)
T(RN,    0x1.29367a0f8dba4p+4,   0x1.bd7ab27da77ebp+26,  -0x1.18aefep-2, INEXACT)
T(RN,    0x1.348e8a71db8d3p+4,   0x1.c499006e75c43p+27,  -0x1.7c7626p-3, INEXACT)
T(RN,    0x1.3fe69ad429602p+4,   0x1.cbd46cccfc894p+28,  -0x1.55f16ap-2, INEXACT)
T(RN,    0x1.4b3eab3677331p+4,   0x1.d32d6eb6c4e7bp+29,   0x1.1ef69ep-2, INEXACT)
T(RN,     0x1.5696bb98c506p+4,   0x1.daa47f309aab9p+30,  -0x1.a6dd84p-2, INEXACT)
T(RN,    0x1.61eecbfb12d8fp+4,   0x1.e23a192e558b5p+31,   0x1.46b326p-3, INEXACT)
T(RN,    0x1.6d46dc5d60abep+4,   0x1.e9eeb99ac2386p+32,  -0x1.1da21ep-2, INEXACT)
T(RN,    0x1.789eecbfae7edp+4,   0x1.f1c2df5fabccdp+33,  -0x1.2832acp-3, INEXACT)
T(RN,    0x1.83f6fd21fc51cp+4,   0x1.f9b70b6e06184p+34,   0x1.da7f14p-7, INEXACT)
T(RN,    0x1.8f4f0d844a24bp+4,    0x1.00e5e0631caap+36,  -0x1.d7e7fcp-2, INEXACT)
T(RN,    0x1.9aa71de697f7ap+4,   0x1.0500c24047e36p+37,   0x1.5851d6p-3, INEXACT)
T(RN,    0x1.a5ff2e48e5ca9p+4,   0x1.092c6eeae2f0bp+38,  -0x1.5ecc74p-4, INEXACT)
T(RN,    0x1.b1573eab339d8p+4,   0x1.0d692b13deb24p+39,  -0x1.021836p-2, INEXACT)
T(RN,    0x1.bcaf4f0d81707p+4,   0x1.11b73c852a0dap+40,  -0x1.e8000ep-3, INEXACT)
T(RN,    0x1.c8075f6fcf436p+4,   0x1.1616ea262f5f5p+41,  -0x1.707272p-3, INEXACT)
T(RN,    0x1.d35f6fd21d165p+4,   0x1.1a887c00644a7p+42,   0x1.cf4948p-2, INEXACT)
T(RN,    0x1.deb780346ae94p+4,   0x1.1f0c3b43ec315p+43,  -0x1.2fea04p-3, INEXACT)
T(RN,    0x1.ea0f9096b8bc3p+4,    0x1.23a2724c4da4p+44,  -0x1.7ade9cp-2, INEXACT)
T(RN,    0x1.f567a0f9068f2p+4,   0x1.284b6ca53b114p+45,   0x1.dfec34p-2, INEXACT)
T(RN,    0x1.03c710cb27f07p+5,   0x1.cca2b291d561fp+46,   0x1.3805f6p-2, INEXACT)
T(RN,    0x1.097318fc4eda1p+5,   0x1.d3ff004614fd7p+47,  -0x1.ed56c4p-2, INEXACT)
T(RN,    0x1.0f1f212d75c3bp+5,   0x1.db796a060b71bp+48,   0x1.008892p-3, INEXACT)
T(RN,    0x1.14cb295e9cad5p+5,   0x1.e3126afcb8087p+49,   0x1.5e0e44p-4, INEXACT)
T(RN,    0x1.1a77318fc396fp+5,   0x1.eaca804cf0a55p+50,   0x1.dfb758p-3, INEXACT)
T(RN,    0x1.202339c0ea809p+5,   0x1.f2a229196ecd9p+51,   0x1.eaf21ep-4, INEXACT)
T(RN,    0x1.25cf41f2116a3p+5,   0x1.fa99e68cfd9f3p+52,   0x1.69e3aep-3, INEXACT)
T(RN,    0x1.2b7b4a233853dp+5,   0x1.01591df1649ecp+54,  -0x1.21303ap-3, INEXACT)
T(RN,    0x1.312752545f3d7p+5,   0x1.0575d737681e5p+55,   0x1.91ebb8p-2, INEXACT)
T(RN,    0x1.36d35a8586271p+5,   0x1.09a362d33bcafp+56,  -0x1.7c2992p-5, INEXACT)
T(RN,    0x1.3c7f62b6ad10bp+5,   0x1.0de20594a0da2p+57,  -0x1.7ed0aap-2, INEXACT)
T(RN,    0x1.422b6ae7d3fa5p+5,   0x1.12320564d4932p+58,  -0x1.c9d26ap-3, INEXACT)
T(RN,    0x1.47d77318fae3fp+5,   0x1.1693a94b0fc43p+59,  -0x1.0cfcc8p-2, INEXACT)
T(RN,    0x1.4d837b4a21cd9p+5,   0x1.1b073971189e3p+60,  -0x1.72c6dep-4, INEXACT)
T(RN,    0x1.532f837b48b73p+5,   0x1.1f8cff27e7418p+61,   0x1.1a277ap-5, INEXACT)
T(RN,    0x1.58db8bac6fa0dp+5,    0x1.242544ec5d49p+62,   0x1.349ebep-3, INEXACT)
T(RN,    0x1.5e8793dd968a7p+5,   0x1.28d0566c10a0ap+63,   0x1.8ed35ep-3, INEXACT)
T(RN,    0x1.64339c0ebd741p+5,   0x1.2d8e808a29f69p+64,   0x1.621caep-2, INEXACT)
T(RN,    0x1.69dfa43fe45dbp+5,   0x1.3260116457172p+65,   0x1.0e01d4p-5, INEXACT)
T(RN,    0x1.6f8bac710b475p+5,   0x1.37455857d1851p+66,   0x1.53733ep-6, INEXACT)
T(RN,    0x1.7537b4a23230fp+5,   0x1.3c3ea60679a0ap+67,   0x1.468456p-3, INEXACT)
T(RN,    0x1.7ae3bcd3591a9p+5,   0x1.414c4c5c06b1fp+68,   0x1.c9395cp-3, INEXACT)
T(RN,    0x1.808fc50480043p+5,   0x1.466e9e934c2bep+69,  -0x1.f0307ep-3, INEXACT)
T(RN,    0x1.863bcd35a6eddp+5,   0x1.4ba5f13b947e7p+70,    0x1.cc36fp-7, INEXACT)
T(RN,    0x1.8be7d566cdd77p+5,   0x1.50f29a3e11d05p+71,  -0x1.2c0d72p-3, INEXACT)
T(RN,    0x1.9193dd97f4c11p+5,   0x1.5654f0e364fa2p+72,  -0x1.627604p-5, INEXACT)
T(RN,    0x1.973fe5c91baabp+5,   0x1.5bcd4dd93b1d7p+73,   -0x1.e283ep-3, INEXACT)
T(RN,    0x1.9cebedfa42945p+5,   0x1.615c0b380234dp+74,   0x1.336124p-2, INEXACT)
T(RN,    0x1.a297f62b697dfp+5,   0x1.67018488b4fa2p+75,   0x1.864abap-2, INEXACT)
T(RN,    0x1.a843fe5c90679p+5,   0x1.6cbe16cabe837p+76,  -0x1.37dd04p-2, INEXACT)
T(RN,    0x1.adf0068db7513p+5,   0x1.72922079f5f6ep+77,  -0x1.72ce72p-3, INEXACT)
T(RN,    0x1.b39c0ebede3adp+5,   0x1.787e0194b2b7ep+78,   0x1.c6ae94p-2, INEXACT)
T(RN,    0x1.b94816f005247p+5,   0x1.7e821ba1f9728p+79,  -0x1.9db0dep-4, INEXACT)
T(RN,    0x1.bef41f212c0e1p+5,   0x1.849ed1b7c26a9p+80,   0x1.c1ad68p-2, INEXACT)
T(RN,    0x1.c4a0275252f7bp+5,   0x1.8ad488815974cp+81,  -0x1.ba21e4p-3, INEXACT)
T(RN,    0x1.ca4c2f8379e15p+5,   0x1.9123a645d804bp+82,   -0x1.732aep-5, INEXACT)
T(RN,    0x1.cff837b4a0cafp+5,   0x1.978c92eeb9b88p+83,  -0x1.87e252p-2, INEXACT)
T(RN,    0x1.d5a43fe5c7b49p+5,   0x1.9e0fb80e8bd02p+84,   -0x1.05b47p-3, INEXACT)
T(RN,    0x1.db504816ee9e3p+5,    0x1.a4ad80e7b7fdp+85,  -0x1.26d982p-2, INEXACT)
T(RN,    0x1.e0fc50481587dp+5,   0x1.ab665a736afb3p+86,   0x1.ce8e64p-3, INEXACT)
T(RN,    0x1.e6a858793c717p+5,   0x1.b23ab36897648p+87,   0x1.6c9aeap-6, INEXACT)
T(RN,    0x1.ec5460aa635b1p+5,   0x1.b92afc4315324p+88,    0x1.26156p-2, INEXACT)
T(RN,    0x1.f20068db8a44bp+5,   0x1.c037a74ade61cp+89,   0x1.7934f2p-2, INEXACT)
T(RN,    0x1.f7ac710cb12e5p+5,   0x1.c761289b6933cp+90,  -0x1.b9b86ap-3, INEXACT)
T(RN,    0x1.fd58793dd817fp+5,   0x1.cea7f62b207f8p+91,     0x1.5039p-4, INEXACT)
T(RN,    0x1.02a4a8c15415ep+6,   0x1.3816e23f0a5c2p+93,   0x1.26c388p-2, INEXACT)
T(RN,    0x1.057aacd9e78abp+6,   0x1.3d138914810dep+94,   0x1.4457b8p-2, INEXACT)
T(RN,    0x1.0850b0f27aff8p+6,   0x1.422496432d9cap+95,   0x1.2f8c94p-5, INEXACT)
T(RN,    0x1.0b26b50b0e745p+6,   0x1.474a5d3deaa13p+96,  -0x1.148472p-3, INEXACT)
T(RN,    0x1.0dfcb923a1e92p+6,   0x1.4c8532cceee25p+97,  -0x1.d1571cp-3, INEXACT)
T(RN,    0x1.10d2bd3c355dfp+6,   0x1.51d56d1341b82p+98,    0x1.ff8aap-2, INEXACT)
T(RN,    0x1.13a8c154c8d2cp+6,   0x1.573b639445bf7p+99,   0x1.799bf2p-2, INEXACT)
T(RN,    0x1.167ec56d5c479p+6,   0x1.5cb76f395a39p+100,   0x1.3bfcf4p-2, INEXACT)
T(RN,    0x1.1954c985efbc6p+6,  0x1.6249ea5793706p+101,   0x1.5715c4p-2, INEXACT)
T(RN,    0x1.1c2acd9e83313p+6,  0x1.67f330b58a897p+102,   0x1.91e5b8p-5, INEXACT)
T(RN,     0x1.1f00d1b716a6p+6,   0x1.6db39f914514p+103,  -0x1.8e8fc6p-2, INEXACT)
T(RN,    0x1.21d6d5cfaa1adp+6,  0x1.738b95a634c6cp+104,   0x1.74a64ep-3, INEXACT)
T(RN,    0x1.24acd9e83d8fap+6,  0x1.797b73334fc41p+105,  -0x1.2be96cp-5, INEXACT)
T(RN,    0x1.2782de00d1047p+6,  0x1.7f839a0141cdfp+106,  -0x1.39e3dap-2, INEXACT)
T(RN,    0x1.2a58e21964794p+6,  0x1.85a46d68b6cdfp+107,  -0x1.86a5b4p-3, INEXACT)
T(RN,    0x1.2d2ee631f7ee1p+6,  0x1.8bde5258bf197p+108,   0x1.964716p-2, INEXACT)
T(RN,    0x1.3004ea4a8b62ep+6,  0x1.9231af5d4ddb3p+109,  -0x1.bcca32p-2, INEXACT)
T(RN,    0x1.32daee631ed7bp+6,  0x1.989eeca5d20dcp+110,  -0x1.fc77fap-6, INEXACT)
T(RN,    0x1.35b0f27bb24c8p+6,   0x1.9f26740bea72p+111,  -0x1.3fe91ap-3, INEXACT)
T(RN,    0x1.3886f69445c15p+6,  0x1.a5c8b11a34f21p+112,   0x1.552b26p-3, INEXACT)
T(RN,    0x1.3b5cfaacd9362p+6,  0x1.ac86111339df2p+113,   0x1.2afc1ep-2, INEXACT)
T(RN,    0x1.3e32fec56caafp+6,  0x1.b35f02f8737d3p+114,   -0x1.de16bp-3, INEXACT)
T(RN,    0x1.410902de001fcp+6,  0x1.ba53f79172502p+115,  -0x1.00ebd4p-3, INEXACT)
T(RN,    0x1.43df06f693949p+6,  0x1.c16561731e9f6p+116,  -0x1.06a75ap-3, INEXACT)
T(RN,    0x1.46b50b0f27096p+6,  0x1.c893b50717a88p+117,  -0x1.aca416p-3, INEXACT)
T(RN,    0x1.498b0f27ba7e3p+6,  0x1.cfdf689330f97p+118,   0x1.2b13f2p-3, INEXACT)
T(RN,     0x1.4c6113404df3p+6,  0x1.d748f4410e6dep+119,  -0x1.62de28p-3, INEXACT)
T(RN,    0x1.4f371758e167dp+6,  0x1.ded0d225df4d9p+120,  -0x1.38330cp-4, INEXACT)
T(RN,    0x1.520d1b7174dcap+6,  0x1.e6777e4a390a1p+121,   0x1.98d0d2p-3, INEXACT)
T(RN,    0x1.54e31f8a08517p+6,  0x1.ee3d76b2121e1p+122,   0x1.67b106p-2, INEXACT)
T(RN,    0x1.57b923a29bc64p+6,  0x1.f6233b64dd915p+123,   0x1.2907c4p-3, INEXACT)
T(RN,    0x1.5a8f27bb2f3b1p+6,  0x1.fe294e75c7a6dp+124,  -0x1.a39b14p-4, INEXACT)
T(RN,    0x1.5d652bd3c2afep+6,  0x1.03281a060a1e7p+126,   0x1.46aa9ep-2, INEXACT)
T(RN,    0x1.603b2fec5624bp+6,  0x1.074c3935cfb45p+127,  -0x1.983db8p-3, INEXACT)
T(RN,    0x1.63113404e9998p+6,  0x1.0b8148fec06d1p+128,  -0x1.1367dap-2, INEXACT)
T(RN,    0x1.65e7381d7d0e5p+6,  0x1.0fc78eac694acp+129,   0x1.d56ad2p-2, INEXACT)
T(RN,    0x1.68bd3c3610832p+6,  0x1.141f50a5cdc98p+130,   0x1.b180f8p-2, INEXACT)
T(RN,    0x1.6b93404ea3f7fp+6,  0x1.1888d671ef6c9p+131,   0x1.5976dcp-3, INEXACT)
T(RN,    0x1.6e694467376ccp+6,  0x1.1d0468bc67d25p+132,   0x1.24cbbap-3, INEXACT)
T(RN,    0x1.713f487fcae19p+6,  0x1.2192515a159b7p+133,  -0x1.a4e536p-2, INEXACT)
T(RN,    0x1.74154c985e566p+6,  0x1.2632db4ddc729p+134,   0x1.b969e2p-2, INEXACT)
T(RN,    0x1.76eb50b0f1cb3p+6,  0x1.2ae652cd78819p+135,   0x1.8ca0c8p-2, INEXACT)
T(RN,      0x1.79c154c9854p+6,  0x1.2fad054665a59p+136,  -0x1.e13dd4p-2, INEXACT)
T(RN,    0x1.7c9758e218b4dp+6,  0x1.34874162dab12p+137,   0x1.92305ap-3, INEXACT)
T(RN,    0x1.7f6d5cfaac29ap+6,  0x1.3975570ed90eap+138,  -0x1.fb54ccp-2, INEXACT)
T(RN,    0x1.824361133f9e7p+6,  0x1.3e77977d5117cp+139,  -0x1.f824eep-3, INEXACT)
T(RN,    0x1.8519652bd3134p+6,  0x1.438e552d5b748p+140,  -0x1.4c48a8p-2, INEXACT)
T(RN,    0x1.87ef694466881p+6,  0x1.48b9e3ef87d9dp+141,  -0x1.3479c2p-3, INEXACT)
T(RN,    0x1.8ac56d5cf9fcep+6,  0x1.4dfa98eb417ddp+142,  -0x1.975ac2p-2, INEXACT)
T(RN,    0x1.8d9b71758d71bp+6,  0x1.5350caa4499b7p+143,   0x1.6b107ep-2, INEXACT)
T(RN,    0x1.9071758e20e68p+6,  0x1.58bcd100485ebp+144,  -0x1.4ba25ep-2, INEXACT)
T(RN,    0x1.934779a6b45b5p+6,  0x1.5e3f054c7496bp+145,    0x1.e9c8ap-3, INEXACT)
T(RN,    0x1.961d7dbf47d02p+6,  0x1.63d7c2435288ap+146,   0x1.afd0e4p-2, INEXACT)
T(RN,    0x1.98f381d7db44fp+6,  0x1.698764128a445p+147,   0x1.ffbc76p-2, INEXACT)
T(RN,    0x1.9bc985f06eb9cp+6,   0x1.6f4e4860d5d9p+148,   0x1.62832cp-3, INEXACT)
T(RN,    0x1.9e9f8a09022e9p+6,  0x1.752cce5407ccep+149,  -0x1.a32062p-2, INEXACT)
T(RN,    0x1.a1758e2195a36p+6,  0x1.7b2356972a3a4p+150,   0x1.159008p-4, INEXACT)
T(RN,    0x1.a44b923a29183p+6,   0x1.81324360b6f7p+151,   0x1.4357dcp-2, INEXACT)
T(RN,     0x1.a7219652bc8dp+6,  0x1.8759f878e92d7p+152,   0x1.d4213ap-3, INEXACT)
T(RN,    0x1.a9f79a6b5001dp+6,  0x1.8d9adb4028cdfp+153,   0x1.456a3ep-4, INEXACT)
T(RN,    0x1.accd9e83e376ap+6,  0x1.93f552b590436p+154,   0x1.80862cp-2, INEXACT)
T(RN,    0x1.afa3a29c76eb7p+6,  0x1.9a69c77d8cd5ap+155,  -0x1.a9ebcap-2, INEXACT)
T(RN,    0x1.b279a6b50a604p+6,  0x1.a0f8a3e89a27fp+156,   0x1.eb5c16p-2, INEXACT)
T(RN,    0x1.b54faacd9dd51p+6,  0x1.a7a253fa19408p+157,  -0x1.4def78p-5, INEXACT)
T(RN,    0x1.b825aee63149ep+6,  0x1.ae67456f438c3p+158,  -0x1.758d18p-3, INEXACT)
T(RN,    0x1.bafbb2fec4bebp+6,  0x1.b547e7c63a4e9p+159,   0x1.782c92p-3, INEXACT)
T(RN,    0x1.bdd1b71758338p+6,  0x1.bc44ac4532f3fp+160,   0x1.598494p-5, INEXACT)
T(RN,    0x1.c0a7bb2feba85p+6,  0x1.c35e0601c0bb5p+161,  -0x1.d176f6p-2, INEXACT)
T(RN,    0x1.c37dbf487f1d2p+6,  0x1.ca9469e83c2ffp+162,  -0x1.8faa34p-2, INEXACT)
T(RN,    0x1.c653c3611291fp+6,  0x1.d1e84ec348ec8p+163,   -0x1.96295p-2, INEXACT)
T(RN,    0x1.c929c779a606cp+6,  0x1.d95a2d437a244p+164,  -0x1.f2b182p-3, INEXACT)
T(RN,    0x1.cbffcb92397b9p+6,  0x1.e0ea8007166f7p+165,   0x1.f3e25ep-3, INEXACT)
T(RN,    0x1.ced5cfaaccf06p+6,  0x1.e899c3a1fb5b2p+166,  -0x1.264094p-2, INEXACT)
T(RN,    0x1.d1abd3c360653p+6,  0x1.f06876a5a13ecp+167,   0x1.4af656p-2, INEXACT)
T(RN,     0x1.d481d7dbf3dap+6,  0x1.f85719a93fda4p+168,   0x1.4f70dap-3, INEXACT)
T(RN,    0x1.d757dbf4874edp+6,  0x1.003317a90a224p+170,  -0x1.bb2722p-2, INEXACT)
T(RN,    0x1.da2de00d1ac3ap+6,  0x1.044b1e2de4589p+171,  -0x1.c3632ap-2, INEXACT)
T(RN,    0x1.dd03e425ae387p+6,  0x1.0873e3d07f4c2p+172,   0x1.a89e24p-3, INEXACT)
T(RN,    0x1.dfd9e83e41ad4p+6,  0x1.0cadad11fde69p+173,   -0x1.f85d2p-2, INEXACT)
T(RN,    0x1.e2afec56d5221p+6,  0x1.10f8bf8bbd89cp+174,   0x1.618d8ap-3, INEXACT)
T(RN,    0x1.e585f06f6896ep+6,  0x1.155561f3d060fp+175,   0x1.1f8b9cp-2, INEXACT)
T(RN,    0x1.e85bf487fc0bbp+6,  0x1.19c3dc218a041p+176,  -0x1.43df36p-2, INEXACT)
T(RN,    0x1.eb31f8a08f808p+6,  0x1.1e4477121eb6dp+177,   0x1.3997b4p-2, INEXACT)
T(RN,    0x1.ee07fcb922f55p+6,  0x1.22d77ced558f9p+178,   0x1.3bae9ep-2, INEXACT)
T(RN,    0x1.f0de00d1b66a2p+6,  0x1.277d390a4dd4ap+179,  -0x1.86c3a6p-2, INEXACT)
T(RN,    0x1.f3b404ea49defp+6,  0x1.2c35f7f457dd5p+180,  -0x1.b408dap-2, INEXACT)
T(RN,    0x1.f68a0902dd53cp+6,  0x1.3102076fe1c6ep+181,   0x1.4224c8p-2, INEXACT)
T(RN,    0x1.f9600d1b70c89p+6,  0x1.35e1b67f784ebp+182,   0x1.43b62cp-3, INEXACT)
T(RN,    0x1.fc361134043d6p+6,  0x1.3ad55568dc245p+183,   0x1.da9724p-2, INEXACT)
T(RN,    0x1.ff0c154c97b23p+6,  0x1.3fdd35ba2c063p+184,   0x1.9bbf94p-2, INEXACT)
T(RN,    0x1.00173eab3623ap+7,  0x1.a8bf81a597eddp+184,  -0x1.11f96ep-3, INEXACT)
T(RN,    0x1.018240b77fddep+7,  0x1.af8901ac286e5p+185,   0x1.64cc76p-2, INEXACT)
T(RN,    0x1.02ed42c3c9982p+7,  0x1.b66e45388ded5p+186,  -0x1.de8e72p-2, INEXACT)
T(RN,    0x1.045844d013526p+7,  0x1.bd6fbddd3e9bdp+187,  -0x1.48cc64p-2, INEXACT)
T(RN,    0x1.05c346dc5d0cap+7,  0x1.c48ddefd466a1p+188,  -0x1.eae2b2p-5, INEXACT)
T(RN,    0x1.072e48e8a6c6ep+7,  0x1.cbc91dd3b37d6p+189,   0x1.21b6f8p-2, INEXACT)
T(RN,    0x1.08994af4f0812p+7,  0x1.d321f17b2103cp+190,   0x1.1ac33ep-2, INEXACT)
T(RN,    0x1.0a044d013a3b6p+7,   0x1.da98d2f560e2p+191,    0x1.4b63ep-3, INEXACT)
T(RN,    0x1.0b6f4f0d83f5ap+7,  0x1.e22e3d3344ba5p+192,  -0x1.10c9d6p-3, INEXACT)
T(RN,    0x1.0cda5119cdafep+7,  0x1.e9e2ad1c86cbcp+193,   0x1.5f2c76p-2, INEXACT)
T(RN,    0x1.0e455326176a2p+7,  0x1.f1b6a197d32c8p+194,  -0x1.4307bep-3, INEXACT)
T(RN,    0x1.0fb0553261246p+7,  0x1.f9aa9b92f1e43p+195,   0x1.b4b434p-2, INEXACT)
T(RN,    0x1.111b573eaadeap+7,  0x1.00df8f0589359p+197,  -0x1.a893c2p-2, INEXACT)
T(RN,    0x1.1286594af498ep+7,  0x1.04fa570a9c8cbp+198,   0x1.240cecp-4, INEXACT)
T(RN,    0x1.13f15b573e532p+7,  0x1.0925e9736786cp+199,   0x1.3a259ep-3, INEXACT)
T(RN,    0x1.155c5d63880d6p+7,  0x1.0d628aef2a8d9p+200,  -0x1.f57ae8p-2, INEXACT)
T(RN,    0x1.16c75f6fd1c7ap+7,  0x1.11b081461d275p+201,  -0x1.1590a4p-3, INEXACT)
T(RN,    0x1.1832617c1b81ep+7,  0x1.1610135deb4bap+202,  -0x1.48c38ap-4, INEXACT)
T(RN,    0x1.199d6388653c2p+7,  0x1.1a81893e4516cp+203,  -0x1.d756dcp-3, INEXACT)
T(RN,    0x1.1b086594aef66p+7,  0x1.1f052c1581251p+204,   -0x1.f4be3p-3, INEXACT)
T(RN,    0x1.1c7367a0f8b0ap+7,  0x1.239b463d51e39p+205,  -0x1.d8aebcp-2, INEXACT)
T(RN,    0x1.1dde69ad426aep+7,  0x1.2844233f8e231p+206,  -0x1.688e3ep-2, INEXACT)
T(RN,    0x1.1f496bb98c252p+7,  0x1.2d000fdb0d3c8p+207,  -0x1.234a2cp-4, INEXACT)
T(RN,    0x1.20b46dc5d5df6p+7,  0x1.31cf5a089716cp+208,     0x1.6b1bp-3, INEXACT)
T(RN,    0x1.221f6fd21f99ap+7,  0x1.36b250ffe85f1p+209,   -0x1.b9169p-3, INEXACT)
T(RN,    0x1.238a71de6953ep+7,   0x1.3ba9453ccb47p+210,    0x1.af4d6p-2, INEXACT)
T(RN,    0x1.24f573eab30e2p+7,  0x1.40b48884451b1p+211,  -0x1.580e4ap-2, INEXACT)
T(RN,    0x1.266075f6fcc86p+7,  0x1.45d46de9d908dp+212,   0x1.b8cd8ap-7, INEXACT)
T(RN,    0x1.27cb78034682ap+7,  0x1.4b0949d4e0691p+213,   -0x1.f5f0bp-5, INEXACT)
T(RN,    0x1.29367a0f903cep+7,  0x1.50537205f8e84p+214,   0x1.c1977ap-2, INEXACT)
T(RN,    0x1.2aa17c1bd9f72p+7,  0x1.55b33d9c88e4cp+215,   0x1.9cfebcp-4, INEXACT)
T(RN,    0x1.2c0c7e2823b16p+7,  0x1.5b29051c5a5f5p+216,  -0x1.e258f6p-3, INEXACT)
T(RN,    0x1.2d7780346d6bap+7,  0x1.60b522734cd8ep+217,  -0x1.44bb98p-2, INEXACT)
T(RN,    0x1.2ee28240b725ep+7,  0x1.6657f0ff1e7c4p+218,   0x1.cced6cp-2, INEXACT)
T(RN,    0x1.304d844d00e02p+7,  0x1.6c11cd934cf28p+219, -0x1.92de58p-11, INEXACT)
T(RN,    0x1.31b886594a9a6p+7,  0x1.71e3167f0e43ap+220,  -0x1.95a176p-2, INEXACT)
T(RN,    0x1.332388659454ap+7,  0x1.77cc2b936224cp+221,   0x1.10d0fap-4, INEXACT)
T(RN,    0x1.348e8a71de0eep+7,  0x1.7dcd6e293c188p+222,   0x1.0572a6p-3, INEXACT)
T(RN,    0x1.35f98c7e27c92p+7,  0x1.83e74127c6c74p+223,  -0x1.afa70ep-2, INEXACT)
T(RN,    0x1.37648e8a71836p+7,  0x1.8a1a090ac0f5fp+224,  -0x1.94013ap-2, INEXACT)
T(RN,    0x1.38cf9096bb3dap+7,  0x1.90662be8f4843p+225,  -0x1.eec472p-2, INEXACT)
T(RN,    0x1.3a3a92a304f7ep+7,  0x1.96cc117ac7dcep+226,   0x1.adfa92p-3, INEXACT)
T(RN,    0x1.3ba594af4eb22p+7,  0x1.9d4c2320ea446p+227,  -0x1.f0b4bcp-2, INEXACT)
T(RN,    0x1.3d1096bb986c6p+7,  0x1.a3e6cbeb1b73bp+228,   -0x1.bc3a9p-4, INEXACT)
T(RN,    0x1.3e7b98c7e226ap+7,  0x1.aa9c789f0eee5p+229,  -0x1.241ab6p-3, INEXACT)
T(RN,    0x1.3fe69ad42be0ep+7,  0x1.b16d97bf6b864p+230,  -0x1.83fecep-6, INEXACT)
T(RN,    0x1.41519ce0759b2p+7,  0x1.b85a9992e77ffp+231,   0x1.da63b4p-3, INEXACT)
T(RN,    0x1.42bc9eecbf556p+7,  0x1.bf63f02b81cbfp+232,   0x1.1d584ap-3, INEXACT)
T(RN,    0x1.4427a0f9090fap+7,  0x1.c68a0f6dd8cd4p+233,    0x1.31346p-6, INEXACT)
T(RN,    0x1.4592a30552c9ep+7,  0x1.cdcd6d189f24fp+234,   0x1.ac8c96p-2, INEXACT)
T(RN,    0x1.46fda5119c842p+7,  0x1.d52e80cc2efdep+235,  -0x1.a2a7f6p-3, INEXACT)
T(RN,    0x1.4868a71de63e6p+7,   0x1.dcadc4123c56p+236,   0x1.214caep-3, INEXACT)
T(RN,    0x1.49d3a92a2ff8ap+7,  0x1.e44bb265a6c29p+237,   0x1.6d598ep-2, INEXACT)
T(RN,    0x1.4b3eab3679b2ep+7,  0x1.ec08c93a6b319p+238,  -0x1.df7d02p-3, INEXACT)
T(RN,    0x1.4ca9ad42c36d2p+7,  0x1.f3e58805b62a8p+239,   0x1.d2cfd4p-3, INEXACT)
T(RN,    0x1.4e14af4f0d276p+7,  0x1.fbe270461712fp+240,  -0x1.1ad938p-3, INEXACT)
T(RN,    0x1.4f7fb15b56e1ap+7,  0x1.020002c5ea7fap+242,  -0x1.319a04p-2, INEXACT)
T(RN,    0x1.50eab367a09bep+7,  0x1.061f66c0b2cbcp+243,   0x1.5effd4p-2, INEXACT)
T(RN,    0x1.5255b573ea562p+7,   0x1.0a4fa7fa034ep+244,  -0x1.5dbe78p-3, INEXACT)
T(RN,    0x1.53c0b78034106p+7,  0x1.0e910b6e3d4c7p+245,   0x1.68e24ep-2, INEXACT)
T(RN,    0x1.552bb98c7dcaap+7,  0x1.12e3d733f4aaap+246,   -0x1.79b91p-4, INEXACT)
T(RN,    0x1.5696bb98c784ep+7,  0x1.17485280724a2p+247,   0x1.876ddap-3, INEXACT)
T(RN,    0x1.5801bda5113f2p+7,  0x1.1bbec5ac48dc4p+248,  -0x1.a8b4e4p-9, INEXACT)
T(RN,    0x1.596cbfb15af96p+7,  0x1.20477a37fc722p+249,  -0x1.6ea554p-3, INEXACT)
T(RN,    0x1.5ad7c1bda4b3ap+7,  0x1.24e2bad0bd16ap+250,   0x1.55cd78p-4, INEXACT)
T(RN,    0x1.5c42c3c9ee6dep+7,  0x1.2990d35534c08p+251,  -0x1.c47bfep-3, INEXACT)
T(RN,    0x1.5dadc5d638282p+7,  0x1.2e5210da68ec2p+252,   0x1.d6b944p-2, INEXACT)
T(RN,    0x1.5f18c7e281e26p+7,  0x1.3326c1b0b02c5p+253,   0x1.b70896p-3, INEXACT)
T(RN,    0x1.6083c9eecb9cap+7,  0x1.380f3568bc054p+254,  -0x1.e81a2ap-3, INEXACT)
T(RN,    0x1.61eecbfb1556ep+7,  0x1.3d0bbcd8b7634p+255,  -0x1.d5f522p-4, INEXACT)
T(RN,    0x1.6359ce075f112p+7,  0x1.421caa217a024p+256,   0x1.d11612p-3, INEXACT)
T(RN,    0x1.64c4d013a8cb6p+7,  0x1.474250b3d11bcp+257,  -0x1.a6e28ep-4, INEXACT)
T(RN,    0x1.662fd21ff285ap+7,  0x1.4c7d0555ddb24p+258,   0x1.d2ceb8p-2, INEXACT)
T(RN,    0x1.679ad42c3c3fep+7,  0x1.51cd1e2888d1ep+259,  -0x1.a7fe28p-2, INEXACT)
T(RN,    0x1.6905d63885fa2p+7,  0x1.5732f2ad0e219p+260,   0x1.24c6fap-3, INEXACT)
T(RN,    0x1.6a70d844cfb46p+7,  0x1.5caedbca9d1dfp+261,   0x1.56d506p-2, INEXACT)
T(RN,    0x1.6bdbda51196eap+7,  0x1.624133d4115cdp+262,   0x1.b26bb4p-2, INEXACT)
T(RN,    0x1.6d46dc5d6328ep+7,  0x1.67ea568dc235ep+263,  -0x1.62ff74p-2, INEXACT)
T(RN,    0x1.6eb1de69ace32p+7,  0x1.6daaa1336a315p+264, -0x1.74ca0cp-12, INEXACT)
T(RN,    0x1.701ce075f69d6p+7,  0x1.7382727e269c9p+265,  -0x1.85fb8cp-4, INEXACT)
T(RN,    0x1.7187e2824057ap+7,  0x1.79722aaa8fa96p+266,    0x1.03e3ep-2, INEXACT)
T(RN,    0x1.72f2e48e8a11ep+7,  0x1.7f7a2b7ee97a2p+267,  -0x1.7ef29cp-2, INEXACT)
T(RN,    0x1.745de69ad3cc2p+7,  0x1.859ad8516e82bp+268,   0x1.678576p-3, INEXACT)
T(RN,    0x1.75c8e8a71d866p+7,   0x1.8bd4960eb3a4p+269,   0x1.b547e6p-2, INEXACT)
T(RN,    0x1.7733eab36740ap+7,  0x1.9227cb40266d2p+270,   -0x1.b9f5fp-3, INEXACT)
T(RN,    0x1.789eecbfb0faep+7,  0x1.9894e012a5ebdp+271,  -0x1.74f7aep-2, INEXACT)
T(RN,    0x1.7a09eecbfab52p+7,  0x1.9f1c3e5d36792p+272,   -0x1.97c45p-2, INEXACT)
T(RN,    0x1.7b74f0d8446f6p+7,  0x1.a5be51a7d0f13p+273,  -0x1.439b42p-2, INEXACT)
T(RN,    0x1.7cdff2e48e29ap+7,  0x1.ac7b87324dc5bp+274,  -0x1.1c8926p-3, INEXACT)
T(RN,    0x1.7e4af4f0d7e3ep+7,  0x1.b3544dfb6c5d4p+275,   -0x1.0d02ep-8, INEXACT)
T(RN,    0x1.7fb5f6fd219e2p+7,  0x1.ba4916c7f7337p+276,  -0x1.afda4ep-3, INEXACT)
T(RN,    0x1.8120f9096b586p+7,  0x1.c15a542a052f1p+277,   -0x1.54c6fp-4, INEXACT)
T(RN,    0x1.828bfb15b512ap+7,  0x1.c8887a8858a61p+278,   0x1.ac40ccp-2, INEXACT)
T(RN,    0x1.83f6fd21feccep+7,  0x1.cfd40025dc889p+279,  -0x1.334bc4p-3, INEXACT)
T(RN,    0x1.8561ff2e48872p+7,  0x1.d73d5d29402ecp+280,  -0x1.457316p-2, INEXACT)
T(RN,    0x1.86cd013a92416p+7,   0x1.dec50ba4b246p+281,  -0x1.f1d79ep-4, INEXACT)
T(RN,    0x1.88380346dbfbap+7,  0x1.e66b879dbb5d7p+282,  -0x1.c175d4p-2, INEXACT)
T(RN,    0x1.89a3055325b5ep+7,  0x1.ee314f1538932p+283,   0x1.cdff22p-4, INEXACT)
T(RN,    0x1.8b0e075f6f702p+7,  0x1.f616e20f76e4ap+284,  -0x1.5799a6p-8, INEXACT)
T(RN,    0x1.8c79096bb92a6p+7,  0x1.fe1cc29c6fa9ap+285,  -0x1.42aa7ap-5, INEXACT)
T(RN,    0x1.8de40b7802e4ap+7,  0x1.0321ba70135f9p+287,   0x1.aeb4c2p-4, INEXACT)
T(RN,    0x1.8f4f0d844c9eep+7,  0x1.0745bf8d9576dp+288,  -0x1.4f5534p-2, INEXACT)
T(RN,    0x1.90ba0f9096592p+7,  0x1.0b7ab4d99c8b5p+289,  -0x1.01584cp-3, INEXACT)
T(RN,    0x1.9225119ce0136p+7,  0x1.0fc0df9e015b4p+290,   0x1.c55b7ep-4, INEXACT)
T(RN,    0x1.939013a929cdap+7,  0x1.141886400c266p+291,  -0x1.5c008ap-2, INEXACT)
T(RN,    0x1.94fb15b57387ep+7,  0x1.1881f044fc1e7p+292,  -0x1.71d1ccp-5, INEXACT)
T(RN,    0x1.966617c1bd422p+7,  0x1.1cfd6656a15e1p+293,  -0x1.ef484cp-5, INEXACT)
T(RN,    0x1.97d119ce06fc6p+7,  0x1.218b324809b2dp+294,  -0x1.3ac408p-4, INEXACT)
T(RN,    0x1.993c1bda50b6ap+7,  0x1.262b9f1a40869p+295,  -0x1.72c2fap-5, INEXACT)
T(RN,    0x1.9aa71de69a70ep+7,  0x1.2adef9012236ep+296,   0x1.1e80e2p-4, INEXACT)
T(RN,    0x1.9c121ff2e42b2p+7,  0x1.2fa58d684329bp+297,  -0x1.f7f59ep-3, INEXACT)
T(RN,    0x1.9d7d21ff2de56p+7,  0x1.347faaf7eaf04p+298,  -0x1.69e0ccp-2, INEXACT)
T(RN,    0x1.9ee8240b779fap+7,   0x1.396da19a23cap+299,  -0x1.0713d4p-3, INEXACT)
T(RN,    0x1.a0532617c159ep+7,  0x1.3e6fc27fdedb1p+300,   0x1.94aadap-2, INEXACT)
T(RN,    0x1.a1be28240b142p+7,  0x1.438660262d6adp+301,  -0x1.f22fbep-2, INEXACT)
T(RN,    0x1.a3292a3054ce6p+7,  0x1.48b1ce5b8f812p+302,  -0x1.64832ap-4, INEXACT)
T(RN,    0x1.a4942c3c9e88ap+7,  0x1.4df2624558385p+303,    -0x1.f24fp-3, INEXACT)
T(RN,    0x1.a5ff2e48e842ep+7,  0x1.53487265281e8p+304,  -0x1.9f4098p-4, INEXACT)
T(RN,    0x1.a76a305531fd2p+7,  0x1.58b4569e7dfefp+305,  -0x1.808412p-2, INEXACT)
T(RN,    0x1.a8d532617bb76p+7,  0x1.5e36683c5e702p+306,   0x1.004464p-2, INEXACT)
T(RN,    0x1.aa40346dc571ap+7,  0x1.63cf01f71282ep+307,   0x1.e43278p-2, INEXACT)
T(RN,    0x1.abab367a0f2bep+7,  0x1.697e7ff9fdf1fp+308,  -0x1.c525fap-2, INEXACT)
T(RN,    0x1.ad16388658e62p+7,  0x1.6f453fe98d31dp+309,    0x1.04a76p-2, INEXACT)
T(RN,    0x1.ae813a92a2a06p+7,  0x1.7523a0e93bc1bp+310,  -0x1.e7fe48p-3, INEXACT)
T(RN,    0x1.afec3c9eec5aap+7,  0x1.7b1a03a1b322bp+311,   0x1.381406p-4, INEXACT)
T(RN,    0x1.b1573eab3614ep+7,  0x1.8128ca4702d7ep+312,  -0x1.25eb5ap-2, INEXACT)
T(RN,    0x1.b2c240b77fcf2p+7,  0x1.8750589ef1d78p+313,  -0x1.3fd3f2p-7, INEXACT)
T(RN,    0x1.b42d42c3c9896p+7,  0x1.8d91140769d3fp+314,   -0x1.a96d1p-4, INEXACT)
T(RN,    0x1.b59844d01343ap+7,  0x1.93eb637cfcc75p+315,  -0x1.b75db6p-5, INEXACT)
T(RN,    0x1.b70346dc5cfdep+7,  0x1.9a5fafa1852c5p+316,   0x1.a5c2f8p-2, INEXACT)
T(RN,    0x1.b86e48e8a6b82p+7,  0x1.a0ee62c2e151bp+317,  -0x1.549a2ap-3, INEXACT)
T(RN,    0x1.b9d94af4f0726p+7,  0x1.a797e8e1ca37bp+318,  -0x1.455812p-3, INEXACT)
T(RN,    0x1.bb444d013a2cap+7,  0x1.ae5cafb8c6671p+319,    -0x1.d325p-5, INEXACT)
T(RN,    0x1.bcaf4f0d83e6ep+7,  0x1.b53d26c339353p+320,   0x1.49fc7ep-3, INEXACT)
T(RN,    0x1.be1a5119cda12p+7,  0x1.bc39bf448ee8ep+321,   0x1.df5ceap-4, INEXACT)
T(RN,    0x1.bf855326175b6p+7,  0x1.c352ec4f86366p+322,   0x1.cfdb06p-2, INEXACT)
T(RN,    0x1.c0f055326115ap+7,  0x1.ca8922cd978a3p+323,   0x1.12ee28p-2, INEXACT)
T(RN,    0x1.c25b573eaacfep+7,  0x1.d1dcd9867a9d3p+324,  -0x1.bbd34ep-2, INEXACT)
T(RN,    0x1.c3c6594af48a2p+7,  0x1.d94e8927cacd8p+325,  -0x1.e1a41ap-2, INEXACT)
T(RN,    0x1.c5315b573e446p+7,  0x1.e0deac4ccab9fp+326,  -0x1.d56f04p-3, INEXACT)
T(RN,    0x1.c69c5d6387feap+7,  0x1.e88dbf8647a05p+327,  -0x1.e4641ap-2, INEXACT)
T(RN,    0x1.c8075f6fd1b8ep+7,  0x1.f05c41629d006p+328,   0x1.10ba96p-4, INEXACT)
T(RN,    0x1.c972617c1b732p+7,  0x1.f84ab275d906ep+329,   0x1.786576p-2, INEXACT)
T(RN,    0x1.cadd6388652d6p+7,  0x1.002ccab10123ep+331,   0x1.802b7ep-3, INEXACT)
T(RN,    0x1.cc486594aee7ap+7,  0x1.0444b76fbfa78p+332,   0x1.b97882p-2, INEXACT)
T(RN,    0x1.cdb367a0f8a1ep+7,  0x1.086d62e2d0495p+333,  -0x1.d68cc6p-2, INEXACT)
T(RN,    0x1.cf1e69ad425c2p+7,  0x1.0ca71189a6a9cp+334,  0x1.c0edbcp-10, INEXACT)
T(RN,    0x1.d0896bb98c166p+7,  0x1.10f208fbe9fcbp+335,  -0x1.b8b584p-9, INEXACT)
T(RN,    0x1.d1f46dc5d5d0ap+7,  0x1.154e8fedef3f6p+336,   0x1.bfc832p-4, INEXACT)
T(RN,    0x1.d35f6fd21f8aep+7,  0x1.19bcee3545be8p+337,   0x1.7a18cp-10, INEXACT)
T(RN,    0x1.d4ca71de69452p+7,  0x1.1e3d6ccd56384p+338,   0x1.33f8bap-2, INEXACT)
T(RN,    0x1.d63573eab2ff6p+7,  0x1.22d055dc14e5ep+339,   -0x1.aa4c9p-3, INEXACT)
T(RN,    0x1.d7a075f6fcb9ap+7,  0x1.2775f4b6c6badp+340,  -0x1.d9e5a2p-2, INEXACT)
T(RN,    0x1.d90b78034673ep+7,  0x1.2c2e95e6da271p+341,  -0x1.b96a98p-3, INEXACT)
T(RN,    0x1.da767a0f902e2p+7,  0x1.30fa872ed3ad5p+342,   0x1.b5cdbap-2, INEXACT)
T(RN,    0x1.dbe17c1bd9e86p+7,  0x1.35da178f4e9dap+343,   0x1.85a99ep-2, INEXACT)
T(RN,    0x1.dd4c7e2823a2ap+7,  0x1.3acd974c12476p+344,    0x1.f361fp-2, INEXACT)
T(RN,    0x1.deb780346d5cep+7,  0x1.3fd557f13bf58p+345,   -0x1.e4c92p-2, INEXACT)
T(RN,    0x1.e0228240b7172p+7,  0x1.44f1ac587e0b3p+346,   0x1.d550f4p-2, INEXACT)
T(RN,    0x1.e18d844d00d16p+7,  0x1.4a22e8ae7495cp+347,   0x1.55573cp-2, INEXACT)
T(RN,    0x1.e2f886594a8bap+7,  0x1.4f6962780fadcp+348,   0x1.5a2a64p-3, INEXACT)
T(RN,    0x1.e46388659445ep+7,  0x1.54c5709813fe6p+349,  -0x1.528156p-2, INEXACT)
T(RN,    0x1.e5ce8a71de002p+7,  0x1.5a376b54b1cf2p+350,  -0x1.2c7796p-3, INEXACT)
T(RN,    0x1.e7398c7e27ba6p+7,  0x1.5fbfac5d32eb1p+351,   0x1.f36a8ap-2, INEXACT)
T(RN,    0x1.e8a48e8a7174ap+7,  0x1.655e8ecfbfc3ap+352,  -0x1.4181acp-2, INEXACT)
T(RN,    0x1.ea0f9096bb2eep+7,  0x1.6b146f3f3c2e5p+353,    0x1.cfeddp-4, INEXACT)
T(RN,    0x1.eb7a92a304e92p+7,  0x1.70e1abb93c1c7p+354,  -0x1.be9bdep-5, INEXACT)
T(RN,    0x1.ece594af4ea36p+7,   0x1.76c6a3cc10b1p+355,    0x1.67212p-5, INEXACT)
T(RN,    0x1.ee5096bb985dap+7,  0x1.7cc3b88cee16ap+356,  -0x1.1a5d06p-2, INEXACT)
T(RN,    0x1.efbb98c7e217ep+7,   0x1.82d94c9e2a7cp+357,   0x1.78f4e6p-6, INEXACT)
T(RN,    0x1.f1269ad42bd22p+7,  0x1.8907c435969cdp+358,   0x1.e206cep-2, INEXACT)
T(RN,    0x1.f2919ce0758c6p+7,  0x1.8f4f8522f0406p+359,   0x1.5f7b66p-4, INEXACT)
T(RN,    0x1.f3fc9eecbf46ap+7,  0x1.95b0f6d66f17fp+360,  -0x1.b1a8cep-2, INEXACT)
T(RN,    0x1.f567a0f90900ep+7,  0x1.9c2c82676c684p+361,  -0x1.a18ad4p-2, INEXACT)
T(RN,    0x1.f6d2a30552bb2p+7,  0x1.a2c2929b25ec5p+362,   0x1.20f63ap-2, INEXACT)
T(RN,    0x1.f83da5119c756p+7,  0x1.a97393eb9c609p+363,   0x1.952ec6p-2, INEXACT)
T(RN,    0x1.f9a8a71de62fap+7,  0x1.b03ff48e8e27ep+364,  -0x1.3f38e2p-2, INEXACT)
T(RN,    0x1.fb13a92a2fe9ep+7,  0x1.b728247c8e7d1p+365,   0x1.e208a8p-2, INEXACT)
T(RN,    0x1.fc7eab3679a42p+7,  0x1.be2c957839a52p+366,  -0x1.fe4112p-3, INEXACT)
T(RN,    0x1.fde9ad42c35e6p+7,  0x1.c54dbb15869aap+367,  -0x1.c3b84ap-2, INEXACT)
T(RN,    0x1.ff54af4f0d18ap+7,  0x1.cc8c0ac136a88p+368,  -0x1.251bb8p-2, INEXACT)
T(RN,    0x1.003b8bac70d6dp+8,  0x1.960beaf4dd4acp+369,   0x1.735512p-2, INEXACT)
T(RN,    0x1.00f10cb295b3fp+8,  0x1.9c88ea9546a4bp+370,   0x1.630414p-2, INEXACT)
T(RN,    0x1.01a68db8ba911p+8,  0x1.a32074ca650cdp+371,   0x1.412006p-2, INEXACT)
T(RN,    0x1.025c0ebedf6e3p+8,  0x1.a9d2f6268b1e9p+372,  -0x1.0a016ap-4, INEXACT)
T(RN,    0x1.03118fc5044b5p+8,  0x1.b0a0dcf82c97cp+373,   0x1.e55ecap-4, INEXACT)
T(RN,    0x1.03c710cb29287p+8,  0x1.b78a9950f720cp+374,   0x1.119e68p-2, INEXACT)
T(RN,    0x1.047c91d14e059p+8,  0x1.be909d0d081cdp+375,   0x1.690136p-4, INEXACT)
T(RN,    0x1.053212d772e2bp+8,  0x1.c5b35bda3ff8ep+376,  -0x1.fa5324p-4, INEXACT)
T(RN,    0x1.05e793dd97bfdp+8,  0x1.ccf34b3fb3719p+377,  -0x1.3ff42ep-3, INEXACT)
T(RN,    0x1.069d14e3bc9cfp+8,  0x1.d450e2a53b4b1p+378,   0x1.b2e28ep-3, INEXACT)
T(RN,    0x1.075295e9e17a1p+8,  0x1.dbcc9b5b22f75p+379,    0x1.d0fa9p-2, INEXACT)
T(RN,    0x1.080816f006573p+8,  0x1.e366f0a1f6a93p+380,   0x1.bdc95ep-3, INEXACT)
T(RN,    0x1.08bd97f62b345p+8,  0x1.eb205fb271552p+381,   0x1.12de5cp-3, INEXACT)
T(RN,    0x1.097318fc50117p+8,  0x1.f2f967c58b21ap+382,  -0x1.611eecp-3, INEXACT)
T(RN,    0x1.0a289a0274ee9p+8,  0x1.faf28a1ca8cccp+383,   0x1.060afcp-4, INEXACT)
T(RN,    0x1.0ade1b0899cbbp+8,  0x1.01862504f6467p+385,    0x1.9e5b6p-6, INEXACT)
T(RN,    0x1.0b939c0ebea8dp+8,  0x1.05a3967c547b2p+386,  -0x1.25d2dep-2, INEXACT)
T(RN,    0x1.0c491d14e385fp+8,  0x1.09d1dd3afb382p+387,    0x1.e011fp-3, INEXACT)
T(RN,    0x1.0cfe9e1b08631p+8,  0x1.0e113e1cb5e38p+388,  -0x1.0f790ap-2, INEXACT)
T(RN,    0x1.0db41f212d403p+8,  0x1.1261ff16fd358p+389,  -0x1.d9d672p-2, INEXACT)
T(RN,    0x1.0e69a027521d5p+8,  0x1.16c4673d77771p+390,   0x1.580252p-2, INEXACT)
T(RN,    0x1.0f1f212d76fa7p+8,  0x1.1b38bec68b29ep+391,   0x1.32eecap-2, INEXACT)
T(RN,    0x1.0fd4a2339bd79p+8,  0x1.1fbf4f100465ap+392,   0x1.dbade2p-7, INEXACT)
T(RN,    0x1.108a2339c0b4bp+8,  0x1.245862a3cd361p+393,  -0x1.e0d20ap-5, INEXACT)
T(RN,    0x1.113fa43fe591dp+8,  0x1.2904453cb9483p+394,  -0x1.fe2fc8p-2, INEXACT)
T(RN,    0x1.11f525460a6efp+8,  0x1.2dc343cb6535bp+395,   0x1.b5f70cp-6, INEXACT)
T(RN,    0x1.12aaa64c2f4c1p+8,  0x1.3295ac7b29be2p+396,  -0x1.8fda46p-2, INEXACT)
T(RN,    0x1.1360275254293p+8,  0x1.377bceb72340bp+397,   0x1.8ec038p-2, INEXACT)
T(RN,    0x1.1415a85879065p+8,  0x1.3c75fb2f4dc79p+398,  -0x1.bab7d8p-5, INEXACT)
T(RN,    0x1.14cb295e9de37p+8,  0x1.418483ddb5fb3p+399,    0x1.3b197p-2, INEXACT)
T(RN,    0x1.1580aa64c2c09p+8,  0x1.46a7bc0bbf50bp+400,  -0x1.bfc8a8p-2, INEXACT)
T(RN,    0x1.16362b6ae79dbp+8,  0x1.4bdff8577fcc8p+401,   0x1.96f964p-3, INEXACT)
T(RN,    0x1.16ebac710c7adp+8,  0x1.512d8eb931af5p+402,   0x1.7935fap-4, INEXACT)
T(RN,    0x1.17a12d773157fp+8,  0x1.5690d688bb691p+403,  -0x1.ffaffcp-2, INEXACT)
T(RN,    0x1.1856ae7d56351p+8,  0x1.5c0a28834e2bap+404,   0x1.f48662p-2, INEXACT)
T(RN,    0x1.190c2f837b123p+8,  0x1.6199ded11b79dp+405,  -0x1.1619eep-4, INEXACT)
T(RN,    0x1.19c1b0899fef5p+8,  0x1.6740550b22123p+406,   -0x1.bc02ep-2, INEXACT)
T(RN,    0x1.1a77318fc4cc7p+8,  0x1.6cfde84112932p+407,  -0x1.e1e39ap-2, INEXACT)
T(RN,    0x1.1b2cb295e9a99p+8,  0x1.72d2f6ff4c3acp+408,   0x1.98675cp-2, INEXACT)
T(RN,    0x1.1be2339c0e86bp+8,  0x1.78bfe154f2248p+409,  -0x1.34a0fep-4, INEXACT)
T(RN,    0x1.1c97b4a23363dp+8,  0x1.7ec508da19698p+410,   0x1.c17842p-2, INEXACT)
T(RN,    0x1.1d4d35a85840fp+8,  0x1.84e2d0b61087ep+411,   0x1.3f6336p-2, INEXACT)
T(RN,    0x1.1e02b6ae7d1e1p+8,  0x1.8b199da5c07a5p+412,  -0x1.9c0f1cp-3, INEXACT)
T(RN,    0x1.1eb837b4a1fb3p+8,  0x1.9169d60227e7ap+413,    0x1.75433p-3, INEXACT)
T(RN,    0x1.1f6db8bac6d85p+8,  0x1.97d3e1c6f0d55p+414,   0x1.0252d2p-2, INEXACT)
T(RN,    0x1.202339c0ebb57p+8,  0x1.9e582a99214a3p+415,  -0x1.017afap-3, INEXACT)
T(RN,    0x1.20d8bac710929p+8,  0x1.a4f71bcde74e9p+416,  -0x1.53f1bcp-2, INEXACT)
T(RN,    0x1.218e3bcd356fbp+8,  0x1.abb1227180ba2p+417,   -0x1.6773ap-2, INEXACT)
T(RN,    0x1.2243bcd35a4cdp+8,  0x1.b286ad4e3f417p+418,   0x1.0279a8p-4, INEXACT)
T(RN,    0x1.22f93dd97f29fp+8,  0x1.b9782cf3a9365p+419,  -0x1.bae172p-2, INEXACT)
T(RN,    0x1.23aebedfa4071p+8,  0x1.c08613bdb7711p+420,   0x1.76f98ep-2, INEXACT)
T(RN,    0x1.24643fe5c8e43p+8,  0x1.c7b0d5dc30d8ap+421,  -0x1.ab9c2ap-4, INEXACT)
T(RN,    0x1.2519c0ebedc15p+8,  0x1.cef8e95a2404bp+422,   0x1.46652ep-3, INEXACT)
T(RN,    0x1.25cf41f2129e7p+8,  0x1.d65ec6257f72cp+423,  -0x1.5beb0ap-3, INEXACT)
T(RN,    0x1.2684c2f8377b9p+8,  0x1.dde2e616c8cd2p+424,  -0x1.ed8b94p-3, INEXACT)
T(RN,    0x1.273a43fe5c58bp+8,  0x1.e585c4f8f3c19p+425,  -0x1.c8f598p-2, INEXACT)
T(RN,    0x1.27efc5048135dp+8,  0x1.ed47e09158e99p+426,   0x1.941db2p-2, INEXACT)
T(RN,    0x1.28a5460aa612fp+8,  0x1.f529b8a7cd46bp+427,   0x1.fc7758p-3, INEXACT)
T(RN,    0x1.295ac710caf01p+8,  0x1.fd2bcf0edad95p+428,   0x1.9bdd12p-4, INEXACT)
T(RN,    0x1.2a104816efcd3p+8,  0x1.02a753d60d6bfp+430,  -0x1.f0d65ep-4, INEXACT)
T(RN,    0x1.2ac5c91d14aa5p+8,  0x1.06c964405908ap+431,   0x1.25694cp-4, INEXACT)
T(RN,    0x1.2b7b4a2339877p+8,  0x1.0afc5cd8f802ap+432,  -0x1.2613d2p-4, INEXACT)
T(RN,    0x1.2c30cb295e649p+8,  0x1.0f4082c908a11p+433,   0x1.bddc4ep-9, INEXACT)
T(RN,    0x1.2ce64c2f8341bp+8,  0x1.13961c5492cb2p+434,   0x1.dcbcbcp-6, INEXACT)
T(RN,    0x1.2d9bcd35a81edp+8,  0x1.17fd70df0d54cp+435,  -0x1.f42a52p-3, INEXACT)
T(RN,    0x1.2e514e3bccfbfp+8,  0x1.1c76c8eff5c97p+436,  -0x1.a6c696p-4, INEXACT)
T(RN,    0x1.2f06cf41f1d91p+8,  0x1.21026e377b00ap+437,  -0x1.6f70c6p-3, INEXACT)
T(RN,    0x1.2fbc504816b63p+8,   0x1.25a0ab933ac9p+438,   0x1.2f5b12p-2, INEXACT)
T(RN,    0x1.3071d14e3b935p+8,  0x1.2a51cd1312f82p+439,  -0x1.ac9d02p-5, INEXACT)
T(RN,    0x1.3127525460707p+8,  0x1.2f161ffe062eap+440,   0x1.be3d56p-4, INEXACT)
T(RN,    0x1.31dcd35a854d9p+8,  0x1.33edf2d734a07p+441,   0x1.f61378p-2, INEXACT)
T(RN,    0x1.32925460aa2abp+8,  0x1.38d99562e933fp+442,   0x1.d545b8p-2, INEXACT)
T(RN,    0x1.3347d566cf07dp+8,  0x1.3dd958abbb4acp+443,  -0x1.9fc834p-3, INEXACT)
T(RN,    0x1.33fd566cf3e4fp+8,  0x1.42ed8f07c588dp+444,   -0x1.cedadp-2, INEXACT)
T(RN,    0x1.34b2d77318c21p+8,  0x1.48168c1df1ef6p+445,  -0x1.5b1f5ap-4, INEXACT)
T(RN,    0x1.356858793d9f3p+8,  0x1.4d54a4eb5ba38p+446,   0x1.10dad6p-2, INEXACT)
T(RN,    0x1.361dd97f627c5p+8,  0x1.52a82fc8c6b8ap+447,  -0x1.6adba2p-5, INEXACT)
T(RN,    0x1.36d35a8587597p+8,  0x1.581184702e594p+448,   0x1.e1f37cp-6, INEXACT)
T(RN,    0x1.3788db8bac369p+8,  0x1.5d90fc0269a8ep+449,  -0x1.2dbf08p-3, INEXACT)
T(RN,    0x1.383e5c91d113bp+8,  0x1.6326f10ce7bcep+450,   0x1.334636p-2, INEXACT)
T(RN,    0x1.38f3dd97f5f0dp+8,  0x1.68d3bf8f8309fp+451,   0x1.8e3036p-2, INEXACT)
T(RN,    0x1.39a95e9e1acdfp+8,  0x1.6e97c5026ca6dp+452,   0x1.5c719cp-4, INEXACT)
T(RN,    0x1.3a5edfa43fab1p+8,  0x1.7473605c2fc55p+453,   0x1.ed7cdap-2, INEXACT)
T(RN,    0x1.3b1460aa64883p+8,  0x1.7a66f217cdc48p+454,  -0x1.8058bep-2, INEXACT)
T(RN,    0x1.3bc9e1b089655p+8,  0x1.8072dc3af341bp+455,  -0x1.0e3706p-4, INEXACT)
T(RN,    0x1.3c7f62b6ae427p+8,  0x1.8697825c468cdp+456,   0x1.cff146p-2, INEXACT)
T(RN,    0x1.3d34e3bcd31f9p+8,  0x1.8cd549a9cfe9bp+457,   0x1.f2d098p-9, INEXACT)
T(RN,    0x1.3dea64c2f7fcbp+8,  0x1.932c98ef7c06fp+458,  -0x1.b9a0f6p-3, INEXACT)
T(RN,    0x1.3e9fe5c91cd9dp+8,  0x1.999dd89db9158p+459,  -0x1.623cd4p-5, INEXACT)
T(RN,    0x1.3f5566cf41b6fp+8,  0x1.a02972d02eee4p+460,   0x1.7505bcp-2, INEXACT)
T(RN,    0x1.400ae7d566941p+8,  0x1.a6cfd35492b41p+461,  -0x1.542c8ap-2, INEXACT)
T(RN,    0x1.40c068db8b713p+8,  0x1.ad9167b196633p+462,  -0x1.a9ac6cp-4, INEXACT)
T(RN,    0x1.4175e9e1b04e5p+8,  0x1.b46e9f2df4bf2p+463,   -0x1.5dbe9p-2, INEXACT)
T(RN,    0x1.422b6ae7d52b7p+8,  0x1.bb67ead79a149p+464,   0x1.ffd54cp-5, INEXACT)
T(RN,    0x1.42e0ebedfa089p+8,  0x1.c27dbd8aea43dp+465,   -0x1.2ca18p-2, INEXACT)
T(RN,    0x1.43966cf41ee5bp+8,  0x1.c9b08bfa248cep+466,   -0x1.ee801p-6, INEXACT)
T(RN,    0x1.444bedfa43c2dp+8,  0x1.d100ccb4e5959p+467,   0x1.937298p-3, INEXACT)
T(RN,    0x1.45016f00689ffp+8,  0x1.d86ef82fc8267p+468,   0x1.0037acp-2, INEXACT)
T(RN,    0x1.45b6f0068d7d1p+8,  0x1.dffb88cc251b9p+469,   0x1.2d857ap-2, INEXACT)
T(RN,    0x1.466c710cb25a3p+8,  0x1.e7a6fadff308dp+470,   -0x1.c765fp-2, INEXACT)
T(RN,    0x1.4721f212d7375p+8,  0x1.ef71ccbdc613dp+471,   0x1.42f32ap-3, INEXACT)
T(RN,    0x1.47d77318fc147p+8,  0x1.f75c7ebcf0864p+472, -0x1.d0e28ap-11, INEXACT)
T(RN,    0x1.488cf41f20f19p+8,    0x1.ff679341c4ap+473,   -0x1.35215p-4, INEXACT)
T(RN,    0x1.4942752545cebp+8,  0x1.03c9c762fc17cp+475,   0x1.fe18aap-4, INEXACT)
T(RN,    0x1.49f7f62b6aabdp+8,  0x1.07f07bf0953dbp+476,  -0x1.8c2eccp-5, INEXACT)
T(RN,    0x1.4aad77318f88fp+8,  0x1.0c282ba8c684ep+477,  -0x1.b2c996p-2, INEXACT)
T(RN,    0x1.4b62f837b4661p+8,  0x1.10711c0257e9cp+478,  -0x1.f81582p-6, INEXACT)
T(RN,    0x1.4c18793dd9433p+8,  0x1.14cb939038ba1p+479,    0x1.e64fep-3, INEXACT)
T(RN,    0x1.4ccdfa43fe205p+8,  0x1.1937da0609f54p+480,    0x1.2d3abp-2, INEXACT)
T(RN,    0x1.4d837b4a22fd7p+8,  0x1.1db6383cbb3f8p+481,   0x1.8cf916p-2, INEXACT)
T(RN,    0x1.4e38fc5047da9p+8,  0x1.2246f8373ab3ap+482,  -0x1.8b8bbap-3, INEXACT)
T(RN,    0x1.4eee7d566cb7bp+8,  0x1.26ea652737e14p+483,    -0x1.46eep-2, INEXACT)
T(RN,    0x1.4fa3fe5c9194dp+8,  0x1.2ba0cb71fa452p+484,   0x1.7b7704p-5, INEXACT)
T(RN,    0x1.50597f62b671fp+8,  0x1.306a78b54b8bdp+485,   0x1.3d1368p-2, INEXACT)
T(RN,    0x1.510f0068db4f1p+8,  0x1.3547bbcc75ef8p+486,  -0x1.2dfb38p-3, INEXACT)
T(RN,    0x1.51c4816f002c3p+8,  0x1.3a38e4d557034p+487,  -0x1.447366p-3, INEXACT)
T(RN,    0x1.527a027525095p+8,  0x1.3f3e4535873eep+488,    0x1.11ad5p-2, INEXACT)
T(RN,    0x1.532f837b49e67p+8,  0x1.44582f9f96a0dp+489,  -0x1.f1410cp-4, INEXACT)
T(RN,    0x1.53e504816ec39p+8,  0x1.4986f8185ebc5p+490,  -0x1.c3d376p-6, INEXACT)
T(RN,    0x1.549a858793a0bp+8,  0x1.4ecaf3fc6a8adp+491,  -0x1.be0816p-5, INEXACT)
T(RN,    0x1.5550068db87ddp+8,  0x1.54247a05745a8p+492,    0x1.d04d3p-4, INEXACT)
T(RN,    0x1.56058793dd5afp+8,  0x1.5993e24ffa33cp+493,  -0x1.db082ap-2, INEXACT)
T(RN,    0x1.56bb089a02381p+8,  0x1.5f198660e9121p+494,   0x1.dfda3ep-2, INEXACT)
T(RN,    0x1.577089a027153p+8,  0x1.64b5c12b5f4cap+495,  -0x1.c9a298p-2, INEXACT)
T(RN,    0x1.58260aa64bf25p+8,  0x1.6a68ef16868f8p+496,   0x1.1ce8eep-8, INEXACT)
T(RN,    0x1.58db8bac70cf7p+8,   0x1.70336e0385c3p+497,  -0x1.ba9f5ep-3, INEXACT)
T(RN,    0x1.59910cb295ac9p+8,  0x1.76159d538b45fp+498,    0x1.eaba4p-4, INEXACT)
T(RN,    0x1.5a468db8ba89bp+8,  0x1.7c0fddedefdc1p+499,  -0x1.378102p-2, INEXACT)
T(RN,    0x1.5afc0ebedf66dp+8,  0x1.8222924672b76p+500,   0x1.9804e2p-2, INEXACT)
T(RN,    0x1.5bb18fc50443fp+8,  0x1.884e1e638f017p+501,  -0x1.4f0768p-2, INEXACT)
T(RN,    0x1.5c6710cb29211p+8,  0x1.8e92e7e4eb4efp+502,   0x1.21424ap-2, INEXACT)
T(RN,    0x1.5d1c91d14dfe3p+8,  0x1.94f15609e3652p+503,  -0x1.9b3348p-2, INEXACT)
T(RN,    0x1.5dd212d772db5p+8,  0x1.9b69d1b82cbf7p+504,   0x1.c4ed48p-2, INEXACT)
T(RN,    0x1.5e8793dd97b87p+8,    0x1.a1fcc582964p+505,  -0x1.6eb488p-6, INEXACT)
T(RN,    0x1.5f3d14e3bc959p+8,  0x1.a8aa9dafe37cep+506,   0x1.5f28c6p-3, INEXACT)
T(RN,    0x1.5ff295e9e172bp+8,  0x1.af73c841c4188p+507,  -0x1.1d500ep-4, INEXACT)
T(RN,    0x1.60a816f0064fdp+8,   0x1.b658b4fbe79ap+508,    0x1.20f5fp-3, INEXACT)
T(RN,    0x1.615d97f62b2cfp+8,  0x1.bd59d56b2e389p+509,  -0x1.f19656p-2, INEXACT)
T(RN,    0x1.621318fc500a1p+8,  0x1.c4779cecf7118p+510,   0x1.4a9b36p-2, INEXACT)
T(RN,    0x1.62c89a0274e73p+8,  0x1.cbb280b68c3fdp+511,  -0x1.27605cp-3, INEXACT)
T(RN,    0x1.637e1b0899c45p+8,  0x1.d30af7dcad518p+512,  -0x1.78fc36p-2, INEXACT)
T(RN,    0x1.64339c0ebea17p+8,  0x1.da817b5b3894dp+513,   0x1.6f4008p-3, INEXACT)
T(RN,    0x1.64e91d14e37e9p+8,  0x1.e216861cf3bcdp+514,   0x1.af31c4p-2, INEXACT)
T(RN,    0x1.659e9e1b085bbp+8,  0x1.e9ca9503745d6p+515,   0x1.cd2d5ep-2, INEXACT)
T(RN,    0x1.66541f212d38dp+8,  0x1.f19e26ef28c06p+516,  -0x1.301406p-2, INEXACT)
T(RN,    0x1.6709a0275215fp+8,   0x1.f991bcc78199p+517,   0x1.dce372p-3, INEXACT)
T(RN,    0x1.67bf212d76f31p+8,  0x1.00d2ecc19e8d6p+519,    0x1.ed01ep-2, INEXACT)
T(RN,    0x1.6874a2339bd03p+8,  0x1.04ed811869feep+520,  -0x1.2c031ep-2, INEXACT)
T(RN,    0x1.692a2339c0ad5p+8,  0x1.0918deff847d9p+521,   0x1.f3aaaep-3, INEXACT)
T(RN,    0x1.69dfa43fe58a7p+8,  0x1.0d554b22cda63p+522,  -0x1.31d20ep-2, INEXACT)
T(RN,    0x1.6a9525460a679p+8,  0x1.11a30b470e607p+523,   0x1.a94a82p-2, INEXACT)
T(RN,    0x1.6b4aa64c2f44bp+8,  0x1.1602664e75fb3p+524,  -0x1.56209ep-3, INEXACT)
T(RN,    0x1.6c0027525421dp+8,  0x1.1a73a43d29a69p+525,  -0x1.71a302p-3, INEXACT)
T(RN,    0x1.6cb5a85878fefp+8,  0x1.1ef70e3de694cp+526,    0x1.8e63bp-4, INEXACT)
T(RN,    0x1.6d6b295e9ddc1p+8,  0x1.238ceea6b70f6p+527,  -0x1.7244fcp-3, INEXACT)
T(RN,    0x1.6e20aa64c2b93p+8,  0x1.283590fdbace8p+528,  -0x1.d3e2a8p-3, INEXACT)
T(RN,    0x1.6ed62b6ae7965p+8,  0x1.2cf141fe02dfbp+529,  -0x1.fc7032p-4, INEXACT)
T(RN,    0x1.6f8bac710c737p+8,  0x1.31c04f9c816dap+530,  -0x1.e80ba8p-2, INEXACT)
T(RN,    0x1.70412d7731509p+8,  0x1.36a3090d0db99p+531,  -0x1.7fd9c4p-3, INEXACT)
T(RN,    0x1.70f6ae7d562dbp+8,  0x1.3b99bec77c98bp+532,  -0x1.aa81bap-6, INEXACT)
T(RN,    0x1.71ac2f837b0adp+8,  0x1.40a4c28ccdca2p+533,   0x1.2b2b7cp-3, INEXACT)
T(RN,    0x1.7261b0899fe7fp+8,  0x1.45c4676c6e7a3p+534,   0x1.ab58bep-3, INEXACT)
T(RN,    0x1.7317318fc4c51p+8,  0x1.4af901c99149dp+535,  -0x1.ae53ccp-2, INEXACT)
T(RN,    0x1.73ccb295e9a23p+8,  0x1.5042e7609c325p+536,  -0x1.106184p-2, INEXACT)
T(RN,    0x1.7482339c0e7f5p+8,  0x1.55a26f4cac9e4p+537,  -0x1.35ce32p-2, INEXACT)
T(RN,    0x1.7537b4a2335c7p+8,  0x1.5b17f20d32134p+538,  -0x1.68e198p-4, INEXACT)
T(RN,    0x1.75ed35a858399p+8,  0x1.60a3c98b9fc82p+539,  -0x1.767a3cp-2, INEXACT)
T(RN,    0x1.76a2b6ae7d16bp+8,  0x1.664651213585ep+540,   0x1.c12652p-2, INEXACT)
T(RN,    0x1.775837b4a1f3dp+8,  0x1.6bffe59ce031ep+541,   0x1.a53382p-2, INEXACT)
T(RN,    0x1.780db8bac6d0fp+8,  0x1.71d0e54932636p+542,    0x1.18054p-2, INEXACT)
T(RN,    0x1.78c339c0ebae1p+8,  0x1.77b9aff275655p+543,  -0x1.605f48p-4, INEXACT)
T(RN,    0x1.7978bac7108b3p+8,  0x1.7dbaa6ecd3094p+544,  -0x1.4c0696p-2, INEXACT)
T(RN,    0x1.7a2e3bcd35685p+8,  0x1.83d42d1a98b09p+545,   0x1.85f512p-3, INEXACT)
T(RN,    0x1.7ae3bcd35a457p+8,  0x1.8a06a6f293f2fp+546,  -0x1.94e24ap-2, INEXACT)
T(RN,    0x1.7b993dd97f229p+8,  0x1.90527a86894bbp+547,  -0x1.4f24b4p-2, INEXACT)
T(RN,    0x1.7c4ebedfa3ffbp+8,  0x1.96b80f89c5371p+548,   0x1.9a8094p-2, INEXACT)
T(RN,    0x1.7d043fe5c8dcdp+8,  0x1.9d37cf57c82ccp+549,   -0x1.2893ap-2, INEXACT)
T(RN,    0x1.7db9c0ebedb9fp+8,  0x1.a3d224fb0de59p+550,  -0x1.089626p-4, INEXACT)
T(RN,    0x1.7e6f41f212971p+8,  0x1.aa877d33f05aap+551,  -0x1.f9b57ep-4, INEXACT)
T(RN,    0x1.7f24c2f837743p+8,  0x1.b158467fa6f13p+552,  -0x1.a66d74p-2, INEXACT)
T(RN,    0x1.7fda43fe5c515p+8,  0x1.b844f11f62453p+553,   0x1.2e022ep-4, INEXACT)
T(RN,    0x1.808fc504812e7p+8,  0x1.bf4def1f8507cp+554,  -0x1.8614ccp-2, INEXACT)
T(RN,    0x1.8145460aa60b9p+8,  0x1.c673b45efa696p+555,  -0x1.e986a2p-2, INEXACT)
T(RN,    0x1.81fac710cae8bp+8,  0x1.cdb6b696aa877p+556,  -0x1.8c7d16p-2, INEXACT)
T(RN,    0x1.82b04816efc5dp+8,  0x1.d5176d610d58dp+557,   0x1.94209ep-6, INEXACT)
T(RN,    0x1.8365c91d14a2fp+8,  0x1.dc965241dc95dp+558,    0x1.31f1ep-2, INEXACT)
T(RN,    0x1.841b4a2339801p+8,  0x1.e433e0ade51a7p+559,   0x1.b5f162p-7, INEXACT)
T(RN,    0x1.84d0cb295e5d3p+8,  0x1.ebf09612f843ap+560,  -0x1.1d689ep-2, INEXACT)
T(RN,    0x1.85864c2f833a5p+8,  0x1.f3ccf1dffdca3p+561,   0x1.f85ceap-5, INEXACT)
T(RN,    0x1.863bcd35a8177p+8,  0x1.fbc9758d26a07p+562,   0x1.dadacap-2, INEXACT)
T(RN,    0x1.86f14e3bccf49p+8,  0x1.01f3525220acep+564,    0x1.c3bfbp-2, INEXACT)
T(RN,    0x1.87a6cf41f1d1bp+8,  0x1.0612826498527p+565,   0x1.e73056p-3, INEXACT)
T(RN,    0x1.885c504816aedp+8,  0x1.0a428ee142326p+566,  -0x1.dd76f6p-2, INEXACT)
T(RN,    0x1.8911d14e3b8bfp+8,  0x1.0e83bcc11afabp+567,   0x1.2ec02ap-2, INEXACT)
T(RN,    0x1.89c7525460691p+8,  0x1.12d652174415cp+568,   0x1.097ce2p-2, INEXACT)
T(RN,    0x1.8a7cd35a85463p+8,   0x1.173a961585d2p+569,   0x1.e95a8ep-3, INEXACT)
T(RN,    0x1.8b325460aa235p+8,  0x1.1bb0d110e3fa3p+570,   0x1.d22b02p-2, INEXACT)
T(RN,    0x1.8be7d566cf007p+8,  0x1.20394c86452a8p+571,  -0x1.7a1e98p-3, INEXACT)
T(RN,    0x1.8c9d566cf3dd9p+8,  0x1.24d4531f2d2f5p+572,   -0x1.a441bp-3, INEXACT)
T(RN,    0x1.8d52d77318babp+8,  0x1.298230b68abaap+573,  -0x1.cb2054p-6, INEXACT)
T(RN,    0x1.8e0858793d97dp+8,  0x1.2e43325d98c04p+574,   0x1.6fa356p-2, INEXACT)
T(RN,    0x1.8ebdd97f6274fp+8,  0x1.3317a660d3c88p+575,   0x1.c669c6p-2, INEXACT)
T(RN,    0x1.8f735a8587521p+8,  0x1.37ffdc4d038b6p+576,   0x1.3b9dfcp-2, INEXACT)
T(RN,    0x1.9028db8bac2f3p+8,   0x1.3cfc24f45927p+577,    0x1.3cee1p-2, INEXACT)
T(RN,    0x1.90de5c91d10c5p+8,  0x1.420cd273a245ap+578,  -0x1.9cfe9ep-2, INEXACT)
T(RN,    0x1.9193dd97f5e97p+8,  0x1.4732383791894p+579,    0x1.7c4c4p-3, INEXACT)
T(RN,    0x1.92495e9e1ac69p+8,  0x1.4c6cab021c92ep+580,   0x1.ac6322p-2, INEXACT)
T(RN,    0x1.92fedfa43fa3bp+8,  0x1.51bc80efefff3p+581,   0x1.8b4918p-2, INEXACT)
T(RN,    0x1.93b460aa6480dp+8,  0x1.5722117df9b15p+582,   0x1.3039aep-2, INEXACT)
T(RN,    0x1.9469e1b0895dfp+8,  0x1.5c9db58f09c76p+583,  -0x1.8f3224p-3, INEXACT)
T(RN,    0x1.951f62b6ae3b1p+8,  0x1.622fc7718a95bp+584,   -0x1.ec2b8p-7, INEXACT)
T(RN,    0x1.95d4e3bcd3183p+8,  0x1.67d8a2e550064p+585,  -0x1.cf98c8p-5, INEXACT)
T(RN,    0x1.968a64c2f7f55p+8,   0x1.6d98a5217ebdp+586,   -0x1.0ce02p-5, INEXACT)
T(RN,    0x1.973fe5c91cd27p+8,  0x1.73702cda8b615p+587,  -0x1.66eb84p-2, INEXACT)
T(RN,    0x1.97f566cf41af9p+8,  0x1.795f9a4852701p+588,   -0x1.b1d51p-2, INEXACT)
T(RN,    0x1.98aae7d5668cbp+8,  0x1.7f674f2c48fa3p+589,  -0x1.919654p-4, INEXACT)
T(RN,    0x1.996068db8b69dp+8,   0x1.8587aed7c6b6p+590,   0x1.f0b66cp-2, INEXACT)
T(RN,    0x1.9a15e9e1b046fp+8,  0x1.8bc11e3269cabp+591,   0x1.858e08p-3, INEXACT)
T(RN,    0x1.9acb6ae7d5241p+8,  0x1.921403c094bf9p+592,   0x1.e6438cp-2, INEXACT)
T(RN,    0x1.9b80ebedfa013p+8,  0x1.9880c7aa06f93p+593,   0x1.e78976p-2, INEXACT)
T(RN,    0x1.9c366cf41ede5p+8,  0x1.9f07d3c090321p+594,   0x1.e4e92cp-2, INEXACT)
T(RN,    0x1.9cebedfa43bb7p+8,  0x1.a5a99386df5c6p+595,  -0x1.58cc9ap-3, INEXACT)
T(RN,    0x1.9da16f0068989p+8,  0x1.ac6674376d5dap+596,   0x1.3a669ap-2, INEXACT)
T(RN,    0x1.9e56f0068d75bp+8,  0x1.b33ee4cb84152p+597,   -0x1.fc3b1p-5, INEXACT)
T(RN,    0x1.9f0c710cb252dp+8,  0x1.ba33560262228p+598,  -0x1.92f19cp-2, INEXACT)
T(RN,    0x1.9fc1f212d72ffp+8,  0x1.c1443a687be06p+599,  -0x1.d24c38p-3, INEXACT)
T(RN,    0x1.a0777318fc0d1p+8,  0x1.c872065eda0b8p+600,  -0x1.813ae2p-3, INEXACT)
T(RN,    0x1.a12cf41f20ea3p+8,  0x1.cfbd3022968fbp+601,  -0x1.2ef1f8p-3, INEXACT)
T(RN,    0x1.a1e2752545c75p+8,  0x1.d7262fd477f59p+602,  -0x1.7ec388p-5, INEXACT)
T(RN,    0x1.a297f62b6aa47p+8,  0x1.dead7f80abeeap+603,  -0x1.fd8a5cp-6, INEXACT)
T(RN,    0x1.a34d77318f819p+8,  0x1.e6539b26a17efp+604,   0x1.7f30d2p-2, INEXACT)
T(RN,    0x1.a402f837b45ebp+8,  0x1.ee1900c103458p+605,  -0x1.7e799cp-3, INEXACT)
T(RN,    0x1.a4b8793dd93bdp+8,  0x1.f5fe304dd2676p+606,   0x1.851f74p-5, INEXACT)
T(RN,    0x1.a56dfa43fe18fp+8,  0x1.fe03abd6a2a1fp+607,   0x1.965be6p-2, INEXACT)
T(RN,    0x1.a6237b4a22f61p+8,  0x1.0314fbbc7c068p+609,   -0x1.77b6bp-3, INEXACT)
T(RN,    0x1.a6d8fc5047d33p+8,  0x1.0738ccb7638b2p+610,  -0x1.8dc4d2p-3, INEXACT)
T(RN,    0x1.a78e7d566cb05p+8,  0x1.0b6d8d0b8ba0bp+611,   0x1.644ab8p-2, INEXACT)
T(RN,    0x1.a843fe5c918d7p+8,  0x1.0fb381ff649dep+612,  -0x1.85356cp-2, INEXACT)
T(RN,    0x1.a8f97f62b66a9p+8,  0x1.140af1f4c06a8p+613,   0x1.93bbb4p-7, INEXACT)
T(RN,    0x1.a9af0068db47bp+8,  0x1.1874246d59b64p+614,  -0x1.93accap-3, INEXACT)
T(RN,    0x1.aa64816f0024dp+8,  0x1.1cef620f6db66p+615,   0x1.f931c6p-2, INEXACT)
T(RN,    0x1.ab1a02752501fp+8,  0x1.217cf4aa68b44p+616,   0x1.cdd31ep-2, INEXACT)
T(RN,    0x1.abcf837b49df1p+8,  0x1.261d273ba5bb6p+617,   0x1.fa798ap-4, INEXACT)
T(RN,    0x1.ac8504816ebc3p+8,  0x1.2ad045f341b3ep+618,   0x1.a89656p-2, INEXACT)
T(RN,    0x1.ad3a858793995p+8,  0x1.2f969e3902395p+619,  -0x1.8936e4p-3, INEXACT)
T(RN,    0x1.adf0068db8767p+8,  0x1.34707eb1507f2p+620,  -0x1.ed869ap-2, INEXACT)
T(RN,    0x1.aea58793dd539p+8,  0x1.395e37424893bp+621,   0x1.2fbf88p-2, INEXACT)
T(RN,    0x1.af5b089a0230bp+8,  0x1.3e601918dd55ep+622,  -0x1.c13d46p-2, INEXACT)
T(RN,    0x1.b01089a0270ddp+8,  0x1.437676ae11728p+623,    0x1.9c7ebp-3, INEXACT)
T(RN,    0x1.b0c60aa64beafp+8,  0x1.48a1a3cc45bdbp+624,  -0x1.cef07ap-3, INEXACT)
T(RN,    0x1.b17b8bac70c81p+8,  0x1.4de1f5949d421p+625,  -0x1.891526p-3, INEXACT)
T(RN,    0x1.b2310cb295a53p+8,  0x1.5337c284775c5p+626,  -0x1.9ef536p-2, INEXACT)
T(RN,    0x1.b2e68db8ba825p+8,  0x1.58a3627b003efp+627,   0x1.1985b8p-3, INEXACT)
T(RN,    0x1.b39c0ebedf5f7p+8,  0x1.5e252ebed838bp+628,  -0x1.fc37b2p-4, INEXACT)
T(RN,    0x1.b4518fc5043c9p+8,  0x1.63bd8203d21bfp+629,   0x1.75a438p-2, INEXACT)
T(RN,    0x1.b50710cb2919bp+8,  0x1.696cb870c9244p+630,   0x1.21033ep-2, INEXACT)
T(RN,    0x1.b5bc91d14df6dp+8,  0x1.6f332fa58ebbap+631,  -0x1.6c9d74p-5, INEXACT)
T(RN,    0x1.b67212d772d3fp+8,  0x1.751146c0f0801p+632,   0x1.6b007cp-6, INEXACT)
T(RN,    0x1.b72793dd97b11p+8,   0x1.7b075e66d6edp+633,  -0x1.018208p-3, INEXACT)
T(RN,    0x1.b7dd14e3bc8e3p+8,  0x1.8115d8c67d0dbp+634,    0x1.618f2p-3, INEXACT)
T(RN,    0x1.b89295e9e16b5p+8,  0x1.873d19a0c19e5p+635,  -0x1.b3d63cp-5, INEXACT)
T(RN,    0x1.b94816f006487p+8,  0x1.8d7d864e9204ap+636,  -0x1.8a6bb6p-2, INEXACT)
T(RN,    0x1.b9fd97f62b259p+8,  0x1.93d785c76f892p+637,  -0x1.5eb6fap-2, INEXACT)
T(RN,    0x1.bab318fc5002bp+8,  0x1.9a4b80a80f3c8p+638,  -0x1.6009c2p-2, INEXACT)
T(RN,    0x1.bb689a0274dfdp+8,  0x1.a0d9e13914f69p+639,  -0x1.b1b246p-5, INEXACT)
T(RN,    0x1.bc1e1b0899bcfp+8,  0x1.a7831375e9dd3p+640,   0x1.fcb574p-3, INEXACT)
T(RN,    0x1.bcd39c0ebe9a1p+8,  0x1.ae478513aee43p+641,   0x1.1c0b38p-2, INEXACT)
T(RN,    0x1.bd891d14e3773p+8,  0x1.b527a5884bb86p+642,  -0x1.b0dcc4p-2, INEXACT)
T(RN,    0x1.be3e9e1b08545p+8,  0x1.bc23e6119a8a4p+643,  -0x1.e8d0c8p-2, INEXACT)
T(RN,    0x1.bef41f212d317p+8,  0x1.c33cb9bcb12dfp+644,  -0x1.01e22ep-2, INEXACT)
T(RN,    0x1.bfa9a027520e9p+8,  0x1.ca72956d48091p+645,   0x1.99ce6cp-5, INEXACT)
T(RN,    0x1.c05f212d76ebbp+8,   0x1.d1c5efe53f48p+646,    0x1.0948fp-3, INEXACT)
T(RN,    0x1.c114a2339bc8dp+8,  0x1.d93741cc42d69p+647,   0x1.847e38p-2, INEXACT)
T(RN,    0x1.c1ca2339c0a5fp+8,  0x1.e0c705b78d99cp+648,   0x1.f6e1e2p-3, INEXACT)
T(RN,    0x1.c27fa43fe5831p+8,  0x1.e875b831cc6acp+649,  -0x1.e753eap-2, INEXACT)
T(RN,    0x1.c33525460a603p+8,  0x1.f043d7c32154fp+650,   0x1.0f4cf4p-2, INEXACT)
T(RN,    0x1.c3eaa64c2f3d5p+8,  0x1.f831e4f9479a4p+651,  -0x1.05c262p-2, INEXACT)
T(RN,    0x1.c4a02752541a7p+8,  0x1.00203137ec82dp+653,   0x1.d27ba2p-4, INEXACT)
T(RN,    0x1.c555a85878f79p+8,  0x1.0437ea6c5a88cp+654,   -0x1.251c5p-6, INEXACT)
T(RN,    0x1.c60b295e9dd4bp+8,  0x1.0860618245377p+655,  -0x1.f21636p-2, INEXACT)
T(RN,    0x1.c6c0aa64c2b1dp+8,  0x1.0c99daf5c1bc2p+656,  -0x1.897d6ep-2, INEXACT)
T(RN,    0x1.c7762b6ae78efp+8,  0x1.10e49c5b0b0fbp+657,  -0x1.2f6b06p-2, INEXACT)
T(RN,    0x1.c82bac710c6c1p+8,  0x1.1540ec62fbf3fp+658,   0x1.93ee76p-2, INEXACT)
T(RN,    0x1.c8e12d7731493p+8,  0x1.19af12df9b406p+659,  -0x1.ab2d8ep-2, INEXACT)
T(RN,    0x1.c996ae7d56265p+8,  0x1.1e2f58c8baca7p+660,   0x1.7eb59cp-2, INEXACT)
T(RN,    0x1.ca4c2f837b037p+8,  0x1.22c20840a9337p+661,   0x1.8db772p-3, INEXACT)
T(RN,    0x1.cb01b0899fe09p+8,  0x1.27676c98f6ebfp+662,  -0x1.95242ep-5, INEXACT)
T(RN,    0x1.cbb7318fc4bdbp+8,  0x1.2c1fd2574eb91p+663,   0x1.504304p-2, INEXACT)
T(RN,    0x1.cc6cb295e99adp+8,  0x1.30eb873a620c8p+664,   0x1.fcb124p-3, INEXACT)
T(RN,    0x1.cd22339c0e77fp+8,  0x1.35cada3ee9807p+665,   0x1.60486ep-4, INEXACT)
T(RN,    0x1.cdd7b4a233551p+8,  0x1.3abe1ba4b9c93p+666,   -0x1.df63dp-2, INEXACT)
T(RN,    0x1.ce8d35a858323p+8,  0x1.3fc59cf3ed70dp+667,  -0x1.7cc728p-4, INEXACT)
T(RN,    0x1.cf42b6ae7d0f5p+8,  0x1.44e1b10223b12p+668,   0x1.654c9ep-2, INEXACT)
T(RN,    0x1.cff837b4a1ec7p+8,  0x1.4a12abf7d4c33p+669,  -0x1.d5a8b8p-2, INEXACT)
T(RN,    0x1.d0adb8bac6c99p+8,  0x1.4f58e355bbfbep+670,  -0x1.b2bdbcp-2, INEXACT)
T(RN,    0x1.d16339c0eba6bp+8,  0x1.54b4adfa580dfp+671,   0x1.5eaadap-4, INEXACT)
T(RN,    0x1.d218bac71083dp+8,  0x1.5a26642781cd4p+672,   0x1.567ffcp-8, INEXACT)
T(RN,    0x1.d2ce3bcd3560fp+8,  0x1.5fae5f8819ceep+673,   0x1.f662d4p-4, INEXACT)
T(RN,    0x1.d383bcd35a3e1p+8,  0x1.654cfb35cd431p+674,    0x1.55eb2p-4, INEXACT)
T(RN,    0x1.d4393dd97f1b3p+8,  0x1.6b0293bef268dp+675,  -0x1.b39f34p-2, INEXACT)
T(RN,    0x1.d4eebedfa3f85p+8,  0x1.70cf872c7cfb5p+676,   0x1.10bee2p-3, INEXACT)
T(RN,    0x1.d5a43fe5c8d57p+8,  0x1.76b435080afaep+677,   0x1.5f3666p-2, INEXACT)
T(RN,    0x1.d659c0ebedb29p+8,   0x1.7cb0fe620a36p+678,    0x1.ae814p-4, INEXACT)
T(RN,    0x1.d70f41f2128fbp+8,  0x1.82c645d7f6f6fp+679,   0x1.8f356ep-3, INEXACT)
T(RN,    0x1.d7c4c2f8376cdp+8,  0x1.88f46f9ab43cdp+680,   0x1.bc4066p-2, INEXACT)
T(RN,    0x1.d87a43fe5c49fp+8,   0x1.8f3be174fde9p+681,  -0x1.f7b6f4p-2, INEXACT)
T(RN,    0x1.d92fc50481271p+8,  0x1.959d02d1f54b2p+682,  -0x1.ff1b74p-3, INEXACT)
T(RN,    0x1.d9e5460aa6043p+8,  0x1.9c183cc3c8768p+683,    0x1.d0fddp-5, INEXACT)
T(RN,    0x1.da9ac710cae15p+8,    0x1.a2adfa0a74dp+684,  -0x1.de9a02p-2, INEXACT)
T(RN,    0x1.db504816efbe7p+8,   0x1.a95ea71aa543p+685,   0x1.c95d2ep-2, INEXACT)
T(RN,    0x1.dc05c91d149b9p+8,  0x1.b02ab224ac8ddp+686,  -0x1.9730eep-2, INEXACT)
T(RN,    0x1.dcbb4a233978bp+8,  0x1.b7128b1b9c1a9p+687,   0x1.46c5eap-2, INEXACT)
T(RN,    0x1.dd70cb295e55dp+8,  0x1.be16a3bc77d67p+688,  -0x1.5a8a94p-3, INEXACT)
T(RN,    0x1.de264c2f8332fp+8,  0x1.c5376f958780fp+689,   0x1.dcaa9ep-5, INEXACT)
T(RN,    0x1.dedbcd35a8101p+8,  0x1.cc75640dc5e91p+690,   0x1.87ae14p-2, INEXACT)
T(RN,    0x1.df914e3bcced3p+8,  0x1.d3d0f86c6e94ap+691,   0x1.dd7518p-3, INEXACT)
T(RN,    0x1.e046cf41f1ca5p+8,  0x1.db4aa5e0aa4d6p+692,  -0x1.743d04p-9, INEXACT)
T(RN,    0x1.e0fc504816a77p+8,  0x1.e2e2e7895b125p+693,  -0x1.8eb0b6p-5, INEXACT)
T(RN,    0x1.e1b1d14e3b849p+8,  0x1.ea9a3a7d07edcp+694,  -0x1.969724p-2, INEXACT)
T(RN,    0x1.e26752546061bp+8,  0x1.f2711dd1e932cp+695,  -0x1.513d36p-8, INEXACT)
T(RN,    0x1.e31cd35a853edp+8,  0x1.fa6812a615a5fp+696,   0x1.656a7cp-3, INEXACT)
T(RN,    0x1.e3d25460aa1bfp+8,  0x1.013fce13e88c9p+698,   0x1.1ac738p-4, INEXACT)
T(RN,    0x1.e487d566cef91p+8,  0x1.055c1fcefe80fp+699,  -0x1.bd0fcap-2, INEXACT)
T(RN,    0x1.e53d566cf3d63p+8,  0x1.0989423855cb5p+700,  -0x1.9764a6p-2, INEXACT)
T(RN,    0x1.e5f2d77318b35p+8,  0x1.0dc77a18eaff6p+701,   0x1.92ec56p-3, INEXACT)
T(RN,    0x1.e6a858793d907p+8,  0x1.12170d531b12fp+702,   0x1.87f3f8p-2, INEXACT)
T(RN,    0x1.e75dd97f626d9p+8,  0x1.167842e722621p+703,  -0x1.6037a4p-5, INEXACT)
T(RN,    0x1.e8135a85874abp+8,  0x1.1aeb62f7ae178p+704,  -0x1.9b5218p-2, INEXACT)
T(RN,    0x1.e8c8db8bac27dp+8,  0x1.1f70b6ce8044bp+705,   -0x1.b21b8p-2, INEXACT)
T(RN,    0x1.e97e5c91d104fp+8,  0x1.240888e126f5fp+706,   0x1.e7de7cp-6, INEXACT)
T(RN,    0x1.ea33dd97f5e21p+8,  0x1.28b324d5c6905p+707,   0x1.09709ep-2, INEXACT)
T(RN,    0x1.eae95e9e1abf3p+8,  0x1.2d70d787f7c84p+708,  -0x1.9084eep-2, INEXACT)
T(RN,    0x1.eb9edfa43f9c5p+8,  0x1.3241ef0db9812p+709,   0x1.6f18acp-2, INEXACT)
T(RN,    0x1.ec5460aa64797p+8,  0x1.3726babc76e66p+710,  -0x1.da38eep-2, INEXACT)
T(RN,    0x1.ed09e1b089569p+8,  0x1.3c1f8b2e2212dp+711,  -0x1.f86f32p-3, INEXACT)
T(RN,    0x1.edbf62b6ae33bp+8,  0x1.412cb2466397cp+712,  -0x1.60c8bep-7, INEXACT)
T(RN,    0x1.ee74e3bcd310dp+8,  0x1.464e8337df3b7p+713,  -0x1.aece6cp-3, INEXACT)
T(RN,    0x1.ef2a64c2f7edfp+8,  0x1.4b8552898e449p+714,   0x1.e96a38p-2, INEXACT)
T(RN,    0x1.efdfe5c91ccb1p+8,  0x1.50d1761c2faacp+715,  -0x1.8c0b96p-3, INEXACT)
T(RN,    0x1.f09566cf41a83p+8,  0x1.5633452fce86ep+716,  -0x1.001f4cp-4, INEXACT)
T(RN,    0x1.f14ae7d566855p+8,  0x1.5bab18695f1c6p+717,  -0x1.0fdac2p-2, INEXACT)
T(RN,    0x1.f20068db8b627p+8,  0x1.613949d872d9dp+718,    0x1.70404p-4, INEXACT)
T(RN,    0x1.f2b5e9e1b03f9p+8,  0x1.66de34fd03ad4p+719,   0x1.75eb02p-2, INEXACT)
T(RN,    0x1.f36b6ae7d51cbp+8,  0x1.6c9a36cd570ccp+720,   0x1.e2b41ap-7, INEXACT)
T(RN,    0x1.f420ebedf9f9dp+8,  0x1.726dadbbf913ap+721,   0x1.ea4fbap-5, INEXACT)
T(RN,    0x1.f4d66cf41ed6fp+8,  0x1.7858f9bdd016bp+722,    0x1.2a7a6p-2, INEXACT)
T(RN,    0x1.f58bedfa43b41p+8,  0x1.7e5c7c5049141p+723,  -0x1.a851d6p-4, INEXACT)
T(RN,    0x1.f6416f0068913p+8,  0x1.8478987f9d642p+724,   -0x1.8c829p-2, INEXACT)
T(RN,    0x1.f6f6f0068d6e5p+8,  0x1.8aadb2ed32128p+725,  -0x1.e630f6p-2, INEXACT)
T(RN,    0x1.f7ac710cb24b7p+8,  0x1.90fc31d611489p+726,   0x1.9486b4p-3, INEXACT)
T(RN,    0x1.f861f212d7289p+8,  0x1.97647d197e33ap+727,   0x1.03cc86p-7, INEXACT)
T(RN,    0x1.f9177318fc05bp+8,  0x1.9de6fe3fa3d3ep+728,   0x1.270e64p-2, INEXACT)
T(RN,    0x1.f9ccf41f20e2dp+8,   0x1.a48420805f21p+729,   0x1.5cf99ep-3, INEXACT)
T(RN,    0x1.fa82752545bffp+8,  0x1.ab3c50ca24f58p+730,  -0x1.84b586p-4, INEXACT)
T(RN,    0x1.fb37f62b6a9d1p+8,  0x1.b20ffdc904318p+731,  -0x1.6d9412p-3, INEXACT)
T(RN,    0x1.fbed77318f7a3p+8,  0x1.b8ff97edc488dp+732,   0x1.ce8a6ep-5, INEXACT)
T(RN,    0x1.fca2f837b4575p+8,  0x1.c00b917522717p+733,  -0x1.570c98p-2, INEXACT)
T(RN,    0x1.fd58793dd9347p+8,  0x1.c7345e6f28a9fp+734,  -0x1.074bb6p-2, INEXACT)
T(RN,    0x1.fe0dfa43fe119p+8,  0x1.ce7a74c6a7d01p+735,  -0x1.14724ap-2, INEXACT)
T(RN,    0x1.fec37b4a22eebp+8,  0x1.d5de4c48cc837p+736,   0x1.d29e3cp-4, INEXACT)
T(RN,    0x1.ff78fc5047cbdp+8,  0x1.dd605eacd4909p+737,    0x1.3c821p-2, INEXACT)
T(RN,    0x1.0005182a990b3p+9,  0x1.a4e2677932966p+738,  -0x1.a5a82ap-3, INEXACT)
T(RN,    0x1.005fd8adab79cp+9,  0x1.ab9c196af187fp+739,  -0x1.83075cp-3, INEXACT)
T(RN,    0x1.00ba9930bde85p+9,  0x1.b2714e3b607c1p+740,  -0x1.57b382p-3, INEXACT)
T(RN,    0x1.011559b3d056ep+9,  0x1.b96276747c875p+741,  -0x1.b8571ep-6, INEXACT)
T(RN,    0x1.01701a36e2c57p+9,  0x1.c070046c9e9f1p+742,   0x1.f95964p-6, INEXACT)
T(RN,     0x1.01cadab9f534p+9,  0x1.c79a6c4dd6c59p+743,   0x1.85be6cp-2, INEXACT)
T(RN,    0x1.02259b3d07a29p+9,  0x1.cee2241d654d4p+744,   0x1.a72032p-3, INEXACT)
T(RN,    0x1.02805bc01a112p+9,  0x1.d647a3c352aedp+745,  -0x1.bffba2p-2, INEXACT)
T(RN,    0x1.02db1c432c7fbp+9,  0x1.ddcb6512266ecp+746,   0x1.262e8ap-2, INEXACT)
T(RN,    0x1.0335dcc63eee4p+9,  0x1.e56de3cebd912p+747,  -0x1.618d14p-3, INEXACT)
T(RN,    0x1.03909d49515cdp+9,  0x1.ed2f9db8411dfp+748,  -0x1.df2d6ap-2, INEXACT)
T(RN,    0x1.03eb5dcc63cb6p+9,  0x1.f51112903d379p+749,   -0x1.f8c4cp-7, INEXACT)
T(RN,    0x1.04461e4f7639fp+9,  0x1.fd12c422d9499p+750,    0x1.9a33ep-2, INEXACT)
T(RN,    0x1.04a0ded288a88p+9,  0x1.029a9b2798eb9p+752,   0x1.dbc9aep-6, INEXACT)
T(RN,    0x1.04fb9f559b171p+9,  0x1.06bc7787ea394p+753,  -0x1.c66968p-2, INEXACT)
T(RN,    0x1.05565fd8ad85ap+9,  0x1.0aef3b41af34ap+754,  -0x1.efd532p-8, INEXACT)
T(RN,    0x1.05b1205bbff43p+9,  0x1.0f332b7a9f596p+755,    0x1.92717p-2, INEXACT)
T(RN,    0x1.060be0ded262cp+9,  0x1.13888e734dd93p+756,  -0x1.e260f4p-6, INEXACT)
T(RN,    0x1.0666a161e4d15p+9,  0x1.17efab8baeaf9p+757,  -0x1.64da2cp-2, INEXACT)
T(RN,    0x1.06c161e4f73fep+9,  0x1.1c68cb47ae32ap+758,   0x1.26a50cp-2, INEXACT)
T(RN,    0x1.071c226809ae7p+9,  0x1.20f43753db6ccp+759,   0x1.9ac6fap-2, INEXACT)
T(RN,     0x1.0776e2eb1c1dp+9,  0x1.25923a8a258c4p+760,   0x1.6224e4p-9, INEXACT)
T(RN,    0x1.07d1a36e2e8b9p+9,  0x1.2a4320f6acb69p+761,   0x1.86a432p-2, INEXACT)
T(RN,    0x1.082c63f140fa2p+9,  0x1.2f0737dca68e4p+762,  -0x1.99b7b2p-3, INEXACT)
T(RN,    0x1.088724745368bp+9,  0x1.33decdbb56bd5p+763,  -0x1.fa6794p-3, INEXACT)
T(RN,    0x1.08e1e4f765d74p+9,  0x1.38ca32531bd45p+764,  -0x1.3f248ep-3, INEXACT)
T(RN,    0x1.093ca57a7845dp+9,  0x1.3dc9b6aa90d2bp+765,   0x1.a1209ep-2, INEXACT)
T(RN,    0x1.099765fd8ab46p+9,  0x1.42ddad13c3abfp+766,  -0x1.1cd596p-2, INEXACT)
T(RN,    0x1.09f226809d22fp+9,  0x1.4806693181207p+767,   0x1.4a5f02p-4, INEXACT)
T(RN,    0x1.0a4ce703af918p+9,  0x1.4d443ffcb63fbp+768,   0x1.89b852p-8, INEXACT)
T(RN,    0x1.0aa7a786c2001p+9,  0x1.529787c9e7ee5p+769,  -0x1.8e37a6p-2, INEXACT)
T(RN,    0x1.0b026809d46eap+9,  0x1.5800984ec0c8bp+770,   0x1.c9b654p-2, INEXACT)
T(RN,    0x1.0b5d288ce6dd3p+9,  0x1.5d7fcaa7b5bdbp+771,   0x1.383ab2p-3, INEXACT)
T(RN,    0x1.0bb7e90ff94bcp+9,  0x1.6315795dc1bfap+772,  -0x1.4cc27ep-3, INEXACT)
T(RN,    0x1.0c12a9930bba5p+9,  0x1.68c2006c38e85p+773,   0x1.789002p-2, INEXACT)
T(RN,    0x1.0c6d6a161e28ep+9,  0x1.6e85bd46b370fp+774,  -0x1.b25a06p-2, INEXACT)
T(RN,    0x1.0cc82a9930977p+9,  0x1.74610edf10dfdp+775,  -0x1.9dfd5ep-4, INEXACT)
T(RN,     0x1.0d22eb1c4306p+9,  0x1.7a5455ab93cd6p+776,   0x1.4fb706p-6, INEXACT)
T(RN,    0x1.0d7dab9f55749p+9,  0x1.805ff3ad16a6ep+777,  -0x1.c653ccp-3, INEXACT)
T(RN,    0x1.0dd86c2267e32p+9,  0x1.86844c7559d3dp+778,  -0x1.f924a4p-4, INEXACT)
T(RN,    0x1.0e332ca57a51bp+9,  0x1.8cc1c52d6ba63p+779,  -0x1.81e0aap-3, INEXACT)
T(RN,    0x1.0e8ded288cc04p+9,  0x1.9318c49c2a7f7p+780,  -0x1.214092p-3, INEXACT)
T(RN,    0x1.0ee8adab9f2edp+9,  0x1.9989b32ce194dp+781,     0x1.38b6p-7, INEXACT)
T(RN,    0x1.0f436e2eb19d6p+9,  0x1.a014faf600c06p+782,   0x1.4cf376p-2, INEXACT)
T(RN,    0x1.0f9e2eb1c40bfp+9,  0x1.a6bb07bfefcd2p+783,   0x1.5c3d68p-2, INEXACT)
T(RN,    0x1.0ff8ef34d67a8p+9,  0x1.ad7c470bfdaedp+784,  -0x1.28dee6p-3, INEXACT)
T(RN,    0x1.1053afb7e8e91p+9,  0x1.b459281b6c179p+785,  -0x1.1fb6d8p-2, INEXACT)
T(RN,    0x1.10ae703afb57ap+9,  0x1.bb521bf697df3p+786, -0x1.aeaa1ep-13, INEXACT)
T(RN,    0x1.110930be0dc63p+9,  0x1.c26795743eb26p+787,   0x1.19d1d6p-2, INEXACT)
T(RN,    0x1.1163f1412034cp+9,  0x1.c99a0940e2816p+788,   -0x1.73ca3p-2, INEXACT)
T(RN,    0x1.11beb1c432a35p+9,  0x1.d0e9ede64b282p+789,   0x1.802f88p-2, INEXACT)
T(RN,    0x1.121972474511ep+9,  0x1.d857bbd326ca8p+790,   0x1.9d9eacp-3, INEXACT)
T(RN,    0x1.127432ca57807p+9,   0x1.dfe3ed62c964p+791,   0x1.0a880ap-2, INEXACT)
T(RN,     0x1.12cef34d69efp+9,  0x1.e78efee50c08bp+792,    0x1.b752fp-5, INEXACT)
T(RN,    0x1.1329b3d07c5d9p+9,  0x1.ef596ea64c5a5p+793,  -0x1.9555a6p-3, INEXACT)
T(RN,    0x1.138474538ecc2p+9,  0x1.f743bcf78cb4bp+794,  -0x1.aad1acp-2, INEXACT)
T(RN,    0x1.13df34d6a13abp+9,  0x1.ff4e6c36b5977p+795,  -0x1.017cc4p-4, INEXACT)
T(RN,    0x1.1439f559b3a94p+9,  0x1.03bd006b7c6a7p+797,   0x1.99349cp-3, INEXACT)
T(RN,    0x1.1494b5dcc617dp+9,  0x1.07e380b4ab883p+798,  -0x1.59f23ep-3, INEXACT)
T(RN,    0x1.14ef765fd8866p+9,  0x1.0c1afb52a40c6p+799,  -0x1.08b908p-3, INEXACT)
T(RN,    0x1.154a36e2eaf4fp+9,  0x1.1063b5b8c3563p+800,   0x1.4fcde8p-2, INEXACT)
T(RN,    0x1.15a4f765fd638p+9,  0x1.14bdf676801c7p+801,   0x1.4d1864p-2, INEXACT)
T(RN,    0x1.15ffb7e90fd21p+9,  0x1.192a053bf494cp+802,   0x1.f32e5ap-2, INEXACT)
T(RN,    0x1.165a786c2240ap+9,  0x1.1da82ade7b2c6p+803,  -0x1.aaa294p-3, INEXACT)
T(RN,    0x1.16b538ef34af3p+9,  0x1.2238b15d5e1f7p+804,   0x1.cc955ep-2, INEXACT)
T(RN,    0x1.170ff972471dcp+9,  0x1.26dbe3e69a3a8p+805,  -0x1.dd8428p-6, INEXACT)
T(RN,    0x1.176ab9f5598c5p+9,  0x1.2b920edbb516bp+806,  -0x1.702d2cp-3, INEXACT)
T(RN,    0x1.17c57a786bfaep+9,  0x1.305b7fd6a71e2p+807,   0x1.6e871cp-5, INEXACT)
T(RN,    0x1.18203afb7e697p+9,  0x1.353885aed9aaep+808,  -0x1.12bc88p-3, INEXACT)
T(RN,     0x1.187afb7e90d8p+9,  0x1.3a29707e39925p+809,   -0x1.cd45dp-2, INEXACT)
T(RN,    0x1.18d5bc01a3469p+9,  0x1.3f2e91a65e704p+810,  -0x1.4b18ccp-3, INEXACT)
T(RN,    0x1.19307c84b5b52p+9,  0x1.44483bd5c706cp+811,  -0x1.07f338p-3, INEXACT)
T(RN,    0x1.198b3d07c823bp+9,  0x1.4976c30d2b094p+812,    -0x1.799ap-3, INEXACT)
T(RN,    0x1.19e5fd8ada924p+9,  0x1.4eba7ca4e2aa2p+813,   0x1.902dd4p-2, INEXACT)
T(RN,    0x1.1a40be0ded00dp+9,  0x1.5413bf526443cp+814,   0x1.ce2d5ap-5, INEXACT)
T(RN,    0x1.1a9b7e90ff6f6p+9,  0x1.5982e32dd8782p+815,  -0x1.c53beap-4, INEXACT)
T(RN,    0x1.1af63f1411ddfp+9,  0x1.5f0841b7c521fp+816,   0x1.6c0eb6p-5, INEXACT)
T(RN,    0x1.1b50ff97244c8p+9,  0x1.64a435decf753p+817,   0x1.a7fd9ep-3, INEXACT)
T(RN,    0x1.1babc01a36bb1p+9,  0x1.6a571c0595adfp+818,  -0x1.b07f66p-2, INEXACT)
T(RN,    0x1.1c06809d4929ap+9,  0x1.70215208a0adcp+819,  -0x1.45b326p-2, INEXACT)
T(RN,    0x1.1c6141205b983p+9,  0x1.760337446de91p+820,  -0x1.587da4p-2, INEXACT)
T(RN,    0x1.1cbc01a36e06cp+9,  0x1.7bfd2c9b9208fp+821,  -0x1.3e5504p-2, INEXACT)
T(RN,    0x1.1d16c22680755p+9,  0x1.820f947cf4a57p+822,  -0x1.5700dcp-2, INEXACT)
T(RN,    0x1.1d7182a992e3ep+9,  0x1.883ad2ea257fbp+823,  -0x1.78b672p-2, INEXACT)
T(RN,    0x1.1dcc432ca5527p+9,  0x1.8e7f4d7dcba3dp+824,   -0x1.73f37p-5, INEXACT)
T(RN,     0x1.1e2703afb7c1p+9,  0x1.94dd6b722edcap+825,  -0x1.f8441ap-3, INEXACT)
T(RN,    0x1.1e81c432ca2f9p+9,  0x1.9b5595a7dbe52p+826,  -0x1.d45a9ep-5, INEXACT)
T(RN,    0x1.1edc84b5dc9e2p+9,  0x1.a1e836ac63c48p+827,  -0x1.3a8306p-2, INEXACT)
T(RN,    0x1.1f374538ef0cbp+9,  0x1.a895bac136c4ap+828,   0x1.8dc3dap-3, INEXACT)
T(RN,    0x1.1f9205bc017b4p+9,   0x1.af5e8fe29b73p+829,   0x1.4fa678p-3, INEXACT)
T(RN,    0x1.1fecc63f13e9dp+9,  0x1.b64325cec21fep+830,   -0x1.44e86p-2, INEXACT)
T(RN,    0x1.204786c226586p+9,  0x1.bd43ee0cf54f5p+831,  -0x1.875e2cp-2, INEXACT)
T(RN,    0x1.20a2474538c6fp+9,  0x1.c4615bf4e792dp+832,   0x1.6b0ecep-4, INEXACT)
T(RN,    0x1.20fd07c84b358p+9,  0x1.cb9be4b61f43fp+833,   0x1.4b4c84p-3, INEXACT)
T(RN,    0x1.2157c84b5da41p+9,  0x1.d2f3ff5f809a4p+834,   0x1.9f3eccp-3, INEXACT)
T(RN,    0x1.21b288ce7012ap+9,  0x1.da6a24e6f6985p+835,    0x1.0ab37p-4, INEXACT)
T(RN,    0x1.220d495182813p+9,  0x1.e1fed0313b4e5p+836,  -0x1.ce4404p-2, INEXACT)
T(RN,    0x1.226809d494efcp+9,  0x1.e9b27e19bff27p+837,    0x1.374c8p-2, INEXACT)
T(RN,    0x1.22c2ca57a75e5p+9,  0x1.f185ad7ab550ap+838,  -0x1.a1e3e2p-2, INEXACT)
T(RN,    0x1.231d8adab9ccep+9,  0x1.f978df3535178p+839,   0x1.dc98a6p-8, INEXACT)
T(RN,    0x1.23784b5dcc3b7p+9,  0x1.00c64b1cc6436p+841,   0x1.d4c73cp-3, INEXACT)
T(RN,     0x1.23d30be0deaap+9,  0x1.04e0abc7d484cp+842,   0x1.432512p-3, INEXACT)
T(RN,    0x1.242dcc63f1189p+9,  0x1.090bd52fd3a33p+843,  -0x1.030566p-3, INEXACT)
T(RN,    0x1.24888ce703872p+9,  0x1.0d480bfd42994p+844,   0x1.8109a4p-2, INEXACT)
T(RN,    0x1.24e34d6a15f5bp+9,  0x1.119595f17bdb1p+845,   0x1.9bfeeep-3, INEXACT)
T(RN,    0x1.253e0ded28644p+9,  0x1.15f4b9eb323afp+846,   0x1.3c16ccp-4, INEXACT)
T(RN,    0x1.2598ce703ad2dp+9,  0x1.1a65bfeb00294p+847,  -0x1.795ccap-5, INEXACT)
T(RN,    0x1.25f38ef34d416p+9,  0x1.1ee8f118099b6p+848,  -0x1.3eef16p-3, INEXACT)
T(RN,    0x1.264e4f765faffp+9,  0x1.237e97c4b0e5bp+849,   -0x1.23b3ep-2, INEXACT)
T(RN,    0x1.26a90ff9721e8p+9,  0x1.2826ff735ed64p+850,   0x1.494b8ep-3, INEXACT)
T(RN,    0x1.2703d07c848d1p+9,  0x1.2ce274db5e5ebp+851,  -0x1.d4a4b8p-3, INEXACT)
T(RN,    0x1.275e90ff96fbap+9,  0x1.31b145edcc1dfp+852,   -0x1.aed51p-6, INEXACT)
T(RN,    0x1.27b95182a96a3p+9,  0x1.3693c1da9a1a1p+853,  -0x1.51f894p-2, INEXACT)
T(RN,    0x1.28141205bbd8cp+9,   0x1.3b8a3915a7fep+854,   0x1.a34bc8p-3, INEXACT)
T(RN,    0x1.286ed288ce475p+9,  0x1.4094fd5bf02dep+855,   0x1.6ef20ap-4, INEXACT)
T(RN,    0x1.28c9930be0b5ep+9,  0x1.45b461b8ca087p+856,   0x1.cbd5b8p-2, INEXACT)
T(RN,    0x1.2924538ef3247p+9,  0x1.4ae8ba8b41aafp+857,   0x1.7323c2p-2, INEXACT)
T(RN,     0x1.297f14120593p+9,  0x1.50325d8b85909p+858,   0x1.085bf2p-3, INEXACT)
T(RN,    0x1.29d9d49518019p+9,  0x1.5591a1d06a661p+859,  -0x1.a0d36ep-7, INEXACT)
T(RN,    0x1.2a3495182a702p+9,  0x1.5b06dfd5056ccp+860,  -0x1.4eef4ep-5, INEXACT)
T(RN,    0x1.2a8f559b3cdebp+9,  0x1.6092717e5dc92p+861,   0x1.15130ep-2, INEXACT)
T(RN,    0x1.2aea161e4f4d4p+9,  0x1.6634b221351acp+862,    0x1.9e8bbp-3, INEXACT)
T(RN,    0x1.2b44d6a161bbdp+9,  0x1.6bedfe87e7bcfp+863,   0x1.061ef4p-2, INEXACT)
T(RN,    0x1.2b9f9724742a6p+9,  0x1.71beb4f865109p+864,   0x1.50da9ep-3, INEXACT)
T(RN,    0x1.2bfa57a78698fp+9,  0x1.77a7353a4031cp+865,  -0x1.da7ad6p-2, INEXACT)
T(RN,    0x1.2c55182a99078p+9,  0x1.7da7e09cd97d4p+866,  -0x1.bff8f4p-3, INEXACT)
T(RN,    0x1.2cafd8adab761p+9,  0x1.83c119fda14a9p+867,   0x1.af0674p-2, INEXACT)
T(RN,    0x1.2d0a9930bde4ap+9,  0x1.89f345ce74429p+868,  -0x1.74101ap-5, INEXACT)
T(RN,    0x1.2d6559b3d0533p+9,  0x1.903eca1c11bb5p+869,   0x1.0debaap-4, INEXACT)
T(RN,    0x1.2dc01a36e2c1cp+9,  0x1.96a40e94ac82bp+870,   0x1.8487e6p-3, INEXACT)
T(RN,    0x1.2e1adab9f5305p+9,  0x1.9d237c8e96851p+871,    0x1.e5343p-3, INEXACT)
T(RN,    0x1.2e759b3d079eep+9,  0x1.a3bd7f0f07bd3p+872,  -0x1.7a0e98p-2, INEXACT)
T(RN,    0x1.2ed05bc01a0d7p+9,  0x1.aa7282d100dd5p+873,  -0x1.1fa15ep-2, INEXACT)
T(RN,     0x1.2f2b1c432c7cp+9,  0x1.b142f64c4a226p+874,   0x1.696686p-4, INEXACT)
T(RN,    0x1.2f85dcc63eea9p+9,  0x1.b82f49bc8ec53p+875,   0x1.3fe058p-2, INEXACT)
T(RN,    0x1.2fe09d4951592p+9,  0x1.bf37ef28957e4p+876,   0x1.b50ee8p-3, INEXACT)
T(RN,    0x1.303b5dcc63c7bp+9,  0x1.c65d5a6996933p+877,  -0x1.c3ed94p-3, INEXACT)
T(RN,    0x1.30961e4f76364p+9,  0x1.cda00132afe6cp+878,   0x1.ef3354p-2, INEXACT)
T(RN,    0x1.30f0ded288a4dp+9,  0x1.d5005b187785ap+879,  -0x1.283f6ap-3, INEXACT)
T(RN,    0x1.314b9f559b136p+9,  0x1.dc7ee198ad2e1p+880,  -0x1.e00ab6p-3, INEXACT)
T(RN,    0x1.31a65fd8ad81fp+9,  0x1.e41c10220b4f4p+881,   0x1.d3c5b8p-8, INEXACT)
T(RN,    0x1.3201205bbff08p+9,  0x1.ebd8641c3802ap+882,   0x1.65f70cp-2, INEXACT)
T(RN,    0x1.325be0ded25f1p+9,  0x1.f3b45cefd6814p+883,   0x1.5912b4p-2, INEXACT)
T(RN,    0x1.32b6a161e4cdap+9,  0x1.fbb07c0eb99a5p+884,   -0x1.6118dp-2, INEXACT)
T(RN,    0x1.331161e4f73c3p+9,  0x1.01e6a27e1bd8fp+886,   0x1.d7d3e8p-2, INEXACT)
T(RN,    0x1.336c226809aacp+9,  0x1.06059eaad0681p+887,   0x1.dcf59cp-4, INEXACT)
T(RN,    0x1.33c6e2eb1c195p+9,  0x1.0a35766d6ba75p+888,  -0x1.0c3834p-3, INEXACT)
T(RN,    0x1.3421a36e2e87ep+9,  0x1.0e766ebb85d74p+889,   -0x1.04eb5p-4, INEXACT)
T(RN,    0x1.347c63f140f67p+9,  0x1.12c8cda4ce14ap+890,   0x1.638938p-2, INEXACT)
T(RN,     0x1.34d724745365p+9,  0x1.172cda578c46dp+891,   0x1.f6ff04p-2, INEXACT)
T(RN,    0x1.3531e4f765d39p+9,  0x1.1ba2dd25357ebp+892,   0x1.94d38cp-3, INEXACT)
T(RN,    0x1.358ca57a78422p+9,  0x1.202b1f8713113p+893,  -0x1.f29028p-2, INEXACT)
T(RN,    0x1.35e765fd8ab0bp+9,  0x1.24c5ec22fcba6p+894,    0x1.ec2f5p-5, INEXACT)
T(RN,    0x1.364226809d1f4p+9,  0x1.29738ed026166p+895,    0x1.1330bp-2, INEXACT)
T(RN,    0x1.369ce703af8ddp+9,  0x1.2e34549bffc04p+896,  -0x1.0f3ca6p-3, INEXACT)
T(RN,    0x1.36f7a786c1fc6p+9,  0x1.33088bcf2c665p+897,   -0x1.a32bep-3, INEXACT)
T(RN,    0x1.37526809d46afp+9,  0x1.37f083f28a25bp+898,   0x1.34985ap-3, INEXACT)
T(RN,    0x1.37ad288ce6d98p+9,  0x1.3cec8dd450805p+899,  -0x1.46c182p-4, INEXACT)
T(RN,    0x1.3807e90ff9481p+9,  0x1.41fcfb8d4341cp+900,   0x1.245ee8p-6, INEXACT)
T(RN,    0x1.3862a9930bb6ap+9,  0x1.47222085faa7dp+901,  -0x1.848f56p-2, INEXACT)
T(RN,    0x1.38bd6a161e253p+9,  0x1.4c5c517c4126ep+902,  -0x1.b0548ap-4, INEXACT)
T(RN,    0x1.39182a993093cp+9,  0x1.51abe48887215p+903,  -0x1.2e61f8p-5, INEXACT)
T(RN,    0x1.3972eb1c43025p+9,  0x1.571131236cecdp+904,   0x1.7e4726p-2, INEXACT)
T(RN,    0x1.39cdab9f5570ep+9,  0x1.5c8c902b637ffp+905,   0x1.6cbfa2p-2, INEXACT)
T(RN,    0x1.3a286c2267df7p+9,  0x1.621e5bea64255p+906,  -0x1.28314ep-3, INEXACT)
T(RN,     0x1.3a832ca57a4ep+9,  0x1.67c6f01bbf923p+907,   -0x1.9ba2ep-2, INEXACT)
T(RN,    0x1.3added288cbc9p+9,  0x1.6d86a9f204c02p+908,   0x1.a0f3aep-2, INEXACT)
T(RN,    0x1.3b38adab9f2b2p+9,  0x1.735de81cffeafp+909,   0x1.f97d5cp-2, INEXACT)
T(RN,    0x1.3b936e2eb199bp+9,  0x1.794d0acfd2163p+910,  -0x1.8bfad2p-2, INEXACT)
T(RN,    0x1.3bee2eb1c4084p+9,  0x1.7f5473c7217dfp+911,   -0x1.16dffp-2, INEXACT)
T(RN,    0x1.3c48ef34d676dp+9,  0x1.8574864f63589p+912,   0x1.38100ep-3, INEXACT)
T(RN,    0x1.3ca3afb7e8e56p+9,   0x1.8bada74b3f52p+913,   0x1.ddf396p-4, INEXACT)
T(RN,    0x1.3cfe703afb53fp+9,  0x1.92003d3a0d292p+914,   0x1.6c7998p-3, INEXACT)
T(RN,    0x1.3d5930be0dc28p+9,   0x1.986cb03e6cdap+915,   0x1.13dc56p-5, INEXACT)
T(RN,    0x1.3db3f14120311p+9,  0x1.9ef36a24f9c21p+916,  -0x1.ded8a4p-5, INEXACT)
T(RN,    0x1.3e0eb1c4329fap+9,  0x1.a594d66b192c4p+917,   0x1.85c6c2p-3, INEXACT)
T(RN,    0x1.3e697247450e3p+9,  0x1.ac516245e4b54p+918,   -0x1.30962p-3, INEXACT)
T(RN,    0x1.3ec432ca577ccp+9,  0x1.b3297ca930fa2p+919,   0x1.830862p-2, INEXACT)
T(RN,    0x1.3f1ef34d69eb5p+9,  0x1.ba1d964eb1042p+920,  -0x1.ff72eap-2, INEXACT)
T(RN,    0x1.3f79b3d07c59ep+9,  0x1.c12e21bd36e8dp+921,   0x1.199132p-2, INEXACT)
T(RN,    0x1.3fd474538ec87p+9,  0x1.c85b93501213cp+922,   0x1.697dfap-4, INEXACT)
T(RN,     0x1.402f34d6a137p+9,  0x1.cfa6613e8bb5ap+923,  -0x1.e4d1bap-4, INEXACT)
T(RN,    0x1.4089f559b3a59p+9,   0x1.d70f03a381d2p+924,  -0x1.63b7e8p-3, INEXACT)
T(RN,    0x1.40e4b5dcc6142p+9,  0x1.de95f485216a2p+925,   0x1.4e3702p-3, INEXACT)
T(RN,    0x1.413f765fd882bp+9,  0x1.e63bafdcc043ap+926,   -0x1.bceefp-4, INEXACT)
T(RN,    0x1.419a36e2eaf14p+9,  0x1.ee00b39ed6ccdp+927,   0x1.ce3c2ap-2, INEXACT)
T(RN,    0x1.41f4f765fd5fdp+9,  0x1.f5e57fc31aa12p+928,   0x1.f6bafap-2, INEXACT)
T(RN,    0x1.424fb7e90fce6p+9,  0x1.fdea964cba345p+929,    0x1.b5bf7p-3, INEXACT)
T(RN,    0x1.42aa786c223cfp+9,  0x1.03083da95d158p+931,  -0x1.3e4f62p-3, INEXACT)
T(RN,    0x1.430538ef34ab8p+9,  0x1.072bda843a758p+932,   0x1.a97ff2p-2, INEXACT)
T(RN,    0x1.435ff972471a1p+9,  0x1.0b6065e31e774p+933,  -0x1.df1faap-3, INEXACT)
T(RN,    0x1.43bab9f55988ap+9,  0x1.0fa6250911353p+934,    0x1.4ebb9p-2, INEXACT)
T(RN,    0x1.44157a786bf73p+9,  0x1.13fd5e546e6a5p+935,   0x1.b91f26p-4, INEXACT)
T(RN,    0x1.44703afb7e65cp+9,  0x1.186659436c70ep+936,  -0x1.a03d32p-2, INEXACT)
T(RN,    0x1.44cafb7e90d45p+9,  0x1.1ce15e78b5c59p+937,  -0x1.e6399ep-4, INEXACT)
T(RN,    0x1.4525bc01a342ep+9,  0x1.216eb7c0155b7p+938,   -0x1.1c77ep-4, INEXACT)
T(RN,    0x1.45807c84b5b17p+9,  0x1.260eb013360e1p+939,   0x1.bbf462p-2, INEXACT)
T(RN,      0x1.45db3d07c82p+9,  0x1.2ac1939e757f2p+940,   0x1.0e5f44p-3, INEXACT)
T(RN,    0x1.4635fd8ada8e9p+9,    0x1.2f87afc5cabp+941,   0x1.a8d542p-2, INEXACT)
T(RN,    0x1.4690be0decfd2p+9,  0x1.34615329c0a6dp+942,  -0x1.1f7714p-2, INEXACT)
T(RN,    0x1.46eb7e90ff6bbp+9,  0x1.394ecdac85726p+943,  -0x1.849c2ap-2, INEXACT)
T(RN,    0x1.47463f1411da4p+9,  0x1.3e5070770ddeep+944,  -0x1.e15cb8p-2, INEXACT)
T(RN,    0x1.47a0ff972448dp+9,  0x1.43668dfe4e313p+945,  -0x1.8697b6p-2, INEXACT)
T(RN,    0x1.47fbc01a36b76p+9,  0x1.48917a08883e1p+946,  -0x1.da3b0ep-5, INEXACT)
T(RN,    0x1.4856809d4925fp+9,  0x1.4dd189b2af34dp+947,   -0x1.f4e5dp-3, INEXACT)
T(RN,    0x1.48b141205b948p+9,  0x1.53271375e1767p+948,  -0x1.5671a2p-2, INEXACT)
T(RN,    0x1.490c01a36e031p+9,  0x1.58926f2cf8d2fp+949,  -0x1.b19042p-2, INEXACT)
T(RN,    0x1.4966c2268071ap+9,  0x1.5e13f61a3188fp+950,   0x1.47c868p-2, INEXACT)
T(RN,    0x1.49c182a992e03p+9,  0x1.63ac02ece8643p+951,    0x1.c1ef4p-2, INEXACT)
T(RN,    0x1.4a1c432ca54ecp+9,  0x1.695af1c7705a4p+952,  -0x1.a8a5fap-3, INEXACT)
T(RN,    0x1.4a7703afb7bd5p+9,  0x1.6f2120450004ep+953,   0x1.d6736cp-2, INEXACT)
T(RN,    0x1.4ad1c432ca2bep+9,  0x1.74feed7fb75b6p+954,  -0x1.121442p-3, INEXACT)
T(RN,    0x1.4b2c84b5dc9a7p+9,  0x1.7af4ba16be0fbp+955,   0x1.60b54cp-4, INEXACT)
T(RN,     0x1.4b874538ef09p+9,  0x1.8102e8347af1dp+956,  -0x1.75b69ep-4, INEXACT)
T(RN,    0x1.4be205bc01779p+9,  0x1.8729db94e4c1ep+957,  -0x1.f5da5ep-2, INEXACT)
T(RN,    0x1.4c3cc63f13e62p+9,  0x1.8d69f98becd7cp+958,   0x1.811876p-2, INEXACT)
T(RN,    0x1.4c9786c22654bp+9,  0x1.93c3a90c0409ep+959,   -0x1.d431ep-2, INEXACT)
T(RN,    0x1.4cf2474538c34p+9,    0x1.9a3752acba4p+960,   0x1.7d5bc6p-3, INEXACT)
T(RN,    0x1.4d4d07c84b31dp+9,  0x1.a0c560b1791c9p+961,   0x1.3fbb92p-3, INEXACT)
T(RN,    0x1.4da7c84b5da06p+9,  0x1.a76e3f105a2e2p+962,   0x1.2ee37cp-3, INEXACT)
T(RN,    0x1.4e0288ce700efp+9,  0x1.ae325b7919178p+963,  -0x1.fd38e6p-4, INEXACT)
T(RN,    0x1.4e5d4951827d8p+9,  0x1.b512255c22221p+964,  -0x1.70e8eap-3, INEXACT)
T(RN,    0x1.4eb809d494ec1p+9,  0x1.bc0e0df1bdadfp+965,  -0x1.02b43cp-3, INEXACT)
T(RN,    0x1.4f12ca57a75aap+9,  0x1.c326884158f68p+966,   0x1.fd599ap-2, INEXACT)
T(RN,    0x1.4f6d8adab9c93p+9,  0x1.ca5c0928eca2cp+967,  -0x1.9d3828p-3, INEXACT)
T(RN,    0x1.4fc84b5dcc37cp+9,  0x1.d1af0764819c5p+968,   0x1.1eb7aap-2, INEXACT)
T(RN,    0x1.50230be0dea65p+9,  0x1.d91ffb95d4a75p+969,  -0x1.3f056ap-3, INEXACT)
T(RN,    0x1.507dcc63f114ep+9,   0x1.e0af604c193bp+970,  -0x1.37672cp-5, INEXACT)
T(RN,    0x1.50d88ce703837p+9,   0x1.e85db20bdc19p+971,  -0x1.d8e1e8p-3, INEXACT)
T(RN,     0x1.51334d6a15f2p+9,  0x1.f02b6f5706269p+972,   0x1.3f39d8p-3, INEXACT)
T(RN,    0x1.518e0ded28609p+9,  0x1.f81918b5000aap+973,  -0x1.1fd41ap-2, INEXACT)
T(RN,    0x1.51e8ce703acf2p+9,  0x1.0013985d7b8bfp+975,   0x1.6ad55ep-2, INEXACT)
T(RN,    0x1.52438ef34d3dbp+9,  0x1.042b1e0a2204cp+976,   0x1.aa71d8p-2, INEXACT)
T(RN,    0x1.529e4f765fac4p+9,  0x1.085360c57a0f7p+977,   0x1.e9872cp-2, INEXACT)
T(RN,    0x1.52f90ff9721adp+9,  0x1.0c8ca5083a908p+978,   0x1.6d7048p-3, INEXACT)
T(RN,    0x1.5353d07c84896p+9,  0x1.10d730633270ep+979,  -0x1.791a8ap-2, INEXACT)
T(RN,    0x1.53ae90ff96f7fp+9,  0x1.15334983c262cp+980,  -0x1.08c59cp-4, INEXACT)
T(RN,    0x1.54095182a9668p+9,  0x1.19a1383868f52p+981,   0x1.e1c254p-2, INEXACT)
T(RN,    0x1.54641205bbd51p+9,  0x1.1e21457561417p+982,  -0x1.33dfccp-2, INEXACT)
T(RN,    0x1.54bed288ce43ap+9,  0x1.22b3bb59547f6p+983,    0x1.12594p-6, INEXACT)
T(RN,    0x1.5519930be0b23p+9,  0x1.2758e5321ecb2p+984,  -0x1.ee276ap-3, INEXACT)
T(RN,    0x1.5574538ef320cp+9,  0x1.2c110f81a76e5p+985,  -0x1.2b644ap-2, INEXACT)
T(RN,    0x1.55cf1412058f5p+9,  0x1.30dc8802ccf9fp+986,   0x1.688154p-2, INEXACT)
T(RN,    0x1.5629d49517fdep+9,   0x1.35bb9dae6583p+987,  -0x1.ee2dfap-3, INEXACT)
T(RN,    0x1.568495182a6c7p+9,  0x1.3aaea0c05354bp+988,    0x1.7dbd4p-3, INEXACT)
T(RN,     0x1.56df559b3cdbp+9,  0x1.3fb5e2bcae6a5p+989,   -0x1.f1d2bp-2, INEXACT)
T(RN,    0x1.573a161e4f499p+9,  0x1.44d1b67503081p+990,   0x1.43122ap-3, INEXACT)
T(RN,    0x1.5794d6a161b82p+9,  0x1.4a02700da5c6cp+991,   0x1.af539ap-2, INEXACT)
T(RN,    0x1.57ef97247426bp+9,  0x1.4f4865031d6c5p+992,   0x1.068beep-3, INEXACT)
T(RN,    0x1.584a57a786954p+9,  0x1.54a3ec2fa2e8fp+993,  -0x1.31cb9ap-5, INEXACT)
T(RN,    0x1.58a5182a9903dp+9,  0x1.5a155dd0b7d3cp+994,   0x1.161e3cp-3, INEXACT)
T(RN,    0x1.58ffd8adab726p+9,  0x1.5f9d138cd3c33p+995,  -0x1.3eb5eap-3, INEXACT)
T(RN,    0x1.595a9930bde0fp+9,  0x1.653b687928decp+996,   0x1.d10ef4p-2, INEXACT)
T(RN,    0x1.59b559b3d04f8p+9,  0x1.6af0b91f80086p+997,   0x1.be1988p-2, INEXACT)
T(RN,    0x1.5a101a36e2be1p+9,  0x1.70bd63842cff1p+998,  -0x1.a98ba8p-3, INEXACT)
T(RN,    0x1.5a6adab9f52cap+9,  0x1.76a1c72c1adbfp+999,   0x1.6b8818p-5, INEXACT)
T(RN,    0x1.5ac59b3d079b3p+9, 0x1.7c9e4522f14d6p+1000,   -0x1.e3c95p-3, INEXACT)
T(RN,    0x1.5b205bc01a09cp+9, 0x1.82b3400152f65p+1001,   0x1.6fff8ap-3, INEXACT)
T(RN,    0x1.5b7b1c432c785p+9, 0x1.88e11bf335574p+1002,  -0x1.fd0fa8p-2, INEXACT)
T(RN,    0x1.5bd5dcc63ee6ep+9, 0x1.8f283ebe52aafp+1003,   0x1.4803e6p-2, INEXACT)
T(RN,    0x1.5c309d4951557p+9,  0x1.95890fc8b61fp+1004,  -0x1.30256ap-2, INEXACT)
T(RN,     0x1.5c8b5dcc63c4p+9, 0x1.9c03f81f62d6bp+1005,  -0x1.e13deap-2, INEXACT)
T(RN,    0x1.5ce61e4f76329p+9,  0x1.a299627d1623p+1006,  -0x1.38f75ep-5, INEXACT)
T(RN,    0x1.5d40ded288a12p+9,  0x1.a949bb512561p+1007,  -0x1.44255ep-6, INEXACT)
T(RN,    0x1.5d9b9f559b0fbp+9, 0x1.b01570c677ef2p+1008,   0x1.d34332p-2, INEXACT)
T(RN,    0x1.5df65fd8ad7e4p+9, 0x1.b6fcf2ca9dabdp+1009,   0x1.278d7cp-2, INEXACT)
T(RN,    0x1.5e51205bbfecdp+9, 0x1.be00b31502731p+1010,  -0x1.c27d78p-3, INEXACT)
T(RN,    0x1.5eabe0ded25b6p+9, 0x1.c521252e3f10dp+1011,  -0x1.b473a4p-2, INEXACT)
T(RN,    0x1.5f06a161e4c9fp+9, 0x1.cc5ebe778820fp+1012,   0x1.2bba48p-3, INEXACT)
T(RN,    0x1.5f6161e4f7388p+9, 0x1.d3b9f6323b573p+1013,   0x1.81551ap-5, INEXACT)
T(RN,    0x1.5fbc226809a71p+9, 0x1.db3345878babep+1014,  -0x1.cf50eep-3, INEXACT)
T(RN,    0x1.6016e2eb1c15ap+9,  0x1.e2cb27904cebp+1015,   0x1.7fc43cp-2, INEXACT)
T(RN,    0x1.6071a36e2e843p+9, 0x1.ea82195cdf266p+1016,  -0x1.c5a81ap-2, INEXACT)
T(RN,    0x1.60cc63f140f2cp+9, 0x1.f25899fd3a8e2p+1017,   0x1.07d598p-2, INEXACT)
T(RN,    0x1.6127247453615p+9, 0x1.fa4f2a891c322p+1018,   0x1.2546eep-2, INEXACT)
T(RN,    0x1.6181e4f765cfep+9, 0x1.013327142a1abp+1020,   0x1.8685a4p-2, INEXACT)
T(RN,    0x1.61dca57a783e7p+9,  0x1.054f450d9afdp+1021,  -0x1.658598p-3, INEXACT)
T(RN,     0x1.623765fd8aadp+9, 0x1.097c32e195696p+1022,   0x1.709342p-2, INEXACT)
T(RN,   -0x1.0e9676640a6b9p+6,   0x1.5339bbbb82c41p-98,   -0x1.fffe8p-2, INEXACT)
T(RN,   -0x1.0db394b7b2895p+6,   0x1.a75cd69a45b74p-98,    0x1.fffe3p-2, INEXACT)
T(RN,   -0x1.a8f5989df1173p+5,    0x1.49812e2ec02ep-77,   0x1.fffe9cp-2, INEXACT)
T(RN,   -0x1.8f00bed740c41p+5,   0x1.081f2fbef11c7p-72,   0x1.fffea2p-2, INEXACT)
T(RN,   -0x1.e7f1950331e3ap+4,   0x1.0082efd5c5bcap-44,  -0x1.ffff78p-2, INEXACT)
T(RN,    -0x1.d2bdf8f47304p+4,   0x1.e291f27efb4d2p-43,  -0x1.ffff22p-2, INEXACT)
T(RN,   -0x1.a42b94d940789p+4,   0x1.1507ffd1bfc95p-38,   0x1.fffeaep-2, INEXACT)
T(RN,   -0x1.b1eb5b2d4d402p+3,   0x1.5a96e8dcaa399p-20,   0x1.ffff38p-2, INEXACT)
T(RN,   -0x1.3a55eaee2003bp+3,   0x1.c6972f2778d2fp-15,   0x1.ffff74p-2, INEXACT)
T(RN,    0x1.91cf70153bd16p+3,   0x1.154cd131a20e3p+18,  -0x1.ffff0ap-2, INEXACT)
T(RN,    0x1.00c8c0ce91c8fp+4,   0x1.1cce0c3185c3cp+23,   0x1.fffed2p-2, INEXACT)
T(RN,    0x1.15affb04ee7c5p+4,   0x1.06f3114262286p+25,   0x1.fffebep-2, INEXACT)
T(RN,    0x1.925e39713ad5cp+4,   0x1.37072b1721f45p+36,  -0x1.ffff96p-2, INEXACT)
T(RN,    0x1.ab20578e5c4ebp+4,    0x1.6d654595bc2ep+38,   -0x1.ffffap-2, INEXACT)
T(RN,    0x1.de1b43526527ap+4,   0x1.144e08c0ae754p+43,  -0x1.fffeaap-2, INEXACT)
T(RN,    0x1.1b866c2acb85ap+5,   0x1.18251d0fadf4bp+51,   0x1.ffff3cp-2, INEXACT)
T(RN,    0x1.67b20535c9e67p+5,   0x1.d2b2a17b11d02p+64,  -0x1.fffee6p-2, INEXACT)
T(RN,     0x1.6f3a8e71476bp+5,   0x1.2b2edb12978a1p+66,   -0x1.fffecp-2, INEXACT)
T(RN,    0x1.750a1dfb9389bp+5,   0x1.35486b388b877p+67,  -0x1.fffed8p-2, INEXACT)
T(RN,   -0x1.62007fcb923a3p+9, 0x1.7b0f80bfa20a6p-1022,   0x1.cd5b0cp-5, INEXACT)
T(RN,   -0x1.6202fec56d5d2p+9, 0x1.73bd901b04901p-1022,  -0x1.47224cp-3, INEXACT)
T(RN,   -0x1.62057dbf48801p+9, 0x1.6c8fcf8d784ffp-1022,    0x1.48101p-2, INEXACT)
T(RN,    -0x1.6207fcb923a3p+9, 0x1.65858c30a302cp-1022,   0x1.e581c4p-5, INEXACT)
T(RN,   -0x1.620a7bb2fec5fp+9,  0x1.5e9e16929514p-1022,  -0x1.e2c99ep-2, INEXACT)
T(RN,   -0x1.620cfaacd9e8ep+9, 0x1.57d8c2a4b5644p-1022,   0x1.4055c6p-4, INEXACT)
T(RN,   -0x1.620f79a6b50bdp+9, 0x1.5134e7ab017a1p-1022,   0x1.4d657cp-3, INEXACT)
T(RN,   -0x1.6211f8a0902ecp+9, 0x1.4ab1e02ba080ep-1022,   0x1.40c7b6p-2, INEXACT)
T(RN,   -0x1.6214779a6b51bp+9, 0x1.444f09dec77b7p-1022,   0x1.80d3bap-2, INEXACT)
T(RN,   -0x1.6216f6944674ap+9, 0x1.3e0bc59eed191p-1022,   0x1.e5eb0ap-5, INEXACT)
T(RN,   -0x1.6219758e21979p+9, 0x1.37e777594ba3dp-1022,  -0x1.9e4ad2p-3, INEXACT)
T(RN,   -0x1.621bf487fcba8p+9, 0x1.31e185feaf857p-1022,   0x1.2b7222p-2, INEXACT)
T(RN,   -0x1.621e7381d7dd7p+9, 0x1.2bf95b7490e86p-1022,  -0x1.87ee6cp-3, INEXACT)
T(RN,   -0x1.6220f27bb3006p+9, 0x1.262e648677023p-1022,   0x1.3dfd9cp-2, INEXACT)
T(RN,   -0x1.622371758e235p+9, 0x1.208010d7a399ep-1022,  -0x1.a8e474p-3, INEXACT)
T(RN,   -0x1.6225f06f69464p+9, 0x1.1aedd2d50566cp-1022,  -0x1.675b84p-2, INEXACT)
T(RN,   -0x1.62286f6944693p+9, 0x1.15771fa76fe7fp-1022,  -0x1.a7f132p-2, INEXACT)
T(RN,   -0x1.622aee631f8c2p+9, 0x1.101b6f26175e5p-1022,    0x1.76cf2p-2, INEXACT)
T(RN,   -0x1.622d6d5cfaaf1p+9, 0x1.0ada3bc94f972p-1022,  -0x1.c1c2f2p-2, INEXACT)
T(RN,    -0x1.622fec56d5d2p+9, 0x1.05b3029d8c3e4p-1022,   0x1.a50b18p-2, INEXACT)
T(RN,   -0x1.62326b50b0f4fp+9,  0x1.00a54336a172p-1022,  -0x1.4ea6cep-3, INEXACT)
T(RN,   -0x1.6234ea4a8c17ep+9, 0x1.f760ff4686bb2p-1023,  -0x1.d3d0d6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62376944673adp+9,   0x1.eda878c1874p-1023,    0x1.8710ap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6239e83e425dcp+9, 0x1.e420009e169f6p-1023,  -0x1.28693ap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.623c67381d80bp+9,  0x1.dac6a949a0ddp-1023,    0x1.381cep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.623ee631f8a3ap+9, 0x1.d19b89c80b504p-1023,   0x1.1a8792p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6241652bd3c69p+9, 0x1.c89dbd9d06768p-1023,  -0x1.7de0c8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6243e425aee98p+9, 0x1.bfcc64b5cfe4cp-1023,   0x1.68619ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6246631f8a0c7p+9, 0x1.b726a353622e4p-1023,  -0x1.0efcf2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6248e219652f6p+9, 0x1.aeaba1f510a22p-1023,   0x1.b92a84p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.624b611340525p+9, 0x1.a65a8d438cc82p-1023,   -0x1.ed9a7p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.624de00d1b754p+9, 0x1.9e3295fc5394cp-1023,  -0x1.ac6306p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62505f06f6983p+9, 0x1.9632f0dd80514p-1023,  -0x1.cf4c8ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6252de00d1bb2p+9, 0x1.8e5ad6920342ep-1023,  -0x1.a6a76ap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.62555cfaacde1p+9,  0x1.86a9839e3a23p-1023,   -0x1.659f2p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6257dbf48801p+9, 0x1.7f1e384ce8856p-1023,   0x1.e6d7e8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.625a5aee6323fp+9, 0x1.77b8389c8e50cp-1023,   0x1.0dcb74p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.625cd9e83e46ep+9, 0x1.7076cc2d1a7b8p-1023,  -0x1.1c5296p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.625f58e21969dp+9, 0x1.69593e2df8414p-1023,  -0x1.ee5904p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6261d7dbf48ccp+9, 0x1.625edd4c7513ep-1023,   -0x1.085e5p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.626456d5cfafbp+9,  0x1.5b86fba27d91p-1023,  -0x1.9ed6b8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6266d5cfaad2ap+9, 0x1.54d0eea5afcd8p-1023,  -0x1.2256bcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.626954c985f59p+9, 0x1.4e3c0f16c1518p-1023,     0x1.8a87p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.626bd3c361188p+9, 0x1.47c7b8f137264p-1023,  -0x1.b0a4a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.626e52bd3c3b7p+9, 0x1.41734b5b6e626p-1023,   0x1.26f61ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6270d1b7175e6p+9, 0x1.3b3e2896f3a2cp-1023,  -0x1.770e74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.627350b0f2815p+9, 0x1.3527b5f127ee8p-1023,    0x1.7ba95p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6275cfaacda44p+9, 0x1.2f2f5bb43182ep-1023,  -0x1.971acep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62784ea4a8c73p+9,  0x1.295485183714p-1023,   0x1.de4a92p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.627acd9e83ea2p+9, 0x1.2396a034e40dcp-1023,  -0x1.1138b2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.627d4c985f0d1p+9, 0x1.1df51df334714p-1023,  -0x1.5e4764p-2, INEXACT|UNDERFLOW)
T(RN,     -0x1.627fcb923a3p+9, 0x1.186f71ff86e7cp-1023,   0x1.b2cf22p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62824a8c1552fp+9, 0x1.130512bbf3b32p-1023,   0x1.98ed6ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6284c985f075ep+9,  0x1.0db57932e727p-1023,  -0x1.746752p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6287487fcb98dp+9, 0x1.08802109fe5bep-1023,   0x1.dfeda6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6289c779a6bbcp+9, 0x1.0364887524d44p-1023,   0x1.c764c2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.628c467381debp+9,  0x1.fcc46053e3abp-1024,   0x1.27f13cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.628ec56d5d01ap+9, 0x1.f2f136a6886c8p-1024,  -0x1.2c0374p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6291446738249p+9, 0x1.e94e9f0a36df4p-1024,   0x1.07357ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6293c36113478p+9, 0x1.dfdba96159828p-1024,  -0x1.7cd754p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6296425aee6a7p+9, 0x1.d6976a3166818p-1024,   0x1.ddeac4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6298c154c98d6p+9, 0x1.cd80fa8bf35d4p-1024,   0x1.9cf832p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.629b404ea4b05p+9, 0x1.c49777f839eccp-1024,    0x1.ac6cfp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.629dbf487fd34p+9, 0x1.bbda045d0c7d8p-1024,   0x1.288408p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62a03e425af63p+9,  0x1.b347c5eb36f2p-1024,  -0x1.dc293ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62a2bd3c36192p+9, 0x1.aadfe7084ac3cp-1024,  -0x1.7c4ac4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.62a53c36113c1p+9, 0x1.a2a19639d3d4cp-1024,  -0x1.f47448p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.62a7bb2fec5fp+9,   0x1.9a8c0610f41p-1024,  -0x1.63170ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.62aa3a29c781fp+9, 0x1.929e6d1663d74p-1024,  -0x1.ef5a5ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62acb923a2a4ep+9, 0x1.8ad805b6d54fcp-1024,   -0x1.0c88dp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.62af381d7dc7dp+9,  0x1.83380e2fb8a2p-1024,   0x1.4ad9cap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62b1b71758eacp+9,   0x1.7bbdc87c5f5p-1024,   0x1.d2d7a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62b43611340dbp+9, 0x1.74687a437cca4p-1024,  -0x1.95bdacp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.62b6b50b0f30ap+9, 0x1.6d376cc502774p-1024,  -0x1.2ee3c2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62b93404ea539p+9, 0x1.6629ecc855688p-1024,   0x1.8ab922p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62bbb2fec5768p+9,  0x1.5f3f4a8adc02p-1024,  -0x1.62448cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.62be31f8a0997p+9, 0x1.5876d9aee1e44p-1024,   0x1.97ab24p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62c0b0f27bbc6p+9, 0x1.51cff12ad067cp-1024,  -0x1.667378p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.62c32fec56df5p+9, 0x1.4b49eb38ba104p-1024,  -0x1.3a3e54p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62c5aee632024p+9, 0x1.44e4254637564p-1024,   0x1.d5ec3ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.62c82de00d253p+9, 0x1.3e9dffe49338cp-1024,    0x1.12c3ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62caacd9e8482p+9, 0x1.3876deb9460c8p-1024,   0x1.4f851ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62cd2bd3c36b1p+9, 0x1.326e286ebd044p-1024,  -0x1.1210b8p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.62cfaacd9e8ep+9,  0x1.2c8346a56cf9p-1024,   0x1.b4886ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62d229c779b0fp+9, 0x1.26b5a5e52efa8p-1024,   0x1.7095e4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.62d4a8c154d3ep+9, 0x1.2104b58ee5414p-1024,  -0x1.b6298ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62d727bb2ff6dp+9,  0x1.1b6fe7ce6716p-1024,  -0x1.d05342p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62d9a6b50b19cp+9, 0x1.15f6b18cb2534p-1024,  -0x1.b55ce6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.62dc25aee63cbp+9, 0x1.10988a6261288p-1024,   0x1.61ec62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62dea4a8c15fap+9, 0x1.0b54ec8a62cccp-1024,   0x1.714a56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62e123a29c829p+9, 0x1.062b54d4f5d6cp-1024,   0x1.f0e66ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.62e3a29c77a58p+9,  0x1.011b429ae2f5p-1024,   0x1.fd77c4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62e6219652c87p+9, 0x1.f8486f61ed8e8p-1025,  -0x1.088cdcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62e8a0902deb6p+9,  0x1.ee8b70b77349p-1025,   0x1.a6ced6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.62eb1f8a090e5p+9, 0x1.e4fe9686c82a8p-1025,  -0x1.aa8b02p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62ed9e83e4314p+9,  0x1.dba0f2d01dbbp-1025,  -0x1.f193d2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62f01d7dbf543p+9, 0x1.d2719c2c3ad28p-1025,   0x1.d5b018p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62f29c779a772p+9, 0x1.c96fadb5c2fc8p-1025,   0x1.9067cap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.62f51b71759a1p+9,  0x1.c09a46f2ee33p-1025,   0x1.eece0ap-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.62f79a6b50bdp+9,  0x1.b7f08bbfaebbp-1025,  -0x1.f759eap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62fa19652bdffp+9, 0x1.af71a438430e8p-1025,   0x1.dd69aap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.62fc985f0702ep+9,  0x1.a71cbca431b1p-1025,    0x1.2f1f6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.62ff1758e225dp+9,  0x1.9ef10561acf1p-1025,    0x1.a3f04p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63019652bd48cp+9,  0x1.96edb2d15c88p-1025,   0x1.c09854p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6304154c986bbp+9,  0x1.8f11fd428b29p-1025,   0x1.07567ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63069446738eap+9,  0x1.875d20dfb60dp-1025,    0x1.1647fp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.630913404eb19p+9, 0x1.7fce5d9b7c988p-1025,  -0x1.f66a42p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.630b923a29d48p+9,  0x1.7864f71dee42p-1025,   0x1.50d3cap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.630e113404f77p+9,   0x1.712034b234ep-1025,  -0x1.7f1518p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6310902de01a6p+9, 0x1.69ff613499a38p-1025,   0x1.b9971ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63130f27bb3d5p+9, 0x1.6301cb00e2ec8p-1025,   0x1.3bd8dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63158e2196604p+9,  0x1.5c26c3e10953p-1025,  -0x1.32df56p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63180d1b71833p+9,  0x1.556da0fc4229p-1025,   0x1.7c24a4p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.631a8c154ca62p+9, 0x1.4ed5bac65dd38p-1025,  -0x1.579244p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.631d0b0f27c91p+9, 0x1.485e6cef785d8p-1025,  -0x1.ac01c8p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.631f8a0902ecp+9, 0x1.42071653faac8p-1025,   0x1.37965cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63220902de0efp+9, 0x1.3bcf18eceac58p-1025,   0x1.d3be66p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.632487fcb931ep+9, 0x1.35b5d9c089a28p-1025,  -0x1.55a946p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.632706f69454dp+9,  0x1.2fbac0d33d13p-1025,  -0x1.da7776p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.632985f06f77cp+9, 0x1.29dd3918c42f8p-1025,   0x1.851b54p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.632c04ea4a9abp+9,  0x1.241cb065b4f4p-1025,  -0x1.966bd4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.632e83e425bdap+9,  0x1.1e7897614196p-1025,   0x1.5ce54ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.633102de00e09p+9,  0x1.18f06177442dp-1025,    0x1.6b3a4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.633381d7dc038p+9,  0x1.138384ca8f5fp-1025,   0x1.80d152p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.633600d1b7267p+9,  0x1.0e317a2782aep-1025,  -0x1.74e7aap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.63387fcb92496p+9,  0x1.08f9bcf6e122p-1025,   0x1.2a3f26p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.633afec56d6c5p+9, 0x1.03dbcb30e9018p-1025,   0x1.d5b464p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.633d7dbf488f4p+9,  0x1.fdae4aa156b5p-1026,   0x1.fd50b6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.633ffcb923b23p+9,  0x1.f3d69c8f443fp-1026,  -0x1.06c978p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63427bb2fed52p+9,  0x1.ea2f96e30744p-1026,  -0x1.c16ccap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6344faacd9f81p+9,  0x1.e0b84910a478p-1026,   0x1.330442p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.634779a6b51bp+9,  0x1.d76fc7314dfcp-1026,   0x1.fc1188p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6349f8a0903dfp+9,  0x1.ce5529ec6c84p-1026,  -0x1.c629a4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.634c779a6b60ep+9,  0x1.c5678e6119fep-1026,  -0x1.268cbap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.634ef6944683dp+9,  0x1.bca616100b8fp-1026,  -0x1.9981a6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6351758e21a6cp+9,  0x1.b40fe6c5e8c2p-1026,   0x1.a30a74p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6353f487fcc9bp+9,  0x1.aba42a860dc8p-1026,   0x1.a2b396p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63567381d7ecap+9,  0x1.a3620f75b6bfp-1026,  -0x1.c08c2cp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6358f27bb30f9p+9,  0x1.9b48c7c791eep-1026,   0x1.6c99d4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.635b71758e328p+9,  0x1.935789a7b702p-1026,   0x1.c7668ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.635df06f69557p+9,  0x1.8b8d8f280156p-1026,   0x1.3fdff2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63606f6944786p+9,  0x1.83ea162ccb5dp-1026,  -0x1.26bd22p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6362ee631f9b5p+9,  0x1.7c6c605a094bp-1026,  -0x1.f1faaep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63656d5cfabe4p+9,  0x1.7513b300c128p-1026,   0x1.791a14p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6367ec56d5e13p+9,  0x1.6ddf570cde7fp-1026,  -0x1.70cc9ap-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.636a6b50b1042p+9,  0x1.66ce98f35feap-1026,  -0x1.e15968p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.636cea4a8c271p+9,   0x1.5fe0c8a0dcbp-1026,  -0x1.110094p-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.636f6944674ap+9,  0x1.5915396860d1p-1026,  -0x1.d73988p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6371e83e426cfp+9,  0x1.526b41f29dcfp-1026,    0x1.3ec54p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.637467381d8fep+9,  0x1.4be23c2d6e88p-1026,  -0x1.825634p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6376e631f8b2dp+9,  0x1.4579853bac9fp-1026,   0x1.03fb68p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6379652bd3d5cp+9,  0x1.3f307d6555bdp-1026,   0x1.4ed014p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.637be425aef8bp+9,  0x1.39068807ff44p-1026,   0x1.97b8c8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.637e631f8a1bap+9,  0x1.32fb0b8796d5p-1026,   0x1.d1225cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6380e219653e9p+9,  0x1.2d0d713f6e3cp-1026,   0x1.b7a07cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6383611340618p+9,  0x1.273d25739146p-1026,   0x1.4b9e64p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6385e00d1b847p+9,  0x1.218997426418p-1026,   -0x1.8b208p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63885f06f6a76p+9,  0x1.1bf23896889fp-1026,  -0x1.d83432p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.638ade00d1ca5p+9,  0x1.16767e1909b8p-1026,  -0x1.e12ea2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.638d5cfaaced4p+9,  0x1.1115df23cab8p-1026,  -0x1.7eebbep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.638fdbf488103p+9,  0x1.0bcfd5b43a07p-1026,   0x1.69da4ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63925aee63332p+9,  0x1.06a3de5e4577p-1026,  -0x1.386336p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6394d9e83e561p+9,  0x1.0191783f8f21p-1026,  -0x1.484ffep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.639758e21979p+9,  0x1.f93049e5c2f8p-1027,   0x1.dc18d8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6399d7dbf49bfp+9,   0x1.ef6ed107c2fp-1027,   0x1.cfde4ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.639c56d5cfbeep+9,  0x1.e5dd92c5faeep-1027,   0x1.1ca8d6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.639ed5cfaae1dp+9,  0x1.dc7ba0b32fc4p-1027,  -0x1.61c8bcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63a154c98604cp+9,  0x1.d34810fcd88cp-1027,   0x1.4693bep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63a3d3c36127bp+9,  0x1.ca41fe545b92p-1027,  -0x1.ffc466p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.63a652bd3c4aap+9,  0x1.c16887d8bbd8p-1027,   -0x1.ed7b7p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63a8d1b7176d9p+9,  0x1.b8bad100b4e2p-1027,  -0x1.c63934p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63ab50b0f2908p+9,  0x1.b038018542c4p-1027,  -0x1.c2f2d8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63adcfaacdb37p+9,  0x1.a7df454c9454p-1027,  -0x1.e8054ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63b04ea4a8d66p+9,  0x1.9fafcc556568p-1027,  -0x1.29b38ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63b2cd9e83f95p+9,  0x1.97a8caa2bf34p-1027,  -0x1.b28748p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63b54c985f1c4p+9,  0x1.8fc978281cb6p-1027,   0x1.188d2ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63b7cb923a3f3p+9,  0x1.881110b5f152p-1027,  -0x1.7a1cbap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63ba4a8c15622p+9,  0x1.807ed3e68fbap-1027,   0x1.ef1d7ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63bcc985f0851p+9,  0x1.7912050b6f32p-1027,   0x1.c49128p-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.63bf487fcba8p+9,  0x1.71c9eb1acd7ap-1027,  -0x1.f95d8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63c1c779a6cafp+9,   0x1.6aa5d09dab8p-1027,  -0x1.24bb54p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63c4467381edep+9,  0x1.63a5039e2316p-1027,   0x1.baf0b8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63c6c56d5d10dp+9,  0x1.5cc6d596140ap-1027,  -0x1.a1283ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63c944673833cp+9,   0x1.560a9b5e26ep-1027,  -0x1.cf978cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63cbc3611356bp+9,   0x1.4f6fad1d238p-1027,  -0x1.b9cd92p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.63ce425aee79ap+9,  0x1.48f566379a4ap-1027,   0x1.c88da6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63d0c154c99c9p+9,   0x1.429b253fddfp-1027,   0x1.e7702ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63d3404ea4bf8p+9,  0x1.3c604be64c88p-1027,   0x1.5086f6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63d5bf487fe27p+9,  0x1.36443ee9e64ep-1027,   0x1.8fd7f2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63d83e425b056p+9,  0x1.30466609308ep-1027,    0x1.2710cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63dabd3c36285p+9,  0x1.2a662bf36354p-1027,   0x1.cee25cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63dd3c36114b4p+9,  0x1.24a2fe39e054p-1027,   0x1.bf0606p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63dfbb2fec6e3p+9,  0x1.1efc4d41f1b6p-1027,  -0x1.f6d1bap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.63e23a29c7912p+9,  0x1.19718c36cf5ap-1027,   -0x1.1f21ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63e4b923a2b41p+9,  0x1.140230fbe932p-1027,   0x1.6c0f04p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.63e7381d7dd7p+9,  0x1.0eadb41f7564p-1027,  -0x1.354aeap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63e9b71758f9fp+9,  0x1.097390cd40f2p-1027,   0x1.eb33dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63ec3611341cep+9,  0x1.045344c1c172p-1027,   0x1.cd8fd4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63eeb50b0f3fdp+9,  0x1.fe98a07acda8p-1028,   0x1.bbf13ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.63f13404ea62cp+9,  0x1.f4bc6bf05788p-1028,   0x1.89a5ccp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.63f3b2fec585bp+9,  0x1.eb10f62ac714p-1028,   0x1.08a332p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.63f631f8a0a8ap+9,   0x1.e1954e2f887p-1028,  -0x1.07e54cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63f8b0f27bcb9p+9,  0x1.d84887ab57f4p-1028,   0x1.ef00bap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.63fb2fec56ee8p+9,   0x1.cf29badb40bp-1028,   0x1.38824cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.63fdaee632117p+9,  0x1.c63804760cc8p-1028,  -0x1.e48d56p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.64002de00d346p+9,  0x1.bd7285962548p-1028,   -0x1.5349ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6402acd9e8575p+9,  0x1.b4d863a3df5cp-1028,   0x1.9bbfd4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64052bd3c37a4p+9,   0x1.ac68c84034cp-1028,   0x1.e53342p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6407aacd9e9d3p+9,  0x1.a422e12fe588p-1028,  -0x1.b7b45ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.640a29c779c02p+9,  0x1.9c05e04700ecp-1028,   0x1.3c8882p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.640ca8c154e31p+9,  0x1.9410fb54d348p-1028,  -0x1.f43046p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.640f27bb3006p+9,   0x1.8c436c10377p-1028,  -0x1.6ee7c4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6411a6b50b28fp+9,  0x1.849c7004492cp-1028,   0x1.530c28p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.641425aee64bep+9,   0x1.7d1b487d773p-1028,  -0x1.b3c786p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6416a4a8c16edp+9,  0x1.75bf3a76f2bcp-1028,   0x1.583672p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.641923a29c91cp+9,   0x1.6e878e887aep-1028,   0x1.aa84c2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.641ba29c77b4bp+9,  0x1.677390d481d4p-1028,  -0x1.c9e3b4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.641e219652d7ap+9,  0x1.608290f6aaa4p-1028,  -0x1.e423f2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6420a0902dfa9p+9,  0x1.59b3e1f29d3cp-1028,   -0x1.2ab13p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64231f8a091d8p+9,  0x1.5306da232f8cp-1028,   0x1.65b224p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64259e83e4407p+9,   0x1.4c7ad329e1cp-1028,  -0x1.5eff16p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.64281d7dbf636p+9,  0x1.460f29deac48p-1028,  -0x1.a1d8bap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.642a9c779a865p+9,  0x1.3fc33e401dc8p-1028,   0x1.297f0ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.642d1b7175a94p+9,  0x1.39967363c79cp-1028,     0x1.06e4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.642f9a6b50cc3p+9,  0x1.33882f66f76cp-1028,  -0x1.495c96p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.643219652bef2p+9,   0x1.2d97db5fbc3p-1028,    0x1.ea88fp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6434985f07121p+9,   0x1.27c4e34e354p-1028,  -0x1.dc0cbcp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.64371758e235p+9,  0x1.220eb60e2a24p-1028,   0x1.4bc3f2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.64399652bd57fp+9,  0x1.1c74c548e96cp-1028,    0x1.798bap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.643c154c987aep+9,   0x1.16f685676d9p-1028,   0x1.d62d5cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.643e9446739ddp+9,  0x1.11936d84c634p-1028,  -0x1.4dbd7cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.644113404ec0cp+9,   0x1.0c4af760c4bp-1028,   0x1.6a0dc2p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6443923a29e3bp+9,  0x1.071c9f52ea54p-1028,   0x1.ae4242p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.644611340506ap+9,  0x1.0207e43d976cp-1028,  -0x1.539bc4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6448902de0299p+9,   0x1.fa188f02f34p-1029,    -0x1.9791p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.644b0f27bb4c8p+9,  0x1.f05299e270a8p-1029,    0x1.654fap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.644d8e21966f7p+9,  0x1.e6bcf58abc28p-1029,  -0x1.d29b44p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64500d1b71926p+9,   0x1.dd56b320fbap-1029,   0x1.c46924p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64528c154cb55p+9,    0x1.d41ee86725p-1029,  -0x1.fa6caap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64550b0f27d84p+9,  0x1.cb14afa53108p-1029,  -0x1.2c6c6ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64578a0902fb3p+9,  0x1.c2372792be48p-1029,   0x1.d7229cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.645a0902de1e2p+9,  0x1.b985734122e8p-1029,   -0x1.b233ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.645c87fcb9411p+9,   0x1.b0feba05eb1p-1029,   0x1.3d52cap-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.645f06f69464p+9,   0x1.a8a22765c11p-1029,   0x1.214cfcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.646185f06f86fp+9,  0x1.a06eeaffbe68p-1029,  -0x1.fe5ef4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.646404ea4aa9ep+9,   0x1.9864387922cp-1029,  -0x1.5707f8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.646683e425ccdp+9,  0x1.908147696f28p-1029,  -0x1.311cdcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.646902de00efcp+9,   0x1.88c55346e3dp-1029,   0x1.f48832p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.646b81d7dc12bp+9,   0x1.812f9b535e1p-1029,   0x1.40819ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.646e00d1b735ap+9,  0x1.79bf62899538p-1029,   0x1.a3a6f8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64707fcb92589p+9,  0x1.7273ef8ab3d8p-1029,  -0x1.678f9ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6472fec56d7b8p+9,   0x1.6b4c8c8c4c6p-1029,   0x1.1db244p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64757dbf489e7p+9,  0x1.64488746a678p-1029,   0x1.c74e58p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6477fcb923c16p+9,   0x1.5d6730e3646p-1029,   0x1.db4416p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.647a7bb2fee45p+9,   0x1.56a7ddec7dap-1029,   0x1.5ed518p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.647cfaacda074p+9,   0x1.5009e63b8e4p-1029,  -0x1.5bd406p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.647f79a6b52a3p+9,  0x1.498ca4e97838p-1029,  -0x1.992eccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6481f8a0904d2p+9,    0x1.432f783e56p-1029,   0x1.44072cp-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6484779a6b701p+9,   0x1.3cf1c1a1bc5p-1029,   0x1.4fe176p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6486f6944693p+9,  0x1.36d2e58b49d8p-1029,  -0x1.3a691ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6489758e21b5fp+9,  0x1.30d24b738358p-1029,   0x1.e0652ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.648bf487fcd8ep+9,  0x1.2aef5dc4fa38p-1029,   0x1.4718e4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.648e7381d7fbdp+9,  0x1.252989cdbd08p-1029,   0x1.53354ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6490f27bb31ecp+9,   0x1.1f803fb10f9p-1029,  -0x1.c58b28p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.649371758e41bp+9,   0x1.19f2f25969dp-1029,    0x1.d1256p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6495f06f6964ap+9,  0x1.1481176abbc8p-1029,  -0x1.33bfd8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64986f6944879p+9,  0x1.0f2a2734f5c8p-1029,   0x1.b4dca2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.649aee631faa8p+9,   0x1.09ed9ca6d2bp-1029,    0x1.914f4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.649d6d5cfacd7p+9,   0x1.04caf540e3fp-1029,  -0x1.ad99dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.649fec56d5f06p+9,   0x1.ff836211baep-1030,  -0x1.bd4e8cp-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.64a26b50b1135p+9,   0x1.f5a2a4fa403p-1030,   -0x1.b1356p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.64a4ea4a8c364p+9,   0x1.ebf2bd11048p-1030,   0x1.1c385ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64a7694467593p+9,   0x1.e272b8eca88p-1030,  -0x1.82b95ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64a9e83e427c2p+9,   0x1.d921abcd40fp-1030,  -0x1.1b4b72p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.64ac67381d9f1p+9,   0x1.cffead854a5p-1030,    0x1.45a3dp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.64aee631f8c2p+9,    0x1.c708da630fp-1030,   0x1.1ca644p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64b1652bd3e4fp+9,   0x1.be3f531a7cfp-1030,   0x1.ee6642p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64b3e425af07ep+9,   0x1.b5a13caf68bp-1030,  -0x1.b85604p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64b6631f8a2adp+9,   0x1.ad2dc0603c8p-1030,   -0x1.7a18ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.64b8e219654dcp+9,   0x1.a4e40b910ffp-1030,   0x1.e1b634p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.64bb61134070bp+9,   0x1.9cc34fb727ap-1030,  -0x1.6e80e4p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.64bde00d1b93ap+9,    0x1.94cac244dap-1030,  -0x1.72ce0ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64c05f06f6b69p+9,   0x1.8cf99c95d79p-1030,   0x1.ddade2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64c2de00d1d98p+9,   0x1.854f1bdbd44p-1030,   0x1.e52cfap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64c55cfaacfc7p+9,   0x1.7dca810b912p-1030,   -0x1.cb64cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64c7dbf4881f6p+9,   0x1.766b10ca433p-1030,  -0x1.91d7fap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64ca5aee63425p+9,   0x1.6f30135b565p-1030,  -0x1.bdb136p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64ccd9e83e654p+9,   0x1.6818d48e8a7p-1030,  -0x1.dbfdf6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64cf58e219883p+9,   0x1.6124a3ae691p-1030,  -0x1.50dbccp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64d1d7dbf4ab2p+9,   0x1.5a52d36f119p-1030,   -0x1.67642p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64d456d5cfce1p+9,   0x1.53a2b9dd5a9p-1030,   0x1.d29a5ep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.64d6d5cfaaf1p+9,   0x1.4d13b04e465p-1030,  -0x1.9dabfep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64d954c98613fp+9,   0x1.46a5134ec9cp-1030,  -0x1.872686p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64dbd3c36136ep+9,   0x1.40564293e2bp-1030,   0x1.9acd9ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.64de52bd3c59dp+9,   0x1.3a26a0eafd5p-1030,  -0x1.88b182p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64e0d1b7177ccp+9,   0x1.3415942aa6fp-1030,   0x1.94ea34p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64e350b0f29fbp+9,   0x1.2e2285238bcp-1030,   0x1.7d6b22p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64e5cfaacdc2ap+9,   0x1.284cdf91bf7p-1030,  -0x1.5e2928p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.64e84ea4a8e59p+9,   0x1.2294120e4e5p-1030,   0x1.578004p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64eacd9e84088p+9,   0x1.1cf78e01158p-1030,  -0x1.c1dad8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64ed4c985f2b7p+9,   0x1.1776c792e1bp-1030,  -0x1.3f0b22p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64efcb923a4e6p+9,   0x1.1211359fd1fp-1030,   0x1.eb0c76p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.64f24a8c15715p+9,   0x1.0cc651a9fe2p-1030,   0x1.0c21cep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64f4c985f0944p+9,   0x1.079597cc5f5p-1030,   0x1.709732p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64f7487fcbb73p+9,   0x1.027e86adf8cp-1030,  -0x1.ad7c4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.64f9c779a6da2p+9,   0x1.fb013eea814p-1031,   0x1.9bd456p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.64fc467381fd1p+9,   0x1.f136cb778cep-1031,  -0x1.4dd9a8p-2, INEXACT|UNDERFLOW)
T(RN,     -0x1.64fec56d5d2p+9,   0x1.e79cbf042ecp-1031,  -0x1.3941ecp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.650144673842fp+9,   0x1.de322a47bb2p-1031,  -0x1.7d24bcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6503c3611365ep+9,   0x1.d4f6229875ap-1031,   0x1.a949d6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6506425aee88dp+9,   0x1.cbe7c1d4b8ap-1031,   0x1.d8ecd8p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6508c154c9abcp+9,   0x1.c306264c8eep-1031,  -0x1.eb7feap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.650b404ea4cebp+9,   0x1.ba5072abbacp-1031,   0x1.67120ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.650dbf487ff1ap+9,   0x1.b1c5cde42a6p-1031,  -0x1.d8bf3cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65103e425b149p+9,   0x1.a9656318d72p-1031,   0x1.f54d2ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6512bd3c36378p+9,   0x1.a12e61890bep-1031,  -0x1.3e9be4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65153c36115a7p+9,   0x1.991ffc7c13cp-1031,  -0x1.28b238p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6517bb2fec7d6p+9,   0x1.91396b2d4bap-1031,   0x1.6a83a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.651a3a29c7a05p+9,   0x1.8979e8b896ep-1031,   0x1.eb6d72p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.651cb923a2c34p+9,   0x1.81e0b40734ep-1031,  -0x1.4d13f8p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.651f381d7de63p+9,   0x1.7a6d0fbcf52p-1031,  -0x1.19577ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6521b71759092p+9,    0x1.731e4225c8p-1031,  -0x1.482b24p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65243611342c1p+9,   0x1.6bf39523aaep-1031,  -0x1.b1a19cp-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6526b50b0f4fp+9,   0x1.64ec561cedcp-1031,  -0x1.f3e754p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65293404ea71fp+9,   0x1.5e07d5ead08p-1031,    0x1.a522fp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.652bb2fec594ep+9,   0x1.574568c8754p-1031,  -0x1.1dc026p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.652e31f8a0b7dp+9,   0x1.50a4664228ep-1031,  -0x1.cc3266p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6530b0f27bdacp+9,   0x1.4a242924fc2p-1031,  -0x1.87792cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65332fec56fdbp+9,   0x1.43c40f6eaf2p-1031,   0x1.c389a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6535aee63220ap+9,   0x1.3d837a3deb8p-1031,  -0x1.ecf626p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65382de00d439p+9,    0x1.3761cdc2cep-1031,  -0x1.cec9f8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.653aacd9e8668p+9,   0x1.315e712fba6p-1031,   0x1.411eaep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.653d2bd3c3897p+9,   0x1.2b78ceaa7bep-1031,   0x1.3c3474p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.653faacd9eac6p+9,   0x1.25b0533daeep-1031,  -0x1.a68c78p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.654229c779cf5p+9,   0x1.20046eca72cp-1031,   0x1.2ca2cap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6544a8c154f24p+9,   0x1.1a7493fa616p-1031,  -0x1.ed046ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.654727bb30153p+9,    0x1.15003831cep-1031,  -0x1.f4ba84p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6549a6b50b382p+9,   0x1.0fa6d382466p-1031,    0x1.08993p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.654c25aee65b1p+9,   0x1.0a67e09d572p-1031,   0x1.ddcd08p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.654ea4a8c17ep+9,   0x1.0542dcc791ep-1031,  -0x1.df773cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.655123a29ca0fp+9,   0x1.003747cbd3cp-1031,   0x1.25e124p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6553a29c77c3ep+9,   0x1.f68947dd928p-1032,   0x1.11b2bap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6556219652e6dp+9,   0x1.ecd4ebc5638p-1032,  -0x1.f8d14ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6558a0902e09cp+9,   0x1.e3508976bd4p-1032,   0x1.2b8c5cp-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.655b1f8a092cbp+9,   0x1.d9fb33c4da8p-1032,  -0x1.91d1b2p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.655d9e83e44fap+9,   0x1.d0d40217788p-1032,   0x1.a13d42p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65601d7dbf729p+9,   0x1.c7da1054318p-1032,  -0x1.475aeep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65629c779a958p+9,   0x1.bf0c7ec8498p-1032,   0x1.45b71ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65651b7175b87p+9,   0x1.b66a7212e64p-1032,  -0x1.2d14acp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.65679a6b50db6p+9,    0x1.adf3130fb5p-1032,   0x1.099fc6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.656a19652bfe5p+9,   0x1.a5a58ec1f88p-1032,   0x1.ddcfd2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.656c985f07214p+9,    0x1.9d81163fffp-1032,   -0x1.cc113p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.656f1758e2443p+9,   0x1.9584de9efe8p-1032,  -0x1.ba720cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65719652bd672p+9,   0x1.8db020df534p-1032,   0x1.a23c46p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6574154c988a1p+9,     0x1.860219d92p-1032,  -0x1.b15e8ep-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6576944673adp+9,   0x1.7e7a0a29504p-1032,  -0x1.b32bc4p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.657913404ecffp+9,    0x1.7717361ef5p-1032,   0x1.487818p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.657b923a29f2ep+9,      0x1.6fd8e5a9p-1032,    0x1.cf46fp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.657e11340515dp+9,    0x1.68be644459p-1032,  -0x1.9dac74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6580902de038cp+9,   0x1.61c700ea4acp-1032,  -0x1.ce2c5ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65830f27bb5bbp+9,   0x1.5af20dff47cp-1032,   0x1.26e758p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65858e21967eap+9,   0x1.543ee14202cp-1032,  -0x1.d0dbf8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65880d1b71a19p+9,   0x1.4dacd3baddcp-1032,   0x1.2a453ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.658a8c154cc48p+9,    0x1.473b41aba7p-1032,  -0x1.9a8646p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.658d0b0f27e77p+9,    0x1.40e98a7faap-1032,  -0x1.50925ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.658f8a09030a6p+9,   0x1.3ab710bc0ccp-1032,   0x1.40676ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65920902de2d5p+9,   0x1.34a339f07b4p-1032,   0x1.866f1ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.659487fcb9504p+9,   0x1.2ead6ea81f4p-1032,   0x1.112662p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.659706f694733p+9,   0x1.28d51a5ae18p-1032,  -0x1.396a72p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.659985f06f962p+9,   0x1.2319ab5ef48p-1032,   0x1.737f12p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.659c04ea4ab91p+9,   0x1.1d7a92daa5cp-1032,   0x1.f0ceeep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.659e83e425dcp+9,   0x1.17f744b6768p-1032,   0x1.1acb96p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65a102de00fefp+9,   0x1.128f378f788p-1032,   0x1.c47da2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65a381d7dc21ep+9,   0x1.0d41e4a9ed8p-1032,   -0x1.9bf02p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65a600d1b744dp+9,    0x1.080ec7e42bp-1032,  -0x1.96468ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65a87fcb9267cp+9,   0x1.02f55fa9bb8p-1032,  -0x1.866092p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65aafec56d8abp+9,    0x1.fbea59cd86p-1033,  -0x1.97e022p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65ad7dbf48adap+9,   0x1.f21b65f73e8p-1033,   0x1.386e4ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65affcb923d09p+9,   0x1.e87cef618b8p-1033,   0x1.c7e77ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65b27bb2fef38p+9,   0x1.df0e0655bd8p-1033,   0x1.a6107ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65b4faacda167p+9,   0x1.d5cdbfbe348p-1033,   0x1.9f2f2ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65b779a6b5396p+9,    0x1.ccbb350f7cp-1033,    0x1.3c935p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65b9f8a0905c5p+9,    0x1.c3d58431dbp-1033,  -0x1.fc4768p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65bc779a6b7f4p+9,    0x1.bb1bcf6b52p-1033,   0x1.875ffcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65bef69446a23p+9,   0x1.b28d3d4a028p-1033,  -0x1.b40f4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65c1758e21c52p+9,   0x1.aa28f88f088p-1033,  -0x1.66c38ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65c3f487fce81p+9,   0x1.a1ee3019b48p-1033,   0x1.5f25e6p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.65c67381d80bp+9,    0x1.99dc16d331p-1033,   0x1.2a1972p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65c8f27bb32dfp+9,    0x1.91f1e39a8dp-1033,   0x1.441d68p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65cb71758e50ep+9,    0x1.8a2ed13125p-1033,  -0x1.382d3ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65cdf06f6973dp+9,   0x1.82921e27728p-1033,  -0x1.a23316p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65d06f694496cp+9,   0x1.7b1b0cca348p-1033,  -0x1.ee5944p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65d2ee631fb9bp+9,   0x1.73c8e30ffa8p-1033,   0x1.f66346p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.65d56d5cfadcap+9,    0x1.6c9aea8706p-1033,   0x1.952d5ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.65d7ec56d5ff9p+9,   0x1.65907043898p-1033,  -0x1.bd0868p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65da6b50b1228p+9,    0x1.5ea8c4ce3ep-1033,  -0x1.0e7f0cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.65dcea4a8c457p+9,    0x1.57e33c134cp-1033,  -0x1.09a3e4p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65df694467686p+9,   0x1.513f2d518d8p-1033,   0x1.3ca898p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65e1e83e428b5p+9,    0x1.4abbf30a1fp-1033,   0x1.f9cc56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65e467381dae4p+9,   0x1.4458eaf0438p-1033,  -0x1.dc79cap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65e6e631f8d13p+9,    0x1.3e1575d99ap-1033,   0x1.c0e8fcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65e9652bd3f42p+9,   0x1.37f0f7ae9a8p-1033,   0x1.8bf142p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65ebe425af171p+9,    0x1.31ead75b68p-1033,  -0x1.374f24p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.65ee631f8a3ap+9,   0x1.2c027ec0e88p-1033,  -0x1.0870aep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65f0e219655cfp+9,    0x1.26375aa627p-1033,   0x1.5b3944p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.65f36113407fep+9,   0x1.2088daa9ff8p-1033,   0x1.65223ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.65f5e00d1ba2dp+9,   0x1.1af67135108p-1033,  -0x1.e8ff18p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.65f85f06f6c5cp+9,    0x1.157f936bf3p-1033,  -0x1.ea6a36p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65fade00d1e8bp+9,    0x1.1023b921b6p-1033,   0x1.f8bef6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65fd5cfaad0bap+9,   0x1.0ae25cca9a8p-1033,  -0x1.3852f4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.65ffdbf4882e9p+9,   0x1.05bafb6f188p-1033,   0x1.87d9c6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66025aee63518p+9,   0x1.00ad149f198p-1033,  -0x1.2b4dcep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6604d9e83e747p+9,    0x1.f77054caf9p-1034,   0x1.89a76ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.660758e219976p+9,    0x1.edb782779ep-1034,  -0x1.f6ac5cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6609d7dbf4ba5p+9,    0x1.e42ebffc95p-1034,   0x1.7c5e1ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.660c56d5cfdd4p+9,    0x1.dad51fc00bp-1034,   -0x1.33fadp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.660ed5cfab003p+9,    0x1.d1a9b8becfp-1034,   0x1.28909cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.661154c986232p+9,    0x1.c8aba6759ap-1034,   0x1.d73ff2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6613d3c361461p+9,    0x1.bfda08cad6p-1034,    0x1.cb192p-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.661652bd3c69p+9,    0x1.b73403f8cdp-1034,     0x1.2427p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6618d1b7178bfp+9,    0x1.aeb8c07841p-1034,  -0x1.4057c4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.661b50b0f2aeep+9,    0x1.a6676aeb74p-1034,  -0x1.3eebeap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.661dcfaacdd1dp+9,    0x1.9e3f340992p-1034,   -0x1.76aedp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66204ea4a8f4cp+9,    0x1.963f508a86p-1034,  -0x1.e6a28ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6622cd9e8417bp+9,    0x1.8e66f9132ep-1034,   0x1.fc369ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66254c985f3aap+9,    0x1.86b56a21f1p-1034,  -0x1.c9b9fap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6627cb923a5d9p+9,    0x1.7f29e3fbbfp-1034,   0x1.6fa6c6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.662a4a8c15808p+9,    0x1.77c3aa995bp-1034,    0x1.2854ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.662cc985f0a37p+9,    0x1.7082059517p-1034,  -0x1.dafda2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.662f487fcbc66p+9,    0x1.69644018ddp-1034,   0x1.9f37b8p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6631c779a6e95p+9,    0x1.6269a8cc93p-1034,   0x1.7d0608p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66344673820c4p+9,    0x1.5b9191c4d9p-1034,   0x1.e5bec8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6636c56d5d2f3p+9,    0x1.54db50721cp-1034,   0x1.fca6d8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6639446738522p+9,    0x1.4e463d8ff8p-1034,  -0x1.0b7738p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.663bc36113751p+9,    0x1.47d1b514f5p-1034,   0x1.8695bcp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.663e425aee98p+9,    0x1.417d162288p-1034,   0x1.3c93fcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6640c154c9bafp+9,     0x1.3b47c2f57p-1034,   0x1.6e538cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6643404ea4ddep+9,    0x1.353120d658p-1034,   0x1.64c886p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6645bf488000dp+9,    0x1.2f38980ac6p-1034,  -0x1.5659a6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66483e425b23cp+9,    0x1.295d93c65ap-1034,  -0x1.520234p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.664abd3c3646bp+9,    0x1.239f821c4dp-1034,  -0x1.ceab06p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.664d3c361169ap+9,    0x1.1dfdd3f13fp-1034,  -0x1.4be21ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.664fbb2fec8c9p+9,    0x1.1877fced48p-1034,   -0x1.f0b26p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66523a29c7af8p+9,     0x1.130d736e5p-1034,  -0x1.15793cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6654b923a2d27p+9,    0x1.0dbdb07aa6p-1034,  -0x1.8e047ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6657381d7df56p+9,     0x1.08882fb3ep-1034,   0x1.9b5462p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6659b71759185p+9,    0x1.036c6f49f4p-1034,   0x1.825948p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.665c3611343b4p+9,    0x1.fcd3dfdd32p-1035,  -0x1.4d4782p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.665eb50b0f5e3p+9,    0x1.f3006991c2p-1035,   0x1.488e28p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66613404ea812p+9,     0x1.e95d86d22p-1035,   0x1.8fe9f4p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.6663b2fec5a41p+9,    0x1.dfea477968p-1035,   0x1.fdd346p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.666631f8a0c7p+9,     0x1.d6a5c005ep-1035,  -0x1.1b878ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6668b0f27be9fp+9,    0x1.cd8f09821ap-1035,   0x1.79b308p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.666b2fec570cep+9,    0x1.c4a5416e64p-1035,  -0x1.bb8318p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.666daee6322fdp+9,    0x1.bbe789aad2p-1035,   0x1.510e44p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66702de00d52cp+9,    0x1.b35508618ap-1035,   0x1.fa497cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6672acd9e875bp+9,    0x1.aaece7f19ap-1035,  -0x1.386326p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66752bd3c398ap+9,     0x1.a2ae56da3p-1035,  -0x1.8a328ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6677aacd9ebb9p+9,    0x1.9a9887a62cp-1035,   0x1.41a87cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.667a29c779de8p+9,     0x1.92aab0d82p-1035,   0x1.34095cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.667ca8c155017p+9,    0x1.8ae40cd6bcp-1035,    0x1.b9a47p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.667f27bb30246p+9,    0x1.8343d9d986p-1035,  -0x1.adf0aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6681a6b50b475p+9,    0x1.7bc959d60ap-1035,  -0x1.f3bf14p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.668425aee66a4p+9,    0x1.7473d26d4cp-1035,  -0x1.3ef9d2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6686a4a8c18d3p+9,    0x1.6d428cd9acp-1035,  -0x1.1fd10ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.668923a29cb02p+9,    0x1.6634d5dd1ap-1035,  -0x1.5cd8a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.668ba29c77d31p+9,    0x1.5f49fdafa2p-1035,   -0x1.b36cep-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.668e219652f6p+9,     0x1.588157ee5p-1035,   0x1.7fd748p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6690a0902e18fp+9,    0x1.51da3b8a64p-1035,  -0x1.2cc2d8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66931f8a093bep+9,    0x1.4b5402b8e8p-1035,   0x1.5f2804p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66959e83e45edp+9,    0x1.44ee0ae27cp-1035,  -0x1.fbd2d4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66981d7dbf81cp+9,    0x1.3ea7b49396p-1035,   0x1.f7c28ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.669a9c779aa4bp+9,    0x1.3880636ce4p-1035,  -0x1.add1e6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.669d1b7175c7ap+9,    0x1.32777e142cp-1035,   -0x1.4c90bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.669f9a6b50ea9p+9,    0x1.2c8c6e254ep-1035,   0x1.c0944ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.66a219652c0d8p+9,    0x1.26bea023a4p-1035,   0x1.9e37acp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66a4985f07307p+9,    0x1.210d836ba6p-1035,  -0x1.ed5ca4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66a71758e2536p+9,    0x1.1b788a24dep-1035,   -0x1.dae04p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66a99652bd765p+9,    0x1.15ff29340ap-1035,  -0x1.c05974p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66ac154c98994p+9,    0x1.10a0d82d9ep-1035,  -0x1.52bb3ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66ae944673bc3p+9,    0x1.0b5d114876p-1035,    0x1.27f19p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.66b113404edf2p+9,     0x1.06335150dp-1035,  -0x1.324cfcp-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.66b3923a2a021p+9,    0x1.0123179b8ap-1035,  -0x1.0be6a8p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.66b611340525p+9,    0x1.f857cbf334p-1036,  -0x1.ddf562p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.66b8902de047fp+9,    0x1.ee9a815784p-1036,  -0x1.c5770ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.66bb0f27bb6aep+9,    0x1.e50d5cad14p-1036,   0x1.ccc2dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66bd8e21968ddp+9,     0x1.dbaf6fecdp-1036,   0x1.ed868ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66c00d1b71b0cp+9,    0x1.d27fd1a864p-1036,  -0x1.a302d6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66c28c154cd3bp+9,     0x1.c97d9cf38p-1036,  -0x1.169cd6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66c50b0f27f6ap+9,     0x1.c0a7f14d8p-1036,  -0x1.31f01cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66c78a0903199p+9,    0x1.b7fdf28ba4p-1036,  -0x1.210d72p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66ca0902de3c8p+9,    0x1.af7ec8c398p-1036,    0x1.85e99p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66cc87fcb95f7p+9,    0x1.a729a0366cp-1036,   0x1.06ff6ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66cf06f694826p+9,      0x1.9efda93cp-1036,   0x1.183662p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66d185f06fa55p+9,    0x1.96fa182ec8p-1036,   -0x1.f31cbp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.66d404ea4ac84p+9,    0x1.8f1e2557fcp-1036,   0x1.e6cf8ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.66d683e425eb3p+9,     0x1.87690cdc2p-1036,   0x1.649b16p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66d902de010e2p+9,    0x1.7fda0ea7f8p-1036,   0x1.1e7c3cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66db81d7dc311p+9,    0x1.78706e5dd8p-1036,  -0x1.6fb3d2p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.66de00d1b754p+9,    0x1.712b73434cp-1036,   0x1.e70802p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.66e07fcb9276fp+9,    0x1.6a0a682f14p-1036,  -0x1.877aacp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66e2fec56d99ep+9,    0x1.630c9b7794p-1036,   0x1.444d82p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66e57dbf48bcdp+9,    0x1.5c315ee16cp-1036,  -0x1.879846p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66e7fcb923dfcp+9,    0x1.5578078ea8p-1036,   0x1.155cbcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66ea7bb2ff02bp+9,    0x1.4edfededf4p-1036,  -0x1.64fcc2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66ecfaacda25ap+9,     0x1.48686daa7p-1036,  -0x1.8df316p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66ef79a6b5489p+9,    0x1.4210e59b9cp-1036,  -0x1.c41dccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66f1f8a0906b8p+9,     0x1.3bd8b7b5bp-1036,    0x1.fd7c7p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.66f4779a6b8e7p+9,    0x1.35bf48fa2cp-1036,  -0x1.b2457ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66f6f69446b16p+9,     0x1.2fc40168ep-1036,   0x1.90931cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66f9758e21d45p+9,    0x1.29e64bf0f4p-1036,   -0x1.fe4f2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66fbf487fcf74p+9,    0x1.2425966298p-1036,   0x1.85b8ccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.66fe7381d81a3p+9,    0x1.1e81516094p-1036,  -0x1.cdf74ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6700f27bb33d2p+9,     0x1.18f8f0528p-1036,  -0x1.0daeaap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.670371758e601p+9,    0x1.138be956fcp-1036,  -0x1.fe187ep-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.6705f06f6983p+9,    0x1.0e39b53648p-1036,   0x1.1e5bacp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.67086f6944a5fp+9,    0x1.0901cf551cp-1036,   0x1.e5ef4ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.670aee631fc8ep+9,     0x1.03e3b5a7cp-1036,  -0x1.c343ecp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.670d6d5cfaebdp+9,    0x1.fdbdd14ac8p-1037,   -0x1.b1b91p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.670fec56d60ecp+9,    0x1.f3e5d67768p-1037,  -0x1.d3db08p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67126b50b131bp+9,     0x1.ea3e85855p-1037,  -0x1.d2a50ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6714ea4a8c54ap+9,     0x1.e0c6ede13p-1037,  -0x1.79e8a4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6717694467779p+9,     0x1.d77e239d1p-1037,   0x1.fb689cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6719e83e429a8p+9,     0x1.ce633f594p-1037,  -0x1.8fe45cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.671c67381dbd7p+9,      0x1.c5755e2ep-1037,   -0x1.7258dp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.671ee631f8e06p+9,    0x1.bcb3a19538p-1037,   0x1.f4737ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6721652bd4035p+9,    0x1.b41d2f54e8p-1037,    0x1.1a739p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6723e425af264p+9,    0x1.abb13169e8p-1037,   0x1.64ab8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6726631f8a493p+9,     0x1.a36ed5f31p-1037,   0x1.8f5154p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6728e219656c2p+9,    0x1.9b554f1cc8p-1037,   0x1.d7cf02p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.672b6113408f1p+9,      0x1.9363d30dp-1037,  -0x1.666aa6p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.672de00d1bb2p+9,    0x1.8b999bcf98p-1037,   0x1.5be1dep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67305f06f6d4fp+9,     0x1.83f5e742fp-1037,  -0x1.34436cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6732de00d1f7ep+9,     0x1.7c77f7054p-1037,   0x1.17b522p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67355cfaad1adp+9,     0x1.751f1061dp-1037,    0x1.dbae5p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6737dbf4883dcp+9,      0x1.6dea7c3fp-1037,   0x1.fb3086p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.673a5aee6360bp+9,     0x1.66d9870c5p-1037,  -0x1.1e3f0cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.673cd9e83e83ap+9,      0x1.5feb80b1p-1037,  -0x1.46588ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.673f58e219a69p+9,    0x1.591fbc7ad8p-1037,  -0x1.ddc606p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6741d7dbf4c98p+9,    0x1.5275910d68p-1037,   0x1.346ec4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.674456d5cfec7p+9,    0x1.4bec585168p-1037,  -0x1.f649a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6746d5cfab0f6p+9,     0x1.45836f64dp-1037,  -0x1.25770ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.674954c986325p+9,    0x1.3f3a368ab8p-1037,  -0x1.a559b4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.674bd3c361554p+9,     0x1.3910111bfp-1037,   0x1.2f46fcp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.674e52bd3c783p+9,    0x1.33046577b8p-1037,   0x1.1c884cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6750d1b7179b2p+9,    0x1.2d169cf4c8p-1037,   0x1.0a4f68p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.675350b0f2be1p+9,     0x1.274623d2bp-1037,   0x1.52daaap-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6755cfaacde1p+9,    0x1.2192692b68p-1037,   0x1.854666p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.67584ea4a903fp+9,     0x1.1bfadee54p-1037,   0x1.70c2f4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.675acd9e8426ep+9,      0x1.167ef9a5p-1037,  -0x1.c2900cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.675d4c985f49dp+9,    0x1.111e30c068p-1037,   0x1.8e291cp-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.675fcb923a6ccp+9,     0x1.0bd7fe30dp-1037,   0x1.832cd6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67624a8c158fbp+9,     0x1.06abde862p-1037,    0x1.79d0ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6764c985f0b2ap+9,     0x1.019950da1p-1037,   0x1.6eb3aep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6767487fcbd59p+9,     0x1.f93fad872p-1038,   0x1.fa251ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6769c779a6f88p+9,      0x1.ef7de895p-1038,    0x1.fb58bp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.676c4673821b7p+9,     0x1.e5ec5fb73p-1038,   0x1.e40d0ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.676ec56d5d3e6p+9,     0x1.dc8a24793p-1038,  -0x1.a5eb18p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6771446738615p+9,     0x1.d3564d017p-1038,   0x1.6ba494p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6773c36113844p+9,     0x1.ca4ff3fa3p-1038,  -0x1.150264p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6776425aeea73p+9,     0x1.c176387bcp-1038,   0x1.0775e2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6778c154c9ca2p+9,     0x1.b8c83df61p-1038,   0x1.490886p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.677b404ea4ed1p+9,     0x1.b0452c1b8p-1038,  -0x1.1d73b8p-5, INEXACT|UNDERFLOW)
T(RN,     -0x1.677dbf48801p+9,     0x1.a7ec2ecbdp-1038,   -0x1.f5617p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67803e425b32fp+9,     0x1.9fbc75ff7p-1038,  -0x1.9c2c62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6782bd3c3655ep+9,     0x1.97b535b33p-1038,   0x1.31d48ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.67853c361178dp+9,     0x1.8fd5a5d46p-1038,    -0x1.efc2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6787bb2fec9bcp+9,     0x1.881d022d9p-1038,   0x1.c3496ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.678a3a29c7bebp+9,     0x1.808a8a532p-1038,  -0x1.b66e66p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.678cb923a2e1ap+9,     0x1.791d8190ep-1038,  -0x1.7829aep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.678f381d7e049p+9,     0x1.71d52ed76p-1038,   0x1.db15b6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6791b71759278p+9,     0x1.6ab0dcaa1p-1038,  -0x1.218092p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67943611344a7p+9,     0x1.63afd90dbp-1038,    0x1.5688ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6796b50b0f6d6p+9,     0x1.5cd17576cp-1038,   0x1.daf7acp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.67993404ea905p+9,     0x1.561506b8bp-1038,  -0x1.a106e6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.679bb2fec5b34p+9,     0x1.4f79e4f54p-1038,   -0x1.67c83p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.679e31f8a0d63p+9,     0x1.48ff6b8bfp-1038,   0x1.1e22dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67a0b0f27bf92p+9,     0x1.42a4f90a2p-1038,   0x1.a4b006p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67a32fec571c1p+9,     0x1.3c69ef1b6p-1038,  -0x1.ecc2b6p-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.67a5aee6323fp+9,      0x1.364db27ap-1038,   0x1.d4f6bcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67a82de00d61fp+9,     0x1.304faadfdp-1038,  -0x1.1f0622p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67aaacd9e884ep+9,     0x1.2a6f42f79p-1038,   0x1.15f25ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67ad2bd3c3a7dp+9,     0x1.24abe84e2p-1038,   0x1.4804e6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67afaacd9ecacp+9,     0x1.1f050b446p-1038,  -0x1.d5154ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67b229c779edbp+9,     0x1.197a1f015p-1038,  -0x1.7456aep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67b4a8c15510ap+9,     0x1.140a99643p-1038,   0x1.e19366p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67b727bb30339p+9,      0x1.0eb5f2f7p-1038,   0x1.93dc4ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67b9a6b50b568p+9,     0x1.097ba6e19p-1038,   0x1.cdebc8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67bc25aee6797p+9,     0x1.045b32dc5p-1038,   0x1.17eba2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67bea4a8c19c6p+9,     0x1.fea82e47ap-1039,    -0x1.e95ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67c123a29cbf5p+9,     0x1.f4cbacd8ap-1039,   0x1.2a1978p-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.67c3a29c77e24p+9,     0x1.eb1febaaap-1039,   0x1.048e0ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67c6219653053p+9,     0x1.e1a3f9bbap-1039,  -0x1.7fdf88p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67c8a0902e282p+9,     0x1.d856eab16p-1039,  -0x1.6e7608p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67cb1f8a094b1p+9,     0x1.cf37d6c1cp-1039,   -0x1.8cb2ep-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.67cd9e83e46ep+9,     0x1.c645da9cap-1039,   0x1.4ad3a2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67d01d7dbf90fp+9,     0x1.bd801755ap-1039,   0x1.a9537ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67d29c779ab3ep+9,     0x1.b4e5b24e6p-1039,   0x1.62ee8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67d51b7175d6dp+9,     0x1.ac75d5216p-1039,   0x1.915906p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67d79a6b50f9cp+9,     0x1.a42fad8cep-1039,  -0x1.bda3c2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67da19652c1cbp+9,     0x1.9c126d5eep-1039,   0x1.252e12p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67dc985f073fap+9,     0x1.941d4a604p-1039,  -0x1.ae1798p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67df1758e2629p+9,      0x1.8c4f7e42p-1039,  -0x1.c77aecp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67e19652bd858p+9,     0x1.84a846894p-1039,  -0x1.d795ecp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67e4154c98a87p+9,     0x1.7d26e47cap-1039,  -0x1.c30114p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67e6944673cb6p+9,     0x1.75ca9d11ap-1039,  -0x1.3ca0fap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.67e913404eee5p+9,     0x1.6e92b8da6p-1039,  -0x1.3bb698p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67eb923a2a114p+9,     0x1.677e83f3ep-1039,  -0x1.ac88ecp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67ee113405343p+9,     0x1.608d4df48p-1039,    0x1.a0e9dp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67f0902de0572p+9,     0x1.59be69da6p-1039,    0x1.39ec8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.67f30f27bb7a1p+9,     0x1.53112dfb6p-1039,   0x1.fa1804p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.67f58e21969dp+9,     0x1.4c84f3f3ep-1039,   0x1.d3194ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67f80d1b71bffp+9,     0x1.46191896cp-1039,   -0x1.3187bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67fa8c154ce2ep+9,     0x1.3fccfbddep-1039,  -0x1.ec4f04p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67fd0b0f2805dp+9,      0x1.39a000dap-1039,  -0x1.938f5ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.67ff8a090328cp+9,     0x1.33918da3cp-1039,   0x1.2ce5cap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.68020902de4bbp+9,     0x1.2da10b4c8p-1039,    0x1.f2704p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.680487fcb96eap+9,     0x1.27cde5cfep-1039,  -0x1.abe996p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.680706f694919p+9,     0x1.22178c054p-1039,  -0x1.651a56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.680985f06fb48p+9,     0x1.1c7d6f91cp-1039,   0x1.db3778p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.680c04ea4ad77p+9,     0x1.16ff04d9cp-1039,  -0x1.b14a4ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.680e83e425fa6p+9,     0x1.119bc2f48p-1039,  -0x1.1be162p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.681102de011d5p+9,     0x1.0c53239dap-1039,   0x1.f91bacp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.681381d7dc404p+9,     0x1.0724a3286p-1039,  -0x1.efd9fap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.681600d1b7633p+9,     0x1.020fc073ap-1039,   0x1.8984e4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68187fcb92862p+9,     0x1.fa27f9b78p-1040,  -0x1.e094b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.681afec56da91p+9,       0x1.f061b86p-1040,  -0x1.dc7242p-7, INEXACT|UNDERFLOW)
T(RN,    -0x1.681d7dbf48ccp+9,      0x1.e6cbc94ap-1040,   0x1.87a386p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.681ffcb923eefp+9,     0x1.dd653d938p-1040,   0x1.7f9e4cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68227bb2ff11ep+9,      0x1.d42d2af7p-1040,  -0x1.eaa738p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6824faacda34dp+9,      0x1.cb22abb6p-1040,  -0x1.7111ccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.682779a6b557cp+9,      0x1.c244de81p-1040,  -0x1.2f872cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6829f8a0907abp+9,     0x1.b992e662cp-1040,   0x1.24d6fep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.682c779a6b9dap+9,     0x1.b10beaa9cp-1040,  -0x1.9ab6b2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.682ef69446c09p+9,     0x1.a8af16d4cp-1040,  -0x1.089fe8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6831758e21e38p+9,     0x1.a07b9a7c4p-1040,     0x1.810bp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6833f487fd067p+9,     0x1.9870a93f4p-1040,   0x1.65f51cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68367381d8296p+9,      0x1.908d7aafp-1040,  -0x1.efb766p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6838f27bb34c5p+9,     0x1.88d14a3c4p-1040,   0x1.005658p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.683b71758e6f4p+9,     0x1.813b57228p-1040,  -0x1.452364p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.683df06f69923p+9,      0x1.79cae457p-1040,   0x1.4aae46p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.68406f6944b52p+9,      0x1.727f3875p-1040,  -0x1.eab504p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6842ee631fd81p+9,      0x1.6b579dadp-1040,    0x1.a8617p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.68456d5cfafbp+9,     0x1.645361b14p-1040,  -0x1.45a96ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6847ec56d61dfp+9,     0x1.5d71d5a68p-1040,  -0x1.246ebcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.684a6b50b140ep+9,     0x1.56b24e118p-1040,   0x1.5066a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.684cea4a8c63dp+9,     0x1.501422c64p-1040,  -0x1.b28378p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.684f69446786cp+9,     0x1.4996aed94p-1040,     0x1.2a01p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6851e83e42a9bp+9,     0x1.4339508d4p-1040,   -0x1.a8da3p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.685467381dccap+9,     0x1.3cfb69454p-1040,   0x1.76dcf8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6856e631f8ef9p+9,     0x1.36dc5d73cp-1040,  -0x1.068ddcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6859652bd4128p+9,      0x1.30db948dp-1040,   -0x1.a0978p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.685be425af357p+9,      0x1.2af878f7p-1040,  -0x1.0db59ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.685e631f8a586p+9,     0x1.253277fb4p-1040,   0x1.bbae68p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6860e219657b5p+9,     0x1.1f8901b88p-1040,   0x1.bac99ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68636113409e4p+9,      0x1.19fb8915p-1040,  -0x1.1f098cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6865e00d1bc13p+9,     0x1.148983b08p-1040,  -0x1.aecc32p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68685f06f6e42p+9,      0x1.0f3269d7p-1040,    0x1.7a7c2p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.686ade00d2071p+9,     0x1.09f5b672cp-1040,  -0x1.c89808p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.686d5cfaad2ap+9,     0x1.04d2e700cp-1040,  -0x1.12f8fcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.686fdbf4884cfp+9,     0x1.ff92f7058p-1041,   0x1.72b34cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68725aee636fep+9,      0x1.f5b1ece6p-1041,   0x1.ca12eep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6874d9e83e92dp+9,     0x1.ec01b9718p-1041,   -0x1.1daf8p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.687758e219b5cp+9,     0x1.e2816b378p-1041,   0x1.3b2224p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6879d7dbf4d8bp+9,     0x1.d93015708p-1041,  -0x1.2cd85ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.687c56d5cffbap+9,     0x1.d00ccfe88p-1041,   0x1.1fd556p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.687ed5cfab1e9p+9,      0x1.c716b6e6p-1041,   -0x1.7866ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.688154c986418p+9,      0x1.be4ceb17p-1041,   -0x1.28e52p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6883d3c361647p+9,      0x1.b5ae9178p-1041,   -0x1.2cfbcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.688652bd3c876p+9,     0x1.ad3ad3418p-1041,   0x1.c8dc74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6888d1b717aa5p+9,     0x1.a4f0ddd08p-1041,   0x1.000d94p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.688b50b0f2cd4p+9,     0x1.9ccfe2948p-1041,   0x1.d62896p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.688dcfaacdf03p+9,      0x1.94d716f9p-1041,  -0x1.bfdcfcp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68904ea4a9132p+9,     0x1.8d05b4548p-1041,   0x1.25e2b4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6892cd9e84361p+9,      0x1.855af7d2p-1041,  -0x1.48704cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.68954c985f59p+9,      0x1.7dd62261p-1041,  -0x1.7b9998p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6897cb923a7bfp+9,      0x1.767678a1p-1041,   -0x1.75f83p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.689a4a8c159eep+9,     0x1.6f3b42cf8p-1041,    0x1.00eeep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.689cc985f0c1dp+9,     0x1.6823ccb68p-1041,  -0x1.febfc6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.689f487fcbe4cp+9,      0x1.612f659cp-1041,  -0x1.7ece0cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68a1c779a707bp+9,     0x1.5a5d602e8p-1041,   0x1.7ed57ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68a44673822aap+9,      0x1.53ad1275p-1041,  -0x1.1b9e38p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68a6c56d5d4d9p+9,     0x1.4d1dd5c08p-1041,   0x1.a532c4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68a9446738708p+9,      0x1.46af0698p-1041,   0x1.1ac798p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68abc36113937p+9,      0x1.406004acp-1041,  -0x1.87e80ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68ae425aeeb66p+9,     0x1.3a3032c58p-1041,  -0x1.b36b1ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68b0c154c9d95p+9,      0x1.341ef6b6p-1041,  -0x1.0d3f0ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68b3404ea4fc4p+9,     0x1.2e2bb9498p-1041,  -0x1.18efbcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68b5bf48801f3p+9,      0x1.2855e638p-1041,   0x1.e709e4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68b83e425b422p+9,     0x1.229cec158p-1041,   0x1.582604p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68babd3c36651p+9,      0x1.1d003c46p-1041,   0x1.e70954p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.68bd3c361188p+9,     0x1.177f4aed8p-1041,   0x1.4e940ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68bfbb2fecaafp+9,     0x1.12198ee48p-1041,   0x1.93df18p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68c23a29c7cdep+9,     0x1.0cce81a88p-1041,  -0x1.dda4b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68c4b923a2f0dp+9,     0x1.079d9f518p-1041,   0x1.e7d746p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68c7381d7e13cp+9,      0x1.02866681p-1041,  -0x1.bea62ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68c9b7175936bp+9,      0x1.fb10b0b6p-1042,   0x1.0607b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68cc36113459ap+9,      0x1.f145f0e9p-1042,    0x1.6ba24p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68ceb50b0f7c9p+9,      0x1.e7ab9995p-1042,    0x1.a3fd5p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68d13404ea9f8p+9,      0x1.de40bb6ap-1042,   0x1.8597b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68d3b2fec5c27p+9,      0x1.d5046bb7p-1042,   0x1.34cdecp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68d631f8a0e56p+9,      0x1.cbf5c454p-1042,   0x1.82a30ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68d8b0f27c085p+9,      0x1.c313e389p-1042,  -0x1.b0d562p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68db2fec572b4p+9,      0x1.ba5debfcp-1042,  -0x1.4366b8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68ddaee6324e3p+9,      0x1.b1d30499p-1042,   0x1.b67da6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68e02de00d712p+9,      0x1.a972587ap-1042,  -0x1.730baep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68e2acd9e8941p+9,      0x1.a13b16dbp-1042,    0x1.83011p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.68e52bd3c3b7p+9,      0x1.992c72fap-1042,  -0x1.a1272ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68e7aacd9ed9fp+9,      0x1.9145a40fp-1042,    0x1.1d326p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.68ea29c779fcep+9,      0x1.8985e52ep-1042,  -0x1.7da83ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68eca8c1551fdp+9,      0x1.81ec753bp-1042,   -0x1.bf208p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68ef27bb3042cp+9,      0x1.7a7896d5p-1042,   0x1.efee1cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68f1a6b50b65bp+9,       0x1.7329904p-1042,  -0x1.ba485cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.68f425aee688ap+9,      0x1.6bfeab5bp-1042,   0x1.94d42cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.68f6a4a8c1ab9p+9,      0x1.64f73585p-1042,  -0x1.33a0e2p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.68f923a29cce8p+9,      0x1.5e127f93p-1042,   0x1.f6fbe2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.68fba29c77f17p+9,      0x1.574fddbap-1042,   0x1.79ae32p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.68fe219653146p+9,      0x1.50aea782p-1042,   0x1.91ab74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6900a0902e375p+9,      0x1.4a2e37b2p-1042,  -0x1.59aad4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69031f8a095a4p+9,      0x1.43cdec44p-1042,  -0x1.7af116p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69059e83e47d3p+9,      0x1.3d8d2652p-1042,   0x1.1943f6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69081d7dbfa02p+9,      0x1.376b4a06p-1042,   0x1.db6e14p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.690a9c779ac31p+9,      0x1.3167be8ep-1042,  -0x1.dd329cp-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.690d1b7175e6p+9,      0x1.2b81ee0cp-1042,  -0x1.66b1c2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.690f9a6b5108fp+9,      0x1.25b94586p-1042,   -0x1.04079p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.691219652c2bep+9,      0x1.200d34d9p-1042,   0x1.4c9248p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6914985f074edp+9,      0x1.1a7d2ea9p-1042,   0x1.6c405cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69171758e271cp+9,      0x1.1508a857p-1042,  -0x1.049152p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69199652bd94bp+9,      0x1.0faf19f1p-1042,   0x1.d1671cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.691c154c98b7ap+9,      0x1.0a6ffe23p-1042,   0x1.3bcb1ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.691e944673da9p+9,      0x1.054ad22fp-1042,   0x1.cb5114p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.692113404efd8p+9,      0x1.003f15dbp-1042,   0x1.85cb6ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6923923a2a207p+9,       0x1.f69896dp-1043,   0x1.b13964p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6926113405436p+9,      0x1.ece3ef0ap-1043,   0x1.0f1004p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6928902de0665p+9,      0x1.e35f4284p-1043,    0x1.4ea74p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.692b0f27bb894p+9,      0x1.da09a408p-1043,  -0x1.413b26p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.692d8e2196ac3p+9,      0x1.d0e22afap-1043,  -0x1.da0394p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69300d1b71cf2p+9,      0x1.c7e7f336p-1043,   -0x1.a0b97p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69328c154cf21p+9,      0x1.bf1a1d04p-1043,   -0x1.a63b3p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.69350b0f2815p+9,      0x1.b677ccfcp-1043,  -0x1.755006p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69378a090337fp+9,      0x1.ae002bf4p-1043,    0x1.66911p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.693a0902de5aep+9,      0x1.a5b266e6p-1043,  -0x1.aeac0ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.693c87fcb97ddp+9,      0x1.9d8daee6p-1043,   0x1.e9024ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.693f06f694a0cp+9,      0x1.959138fep-1043,  -0x1.1a4feep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.694185f06fc3bp+9,      0x1.8dbc3e2ep-1043,   0x1.86334cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.694404ea4ae6ap+9,      0x1.860dfb44p-1043,   0x1.67c97cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.694683e426099p+9,      0x1.7e85b0d8p-1043,    0x1.75eb6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.694902de012c8p+9,      0x1.7722a334p-1043,  -0x1.2ed294p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.694b81d7dc4f7p+9,      0x1.6fe41a42p-1043,   0x1.7e6146p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.694e00d1b7726p+9,      0x1.68c96178p-1043,   0x1.5cb66ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69507fcb92955p+9,      0x1.61d1c7cap-1043,  -0x1.2abe02p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6952fec56db84p+9,      0x1.5afc9f98p-1043,  -0x1.f2fabap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69557dbf48db3p+9,      0x1.54493e9cp-1043,    0x1.10f82p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6957fcb923fe2p+9,      0x1.4db6fdd8p-1043,   0x1.c7a93ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.695a7bb2ff211p+9,      0x1.47453988p-1043,   0x1.ef9fcep-9, INEXACT|UNDERFLOW)
T(RN,    -0x1.695cfaacda44p+9,      0x1.40f35114p-1043,  -0x1.0851f2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.695f79a6b566fp+9,      0x1.3ac0a6fep-1043,   0x1.ef46a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6961f8a09089ep+9,      0x1.34aca0ccp-1043,  -0x1.0508b8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6964779a6bacdp+9,      0x1.2eb6a70ap-1043,   0x1.01940cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6966f69446cfcp+9,      0x1.28de2528p-1043,    0x1.3e353p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6969758e21f2bp+9,      0x1.23228978p-1043,   0x1.6151f4p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.696bf487fd15ap+9,      0x1.1d83451ep-1043,   0x1.e3f2aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.696e7381d8389p+9,      0x1.17ffcbfcp-1043,   0x1.ebfed2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6970f27bb35b8p+9,      0x1.129794aap-1043,  -0x1.80117cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.697371758e7e7p+9,      0x1.0d4a186cp-1043,   -0x1.5e165p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6975f06f69a16p+9,      0x1.0816d31ap-1043,  -0x1.f01f66p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.69786f6944c45p+9,      0x1.02fd431cp-1043,   0x1.442e98p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.697aee631fe74p+9,      0x1.fbf9d2b4p-1044,   0x1.67c312p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.697d6d5cfb0a3p+9,       0x1.f22a926p-1044,   0x1.ded3a8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.697fec56d62d2p+9,      0x1.e88bd0c8p-1044,    0x1.bf94bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69826b50b1501p+9,      0x1.df1c9e2cp-1044,   0x1.d52566p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6984ea4a8c73p+9,       0x1.d5dc0f7p-1044,   0x1.f9ea8ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.698769446795fp+9,        0x1.ccc93ep-1044,   0x1.4fa70ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6989e83e42b8ep+9,       0x1.c3e347cp-1044,    0x1.ebfabp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.698c67381ddbdp+9,      0x1.bb294eecp-1044,  -0x1.cb2ef2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.698ee631f8fecp+9,       0x1.b29a7a1p-1044,   -0x1.adc3bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6991652bd421bp+9,      0x1.aa35f3e4p-1044,  -0x1.c8b374p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6993e425af44ap+9,      0x1.a1faeb44p-1044,   0x1.e41becp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6996631f8a679p+9,      0x1.99e8930cp-1044,  -0x1.a4c238p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6998e219658a8p+9,      0x1.91fe221cp-1044,   0x1.37bdb2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.699b611340ad7p+9,      0x1.8a3ad328p-1044,   -0x1.8637bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.699de00d1bd06p+9,      0x1.829de4c4p-1044,   0x1.917206p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69a05f06f6f35p+9,       0x1.7b26993p-1044,   0x1.2c5b56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69a2de00d2164p+9,      0x1.73d4365cp-1044,  -0x1.3f759ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69a55cfaad393p+9,      0x1.6ca605d8p-1044,   0x1.a3e184p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69a7dbf4885c2p+9,      0x1.659b54acp-1044,   0x1.427bcap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69aa5aee637f1p+9,      0x1.5eb3735cp-1044,  -0x1.317422p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.69acd9e83ea2p+9,      0x1.57edb5d4p-1044,   0x1.ba9d5cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69af58e219c4fp+9,      0x1.51497348p-1044,   -0x1.a0e2ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.69b1d7dbf4e7ep+9,      0x1.4ac60638p-1044,    0x1.a8391p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69b456d5d00adp+9,       0x1.4462cc5p-1044,    0x1.357e9p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69b6d5cfab2dcp+9,       0x1.3e1f266p-1044,   0x1.5d4458p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.69b954c98650bp+9,       0x1.37fa785p-1044,    0x1.feaefp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69bbd3c36173ap+9,        0x1.31f429p-1044,  -0x1.94f83ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69be52bd3c969p+9,      0x1.2c0ba254p-1044,  -0x1.058326p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69c0d1b717b98p+9,      0x1.2640510cp-1044,   0x1.1ad182p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69c350b0f2dc7p+9,       0x1.2091a4cp-1044,  -0x1.c859e6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69c5cfaacdff6p+9,      0x1.1aff0fd8p-1044,  -0x1.478fe2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69c84ea4a9225p+9,      0x1.15880774p-1044,   0x1.9fa452p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69cacd9e84454p+9,      0x1.102c035cp-1044,  -0x1.f81298p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69cd4c985f683p+9,      0x1.0aea7e0cp-1044,   0x1.6bd228p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69cfcb923a8b2p+9,       0x1.05c2f48p-1044,    0x1.30728p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69d24a8c15ae1p+9,      0x1.00b4e644p-1044,  -0x1.12ff04p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.69d4c985f0d1p+9,      0x1.f77faac8p-1045,   0x1.009d84p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69d7487fcbf3fp+9,       0x1.edc68cap-1045,  -0x1.7d4a3ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69d9c779a716ep+9,       0x1.e43d7fdp-1045,   0x1.ebc586p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69dc46738239dp+9,      0x1.dae396a8p-1045,   0x1.826f52p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.69dec56d5d5ccp+9,      0x1.d1b7e828p-1045,   0x1.e9359cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69e14467387fbp+9,      0x1.c8b98fb8p-1045,  -0x1.52a4c8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69e3c36113a2ap+9,      0x1.bfe7ad48p-1045,  -0x1.1e3d22p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69e6425aeec59p+9,      0x1.b7416508p-1045,   0x1.75c8dcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69e8c154c9e88p+9,       0x1.aec5df6p-1045,  -0x1.c07c4ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69eb404ea50b7p+9,      0x1.a67448f8p-1045,   0x1.3e5feap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.69edbf48802e6p+9,      0x1.9e4bd278p-1045,  -0x1.362d42p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.69f03e425b515p+9,      0x1.964bb098p-1045,  -0x1.58317cp-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.69f2bd3c36744p+9,       0x1.8e731bfp-1045,  -0x1.7ca7aep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69f53c3611973p+9,        0x1.86c151p-1045,   -0x1.3b3fdp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69f7bb2fecba2p+9,      0x1.7f359008p-1045,    0x1.34249p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69fa3a29c7dd1p+9,       0x1.77cf1cfp-1045,   0x1.2f28f8p-4, INEXACT|UNDERFLOW)
T(RN,      -0x1.69fcb923a3p+9,      0x1.708d3f58p-1045,    0x1.b21dfp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.69ff381d7e22fp+9,      0x1.696f4258p-1045,  -0x1.98b596p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a01b7175945ep+9,       0x1.627474ap-1045,  -0x1.bdc30ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a0436113468dp+9,      0x1.5b9c2838p-1045,   -0x1.c27e8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a06b50b0f8bcp+9,       0x1.54e5b29p-1045,   0x1.04c8fcp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a093404eaaebp+9,      0x1.4e506c58p-1045,  -0x1.2a31b2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a0bb2fec5d1ap+9,      0x1.47dbb188p-1045,   0x1.704768p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a0e31f8a0f49p+9,      0x1.4186e138p-1045,   0x1.01279cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a10b0f27c178p+9,       0x1.3b515dap-1045,    0x1.30cebp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a132fec573a7p+9,      0x1.353a8c08p-1045,   0x1.83d456p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a15aee6325d6p+9,      0x1.2f41d4a8p-1045,  -0x1.610f24p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a182de00d805p+9,      0x1.2966a2b8p-1045,  -0x1.8fb6c6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a1aacd9e8a34p+9,      0x1.23a86448p-1045,  -0x1.f6205ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a1d2bd3c3c63p+9,       0x1.1e068a3p-1045,  -0x1.9c0e02p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a1faacd9ee92p+9,       0x1.1880882p-1045,   0x1.2bc40ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a2229c77a0c1p+9,       0x1.1315d46p-1045,  -0x1.00f406p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6a24a8c1552fp+9,        0x1.0dc5e8p-1045,  -0x1.3bdacep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a2727bb3051fp+9,       0x1.08903eap-1045,   0x1.b4b588p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a29a6b50b74ep+9,       0x1.0374566p-1045,    0x1.cf3ebp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a2c25aee697dp+9,       0x1.fce35fep-1046,   0x1.46a72ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a2ea4a8c1bacp+9,       0x1.f30f9cfp-1046,  -0x1.c0cfdap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a3123a29cddbp+9,       0x1.e96c6f1p-1046,   0x1.ba285cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a33a29c7800ap+9,        0x1.dff8e6p-1046,  -0x1.b94cfcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a36219653239p+9,       0x1.d6b4165p-1046,   0x1.76b55ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a38a0902e468p+9,       0x1.cd9d18ep-1046,  -0x1.784468p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a3b1f8a09697p+9,       0x1.c4b30b5p-1046,  -0x1.3bb854p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a3d9e83e48c6p+9,       0x1.bbf50f6p-1046,  -0x1.03a126p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a401d7dbfaf5p+9,       0x1.b3624b4p-1046,    0x1.7b89fp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a429c779ad24p+9,       0x1.aaf9e94p-1046,  -0x1.49b078p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a451b7175f53p+9,       0x1.a2bb17ep-1046,   0x1.ffa3eap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a479a6b51182p+9,       0x1.9aa509ap-1046,   0x1.8b26bep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a4a19652c3b1p+9,        0x1.92b6f5p-1046,   0x1.9fe44cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6a4c985f075ep+9,       0x1.8af0145p-1046,  -0x1.1b4094p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a4f1758e280fp+9,       0x1.834fa5ep-1046,   0x1.5d3676p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a519652bda3ep+9,       0x1.7bd4eb9p-1046,   0x1.852ef8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a54154c98c6dp+9,       0x1.747f2afp-1046,   0x1.b21ca4p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a56944673e9cp+9,       0x1.6d4dad4p-1046,  -0x1.463c92p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a5913404f0cbp+9,       0x1.663fbf4p-1046,   -0x1.bd55ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a5b923a2a2fap+9,       0x1.5f54b12p-1046,  -0x1.f66696p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a5e113405529p+9,       0x1.588bd68p-1046,    0x1.bc853p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a60902de0758p+9,       0x1.51e4864p-1046,   0x1.7205dap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a630f27bb987p+9,       0x1.4b5e1a8p-1046,  -0x1.f1e46ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a658e2196bb6p+9,       0x1.44f7f0dp-1046,   0x1.03da38p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a680d1b71de5p+9,       0x1.3eb1699p-1046,    0x1.b8cb2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a6a8c154d014p+9,       0x1.3889e87p-1046,   0x1.50bf8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a6d0b0f28243p+9,        0x1.3280d4p-1046,  -0x1.33c5b6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a6f8a0903472p+9,       0x1.2c9595fp-1046,    0x1.b6e5fp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a720902de6a1p+9,       0x1.26c79abp-1046,   0x1.f987a8p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6a7487fcb98dp+9,       0x1.2116519p-1046,    0x1.777a2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a7706f694affp+9,       0x1.1b812ccp-1046,    0x1.55344p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a7985f06fd2ep+9,       0x1.1607a12p-1046,    0x1.4a3dfp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a7c04ea4af5dp+9,       0x1.10a9264p-1046,   0x1.988b98p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a7e83e42618cp+9,       0x1.0b65364p-1046,  -0x1.829baap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a8102de013bbp+9,       0x1.063b4e1p-1046,      0x1.439p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a8381d7dc5eap+9,       0x1.012aecep-1046,   0x1.ae8e98p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a8600d1b7819p+9,        0x1.f86729p-1047,   0x1.dcce32p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a887fcb92a48p+9,       0x1.eea9926p-1047,   -0x1.a21b7p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a8afec56dc77p+9,       0x1.e51c234p-1047,  -0x1.a4ad08p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a8d7dbf48ea6p+9,       0x1.dbbded8p-1047,   0x1.60b0a2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a8ffcb9240d5p+9,       0x1.d28e07ap-1047,   0x1.94270cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a927bb2ff304p+9,       0x1.c98b8cap-1047,   0x1.0bad76p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a94faacda533p+9,       0x1.c0b59c2p-1047,   0x1.ab4f22p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a9779a6b5762p+9,       0x1.b80b59cp-1047,  -0x1.e079d4p-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a99f8a090991p+9,       0x1.af8bedcp-1047,   0x1.52d788p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6a9c779a6bbcp+9,       0x1.a736842p-1047,  -0x1.a4ed56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6a9ef69446defp+9,       0x1.9f0a4d8p-1047,   0x1.c6f14ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aa1758e2201ep+9,       0x1.97067dep-1047,  -0x1.9bed0ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aa3f487fd24dp+9,       0x1.8f2a4dcp-1047,  -0x1.871ec8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aa67381d847cp+9,       0x1.8774f94p-1047,   0x1.500da8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aa8f27bb36abp+9,         0x1.7fe5cp-1047,  -0x1.f3e29ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aab71758e8dap+9,        0x1.787be6p-1047,   0x1.1a5852p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aadf06f69b09p+9,       0x1.7136b22p-1047,  -0x1.825d4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ab06f6944d38p+9,       0x1.6a156f8p-1047,   0x1.c0303ep-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ab2ee631ff67p+9,       0x1.63176c4p-1047,  -0x1.4bf9aap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ab56d5cfb196p+9,       0x1.5c3bfa4p-1047,   0x1.6f38bcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ab7ec56d63c5p+9,       0x1.55826e8p-1047,    0x1.bb166p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aba6b50b15f4p+9,       0x1.4eea216p-1047,   -0x1.458e9p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6abcea4a8c823p+9,       0x1.48726ecp-1047,   0x1.927a58p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6abf694467a52p+9,       0x1.421ab52p-1047,  -0x1.f81524p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ac1e83e42c81p+9,       0x1.3be256cp-1047,  -0x1.2f1b64p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6ac467381debp+9,       0x1.35c8b88p-1047,   0x1.4dc0eep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ac6e631f90dfp+9,       0x1.2fcd424p-1047,  -0x1.a9b3f6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ac9652bd430ep+9,        0x1.29ef5fp-1047,  -0x1.fd43e6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6acbe425af53dp+9,       0x1.242e7cap-1047,  -0x1.3720e6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ace631f8a76cp+9,       0x1.1e8a0bap-1047,  -0x1.fa29bep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ad0e2196599bp+9,       0x1.19017f8p-1047,   0x1.f0a126p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ad3611340bcap+9,       0x1.13944e2p-1047,  -0x1.372e8cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ad5e00d1bdf9p+9,       0x1.0e41f08p-1047,  -0x1.4f1366p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ad85f06f7028p+9,        0x1.0909e2p-1047,   0x1.b6ec08p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6adade00d2257p+9,       0x1.03eba06p-1047,    0x1.d618fp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6add5cfaad486p+9,       0x1.fdcd588p-1048,   0x1.2ac2eep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6adfdbf4886b5p+9,       0x1.f3f510cp-1048,  -0x1.64c97ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ae25aee638e4p+9,       0x1.ea4d748p-1048,  -0x1.c0cbc8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ae4d9e83eb13p+9,       0x1.e0d5934p-1048,   0x1.c0f008p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ae758e219d42p+9,       0x1.d78c808p-1048,   0x1.ccff0ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ae9d7dbf4f71p+9,       0x1.ce71554p-1048,   0x1.823e8ap-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6aec56d5d01ap+9,       0x1.c5832e8p-1048,   0x1.961be4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6aeed5cfab3cfp+9,       0x1.bcc12d8p-1048,  -0x1.00d7bep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6af154c9865fep+9,       0x1.b42a784p-1048,  -0x1.6f30d4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6af3d3c36182dp+9,       0x1.abbe38cp-1048,    0x1.95987p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6af652bd3ca5cp+9,       0x1.a37b9ccp-1048,  -0x1.403638p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6af8d1b717c8bp+9,       0x1.9b61d6cp-1048,  -0x1.3ae3dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6afb50b0f2ebap+9,       0x1.93701ccp-1048,  -0x1.21f71cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6afdcfaace0e9p+9,       0x1.8ba5a8cp-1048,  -0x1.5231e2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b004ea4a9318p+9,       0x1.8401b8cp-1048,   0x1.57fd16p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b02cd9e84547p+9,        0x1.7c838ep-1048,  -0x1.5a2d38p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b054c985f776p+9,        0x1.752a6ep-1048,   -0x1.b7d4dp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b07cb923a9a5p+9,       0x1.6df5a1cp-1048,    -0x1.00f7p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b0a4a8c15bd4p+9,       0x1.66e4758p-1048,   0x1.604b46p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b0cc985f0e03p+9,        0x1.5ff639p-1048,   -0x1.4bf89p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b0f487fcc032p+9,       0x1.592a3fcp-1048,  -0x1.f5087ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b11c779a7261p+9,       0x1.527fe08p-1048,   0x1.db8044p-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.6b1446738249p+9,       0x1.4bf674cp-1048,  -0x1.102038p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b16c56d5d6bfp+9,       0x1.458d59cp-1048,  -0x1.b4964cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b194467388eep+9,         0x1.3f43fp-1048,   0x1.043956p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b1bc36113b1dp+9,       0x1.39199a8p-1048,   0x1.7106bap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b1e425aeed4cp+9,       0x1.330dbfcp-1048,   0x1.e7d17ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b20c154c9f7bp+9,        0x1.2d1fc9p-1048,   0x1.cb831cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b23404ea51aap+9,       0x1.274f228p-1048,   0x1.02282ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b25bf48803d9p+9,       0x1.219b3b4p-1048,  -0x1.932536p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b283e425b608p+9,       0x1.1c03858p-1048,   0x1.12f2f2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b2abd3c36837p+9,       0x1.1687758p-1048,   0x1.9c3054p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b2d3c3611a66p+9,       0x1.1126828p-1048,   -0x1.de483p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b2fbb2fecc95p+9,        0x1.0be027p-1048,   0x1.3015bap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b323a29c7ec4p+9,        0x1.06b3dfp-1048,    0x1.3a72ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b34b923a30f3p+9,       0x1.01a129cp-1048,   0x1.c8a318p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b37381d7e322p+9,       0x1.f94f118p-1049,  -0x1.03bd78p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b39b71759551p+9,       0x1.ef8d008p-1049,  -0x1.7e6686p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6b3c36113478p+9,        0x1.e5fb2dp-1049,  -0x1.bce9f4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b3eb50b0f9afp+9,       0x1.dc98a88p-1049,   -0x1.83722p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b413404eabdep+9,       0x1.d364898p-1049,   0x1.605456p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b43b2fec5e0dp+9,        0x1.ca5deap-1049,  -0x1.9d32dep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b4631f8a103cp+9,       0x1.c183e98p-1049,  -0x1.304bd6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b48b0f27c26bp+9,       0x1.b8d5ab8p-1049,   0x1.5f64e8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b4b2fec5749ap+9,        0x1.b05257p-1049,    -0x1.86b5p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b4daee6326c9p+9,       0x1.a7f9188p-1049,  -0x1.7e65b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b502de00d8f8p+9,         0x1.9fc92p-1049,  -0x1.88e1d2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b52acd9e8b27p+9,        0x1.97c1a1p-1049,  -0x1.23ae84p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b552bd3c3d56p+9,        0x1.8fe1d4p-1049,    0x1.02e27p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b57aacd9ef85p+9,        0x1.8828f4p-1049,  -0x1.28090cp-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b5a29c77a1b4p+9,        0x1.809641p-1049,  -0x1.b14b18p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b5ca8c1553e3p+9,       0x1.7928fe8p-1049,   0x1.016256p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b5f27bb30612p+9,        0x1.71e073p-1049,    0x1.438d9p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b61a6b50b841p+9,        0x1.6abbe9p-1049,  -0x1.93e2f2p-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.6b6425aee6a7p+9,        0x1.63baafp-1049,   0x1.72620cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b66a4a8c1c9fp+9,       0x1.5cdc158p-1049,  -0x1.52161ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b6923a29cecep+9,       0x1.561f728p-1049,   0x1.b78ed8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b6ba29c780fdp+9,        0x1.4f841dp-1049,  -0x1.d0e8a6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b6e21965332cp+9,        0x1.490971p-1049,  -0x1.731092p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b70a0902e55bp+9,        0x1.42aecdp-1049,  -0x1.07f3bcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b731f8a0978ap+9,       0x1.3c73928p-1049,  -0x1.b9c8aap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b759e83e49b9p+9,       0x1.3657268p-1049,   0x1.61c88ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b781d7dbfbe8p+9,         0x1.3058fp-1049,   0x1.43e0dep-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b7a9c779ae17p+9,       0x1.2a785a8p-1049,   0x1.eb2684p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b7d1b7176046p+9,       0x1.24b4d28p-1049,  -0x1.3ecebcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b7f9a6b51275p+9,       0x1.1f0dc98p-1049,  -0x1.604bbcp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b8219652c4a4p+9,        0x1.1982b2p-1049,  -0x1.d6fffep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b84985f076d3p+9,        0x1.141302p-1049,  -0x1.c00f3ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b871758e2902p+9,        0x1.0ebe32p-1049,   -0x1.da2b3p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b899652bdb31p+9,        0x1.0983bdp-1049,  -0x1.a6fe5cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6b8c154c98d6p+9,        0x1.046321p-1049,  -0x1.a58ce8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b8e944673f8fp+9,        0x1.feb7bdp-1050,    0x1.c88eap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b9113404f1bep+9,        0x1.f4daeep-1050,  -0x1.bee0cep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b93923a2a3edp+9,        0x1.eb2ee2p-1050,   0x1.83be92p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b9611340561cp+9,        0x1.e1b2a6p-1050,   0x1.1725bap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b98902de084bp+9,        0x1.d8654ep-1050,  -0x1.3d27a6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b9b0f27bba7ap+9,        0x1.cf45f3p-1050,  -0x1.647ad4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6b9d8e2196ca9p+9,        0x1.c653b1p-1050,  -0x1.787e0ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ba00d1b71ed8p+9,        0x1.bd8da9p-1050,  -0x1.fb4652p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ba28c154d107p+9,        0x1.b4f301p-1050,  -0x1.824324p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ba50b0f28336p+9,        0x1.ac82e2p-1050,  -0x1.a0dddcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ba78a0903565p+9,        0x1.a43c7ap-1050,  -0x1.36da4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6baa0902de794p+9,        0x1.9c1efbp-1050,   0x1.3b93b6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bac87fcb99c3p+9,        0x1.94299ap-1050,   0x1.a24788p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6baf06f694bf2p+9,        0x1.8c5b91p-1050,    0x1.7036bp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bb185f06fe21p+9,        0x1.84b41dp-1050,  -0x1.aa5a4cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6bb404ea4b05p+9,        0x1.7d3281p-1050,   0x1.4d03bep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bb683e42627fp+9,          0x1.75d6p-1050,  -0x1.480e42p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bb902de014aep+9,        0x1.6e9de4p-1050,   0x1.f253fep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bbb81d7dc6ddp+9,        0x1.678977p-1050,  -0x1.a2f28ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bbe00d1b790cp+9,        0x1.60980bp-1050,  -0x1.17e36cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bc07fcb92b3bp+9,        0x1.59c8f2p-1050,  -0x1.43d6dep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bc2fec56dd6ap+9,        0x1.531b82p-1050,  -0x1.2051d2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bc57dbf48f99p+9,        0x1.4c8f15p-1050,  -0x1.978fb8p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bc7fcb9241c8p+9,        0x1.462308p-1050,   0x1.8e90dap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bca7bb2ff3f7p+9,        0x1.3fd6bap-1050,   0x1.c2479ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bccfaacda626p+9,        0x1.39a98fp-1050,   0x1.94bf68p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bcf79a6b5855p+9,        0x1.339aecp-1050,   -0x1.4ca3ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bd1f8a090a84p+9,        0x1.2daa3cp-1050,    0x1.fc7b8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bd4779a6bcb3p+9,        0x1.27d6e9p-1050,   0x1.a0bc04p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bd6f69446ee2p+9,        0x1.222062p-1050,  -0x1.054efap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bd9758e22111p+9,        0x1.1c861ap-1050,  -0x1.e0bcecp-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.6bdbf487fd34p+9,        0x1.170785p-1050,   0x1.c63672p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bde7381d856fp+9,        0x1.11a419p-1050,   0x1.6b0056p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6be0f27bb379ep+9,         0x1.0c5b5p-1050,  -0x1.a17b6ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6be371758e9cdp+9,        0x1.072ca7p-1050,  -0x1.e3ac78p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6be5f06f69bfcp+9,        0x1.02179dp-1050,   0x1.924208p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6be86f6944e2bp+9,        0x1.fa3764p-1051,  -0x1.c9051ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6beaee632005ap+9,        0x1.f070d8p-1051,   0x1.590ecep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bed6d5cfb289p+9,        0x1.e6da9ep-1051,   0x1.064fcap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6befec56d64b8p+9,        0x1.dd73c8p-1051,  -0x1.dce546p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bf26b50b16e7p+9,        0x1.d43b6ep-1051,   0x1.366bfcp-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bf4ea4a8c916p+9,        0x1.cb30a8p-1051,   -0x1.a05d3p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bf7694467b45p+9,        0x1.c25296p-1051,   0x1.2d2746p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bf9e83e42d74p+9,        0x1.b9a05ap-1051,   0x1.2e4d5ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bfc67381dfa3p+9,        0x1.b1191cp-1051,   0x1.2d6e2ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6bfee631f91d2p+9,        0x1.a8bc06p-1051,   -0x1.515e5p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c01652bd4401p+9,        0x1.a0884ap-1051,  -0x1.6e8a28p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6c03e425af63p+9,        0x1.987d1ap-1051,  -0x1.992b34p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c06631f8a85fp+9,        0x1.9099aep-1051,  -0x1.4fcc7ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c08e21965a8ep+9,        0x1.88dd42p-1051,   0x1.c4775cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c0b611340cbdp+9,        0x1.814714p-1051,   0x1.65920ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c0de00d1beecp+9,        0x1.79d666p-1051,  -0x1.f89242p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c105f06f711bp+9,        0x1.728a82p-1051,   0x1.21d722p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c12de00d234ap+9,         0x1.6b62bp-1051,   0x1.b8326cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c155cfaad579p+9,        0x1.645e3cp-1051,   -0x1.c2951p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c17dbf4887a8p+9,        0x1.5d7c7ap-1051,  -0x1.79819cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c1a5aee639d7p+9,        0x1.56bcbep-1051,  -0x1.0f7d36p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c1cd9e83ec06p+9,         0x1.501e6p-1051,   0x1.7c104ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c1f58e219e35p+9,        0x1.49a0bap-1051,   0x1.d162aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c21d7dbf5064p+9,        0x1.43432ap-1051,   0x1.ae124ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c2456d5d0293p+9,        0x1.3d0512p-1051,   0x1.9840fep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c26d5cfab4c2p+9,        0x1.36e5d6p-1051,   0x1.674a56p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c2954c9866f1p+9,        0x1.30e4dep-1051,   0x1.0e5d54p-5, INEXACT|UNDERFLOW)
T(RN,    -0x1.6c2bd3c36192p+9,        0x1.2b0194p-1051,  -0x1.c0685ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c2e52bd3cb4fp+9,        0x1.253b66p-1051,  -0x1.b92e84p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c30d1b717d7ep+9,        0x1.1f91c4p-1051,  -0x1.0bab84p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c3350b0f2fadp+9,         0x1.1a042p-1051,   -0x1.3a299p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c35cfaace1dcp+9,         0x1.1491fp-1051,  -0x1.c14b3ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c384ea4a940bp+9,        0x1.0f3aacp-1051,  -0x1.72dddcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c3acd9e8463ap+9,         0x1.09fddp-1051,  -0x1.f84a3ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c3d4c985f869p+9,        0x1.04dad8p-1051,   -0x1.fd649p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c3fcb923aa98p+9,        0x1.ffa28cp-1052,  -0x1.c9ae86p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c424a8c15cc7p+9,        0x1.f5c134p-1052,  -0x1.48b104p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c44c985f0ef6p+9,        0x1.ec10b8p-1052,   0x1.b91e36p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c47487fcc125p+9,        0x1.e2901cp-1052,  -0x1.f4e93ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c49c779a7354p+9,         0x1.d93e8p-1052,   0x1.ee42c4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c4c467382583p+9,        0x1.d01af4p-1052,    0x1.4634ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c4ec56d5d7b2p+9,        0x1.c72494p-1052,   0x1.54c328p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c514467389e1p+9,        0x1.be5a84p-1052,    0x1.04d08p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6c53c36113c1p+9,        0x1.b5bbe8p-1052,    0x1.57277p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c56425aeee3fp+9,        0x1.ad47e8p-1052,   0x1.778186p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c58c154ca06ep+9,         0x1.a4fdbp-1052,  -0x1.cf3086p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c5b404ea529dp+9,        0x1.9cdc74p-1052,  -0x1.d3709cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c5dbf48804ccp+9,        0x1.94e36cp-1052,  -0x1.ad6022p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c603e425b6fbp+9,        0x1.8d11ccp-1052,  -0x1.c5458ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c62bd3c3692ap+9,        0x1.8566d4p-1052,  -0x1.27ca9ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c653c3611b59p+9,        0x1.7de1c4p-1052,  -0x1.180036p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c67bb2fecd88p+9,         0x1.7681ep-1052,  -0x1.a16042p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c6a3a29c7fb7p+9,        0x1.6f4674p-1052,   0x1.653c4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c6cb923a31e6p+9,        0x1.682ec4p-1052,   -0x1.34803p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c6f381d7e415p+9,        0x1.613a28p-1052,   0x1.12a952p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c71b71759644p+9,        0x1.5a67ecp-1052,  -0x1.3fd40ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c74361134873p+9,        0x1.53b76cp-1052,    0x1.4510fp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c76b50b0faa2p+9,        0x1.4d27fcp-1052,   0x1.fa3f8cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c793404eacd1p+9,        0x1.46b8fcp-1052,   0x1.d142dcp-2, INEXACT|UNDERFLOW)
T(RN,     -0x1.6c7bb2fec5fp+9,        0x1.4069c8p-1052,   0x1.decf74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c7e31f8a112fp+9,        0x1.3a39c4p-1052,   -0x1.d5b3cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c80b0f27c35ep+9,        0x1.342858p-1052,  -0x1.8aaa94p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c832fec5758dp+9,        0x1.2e34ecp-1052,  -0x1.b7808cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c85aee6327bcp+9,        0x1.285eecp-1052,  -0x1.2466e4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c882de00d9ebp+9,        0x1.22a5c8p-1052,   0x1.9e7214p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c8aacd9e8c1ap+9,        0x1.1d08ecp-1052,   0x1.31dd48p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c8d2bd3c3e49p+9,         0x1.1787dp-1052,   0x1.759346p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c8faacd9f078p+9,        0x1.1221e8p-1052,  -0x1.a8bfd4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c9229c77a2a7p+9,         0x1.0cd6bp-1052,   -0x1.e7529p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c94a8c1554d6p+9,        0x1.07a5a8p-1052,   0x1.d67744p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c9727bb30705p+9,        0x1.028e48p-1052,   0x1.6e58dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c99a6b50b934p+9,         0x1.fb202p-1053,  -0x1.7cb662p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c9c25aee6b63p+9,        0x1.f15518p-1053,   0x1.302524p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6c9ea4a8c1d92p+9,        0x1.e7ba78p-1053,   0x1.b3958ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ca123a29cfc1p+9,         0x1.de4f5p-1053,   0x1.817276p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6ca3a29c781fp+9,        0x1.d512b8p-1053,   0x1.5dadacp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ca621965341fp+9,        0x1.cc03c8p-1053,   0x1.80727cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ca8a0902e64ep+9,         0x1.c321ap-1053,  -0x1.30cbcap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cab1f8a0987dp+9,        0x1.ba6b68p-1053,    0x1.25031p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cad9e83e4aacp+9,        0x1.b1e038p-1053,  -0x1.da02e4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cb01d7dbfcdbp+9,         0x1.a97f5p-1053,   0x1.bf0f86p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cb29c779af0ap+9,         0x1.a147dp-1053,   0x1.b85976p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cb51b7176139p+9,        0x1.9938e8p-1053,  -0x1.d9ed58p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cb79a6b51368p+9,         0x1.9151ep-1053,   0x1.5806acp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cba19652c597p+9,         0x1.8991ep-1053,  -0x1.00a0bcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cbc985f077c6p+9,        0x1.81f838p-1053,   0x1.34aa88p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cbf1758e29f5p+9,         0x1.7a842p-1053,   0x1.b98b88p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cc19652bdc24p+9,         0x1.7334ep-1053,    0x1.4cc1bp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cc4154c98e53p+9,         0x1.6c09cp-1053,  -0x1.e897dap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cc6944674082p+9,        0x1.650218p-1053,   0x1.5f0852p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cc913404f2b1p+9,        0x1.5e1d28p-1053,  -0x1.8dd894p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6ccb923a2a4ep+9,         0x1.575a5p-1053,  -0x1.7e7f68p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cce11340570fp+9,        0x1.50b8e8p-1053,  -0x1.116b38p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cd0902de093ep+9,        0x1.4a3848p-1053,   0x1.71e21ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cd30f27bbb6dp+9,        0x1.43d7c8p-1053,  -0x1.66f7e8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cd58e2196d9cp+9,         0x1.3d96dp-1053,  -0x1.587a8cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cd80d1b71fcbp+9,        0x1.3774c8p-1053,   0x1.6d4c7cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cda8c154d1fap+9,         0x1.31711p-1053,   0x1.e55c2ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cdd0b0f28429p+9,         0x1.2b8b1p-1053,   0x1.255232p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cdf8a0903658p+9,        0x1.25c238p-1053,  -0x1.4977c8p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ce20902de887p+9,        0x1.2015f8p-1053,   -0x1.95a94p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ce487fcb9ab6p+9,        0x1.1a85c8p-1053,   -0x1.9a8a5p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ce706f694ce5p+9,        0x1.151118p-1053,  -0x1.7c401ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ce985f06ff14p+9,         0x1.0fb76p-1053,  -0x1.3eb258p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cec04ea4b143p+9,        0x1.0a7818p-1053,  -0x1.f3d198p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cee83e426372p+9,        0x1.0552c8p-1053,   0x1.6339f8p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cf102de015a1p+9,        0x1.0046e8p-1053,   0x1.ecdc8ep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6cf381d7dc7dp+9,         0x1.f6a7ep-1054,  -0x1.8e58a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cf600d1b79ffp+9,         0x1.ecf2fp-1054,  -0x1.6193fep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cf87fcb92c2ep+9,          0x1.e36ep-1054,   0x1.fe9dccp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cfafec56de5dp+9,         0x1.da181p-1054,  -0x1.2f3fdcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cfd7dbf4908cp+9,         0x1.d0f05p-1054,  -0x1.12da8cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6cfffcb9242bbp+9,         0x1.c7f5dp-1054,  -0x1.a16e5ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d027bb2ff4eap+9,         0x1.bf27cp-1054,   0x1.151c1ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d04faacda719p+9,         0x1.b6853p-1054,   0x1.ec52c8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d0779a6b5948p+9,         0x1.ae0d4p-1054,  -0x1.4f6eaep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d09f8a090b77p+9,         0x1.a5bf4p-1054,   0x1.21ee06p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d0c779a6bda6p+9,         0x1.9d9a4p-1054,  -0x1.fb14b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d0ef69446fd5p+9,         0x1.959d9p-1054,   -0x1.df388p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d11758e22204p+9,         0x1.8dc86p-1054,   0x1.099816p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d13f487fd433p+9,         0x1.8619ep-1054,    0x1.7af0fp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d167381d8662p+9,         0x1.7e915p-1054,  -0x1.f84b8ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d18f27bb3891p+9,         0x1.772e1p-1054,   -0x1.44e32p-5, INEXACT|UNDERFLOW)
T(RN,    -0x1.6d1b71758eacp+9,         0x1.6fef5p-1054,   0x1.9cb9cep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d1df06f69cefp+9,         0x1.68d46p-1054,    0x1.feaa4p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d206f6944f1ep+9,         0x1.61dc9p-1054,   0x1.01f58cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d22ee632014dp+9,         0x1.5b073p-1054,  -0x1.83a03ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d256d5cfb37cp+9,         0x1.5453ap-1054,   0x1.dd2008p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d27ec56d65abp+9,         0x1.4dc13p-1054,    0x1.ef585p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d2a6b50b17dap+9,         0x1.474f3p-1054,  -0x1.b21158p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d2cea4a8ca09p+9,         0x1.40fd1p-1054,   -0x1.fd669p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d2f694467c38p+9,         0x1.3aca4p-1054,   0x1.3b9c6ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d31e83e42e67p+9,          0x1.34b6p-1054,  -0x1.fc76d8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d3467381e096p+9,         0x1.2ebfep-1054,   0x1.34e6e6p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d36e631f92c5p+9,         0x1.28e73p-1054,   -0x1.d31eep-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d39652bd44f4p+9,         0x1.232b6p-1054,  -0x1.f5819ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d3be425af723p+9,         0x1.1d8bfp-1054,  -0x1.e8d1e2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d3e631f8a952p+9,         0x1.18085p-1054,  -0x1.c10fb6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d40e21965b81p+9,         0x1.129ffp-1054,   -0x1.03a06p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6d43611340dbp+9,         0x1.0d525p-1054,   0x1.c8a3f6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d45e00d1bfdfp+9,         0x1.081eep-1054,   0x1.713294p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d485f06f720ep+9,         0x1.03052p-1054,  -0x1.b2c9a8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d4ade00d243dp+9,         0x1.fc094p-1055,  -0x1.820a56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d4d5cfaad66cp+9,         0x1.f239cp-1055,   0x1.85928ep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d4fdbf48889bp+9,         0x1.e89acp-1055,    0x1.ac1ffp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d525aee63acap+9,         0x1.df2b4p-1055,    0x1.31f35p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d54d9e83ecf9p+9,         0x1.d5ea6p-1055,   0x1.ca364cp-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d5758e219f28p+9,         0x1.ccd74p-1055,  -0x1.d729d2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d59d7dbf5157p+9,          0x1.c3f1p-1055,  -0x1.771094p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d5c56d5d0386p+9,         0x1.bb36cp-1055,  -0x1.db30f6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d5ed5cfab5b5p+9,         0x1.b2a7cp-1055,   0x1.17ed8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d6154c9867e4p+9,         0x1.aa42ep-1055,  -0x1.f438aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d63d3c361a13p+9,         0x1.a207ap-1055,  -0x1.b3ebe6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d6652bd3cc42p+9,          0x1.99f5p-1055,  -0x1.f4dfd4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d68d1b717e71p+9,         0x1.920a6p-1055,  -0x1.f4ff22p-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.6d6b50b0f30ap+9,         0x1.8a46ep-1055,   0x1.500e9cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d6dcfaace2cfp+9,         0x1.82a9ap-1055,  -0x1.775a1cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d704ea4a94fep+9,         0x1.7b322p-1055,   -0x1.7b606p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d72cd9e8472dp+9,         0x1.73df8p-1055,  -0x1.405ac4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d754c985f95cp+9,         0x1.6cb12p-1055,  -0x1.7df346p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d77cb923ab8bp+9,         0x1.65a64p-1055,   0x1.a5f6d2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d7a4a8c15dbap+9,         0x1.5ebe2p-1055,   -0x1.1fb8fp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d7cc985f0fe9p+9,         0x1.57f82p-1055,  -0x1.fcb0fcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d7f487fcc218p+9,         0x1.5153cp-1055,   0x1.9c41f2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d81c779a7447p+9,         0x1.4ad02p-1055,   0x1.934d6cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d84467382676p+9,         0x1.446cap-1055,  -0x1.bf4bc4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d86c56d5d8a5p+9,         0x1.3e28ep-1055,   0x1.19cc28p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d89446738ad4p+9,          0x1.3804p-1055,   0x1.b21f58p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d8bc36113d03p+9,         0x1.31fd8p-1055,   0x1.4449c2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d8e425aeef32p+9,         0x1.2c14cp-1055,  -0x1.8bd874p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d90c154ca161p+9,         0x1.26494p-1055,  -0x1.edcc06p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6d93404ea539p+9,         0x1.209a6p-1055,  -0x1.e38a7cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d95bf48805bfp+9,         0x1.1b07ap-1055,  -0x1.d7d968p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d983e425b7eep+9,         0x1.15908p-1055,   0x1.1151aep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d9abd3c36a1dp+9,         0x1.10344p-1055,  -0x1.bb5c0ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d9d3c3611c4cp+9,         0x1.0af2ap-1055,   0x1.d280acp-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6d9fbb2fece7bp+9,         0x1.05caep-1055,  -0x1.b99672p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6da23a29c80aap+9,         0x1.00bccp-1055,   0x1.f6434ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6da4b923a32d9p+9,          0x1.f78fp-1056,  -0x1.3a9e1ap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6da7381d7e508p+9,         0x1.edd58p-1056,  -0x1.7439fep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6da9b71759737p+9,         0x1.e44c4p-1056, -0x1.298ecep-10, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dac361134966p+9,          0x1.daf2p-1056,  -0x1.bfe7d8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6daeb50b0fb95p+9,          0x1.d1c6p-1056,  -0x1.7f82b4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6db13404eadc4p+9,         0x1.c8c78p-1056,    0x1.a4f4cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6db3b2fec5ff3p+9,         0x1.bff54p-1056,  -0x1.23406ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6db631f8a1222p+9,         0x1.b74ecp-1056,  -0x1.9f274ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6db8b0f27c451p+9,          0x1.aed3p-1056,   0x1.4e6e44p-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.6dbb2fec5768p+9,         0x1.a6814p-1056,   0x1.897bb2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dbdaee6328afp+9,         0x1.9e588p-1056,    0x1.d697cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dc02de00dadep+9,          0x1.9658p-1056,  -0x1.10610cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dc2acd9e8d0dp+9,         0x1.8e7f4p-1056,    0x1.9d2cep-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dc52bd3c3f3cp+9,         0x1.86cd4p-1056,   0x1.f00cf8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dc7aacd9f16bp+9,         0x1.7f414p-1056,   0x1.cac4bep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dca29c77a39ap+9,         0x1.77da8p-1056,  -0x1.f3d738p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dcca8c1555c9p+9,         0x1.70988p-1056,    0x1.a5155p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dcf27bb307f8p+9,         0x1.697a4p-1056,  -0x1.3c0b8ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dd1a6b50ba27p+9,         0x1.627f4p-1056,  -0x1.92b8cep-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dd425aee6c56p+9,         0x1.5ba6cp-1056,   0x1.fd8574p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dd6a4a8c1e85p+9,           0x1.54fp-1056,  -0x1.4fdd8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dd923a29d0b4p+9,         0x1.4e5a8p-1056,  -0x1.b709aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ddba29c782e3p+9,         0x1.47e5cp-1056,   0x1.1b9f52p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dde219653512p+9,         0x1.4190cp-1056,   0x1.36a2d4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6de0a0902e741p+9,          0x1.3b5bp-1056,   0x1.db3afep-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.6de31f8a0997p+9,          0x1.3544p-1056,   0x1.105e78p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6de59e83e4b9fp+9,          0x1.2f4bp-1056,  -0x1.19003ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6de81d7dbfdcep+9,         0x1.296fcp-1056,    0x1.c12efp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dea9c779affdp+9,         0x1.23b14p-1056,  -0x1.aebbecp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ded1b717622cp+9,         0x1.1e0f4p-1056,  -0x1.7242b6p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6def9a6b5145bp+9,          0x1.1889p-1056,  -0x1.390a8ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6df219652c68ap+9,         0x1.131e4p-1056,   0x1.4d1eacp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6df4985f078b9p+9,          0x1.0dcep-1056,  -0x1.fca5d2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6df71758e2ae8p+9,         0x1.08984p-1056,  -0x1.b88494p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6df99652bdd17p+9,         0x1.037c4p-1056,   0x1.29c81ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dfc154c98f46p+9,          0x1.fcf3p-1057,   0x1.fa598ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6dfe944674175p+9,          0x1.f31fp-1057,   0x1.79a1a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e0113404f3a4p+9,         0x1.e97b8p-1057,    0x1.420aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e03923a2a5d3p+9,         0x1.e0078p-1057,  -0x1.3fdff2p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e06113405802p+9,         0x1.d6c28p-1057,   0x1.301c84p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e08902de0a31p+9,          0x1.cdabp-1057,   -0x1.45ba7p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6e0b0f27bbc6p+9,          0x1.c4c1p-1057,   0x1.5315b2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e0d8e2196e8fp+9,         0x1.bc028p-1057,  -0x1.582b08p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e100d1b720bep+9,         0x1.b36f8p-1057,  -0x1.d08cb8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e128c154d2edp+9,          0x1.ab07p-1057,   0x1.50b8acp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e150b0f2851cp+9,          0x1.a2c8p-1057,   0x1.35d5d2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e178a090374bp+9,         0x1.9ab18p-1057,   -0x1.7ea64p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e1a0902de97ap+9,          0x1.92c3p-1057,  -0x1.cbd448p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e1c87fcb9ba9p+9,          0x1.8afcp-1057,  -0x1.c2fedcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e1f06f694dd8p+9,         0x1.835b8p-1057,   0x1.b7dc9cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e2185f070007p+9,         0x1.7be08p-1057,   0x1.33fdcep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e2404ea4b236p+9,         0x1.748a8p-1057,  -0x1.e52a7cp-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e2683e426465p+9,          0x1.6d59p-1057,   0x1.8fc5aep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e2902de01694p+9,         0x1.664a8p-1057,   -0x1.482f4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e2b81d7dc8c3p+9,         0x1.5f5f8p-1057,   0x1.b0c7bep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e2e00d1b7af2p+9,         0x1.58968p-1057,   0x1.54eab6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e307fcb92d21p+9,          0x1.51efp-1057,   0x1.762d92p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6e32fec56df5p+9,          0x1.4b68p-1057,  -0x1.952aeap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e357dbf4917fp+9,          0x1.4502p-1057,   0x1.47eb5cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e37fcb9243aep+9,          0x1.3ebbp-1057,  -0x1.ed4ac2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e3a7bb2ff5ddp+9,         0x1.38938p-1057,   0x1.24d2dep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e3cfaacda80cp+9,          0x1.328ap-1057,   -0x1.51cb8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e3f79a6b5a3bp+9,         0x1.2c9e8p-1057,   -0x1.efd9ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e41f8a090c6ap+9,         0x1.26d08p-1057,  -0x1.572952p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e44779a6be99p+9,          0x1.211fp-1057,  -0x1.ff325ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e46f694470c8p+9,          0x1.1b8ap-1057,   0x1.83218ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e49758e222f7p+9,           0x1.161p-1057,  -0x1.948d64p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e4bf487fd526p+9,         0x1.10b18p-1057,   0x1.6f33ecp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e4e7381d8755p+9,         0x1.0b6d8p-1057,   0x1.23e6ecp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e50f27bb3984p+9,         0x1.06438p-1057,   0x1.a7e518p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e5371758ebb3p+9,          0x1.0133p-1057,   0x1.ed5f4cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e55f06f69de2p+9,          0x1.f877p-1058,   0x1.e60b62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e586f6945011p+9,          0x1.eeb9p-1058,    0x1.701f9p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6e5aee632024p+9,          0x1.e52bp-1058,   0x1.5acb2ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e5d6d5cfb46fp+9,          0x1.dbccp-1058,   -0x1.ade4bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e5fec56d669ep+9,          0x1.d29cp-1058,  -0x1.ef694ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e626b50b18cdp+9,          0x1.c999p-1058,  -0x1.f2d3fap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e64ea4a8cafcp+9,          0x1.c0c3p-1058,  -0x1.1d097ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e67694467d2bp+9,          0x1.b819p-1058,   0x1.f5171cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e69e83e42f5ap+9,          0x1.af99p-1058,  -0x1.30dbc4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e6c67381e189p+9,          0x1.a743p-1058,  -0x1.a221a8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e6ee631f93b8p+9,          0x1.9f17p-1058,   0x1.bcf438p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e71652bd45e7p+9,          0x1.9713p-1058,   0x1.bf45bcp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e73e425af816p+9,          0x1.8f36p-1058,  -0x1.da7d1ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e76631f8aa45p+9,          0x1.8781p-1058,   0x1.a14244p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e78e21965c74p+9,          0x1.7ff1p-1058,  -0x1.c749dap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e7b611340ea3p+9,          0x1.7887p-1058,  -0x1.77a7bap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e7de00d1c0d2p+9,          0x1.7142p-1058,   0x1.d26e6cp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e805f06f7301p+9,           0x1.6a2p-1058,  -0x1.dc982ep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6e82de00d253p+9,          0x1.6322p-1058,  -0x1.eb0faap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e855cfaad75fp+9,          0x1.5c47p-1058,   0x1.a896a8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e87dbf48898ep+9,          0x1.558dp-1058,   0x1.52c9d2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e8a5aee63bbdp+9,          0x1.4ef4p-1058,  -0x1.54af14p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e8cd9e83edecp+9,          0x1.487cp-1058,  -0x1.c029aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e8f58e21a01bp+9,          0x1.4225p-1058,   0x1.ebbe6ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e91d7dbf524ap+9,          0x1.3becp-1058,   0x1.3af6acp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e9456d5d0479p+9,          0x1.35d2p-1058,  -0x1.425182p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e96d5cfab6a8p+9,          0x1.2fd7p-1058,   0x1.f24d9ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e9954c9868d7p+9,          0x1.29f8p-1058,  -0x1.c9d68ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e9bd3c361b06p+9,          0x1.2437p-1058,  -0x1.8cb224p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6e9e52bd3cd35p+9,          0x1.1e93p-1058,    0x1.cea4ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ea0d1b717f64p+9,          0x1.190ap-1058,  -0x1.da267ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ea350b0f3193p+9,          0x1.139dp-1058,   0x1.332f38p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ea5cfaace3c2p+9,          0x1.0e4ap-1058,  -0x1.60a314p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ea84ea4a95f1p+9,          0x1.0912p-1058,   0x1.6632ccp-5, INEXACT|UNDERFLOW)
T(RN,    -0x1.6eaacd9e8482p+9,          0x1.03f4p-1058,   0x1.d2c572p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ead4c985fa4fp+9,          0x1.fddcp-1059,  -0x1.c011e8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eafcb923ac7ep+9,          0x1.f404p-1059,   -0x1.2eafcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eb24a8c15eadp+9,          0x1.ea5cp-1059,  -0x1.909cfap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eb4c985f10dcp+9,          0x1.e0e4p-1059,  -0x1.c6c734p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eb7487fcc30bp+9,          0x1.d79ap-1059,  -0x1.bb8916p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eb9c779a753ap+9,           0x1.ce8p-1059,   0x1.29071ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ebc467382769p+9,           0x1.c59p-1059,  -0x1.fe15e8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ebec56d5d998p+9,          0x1.bccep-1059,  -0x1.73b8e8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ec1446738bc7p+9,          0x1.b438p-1059,   0x1.f2b2c8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ec3c36113df6p+9,          0x1.abccp-1059,   0x1.7f3b4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ec6425aef025p+9,          0x1.a388p-1059,  -0x1.906276p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ec8c154ca254p+9,          0x1.9b6ep-1059,  -0x1.7bb134p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ecb404ea5483p+9,          0x1.937cp-1059,   -0x1.9bdc4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ecdbf48806b2p+9,          0x1.8bb2p-1059,   0x1.271d5ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ed03e425b8e1p+9,          0x1.840ep-1059,   0x1.d5f124p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6ed2bd3c36b1p+9,           0x1.7c9p-1059,   0x1.b52a72p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ed53c3611d3fp+9,          0x1.7536p-1059,   0x1.9e918cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ed7bb2fecf6ep+9,            0x1.6ep-1059,  -0x1.8f4ffcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eda3a29c819dp+9,           0x1.66fp-1059,   0x1.378428p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6edcb923a33ccp+9,             0x1.6p-1059,  -0x1.e3982cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6edf381d7e5fbp+9,          0x1.5934p-1059,  -0x1.872b84p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ee1b7175982ap+9,          0x1.528ap-1059,  -0x1.81a12cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ee4361134a59p+9,            0x1.4cp-1059,  -0x1.230bdep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ee6b50b0fc88p+9,          0x1.4598p-1059,   0x1.76c1d8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ee93404eaeb7p+9,          0x1.3f4ep-1059,   0x1.591c14p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eebb2fec60e6p+9,          0x1.3924p-1059,   0x1.b7ba32p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6eee31f8a1315p+9,          0x1.3318p-1059,   0x1.cb9a88p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ef0b0f27c544p+9,          0x1.2d28p-1059,  -0x1.ea6c0ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ef32fec57773p+9,          0x1.2758p-1059,  -0x1.0b1a9cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ef5aee6329a2p+9,          0x1.21a4p-1059,  -0x1.b978eep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ef82de00dbd1p+9,          0x1.1c0cp-1059,  -0x1.626842p-4, INEXACT|UNDERFLOW)
T(RN,     -0x1.6efaacd9e8ep+9,           0x1.169p-1059,   0x1.cf936ep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6efd2bd3c402fp+9,          0x1.112ep-1059,  -0x1.a97886p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6effaacd9f25ep+9,          0x1.0be8p-1059,  -0x1.3fa344p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f0229c77a48dp+9,          0x1.06bcp-1059,   0x1.03782ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f04a8c1556bcp+9,          0x1.01aap-1059,   0x1.fa72ccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f0727bb308ebp+9,           0x1.f96p-1060,   0x1.89ce26p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f09a6b50bb1ap+9,          0x1.ef9cp-1060,  -0x1.91085ap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f0c25aee6d49p+9,          0x1.e608p-1060,  -0x1.faf3dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f0ea4a8c1f78p+9,          0x1.dca8p-1060,   0x1.a54e4cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f1123a29d1a7p+9,          0x1.d374p-1060,   0x1.39a86ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f13a29c783d6p+9,          0x1.ca6cp-1060,   0x1.f73816p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f16219653605p+9,           0x1.c19p-1060,  -0x1.9b020cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f18a0902e834p+9,          0x1.b8e4p-1060,   0x1.cdca5cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f1b1f8a09a63p+9,           0x1.b06p-1060,   0x1.f60fe8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f1d9e83e4c92p+9,          0x1.a808p-1060,   0x1.fd078ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f201d7dbfec1p+9,          0x1.9fd4p-1060,  -0x1.ca7bdap-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6f229c779b0fp+9,           0x1.97dp-1060,   0x1.f30968p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f251b717631fp+9,           0x1.8ffp-1060,    0x1.fdb62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f279a6b5154ep+9,          0x1.8834p-1060,  -0x1.cc686ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f2a19652c77dp+9,           0x1.80ap-1060,  -0x1.f83e5cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f2c985f079acp+9,          0x1.7934p-1060,  -0x1.eea21ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f2f1758e2bdbp+9,          0x1.71ecp-1060,   0x1.229fd4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f319652bde0ap+9,          0x1.6ac8p-1060,   0x1.0a3aacp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f34154c99039p+9,          0x1.63c4p-1060,  -0x1.84ea38p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f36944674268p+9,          0x1.5ce8p-1060,   0x1.49cf5cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f3913404f497p+9,          0x1.5628p-1060,  -0x1.de619cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f3b923a2a6c6p+9,           0x1.4f9p-1060,   0x1.aa6b72p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f3e1134058f5p+9,          0x1.4914p-1060,     0x1.11c2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f40902de0b24p+9,          0x1.42b8p-1060,  -0x1.43090cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f430f27bbd53p+9,          0x1.3c7cp-1060,  -0x1.366704p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f458e2196f82p+9,           0x1.366p-1060,   -0x1.34ee9p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f480d1b721b1p+9,          0x1.3064p-1060,    0x1.ca9a1p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6f4a8c154d3ep+9,           0x1.2a8p-1060,  -0x1.71d48ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f4d0b0f2860fp+9,          0x1.24bcp-1060,   -0x1.bd472p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f4f8a090383ep+9,          0x1.1f18p-1060,    0x1.77ea3p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f520902dea6dp+9,          0x1.198cp-1060,    0x1.75421p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f5487fcb9c9cp+9,          0x1.141cp-1060,    0x1.2a0d3p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f5706f694ecbp+9,          0x1.0ec8p-1060,   0x1.8e990cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f5985f0700fap+9,          0x1.098cp-1060,    0x1.61c5cp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f5c04ea4b329p+9,          0x1.046cp-1060,   0x1.e06a22p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f5e83e426558p+9,          0x1.fec8p-1061,   0x1.69654ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f6102de01787p+9,          0x1.f4e8p-1061,  -0x1.180708p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f6381d7dc9b6p+9,           0x1.eb4p-1061,   0x1.13fbe6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f6600d1b7be5p+9,           0x1.e1cp-1061,  -0x1.522b2cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f687fcb92e14p+9,           0x1.d87p-1061,  -0x1.d9070cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f6afec56e043p+9,          0x1.cf58p-1061,   0x1.f81394p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f6d7dbf49272p+9,           0x1.c66p-1061,  -0x1.882d6ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f6ffcb9244a1p+9,          0x1.bd98p-1061,  -0x1.9e08f2p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6f727bb2ff6dp+9,            0x1.b5p-1061,  -0x1.436a58p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f74faacda8ffp+9,           0x1.ac9p-1061,   0x1.fd6384p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f7779a6b5b2ep+9,          0x1.a448p-1061,  -0x1.477258p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f79f8a090d5dp+9,          0x1.9c28p-1061,  -0x1.c45a14p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f7c779a6bf8cp+9,          0x1.9438p-1061,   0x1.0b346cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f7ef694471bbp+9,          0x1.8c68p-1061,   0x1.70ffbep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f81758e223eap+9,           0x1.84cp-1061,   0x1.6af8ccp-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f83f487fd619p+9,           0x1.7d4p-1061,   0x1.e2755cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f867381d8848p+9,           0x1.75ep-1061,  -0x1.635168p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f88f27bb3a77p+9,          0x1.6ea8p-1061,   -0x1.0e838p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f8b71758eca6p+9,          0x1.6798p-1061,   0x1.ca6686p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f8df06f69ed5p+9,           0x1.60ap-1061,   -0x1.6475ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f906f6945104p+9,           0x1.59dp-1061,   -0x1.bd502p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f92ee6320333p+9,          0x1.5328p-1061,   0x1.14b15cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f956d5cfb562p+9,          0x1.4c98p-1061,  -0x1.3674a6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f97ec56d6791p+9,           0x1.463p-1061,   0x1.84884ep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6f9a6b50b19cp+9,           0x1.3fep-1061,  -0x1.dff5dcp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f9cea4a8cbefp+9,           0x1.39bp-1061,  -0x1.8e530ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6f9f694467e1ep+9,          0x1.33a8p-1061,   0x1.da83c2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fa1e83e4304dp+9,           0x1.2dbp-1061,  -0x1.b5fe76p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fa467381e27cp+9,           0x1.27ep-1061,   0x1.459faap-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fa6e631f94abp+9,          0x1.2228p-1061,  -0x1.38c246p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fa9652bd46dap+9,           0x1.1c9p-1061,   0x1.3b1204p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fabe425af909p+9,           0x1.171p-1061,  -0x1.215788p-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fae631f8ab38p+9,           0x1.11bp-1061,   0x1.c8b482p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fb0e21965d67p+9,           0x1.0c6p-1061,  -0x1.be6b2ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fb3611340f96p+9,          0x1.0738p-1061,    0x1.aa388p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fb5e00d1c1c5p+9,           0x1.022p-1061,   0x1.0cd11cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fb85f06f73f4p+9,           0x1.fa4p-1062,  -0x1.b4226ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fbade00d2623p+9,           0x1.f08p-1062,   0x1.286498p-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fbd5cfaad852p+9,           0x1.e6fp-1062,   0x1.a3772ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fbfdbf488a81p+9,           0x1.dd8p-1062,  -0x1.29e63ap-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.6fc25aee63cbp+9,           0x1.d45p-1062,   0x1.93a6d4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fc4d9e83eedfp+9,           0x1.cb4p-1062,   0x1.5ae0eep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fc758e21a10ep+9,           0x1.c26p-1062,  -0x1.367a68p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fc9d7dbf533dp+9,           0x1.b9bp-1062,   0x1.190fc8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fcc56d5d056cp+9,           0x1.b12p-1062,  -0x1.934994p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fced5cfab79bp+9,           0x1.a8dp-1062,   0x1.c247a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fd154c9869cap+9,           0x1.a09p-1062,  -0x1.3ea77ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fd3d3c361bf9p+9,           0x1.989p-1062,   0x1.9d0466p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fd652bd3ce28p+9,           0x1.90ap-1062,  -0x1.7895fcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fd8d1b718057p+9,           0x1.88fp-1062,   0x1.b1b04ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fdb50b0f3286p+9,           0x1.815p-1062,  -0x1.67e9b4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fddcfaace4b5p+9,           0x1.79ep-1062,  -0x1.e8ff0ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fe04ea4a96e4p+9,           0x1.729p-1062,  -0x1.72d47ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fe2cd9e84913p+9,           0x1.6b7p-1062,   0x1.1f876ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fe54c985fb42p+9,           0x1.647p-1062,   0x1.ba1edap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fe7cb923ad71p+9,           0x1.5d8p-1062,  -0x1.c8097cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.6fea4a8c15fap+9,           0x1.56cp-1062,  -0x1.cbd3dep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fecc985f11cfp+9,           0x1.503p-1062,   0x1.d8cd24p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6fef487fcc3fep+9,           0x1.49bp-1062,   0x1.4f1716p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ff1c779a762dp+9,           0x1.435p-1062,   0x1.7ef746p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ff446738285cp+9,           0x1.3d1p-1062,   0x1.46921cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ff6c56d5da8bp+9,           0x1.36fp-1062,   0x1.63bb3ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ff9446738cbap+9,           0x1.30fp-1062,   0x1.d8667ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ffbc36113ee9p+9,           0x1.2b1p-1062,   0x1.53f3f4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.6ffe425aef118p+9,           0x1.254p-1062,  -0x1.1549c2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7000c154ca347p+9,           0x1.1fap-1062,   0x1.5e5af4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7003404ea5576p+9,           0x1.1a1p-1062,   0x1.a45564p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7005bf48807a5p+9,           0x1.14ap-1062,   0x1.68bfa6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70083e425b9d4p+9,           0x1.0f4p-1062,  -0x1.77ee26p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.700abd3c36c03p+9,            0x1.0ap-1062,  -0x1.7ab21ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.700d3c3611e32p+9,           0x1.04ep-1062,  -0x1.659d44p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.700fbb2fed061p+9,           0x1.ffcp-1063,   0x1.bbb4dep-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.70123a29c829p+9,           0x1.f5ep-1063,   0x1.f03baap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7014b923a34bfp+9,           0x1.ec2p-1063,    0x1.31bb8p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.7017381d7e6eep+9,           0x1.e2ap-1063,   0x1.2edb0ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.7019b7175991dp+9,           0x1.d94p-1063,  -0x1.9d4114p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.701c361134b4cp+9,           0x1.d02p-1063,  -0x1.22bf2cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.701eb50b0fd7bp+9,           0x1.c74p-1063,   0x1.b1d9e8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70213404eafaap+9,           0x1.be6p-1063,  -0x1.0389c6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7023b2fec61d9p+9,           0x1.b5cp-1063,   -0x1.27883p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.702631f8a1408p+9,           0x1.ad6p-1063,   0x1.60b94ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7028b0f27c637p+9,            0x1.a5p-1063,  -0x1.506f64p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.702b2fec57866p+9,           0x1.9cep-1063,  -0x1.212e96p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.702daee632a95p+9,           0x1.94ep-1063,  -0x1.f8303ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70302de00dcc4p+9,           0x1.8d2p-1063,   0x1.0d89bep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7032acd9e8ef3p+9,           0x1.858p-1063,   0x1.a9e578p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70352bd3c4122p+9,           0x1.7dep-1063,   -0x1.acc39p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7037aacd9f351p+9,           0x1.768p-1063,  -0x1.a92b2ap-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.703a29c77a58p+9,           0x1.6f6p-1063,   0x1.cba856p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.703ca8c1557afp+9,           0x1.684p-1063,   0x1.907e0cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.703f27bb309dep+9,           0x1.614p-1063,  -0x1.3a9ccap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7041a6b50bc0dp+9,           0x1.5a8p-1063,   0x1.b0ab8cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.704425aee6e3cp+9,           0x1.53cp-1063,  -0x1.c4968ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.7046a4a8c206bp+9,           0x1.4d4p-1063,   0x1.bbcdcap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.704923a29d29ap+9,           0x1.46cp-1063,   -0x1.77099p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.704ba29c784c9p+9,           0x1.408p-1063,   0x1.8ec7dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.704e2196536f8p+9,           0x1.3a4p-1063,  -0x1.abad5ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7050a0902e927p+9,           0x1.344p-1063,   0x1.c86af2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70531f8a09b56p+9,           0x1.2e4p-1063,   0x1.dd92dap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.70559e83e4d85p+9,           0x1.286p-1063,  -0x1.fd15d4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70581d7dbffb4p+9,           0x1.22ap-1063,  -0x1.d41e58p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.705a9c779b1e3p+9,           0x1.1d2p-1063,   0x1.ccccbap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.705d1b7176412p+9,           0x1.17ap-1063,   0x1.f5b2c6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.705f9a6b51641p+9,           0x1.122p-1063,  -0x1.484622p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.706219652c87p+9,           0x1.0cep-1063,   0x1.1d9a3cp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.7064985f07a9fp+9,           0x1.07ap-1063,  -0x1.b5e2dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70671758e2ccep+9,           0x1.02ap-1063,   0x1.3b240cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70699652bdefdp+9,           0x1.fb4p-1064,   0x1.06a4a8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.706c154c9912cp+9,           0x1.f18p-1064,   0x1.bc2d2cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.706e94467435bp+9,           0x1.e7cp-1064,  -0x1.2a021ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.707113404f58ap+9,           0x1.de4p-1064,  -0x1.ddf024p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7073923a2a7b9p+9,           0x1.d54p-1064,   0x1.f00be2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70761134059e8p+9,            0x1.ccp-1064,  -0x1.1ca994p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7078902de0c17p+9,           0x1.c34p-1064,   0x1.0a0bc6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.707b0f27bbe46p+9,           0x1.ba8p-1064,   0x1.c809d2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.707d8e2197075p+9,            0x1.b2p-1064,   0x1.28cc98p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70800d1b722a4p+9,           0x1.a98p-1064,  -0x1.888d92p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70828c154d4d3p+9,           0x1.a14p-1064,  -0x1.482a72p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70850b0f28702p+9,           0x1.994p-1064,  -0x1.5846aap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.70878a0903931p+9,           0x1.914p-1064,  -0x1.e16f04p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.708a0902deb6p+9,           0x1.898p-1064,  -0x1.ddf31cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.708c87fcb9d8fp+9,            0x1.82p-1064,  -0x1.fc5b74p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.708f06f694fbep+9,           0x1.7a8p-1064,  -0x1.f4c242p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.709185f0701edp+9,           0x1.734p-1064,   -0x1.6bf1dp-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.709404ea4b41cp+9,            0x1.6cp-1064,  -0x1.4d8cccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.709683e42664bp+9,            0x1.65p-1064,  -0x1.9eaa74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.709902de0187ap+9,           0x1.5e4p-1064,   0x1.82c23ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.709b81d7dcaa9p+9,           0x1.578p-1064,   0x1.b376e6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.709e00d1b7cd8p+9,           0x1.50cp-1064,  -0x1.957882p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.70a07fcb92f07p+9,           0x1.4a4p-1064,  -0x1.2adc2ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.70a2fec56e136p+9,            0x1.44p-1064,   0x1.e59298p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70a57dbf49365p+9,           0x1.3dcp-1064,   0x1.f80a46p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70a7fcb924594p+9,           0x1.378p-1064,   0x1.bc9662p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.70aa7bb2ff7c3p+9,           0x1.318p-1064,   0x1.6976c8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.70acfaacda9f2p+9,           0x1.2b8p-1064,  -0x1.42da58p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70af79a6b5c21p+9,           0x1.25cp-1064,  -0x1.655d16p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.70b1f8a090e5p+9,             0x1.2p-1064,  -0x1.ec1c26p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70b4779a6c07fp+9,           0x1.1a8p-1064,  -0x1.cc99e8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70b6f694472aep+9,            0x1.15p-1064,   -0x1.98967p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70b9758e224ddp+9,           0x1.0fcp-1064,   0x1.61c53cp-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.70bbf487fd70cp+9,           0x1.0a8p-1064,  -0x1.cf5dc8p-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.70be7381d893bp+9,           0x1.054p-1064,  -0x1.abdb6cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70c0f27bb3b6ap+9,           0x1.004p-1064,  -0x1.d655dap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70c371758ed99p+9,           0x1.f68p-1065,  -0x1.b9b0d4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70c5f06f69fc8p+9,            0x1.edp-1065,  -0x1.f6f1aap-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.70c86f69451f7p+9,           0x1.e38p-1065,   0x1.a5057ep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.70caee6320426p+9,            0x1.dap-1065,   -0x1.342f1p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70cd6d5cfb655p+9,            0x1.d1p-1065,   0x1.81f4f8p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.70cfec56d6884p+9,            0x1.c8p-1065,  -0x1.dd2078p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.70d26b50b1ab3p+9,            0x1.bfp-1065,  -0x1.aad5e4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70d4ea4a8cce2p+9,           0x1.b68p-1065,  -0x1.28408ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70d7694467f11p+9,            0x1.aep-1065,   -0x1.a5eeep-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.70d9e83e4314p+9,            0x1.a6p-1065,   0x1.9f3d22p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70dc67381e36fp+9,           0x1.9d8p-1065,  -0x1.370aaep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70dee631f959ep+9,           0x1.958p-1065,  -0x1.4f76f6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70e1652bd47cdp+9,            0x1.8ep-1065,   0x1.5c30dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70e3e425af9fcp+9,            0x1.86p-1065,  -0x1.2df96cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70e6631f8ac2bp+9,           0x1.7e8p-1065,  -0x1.cff456p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70e8e21965e5ap+9,            0x1.77p-1065,  -0x1.cbf34ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70eb611341089p+9,             0x1.7p-1065,   0x1.5ee1bep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.70ede00d1c2b8p+9,            0x1.69p-1065,   0x1.051904p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70f05f06f74e7p+9,            0x1.62p-1065,    0x1.8a97ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70f2de00d2716p+9,            0x1.5bp-1065,  -0x1.1c3c16p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.70f55cfaad945p+9,           0x1.548p-1065,   0x1.102dfap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70f7dbf488b74p+9,            0x1.4ep-1065,   0x1.a56814p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70fa5aee63da3p+9,           0x1.478p-1065,    0x1.36aebp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.70fcd9e83efd2p+9,            0x1.41p-1065,  -0x1.b7c8bcp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.70ff58e21a201p+9,            0x1.3bp-1065,   0x1.615d06p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.7101d7dbf543p+9,           0x1.348p-1065,  -0x1.fb7b04p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.710456d5d065fp+9,            0x1.2fp-1065,    0x1.b73aep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7106d5cfab88ep+9,            0x1.29p-1065,   0x1.f88d82p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.710954c986abdp+9,            0x1.23p-1065,  -0x1.a233cap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.710bd3c361cecp+9,           0x1.1d8p-1065,  -0x1.4aa6d6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.710e52bd3cf1bp+9,            0x1.18p-1065,  -0x1.0db4bcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7110d1b71814ap+9,           0x1.128p-1065,  -0x1.427d28p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.711350b0f3379p+9,           0x1.0d8p-1065,   0x1.2bfa78p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7115cfaace5a8p+9,            0x1.08p-1065,  -0x1.375212p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71184ea4a97d7p+9,            0x1.03p-1065,  -0x1.a15704p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.711acd9e84a06p+9,            0x1.fcp-1066,  -0x1.8c5e6cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.711d4c985fc35p+9,            0x1.f2p-1066,  -0x1.23b246p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.711fcb923ae64p+9,            0x1.e9p-1066,    0x1.59ac5p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71224a8c16093p+9,            0x1.dfp-1066,  -0x1.ce7944p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7124c985f12c2p+9,            0x1.d6p-1066,    0x1.d3f8ep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.7127487fcc4f1p+9,            0x1.cdp-1066,   0x1.aaed8ap-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.7129c779a772p+9,            0x1.c4p-1066,   0x1.2fe322p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.712c46738294fp+9,            0x1.bbp-1066,  -0x1.113cbap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.712ec56d5db7ep+9,            0x1.b3p-1066,   0x1.2c2ca6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7131446738dadp+9,            0x1.aap-1066,  -0x1.3faf0cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7133c36113fdcp+9,            0x1.a2p-1066,  -0x1.462bfap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7136425aef20bp+9,            0x1.9ap-1066,  -0x1.8ca2f4p-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.7138c154ca43ap+9,            0x1.92p-1066,  -0x1.6a039cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.713b404ea5669p+9,            0x1.8ap-1066,  -0x1.4b60ccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.713dbf4880898p+9,            0x1.83p-1066,   0x1.2a33c6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71403e425bac7p+9,            0x1.7bp-1066,  -0x1.ed9832p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7142bd3c36cf6p+9,            0x1.74p-1066,   0x1.521ff4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.71453c3611f25p+9,            0x1.6dp-1066,   0x1.0f0a12p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7147bb2fed154p+9,            0x1.66p-1066,   0x1.3b8618p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.714a3a29c8383p+9,            0x1.5fp-1066,   0x1.b97458p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.714cb923a35b2p+9,            0x1.58p-1066,  -0x1.55249ap-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.714f381d7e7e1p+9,            0x1.51p-1066,  -0x1.780098p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.7151b71759a1p+9,            0x1.4bp-1066,   0x1.2e9418p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7154361134c3fp+9,            0x1.44p-1066,  -0x1.da3fccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7156b50b0fe6ep+9,            0x1.3ep-1066,  -0x1.944278p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71593404eb09dp+9,            0x1.38p-1066,  -0x1.af4d64p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.715bb2fec62ccp+9,            0x1.32p-1066,  -0x1.b34966p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.715e31f8a14fbp+9,            0x1.2cp-1066,  -0x1.dea518p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7160b0f27c72ap+9,            0x1.26p-1066,  -0x1.48faa2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71632fec57959p+9,            0x1.21p-1066,   0x1.73190ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7165aee632b88p+9,            0x1.1bp-1066,  -0x1.04de88p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.71682de00ddb7p+9,            0x1.16p-1066,   0x1.9c3eecp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.716aacd9e8fe6p+9,             0x1.1p-1066,  -0x1.e4c4c4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.716d2bd3c4215p+9,            0x1.0bp-1066,   0x1.4fad48p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.716faacd9f444p+9,            0x1.06p-1066,   0x1.68c53ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.717229c77a673p+9,            0x1.01p-1066,   0x1.dbadcep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7174a8c1558a2p+9,            0x1.f8p-1067,   0x1.869f68p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.717727bb30ad1p+9,            0x1.eep-1067,   0x1.b5da66p-5, INEXACT|UNDERFLOW)
T(RN,     -0x1.7179a6b50bdp+9,            0x1.e4p-1067,  -0x1.6c0328p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.717c25aee6f2fp+9,            0x1.dcp-1067,    0x1.fef47p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.717ea4a8c215ep+9,            0x1.d2p-1067,   0x1.5dbe2ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.718123a29d38dp+9,            0x1.c8p-1067,  -0x1.aac714p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7183a29c785bcp+9,             0x1.cp-1067,  -0x1.7bc41cp-8, INEXACT|UNDERFLOW)
T(RN,   -0x1.71862196537ebp+9,            0x1.b8p-1067,   0x1.47af4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7188a0902ea1ap+9,            0x1.aep-1067,   -0x1.c03cdp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.718b1f8a09c49p+9,            0x1.a6p-1067,  -0x1.1c0c7ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.718d9e83e4e78p+9,            0x1.9ep-1067,  -0x1.9441fep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71901d7dc00a7p+9,            0x1.96p-1067,  -0x1.91c752p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71929c779b2d6p+9,            0x1.8ep-1067,  -0x1.16c59ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71951b7176505p+9,            0x1.86p-1067,  -0x1.b23fb4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71979a6b51734p+9,             0x1.8p-1067,   0x1.662dacp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.719a19652c963p+9,            0x1.78p-1067,   0x1.9fd58ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.719c985f07b92p+9,             0x1.7p-1067,  -0x1.4767b4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.719f1758e2dc1p+9,            0x1.6ap-1067,   0x1.eae08ep-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.71a19652bdffp+9,            0x1.62p-1067,  -0x1.141a8cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71a4154c9921fp+9,            0x1.5cp-1067,   0x1.3aa792p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71a694467444ep+9,            0x1.54p-1067,  -0x1.f4ef7ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71a913404f67dp+9,            0x1.4ep-1067,   -0x1.932b6p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71ab923a2a8acp+9,            0x1.48p-1067,   0x1.054acap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.71ae113405adbp+9,            0x1.42p-1067,   0x1.961ef8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71b0902de0d0ap+9,            0x1.3cp-1067,   0x1.36d85cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71b30f27bbf39p+9,            0x1.36p-1067,   0x1.653982p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71b58e2197168p+9,             0x1.3p-1067,   0x1.576282p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71b80d1b72397p+9,            0x1.2ap-1067,   0x1.0e7d0ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71ba8c154d5c6p+9,            0x1.24p-1067,   0x1.175a38p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71bd0b0f287f5p+9,            0x1.1ep-1067,   -0x1.7f783p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.71bf8a0903a24p+9,            0x1.18p-1067,  -0x1.233e8cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71c20902dec53p+9,            0x1.14p-1067,   0x1.b2d1e6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71c487fcb9e82p+9,            0x1.0ep-1067,   0x1.4d416ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.71c706f6950b1p+9,            0x1.08p-1067,  -0x1.40ba56p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.71c985f0702ep+9,            0x1.04p-1067,   0x1.ef6b18p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71cc04ea4b50fp+9,            0x1.fcp-1068,  -0x1.02614ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71ce83e42673ep+9,            0x1.f4p-1068,   0x1.a3f5cap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71d102de0196dp+9,            0x1.e8p-1068,  -0x1.8a40e4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71d381d7dcb9cp+9,             0x1.ep-1068,  -0x1.6246dap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.71d600d1b7dcbp+9,            0x1.d8p-1068,   0x1.2f3bdep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71d87fcb92ffap+9,            0x1.ccp-1068,  -0x1.b938f6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71dafec56e229p+9,            0x1.c4p-1068,  -0x1.9d40acp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71dd7dbf49458p+9,            0x1.bcp-1068,  -0x1.01c0cep-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.71dffcb924687p+9,            0x1.b4p-1068,   0x1.065b9ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71e27bb2ff8b6p+9,            0x1.acp-1068,   0x1.d825e4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71e4faacdaae5p+9,            0x1.a4p-1068,    0x1.2b64fp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71e779a6b5d14p+9,            0x1.9cp-1068,    0x1.41f15p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71e9f8a090f43p+9,            0x1.94p-1068,   0x1.3081a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71ec779a6c172p+9,            0x1.8cp-1068,   0x1.efb72ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71eef694473a1p+9,            0x1.84p-1068,   0x1.318202p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.71f1758e225dp+9,            0x1.7cp-1068,   0x1.3efffap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.71f3f487fd7ffp+9,            0x1.74p-1068,  -0x1.2bb9fcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71f67381d8a2ep+9,            0x1.6cp-1068,   -0x1.63ef2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71f8f27bb3c5dp+9,            0x1.68p-1068,   0x1.aa6ce6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.71fb71758ee8cp+9,             0x1.6p-1068,   0x1.2bcddap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.71fdf06f6a0bbp+9,            0x1.58p-1068,   -0x1.41a93p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72006f69452eap+9,             0x1.5p-1068,  -0x1.f91c8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7202ee6320519p+9,            0x1.4cp-1068,   0x1.1b69dcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72056d5cfb748p+9,            0x1.44p-1068,  -0x1.0bbd86p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7207ec56d6977p+9,             0x1.4p-1068,   0x1.3b2b9ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.720a6b50b1ba6p+9,            0x1.38p-1068,  -0x1.39e68ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.720cea4a8cdd5p+9,            0x1.34p-1068,   0x1.6c7f46p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.720f694468004p+9,            0x1.2cp-1068,  -0x1.4fcca2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7211e83e43233p+9,            0x1.28p-1068,   0x1.266f7cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.721467381e462p+9,             0x1.2p-1068,  -0x1.27ee9ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7216e631f9691p+9,            0x1.1cp-1068,   0x1.b6350ep-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.7219652bd48cp+9,            0x1.18p-1068,   0x1.e76e4ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.721be425afaefp+9,             0x1.1p-1068,  -0x1.738628p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.721e631f8ad1ep+9,            0x1.0cp-1068,     0x1.14fep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7220e21965f4dp+9,            0x1.08p-1068,   0x1.b4b7c6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.722361134117cp+9,               0x1p-1068,  -0x1.3a980cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7225e00d1c3abp+9,            0x1.f8p-1069,  -0x1.0bc8ecp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.72285f06f75dap+9,             0x1.fp-1069,   0x1.384a08p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.722ade00d2809p+9,            0x1.e8p-1069,   0x1.632716p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.722d5cfaada38p+9,            0x1.d8p-1069,  -0x1.ed74f4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.722fdbf488c67p+9,             0x1.dp-1069,  -0x1.553a5ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72325aee63e96p+9,            0x1.c8p-1069,  -0x1.a76d38p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7234d9e83f0c5p+9,             0x1.cp-1069,  -0x1.a1e5bap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.723758e21a2f4p+9,            0x1.b8p-1069,  -0x1.314b16p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.7239d7dbf5523p+9,             0x1.bp-1069,   0x1.671ccep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.723c56d5d0752p+9,            0x1.a8p-1069,    0x1.5f657p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.723ed5cfab981p+9,             0x1.ap-1069,   0x1.b8d1ccp-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.724154c986bbp+9,            0x1.98p-1069,   0x1.c16aeap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7243d3c361ddfp+9,             0x1.9p-1069,   0x1.7ac05ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.724652bd3d00ep+9,            0x1.88p-1069,   0x1.ccb404p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.7248d1b71823dp+9,             0x1.8p-1069,   0x1.6e07cp-10, INEXACT|UNDERFLOW)
T(RN,   -0x1.724b50b0f346cp+9,            0x1.78p-1069,  -0x1.25ac6cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.724dcfaace69bp+9,             0x1.7p-1069,  -0x1.4d3104p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72504ea4a98cap+9,            0x1.68p-1069,  -0x1.15bf92p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7252cd9e84af9p+9,             0x1.6p-1069,  -0x1.96876ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72554c985fd28p+9,             0x1.6p-1069,   0x1.d76716p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7257cb923af57p+9,            0x1.58p-1069,   0x1.34616ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.725a4a8c16186p+9,             0x1.5p-1069,   0x1.0176bep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.725cc985f13b5p+9,            0x1.48p-1069,  -0x1.0ce35ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.725f487fcc5e4p+9,             0x1.4p-1069,  -0x1.172a9ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7261c779a7813p+9,            0x1.38p-1069,  -0x1.facaeap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7264467382a42p+9,            0x1.38p-1069,    0x1.1233dp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7266c56d5dc71p+9,             0x1.3p-1069,   0x1.01d92ap-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.7269446738eap+9,            0x1.28p-1069,  -0x1.00c312p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.726bc361140cfp+9,            0x1.28p-1069,   0x1.dfdb04p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.726e425aef2fep+9,             0x1.2p-1069,   0x1.647f0ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7270c154ca52dp+9,            0x1.18p-1069,  -0x1.129e74p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7273404ea575cp+9,             0x1.1p-1069,  -0x1.d28c42p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7275bf488098bp+9,             0x1.1p-1069,   0x1.ad981cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72783e425bbbap+9,            0x1.08p-1069,  -0x1.1a07eap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.727abd3c36de9p+9,               0x1p-1069,   -0x1.fdbb4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.727d3c3612018p+9,               0x1p-1069,   0x1.09cbf2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.727fbb2fed247p+9,             0x1.fp-1070,  -0x1.04e1bep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72823a29c8476p+9,             0x1.fp-1070,   0x1.652af6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7284b923a36a5p+9,             0x1.ep-1070,    -0x1.e5bep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.7287381d7e8d4p+9,             0x1.dp-1070,   -0x1.ea4eep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7289b71759b03p+9,             0x1.dp-1070,   0x1.727dcep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.728c361134d32p+9,             0x1.cp-1070,  -0x1.67b406p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.728eb50b0ff61p+9,             0x1.cp-1070,    0x1.91dcbp-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.72913404eb19p+9,             0x1.bp-1070,  -0x1.1142dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7293b2fec63bfp+9,             0x1.bp-1070,   0x1.09ede2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.729631f8a15eep+9,             0x1.ap-1070,   -0x1.ca95ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7298b0f27c81dp+9,             0x1.ap-1070,   0x1.214626p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.729b2fec57a4cp+9,             0x1.9p-1070,  -0x1.c458bep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.729daee632c7bp+9,             0x1.9p-1070,   0x1.108f02p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72a02de00deaap+9,             0x1.8p-1070,  -0x1.06572cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72a2acd9e90d9p+9,             0x1.8p-1070,   0x1.b2a16ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72a52bd3c4308p+9,             0x1.7p-1070,  -0x1.504aa6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72a7aacd9f537p+9,             0x1.7p-1070,   0x1.f41222p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.72aa29c77a766p+9,             0x1.6p-1070,  -0x1.be94d6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72aca8c155995p+9,             0x1.6p-1070,  -0x1.755ae2p-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.72af27bb30bc4p+9,             0x1.6p-1070,   0x1.b02e18p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72b1a6b50bdf3p+9,             0x1.5p-1070,   -0x1.4a402p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72b425aee7022p+9,             0x1.5p-1070,   0x1.faa8b4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72b6a4a8c2251p+9,             0x1.4p-1070,  -0x1.684becp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.72b923a29d48p+9,             0x1.4p-1070,   0x1.51387cp-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.72bba29c786afp+9,             0x1.4p-1070,   0x1.b4d47ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72be2196538dep+9,             0x1.3p-1070,  -0x1.903a7ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72c0a0902eb0dp+9,             0x1.3p-1070,    0x1.66ef2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72c31f8a09d3cp+9,             0x1.2p-1070,  -0x1.d84826p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72c59e83e4f6bp+9,             0x1.2p-1070,  -0x1.ace084p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.72c81d7dc019ap+9,             0x1.2p-1070,   0x1.f5964cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72ca9c779b3c9p+9,             0x1.1p-1070,  -0x1.a61b76p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72cd1b71765f8p+9,             0x1.1p-1070,  -0x1.37271cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.72cf9a6b51827p+9,             0x1.1p-1070,   0x1.03e1b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72d219652ca56p+9,               0x1p-1070,  -0x1.b0f81ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72d4985f07c85p+9,               0x1p-1070,  -0x1.b0dc18p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.72d71758e2eb4p+9,               0x1p-1070,   0x1.a48932p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72d99652be0e3p+9,             0x1.ep-1071,   -0x1.f5664p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72dc154c99312p+9,             0x1.ep-1071,   -0x1.86325p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72de944674541p+9,             0x1.ep-1071,   0x1.a526c6p-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.72e113404f77p+9,             0x1.ep-1071,   0x1.8fdf8ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72e3923a2a99fp+9,             0x1.cp-1071,   -0x1.4f3afp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72e6113405bcep+9,             0x1.cp-1071,  -0x1.9f4ce6p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.72e8902de0dfdp+9,             0x1.cp-1071,   0x1.c3de2ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72eb0f27bc02cp+9,             0x1.cp-1071,   0x1.f26a38p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72ed8e219725bp+9,             0x1.ap-1071,  -0x1.025db4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72f00d1b7248ap+9,             0x1.ap-1071,   0x1.d8ab1cp-9, INEXACT|UNDERFLOW)
T(RN,   -0x1.72f28c154d6b9p+9,             0x1.ap-1071,   0x1.04b0dap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72f50b0f288e8p+9,             0x1.8p-1071,  -0x1.ff4622p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72f78a0903b17p+9,             0x1.8p-1071,  -0x1.081b18p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.72fa0902ded46p+9,             0x1.8p-1071,  -0x1.5b5f7ap-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.72fc87fcb9f75p+9,             0x1.8p-1071,   0x1.b001b2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.72ff06f6951a4p+9,             0x1.8p-1071,   0x1.c1207cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.730185f0703d3p+9,             0x1.6p-1071,  -0x1.5a405ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.730404ea4b602p+9,             0x1.6p-1071,  -0x1.e82dacp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.730683e426831p+9,             0x1.6p-1071,   0x1.87547cp-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.730902de01a6p+9,             0x1.6p-1071,   0x1.3976aap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.730b81d7dcc8fp+9,             0x1.4p-1071,  -0x1.f311ccp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.730e00d1b7ebep+9,             0x1.4p-1071,  -0x1.23afacp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73107fcb930edp+9,             0x1.4p-1071,  -0x1.613b1ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7312fec56e31cp+9,             0x1.4p-1071,   0x1.bc92c2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73157dbf4954bp+9,             0x1.4p-1071,   0x1.32be24p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7317fcb92477ap+9,             0x1.4p-1071,   0x1.f2909ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.731a7bb2ff9a9p+9,             0x1.2p-1071,  -0x1.515136p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.731cfaacdabd8p+9,             0x1.2p-1071,  -0x1.31aa0ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.731f79a6b5e07p+9,             0x1.2p-1071,   0x1.c17236p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.7321f8a091036p+9,             0x1.2p-1071,   0x1.9b09c4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7324779a6c265p+9,             0x1.2p-1071,   0x1.7b857cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7326f69447494p+9,               0x1p-1071,   -0x1.d9d62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7329758e226c3p+9,               0x1p-1071,  -0x1.327d54p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.732bf487fd8f2p+9,               0x1p-1071,  -0x1.1cbfa8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.732e7381d8b21p+9,               0x1p-1071,   0x1.29257ap-6, INEXACT|UNDERFLOW)
T(RN,    -0x1.7330f27bb3d5p+9,               0x1p-1071,   0x1.60d1b4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.733371758ef7fp+9,               0x1p-1071,   0x1.4b3312p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7335f06f6a1aep+9,               0x1p-1071,    0x1.e3001p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73386f69453ddp+9,             0x1.cp-1072,  -0x1.882166p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.733aee632060cp+9,             0x1.cp-1072,  -0x1.ec45a2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.733d6d5cfb83bp+9,             0x1.cp-1072,  -0x1.9bd7e6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.733fec56d6a6ap+9,             0x1.cp-1072,   0x1.2b9878p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.73426b50b1c99p+9,             0x1.cp-1072,   0x1.5e4be8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7344ea4a8cec8p+9,             0x1.cp-1072,   0x1.36301ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73476944680f7p+9,             0x1.cp-1072,    0x1.ba9ebp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7349e83e43326p+9,             0x1.8p-1072,   -0x1.c3817p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.734c67381e555p+9,             0x1.8p-1072,  -0x1.44239cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.734ee631f9784p+9,             0x1.8p-1072,  -0x1.8e76e2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7351652bd49b3p+9,             0x1.8p-1072,   -0x1.32f31p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7353e425afbe2p+9,             0x1.8p-1072,   0x1.5b22b4p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.7356631f8ae11p+9,             0x1.8p-1072,   0x1.426722p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.7358e2196604p+9,             0x1.8p-1072,   0x1.14bc62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.735b61134126fp+9,             0x1.8p-1072,   0x1.860a0ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.735de00d1c49ep+9,             0x1.8p-1072,   0x1.f52792p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73605f06f76cdp+9,             0x1.4p-1072,  -0x1.9de038p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7362de00d28fcp+9,             0x1.4p-1072,  -0x1.3302b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73655cfaadb2bp+9,             0x1.4p-1072,  -0x1.946b06p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7367dbf488d5ap+9,             0x1.4p-1072,  -0x1.8db9a4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.736a5aee63f89p+9,             0x1.4p-1072,  0x1.5c980cp-10, INEXACT|UNDERFLOW)
T(RN,   -0x1.736cd9e83f1b8p+9,             0x1.4p-1072,   0x1.90d542p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.736f58e21a3e7p+9,             0x1.4p-1072,   0x1.8a4abep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7371d7dbf5616p+9,             0x1.4p-1072,   0x1.243634p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.737456d5d0845p+9,             0x1.4p-1072,    0x1.81711p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7376d5cfaba74p+9,             0x1.4p-1072,   0x1.dcdf08p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.737954c986ca3p+9,               0x1p-1072,    -0x1.c977p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.737bd3c361ed2p+9,               0x1p-1072,  -0x1.71884cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.737e52bd3d101p+9,               0x1p-1072,  -0x1.1b4c4cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.7380d1b71833p+9,               0x1p-1072,  -0x1.8d753ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.738350b0f355fp+9,               0x1p-1072,  -0x1.cf2c08p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7385cfaace78ep+9,               0x1p-1072,  -0x1.13ab42p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.73884ea4a99bdp+9,               0x1p-1072,   0x1.6a70d6p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.738acd9e84becp+9,               0x1p-1072,   0x1.ee1d2cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.738d4c985fe1bp+9,               0x1p-1072,   0x1.907b8cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.738fcb923b04ap+9,               0x1p-1072,   0x1.137904p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73924a8c16279p+9,               0x1p-1072,   0x1.5d4056p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7394c985f14a8p+9,               0x1p-1072,   0x1.a59aecp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7397487fcc6d7p+9,               0x1p-1072,   0x1.ec8fd2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7399c779a7906p+9,             0x1.8p-1073,  -0x1.cdda12p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.739c467382b35p+9,             0x1.8p-1073,  -0x1.899bf8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.739ec56d5dd64p+9,             0x1.8p-1073,  -0x1.46af3cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73a1446738f93p+9,             0x1.8p-1073,  -0x1.050d5ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73a3c361141c2p+9,             0x1.8p-1073,  -0x1.895fdep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73a6425aef3f1p+9,             0x1.8p-1073,  -0x1.0b216cp-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.73a8c154ca62p+9,             0x1.8p-1073,  -0x1.1ea62ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73ab404ea584fp+9,             0x1.8p-1073,  -0x1.5e8cb6p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.73adbf4880a7ep+9,             0x1.8p-1073,   0x1.84a50ap-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.73b03e425bcadp+9,             0x1.8p-1073,   0x1.abdd58p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73b2bd3c36edcp+9,             0x1.8p-1073,   0x1.4872cep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73b53c361210bp+9,             0x1.8p-1073,   0x1.b8c0d2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73b7bb2fed33ap+9,             0x1.8p-1073,    0x1.1371dp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73ba3a29c8569p+9,             0x1.8p-1073,   0x1.4972fcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73bcb923a3798p+9,             0x1.8p-1073,   0x1.7e692ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73bf381d7e9c7p+9,             0x1.8p-1073,   0x1.b2598cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73c1b71759bf6p+9,             0x1.8p-1073,   0x1.e54926p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73c4361134e25p+9,               0x1p-1073,   -0x1.e8c31p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73c6b50b10054p+9,               0x1p-1073,  -0x1.b7c638p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73c93404eb283p+9,               0x1p-1073,  -0x1.87bb8cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73cbb2fec64b2p+9,               0x1p-1073,  -0x1.589e62p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73ce31f8a16e1p+9,               0x1p-1073,  -0x1.2a6a22p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.73d0b0f27c91p+9,               0x1p-1073,  -0x1.fa3496p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73d32fec57b3fp+9,               0x1p-1073,  -0x1.a154eep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73d5aee632d6ep+9,               0x1p-1073,   -0x1.4a2cap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73d82de00df9dp+9,               0x1p-1073,  -0x1.e96668p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73daacd9e91ccp+9,               0x1p-1073,  -0x1.41c0aap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73dd2bd3c43fbp+9,               0x1p-1073,  -0x1.3aaf6ep-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.73dfaacd9f62ap+9,               0x1p-1073,  0x1.f23a36p-11, INEXACT|UNDERFLOW)
T(RN,   -0x1.73e229c77a859p+9,               0x1p-1073,   0x1.440712p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.73e4a8c155a88p+9,               0x1p-1073,   0x1.3d14eap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73e727bb30cb7p+9,               0x1p-1073,   0x1.d527b4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.73e9a6b50bee6p+9,               0x1p-1073,   0x1.352558p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73ec25aee7115p+9,               0x1p-1073,   0x1.7e4632p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73eea4a8c2344p+9,               0x1p-1073,   0x1.c5fd88p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.73f123a29d573p+9,               0x1p-1073,   0x1.06292ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73f3a29c787a2p+9,               0x1p-1073,   0x1.28a5b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73f62196539d1p+9,               0x1p-1073,   0x1.4a77c6p-2, INEXACT|UNDERFLOW)
T(RN,     -0x1.73f8a0902ecp+9,               0x1p-1073,   0x1.6ba2a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73fb1f8a09e2fp+9,               0x1p-1073,   0x1.8c298ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.73fd9e83e505ep+9,               0x1p-1073,   0x1.ac0fa2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74001d7dc028dp+9,               0x1p-1073,   0x1.cb5808p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74029c779b4bcp+9,               0x1p-1073,   0x1.ea05c8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74051b71766ebp+9,               0x1p-1074,  -0x1.f7e422p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74079a6b5191ap+9,               0x1p-1074,  -0x1.da62c8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.740a19652cb49p+9,               0x1p-1074,  -0x1.bd734cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.740c985f07d78p+9,               0x1p-1074,  -0x1.a112dcp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.740f1758e2fa7p+9,               0x1p-1074,  -0x1.853eb6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74119652be1d6p+9,               0x1p-1074,  -0x1.69f422p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7414154c99405p+9,               0x1p-1074,  -0x1.4f3078p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7416944674634p+9,               0x1p-1074,   -0x1.34f12p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.741913404f863p+9,               0x1p-1074,  -0x1.1b338ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.741b923a2aa92p+9,               0x1p-1074,  -0x1.01f532p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.741e113405cc1p+9,               0x1p-1074,   -0x1.d2675p-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.7420902de0efp+9,               0x1p-1074,    -0x1.a1d9p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74230f27bc11fp+9,               0x1p-1074,  -0x1.723abcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74258e219734ep+9,               0x1p-1074,  -0x1.4387dep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74280d1b7257dp+9,               0x1p-1074,  -0x1.15bbdep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.742a8c154d7acp+9,               0x1p-1074,  -0x1.d1a48ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.742d0b0f289dbp+9,               0x1p-1074,  -0x1.798d68p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.742f8a0903c0ap+9,               0x1p-1074,  -0x1.2329c4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.74320902dee39p+9,               0x1p-1074,  -0x1.9ce264p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.743487fcba068p+9,               0x1p-1074,  -0x1.ed6dd6p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.743706f695297p+9,               0x1p-1074,  -0x1.4f03b6p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.743985f0704c6p+9,               0x1p-1074,   0x1.303dc6p-7, INEXACT|UNDERFLOW)
T(RN,   -0x1.743c04ea4b6f5p+9,               0x1p-1074,    0x1.d1938p-6, INEXACT|UNDERFLOW)
T(RN,   -0x1.743e83e426924p+9,               0x1p-1074,    0x1.827d4p-5, INEXACT|UNDERFLOW)
T(RN,   -0x1.744102de01b53p+9,               0x1p-1074,   0x1.0c9c74p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.744381d7dcd82p+9,               0x1p-1074,   0x1.5685b2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.744600d1b7fb1p+9,               0x1p-1074,   0x1.9f018ep-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.74487fcb931ep+9,               0x1p-1074,   0x1.e61712p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.744afec56e40fp+9,               0x1p-1074,   0x1.15e696p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.744d7dbf4963ep+9,               0x1p-1074,   0x1.381554p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.744ffcb92486dp+9,               0x1p-1074,   0x1.599b14p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74527bb2ffa9cp+9,               0x1p-1074,   0x1.7a7b1cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7454faacdaccbp+9,               0x1p-1074,   0x1.9ab89ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.745779a6b5efap+9,               0x1p-1074,   0x1.ba56bcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7459f8a091129p+9,               0x1p-1074,   0x1.d9588ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.745c779a6c358p+9,               0x1p-1074,   0x1.f7c114p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.745ef69447587p+9,               0x1p-1074,   0x1.0ac9a4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7461758e227b6p+9,               0x1p-1074,   0x1.196906p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7463f487fd9e5p+9,               0x1p-1074,    0x1.27c02p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74667381d8c14p+9,               0x1p-1074,   0x1.35d054p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7468f27bb3e43p+9,               0x1p-1074,   0x1.439b04p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.746b71758f072p+9,               0x1p-1074,   0x1.512184p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.746df06f6a2a1p+9,               0x1p-1074,   0x1.5e6526p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.74706f69454dp+9,               0x1p-1074,   0x1.6b6736p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7472ee63206ffp+9,               0x1p-1074,   0x1.7828f6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74756d5cfb92ep+9,               0x1p-1074,   0x1.84aba8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7477ec56d6b5dp+9,               0x1p-1074,   0x1.90f07ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.747a6b50b1d8cp+9,               0x1p-1074,    0x1.9cf8bp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.747cea4a8cfbbp+9,               0x1p-1074,   0x1.a8c564p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.747f6944681eap+9,               0x1p-1074,   0x1.b457c4p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7481e83e43419p+9,               0x1p-1074,   0x1.bfb0eep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.748467381e648p+9,               0x1p-1074,     0x1.cad2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7486e631f9877p+9,               0x1p-1074,   0x1.d5bc0cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7489652bd4aa6p+9,               0x1p-1074,   0x1.e07022p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.748be425afcd5p+9,               0x1p-1074,    0x1.eaef5p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.748e631f8af04p+9,               0x1p-1074,   0x1.f53a98p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7490e21966133p+9,               0x1p-1074,   0x1.ff52fep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7493611341362p+9,                  0x0p+0,  -0x1.f6c686p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.7495e00d1c591p+9,                  0x0p+0,  -0x1.ed10fcp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.74985f06f77cp+9,                  0x0p+0,   -0x1.e38b7p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.749ade00d29efp+9,                  0x0p+0,  -0x1.da34f8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.749d5cfaadc1ep+9,                  0x0p+0,  -0x1.d10ca8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.749fdbf488e4dp+9,                  0x0p+0,  -0x1.c8119ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74a25aee6407cp+9,                  0x0p+0,  -0x1.bf42fap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74a4d9e83f2abp+9,                  0x0p+0,   -0x1.b69fep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74a758e21a4dap+9,                  0x0p+0,  -0x1.ae277ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74a9d7dbf5709p+9,                  0x0p+0,  -0x1.a5d8f2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74ac56d5d0938p+9,                  0x0p+0,  -0x1.9db37cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74aed5cfabb67p+9,                  0x0p+0,  -0x1.95b64ap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74b154c986d96p+9,                  0x0p+0,  -0x1.8de098p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74b3d3c361fc5p+9,                  0x0p+0,  -0x1.8631a2p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74b652bd3d1f4p+9,                  0x0p+0,  -0x1.7ea8a8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74b8d1b718423p+9,                  0x0p+0,  -0x1.7744ecp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74bb50b0f3652p+9,                  0x0p+0,  -0x1.7005bap-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74bdcfaace881p+9,                  0x0p+0,  -0x1.68ea5cp-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.74c04ea4a9abp+9,                  0x0p+0,  -0x1.61f21ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74c2cd9e84cdfp+9,                  0x0p+0,  -0x1.5b1c56p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74c54c985ff0ep+9,                  0x0p+0,  -0x1.546858p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74c7cb923b13dp+9,                  0x0p+0,  -0x1.4dd57ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74ca4a8c1636cp+9,                  0x0p+0,  -0x1.476322p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74ccc985f159bp+9,                  0x0p+0,  -0x1.4110a6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74cf487fcc7cap+9,                  0x0p+0,  -0x1.3add6cp-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74d1c779a79f9p+9,                  0x0p+0,  -0x1.34c8d8p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74d4467382c28p+9,                  0x0p+0,  -0x1.2ed252p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74d6c56d5de57p+9,                  0x0p+0,  -0x1.28f948p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74d9446739086p+9,                  0x0p+0,  -0x1.233d26p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74dbc361142b5p+9,                  0x0p+0,  -0x1.1d9d5ep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74de425aef4e4p+9,                  0x0p+0,  -0x1.181964p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74e0c154ca713p+9,                  0x0p+0,  -0x1.12b0aep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74e3404ea5942p+9,                  0x0p+0,  -0x1.0d62b6p-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74e5bf4880b71p+9,                  0x0p+0,  -0x1.082ef6p-2, INEXACT|UNDERFLOW)
T(RN,    -0x1.74e83e425bdap+9,                  0x0p+0,  -0x1.0314eep-2, INEXACT|UNDERFLOW)
T(RN,   -0x1.74eabd3c36fcfp+9,                  0x0p+0,   -0x1.fc284p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74ed3c36121fep+9,                  0x0p+0,  -0x1.f2581ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74efbb2fed42dp+9,                  0x0p+0,  -0x1.e8b878p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74f23a29c865cp+9,                  0x0p+0,  -0x1.df4868p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74f4b923a388bp+9,                  0x0p+0,  -0x1.d60702p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74f7381d7eabap+9,                  0x0p+0,  -0x1.ccf35cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74f9b71759ce9p+9,                  0x0p+0,  -0x1.c40c94p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74fc361134f18p+9,                  0x0p+0,   -0x1.bb51dp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.74feb50b10147p+9,                  0x0p+0,  -0x1.b2c232p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.75013404eb376p+9,                  0x0p+0,  -0x1.aa5ce8p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7503b2fec65a5p+9,                  0x0p+0,   -0x1.a2212p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.750631f8a17d4p+9,                  0x0p+0,  -0x1.9a0e0ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7508b0f27ca03p+9,                  0x0p+0,   -0x1.9222ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.750b2fec57c32p+9,                  0x0p+0,  -0x1.8a5edcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.750daee632e61p+9,                  0x0p+0,  -0x1.82c13ap-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.75102de00e09p+9,                  0x0p+0,   -0x1.7b494p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7512acd9e92bfp+9,                  0x0p+0,  -0x1.73f632p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.75152bd3c44eep+9,                  0x0p+0,  -0x1.6cc75ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7517aacd9f71dp+9,                  0x0p+0,  -0x1.65bc04p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.751a29c77a94cp+9,                  0x0p+0,   -0x1.5ed38p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.751ca8c155b7bp+9,                  0x0p+0,  -0x1.580d24p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.751f27bb30daap+9,                  0x0p+0,  -0x1.516848p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7521a6b50bfd9p+9,                  0x0p+0,  -0x1.4ae442p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.752425aee7208p+9,                  0x0p+0,  -0x1.448072p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7526a4a8c2437p+9,                  0x0p+0,  -0x1.3e3c3ap-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.752923a29d666p+9,                  0x0p+0,  -0x1.3816fcp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.752ba29c78895p+9,                  0x0p+0,   -0x1.32102p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.752e219653ac4p+9,                  0x0p+0,  -0x1.2c270ep-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7530a0902ecf3p+9,                  0x0p+0,  -0x1.265b36p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.75331f8a09f22p+9,                  0x0p+0,  -0x1.20ac04p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.75359e83e5151p+9,                  0x0p+0,  -0x1.1b18eep-3, INEXACT|UNDERFLOW)
T(RN,    -0x1.75381d7dc038p+9,                  0x0p+0,  -0x1.15a166p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.753a9c779b5afp+9,                  0x0p+0,  -0x1.1044e4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.753d1b71767dep+9,                  0x0p+0,  -0x1.0b02e4p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.753f9a6b51a0dp+9,                  0x0p+0,  -0x1.05dae2p-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.754219652cc3cp+9,                  0x0p+0,  -0x1.00cc5cp-3, INEXACT|UNDERFLOW)
T(RN,   -0x1.7544985f07e6bp+9,                  0x0p+0,   -0x1.f7adbp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.75471758e309ap+9,                  0x0p+0,  -0x1.edf3aep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.75499652be2c9p+9,                  0x0p+0,  -0x1.e469c2p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.754c154c994f8p+9,                  0x0p+0,  -0x1.db0efep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.754e944674727p+9,                  0x0p+0,  -0x1.d1e278p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.755113404f956p+9,                  0x0p+0,  -0x1.c8e34ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7553923a2ab85p+9,                  0x0p+0,  -0x1.c0109ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7556113405db4p+9,                  0x0p+0,  -0x1.b7698ap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.7558902de0fe3p+9,                  0x0p+0,  -0x1.aeed3ep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.755b0f27bc212p+9,                  0x0p+0,  -0x1.a69ae6p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.755d8e2197441p+9,                  0x0p+0,   -0x1.9e71bp-4, INEXACT|UNDERFLOW)
T(RN,    -0x1.75600d1b7267p+9,                  0x0p+0,  -0x1.9670d4p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.75628c154d89fp+9,                  0x0p+0,  -0x1.8e9786p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.75650b0f28acep+9,                  0x0p+0,  -0x1.86e508p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.75678a0903cfdp+9,                  0x0p+0,  -0x1.7f5896p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.756a0902def2cp+9,                  0x0p+0,  -0x1.77f176p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.756c87fcba15bp+9,                  0x0p+0,  -0x1.70aeeep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.756f06f69538ap+9,                  0x0p+0,  -0x1.69904cp-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.757185f0705b9p+9,                  0x0p+0,  -0x1.6294dap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.757404ea4b7e8p+9,                  0x0p+0,  -0x1.5bbbeep-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.757683e426a17p+9,                  0x0p+0,  -0x1.5504dap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.757902de01c46p+9,                  0x0p+0,  -0x1.4e6efap-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.757b81d7dce75p+9,                  0x0p+0,  -0x1.47f9a8p-4, INEXACT|UNDERFLOW)
T(RN,   -0x1.757e00d1b80a4p+9,                  0x0p+0,  -0x1.41a444p-4, INEXACT|UNDERFLOW)
