﻿/*---------------------------------------------------------------------------*
  Copyright (C)2015 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "replacement--test.h"
#include "ntd-test-libc.h" // TESTCASE() macro

#include <stdio.h> // printf(), vprintf()
#include <stdarg.h> // va_list, va_start(), va_end()

static const char *musl_libc_test_short_path(const char *file)
{
    const char *partial_path = strstr(file, "musl-libc-test/");
    if (partial_path) {
        return partial_path;
    } else {
        partial_path = strstr(file, "musl-libc-tests/");
        if (partial_path) {
            return partial_path;
        } else {
            return file;
        }
    }
}

int t_error_replacement_func(const char* file, int line, ...)
{
  va_list args;
  const char* format_string;

  // Trigger the Horizon testsuite's failure state to make sure this failure
  // increments the counter for number of failures
  TESTCASE_FAILURE();

  // Print the actual error so users know where the failure actually occurred
  va_start(args, line);
  format_string = va_arg(args, const char*);
  printf("%s:%d - ", musl_libc_test_short_path(file), line);
  vprintf(format_string, args);
  va_end(args);
  return 0;
}
