﻿#include <fenv.h>
#include <float.h>
#include <math.h>
#include "ntd-test-libc.h"

#undef RN
#undef RZ
#undef RD
#undef RU
#ifdef FE_TONEAREST
#define RN FE_TONEAREST
#else
#define RN 0
#endif
#ifdef FE_TOWARDZERO
#define RZ FE_TOWARDZERO
#else
#define RZ -1
#endif
#ifdef FE_DOWNWARD
#define RD FE_DOWNWARD
#else
#define RD -1
#endif
#ifdef FE_UPWARD
#define RU FE_UPWARD
#else
#define RU -1
#endif

#undef INEXACT
#undef INVALID
#undef DIVBYZERO
#undef UNDERFLOW
#undef OVERFLOW
#ifdef FE_INEXACT
#define INEXACT FE_INEXACT
#else
#define INEXACT 0
#endif
#ifdef FE_INVALID
#define INVALID FE_INVALID
#else
#define INVALID 0
#endif
#ifdef FE_DIVBYZERO
#define DIVBYZERO FE_DIVBYZERO
#else
#define DIVBYZERO 0
#endif
#ifdef FE_UNDERFLOW
#define UNDERFLOW FE_UNDERFLOW
#else
#define UNDERFLOW 0
#endif
#ifdef FE_OVERFLOW
#define OVERFLOW FE_OVERFLOW
#else
#define OVERFLOW 0
#endif

#undef inf
#undef nan
#define inf INFINITY
#define nan NAN

#define T(...) {0, "", __FILE__, __LINE__, __VA_ARGS__},
#define EXPECT_FAIL(msg, ...) {1, msg, __FILE__, __LINE__, __VA_ARGS__},

#if __arm__ || __aarch64__
#define ARM_EXPECT_FAIL(msg,...) EXPECT_FAIL(msg, __VA_ARGS__)
#else
#define ARM_EXPECT_FAIL(msg,...) T(__VA_ARGS__)
#endif

#if __X86_64__
#define X86_64_EXPECT_FAIL(msg,...) EXPECT_FAIL(msg, __VA_ARGS__)
#else
#define X86_64_EXPECT_FAIL(msg,...) T(__VA_ARGS__)
#endif

#if __horizon
#define HORIZON_EXP_FAIL(msg,...) EXPECT_FAIL(msg,__VA_ARGS__)
#else
#define HORIZON_EXP_FAIL(msg,...) T(__VA_ARGS__)
#endif

#define POS int expect_failure; const char *fail_msg; char *file; int line;
struct d_d {POS int r; double x; double y; float dy; int e; };
struct f_f {POS int r; float x; float y; float dy; int e; };
struct l_l {POS int r; long double x; long double y; float dy; int e; };
struct ff_f {POS int r; float x; float x2; float y; float dy; int e; };
struct dd_d {POS int r; double x; double x2; double y; float dy; int e; };
struct ll_l {POS int r; long double x; long double x2; long double y; float dy; int e; };
struct d_di {POS int r; double x; double y; float dy; long long i; int e; };
struct f_fi {POS int r; float x; float y; float dy; long long i; int e; };
struct l_li {POS int r; long double x; long double y; float dy; long long i; int e; };
struct di_d {POS int r; double x; long long i; double y; float dy; int e; };
struct fi_f {POS int r; float x; long long i; float y; float dy; int e; };
struct li_l {POS int r; long double x; long long i; long double y; float dy; int e; };
struct d_i {POS int r; double x; long long i; int e; };
struct f_i {POS int r; float x; long long i; int e; };
struct l_i {POS int r; long double x; long long i; int e; };
struct d_dd {POS int r; double x; double y; float dy; double y2; float dy2; int e; };
struct f_ff {POS int r; float x; float y; float dy; float y2; float dy2; int e; };
struct l_ll {POS int r; long double x; long double y; float dy; long double y2; float dy2; int e; };
struct ff_fi {POS int r; float x; float x2; float y; float dy; long long i; int e; };
struct dd_di {POS int r; double x; double x2; double y; float dy; long long i; int e; };
struct ll_li {POS int r; long double x; long double x2; long double y; float dy; long long i; int e; };
struct fff_f {POS int r; float x; float x2; float x3; float y; float dy; int e; };
struct ddd_d {POS int r; double x; double x2; double x3; double y; float dy; int e; };
struct lll_l {POS int r; long double x; long double x2; long double x3; long double y; float dy; int e; };
#undef POS

char *estr(int);
char *estr2(int);
typedef enum E_CHECK_TYPE {
    check_all,
    check_inexact,
    check_RN_inexact_omisson,
    check_RN_inexact_igore
} E_CHECK_TYPE;

char *estrs(int got, int want, int r, E_CHECK_TYPE e_check);
char *rstr(int);

#if defined CHECK_INEXACT
#define ESTRS(got, p) estrs(got, p->e, p->r, check_inexact)
#elif defined CHECK_INEXACT_OMISSION
#define ESTRS(got, p) estrs(got, p->e, p->r, check_inexact_omisson)
#else
#define ESTRS(got, p) estrs(got, p->e, p->r, check_RN_inexact_igore)
#endif
#define ESTRS_ALL(got, p) estrs(got, p->e, p->r, check_all)
#define ESTRS_NO_INEXACT(got, p) estrs((got & ~INEXACT), (p->e & ~INEXACT), p->r, check_all)


float ulperr(double got, double want, float dwant);
float ulperrf(float got, float want, float dwant);
float ulperrl(long double got, long double want, float dwant);

static int t_checkexcept(int got, int want, int r)
{
    if (r == RN)
#if defined CHECK_INEXACT
        return got == want;
#elif defined CHECK_INEXACT_OMISSION
        return got == want || got == (want|INEXACT);
#else
        return (got|INEXACT) == (want|INEXACT);
#endif
    return (got|INEXACT|UNDERFLOW) == (want|INEXACT|UNDERFLOW);
}

#define checkexcept(got, want, r) TESTCASE_MESSAGE(t_checkexcept(got, want, r), \
    "got exception %d, wanted %d round = %d", got, want, r)

#define t_checkexceptall(got, want, r) ((got) == (want))
#define checkexceptall(got, want, r) TESTCASE_MESSAGE((got) == (want), "got exception %d, wanted %d", got, want)

static int t_checkulp(float d, int r)
{
    // TODO: we only care about >=1.5 ulp errors for now, should be 1.0
    if (r == RN)
        return fabsf(d) < 1.5;
    return 1;
}
#define checkulp(d, r) TESTCASE_RESULT(t_checkulp(d, r))

static int t_checkcr(long double y, long double ywant, int r)
{
    if (isnan(ywant))
        return isnan(y);
    return y == ywant && signbit(y) == signbit(ywant);
}
#define checkcr(d, ywant, r) TESTCASE_RESULT(t_checkcr(d, ywant, r))

int test_ll_l_checkexceptall(long double (*f)(long double, long double), const char *f_name, struct ll_l *t, size_t n);

