﻿#include <stdint.h>
#include <stdio.h>
#include "mtest.h"

static struct d_i t[] = {
#include "sanity/ilogb.h"
#include "special/ilogb.h"

};

int main(void)
{
    #pragma STDC FENV_ACCESS ON
    long long yi;
    int e, i, err = 0;
    struct d_i *p;

    for (i = 0; i < sizeof t/sizeof *t; i++) {
        p = t + i;

        if (p->r < 0)
            continue;
        fesetround(p->r);
        feclearexcept(FE_ALL_EXCEPT);
        yi = ilogb(p->x);
        e = fetestexcept(INEXACT|INVALID|DIVBYZERO|UNDERFLOW|OVERFLOW);

        if (!checkexcept(e, p->e, p->r)) {
            printf("%s:%d: bad fp exception: %s ilogb(%a)=%lld, want %s",
                p->file, p->line, rstr(p->r), p->x, p->i, estr(p->e));
            printf(" got %s\n", estr(e));
            err++;
        }
        if (yi != p->i) {
            printf("%s:%d: %s ilogb(%a) want %lld got %lld\n",
                p->file, p->line, rstr(p->r), p->x, p->i, yi);
            err++;
        }
    }
    return !!err;
}
