﻿#include <features.h>

#if defined(__STDC_LIB_EXT1__) || defined(__NN_STDC_LIB_EXT1_MEMSET_S__)
#define __STDC_WANT_LIB_EXT1__
#include <string.h>
#endif

#include <stdio.h>
#include <stdlib.h>
#include <errno.h>
#include "test.h"

#pragma clang optimize on
void memset_free()
{
    size_t len = 10;
    char key[16];

    char *buf = malloc(len);
    memset(buf, 0, len);
    free(buf);

    memset(key, 0, sizeof(key));

}

void memset_s_free()
{
#ifdef __STDC_WANT_LIB_EXT1__
    size_t len = 10;
    char key[16];
    errno_t err;

    char *buf = malloc(len);
    err = memset_s(buf, len, 0, len);
    free(buf);

    err = memset_s(key, sizeof(key), 0, sizeof(key));
#endif
}

int main(void)
{
    char str[] = "ghghghghghghghghghghgh";
    char *nullstr = 0;
    memset(str,'a',5);
    if (strcmp(str,"aaaaahghghghghghghghgh") != 0)
        t_error("memset(str,'a',5) want aaaaahghghghghghghghgh got %s\n", str);
    else
        TESTCASE(1);

    memset_free();

#ifdef __STDC_WANT_LIB_EXT1__
    /* Positive memset_s test */
    int r = memset_s(str, sizeof str, 'b', 5);
    if (strcmp(str,"bbbbbhghghghghghghghgh") != 0)
        t_error("memset_s(str, sizeof str, 'b',5) want bbbbbhghghghghghghghgh got %s\n", str);
    else
        TESTCASE(1);
    if (r != 0)
        t_error("memset_s(str, sizeof str, 'b',5) want returning 0 got %d (%s)\n", r, strerror(errno));

    /* memset_s a null string, check errno = EINVAL */
    r = memset_s(nullstr, 5, 'c', 10);
    if (nullstr != 0)
        t_error("memset_s(nullstr, 5, 'c', 10) want 0 got %s\n", str);
    else
        TESTCASE(1);
    if (r != EINVAL)
        t_error("memset_s((nullstr, 5, 'c', 10) want returning EINVAL got %d (%s)\n", r, strerror(errno));
    else
        TESTCASE(1);

    /* smax > RSIZE_MAX, check errno == E2BIG */
    r = memset_s(str, SIZE_MAX, 'c', 10);
    if (strcmp(str,"bbbbbhghghghghghghghgh") != 0)
        t_error("memset_s(str, SIZE_MAX, 'c', 10) want bbbbbhghghghghghghghgh got %s\n", str);
    else
        TESTCASE(1);
    if (r != E2BIG)
        t_error("memset_s(str, SIZE_MAX, 'c', 10) want returning EOVERFLOW got %d (%s)\n", r, strerror(errno));
    else
        TESTCASE(1);

    /* n > RSIZE_MAX, check errno == E2BIG */
    r = memset_s(str, 5, 'a', SIZE_MAX);
    if (strcmp(str,"aaaaahghghghghghghghgh") != 0)
        t_error("memset_s(str, 5, 'c', 10) want aaaaahghghghghghghghgh got %s\n", str);
    else
        TESTCASE(1);
    if (r != E2BIG)
        t_error("memset_s(str, 5, 'c', 10) want returning E2BIG got %d (%s)\n", r, strerror(errno));
    else
        TESTCASE(1);

    /* n > smax, check errno == EOVERFLOW */
    r = memset_s(str, 5, 'c', 10);
    if (strcmp(str,"ccccchghghghghghghghgh") != 0)
        t_error("memset_s(str, 5, 'c', 10) want ccccchghghghghghghghgh got %s\n", str);
    else
        TESTCASE(1);
    if (r != EOVERFLOW)
        t_error("memset_s(str, 5, 'c', 10) want returning EOVERFLOW got %d (%s)\n", r, strerror(errno));
    else
        TESTCASE(1);

    memset_s_free();
#endif

    return 0;
}
