﻿/*---------------------------------------------------------------------------*
  Copyright (C) 2016 Nintendo Co., Ltd.  All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo of America Inc. and/or Nintendo
  Company Ltd., and are protected by Federal copyright law.  They may
  not be disclosed to third parties or copied or duplicated in any form,
  in whole or in part, without the prior written consent of Nintendo.
 *---------------------------------------------------------------------------*/

#include "jira-regression-tests.h"
#include "ntd-test-libc.h"
#include <stdio.h>

void rynda_249()
{
    NTD_TEST_GROUP_START("RYNDA-249", 1);
    TESTCASE(strverscmp("", "") == 0);
    TESTCASE(strverscmp("a", "a") == 0);
    TESTCASE(strverscmp("a", "b") < 0);
    TESTCASE(strverscmp("b", "a") > 0);
    TESTCASE_KNOWN_FAILURE("RYNDA-249", strverscmp("000", "00") < 0);
    TESTCASE_KNOWN_FAILURE("RYNDA-249", strverscmp("00", "000") > 0);
    TESTCASE(strverscmp("a0", "a") > 0);
    TESTCASE(strverscmp("00", "01") < 0);
    TESTCASE(strverscmp("01", "010") < 0);
    TESTCASE(strverscmp("010", "09") < 0);
    TESTCASE_KNOWN_FAILURE("RYNDA-249", strverscmp("09", "0") < 0);
    TESTCASE(strverscmp("9", "10") < 0);
    TESTCASE(strverscmp("0a", "0") > 0);
    TESTCASE(strverscmp("foobar-1.1.2", "foobar-1.1.3") < 0);
    TESTCASE(strverscmp("foobar-1.1.2", "foobar-1.01.3") > 0);
    NTD_TEST_GROUP_END("RYNDA-249", 1);
}
