﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#include <nnt/gtest/detail/gtest-ctime.h>

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

namespace {

CTime::Tm g_Tm;

} // namespace

CTime::Tm* CTime::Localtime(const CTime::Time_t* timer) NN_NOEXCEPT
{
    NN_UNUSED(timer);
    g_Tm.tm_sec = 0;
    g_Tm.tm_min = 0;
    g_Tm.tm_hour = 0;
    g_Tm.tm_mday = 1;
    g_Tm.tm_mon = 0;
    g_Tm.tm_year = 70;
    g_Tm.tm_wday = 4;
    g_Tm.tm_yday = 0;
    g_Tm.tm_isdst = 0;
    return &g_Tm;
}

}}} // namespace nnt::testing::detail
