﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class Math final
{
public:
    static double Fabs(double value) NN_NOEXCEPT;

private:
    Math() NN_NOEXCEPT;

    NN_DISALLOW_COPY(Math);
    NN_DISALLOW_MOVE(Math);
};

inline double Math::Fabs(double value) NN_NOEXCEPT
{
    return value > 0 ? value : -value;
}

}}} // namespace nnt::testing::detail
