﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class Host final
{
public:
    static bool IsDirectory(const char* path) NN_NOEXCEPT;

    static bool IsFile(const char* path) NN_NOEXCEPT;

    static bool Exists(const char* path) NN_NOEXCEPT;

    static bool CreateDirectory(const char* path) NN_NOEXCEPT;

    static void* OpenFile(const char* path, const char* mode) NN_NOEXCEPT;

    static bool WriteFile(
        void* handle, int offset, const void* buffer, int size) NN_NOEXCEPT;

    static bool FlushFile(void* handle) NN_NOEXCEPT;

    static bool GetFileSize(void* handle, int* pOutValue) NN_NOEXCEPT;

    static bool SetFileSize(void* handle, int value) NN_NOEXCEPT;

    static void CloseFile(void* handle) NN_NOEXCEPT;

private:
    Host();

    NN_DISALLOW_COPY(Host);
    NN_DISALLOW_MOVE(Host);
};

}}} // namespace nnt::testing::detail
