﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class Heap final
{
public:
    static void *Allocate(size_t size) NN_NOEXCEPT;

    static void Free(void* p) NN_NOEXCEPT;

private:
    Heap();

    NN_DISALLOW_COPY(Heap);
    NN_DISALLOW_MOVE(Heap);
};

#define NNT_TESTING_DETAIL_HEAP_IS_ALLOCATABLE() \
    void *operator new(size_t size) NN_NOEXCEPT \
    { \
        return ::nnt::testing::detail::Heap::Allocate(size); \
    } \
    void operator delete(void* p) NN_NOEXCEPT \
    { \
        ::nnt::testing::detail::Heap::Free(p); \
    } \
    void *operator new[](size_t size) NN_NOEXCEPT \
    { \
        return ::nnt::testing::detail::Heap::Allocate(size); \
    } \
    void operator delete[](void* p) NN_NOEXCEPT \
    { \
        ::nnt::testing::detail::Heap::Free(p); \
    }

}}} // namespace nnt::testing::detail
