﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class CTime final
{
public:
    typedef int64_t Time_t;

    struct Tm
    {
        int	tm_sec;
        int	tm_min;
        int	tm_hour;
        int	tm_mday;
        int	tm_mon;
        int	tm_year;
        int	tm_wday;
        int	tm_yday;
        int	tm_isdst;
    };

    static Tm* Localtime(const Time_t* timer) NN_NOEXCEPT;

private:
    CTime();

    NN_DISALLOW_COPY(CTime);
    NN_DISALLOW_MOVE(CTime);
};

}}} // namespace nnt::testing::detail
