﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>

namespace nnt { namespace testing { namespace detail {

class CString final
{
public:
    static char* Strncpy(char* ptr, const char* str, size_t num) NN_NOEXCEPT;

    static int Strcmp(const char* lhs, const char* rhs) NN_NOEXCEPT;

    static int Strncmp(
        const char* lhs, const char* rhs, size_t num) NN_NOEXCEPT;

    static int Strcasecmp(const char* lhs, const char* rhs) NN_NOEXCEPT;

    static const char* Strchr(const char * str, int character) NN_NOEXCEPT;

    static const char* Strrchr(const char* str, int character) NN_NOEXCEPT;

    static const char *Strstr(
        const char* haystack, const char* needle) NN_NOEXCEPT;

    static void* Memset(void* ptr, int value, size_t num) NN_NOEXCEPT;

    static size_t Strlen(const char* str) NN_NOEXCEPT;

private:
    CString();

    NN_DISALLOW_COPY(CString);
    NN_DISALLOW_MOVE(CString);
};

}}} // namespace nnt::testing::detail
