﻿/*--------------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain proprietary
  information of Nintendo and/or its licensed developers and are protected by
  national and international copyright laws. They may not be disclosed to third
  parties or copied or duplicated in any form, in whole or in part, without the
  prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *--------------------------------------------------------------------------------*/

#pragma once

#include <nn/nn_Common.h>
#include <nn/cstd/cstd_CStdArg.h>

namespace nnt { namespace testing { namespace detail {

struct File final
{
    int _type;
    void* _impl;
};

class CStdio final
{
public:
    static File* const Stderr;

    static File* const Stdout;

    static int Fclose(File* stream) NN_NOEXCEPT;

    static int Fflush(File* stream) NN_NOEXCEPT;

    static File* Fopen(const char * filename, const char * mode) NN_NOEXCEPT;

    static int Fprintf(File* stream, const char* format, ...) NN_NOEXCEPT;

    static int Fileno(File* stream) NN_NOEXCEPT;

    static int Isatty(int fd) NN_NOEXCEPT;

    static int Printf(const char* format, ...) NN_NOEXCEPT;

    static int Vprintf(const char* format, va_list arg) NN_NOEXCEPT;

private:
    CStdio();

    NN_DISALLOW_COPY(CStdio);
    NN_DISALLOW_MOVE(CStdio);
};

}}} // namespace nnt::testing::detail
