﻿/*----------------------------------------------------------------------------*
  Copyright (C)Nintendo All rights reserved.

  These coded instructions, statements, and computer programs contain
  proprietary information of Nintendo and/or its licensed developers and are
  protected by national and international copyright laws.  They may not be
  disclosed to third parties or copied or duplicated in any form, in whole or
  in part, without the prior written consent of Nintendo.

  The content herein is highly confidential and should be handled accordingly.
 *----------------------------------------------------------------------------*/

#pragma once

//==============================================================================
//  INCLUDES
//==============================================================================

#include "tm.h"

//==============================================================================

namespace nn {

namespace tm {

//------------------------------------------------------------------------------
// Utilities
//------------------------------------------------------------------------------

//------------------------------------------------------------------------------
/**
 * @brief       Attaches the library to the local Target Manager. Used for
 *              debugging and automation purposes only. The public interface
 *              should handle connection logic for the user.
 *
 * @result      nn::tm::Error_Ok if successful, else an error code.
 */
Error           Attach( );

//------------------------------------------------------------------------------
/**
 * @brief       Detaches the library from the local Target Manager. Used for
 *              debugging and automation purposes only. The public interface
 *              should handle connection logic for the user.
 *
 * @result      nn::tm::Error_Ok if successful, else an error code.
 */
Error           Detach( );

//------------------------------------------------------------------------------
/**
* @brief        Generic method that can take in some data to send to
*               TargetManager that will parse and send to Azure App Insights
*
* @param[in]    pBuffer The generic pointer to a specific struct holding the data
* @param[in]    Size The size of the metric data
* @param[in]    EventType A number that can be used later to determine the struct
*               to use
*
* @result       nn::tm::Error_Ok if successful, else an error code.
*/
Error           SetMetricEvent( void* pBuffer, uint32_t Size, uint32_t EventType );

//------------------------------------------------------------------------------
/**
* @brief        Checks with TargetManager to see if allowed to send metrics
*
* @param[out]   pOutIsAllowedToSendMetrics The bool value of whether DE is
*               allowed to send the SetMetricEvent call
*
* @result       nn::tm::Error_Ok if successful, else an error code.
*/
Error           IsAllowedToSendMetrics( bool* pOutIsAllowedToSendMetrics );

//------------------------------------------------------------------------------
/**
* @brief        Simulates inserting the battery into the target. Only supported
*               by SDEV targets.
*
* @param[in]    targetHandle The handle of the target to simulate an inserted
*               battery.
*
* @result       nn::tm::Error_Ok if successful, else an error code.
*/
Error           InsertBattery( TargetHandle targetHandle );

//------------------------------------------------------------------------------
/**
* @brief        Simulates removing the battery from the target. Only supported by
*               SDEV targets.
*
* @param[in]    targetHandle The handle of the target to simulate the removal of
*               the battery.
*
* @result       nn::tm::Error_Ok if successful, else an error code.
*/
Error           RemoveBattery( TargetHandle targetHandle );


//------------------------------------------------------------------------------
} // namespace tm

} // namespace nn
//==============================================================================
