﻿/*----------------------------------------------------------------------*
  Project: StepTest
 *----------------------------------------------------------------------*/

#include "assert.h"
#include "stdio.h"
#include "stdlib.h"
#include <ctime>

//#ifdef __NX__
//#include <nn/diag.h>
//#endif

struct Struct
{
    void Func()
    {
        int x = 0;
    }

    void Func2();
};

void Struct::Func2()
{
    int x = 0;
}

class my_class
{
public:
    static int Static;

     my_class() {};
    ~my_class() {};

    // Tests proper updating of call frame for variables
    void Function()
    {
        int         Local  = -1;
        static int  Static = -1;

        for( int i = 0; i < 10; i++ )
        {
            Local++; // PLACE A BREAKPOINT HERE
            Static++;
        }
    }
};

struct color
{
    color() {};

    color( int aR, int aG, int aB, int aA = 255 )
    {
        R = (unsigned char)aR;
        G = (unsigned char)aG;
        B = (unsigned char)aB;
        A = (unsigned char)aA;
    }

    unsigned char R;
    unsigned char G;
    unsigned char B;
    unsigned char A;
};

template <typename T1, typename T2>
struct complex
{
    complex<T1,T2>() {};

    complex<T1,T2>( T1 aX, T2 aY )
    {
        X = aX;
        Y = aY;
    }

    T1 X;
    T2 Y;
};

color Color( 1, 2, 3, 4 );

struct complex<int,int> Complex( 1, 2 );

typedef int iNtEgEr;

iNtEgEr InTeGeR = 1;

int Array[2] = { 0, 1 };

int my_class::Static = -1;

Struct str;

double Global;

typedef bool (*TFunctionPtr)(int const);

time_t CurTime;

TFunctionPtr build_fn_ptr()
{
    return [] (int const x)
    {
        return x == 10;
    };
}

void TestLambda()
{
    TFunctionPtr arr[2];
    arr[0] = build_fn_ptr();
    arr[1] = build_fn_ptr();

    int x = 10;
    for ( TFunctionPtr ptr : arr )
    {
        ptr(x++);
    }
}

int g = 0;
int h = 0;

template <typename Type>
struct StructA
{
    void Func1(Type a) {}
    void Func2(Type a);
};

template <typename Type>
void StructA<Type>::Func2(Type a)
{
    Func1(a);           // BP.6622.1
}                       // BP.6622.2

int StructTest()        // BP.6622.0
{
    StructA<unsigned char> structA1;
    StructA<int> structA2;

    structA1.Func2(66);
    structA2.Func2(9);  // BP.6622.3

    return 0;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineIncr()
{
    g += 1;							//InlineFramesTestAddrKey11
    return g;
}

// 1-level V-topology
//
//  |-----------|
//      |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV1( int x )
{
    g += x;							//InlineFramesTestAddrKey03
    InlineIncr();
    g += x;							//InlineFramesTestAddrKey12
    return g;
}

// 2-level V-topology
//
//  |-------------------|
//      |-----------|
//          |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV2( int x )
{
    g += x;							//InlineFramesTestAddrKey02
    InlineV1(x);					//InlineFramesTestAddrKey06
    g += x;							//InlineFramesTestAddrKey10
    return g;
}

// 3-level V-topology
//
//  |---------------------------|
//      |-------------------|
//          |-----------|
//              |---|

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineV3( int x ) //inline Call Stack Test
{   g += x; //PLACE A BREAKPOINT HERE   //InlineFramesTestAddrKey01
    InlineV2(x);
    g += x;								//InlineFramesTestAddrKey07
    return g;
}

void InnerFunction() // Tests calls from inline code
{
    InlineIncr();
    InlineV3( 1 );
    g += 1; // PLACE A BREAKPOINT HERE  //InlineFramesTestAddrKey08
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineFunc()
{
    g += 1; // PLACE A BREAKPOINT HERE                      // Inline.X7.BP  //InlineFramesTestAddrKey09

    // Uncomment to test user-coded breakpoints in inline routines
#ifndef __NX__
    //__debugbreak();         // Tests user-coded breakpoint
#else
    //__builtin_trap();       // Tests user-coded breakpoint
    //__builtin_debugtrap();  // Tests user_coded breakpoint
#endif
    InnerFunction();										//InlineFramesTestAddrKey04
    return g;
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int InlineFunc1( int x )
{
    g += x; // PLACE A BREAKPOINT HERE                      // Inline.X2.BP
    return g;
}

#ifdef __NX__
__attribute__((noinline))
#endif
int MultiArg( int x, int y, int z )
{
    return( x + y + z );
}

int InlineTest()                                            // Inline.Start
{
    InlineFunc();                                           // Inline.Slide.0
    int x = InlineFunc();
    h += 1;                                                 // Inline.Slide.1
    InlineFunc();
    InnerFunction();                                        // Inline.X7.R3
    h += 1;
    InlineFunc1( x );                                       // InlineX2.1
    int y = InlineFunc1( x );
    h += 1;
    x = InlineFunc();
    h += 1;
    x = g + InlineFunc() + x;
    h += 1;
    g += x;
    h += MultiArg( x, g, h );
    h += MultiArg( InlineV1( x ), InlineV2( g ), InlineV3( h ) );
    g += x;
    g += InlineV3( 2 );
    h += x;
    return( x );
}

int InlineTest2()
{
    InlineFunc();
    h += 1;
    InlineFunc();
    g += 1;
    return( g );
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
int UnusedFunc( int x )
{
    return( x + x );
}

__attribute__((noinline)) void ForLoopTest() // Tests multiple breakpoints on FOR statement and SigloNTD-6622
{                                                           // Manual.StepIn.1
    int x = 0;
    for( int i = 0; i < 5; i++ ) // 6622.For()
    {
        x++;
        g++;
        Global++;
    }
}

#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
void InlineForTemplate()
{
    g++; // PLACE A BREAKPOINT HERE                                 // TemplateExp.DefInl
}

template <typename Type, typename Type2>
long long AddTaTb(Type a, Type2 b)                                  // TemplateExp.AddPro
{
    InlineForTemplate();                                            // TemplateExp.AddInl
    return (long long)a + (long long)b; // PLACE A BREAKPOINT HERE  // TemplateExp.AddBody
}

template <typename Type, typename Type2>
#ifndef __NX__
__forceinline
#else
inline __attribute__((always_inline))
#endif
long long SubTaTb(Type a, Type2 b)                                  // TemplateExp.SubPro
{
    InlineForTemplate();                                            // TemplateExp.SubInl
    return (long long)a - (long long)b; // PLACE A BREAKPOINT HERE  // TemplateExp.SubBody
}

// Tests templated functions
long long TemplateExpansionTest()
{
    long long   Sum = 0;                                            // TemplateExp.Top

    // Non-inline template functions

    Sum += AddTaTb( (char)1,    (char)2 );
    Sum += AddTaTb( (char)1,    (double)2 );
    Sum += AddTaTb( (char)1,    (float)2 );
    Sum += AddTaTb( (char)1,    (int)2 );
    Sum += AddTaTb( (char)1,    (long)2 );
    Sum += AddTaTb( (char)1,    (short)2 );

    Sum += AddTaTb( (double)1,  (char)2 );
    Sum += AddTaTb( (double)1,  (double)2 );
    Sum += AddTaTb( (double)1,  (float)2 );
    Sum += AddTaTb( (double)1,  (int)2 );
    Sum += AddTaTb( (double)1,  (long)2 );
    Sum += AddTaTb( (double)1,  (short)2 );

    Sum += AddTaTb( (float)1,   (char)2 );
    Sum += AddTaTb( (float)1,   (double)2 );
    Sum += AddTaTb( (float)1,   (float)2 );
    Sum += AddTaTb( (float)1,   (char)2 );
    Sum += AddTaTb( (float)1,   (int)2 );
    Sum += AddTaTb( (float)1,   (long)2 );
    Sum += AddTaTb( (float)1,   (short)2 );

    Sum += AddTaTb( (int)1,     (char)2 );
    Sum += AddTaTb( (int)1,     (double)2 );
    Sum += AddTaTb( (int)1,     (float)2 );
    Sum += AddTaTb( (int)1,     (int)2 );
    Sum += AddTaTb( (int)1,     (long)2 );
    Sum += AddTaTb( (int)1,     (short)2 );

    Sum += AddTaTb( (long)1,    (char)2 );
    Sum += AddTaTb( (long)1,    (double)2 );
    Sum += AddTaTb( (long)1,    (float)2 );
    Sum += AddTaTb( (long)1,    (int)2 );
    Sum += AddTaTb( (long)1,    (long)2 );
    Sum += AddTaTb( (long)1,    (short)2 );

    Sum += AddTaTb( (short)1,   (char)2 );
    Sum += AddTaTb( (short)1,   (double)2 );
    Sum += AddTaTb( (short)1,   (float)2 );
    Sum += AddTaTb( (short)1,   (int)2 );
    Sum += AddTaTb( (short)1,   (long)2 );
    Sum += AddTaTb( (short)1,   (short)2 );

    // Inline template functions

    Sum += SubTaTb( (char)1,    (char)2 );
    Sum += SubTaTb( (char)1,    (double)2 );
    Sum += SubTaTb( (char)1,    (float)2 );
    Sum += SubTaTb( (char)1,    (int)2 );
    Sum += SubTaTb( (char)1,    (long)2 );
    Sum += SubTaTb( (char)1,    (short)2 );

    Sum += SubTaTb( (double)1,  (char)2 );
    Sum += SubTaTb( (double)1,  (double)2 );
    Sum += SubTaTb( (double)1,  (float)2 );
    Sum += SubTaTb( (double)1,  (int)2 );
    Sum += SubTaTb( (double)1,  (long)2 );
    Sum += SubTaTb( (double)1,  (short)2 );

    Sum += SubTaTb( (float)1,   (char)2 );
    Sum += SubTaTb( (float)1,   (double)2 );
    Sum += SubTaTb( (float)1,   (float)2 );
    Sum += SubTaTb( (float)1,   (char)2 );
    Sum += SubTaTb( (float)1,   (int)2 );
    Sum += SubTaTb( (float)1,   (long)2 );
    Sum += SubTaTb( (float)1,   (short)2 );

    Sum += SubTaTb( (int)1,     (char)2 );
    Sum += SubTaTb( (int)1,     (double)2 );
    Sum += SubTaTb( (int)1,     (float)2 );
    Sum += SubTaTb( (int)1,     (int)2 );
    Sum += SubTaTb( (int)1,     (long)2 );
    Sum += SubTaTb( (int)1,     (short)2 );

    Sum += SubTaTb( (long)1,    (char)2 );
    Sum += SubTaTb( (long)1,    (double)2 );
    Sum += SubTaTb( (long)1,    (float)2 );
    Sum += SubTaTb( (long)1,    (int)2 );
    Sum += SubTaTb( (long)1,    (long)2 );
    Sum += SubTaTb( (long)1,    (short)2 );

    Sum += SubTaTb( (short)1,   (char)2 );
    Sum += SubTaTb( (short)1,   (double)2 );
    Sum += SubTaTb( (short)1,   (float)2 );
    Sum += SubTaTb( (short)1,   (int)2 );
    Sum += SubTaTb( (short)1,   (long)2 );
    Sum += SubTaTb( (short)1,   (short)2 );

    return( Sum );
};

// Breakpoint here will be rejected (more than 10 lines)    #Context.Reject
// Breakpoint here will slide down to {                     #Context.Slide
//
//
//
//
//
//
//

int IfTest( int x ) // Tests statement bounds               #Context.Result
{
    bool Flag = true;

    if( x & 256 )
        Flag = false;

    if( !Flag )
        return( ++x ); // This demonstrates incorrect bounds

    x = -1;
    return( (int)Flag );
}

template <typename Type>
bool TemplateFunc(Type i)               // Template.X2 for template with two instances
{
    unsigned long ULong = 0;
    *(Type*)&ULong = i;                 // Convert binary to long

    return( ULong == (unsigned long)i ); // Returns TRUE if Type is some kind of integer
}

template <typename Type>
bool TemplateFunc2(Type i)              // Template.Slide for uninstantiated template
{
    unsigned long ULong = 0;
    *(Type*)&ULong = i;                 // Convert binary to long

    return( ULong == (unsigned long)i ); // Returns TRUE if Type is some kind of integer
}

int TemplateTest()                      // Template.Start
{
    int     Result = 0;
    bool    RetVal;

    RetVal = TemplateFunc(0);
    Result += ( RetVal ? 1 : 0 );
    RetVal = TemplateFunc(1);
    Result += ( RetVal ? 1 : 0 );
    RetVal = TemplateFunc(2.0f);
    Result += ( RetVal ? 1 : 0 );
    RetVal = TemplateFunc(3);
    Result += ( RetVal ? 1 : 0 );
    RetVal = TemplateFunc(4.0f);
    Result += ( RetVal ? 1 : 0 );
    RetVal = TemplateFunc(5.0f);
    Result += ( RetVal ? 1 : 0 );
    return Result;
}

int Sub2()
{
    IfTest( (int)Global );

    int Result = TemplateTest();

#ifndef __NX__
    int LoopCounter = 10; // For 5-sec loop on ArmRef use 500000;
#else
    int LoopCounter = 10; // 800000000; // Uncomment For 5-sec loop on NX32
#endif

    while( LoopCounter > 0 ) // Tests BreakAll
    {
        LoopCounter--;
    }

    //while(true);  // Tests branch to self
    //for(;;);      // Tests branch to self

    return Result;
}

int Sub1()
{                                                           // Manual.StepIn.2
    int Result = 17;

    Result = Sub2();
    return Result;
}

inline
float frand( float Min, float Max )
{
    return Min + ((rand() * (Max-Min)) / RAND_MAX);
}

double DRecurseTest( double x, double y, double z ) // Tests unwind of floating point registers
{
    x--;
    y++;
    z += (double)frand( (float)x, (float)y ); // Used to confuse the optimizer

    if ( x > 0 )
    {
        z = DRecurseTest( x, y, z );
    }
    else
    {
        z = x + y + z;
    }
    return( z );
}

float FRecurseTest( float x, float y, float z ) // Tests unwind of floating point registers
{
    x--;
    y++;
    z += frand( x, y ); // Used to confuse the optimizer

    if ( x > 0 )
    {
        z = FRecurseTest( x, y, z );
    }
    else
    {
        z = x + y + z;
    }
    return( z );
}

void RecurseTest( int i ) // Tests StepOut
{
    i--;
    if ( i > 0 )
    {
        RecurseTest( i );   // Manual.CallStack
    }                       // BP.InOut.5
    else
    {
        //assert( 0 ); // Tests full stack unwind

        int LoopCounter = 10; // 800000000; // Uncomment to test BreakAll with deep callstack
        while( LoopCounter > 0 )
        {
            LoopCounter--;
        }

        i = 0;              // BP.InOut.4
    }
}

long Overloaded( char x )   // BP.InOut.1
{
    return( (long)x );
}

long Overloaded( iNtEgEr x )
{
    return( (long)x );      // BP.InOut.3
}

long Overloaded( long x )
{
    return( (long)x );
}

long Overloaded( float x )
{
    return( (long)x );
}

long Overloaded( double x )
{
    return( (long)x );
}

long Overloaded( int &x, int *p )
{
    return( (long)x + (long)*p );
}

long Overloaded( color& x )
{
    return( ((long)x.R << 24) | ((long)x.G << 16) | ((long)x.B << 8) | (long)x.A );
}

long Overloaded( color* p )
{
    return( ((long)p->R << 24) | ((long)p->G << 16) | ((long)p->B << 8) | (long)p->A );
}

long Overloaded( complex<int,int>& x )
{
    return( ((long)x.X << 16) | (long)x.Y );
}

long Overloaded( int x[2] )
{
    return( (long)x[0] + (long)x[1] );
}

long Overloaded( complex<int,int>* p, int Shift )
{
    return( ( ((long)p->X << 16) | (long)p->Y ) << Shift );
}

void SwitchTest() // Tests stepping thru branch tables
{
    char Buffer[16];

    switch( Buffer[0] & 0x07 )
    {
    case 0:
        Buffer[0] = Buffer[3] + Buffer[5];
        break;
    case 1:
        Buffer[0] = Buffer[1] + Buffer[2];
        break;
    case 2:
        Buffer[0] = Buffer[7] + Buffer[9];
        break;
    case 3:
        Buffer[0] = Buffer[5] + Buffer[4];
        break;
    case 4:
        Buffer[0] = Buffer[3] + Buffer[2];
        break;
    case 5:
        Buffer[0] = Buffer[7] + Buffer[6];
        break;
    case 6:
        Buffer[0] = Buffer[2] + Buffer[8];
        break;
    case 7:
        Buffer[0] = Buffer[9] + Buffer[9];
        break;
    }

    return;
}

void FatalTests()                                   // Conditionally disabled tests that may kill the testcase
{
    int TestSelect  = 0;                            // Used to trigger special manual tests
    int i           = 123;

    if( TestSelect == 1 )   *(int*)i = i;           // Tests Access Violation of Data

    //if( TestSelect == 2 )                           // Tests Access Violation by Instruction
    //{
    //    asm volatile(
    //        "mov    x5, 0x00000124\n"
    //        "br     x5\n"
    //    );
    //}

    //if( TestSelect == 3 )                           // Tests Invalid Instruction
    //{
    //    asm volatile(
    //        ".inst  0xE7FFDEFE\n"
    //    );
    //}

    // Tests breakpoint within line in 32-bit mode
#ifndef __NX__
    if( TestSelect == -2 ) __debugbreak();          // Tests user-coded breakpoint
#else
    if( TestSelect == -2 ) __builtin_trap();        // Tests user-coded breakpoint
    if( TestSelect == -3 ) __builtin_debugtrap();   // Tests user_coded breakpoint
    //( TestSelect == -4 ) NN_DIAG_BREAK();         // Tests user_coded breakpoint
#endif

    // Tests branch to self within line in 32-bit mode
    if( TestSelect == -9 ) for(;;);

#ifndef __NX__
    //__debugbreak();           // Tests user-coded breakpoint
#else
    //__builtin_trap();         // Tests user-coded breakpoint
    //__builtin_debugtrap();    // Tests user_coded breakpoint
#endif
}

void f( unsigned int v )
{
    printf( "%d\n", v );
}

time_t GetCurTime()
{
    time( &CurTime );

    return( CurTime );
}

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain( void )
#endif
{
    printf( "StepTest starting...\n" );

    // Tests disassembly of modified immediates
    f(1);
    f(1111);
    f(1111111);
    f(1111111111);

    int         Local   = -1;   // Must be the same as Static
    static int  Static  = -1;   // Must be the same as Local

    my_class MyClass;           // Tests StepOver vs StepInto

    Global = 0;

    // Tests updates in the Registers window
    double  A = 1.0;
    double  B = 2.0;
    double  C = 3.0;
    double  D = A * B * C;

    float   a = 1.0;
    float   b = 2.0;
    float   c = 3.0;
    float   d = a * b * c;

    a = b; b = c; c = d;    // Tests multiple statements on line
    A = B; B = C; C = D;    // Tests multiple statements on line

    int i = 123;

    long long Sum = i       // Tests breakpoints within lines and 6622.MultLine
                  + Local   //  PLACE A BREAKPOINT HERE
                  + Static; //  PLACE A BREAKPOINT HERE

    // Tests correct replacement of original instruction
    for( i = 0; i < 10; i++ ) //  PLACE A BREAKPOINT HERE
    {
        Global++;
    }

    // Test breakpoint placement with full loop optimization enabled (-O3)
    // Loop unrolling will generate multiple code ranges for if() inside for().
    time_t  tStart  = GetCurTime();
    time_t  tCur    = tStart;
    time_t  tPrev   = tStart;
    time_t  tDelta  = tCur - tPrev;

    for( i = 0; i < 2; i++ )
    {
        tCur    = GetCurTime();
        tDelta  = tCur - tPrev;

        if( tDelta >= 1 ) // PLACE A BREAKPOINT HERE
        {
            printf( "Elapsed time: %lld seconds\n", (unsigned long long)tDelta );
            tPrev = tCur;
        }
    }

    while(true)
    {
        ForLoopTest();                                  // TopOfMainLoop
        Global += Sub1();                               // Manual.StepOut
        Global += Sub1();                               // Manual.StepOver.1
        Global += Sub1();                               // Manual.StepOver.2

        tCur    = GetCurTime();
        tDelta  = tCur - tPrev;

        // Provide print at regular intervals to test functions after attach
        if( tDelta >= 10 )
        {
            printf( "Elapsed time: %lld seconds, Local = %d\n", (unsigned long long)(tCur - tStart), Local );
            tPrev = tCur;
        }

        StructTest();
        TemplateExpansionTest();

        str.Func();
        str.Func2();

        InlineTest();												//InlineFramesTestAddrKey05
        InlineTest2();

        A = DRecurseTest( d, d, d );
        a = FRecurseTest( d, d, d );

        RecurseTest( 5 );                                                                // Manual.nnMain
        TestLambda();                                                                    // BP.InOut.6

        // Set Zero without immediate to fool optimizer
        int Zero = Static - Local;  // Tests Read data breakpoint for Local,                BP.Data.Read

        SwitchTest();               // Set data breakpoints for Local when stopped here,    BP.Data.SetBPs

        Local += Zero;              // Tests Write data breakpoint with change for Local,   BP.Data.WriteZero

        Local++;                    // Tests Write and Change data breakpoint for Local,    BP.Data.WriteNonZero
        Static++;                   //                                                      BP.Data.WriteChanged
        my_class::Static++;

        MyClass.Function();

        // Tests overloaded functions and non-Back-To-Back breakpoints
        i += Overloaded( 'x' );     // BP.InOut.0
        i += Overloaded( 7 );       // BP.InOut.2
        i += Overloaded( 13L );
        i += Overloaded( a );
        i += Overloaded( A );
        i += Overloaded( InTeGeR, &InTeGeR );
        i += Overloaded( Color );
        i += Overloaded( &Color );
        i += Overloaded( Complex );
        i += Overloaded( InTeGeR );
        i += Overloaded( Array );
        i += Overloaded( &Complex, 3 );

        // Tests Back-To-Back breakpoints
        FatalTests();               // B2B.Start
        FatalTests();               // B2B.1
        FatalTests();               // B2B.2
        FatalTests();               // B2B.3
        FatalTests();               // B2B.4
        FatalTests();               // B2B.5
        FatalTests();               // B2B.6
        FatalTests();               // B2B.7
        FatalTests();               // B2B.8
        FatalTests();               // B2B.9
        FatalTests();               // B2B.Stop

        // Test data breakpoint when overrunning item
        int arr[8]; // = {0}; // Initialization counts as a write

        for( int i = 0; i < 8; i++ )
        {
            arr[i] = i;
        }
        const int index = 4;

        // Overflow high bits into previous index (test assumes little-endian).
        *((long*) (((int*) arr) + (index - 1))) = ((long)2 << 35);
    }

#ifndef __NX__
    return 0;
#endif
}
