﻿#include <nn/os.h>
#include <nn/fs.h>
#include <nn/nn_Assert.h>

extern "C" void nnMain()
{
    const uint32_t FILE_SIZE = 0x1FFFFFFF;

    char Buffer[1024];
    memset( Buffer, '\0', 1024 );
    strcat( Buffer, "C:\\Users\\" );
    strcat( Buffer, USER_NAME );

    nn::Result result;
    result = nn::fs::MountHost( "host", Buffer );

    nn::fs::FileHandle fileHandle;
    result = nn::fs::OpenFile( &fileHandle, "host:/FsSmplDir/file1", nn::fs::OpenMode_Read | nn::fs::OpenMode_Write | nn::fs::OpenMode_AllowAppend );
    NN_ASSERT( result.IsSuccess() );

    static char readBuffer[FILE_SIZE];
    result = nn::fs::ReadFile( fileHandle, 0, readBuffer, FILE_SIZE );
    NN_ASSERT( result.IsSuccess() );

    nn::fs::CloseFile( fileHandle );

    nn::fs::Unmount( "host" );

    return;
}
