﻿//==============================================================================
//  Copyright (C) Deja Tools, LLC.  All rights reserved.
//==============================================================================

#pragma once

#include <list>
#include <WinSock2.h>
#include <ws2tcpip.h>

//==============================================================================
// Directory entry

class htcs_directory_entry
{
public:

    htcs_directory_entry    ( char*         pPeerName,
                              char*         pPortName,
                              char*         pIPAddress,
                              char*         pPort );
    ~htcs_directory_entry   ();

    char*   GetPeerName     ();
    char*   GetPortName     ();
    char*   GetIPAddress    ();
    int     GetPort         ();
    char*   Describe        ( char*         pToString,
                              size_t        SizeOfStringBuffer );

    bool    Is              ( const char*   pTargetServer,
                              const char*   pTargetPort );

    bool    Is              ( const char*   pIPAddress,
                              int           Port );

    void    GetTcpAddress   ( char*         pIPAddress,
                              int*          pPort );

    void    GetHTCSAddress  ( char*         pServerName,
                              char*         pPortName );

private:
    char m_PeerName[1024];
    char m_PortName[1024];
    char m_IPAddress[1024];
    char m_Port[1024];
    int  m_PortNumber;
};

//========================================================================================
class htcs_directory_stream;

class htcs_directory
{
public:
                                        htcs_directory      ();
                                        ~htcs_directory     ();
    //
    std::list<htcs_directory_entry*>&   GetDirectoryListing ();

    // Resolution functionality
    bool                                ResolveTcpAddress   ( const char*   pServerName,
                                                              const char*   pPortName,
                                                              char*         pIPAddress,
                                                              int*          pPort );

    bool                                ResolveHTCSAddress  ( const char*   pIPAddress,
                                                              int           Port,
                                                              char*         pServerName,
                                                              char*         pPortName);
    // Reporting
    bool                                HasError            ();
    void                                ReportError         ();
    bool                                IsAvailable         ();

    // Server registration functionality
    bool                                RegisterEntry       ( const char*   pServerName,
                                                              const char*   pPortName,
                                                              const char*   pIPAddress,
                                                              const char*   pPort,
                                                              const char*   pRequestName = NULL );

    bool                                UnRegisterEntry     ( const char*   pServerName,
                                                              const char*   pPortName,
                                                              const char*   pRequestName = NULL );

private:
    htcs_directory_stream*              m_pStream;
    std::list<htcs_directory_entry*>    m_Entries;
    void                                FetchDirectoryListing   ();

    //Primitive XML-parsing code
    bool                                DirectoryXMLFindPortMap ( char*     pReadAt,
                                                                  char*     pEnd,
                                                                  char**    ppPortMapStart,
                                                                  char**    ppPortMapEnd );
    void                                DirectoryXMLParse       ( char*     pPartMapStart,
                                                                  char*     pPortMapEnd );
    bool                                DirectoryXMLGet         ( char*     pPortMapStart,
                                                                  char*     pPortMapEnd,
                                                                  char*     pTag,
                                                                  char*     pContentBuffer );
    char*                               DirectoryXMLFind        ( char*     pPortMapStart,
                                                                  char*     pPortMapEnd,
                                                                  char*     pTag );

    bool                                CheckCommandResult      ( const char*   pRequestName );
    bool                                FetchCommandResult      ( char*     pBuffer,
                                                                  size_t    SizeOfBuffer );

};

//========================================================================================

