﻿#include <string>
#include <vector>
#include <list>
#include <forward_list>
#include <map>
#include <set>
#include <deque>
#include <stdio.h>
#include <nn/fs.h>
#include "Containers.h"

// Copying nn::Result creation and defines.
#define NN_DEFINE_ERROR_RANGE_RESULT(name, module, descriptionBegin, descriptionEnd) \
    class name \
        : public ::nn::result::detail::ErrorResultBase<module, descriptionBegin> \
        , public ::nn::result::detail::ErrorRange<module, descriptionBegin, descriptionEnd> \
    {}

NN_DEFINE_ERROR_RANGE_RESULT( ResultTooLongPath, 2, 6003, 6004 );
NN_DEFINE_ERROR_RANGE_RESULT( ResultConnectionFailure, 18, 1, 2 );
NN_DEFINE_ERROR_RANGE_RESULT( ResultDuplicatedServiceName, 4, 3, 4 );
NN_DEFINE_ERROR_RANGE_RESULT( ResultAccessViolation, 3, 2, 3 );

template <class Type>
class RecursiveType
{
public:
    int     m_Int;
    Type    m_Type;
};

template <class A>
class SparseArray
{
public:
    SparseArray()
    {
        m_nItems = 0;
        m_StepSize = 0;
        m_pBuffer = nullptr;
    }
    SparseArray( int Size )
    {
        m_nItems = 0;
        m_StepSize = 0;
        m_pBuffer = nullptr;

        CreateArray( Size );
    }
    ~SparseArray()
    {
        delete[] m_pBuffer;
        m_pBuffer = nullptr;
    }
    void CreateArray( int Size )
    {
        delete[] m_pBuffer;

        m_StepSize = Size;
        m_nItems = Size;
        m_pBuffer = new A[Size*Size];

        memset( m_pBuffer, 0, Size*Size );

        for( int iElement = 0; iElement < Size; ++iElement )
        {
            m_pBuffer[iElement*m_StepSize] = A( iElement );
        }
    }
public:
    int  m_nItems;
    int  m_StepSize;
    A*   m_pBuffer;
};

template <class A>
using SparseArray2 = SparseArray<A>;

class IDHolder;

class Identification
{
public:
    int         m_id;
    IDHolder*   m_Holder;
};

class IDHolder
{
public:
    Identification* m_pID;
};

class SyntheticTestClass
{
public:
    SyntheticTestClass() {}
public:
    char* m_pChar = "data";
    IDHolder* m_pID;
};

namespace A
{
    template<class Type>
    class ClassA
    {
    public:
        Type m_Type = { 0 };
    };
}

namespace B
{
    template<class Type>
    class ClassB : public A::ClassA<Type>
    {
    public:
        Type m_Type = { 0 };
    };
}

template<class Type>
class ClassC : public A::ClassA<Type>
{
public:
    Type m_Type = { 0 };
};

namespace D
{
    template<class Type>
    class ClassD : public ClassC<Type>, public B::ClassB<Type>
    {
    public:
        Type m_Type = { 0 };
    };
}

template<class Type>
class ClassE : public B::ClassB<Type>, public ClassC<Type>
{
public:
    Type m_Type = { 0 };
};

class ExpandedItemTestClass
{
public:
    IDHolder* m_pIDH;
};

class Q
{
public:
    Q() { m_Value = 100; };
    int m_Value;
};

extern IntContainer<int> gIntContainer1;
extern IntContainer<int> gIntContainer2;

extern "C" void nnMain ( void )
{
    gIntContainer1.anInt = 0;
    gIntContainer2.anInt = 1;

    IntContainerWrapper<int, &gIntContainer1> intContainerWrapper1;
    intContainerWrapper1.anInt = 2;
    intContainerWrapper1.anIntContainer = gIntContainer1;

    IntContainerWrapper<int, &gIntContainer2> intContainerWrapper2;
    intContainerWrapper2.anInt = 3;
    intContainerWrapper2.anIntContainer = gIntContainer2;

    // Initial set of NatVis variables.
    std::map< double, const char* > MapOfDoubleToChars1;
    MapOfDoubleToChars1.insert( { 2.0, "2.0" } );
    MapOfDoubleToChars1.insert( { 4.0, "4.0" } );

    std::vector< double > VectorOfDoubles1;
    VectorOfDoubles1.push_back( 1.0 );
    VectorOfDoubles1.push_back( 2.0 );

    std::list< double > ListOfDoubles1;
    ListOfDoubles1.push_back( 1.0 );
    ListOfDoubles1.push_back( 2.0 );

    std::forward_list< double > ForwardListOfDoubles1;
    ForwardListOfDoubles1.push_front( 3.0 );
    ForwardListOfDoubles1.push_front( 2.0 );

    std::set< double > SetOfDoubles1;
    SetOfDoubles1.insert( 1.0 );
    SetOfDoubles1.insert( 2.0 );

    // Additional set of NatVis variables.
    std::map< double, const char* > MapOfDoubleToChars2;
    MapOfDoubleToChars2.insert( { 8.0, "8.0" } );
    MapOfDoubleToChars2.insert( { 16.0, "16.0" } );

    std::vector< double > VectorOfDoubles2;
    VectorOfDoubles2.push_back( 10.0 );
    VectorOfDoubles2.push_back( 20.0 );

    std::list< double > ListOfDoubles2;
    ListOfDoubles2.push_back( 10.0 );
    ListOfDoubles2.push_back( 200.0 );

    std::forward_list< double > ForwardListOfDoubles2;
    ForwardListOfDoubles2.push_front( 30.0 );
    ForwardListOfDoubles2.push_front( 20.0 );

    std::set< double > SetOfDoubles2;
    SetOfDoubles2.insert( 10.0 );
    SetOfDoubles2.insert( 20.0 );

    // Nested NatVis variables.
    std::map< double, std::map< double, const char* > > MapOfDoubleToMapOfDoubleToChars;
    MapOfDoubleToMapOfDoubleToChars.insert( { 1.0, MapOfDoubleToChars1 } );
    MapOfDoubleToMapOfDoubleToChars.insert( { 2.0, MapOfDoubleToChars2 } );

    std::vector< std::vector< double > > VectorOfVectorDoubles;
    VectorOfVectorDoubles.push_back( VectorOfDoubles1 );
    VectorOfVectorDoubles.push_back( VectorOfDoubles2 );

    std::list< std::list< double > > ListOfListOfDoubles;
    ListOfListOfDoubles.push_back( ListOfDoubles1 );
    ListOfListOfDoubles.push_back( ListOfDoubles2 );

    std::forward_list< std::forward_list< double > > ForwardListOfForwardListOfDoubles;
    ForwardListOfForwardListOfDoubles.push_front( ForwardListOfDoubles2 );
    ForwardListOfForwardListOfDoubles.push_front( ForwardListOfDoubles1 );

    std::set< std::set< double > > SetOfSetOfDoubles;
    SetOfSetOfDoubles.insert( SetOfDoubles1 );
    SetOfSetOfDoubles.insert( SetOfDoubles2 );

    std::string NarrowString = "Narrow Hello";
    printf( NarrowString.c_str() );

    std::wstring WideString = L"Wide Hello";
    wprintf( WideString.c_str() );

    // Const references and pointers to custom types.
    const std::map< double, const char* >& ConstRefToMap        = MapOfDoubleToChars1;
    const std::map< double, const char* >* ConstPointerToMap    = &MapOfDoubleToChars1;

    // Nested pointer to NatVis types.
    std::map< double, std::map< double, const char* >* > MapOfDoubleTopMapOfDoubleToChars;
    MapOfDoubleTopMapOfDoubleToChars.insert( { 1.0, &MapOfDoubleToChars1 } );
    MapOfDoubleTopMapOfDoubleToChars.insert( { 2.0, &MapOfDoubleToChars2 } );

    std::vector< std::vector< double >* > VectorOfpVectorDoubles;
    VectorOfpVectorDoubles.push_back( &VectorOfDoubles1 );
    VectorOfpVectorDoubles.push_back( &VectorOfDoubles2 );

    std::list< std::list< double >* > ListOfpListOfDoubles;
    ListOfpListOfDoubles.push_back( &ListOfDoubles1 );
    ListOfpListOfDoubles.push_back( &ListOfDoubles2 );

    std::forward_list< std::forward_list< double >* > ForwardListOfpForwardListOfDoubles;
    ForwardListOfpForwardListOfDoubles.push_front( &ForwardListOfDoubles2 );
    ForwardListOfpForwardListOfDoubles.push_front( &ForwardListOfDoubles1 );

    std::set< std::set< double >* > SetOfpSetOfDoubles;
    SetOfpSetOfDoubles.insert( &SetOfDoubles1 );
    SetOfpSetOfDoubles.insert( &SetOfDoubles2 );

    // Various custom NatVis types as defined by the project's NatvisTest.natvis file.
    SparseArray2<int> SAInts;
    SAInts.CreateArray( 15 );

    SparseArray<double> SADouble;
    SADouble.CreateArray( 3 );

    Identification ID;
    IDHolder       IDH;
    ID.m_id        = 1234;
    ID.m_Holder    = &IDH;
    IDH.m_pID      = &ID;

    int TheInt = 1;
    RecursiveType<int> RT1;
    RT1.m_Int  = 2;
    RT1.m_Type = TheInt;

    RecursiveType<RecursiveType<int>*> RT2;
    RT2.m_Int  = 3;
    RT2.m_Type = &RT1;

    A::ClassA<int>*    pCA = new A::ClassA<int>();
    B::ClassB<float*>* pCB = new B::ClassB<float*>();
    ClassC<int>*       pCC = new ClassC<int>();
    D::ClassD<float>*  pCD = new D::ClassD<float>();
    ClassE<int>*       pCE = new ClassE<int>();

    // delete me.
    B::ClassB<float*>** ppCB = &pCB;
    B::ClassB<float*>*** pppCB = &ppCB;

    A::ClassA<double>       CA;
    B::ClassB<int>          CB;
    ClassC<long long int>   CC;
    D::ClassD<int>          CD;
    ClassE<A::ClassA<int>>  CE;

    SyntheticTestClass STC;
    STC.m_pID = &IDH;

    std::deque<int> DequeOfInts1;
    DequeOfInts1.emplace_front( 1 );
    DequeOfInts1.emplace_back( 2 );
    DequeOfInts1.emplace_back( 3 );
    DequeOfInts1.emplace_front( 0 );

    std::deque<int> DequeOfInts2;
    DequeOfInts2.emplace_front( 10 );
    DequeOfInts2.emplace_back( 20);
    DequeOfInts2.emplace_back( 30 );
    DequeOfInts2.emplace_front( 0 );

    std::deque<std::deque<int>> DequeOfDequeOfInts;
    DequeOfDequeOfInts.emplace_front( DequeOfInts1 );
    DequeOfDequeOfInts.emplace_back( DequeOfInts2 );

    ExpandedItemTestClass EITC;
    EITC.m_pIDH = &IDH;

    Q SameNameAsRegister;

    struct NatVisWrapperStruct
    {
        NatVisWrapperStruct()
        {
            MapOfDoubleToChars1.insert( { 2.0, "2.0" } );
            MapOfDoubleToChars1.insert( { 4.0, "4.0" } );

            VectorOfDoubles1.push_back( 1.0 );
            VectorOfDoubles1.push_back( 2.0 );

            ListOfDoubles1.push_back( 1.0 );
            ListOfDoubles1.push_back( 2.0 );

            ForwardListOfDoubles1.push_front( 3.0 );
            ForwardListOfDoubles1.push_front( 2.0 );

            SetOfDoubles1.insert( 1.0 );
            SetOfDoubles1.insert( 2.0 );

            MapOfDoubleToChars2.insert( { 8.0, "8.0" } );
            MapOfDoubleToChars2.insert( { 16.0, "16.0" } );

            VectorOfDoubles2.push_back( 10.0 );
            VectorOfDoubles2.push_back( 20.0 );

            ListOfDoubles2.push_back( 10.0 );
            ListOfDoubles2.push_back( 200.0 );

            ForwardListOfDoubles2.push_front( 30.0 );
            ForwardListOfDoubles2.push_front( 20.0 );

            SetOfDoubles2.insert( 10.0 );
            SetOfDoubles2.insert( 20.0 );

            MapOfDoubleToMapOfDoubleToChars.insert( { 1.0, MapOfDoubleToChars1 } );
            MapOfDoubleToMapOfDoubleToChars.insert( { 2.0, MapOfDoubleToChars2 } );

            VectorOfVectorDoubles.push_back( VectorOfDoubles1 );
            VectorOfVectorDoubles.push_back( VectorOfDoubles2 );

            ListOfListOfDoubles.push_back( ListOfDoubles1 );
            ListOfListOfDoubles.push_back( ListOfDoubles2 );

            ForwardListOfForwardListOfDoubles.push_front( ForwardListOfDoubles2 );
            ForwardListOfForwardListOfDoubles.push_front( ForwardListOfDoubles1 );

            SetOfSetOfDoubles.insert( SetOfDoubles1 );
            SetOfSetOfDoubles.insert( SetOfDoubles2 );

            NarrowString = "Narrow Hello";
            WideString   = L"Wide Hello";

            MapOfDoubleTopMapOfDoubleToChars.insert( { 1.0, &MapOfDoubleToChars1 } );
            MapOfDoubleTopMapOfDoubleToChars.insert( { 2.0, &MapOfDoubleToChars2 } );

            VectorOfpVectorDoubles.push_back( &VectorOfDoubles1 );
            VectorOfpVectorDoubles.push_back( &VectorOfDoubles2 );

            ListOfpListOfDoubles.push_back( &ListOfDoubles1 );
            ListOfpListOfDoubles.push_back( &ListOfDoubles2 );

            ForwardListOfpForwardListOfDoubles.push_front( &ForwardListOfDoubles2 );
            ForwardListOfpForwardListOfDoubles.push_front( &ForwardListOfDoubles1 );

            SetOfpSetOfDoubles.insert( &SetOfDoubles1 );
            SetOfpSetOfDoubles.insert( &SetOfDoubles2 );

            SAInts.CreateArray( 15 );

            SADouble.CreateArray( 3 );

            ID.m_id = 1234;
            ID.m_Holder = &IDH;
            IDH.m_pID = &ID;

            RT1.m_Int = 2;
            RT1.m_Type = TheInt;

            RT2.m_Int = 3;
            RT2.m_Type = &RT1;

            pCA = new A::ClassA<int>();
            pCB = new B::ClassB<float*>();
            pCC = new ClassC<int>();
            pCD = new D::ClassD<float>();
            pCE = new ClassE<int>();

            STC.m_pID = &IDH;

            DequeOfInts1.emplace_front( 1 );
            DequeOfInts1.emplace_back( 2 );
            DequeOfInts1.emplace_back( 3 );
            DequeOfInts1.emplace_front( 0 );

            DequeOfInts2.emplace_front( 10 );
            DequeOfInts2.emplace_back( 20 );
            DequeOfInts2.emplace_back( 30 );
            DequeOfInts2.emplace_front( 0 );

            DequeOfDequeOfInts.emplace_front( DequeOfInts1 );
            DequeOfDequeOfInts.emplace_back( DequeOfInts2 );

            EITC.m_pIDH = &IDH;
        }
        // Initial set of NatVis variables.
        std::map< double, const char* > MapOfDoubleToChars1;
        std::vector< double > VectorOfDoubles1;
        std::list< double > ListOfDoubles1;
        std::forward_list< double > ForwardListOfDoubles1;
        std::set< double > SetOfDoubles1;

        // Additional set of NatVis variables.
        std::map< double, const char* > MapOfDoubleToChars2;
        std::vector< double > VectorOfDoubles2;
        std::list< double > ListOfDoubles2;
        std::forward_list< double > ForwardListOfDoubles2;
        std::set< double > SetOfDoubles2;

        // Nested NatVis variables.
        std::map< double, std::map< double, const char* > > MapOfDoubleToMapOfDoubleToChars;
        std::vector< std::vector< double > > VectorOfVectorDoubles;
        std::list< std::list< double > > ListOfListOfDoubles;
        std::forward_list< std::forward_list< double > > ForwardListOfForwardListOfDoubles;
        std::set< std::set< double > > SetOfSetOfDoubles;

        std::string NarrowString;
        std::wstring WideString;

        // Nested pointer to NatVis types.
        std::map< double, std::map< double, const char* >* > MapOfDoubleTopMapOfDoubleToChars;
        std::vector< std::vector< double >* > VectorOfpVectorDoubles;
        std::list< std::list< double >* > ListOfpListOfDoubles;
        std::forward_list< std::forward_list< double >* > ForwardListOfpForwardListOfDoubles;
        std::set< std::set< double >* > SetOfpSetOfDoubles;

        // Various custom NatVis types as defined by the project's NatvisTest.natvis file.
        SparseArray2<int> SAInts;
        SparseArray<double> SADouble;

        Identification ID;
        IDHolder       IDH;

        int TheInt = 1;
        RecursiveType<int> RT1;
        RecursiveType<RecursiveType<int>*> RT2;

        A::ClassA<int>*    pCA;
        B::ClassB<float*>* pCB;
        ClassC<int>*       pCC;
        D::ClassD<float>*  pCD;
        ClassE<int>*       pCE;

        A::ClassA<double>       CA;
        B::ClassB<int>          CB;
        ClassC<long double>     CC;
        D::ClassD<int>          CD;
        ClassE<A::ClassA<int>>  CE;

        SyntheticTestClass STC;
        std::deque<int> DequeOfInts1;
        std::deque<int> DequeOfInts2;
        std::deque<std::deque<int>> DequeOfDequeOfInts;
        ExpandedItemTestClass EITC;
    };
    NatVisWrapperStruct NVWS;

    nn::Result ResultOkay                   = nn::ResultSuccess();
    nn::Result ResultFSLongPath             = ResultTooLongPath();
    nn::Result ResultHTCSDuplicatedService  = ResultDuplicatedServiceName();
    nn::Result ResultHTCConnectFailure      = ResultConnectionFailure();
    nn::Result ResultOSAccessViolation      = ResultAccessViolation();

    int Hold = 0;
    ++Hold; // NatVisTestBP01
    printf("NarrowString address: %p, WideString address: %p,", &NarrowString, &WideString);
}
