﻿// The purpose of the test is to validate the expression parser can
// correctly display various string types in a variety of requested formats
// such as "String, 5" to display the first 5 characters of the string.

#include <cstdint>
#include <stdint.h>
#include <nn\os\os_Thread.h>

// Char, wchar_t, char16_t, char32_t literal string globals.
const char*     pJapaneseHelloWorldChar     =  "こんにちは世界"; //Translate: Hello World.
const wchar_t*  pJapaneseHelloWorldWChar    = L"こんにちは世界";
const char16_t* pHelloWorldChar16           = u"Hello World";
const char32_t* pHelloWorldChar32           = U"Hello World";
const char16_t* pJapanesepHelloWorldChar16  = u"こんにちは世界";
const char32_t* pJapanesepHelloWorldChar32  = U"こんにちは世界";

class 構造 // Translate: Structure.
{
public:
    構造( ) :
        整数( 0 ),
        m_pJapaneseHelloWorldChar( pJapaneseHelloWorldChar ),
        m_pJapaneseHelloWorldWChar( pJapaneseHelloWorldWChar ),
        m_Char( pJapaneseHelloWorldChar[0] ),
        m_WChar( pJapaneseHelloWorldWChar[0] ),
        m_Char16( pHelloWorldChar16[0] ),
        m_Char32( pHelloWorldChar32[0] ),
        m_JapaneseChar16( pJapanesepHelloWorldChar16[0] ),
        m_JapaneseChar32( pJapanesepHelloWorldChar32[0] )
    {
        m_CharArray[0] = 'f';
        m_CharArray[1] = 'o';
        m_CharArray[2] = 'o';
        m_CharArray[3] = 'b';
        m_CharArray[4] = 'a';
        m_CharArray[5] = 'r';
        m_CharArray[6] = '\0';

        m_WCharArray[0] = L'f';
        m_WCharArray[1] = L'o';
        m_WCharArray[2] = L'o';
        m_WCharArray[3] = L'b';
        m_WCharArray[4] = L'a';
        m_WCharArray[5] = L'r';
        m_WCharArray[6] = L'\0';

        m_pChar  = "foobar";
        m_pWChar = L"foobar";
    };
    void 関数( 構造 &構造パラメータ ); // Translate: Function.
private:
    int 整数; // Translate: Integer.
    const char*     m_pJapaneseHelloWorldChar;
    const wchar_t*  m_pJapaneseHelloWorldWChar;
    char            m_Char;
    wchar_t         m_WChar;
    char16_t        m_Char16;
    char32_t        m_Char32;
    char16_t        m_JapaneseChar16;
    char32_t        m_JapaneseChar32;
    const char*     m_pChar;
    const wchar_t*  m_pWChar;
    char            m_CharArray[7];
    wchar_t         m_WCharArray[7];
};

void 構造::関数( 構造 &構造パラメータ ) // Translate: Structure parameter.
{
    // Test thread name string.
    nn::os::SetThreadName( nn::os::GetCurrentThread( ), "スレッド" ); // Translate: Thread.
    const char* ThreadName = nn::os::GetThreadNamePointer( nn::os::GetCurrentThread( ) );

    // Test local variables.
    const char*     pLocalJapaneseHelloWorldChar    = pJapaneseHelloWorldChar;
    const wchar_t*  pLocalJapaneseHelloWorldWChar   = pJapaneseHelloWorldWChar;
    char            LocalCharArray[]                = "こんにちは世界";
    wchar_t         LocalWCharArray[]               = L"こんにちは世界";
    char16_t  LocalHelloWorldChar16Array[]          = u"Hello World";
    char32_t  LocalHelloWorldChar32Array[]          = U"Hello World";
    char16_t  LocalJapaneseHelloWorldChar16Array[]  = u"こんにちは世界";
    char32_t  LocalJapaneseHelloWorldChar32Array[]  = U"こんにちは世界";

    // Test higher order characters.
    char      LocalHighOrderCharArray[]   = { (char)-1,     (char)-2,     (char)-3,     (char)0 };
    wchar_t   LocalHighOrderWCharArray[]  = { (wchar_t)-1,  (wchar_t)-2,  (wchar_t)-3,  (wchar_t)0 };
    char16_t  LocalHighOrderChar16Array[] = { (char16_t)-1, (char16_t)-2, (char16_t)-3, (char16_t)0 };
    char32_t  LocalHighOrderChar32Array[] = { (char32_t)-1, (char32_t)-2, (char32_t)-3, (char32_t)0 };
    char*     pLocalHighOrderCharArray    = LocalHighOrderCharArray;
    wchar_t*  pLocalHighOrderWCharArray   = LocalHighOrderWCharArray;
    char16_t* pLocalHighOrderChar16Array  = LocalHighOrderChar16Array;
    char32_t* pLocalHighOrderChar32Array  = LocalHighOrderChar32Array;

    ++構造パラメータ.整数; // StringsTestBP01 // WriteRegistersTestBP01
}

extern "C" void nnMain ( void )
{
    構造 私の構造; // Translate: My structure.
    私の構造.関数(私の構造);
}
