﻿#include <cstdio>
#include <stdio.h>
#include <cstdarg>
#include <iostream>

// Definition of a simple struct for testing function parameters and return types.
struct TheStruct
{
    int         m_Int;
    double      m_Double;
    float       m_float;
    char        m_char;
    TheStruct( )
    {
        m_Int       = 42;
        m_Double    = 42.0;
        m_float     = 42.0;
        m_char      = 42;
    }
};

void TheVoidFunction( void )
{
    printf( "TheVoidFunction was called.\n" );
}

void* TheVoidPtrFunction( void* )
{
    printf( "TheVoidPtrFunction was called.\n" );
    return nullptr;
}

int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
{
    printf( "TheIntFunction was called with %d.\n", TheInt );
    return TheInt;
}

int& TheIntRefFunction( int TheInt, int* pTheInt, const int& TheIntRef )
{
    printf( "TheIntRefFunction was called with %d.\n", TheInt );
    return TheInt;
}

int*& TheIntRefPtrFunction( int TheInt, int* pTheInt, const int& TheIntRef )
{
    printf( "TheIntRefPtrFunction was called with %d.\n", TheInt );
    return pTheInt;
}

double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
{
    printf( "TheDoubleFunction was called with %f.\n", TheDouble );
    return TheDouble;
}

double& TheDoubleRefFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
{
    printf( "TheDoubleRefFunction was called with %f.\n", TheDouble );
    return TheDouble;
}

double*& TheDoubleRefPtrFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
{
    printf( "TheDoubleRefPtrFunction was called with %f.\n", TheDouble );
    return pTheDouble;
}

float TheFloatFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
{
    printf( "TheFloatFunction was called with %f.\n", TheFloat );
    return TheFloat;
}

float& TheFloatRefFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
{
    printf( "TheFloatRefFunction was called with %f.\n", TheFloat );
    return TheFloat;
}

float*& TheFloatRefPtrFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
{
    printf( "TheFloatRefPtrFunction was called with %f.\n", TheFloat );
    return pTheFloat;
}

TheStruct* TheStructPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
{
    printf( "TheStructPtrFunction was called with %d.\n", Struct.m_Int );
    return &Struct;
}

TheStruct& TheStructRefFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
{
    printf( "TheStructRefFunction was called with %d.\n", Struct.m_Int );
    return Struct;
}

TheStruct*& TheStructRefPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
{
    printf( "TheStructRefPtrFunction was called with %d.\n", Struct.m_Int );
    return pStruct;
}

const TheStruct* TheComplexStructFunction( const TheStruct*** const pppStruct )
{
    printf( "TheComplexStructFunction was called.\n" );
    return **pppStruct;
}

void TheFunctionPointerFunction( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) )
{
    printf( "TheFunctionPointerFunction was called.\n" );
}

typedef TheStruct* (*TypeDefFunction)( const TheStruct& Struct );
TypeDefFunction* TheReallyComplexFunction( TypeDefFunction* pFunctionPointerParam )
{
    printf( "TheReallyComplexFunction was called.\n" );
    return pFunctionPointerParam;
}

const int * const * const TheMultipleConstPointersFunction( const int * const * const ppInt, const TheStruct * const * const ppTheStruct )
{
    printf( "TheMultipleConstPointersFunction was called.\n" );
    return ppInt;
}

class ClassFunctions
{
public:
    ClassFunctions() {};
    void TheVoidFunction( void )
    {
        printf( "ClassFunctions::TheVoidFunction was called.\n" );
    }

    void* TheVoidPtrFunction( void* )
    {
        printf( "ClassFunctions::TheVoidPtrFunction was called.\n" );
        return nullptr;
    }

    int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
    {
        printf( "ClassFunctions::TheIntFunction was called with %d.\n", TheInt );
        return TheInt;
    }

    double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
    {
        printf( "ClassFunctions::TheDoubleFunction was called with %f.\n", TheDouble );
        return TheDouble;
    }

    float TheFloatFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
    {
        printf( "ClassFunctions::TheFloatFunction was called with %f.\n", TheFloat );
        return TheFloat;
    }

    TheStruct* TheStructPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
    {
        printf( "ClassFunctions::TheStructPtrFunction was called with %d.\n", Struct.m_Int );
        return &Struct;
    }

    const TheStruct* TheComplexStructFunction( const TheStruct*** const pppStruct )
    {
        printf( "ClassFunctions::TheComplexStructFunction was called.\n" );
        return **pppStruct;
    }

    void TheFunctionPointerFunction( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) )
    {
        printf( "ClassFunctions::TheFunctionPointerFunction was called.\n" );
    }

    typedef TheStruct* ( *TypeDefFunction )( const TheStruct& Struct );
    TypeDefFunction* TheReallyComplexFunction( TypeDefFunction* pFunctionPointerParam )
    {
        printf( "ClassFunctions::TheReallyComplexFunction was called.\n" );
        return pFunctionPointerParam;
    }

    const int * const * const TheMultipleConstPointersFunction( const int * const * const ppInt, const TheStruct * const * const ppTheStruct )
    {
        printf( "ClassFunctions::TheMultipleConstPointersFunction was called.\n" );
        return ppInt;
    }
};

class ClassVirtualFunctions
{
public:
    ClassVirtualFunctions() {};
    virtual void TheVoidFunction( void )
    {
        printf( "ClassVirtualFunctions::TheVoidFunction was called.\n" );
    }

    virtual void* TheVoidPtrFunction( void* )
    {
        printf( "ClassVirtualFunctions::TheVoidPtrFunction was called.\n" );
        return nullptr;
    }

    virtual int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
    {
        printf( "ClassVirtualFunctions::TheIntFunction was called with %d.\n", TheInt );
        return TheInt;
    }

    virtual double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
    {
        printf( "ClassVirtualFunctions::TheDoubleFunction was called with %f.\n", TheDouble );
        return TheDouble;
    }

    virtual float TheFloatFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
    {
        printf( "ClassVirtualFunctions::TheFloatFunction was called with %f.\n", TheFloat );
        return TheFloat;
    }

    virtual TheStruct* TheStructPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
    {
        printf( "ClassVirtualFunctions::TheStructPtrFunction was called with %d.\n", Struct.m_Int );
        return &Struct;
    }

    virtual const TheStruct* TheComplexStructFunction( const TheStruct*** const pppStruct )
    {
        printf( "ClassVirtualFunctions::TheComplexStructFunction was called.\n" );
        return **pppStruct;
    }

    virtual void TheFunctionPointerFunction( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) )
    {
        printf( "ClassVirtualFunctions::TheFunctionPointerFunction was called.\n" );
    }

    typedef TheStruct* ( *TypeDefFunction )( const TheStruct& Struct );
    virtual TypeDefFunction* TheReallyComplexFunction( TypeDefFunction* pFunctionPointerParam )
    {
        printf( "ClassVirtualFunctions::TheReallyComplexFunction was called.\n" );
        return pFunctionPointerParam;
    }

    virtual const int * const * const TheMultipleConstPointersFunction( const int * const * const ppInt, const TheStruct * const * const ppTheStruct )
    {
        printf( "ClassVirtualFunctions::TheMultipleConstPointersFunction was called.\n" );
        return ppInt;
    }
};

class ChildClassVirtualFunctions : public ClassVirtualFunctions
{
public:
    ChildClassVirtualFunctions() {};
    virtual void TheVoidFunction( void )
    {
        printf( "ChildClassVirtualFunctions::TheVoidFunction was called.\n" );
    }

    virtual void* TheVoidPtrFunction( void* )
    {
        printf( "ChildClassVirtualFunctions::TheVoidPtrFunction was called.\n" );
        return nullptr;
    }

    virtual int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
    {
        printf( "ChildClassVirtualFunctions::TheIntFunction was called with %d.\n", TheInt );
        return TheInt;
    }

    virtual double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
    {
        printf( "ChildClassVirtualFunctions::TheDoubleFunction was called with %f.\n", TheDouble );
        return TheDouble;
    }

    virtual float TheFloatFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
    {
        printf( "ChildClassVirtualFunctions::TheFloatFunction was called with %f.\n", TheFloat );
        return TheFloat;
    }

    virtual TheStruct* TheStructPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
    {
        printf( "ChildClassVirtualFunctions::TheStructPtrFunction was called with %d.\n", Struct.m_Int );
        return &Struct;
    }

    virtual const TheStruct* TheComplexStructFunction( const TheStruct*** const pppStruct )
    {
        printf( "ChildClassVirtualFunctions::TheComplexStructFunction was called.\n" );
        return **pppStruct;
    }

    virtual void TheFunctionPointerFunction( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) )
    {
        printf( "ChildClassVirtualFunctions::TheFunctionPointerFunction was called.\n" );
    }

    typedef TheStruct* ( *TypeDefFunction )( const TheStruct& Struct );
    virtual TypeDefFunction* TheReallyComplexFunction( TypeDefFunction* pFunctionPointerParam )
    {
        printf( "ChildClassVirtualFunctions::TheReallyComplexFunction was called.\n" );
        return pFunctionPointerParam;
    }

    virtual const int * const * const TheMultipleConstPointersFunction( const int * const * const ppInt, const TheStruct * const * const ppTheStruct )
    {
        printf( "ChildClassVirtualFunctions::TheMultipleConstPointersFunction was called.\n" );
        return ppInt;
    }
};

class StaticClassFunctions
{
public:
    StaticClassFunctions() {};
    static void TheVoidFunction( void )
    {
        printf( "StaticClassFunctions::TheVoidFunction was called.\n" );
    }

    static void* TheVoidPtrFunction( void* )
    {
        printf( "StaticClassFunctions::TheVoidPtrFunction was called.\n" );
        return nullptr;
    }

    static int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
    {
        printf( "StaticClassFunctions::TheIntFunction was called with %d.\n", TheInt );
        return TheInt;
    }

    static double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
    {
        printf( "StaticClassFunctions::TheDoubleFunction was called with %f.\n", TheDouble );
        return TheDouble;
    }

    static float TheFloatFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
    {
        printf( "StaticClassFunctions::TheFloatFunction was called with %f.\n", TheFloat );
        return TheFloat;
    }

    static TheStruct* TheStructPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
    {
        printf( "StaticClassFunctions::TheStructPtrFunction was called with %d.\n", Struct.m_Int );
        return &Struct;
    }

    static const TheStruct* TheComplexStructFunction( const TheStruct*** const pppStruct )
    {
        printf( "StaticClassFunctions::TheComplexStructFunction was called.\n" );
        return **pppStruct;
    }

    static void TheFunctionPointerFunction( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) )
    {
        printf( "StaticClassFunctions::TheFunctionPointerFunction was called.\n" );
    }

    typedef TheStruct* ( *TypeDefFunction )( const TheStruct& Struct );
    static TypeDefFunction* TheReallyComplexFunction( TypeDefFunction* pFunctionPointerParam )
    {
        printf( "StaticClassFunctions::TheReallyComplexFunction was called.\n" );
        return pFunctionPointerParam;
    }

    static const int * const * const TheMultipleConstPointersFunction( const int * const * const ppInt, const TheStruct * const * const ppTheStruct )
    {
        printf( "StaticClassFunctions::TheMultipleConstPointersFunction was called.\n" );
        return ppInt;
    }
};

template <class Type1, class Type2, class Type3>
class TemplateClassFunctions
{
public:
    TemplateClassFunctions() {};
    void TheVoidFunction( void )
    {
        printf( "TemplateClassFunctions::TheVoidFunction was called.\n" );
    }

    void* TheVoidPtrFunction( void* )
    {
        printf( "TemplateClassFunctions::TheVoidPtrFunction was called.\n" );
        return nullptr;
    }

    int TheIntFunction( int TheInt, int* pTheInt, const int& TheIntRef )
    {
        printf( "TemplateClassFunctions::TheIntFunction was called with %d.\n", TheInt );
        return TheInt;
    }

    double TheDoubleFunction( double TheDouble, double* pTheDouble, const double& TheDoubleRef )
    {
        printf( "TemplateClassFunctions::TheDoubleFunction was called with %f.\n", TheDouble );
        return TheDouble;
    }

    float TheFloatFunction( float TheFloat, float* pTheFloat, const float& TheFloatRef )
    {
        printf( "TemplateClassFunctions::TheFloatFunction was called with %f.\n", TheFloat );
        return TheFloat;
    }

    TheStruct* TheStructPtrFunction( TheStruct Struct, TheStruct* pStruct, const TheStruct& StructRef )
    {
        printf( "TemplateClassFunctions::TheStructPtrFunction was called with %d.\n", Struct.m_Int );
        return &Struct;
    }

    const TheStruct* TheComplexStructFunction( const TheStruct*** const pppStruct )
    {
        printf( "ClassFunctions::TheComplexStructFunction was called.\n" );
        return **pppStruct;
    }

    void TheFunctionPointerFunction( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) )
    {
        printf( "TemplateClassFunctions::TheFunctionPointerFunction was called.\n" );
    }

    typedef TheStruct* ( *TypeDefFunction )( const TheStruct& Struct );
    TypeDefFunction* TheReallyComplexFunction( TypeDefFunction* pFunctionPointerParam )
    {
        printf( "TemplateClassFunctions::TheReallyComplexFunction was called.\n" );
        return pFunctionPointerParam;
    }

    const int * const * const TheMultipleConstPointersFunction( const int * const * const ppInt, const TheStruct * const * const ppTheStruct )
    {
        printf( "TemplateClassFunctions::TheMultipleConstPointersFunction was called.\n" );
        return ppInt;
    }
private:
    Type1 T1;
    Type2 T2;
    Type3 T3;
};

class TheClass
{
public:
    TheClass( ) :
        m_pTheVoidFunction( nullptr ),
        m_pTheVoidPtrFunction( nullptr ),
        m_pTheIntFunction( nullptr ),
        m_pTheDoubleFunction( nullptr ),
        m_pTheFloatFunction( nullptr ),
        m_pTheStructPtrFunction( nullptr ),
        m_pTheComplexStructFunction( nullptr ),
        m_ppTheVoidFunction( nullptr ),
        m_ppTheVoidPtrFunction( nullptr ),
        m_ppTheIntFunction( nullptr ),
        m_ppTheDoubleFunction( nullptr ),
        m_ppTheFloatFunction( nullptr ),
        m_ppTheStructPtrFunction( nullptr ),
        m_ppTheComplexStructFunction( nullptr ),
        m_pppTheVoidFunction( nullptr ),
        m_pppTheVoidPtrFunction( nullptr ),
        m_pppTheIntFunction( nullptr ),
        m_pppTheDoubleFunction( nullptr ),
        m_pppTheFloatFunction( nullptr ),
        m_pppTheStructPtrFunction( nullptr ),
        m_pppTheComplexStructFunction( nullptr ),
        m_pTheFunctionPointerFunction( nullptr ),
        m_pTheReallyComplexFunction( nullptr ),
        m_pTheMultipleConstPointersFunction( TheMultipleConstPointersFunction )
    {
        m_pTheVoidFunction            = TheVoidFunction; // FunctionPointerMembersTestBP01
        m_pTheVoidPtrFunction         = TheVoidPtrFunction;
        m_pTheIntFunction             = TheIntFunction;
        m_pTheDoubleFunction          = TheDoubleFunction;
        m_pTheFloatFunction           = TheFloatFunction;
        m_pTheStructPtrFunction       = TheStructPtrFunction;
        m_pTheComplexStructFunction   = TheComplexStructFunction;

        m_ppTheVoidFunction           = &m_pTheVoidFunction;
        m_ppTheVoidPtrFunction        = &m_pTheVoidPtrFunction;
        m_ppTheIntFunction            = &m_pTheIntFunction;
        m_ppTheDoubleFunction         = &m_pTheDoubleFunction;
        m_ppTheFloatFunction          = &m_pTheFloatFunction;
        m_ppTheStructPtrFunction      = &m_pTheStructPtrFunction;
        m_ppTheComplexStructFunction  = &m_pTheComplexStructFunction;

        m_pppTheVoidFunction          = &m_ppTheVoidFunction;
        m_pppTheVoidPtrFunction       = &m_ppTheVoidPtrFunction;
        m_pppTheIntFunction           = &m_ppTheIntFunction;
        m_pppTheDoubleFunction        = &m_ppTheDoubleFunction;
        m_pppTheFloatFunction         = &m_ppTheFloatFunction;
        m_pppTheStructPtrFunction     = &m_ppTheStructPtrFunction;
        m_pppTheComplexStructFunction = &m_ppTheComplexStructFunction;

        m_pTheFunctionPointerFunction = TheFunctionPointerFunction;
        m_pTheReallyComplexFunction   = TheReallyComplexFunction;
    } // FunctionPointerMembersTestBP02
private:

    // Pointers to functions!
    void             (*m_pTheVoidFunction)              ( void );
    void*            (*m_pTheVoidPtrFunction)           ( void* );
    int              (*m_pTheIntFunction)               ( int, int*, const int& );
    double           (*m_pTheDoubleFunction)            ( double, double*, const double& );
    float            (*m_pTheFloatFunction)             ( float, float*, const float& );
    TheStruct*       (*m_pTheStructPtrFunction)         ( TheStruct, TheStruct*, const TheStruct& );
    const TheStruct* (*m_pTheComplexStructFunction)     ( const TheStruct*** const pppStruct );

    // Pointers to pointers to functions!
    void             (**m_ppTheVoidFunction)            ( void );
    void*            (**m_ppTheVoidPtrFunction)         ( void* );
    int              (**m_ppTheIntFunction)             ( int, int*, const int& );
    double           (**m_ppTheDoubleFunction)          ( double, double*, const double& );
    float            (**m_ppTheFloatFunction)           ( float, float*, const float& );
    TheStruct*       (**m_ppTheStructPtrFunction)       ( TheStruct, TheStruct*, const TheStruct& );
    const TheStruct* (**m_ppTheComplexStructFunction)   ( const TheStruct*** const pppStruct );

    // Pointers to pointers to pointers to functions!
    void             (***m_pppTheVoidFunction)          ( void );
    void*            (***m_pppTheVoidPtrFunction)       ( void* );
    int              (***m_pppTheIntFunction)           ( int, int*, const int& );
    double           (***m_pppTheDoubleFunction)        ( double, double*, const double& );
    float            (***m_pppTheFloatFunction)         ( float, float*, const float& );
    TheStruct*       (***m_pppTheStructPtrFunction)     ( TheStruct, TheStruct*, const TheStruct& );
    const TheStruct* (***m_pppTheComplexStructFunction) ( const TheStruct*** const pppStruct );

    // Complex test case using function pointers as parameters.
    void             (*m_pTheFunctionPointerFunction)   ( double( *ADoubleFunction )( double, double*, const double& ), int( *AIntFunction )( int, int*, const int& ) );

    // Complex test case using function pointers as params and return type.
    TypeDefFunction* (*m_pTheReallyComplexFunction)     ( TypeDefFunction* pFunctionPointerParam );

    // Complex levels of const pointers.
    const int * const * const ( *const m_pTheMultipleConstPointersFunction )( const int * const * const ppInt, const TheStruct * const * const ppTheStruct );
};

// The following series of classes test a complex diamond inheritance test case.
// This test is specific to virtual tables, but could be used for other purposes.
// The hierarchy looks like:
//          TheBaseClass
//              /
//    TheDerivedClass   TheExtraClass
//         /       \           /
// TheChildClass   TheMultipleInheritanceClass

class TheBaseClass
{
public:
    TheBaseClass( ) :
        m_Int( 0 ),
        m_Double( 1.0 ),
        m_pChild( nullptr )
    {
    }
    virtual ~TheBaseClass( )
    {
        m_pChild = nullptr;
    }

    virtual void AddChild( TheBaseClass* pBaseClass )
    {
        m_pChild = pBaseClass;
    }

    virtual void Print( void )
    {
        printf( "TheBaseClass" );
    }

    virtual void Print123( void )
    {
        printf( "Print123" );
    }

    virtual void Print234( void )
    {
        printf( "Print234" );
    }

    virtual void Print345( void )
    {
        printf( "Print345" );
    }

    void BaseAddMembers( void )
    {
        int Sum     = (int)(m_Int + m_Double);
        m_Int       = Sum;
        m_Double    = (double)Sum;
    }

private:
    int             m_Int;
    double          m_Double;
    TheBaseClass*   m_pChild;
};

class TheDerivedClass : public TheBaseClass
{
public:
    TheDerivedClass( ) :
        m_Int( 0 ),
        m_Double( 1.0 ),
        m_pChild( nullptr )
    {
    }
    virtual ~TheDerivedClass( )
    {
        m_pChild = nullptr;
    }

    virtual void Print( void )
    {
        printf( "TheDerivedClass" );
    }

    virtual void ChildAddMembers( void )
    {
        printf( "TheDerivedClass ChildAddMembers" );
        double Sum  = m_Int + m_Double;
        m_Int       = (int)Sum;
        m_Double    = Sum;
    }

    virtual int Conflict( int )
    {
        printf( "Conflict" );
        return 1;
    }

private:
    int             m_Int;
    double          m_Double;
    TheBaseClass*   m_pChild;
};

class TheChildClass : public TheDerivedClass
{
public:
    TheChildClass( )
    {
    }
    virtual ~TheChildClass( )
    {
    }

    virtual void Print( void )
    {
        printf( "TheChildClass" );
    }

    virtual void ChildAddMembers( void )
    {
        printf( "TheChildClass ChildAddMembers" );
    }
};

class TheExtraClass
{
public:
    TheExtraClass( ) : m_Int( 4 )
    {
    }
    virtual ~TheExtraClass( )
    {
    }

    virtual void Print2( void )
    {
        printf( "TheExtraClass" );
    }

    virtual int Conflict( int )
    {
        printf( "Conflict" );
        return 2;
    }
    int m_Int;
};

class TheMultipleInheritanceClass : public TheDerivedClass, public TheExtraClass
{
public:
    TheMultipleInheritanceClass( )
    {
    }
    virtual ~TheMultipleInheritanceClass( )
    {
    }

    virtual int Conflict( int )
    {
        printf( "Conflict" );
        return 3;
    }

    virtual void Print( void )
    {
        printf( "TheMultipleInheritanceClass" );
    }

    virtual void Print2( void )
    {
        printf( "TheMultipleInheritanceClass" );
    }
};

//==============================================================================

void VariadicPrint(const char* ArgsString...)
{
    va_list Args;
    va_start(Args, ArgsString);

    while (*ArgsString != '\0')
    {
        // Only supporting ints, doubles, and strings...
        if(*ArgsString == 'd')
        {
            int i = va_arg(Args, int);
            std::cout << i << '\n';
        }
        else if(*ArgsString == 's')
        {
            char* c = va_arg(Args, char*);
            std::cout << c << '\n';
        }
        else if(*ArgsString == 'f')
        {
            double d = va_arg(Args, double);
            std::cout << d << '\n';
        }
        ++ArgsString;
    }

    va_end(Args);
}

//==============================================================================

int VariadicSum( void )
{
    return 0;
}

template<typename ... Types>
int VariadicSum( int First, Types ... Params )
{
    return First + VariadicSum( Params... );
}

//==============================================================================

// Test case for Siglo-56369
class NTDBase {
public:
    void Func() { printf( "" ); }
    virtual void FuncV() { printf( "" ); }
};

class NTDDerived : public NTDBase
{
public:
    virtual void FuncV() { printf( "" ); }
};

//==============================================================================

extern "C" void nnMain ( void )
{
    TheStruct                       MyStruct;
    TheClass                        MyClass;
    int                             MyInt       = 1;
    double                          MyDouble    = 2.1;
    float                           MyFloat     = 3.2;
    const int * const * const       ppInt       = nullptr;
    const TheStruct * const * const ppTheStruct = nullptr;

    TheChildClass               CC;
    TheMultipleInheritanceClass MI;

    void ( TheBaseClass::*MemberFunctionPtr )( ) = &TheBaseClass::BaseAddMembers;
    void ( TheDerivedClass::*MemberVirtualFunctionPtr )( ) = &TheDerivedClass::Print;

    NTDBase     Base;
    NTDDerived  Derived;

    void ( NTDBase::*pBaseMemberVFunction )( )          = &NTDBase::FuncV;
    void ( NTDDerived::*pDerivedMemberVFunction )( )    = &NTDDerived::FuncV;

    TheVoidFunction         ( );
    TheVoidPtrFunction      ( nullptr ); // ReturnValuesTestBP01
    TheIntFunction          ( MyInt, &MyInt, MyInt );
    TheIntRefFunction       ( MyInt, &MyInt, MyInt );
    TheIntRefPtrFunction    ( MyInt, &MyInt, MyInt );
    TheDoubleFunction       ( MyDouble, &MyDouble, MyDouble);
    TheDoubleRefFunction    ( MyDouble, &MyDouble, MyDouble );
    TheDoubleRefPtrFunction ( MyDouble, &MyDouble, MyDouble );
    TheFloatFunction        ( MyFloat, &MyFloat, MyFloat );
    TheFloatRefFunction     ( MyFloat, &MyFloat, MyFloat );
    TheFloatRefPtrFunction  ( MyFloat, &MyFloat, MyFloat );
    TheStructPtrFunction    ( MyStruct, &MyStruct, MyStruct );
    TheStructRefFunction    ( MyStruct, &MyStruct, MyStruct );
    TheStructRefPtrFunction ( MyStruct, &MyStruct, MyStruct );
    TheMultipleConstPointersFunction( ppInt, ppTheStruct );

    ClassFunctions MyClassFunctions;
    MyClassFunctions.TheVoidFunction();
    MyClassFunctions.TheVoidPtrFunction( nullptr ); // ReturnValuesTestBP02
    MyClassFunctions.TheIntFunction( -MyInt, &MyInt, MyInt );
    MyClassFunctions.TheDoubleFunction( -MyDouble, &MyDouble, MyDouble );
    MyClassFunctions.TheFloatFunction( -MyFloat, &MyFloat, MyFloat );
    MyClassFunctions.TheStructPtrFunction( MyStruct, &MyStruct, MyStruct );
    MyClassFunctions.TheMultipleConstPointersFunction( ppInt, ppTheStruct );

    ClassVirtualFunctions MyClassVirtualFunctions;
    MyClassVirtualFunctions.TheVoidFunction();
    MyClassVirtualFunctions.TheVoidPtrFunction( nullptr ); // ReturnValuesTestBP03
    MyClassVirtualFunctions.TheIntFunction( MyInt, &MyInt, MyInt );
    MyClassVirtualFunctions.TheDoubleFunction( MyDouble, &MyDouble, MyDouble );
    MyClassVirtualFunctions.TheFloatFunction( MyFloat, &MyFloat, MyFloat );
    MyClassVirtualFunctions.TheStructPtrFunction( MyStruct, &MyStruct, MyStruct );
    MyClassVirtualFunctions.TheMultipleConstPointersFunction( ppInt, ppTheStruct );

    ChildClassVirtualFunctions MyChildClassVirtualFunctions;
    MyChildClassVirtualFunctions.TheVoidFunction();
    MyChildClassVirtualFunctions.TheVoidPtrFunction( nullptr ); // ReturnValuesTestBP04
    MyChildClassVirtualFunctions.TheIntFunction( MyInt, &MyInt, MyInt );
    MyChildClassVirtualFunctions.TheDoubleFunction( MyDouble, &MyDouble, MyDouble );
    MyChildClassVirtualFunctions.TheFloatFunction( MyFloat, &MyFloat, MyFloat );
    MyChildClassVirtualFunctions.TheStructPtrFunction( MyStruct, &MyStruct, MyStruct );
    MyChildClassVirtualFunctions.TheMultipleConstPointersFunction( ppInt, ppTheStruct );

    TemplateClassFunctions< int, float, double> MyTemplateClassFunctions;
    MyTemplateClassFunctions.TheVoidFunction();
    MyTemplateClassFunctions.TheVoidPtrFunction( nullptr ); // ReturnValuesTestBP05
    MyTemplateClassFunctions.TheIntFunction( MyInt, &MyInt, MyInt );
    MyTemplateClassFunctions.TheDoubleFunction( MyDouble, &MyDouble, MyDouble );
    MyTemplateClassFunctions.TheFloatFunction( MyFloat, &MyFloat, MyFloat );
    MyTemplateClassFunctions.TheStructPtrFunction( MyStruct, &MyStruct, MyStruct );
    MyTemplateClassFunctions.TheMultipleConstPointersFunction( ppInt, ppTheStruct );

    StaticClassFunctions::TheVoidFunction();
    StaticClassFunctions::TheVoidPtrFunction( nullptr ); // ReturnValuesTestBP06
    StaticClassFunctions::TheIntFunction( MyInt, &MyInt, MyInt );
    StaticClassFunctions::TheDoubleFunction( MyDouble, &MyDouble, MyDouble );
    StaticClassFunctions::TheFloatFunction( MyFloat, &MyFloat, MyFloat );
    StaticClassFunctions::TheStructPtrFunction( MyStruct, &MyStruct, MyStruct );
    StaticClassFunctions::TheMultipleConstPointersFunction( ppInt, ppTheStruct );

    void( *pVariadicPrint )( const char* ... ) = VariadicPrint;
    VariadicPrint( "%s, %d, %f", "Variadic print test.", 1, 2.0 );
    VariadicSum( 1, 2, 3, 4, 5 ); // FunctionsTestBP01 // ReturnValuesTestBP07
}
