﻿//==============================================================================
//
//  Main entry for EndlessLoop
//
//==============================================================================

#ifndef __NX__
#else
#include <nn/tma/tma.h>
#include <numeric>
#include <vector>
#include <iostream>
#endif

// Algorithms
static void TestSimpleAlgorithms()
{
    struct fibonacci
    {
        int Iterations;
    };

    fibonacci Fibonacci1{ 2 };
    fibonacci Fibonacci2{ 5 };
    fibonacci Fibonacci3{ 30 };

    int Dummy = 0;                  // AlgorithmsKey1
}

static void TestBitshiftAlgorithms()
{
    struct bitshift_addition
    {
        unsigned First;
        unsigned Second;
    };

    bitshift_addition Addition1{ 0, 0 };
    bitshift_addition Addition2{ 1, 1 };
    bitshift_addition Addition3{ 837, 28 };
    bitshift_addition Addition4{ 0xFFFFFFFF, 10 };
    bitshift_addition Addition5{ 64, 4 };
    bitshift_addition Addition6{ 0xFFFFFFFF, 0xFFFFFFFF };
    bitshift_addition Addition7{ 2376412, 8345767 };
    bitshift_addition Addition8{ 0xF7F7F7F7, 0x08080808 };

    struct bitshift_count_set_bits
    {
        unsigned Value;
    };

    bitshift_count_set_bits CountBits1{ 0 };
    bitshift_count_set_bits CountBits2{ 64 };
    bitshift_count_set_bits CountBits3{ 65 };
    bitshift_count_set_bits CountBits4{ 0xFFFFFFFF };
    bitshift_count_set_bits CountBits5{ 7826 };
    bitshift_count_set_bits CountBits6{ 0xFEDCBA98 };

    struct bitshift_reverse_bits
    {
        unsigned Value;
    };

    bitshift_reverse_bits ReverseBits1{ 0 };
    bitshift_reverse_bits ReverseBits2{ 1 };
    bitshift_reverse_bits ReverseBits3{ 0xFF00F0F0 };
    bitshift_reverse_bits ReverseBits4{ 289731 };
    bitshift_reverse_bits ReverseBits5{ 0x10000000 };

    int Dummy = 0;                  // AlgorithmsKey2
}

// Structures TODO: nested types
static void TestLinkedLists()
{
    struct basic_linked_list
    {
        basic_linked_list()             { pNext = nullptr; }
        basic_linked_list( double Val ) { pNext = nullptr; Value = Val; }
        basic_linked_list* pNext;
        double       Value;
    };

    const int nNodes = 150;
    basic_linked_list* Nodes[ nNodes ];

    for( int i = 0; i < nNodes; ++i )
    {
        Nodes[ i ] = new basic_linked_list( i );
    }

    for( int i = 0; i < nNodes - 1; ++i )
    {
        Nodes[ i ]->pNext = Nodes[ i + 1 ];
    }

    basic_linked_list* pHead = Nodes[ 0 ];

    int Dummy = 0;                  // StructuresKey1

    for( int i = 0; i < nNodes; ++i )
    {
        delete Nodes[ i ];
    }
}

// Globals
struct global_struct
{
    double Value;
};


int           g_Int1;
float         g_Float1;
double*       g_pDouble1;
global_struct g_GlobalStruct1;

static void TestGlobals()
{
    // Use globals here to keep them from being optimized out.
    g_Int1                = 100;
    g_Float1              = 123.5;
    g_pDouble1            = new double( 3.5 );
    g_GlobalStruct1.Value = 95155137.25;

    struct basic_globals
    {
        basic_globals() { Value = 589718; }
        unsigned Value;
    };

    basic_globals BasicGlobals1;
    int Dummy = 0;                  // GlobalsKey1
}

// Language
static void TestControlFlow()
{
    struct deeply_nested_if
    {
        int First;
        int Second;
        int Third;
        int Fourth;
        int Fifth;
        int Sixth;
        int Seventh;
    };

    deeply_nested_if DeepIf1{ 0, 0, 0, 0, 0, 0, 0 };
    deeply_nested_if DeepIf2{ 0, 0, 0, 0, 0, 0, 1 };
    deeply_nested_if DeepIf3{ 1, 1, 0, 0, 0, 0, 0 };
    deeply_nested_if DeepIf4{ 1, 0, 0, 0, 0, 0, 0 };
    deeply_nested_if DeepIf5{ 2, 2, 2, 0, 0, 0, 0 };
    deeply_nested_if DeepIf6{ -1, -1, -1, -1, -1, -1, -1 };

    struct nested_loop
    {
        nested_loop() { Dummy = 0; }
        int Dummy;
    };

    nested_loop NestedLoop;

    struct infinite_loop
    {};

    infinite_loop InfiniteLoop;

    int Dummy1 = 0;                  // LanguageKey1
}

static void TestMutation()
{
    struct basic_assignment
    {
        unsigned Value;
        unsigned Modifier;
    };

    basic_assignment Assignment1{ 0, 1 };
    basic_assignment Assignment2{ 29376217, 898537 };
    basic_assignment Assignment3{ 4096, 4 };
    basic_assignment Assignment4{ 0xFFFFFFFF, 2 };
    basic_assignment Assignment5{ 0x1337BEEF, 0xFEEB7331 };

    struct chained_assignment
    {
        float    Float;
        int      Int;
        double   Double;
        unsigned Unsigned;
    };

    chained_assignment ChainedAssignment1{ 1, 2, 3, 4 };
    chained_assignment ChainedAssignment2{ 328.25, 100, 100000000000.0, 25 };

    struct increment_decrement
    {
        int Int1;
        int Int2;
        double* pDouble1;
        float* pFloat1;
    };

    increment_decrement IncrementDecrement1{ -23, 49, nullptr, nullptr };

    int Dummy = 0;                  // LanguageKey2
}

static void TestAliases()
{
    struct alias1
    {
        int Value;
    };

    struct alias2
    {
        int Value;
    };

    struct alias3
    {
        int Value;
    };

    alias1 Alias1{ 32908 };
    alias2 Alias2{ -238 };
    alias3 Alias3{ -3867 };

    int Dummy = 0;                  // LanguageKey3
}

// Templates
template <typename T1, typename T2, typename T3>
struct template_macros
{
    T1 First;
    T2 Second;
    T3 Third;
};

template <typename T1, typename T2>
struct template2
{
    T1 First;
    T2 Second;
};

static void TestTemplates()
{
    template_macros<int, int, template_macros<long, double, int*>>          TemplateMacros1;
    template_macros<float, template_macros<float, float, unsigned>, double> TemplateMacros2;

    template_macros<template2<template2<int, double>, template2<float, int>>, double, float> TemplateMacros3;

    int Dummy = 0;                  // TemplateKey1
}

// Errors

// Misc

// This feature is a general expression parser feature, but is most important for CustomListItems,
// such as in the conditional if( curNode && curNode->next ).
static void TestShortCircuitEvaluation()
{
    struct short_circuit_evaluation
    {
        int Dummy;
    };

    short_circuit_evaluation ShortCircuitEvaluation;

    int Dummy = 0;                  // MiscKey1
}

#ifndef __NX__
int main(int argc, char** argv)
#else
extern "C" void nnMain()
#endif
{
    // Algorithms
    TestSimpleAlgorithms();
    TestBitshiftAlgorithms();

    // Structures
    TestLinkedLists();

    // Globals
    TestGlobals();

    // Language
    TestControlFlow();
    TestMutation();
    TestAliases();

    // Templates
    TestTemplates();

    // Misc
    TestShortCircuitEvaluation();

    // Note: Corrupt.natvis is a randomized file to ensure unparseable XML doesn't crash the system.
    //         Empty.natvis is similar, but ensures empty natvis files don't crash the system.
    //        Errors.natvis has valid XML, but the natvis types have errors.

#ifndef __NX__
    return 0;
#else
    return;
#endif
}
