﻿#pragma once

// Random class that is guaranteed to work in a deterministic way on any platform,
// given that all start with the same initial seed.
class deterministic_random
{
public:
    // Seed should be positive.
    deterministic_random( int32_t Seed )
    {
        // Seed of 0 causes same number to occur forever.
        if( Seed == 0 )
        {
            Seed = 1;
        }
        else if( Seed < 0 )
        {
            Seed = -Seed;
        }

        m_Seed = Seed;
    }

    int32_t RandomInt( int32_t Min, int32_t Max )
    {
        // Linear Congruential Generator
        const int32_t a = 16807;
        const int32_t m = 2147483647;
        const int32_t q = m / a;
        const int32_t r = m % a;

        m_Seed = a * (m_Seed % q) - r * (m_Seed / q);

        if( m_Seed <= 0 )
        {
            m_Seed += m;
        }

        return m_Seed % (Max - Min + 1) + Min;
    }

    char* RandomString( int32_t MinLength, int32_t MaxLength )
    {
        int32_t BufferSize = RandomInt( MinLength, MaxLength ) + 1; //Room for null terminator.
        char* Buffer = new char[BufferSize];

        Buffer[BufferSize - 1] = '\0';

        for( int i = 0; i < BufferSize - 1; ++i )
        {
            // Generate all characters except null terminator.
            Buffer[i] = (char)RandomInt( 1, 255 );
        }

        return Buffer;
    }

private:
    int32_t m_Seed;
};
