﻿//==============================================================================
// Test01:   Basic debugging over DLL load and unload
//    Uses DLLs named OMEGA and GAMMA.
//    Sequence of DLL usage:
//    Load OMEGA.
//    Unload OMEGA.
//    Load GAMMA.
//    Load OMEGA (again).
//    Unload GAMMA.
//    Unload OMEGA.
// Objectives:
//    Verify basic debugger functionality within a DLL.
//    Verify debugger handles DLL relocation.
// Tests for a DLL which is not yet loaded:
//    Breakpoints set into the DLL source will not bind.
//    Global variables in the DLL are not available.
// Tests for a DLL after it loads:
//    Breakpoints previously set in DLL source automatically bind.
//    Newly set breakpoints in DLL source will bind.
//    Global variables in the DLL are available.
// Tests for a DLL after it unloads:
//    Breakpoints previously set in DLL source automatically unbind.
//    Newly set breakpoints in DLL source will not bind.
//    Global variables in the DLL are not available.
// Perform all tests described above for both OMEGA and GAMMA before and after each sequence point described above.
//    Check to see if OMEGA uses a different base address the second time it loads.
//==============================================================================

#include "stdafx.h"
#include <nn/init.h>
#include <nn/os.h>
#include <nn/fs.h>
#include <nn/mem/mem_StandardAllocator.h>
#include "..\DLLCode\DLLCode.h"
#include "..\Common\Common.h"
#include "..\Phi\Phi.h"

//==============================================================================
// Forward declarations.
bool Test();

//==============================================================================

extern "C" void nnMain()
{
    //===========================================
    // Init system.
    Common_Init();

    dll_code* pPhiCode = new dll_code( "Phi" ); //DLLBreakpointKey01

    if( pPhiCode->Load() == true )
    {
        // Using macros here so that the call stack does not have an extra function added to
        // it, to more closely match other tests.
                                                                                               //SteppingSimpleTestAddrKey01
        Common_DLLReturnVoidMacro(pPhiCode, "InlineTest", TestDLL_ReturnVoidProc);             //SteppingSimpleTestAddrKey02

        Common_DLLReturnVoidMacro(pPhiCode, "Sub1", TestDLL_ReturnVoidProc);                   //SteppingSimpleTestAddrKey10

        Common_DLLReturnVoidMacro(pPhiCode, "RecurseTest", TestDLL_ReturnVoidIntArgProc, 5);   //SteppingSimpleTestAddrKey38

        Func();                                                                                //SteppingSimpleTestAddrKey45

        Common_DLLReturnVoidMacro(pPhiCode, "Func2", TestDLL_ReturnVoidProc);

        Common_DLLReturnVoidMacro(pPhiCode, "ComplexTemplateTest", TestDLL_ReturnVoidProc);   //SteppingSimpleTestAddrKey55

        Common_DLLReturnVoidMacro(pPhiCode, "ComplexLambdaTest", TestDLL_ReturnVoidProc);     //SteppingSimpleTestAddrKey56

        Common_DLLReturnVoidMacro(pPhiCode, "ComplexVirtualTest", TestDLL_ReturnVoidProc);    //SteppingSimpleTestAddrKey57

        pPhiCode->Unload();                                                                   //SteppingSimpleTestAddrKey53

        delete pPhiCode;
    }

    Common_Close();
}
